import celery
from api_dnl import settings
from datetime import datetime,timedelta
from dateutil.parser import parse as parse_datetime
from pytz import UTC
from time import mktime,sleep
import io,csv,gzip,zipfile
import xlwt,xlrd
import re
import json
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import Client,Client,Resource,Rate,RateTable,RateImportTask,RateUploadTask,RateUploadValues,RateSendLog,BalanceHistoryActual,C4ClientBalance,\
    RateSendLogDetail,CrdReportDetailTable,MailSender,FraudDetection,FraudDetectionLog,FraudDetectionLogDetail,\
    ResourceBlock,IngressTrunk,SystemParameter,AlertRule,AlertRuleLog,AlertRulesLogDetail,CdrReportDetail,client_cdr
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast,generate_uuid_str
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.scheme import RateScheme,BaseModelScheme
from api_dnl.utils.imp_exp import (csv2xls,dict_to_csv)



@app.task(base=SqlAlchemyTask)
def do_upload_rate():
    log.debug('Upload rate started')
#     sr = RateUploadTask.filter(RateUploadTask.pre_status == 'busy').first()
#     if sr:
#         i = app.control.inspect()
#         active=i.active()
#         log.debug('active tasks:{}'.format([v[0]['id'] for k,v in active.items() if len(v)]))
#         if not sr.task_id in [v[0]['id'] for k,v in active.items() if len(v)]:
#             log.info('Upload task uuid {} was not active!!!'.format(sr.task_id))
#             sr.progress = 'Celery task was broken'
#             sr.pre_status = 'error'
#             sr.status = 'error'
#             sr.save()
#             ws = None
#             try:
#                 ws = WSBrokerAPI()
#             except:
#                 ws = None
#             if ws:
#                 ws.set_task_id('upload_rate', id)
#                 ws.state('fail')
#         else:
#             log.debug('Upload rate {} already executed, skip'.format(sr.task_id))
#             return
#     sr = RateUploadTask.filter(and_(RateUploadTask.pre_status == 'preprocess', RateUploadTask.task_id.isnot(None))).first()
#     if sr:
#         if sr.start_time > int(datetime.now(UTC).timestamp() - 3600):
#             log.debug('Upload rate {} already scheduled, skip'.format(sr.task_id))
#             return
#         else:
#
#             sr.progress = 'Celery task was not started in one hour, revoke task'
#             sr.pre_status = 'error'
#             sr.status = 'error'
#             sr.save()
#             app.control.revoke(sr.task_id,terminate=True)
#     sr=RateUploadTask.filter(and_(RateUploadTask.pre_status=='preprocess',RateUploadTask.task_id.is_(None))).all()
#     log.debug('Upload rate waiting {}'.format(len(sr)))
#     if len(sr):
#         log.debug('Upload rate  id={} will start.'.format(sr[0].id))
#         ret=upload_rate.delay(id=sr[0].id)
#         sr[0].task_id=ret.id
#         sr[0].start_time=int(datetime.now(UTC).timestamp())
#         sr[0].save()

DATE_REGEXP={
'mm/dd/yyyy':r'^(0?[1-9]|1[012])/(0?[1-9]|[1-2][0-9]|3[01])/[12][09][0-9][0-9]$',
'yyyy-mm-dd':r'^[12][09][0-9][0-9]-(0?[1-9]|1[012])-(0?[1-9]|[1-2][0-9]|3[01])$',
'dd-mm-yyyy':r'^(0?[1-9]|1[012])-[12][09][0-9][0-9]-(0?[1-9]|[1-2][0-9]|3[01])$',
'dd/mm/yyyy':r'^(0?[1-9]|1[012])/[12][09][0-9][0-9]/(0?[1-9]|[1-2][0-9]|3[01])$',
'yyyy/mm/dd':r'^[12][09][0-9][0-9]/(0?[1-9]|1[012])/(0?[1-9]|[1-2][0-9]|3[01])$'
}

DATE_FMT={
'mm/dd/yyyy':'%m/%d/%Y',
'yyyy-mm-dd':'%Y-%m-%d',
'dd-mm-yyyy':'%d-%m-%Y',
'dd/mm/yyyy':'%d/%m/%Y',
'yyyy/mm/dd':'%Y/m/%d'
}

class MyReader():
    def __init__(self,file,start_from=0):
        if start_from == None:
            start_from = 0
        self.start_from=start_from
        self.format = file.split('.')[-1]
        self.datemode = None
        if self.format == 'csv':
            f=open(file,'rt')
            self._len=len(f.read().split('\n'))
            f.seek(0)
            self.csv=csv.DictReader(f,delimiter=',')
        else:
            try:
                wb=xlrd.open_workbook(file,formatting_info=True)
            except:
                wb = xlrd.open_workbook(file)
            self.datemode=wb.datemode
            self.xsl=wb.sheet_by_index(0)
            self._len = self.xsl.nrows


    @property
    def fieldnames(self):
        if self.format=='csv':
            self.keys = self.csv.fieldnames
            return self.keys
        else:
            self.keys=[self.xsl.cell(self.start_from, col_index).value for col_index in range(self.xsl.ncols)]
            return self.keys

    def len(self):
        return self._len

    def all(self):
        if self.format == 'csv':
            for item in self.csv:
                yield item
        else:
            for row_index in range(1, self.xsl.nrows):
                item = {self.keys[col_index]: self.xsl.cell(row_index, col_index).value
                         for col_index in range(self.xsl.ncols)}
                yield item

from api_dnl.utils.ws_broker_api import WSBrokerAPI

@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def upload_rate(id,force=True):
    slog = SchLog('upload_rate')
    log.debug('Upload rate log id={} sheduled.'.format(id))
    sr = RateUploadTask.get(id)
    #sr.pre_status = 'preprocess' #!!!!todo delete it!!!!
    #sr.save()
    ws = None
    try:
        ws = WSBrokerAPI()
    except:
        ws =None
    if ws:
        ws.set_task_id('upload_rate', id)
    if not sr:
        log.debug('Upload rate id={} sheduled. but not found'.format(id))
        return False
    if not force and sr.pre_status != 'preprocess':
        log.warning('Upload rate task id={} sheduled but already started! skip.'.format(id))
        return False
    try:
        sr.pre_status = 'busy'
        sr.progress = 'temporary busy '
        sr.save()
        log.debug('Upload rate task id={}'.format(id))
        rt = RateTable.get(sr.rate_table_id)
        if not rt:
            sr.pre_status = 'error'
            sr.progress = 'No rate_table_id {}'.format(sr.rate_table_id)
            sr.save()
            log.warning('Upload rate task id={} no rate_table_id'.format(id))
            if ws:
                ws.state('fail')
            return False
        if not sr.method:
            if rt.jur_type == 'A-Z':
                sr.method = 'delete'
            else:
                sr.method = 'ignore'


        objects_list = Rate.filter(Rate.rate_table_id==rt.rate_table_id).all()
        info=sr.info
        if not info:
            sr.pre_status = 'error'
            sr.progress = 'info field empty - can not start'
            sr.save()
            log.warning(sr.progress)
            if ws:
                ws.state('fail')
            return False
        if not 'fields' in info:
            info['fields']=dict(Code='Code',Rate='Rate', Effective_date='Effective_date',Min_time='Min_time',
                                Interval='Interval',Code_name='Code_name',Country='Country')
            if rt.jur_type == 'US Jurisdictional':
                info['fields']=dict(Code='Code',Rate='Rate', Effective_date='Effective_date',Min_time='Min_time',
                                    Interval='Interval',Code_name='Code_name',Country='Country',
                                    Inter_rate='Inter_rate', Intra_rate='Intra_rate', Local_rate='Local_rate')
        fhdrs = list(info['fields'].values())
        hdrs=list(info['fields'].keys())
        back =  dict((v, k) for k, v in info['fields'].items())
        num_fields = False
        if fhdrs[0].isdigit():
            num_fields=True
        flds = ('Code', 'Rate', 'Effective_date', 'Min_time', 'Interval', 'Code_name', 'Country')
        if rt.jur_type == 'US Jurisdictional':
            flds = ('Code', 'Rate','Inter_rate','Intra_rate','Local_rate','Effective_date', 'Min_time',
                    'Interval', 'Code_name', 'Country')

        class scheme_class(BaseModelScheme):
            class Meta:
                model = RateUploadValues
                fields = flds

        sr.upload_orig_file=sr.upload_orig_file.strip()
        format=sr.upload_orig_file.strip().split('.')[-1]
        if not format in ['csv','xls','xlsx']:
            sr.progress = 'Bad file format '
            sr.pre_status = 'error'
            sr.status = 'error'
            sr.save()
            if ws:
                ws.state('fail')
            return False
        if format in ['csv','xls','xlsx']:
            file = sr.orig_file
            if not 'start_from' in info:
                info['start_from']=0
            reader = MyReader(file,start_from=info['start_from'])#csv.DictReader(file,delimiter=',')
            fieldnames=reader.fieldnames
            key_found = 0
            for k in fieldnames:
                if k in back:
                    key_found += 1
            if key_found < 1:
                sr.progress = 'No key fields in file '
                sr.pre_status = 'error'
                sr.status = 'error'
                sr.save()
                if ws:
                    ws.state('fail')
                return False
            not_found = []
            for k in back.keys():
                if k not in fieldnames:
                    not_found.append(k)
            if len(not_found) and 'fields' in info:
                sr.progress = 'Fields mapped in "info" but no such fields in file: {} '.format(','.join(not_found))
                sr.pre_status = 'error'
                sr.status = 'error'
                sr.save()
                if ws:
                    ws.state('fail')
                return False
            if len(not_found):
                log.warning('Default fields not all in file: {} '.format(','.join(not_found)))
            RateUploadValues.filter(RateUploadValues.task_id == sr.id).delete(synchronize_session='fetch')
            i=0
            max_lines = reader.len()
            sr_values = []
            sr_values_keys = set()

            for _item in reader.all():
                if i % 10 == 0:
                    if ws:
                        ws.notify(100*i/(max_lines*1.5))
                i+=1
                item={}
                k=0
                for key in fieldnames:
                    if num_fields:
                        key=k
                    if key in back:
                        if _item[key]=='':
                            _item[key]=None
                        item[back[key]]=_item[key]
                    k=k+1

                if info['start_from']:
                    if i - 1 < info['start_from']:
                        continue
                if item['Code']==info['fields']['Code'] and item['Rate']==info['fields']['Rate']:
                    continue
                if item['Code']==None:
                    break
                if type(item['Rate'])==type(''):
                    item['Rate']=item['Rate'].replace(',','.')
                if type(item['Code']) != type(''):
                    item['Code']=str(int(item['Code']))
                if (not 'Country' in item) or item['Country'] == '' or item['Country'] is None:
                    if sr.rate_table_code_deck_id:
                        country_q=model.Code.filter(and_(model.Code.code_deck_id==sr.rate_table_code_deck_id,
                                                         text_("code @> '{}'".format(item['Code'])))).first()
                        if country_q:
                            item['Country']=country_q.country
                            item['Code_name']=country_q.name
                if 'effective_date_default' in info and info['effective_date_default']:
                    item['Effective_date'] = info['effective_date_default']
                else:
                    if 'Effective_date' in item:
                        if type(item['Effective_date']) != type(''):
                            if format != 'csv':
                                item['Effective_date']=xlrd.xldate_as_datetime(item['Effective_date'],reader.datemode).strftime(DATE_FMT[sr.rate_date_format])
                #del item['foo']
                rec = RateUploadValues(**item)

                codes=None
                if ',' in rec.Code:
                    codes=rec.Code.split(',')
                elif ';' in rec.Code:
                    codes=rec.Code.split(';')
                else:
                    codes = [rec.Code]
                for code in codes:
                    i = i + 1
                    rec = RateUploadValues(**item)
                    rec.Code = code
                    if 'prefix_default' in info:
                        rec.Code = info['prefix_default'] + rec.Code
                    if 'time_intervals' in info:
                        for intr in info['time_intervals']:
                            if 'code' not in intr or intr['code']==None or intr['code']==rec.Code[0:len(intr['code'])]:
                                rec.Min_time = intr['min_time']
                                rec.Interval=intr['interval']
                                if 'code' in intr and intr['code']!=None and intr['code']==rec.Code[0:len(intr['code'])]:
                                    break

                    if '.' in rec.Effective_date:
                        if '-' in sr.rate_date_format:
                            rec.Effective_date.replace('.', '-')
                        if '/' in sr.rate_date_format:
                            rec.Effective_date.replace('.', '/')
                    if not sr.rate_date_format:
                        sr.rate_date_format='yyyy-mm-dd'
                    if not re.match(DATE_REGEXP[sr.rate_date_format],rec.Effective_date):
                        if True:
                            try:
                                dayfirst=False
                                if sr.rate_date_format in ('dd-mm-yyyy','dd/mm/yyyy'):
                                    dayfirst = True
                                d = parse_datetime(rec.Effective_date,dayfirst=dayfirst)
                                rec.Effective_date=d.strftime(DATE_FMT[sr.rate_date_format])
                            except:
                                raise Exception('Rate upload row {}. Bad date value format is:{} value is:{}'.format(i,sr.rate_date_format,rec.Effective_date))
                        else:
                            raise Exception('Rate upload row {}. Bad date value format is:{} value is:{}'.format(i,
                                                                                                                 sr.rate_date_format,
                                                                                                                 rec.Effective_date))
                    rec.Effective_date = rec.Effective_date[0:10]
                    #q = sr.values.filter(and_(RateUploadValues.Code == rec.Code,RateUploadValues.Effective_date == rec.Effective_date)).first()
                    key = rec.Effective_date+' '+rec.Code
                    if key in sr_values_keys:
                        log.warning('skip key duplicate {}'.format(key))
                        continue
                    sr_values_keys.add(key)

                    ##sr.values.append(rec)
                    sr_values.append(rec)
                    ##rec.save()
                    if i % 512 == 1:
                        sr.progress = 'temporary busy count:{}'.format(i)
                        sr.save()

                stp=False
                if stp:
                    break
            sr.save()
            ##objects_list = sr.values.order_by(RateUploadValues.Code)
            objects_list = sr_values
            objects_list.sort(key=lambda i:i.Code)
            data = scheme_class().dump(objects_list, many=True).data
            sr.upload_format_file='_'+sr.upload_orig_file.split('.')[0]+'.csv'
            csvfile = open(sr.upload_file_path+'/'+sr.upload_format_file,'wt')
            writer = csv.DictWriter(csvfile, fieldnames=flds)
            writer.writeheader()
            writer.writerows(data)
            csvfile.close()
            sleep(1)
            #RateUploadValues.filter(RateUploadValues.task_id == sr.id).delete(synchronize_session='fetch')
            sr.progress = 'converted '
            sr.pre_status = 'converted'
            sr.status = 'finished'
            sr_new = sr.create_import_task()
            id_new = sr_new.save()
            sr.import_task_id=id_new
            sr.save()
            i=70
            while sr_new.status not in ('Upload successful','Upload failed'):
                if ws:
                    ws.notify(i, 'run backend')
                i = i+1
                if i == 99:
                    i = 70
                sleep(5)
                RateUploadTask.session().expire(sr_new)
                RateUploadTask.session().refresh(sr_new)
                sr_new = RateImportTask.get(id_new)
            if sr_new.status == 'Upload successful':
                if ws:
                    ws.notify(100, 'success')
            else:
                if ws:
                    ws.notify(100, 'fail')
            if sr.rule_log_id:
                if sr_new.status == 'Upload successful':
                    sr.rule_log.error = 'task id {} finished successfully'.format(sr.id)
                    sr.rule_log.status = 'upload success'
                else:
                    sr.status = 'error'
                    sr.rule_log.error = 'error in backend, see log for task id={}'.format(sr.id)
                    sr.rule_log.status = 'upload error'
                sr.rule_log.finish=datetime.now(UTC)
                sr.rule_log.save()
            return True
    except Exception as e:
        if ws:
            ws.notify(100, 'fail')

        sr.pre_status = 'error'
        try:
            db.session.rollback()
            for v in sr.values:
                sr.values.remove(v)
            #sr.values.clear()
            db.session.commit()
            sr.pre_status = 'error'
            sr.progress='row:{} error:{}'.format(i,str(e)[0:180])
            sr.save()
            if sr.rule_log_id:
                sr.rule_log.error = 'error job, see log for task id={}'.format(sr.id)
                sr.rule_log.status = 'upload error'
                sr.rule_log.finish = datetime.now(UTC)
                sr.rule_log.save()
            log.error('Upload rate id={} error={}'.format(id, str(e)))
            slog.close()

        except Exception as e:
            log.error('Upload rate id={} fatal error={}'.format(id,str(e)))
            #db.session.rollback()
        return False
    slog.close()
    return True
