from falcon_rest.schemes import BaseModelScheme, Schema, fields, validate
from falcon_rest.resources.resources import Resource, DEFAULT_SECURITY
from falcon_rest.responses import SuccessResponse, SuccessResponseJustOk, OperationErrorResponse, \
    SuccessResponseObjectInfo, UnAuthorizedErrorResponse
from falcon_rest.logger import log
import falcon, json
import configparser
from api_dnl.settings import API_INI
import jwt
from api_dnl import settings
from urllib.parse import urlparse
import os


class DbConfig(object):
    def __init__(self, host='127.0.0.1', port='5432', user='user', password='password', dbname='dbname'):
        self.host = host
        self.port = port
        self.user = user
        self.password = password
        self.dbname = dbname

    def from_conn_string(self, str):
        self.dbname = str.split('/')[3]
        mid = str.split('/')[2].split(':')
        if len(mid)<3:
            self.user = mid[0].split('@')[0]
            self.port = mid[1]
            self.password = ''
            self.host = mid[0].split('@')[1]
        else:
            self.user = mid[0]
            self.port = mid[2]
            self.password = '*' * len(mid[1].split('@')[0])
            self.host = mid[1].split('@')[1]

    @property
    def db_conn_string(self):
        return 'postgresql://{}{}@{}:{}/{}'.format(self.user, ':'+self.password if self.password else '', self.host, self.port, self.dbname)

    @staticmethod
    def get():
        ret = DbConfig()
        return ret


class DbConfigInnerScheme(BaseModelScheme):
    host = fields.Str()
    port = fields.Str()
    user = fields.Str()
    password = fields.Str()
    dbname = fields.Str()


class DbConfigScheme(BaseModelScheme):
    db = fields.Nested(DbConfigInnerScheme)
    db_ext = fields.Nested(DbConfigInnerScheme)


class DbConfigResource(Resource):
    scheme_class = DbConfigScheme
    scheme_class_get = DbConfigScheme
    entity = 'DbConfig'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = False
    no_auth_needed = True
    config_item = 'db_conn_string'

    def check_user(self, req, resp):
        return True

    def on_get(self, req, resp, **kwargs):
        db = DbConfig.get()
        log.debug('config_db {}'.format(db))
        db_ext = DbConfig.get()
        config = configparser.ConfigParser()
        log.debug('config_db ext {}'.format(db_ext))
        try:
            log.debug('config_db read API_INI {}'.format(API_INI))
            config.read(API_INI)
            db.from_conn_string(config['DEFAULT']['db_conn_string'])
            log.debug('config_db db_conn_string {}'.format(config['DEFAULT']['db_conn_string']))
            db_ext.from_conn_string(config['DEFAULT']['db_conn_string_ext'])
            log.debug('config_db db_conn_string_ext {}'.format(config['DEFAULT']['db_conn_string_ext']))
            data = dict(db=db.__dict__, db_ext=db_ext.__dict__)
            log.debug(data)
            self.set_response(resp, SuccessResponseObjectInfo(data=data))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(str(e)))

    def on_patch(self, req, resp, **kwargs):
        token = req.headers['X-AUTH-TOKEN']
        token_data = jwt.decode(token, settings.JWT_SIGNATURE)
        if token_data['user_id'] != 1:
            self.set_response(resp, UnAuthorizedErrorResponse(data='access denied'))
            return
        config = configparser.ConfigParser()
        try:
            config.read(API_INI)
        except:
            config['DEFAULT'] = {self.config_item: ''}
            pass
        try:
            db = DbConfig()
            db_ext = DbConfig()
            if 'db' in req.data:
                db = DbConfig(**req.data['db'])
                config['DEFAULT']['db_conn_string'] = db.db_conn_string
            if 'db_ext' in req.data:
                db_ext = DbConfig(**req.data['db_ext'])
                config['DEFAULT']['db_conn_string_ext'] = db_ext.db_conn_string

            with open('api.ini', 'w') as configfile:
                config.write(configfile)
            config.read(API_INI)

            db.from_conn_string(config['DEFAULT']['db_conn_string'])
            db_ext.from_conn_string(config['DEFAULT']['db_conn_string_ext'])
            data = dict(db=db.__dict__, db_ext=db_ext.__dict__)
            self.set_response(resp, SuccessResponseObjectInfo(data=data))

            log.debug("SHELL: ps aux | grep api_dnl_run | awk '{ print $2 }' | xargs kill -HUP")
            os.system(" ( sleep 3 && ps aux | grep api_dnl_run | awk '{ print $2 }' | xargs kill -HUP) &")
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(data=str(e)))


class RtConfigScheme(BaseModelScheme):
    url = fields.URL(default='http://localhost')
    auth_port = fields.Int(validate=validate.Range(1000, 65535), default=8887)
    sync_port = fields.Int(validate=validate.Range(1000, 65535), default=8888)
    async_port = fields.Int(validate=validate.Range(1000, 65535), default=8889)
    ftp_port = fields.Int(validate=validate.Range(1000, 65535), default=8892)
    qos_port = fields.Int(validate=validate.Range(1000, 65535), default=8891)
    aggregation_port = fields.Int(validate=validate.Range(1000, 65535), default=8890)


class RtConfigResource(Resource):
    scheme_class = RtConfigScheme
    scheme_class_get = RtConfigScheme
    entity = 'RtConfig'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = False

    def on_get(self, req, resp, **kwargs):
        try:
            stat = settings.STATISTIC
            if stat:
                data = dict(url='http://{}'.format(stat.get('host', 'localhost')),
                            auth_port=int(stat.get('auth_port', '8887')),
                            sync_port=int(stat.get('cdr_port', '8888')),
                            async_port=int(stat.get('async_port', '8889')),
                            aggregation_port=int(stat.get('port', '8890')),
                            qos_port=int(stat.get('qos_port', '8891')),
                            ftp_port=int(stat.get('ftp_port', '8892')),


                            )
            self.set_response(resp, SuccessResponseObjectInfo(data=data))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(str(e)))

    def on_patch(self, req, resp, **kwargs):

        token = req.headers['X-AUTH-TOKEN']
        token_data = jwt.decode(token, settings.JWT_SIGNATURE)
        if token_data['user_id'] != 1:
            self.set_response(resp, UnAuthorizedErrorResponse(data='access denied'))
            return
        config = configparser.ConfigParser()
        try:
            config.read(API_INI)
        except:
            if not 'STATISTIC' in config:
                config.add_section('STATISTIC')
            pass
        try:
            data = req.data
            if 'url' in data:
                p = urlparse(data['url'])
                config['STATISTIC']['host'] = p.netloc
                config['STATISTIC']['cdr_host'] = p.netloc
                config['STATISTIC']['cdr_async_host'] = p.netloc
                config['STATISTIC']['auth_host'] = p.netloc
                config['STATISTIC']['qos_host'] = p.netloc
                config['STATISTIC']['async_host'] = p.netloc
            config['STATISTIC']['auth_port'] = str(data.get('auth_port', '8887'))
            config['STATISTIC']['cdr_port'] = str(data.get('sync_port', '8888'))
            config['STATISTIC']['async_port'] = str(data.get('async_port', '8889'))
            config['STATISTIC']['port'] = str(data.get('aggregation_port', '8890'))
            config['STATISTIC']['qos_port'] = str(data.get('qos_port', '8891'))
            config['STATISTIC']['ftp_port'] = str(data.get('ftp_port', '8892'))


            with open(API_INI, 'w') as configfile:
                config.write(configfile)

            log.debug("SHELL: ps aux | grep api_dnl_run | awk '{ print $2 }' | xargs kill -HUP")
            os.system(" ( sleep 3 && ps aux | grep api_dnl_run | awk '{ print $2 }' | xargs kill -HUP) &")
            config.read(API_INI)
            self.set_response(resp, SuccessResponseObjectInfo(data=data))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(data=str(e)))
