"""Fix permissions

Revision ID: 1107d03f17f8
Revises: 4613fb5b57e8
Create Date: 2025-06-02 19:19:34.304534

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os


# revision identifiers, used by Alembic.
revision = '1107d03f17f8'
down_revision = '4613fb5b57e8'
branch_labels = None
depends_on = None


def upgrade():
    upgrade_sql = """
BEGIN;

ALTER DEFAULT PRIVILEGES FOR ROLE class4_user IN SCHEMA public GRANT SELECT, INSERT, UPDATE, DELETE ON TABLES TO webbackend;
ALTER DEFAULT PRIVILEGES FOR ROLE class4_user IN SCHEMA public GRANT USAGE ON SEQUENCES TO webbackend;

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.agent_client_client_record TO webbackend;
GRANT USAGE ON SEQUENCE public.agent_client_client_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.allowed_sendto_ip_record TO webbackend;
GRANT USAGE ON SEQUENCE public.allowed_sendto_ip_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.banned_ip_record TO webbackend;
GRANT USAGE ON SEQUENCE public.banned_ip_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_livecall_user_record TO webbackend;
GRANT USAGE ON SEQUENCE public.c4_livecall_user_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_lrn_record TO webbackend;
GRANT USAGE ON SEQUENCE public.c4_lrn_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_shaken_conf_record TO webbackend;
GRANT USAGE ON SEQUENCE public.c4_shaken_conf_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_shaken_status_record TO webbackend;
GRANT USAGE ON SEQUENCE public.c4_shaken_status_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4db_version TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_record TO webbackend;
GRANT USAGE ON SEQUENCE public.client_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.code_record TO webbackend;
GRANT USAGE ON SEQUENCE public.code_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.currency_record TO webbackend;
GRANT USAGE ON SEQUENCE public.currency_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.currency_updates_record TO webbackend;
GRANT USAGE ON SEQUENCE public.currency_updates_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_billing_plan_record TO webbackend;
GRANT USAGE ON SEQUENCE public.did_billing_plan_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_billing_rel_record TO webbackend;
GRANT USAGE ON SEQUENCE public.did_billing_rel_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_items_record TO webbackend;
GRANT USAGE ON SEQUENCE public.dynamic_route_items_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_override_record TO webbackend;
GRANT USAGE ON SEQUENCE public.dynamic_route_override_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_pri_record TO webbackend;
GRANT USAGE ON SEQUENCE public.dynamic_route_pri_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_qos_record TO webbackend;
GRANT USAGE ON SEQUENCE public.dynamic_route_qos_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_record TO webbackend;
GRANT USAGE ON SEQUENCE public.dynamic_route_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.egress_profile_record TO webbackend;
GRANT USAGE ON SEQUENCE public.egress_profile_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.global_route_error_record TO webbackend;
GRANT USAGE ON SEQUENCE public.global_route_error_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.jurisdiction_prefix_record TO webbackend;
GRANT USAGE ON SEQUENCE public.jurisdiction_prefix_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ocn_blocklist_record TO webbackend;
GRANT USAGE ON SEQUENCE public.ocn_blocklist_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.origination_global_failover_record TO webbackend;
GRANT USAGE ON SEQUENCE public.origination_global_failover_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.partition_gateway_ref_record TO webbackend;
GRANT USAGE ON SEQUENCE public.partition_gateway_ref_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.payment_term_record TO webbackend;
GRANT USAGE ON SEQUENCE public.payment_term_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_items_record TO webbackend;
GRANT USAGE ON SEQUENCE public.product_items_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_items_resource_record TO webbackend;
GRANT USAGE ON SEQUENCE public.product_items_resource_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_record TO webbackend;
GRANT USAGE ON SEQUENCE public.product_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_rout_rate_table_record TO webbackend;
GRANT USAGE ON SEQUENCE public.product_rout_rate_table_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.random_ani_generation_record TO webbackend;
GRANT USAGE ON SEQUENCE public.random_ani_generation_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.random_ani_group_record TO webbackend;
GRANT USAGE ON SEQUENCE public.random_ani_group_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_record TO webbackend;
GRANT USAGE ON SEQUENCE public.rate_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_table_record TO webbackend;
GRANT USAGE ON SEQUENCE public.rate_table_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_type_override_record TO webbackend;
GRANT USAGE ON SEQUENCE public.rate_type_override_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_block_items_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_block_items_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_block_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_block_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_capacity_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_capacity_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_codecs_ref_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_codecs_ref_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_direction_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_direction_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_ip_limit_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_ip_limit_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_ip_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_ip_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_lrn_action_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_lrn_action_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_next_route_rule_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_next_route_rule_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_prefix_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_prefix_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_replace_action_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_replace_action_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_translation_ref_record TO webbackend;
GRANT USAGE ON SEQUENCE public.resource_translation_ref_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.route_record TO webbackend;
GRANT USAGE ON SEQUENCE public.route_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.service_charge_items_record TO webbackend;
GRANT USAGE ON SEQUENCE public.service_charge_items_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_list_record TO webbackend;
GRANT USAGE ON SEQUENCE public.shaken_ani_group_list_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_list_rel_record TO webbackend;
GRANT USAGE ON SEQUENCE public.shaken_ani_group_list_rel_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_rel_record TO webbackend;
GRANT USAGE ON SEQUENCE public.shaken_ani_group_rel_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_sti_sp_conf_record TO webbackend;
GRANT USAGE ON SEQUENCE public.shaken_sti_sp_conf_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.sip_404_number_record TO webbackend;
GRANT USAGE ON SEQUENCE public.sip_404_number_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.sip_error_code_record TO webbackend;
GRANT USAGE ON SEQUENCE public.sip_error_code_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.spam_traffic_ip_record TO webbackend;
GRANT USAGE ON SEQUENCE public.spam_traffic_ip_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.switch_profile_record TO webbackend;
GRANT USAGE ON SEQUENCE public.switch_profile_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.termination_global_failover_record TO webbackend;
GRANT USAGE ON SEQUENCE public.termination_global_failover_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.time_profile_record TO webbackend;
GRANT USAGE ON SEQUENCE public.time_profile_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.transaction_fee_items_record TO webbackend;
GRANT USAGE ON SEQUENCE public.transaction_fee_items_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.translation_item_record TO webbackend;
GRANT USAGE ON SEQUENCE public.translation_item_record_record_id_seq TO webbackend;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.voip_gateway_record TO webbackend;
GRANT USAGE ON SEQUENCE public.voip_gateway_record_record_id_seq TO webbackend;

END;
"""
    connection = op.get_bind()
    connection.execute(upgrade_sql)


def downgrade():
    # Arch users don't downgrade
    pass


"""
ADDONS
"""
def up_rec(table):
    """
    Update {table}_record schema
    """

    up_rec_sql = """
DO $do$
DECLARE
    rec_id INT := 1;
BEGIN
    -- Check if table exists
    IF NOT EXISTS (SELECT 0 FROM pg_tables WHERE tablename = '{table}') THEN
        RAISE WARNING 'Table {table} does not exist';
    ELSE
        -- Get last record_id
        SELECT record_id FROM {table}_record ORDER BY record_id DESC LIMIT 1
        INTO rec_id;
        -- Delete existing table
        DROP TRIGGER IF EXISTS class4_trig_record_{table} ON {table};
        DROP FUNCTION IF EXISTS class4_trigfun_record_{table};
        DROP TABLE IF EXISTS {table}_record;
        DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
    END IF;

    -- Create new table
    CREATE TABLE {table}_record (LIKE {table},
    "time" integer, flag character(1), record_id SERIAL PRIMARY KEY);
    ALTER TABLE {table}_record OWNER TO class4_user;
    CREATE INDEX IF NOT EXISTS {table}_record_time_idx
    ON {table}_record USING btree ("time");
    EXECUTE format(E'SELECT setval(\\'{table}_record_record_id_seq\\', %%L)',
    rec_id);

    -- Trigger
    CREATE FUNCTION class4_trigfun_record_{table}() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;
    ALTER FUNCTION class4_trigfun_record_{table}() OWNER TO class4_user;
    CREATE TRIGGER class4_trig_record_{table} AFTER INSERT OR DELETE OR UPDATE
    ON {table} FOR EACH ROW EXECUTE PROCEDURE class4_trigfun_record_{table}();
END $do$;
"""
    connection = op.get_bind()
    connection.execute(up_rec_sql.format_map(dict(table=table)))
