"""did_billing_plan min_time

Revision ID: 50da2c915ca6
Revises: 85e1c8595bb6
Create Date: 2020-01-20 17:25:13.043811

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '50da2c915ca6'
down_revision = '85e1c8595bb6'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    connection = op.get_bind()
    row = connection.execute("select * from pg_tables where tablename='did_mrc_info'")
    if not row or len(row.fetchall()) == 0:
        op.create_table('did_mrc_info',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('invoice_number', sa.Integer(), nullable=True),
        sa.Column('client_id', sa.Integer(), nullable=False),
        sa.Column('did_number', sa.String(length=64), nullable=False),
        sa.Column('rent', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False),
        sa.Column('start_date', sa.Date(), nullable=True),
        sa.Column('end_date', sa.Date(), nullable=True),
        sa.PrimaryKeyConstraint('id')
        )
        op.create_index(op.f('ix_did_mrc_info_client_id'), 'did_mrc_info', ['client_id'], unique=False)
        op.create_index(op.f('ix_did_mrc_info_did_number'), 'did_mrc_info', ['did_number'], unique=False)
        op.create_index(op.f('ix_did_mrc_info_invoice_number'), 'did_mrc_info', ['invoice_number'], unique=False)

    op.add_column('did_billing_plan', sa.Column('interval', sa.Integer(), nullable=True))
    op.add_column('did_billing_plan', sa.Column('min_time', sa.Integer(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('did_billing_plan', 'min_time')
    op.drop_column('did_billing_plan', 'interval')
    op.drop_index(op.f('ix_did_mrc_info_invoice_number'), table_name='did_mrc_info')
    op.drop_index(op.f('ix_did_mrc_info_did_number'), table_name='did_mrc_info')
    op.drop_index(op.f('ix_did_mrc_info_client_id'), table_name='did_mrc_info')
    op.drop_table('did_mrc_info')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))