"""CLAS6-1742 schema

Revision ID: d764f79ad418
Revises: 663ede0dbc93
Create Date: 2017-10-13 21:43:29.207767

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'd764f79ad418'
down_revision = '663ede0dbc93'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('alert_rules_log', sa.Column('time', falcon_rest.db.fields.numeric.Numeric(), server_default=sa.text('EXTRACT(EPOCH from current_timestamp(0))'), nullable=True))
    op.create_index(op.f('ix_alert_rules_log_time'), 'alert_rules_log', ['time'], unique=False)
    op.add_column('alert_rules_log_detail', sa.Column('time', falcon_rest.db.fields.numeric.Numeric(), server_default=sa.text('EXTRACT(EPOCH from current_timestamp(0))'), nullable=True))
    op.create_index(op.f('ix_alert_rules_log_detail_time'), 'alert_rules_log_detail', ['time'], unique=False)
    op.add_column('cdr_report_detail', sa.Column('egress_no_ring', sa.Integer(), nullable=True))
    op.add_column('qos_route_report', sa.Column('call_duration', sa.Integer(), nullable=True))
    op.add_column('qos_total', sa.Column('egress_channels', sa.Integer(), nullable=True))
    op.add_column('resource', sa.Column('ani_cap_limit', sa.Integer(), nullable=True))
    op.add_column('resource', sa.Column('ani_cps_limit', sa.Integer(), nullable=True))
    op.add_column('resource', sa.Column('dnis_cap_limit', sa.Integer(), nullable=True))
    op.add_column('resource', sa.Column('dnis_cps_limit', sa.Integer(), nullable=True))
    op.add_column('spam_traffic_ip', sa.Column('netmask', sa.Integer(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('spam_traffic_ip', 'netmask')
    op.drop_column('resource', 'dnis_cps_limit')
    op.drop_column('resource', 'dnis_cap_limit')
    op.drop_column('resource', 'ani_cps_limit')
    op.drop_column('resource', 'ani_cap_limit')
    op.drop_column('qos_total', 'egress_channels')
    op.drop_column('qos_route_report', 'call_duration')
    op.drop_column('cdr_report_detail', 'egress_no_ring')
    op.drop_index(op.f('ix_alert_rules_log_detail_time'), table_name='alert_rules_log_detail')
    op.drop_column('alert_rules_log_detail', 'time')
    op.drop_index(op.f('ix_alert_rules_log_time'), table_name='alert_rules_log')
    op.drop_column('alert_rules_log', 'time')
    # ### end Alembic commands ###
