"""did_vendor

Revision ID: eb111b687776
Revises: 936a530db264
Create Date: 2019-03-22 20:56:10.030346

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'eb111b687776'
down_revision = '936a530db264'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_vendor',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('type', sa.SmallInteger(), server_default='1', nullable=True),
    sa.Column('username', sa.String(length=64), nullable=True),
    sa.Column('password', sa.String(length=64), nullable=True),
    sa.Column('sms_enabled', sa.Boolean(), nullable=True),
    sa.Column('rate_per_sms_sent', falcon_rest.db.fields.numeric.Numeric(length=15, collation=6), nullable=True),
    sa.Column('rate_per_sms_received', falcon_rest.db.fields.numeric.Numeric(length=15, collation=6), nullable=True),
    sa.Column('default_received_sms_url', sa.Text(), nullable=True),
    sa.Column('mrc', sa.String(length=10), nullable=True),
    sa.Column('nrc', sa.String(length=10), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('did',
    sa.Column('did', sa.String(length=16), nullable=False),
    sa.Column('type', sa.SmallInteger(), server_default='1', nullable=True),
    sa.Column('client_id', sa.Integer(), nullable=True),
    sa.Column('vendor_id', sa.Integer(), nullable=True),
    sa.Column('created_on', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['vendor_id'], ['did_vendor.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('did')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('did')
    op.drop_table('did_vendor')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))