# coding: utf-8
from sqlalchemy import Boolean, CheckConstraint, Column, DateTime, ForeignKey, Integer, String, Text, JSON, text,func
from sqlalchemy.orm import relationship, foreign
from falcon_rest.db.orm import generate_uuid_str
from sqlalchemy.ext.declarative import declarative_base
from api_dnl.base_model import DnlApiBaseModel as Base
from api_dnl import settings
#Base = declarative_base()
metadata = Base.metadata

class DnlCloudDownloaderCfg(Base):
    __tablename__ = 'dnl_cloud_downloader_cfg'
    __table_args__ = (
        CheckConstraint('((server_ip_whitelist IS NOT NULL) AND (server_ip_blacklist IS NOT NULL)) IS FALSE'),
        CheckConstraint("(log_level >= '-1'::integer) AND (log_level < 3)"),
        CheckConstraint('(server_port > 0) AND (server_port < 65536)'),
        CheckConstraint('server_con_limit > 0'),
        CheckConstraint('server_con_timeout > 0'),
        CheckConstraint('server_per_ip_con_limit > 0')
    )

    #id = Column(Boolean, primary_key=True, server_default=text("true"))
    server_name = Column(String(256), primary_key=True, server_default=text("true"))
    server_use_ssl = Column(Boolean, server_default='false')
    server_ip = Column(String(16), server_default=text("NULL::character varying"))
    server_port = Column(Integer)
    server_ip_whitelist = Column(Text)
    server_ip_blacklist = Column(Text)
    server_con_limit = Column(Integer)
    server_per_ip_con_limit = Column(Integer)
    server_con_timeout = Column(Integer)
    log_level = Column(Integer, server_default=text("0"))
    log_dir_path = Column(Text)
    disable_logfile = Column(Boolean, server_default=text("false"))
    enable_postgresql_log = Column(Boolean, server_default=text("false"))
    tmp_dir_path = Column(Text)
    disable_tmp_dir = Column(Boolean, server_default=text("false"))


class DnlCloudLog(Base):
    __tablename__ = 'dnl_cloud_log'
    __table_args__ = (
        CheckConstraint("(btrim((instance)::text) = ''::text) IS FALSE"),
        CheckConstraint("(btrim((level)::text) = ''::text) IS FALSE")
    )

    id = Column(Integer, primary_key=True)#, server_default=text("nextval('dnl_cloud_log_id_seq'::regclass)"))
    time = Column(DateTime, nullable=False, server_default=text("now()"))
    server_name = Column(String(256), primary_key=True, server_default=text("true"))
    instance = Column(String(128), nullable=False)
    level = Column(String(16), nullable=False)
    msg = Column(Text, nullable=False)


class DnlCloudGcloudCfg(Base):
    __tablename__ = 'dnl_cloud_gcloud_cfg'
    __table_args__ = (
        CheckConstraint("(((type)::text = 'service'::text) AND ((btrim(key_file_path) = ''::text) IS FALSE)) OR (((type)::text = 'oauth2'::text) AND ((btrim(email) = ''::text) IS FALSE) AND ((btrim(secret) = ''::text) IS FALSE) AND ((btrim(token) = ''::text) IS FALSE))"),
        CheckConstraint("(btrim(bucket) = ''::text) IS FALSE"),
        CheckConstraint('(debug >= 0) AND (debug < 3)')
    )

    uuid = Column(String(36), ForeignKey('dnl_cloud_storages.uuid', ondelete='CASCADE'), primary_key=True)
    type = Column(String(16), nullable=False)
    bucket = Column(Text, nullable=False)
    workdir = Column(Text)
    key_file_path = Column(Text)
    json_key = Column(JSON)
    email = Column(Text)
    secret = Column(Text)
    token = Column(Text)
    debug = Column(Integer)
    storage = relationship('DnlCloudStorage', uselist=False, back_populates='gcloud')

    def delete(self, **kwargs):
        DnlCloudStorage.filter(DnlCloudStorage.uuid == self.uuid).delete(synchronize_session='fetch')
        ret = super().delete(**kwargs)
        return ret

    @property
    def json_download_url(self):
        if self.key_file_path and 'files/' in self.key_file_path:
            file_name = self.key_file_path.split('files/')[-1]
            return '{}{}/files/{}'.format(settings.API_SCHEME, settings.API_HOST,
                                                     file_name)
        return None

    @json_download_url.setter
    def json_download_url(self, value):
        pass

class DnlCloudSftpCfg(Base):
    __tablename__ = 'dnl_cloud_sftp_cfg'
    __table_args__ = (
        CheckConstraint("(((btrim(username) = ''::text) IS FALSE) AND ((btrim(password) = ''::text) IS FALSE)) OR ((username IS NULL) AND (password IS NULL) AND ((btrim(privkey_path) = ''::text) IS FALSE))"),
        CheckConstraint("(btrim((ip)::text) = ''::text) IS FALSE"),
        CheckConstraint('(debug >= 0) AND (debug < 3)'),
        CheckConstraint('(port > 0) AND (port < 65536)')
    )

    uuid = Column(ForeignKey('dnl_cloud_storages.uuid', ondelete='CASCADE'), primary_key=True)
    ip = Column(String(16), nullable=False)
    port = Column(Integer, nullable=False)
    username = Column(Text)
    password = Column(Text)
    workdir = Column(Text)
    pubkey_path = Column(Text)
    privkey_path = Column(Text)
    passphrase = Column(Text)
    debug = Column(Integer)
    storage = relationship('DnlCloudStorage', uselist=False, back_populates='sftp')

class DnlCloudFtpCfg(Base):
    __tablename__ = 'dnl_cloud_ftp_cfg'
    __table_args__ = (
        CheckConstraint("((btrim(username) = 'anonymous'::text) AND (password IS NULL)) OR (((btrim(username) = ''::text) IS FALSE) AND ((btrim(password) = ''::text) IS FALSE)) OR ((username IS NULL) AND (password IS NULL) AND ((btrim(netrc_path) = ''::text) IS FALSE))"),
        CheckConstraint("(btrim((ip)::text) = ''::text) IS FALSE"),
        CheckConstraint('(debug >= 0) AND (debug < 3)'),
        CheckConstraint('(port > 0) AND (port < 65536)')
    )

    uuid = Column(String(36), ForeignKey('dnl_cloud_storages.uuid', ondelete='CASCADE'), primary_key=True)
    ip = Column(String(16), nullable=False)
    port = Column(Integer, nullable=False)
    username = Column(Text)
    password = Column(Text)
    workdir = Column(Text)
    use_relative_paths = Column(Boolean, server_default=text("false"))
    netrc_path = Column(Text)
    debug = Column(Integer)
    storage = relationship('DnlCloudStorage', uselist=False, back_populates='ftp')

    def delete(self, **kwargs):
        DnlCloudStorage.filter(DnlCloudStorage.uuid == self.uuid).delete(synchronize_session='fetch')
        ret = super().delete(**kwargs)
        return ret


class DnlCloudDbmanCfg(Base):
    __tablename__ = 'dnl_cloud_dbman_cfg'
    __table_args__ = (
        CheckConstraint('((server_ip_whitelist IS NOT NULL) AND (server_ip_blacklist IS NOT NULL)) IS FALSE'),
        CheckConstraint("(log_level >= '-1'::integer) AND (log_level < 3)"),
        CheckConstraint('(server_port > 0) AND (server_port < 65536)'),
        CheckConstraint('(startup_delay >= 0) AND (startup_delay < 86400)'),
        CheckConstraint('keep_cdr > 0'),
        CheckConstraint('keep_cdr_archives > 0'),
        CheckConstraint('keep_cdr_remote > 0'),
        CheckConstraint('keep_pcap > 0'),
        CheckConstraint('keep_pcap_archives > 0'),
        CheckConstraint('keep_pcap_remote > 0'),
        CheckConstraint('server_con_limit > 0'),
        CheckConstraint('server_con_timeout > 0'),
        CheckConstraint('server_per_ip_con_limit > 0')
    )

    #id = Column(Boolean, primary_key=True, server_default=text("true"))
    server_name = Column(String(256), primary_key=True, server_default=text("true"))
    server_use_ssl = Column(Boolean, server_default='false')
    cdr_storage_cfg_uuid = Column(ForeignKey('dnl_cloud_storages.uuid'))
    pcap_storage_cfg_uuid = Column(ForeignKey('dnl_cloud_storages.uuid'))
    keep_cdr = Column(Integer)
    keep_pcap = Column(Integer)
    keep_cdr_archives = Column(Integer)
    keep_pcap_archives = Column(Integer)
    keep_cdr_remote = Column(Integer)
    keep_pcap_remote = Column(Integer)
    hourly_cdr_backup = Column(Boolean, nullable=False, server_default=text("false"))
    server_ip = Column(String(16), server_default=text("NULL::character varying"))
    server_port = Column(Integer)
    server_ip_whitelist = Column(Text)
    server_ip_blacklist = Column(Text)
    server_con_limit = Column(Integer)
    server_per_ip_con_limit = Column(Integer)
    server_con_timeout = Column(Integer)

    log_level = Column(Integer, server_default=text("0"))
    log_dir_path = Column(Text)
    disable_logfile = Column(Boolean, server_default=text("false"))
    enable_postgresql_log = Column(Boolean, server_default=text("false"))
    tmp_dir_path = Column(Text)
    disable_tmp_dir = Column(Boolean, server_default=text("false"))
    startup_delay = Column(Integer)
    run_on_start = Column(Boolean, nullable=False, server_default=text("false"))

    dnl_cloud_storage = relationship('DnlCloudStorage', primaryjoin='DnlCloudDbmanCfg.cdr_storage_cfg_uuid == DnlCloudStorage.uuid')
    dnl_cloud_storage1 = relationship('DnlCloudStorage', primaryjoin='DnlCloudDbmanCfg.pcap_storage_cfg_uuid == DnlCloudStorage.uuid')


class DnlCloudStorage(Base):
    __tablename__ = 'dnl_cloud_storages'
    __table_args__ = (
        CheckConstraint("((type)::text = 'ftp'::text) OR ((type)::text = 'sftp'::text) OR ((type)::text = 'gcloud'::text)"),
        CheckConstraint("(btrim(uuid) = ''::text) IS FALSE")
    )

    #uuid = Column(String(36), primary_key=True, server_default=func.uuid_generate_v4())
    uuid = Column(String(36), primary_key=True, default=generate_uuid_str())
    type = Column(String(16))
    gcloud = relationship('DnlCloudGcloudCfg',uselist=False,back_populates='storage', single_parent=True, cascade="all, delete-orphan", primaryjoin=foreign(DnlCloudGcloudCfg.uuid) == uuid)
    sftp = relationship('DnlCloudSftpCfg',uselist=False,back_populates='storage', single_parent=True, cascade="all, delete-orphan", primaryjoin=foreign(DnlCloudSftpCfg.uuid) == uuid)
    ftp = relationship('DnlCloudFtpCfg',uselist=False,back_populates='storage', single_parent=True, cascade="all, delete-orphan", primaryjoin=foreign(DnlCloudFtpCfg.uuid) == uuid)

    @property
    def _ftp(self):
        return self.ftp

    @_ftp.setter
    def _ftp(self, value):
        curr = self.ftp
        if curr:
            self.ftp = value
            if curr.uuid:
                curr.delete()
        self.ftp = value



class DnlCloudSearchCfg(Base):
    __tablename__ = 'dnl_cloud_search_cfg'
    __table_args__ = (
        CheckConstraint('((server_ip_whitelist IS NOT NULL) AND (server_ip_blacklist IS NOT NULL)) IS FALSE'),
        CheckConstraint("(log_level >= '-1'::integer) AND (log_level < 3)"),
        CheckConstraint('(server_port > 0) AND (server_port < 65536)'),
        CheckConstraint('pcap_time_margin >= 0'),
        CheckConstraint('req_exp_time >= 0'),
        CheckConstraint('server_con_limit > 0'),
        CheckConstraint('server_con_timeout > 0'),
        CheckConstraint('server_per_ip_con_limit > 0'),
        CheckConstraint('threads_max >= 0')
    )

    #id = Column(Boolean, primary_key=True, server_default=text("true"))
    server_name = Column(String(256), primary_key=True )
    server_use_ssl = Column(Boolean, server_default='false')
    pcap_time_margin = Column(Integer)
    req_exp_time = Column(Integer)
    threads_max = Column(Integer)
    server_ip = Column(String(16), server_default=text("NULL::character varying"))
    server_port = Column(Integer)
    server_ip_whitelist = Column(Text)
    server_ip_blacklist = Column(Text)
    server_con_limit = Column(Integer)
    server_per_ip_con_limit = Column(Integer)
    server_con_timeout = Column(Integer)
    log_level = Column(Integer, server_default=text("0"))
    log_dir_path = Column(Text)
    disable_logfile = Column(Boolean, server_default=text("false"))
    enable_postgresql_log = Column(Boolean, server_default=text("false"))
    tmp_dir_path = Column(Text)

class DnlCloudStatus(Base):
    __tablename__ = 'dnl_cloud_status'
    __table_args__ = (
                         CheckConstraint("(TRIM(server_ip) = '') IS FALSE"),
                         CheckConstraint('(server_port > 0) AND (server_port < 65536)'),
    )
    server_name = Column(String(256), primary_key=True, server_default=text("true"))
    instance = Column(String(128), primary_key=True)
    operation = Column(Text)
    is_online = Column(Boolean, server_default='false')
    upd_time = Column(DateTime, nullable=False, server_default=func.now())
    server_ip = Column(String(16), server_default=text("NULL::character varying"))
    server_port = Column(Integer)
    server_use_ssl = Column(Boolean, server_default='false')
    switch_list = Column(Text,server_default='NULL')
