import json
import sys
from datetime import date, datetime, timedelta
from decimal import *
from time import mktime
from pytz import UTC
from traceback import format_exc

from marshmallow import ValidationError
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint,
                        Integer, DateTime, func, cast, case)
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table, Interval, TIMESTAMP
)
from sqlalchemy.dialects import postgresql
from sqlalchemy.ext.hybrid import hybrid_property
from sqlalchemy.orm import backref, foreign, relationship, synonym, column_property
from sqlalchemy.orm.exc import NoResultFound
from sqlalchemy.sql import func, select

# from falcon_rest.db import Column
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.fields import ChoiceType, PrefixRange, Ip4, Ip4r
from api_dnl.models.mail import MailSender
from api_dnl.models.user import User
# from api_dnl.utils.statisticapi2 import IStatistic
from api_dnl.base_model import DnlApiBaseModel
from falcon_rest.db.fields import (Numeric)
from falcon_rest.db.orm import generate_uuid_str
from falcon_rest.logger import log


class ImportTargetLog(DnlApiBaseModel):
    __tablename__ = 'import_target_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('import_target_log_id_seq'::regclass)"))
    status = Column(Integer)
    client_id = Column(Integer)
    create_time = Column(DateTime)
    file_name = Column(String(256))
    file_path = Column(String(256))
    error_message = Column(String(256))


class JurisdictionUpdateLog(DnlApiBaseModel):
    __tablename__ = 'jurisdiction_update_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('jurisdiction_update_log_id_seq'::regclass)"))
    tigger_time = Column(DateTime(True))
    is_new_file = Column(Boolean)
    import_log_id = Column(Integer)
    file_update_time_flg = Column(String(10))
    status = Column(Integer)


class KillPgSqlLog(DnlApiBaseModel):
    __tablename__ = 'kill_pg_sql_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('kill_pg_sql_log_id_seq'::regclass)"))
    query = Column(Text)
    start_time = Column(DateTime(True))
    kill_time = Column(DateTime(True))


class MailCdrLog(DnlApiBaseModel):
    __tablename__ = 'mail_cdr_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('mail_cdr_log_id_seq'::regclass)"))
    start_time = Column(DateTime(True))
    cdr_counts = Column(Integer)
    user_id = Column(Integer)
    finish_time = Column(DateTime(True))
    cdr_start_time = Column(DateTime(True))
    cdr_end_time = Column(DateTime(True))
    file_counts = Column(Integer)
    mail_content = Column(Text)
    mail_subject = Column(String(500))
    status = Column(Integer)


class FtpServerLog(DnlApiBaseModel):
    __tablename__ = 'ftp_server_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('ftp_server_log_id_seq'::regclass)"))
    time = Column(DateTime(True))
    cmd = Column(Text)
    response = Column(Text)


class FtpCdrLog(DnlApiBaseModel):
    __tablename__ = 'ftp_cdr_log'
    STATUS = {0: 'initial', 1: 'in process', 2: 'finished', 3: 'error', 4: 'ftp in ptogress', 4: 'ftp finished',
              5: 'ftp error'}
    id = Column(Integer, primary_key=True, server_default=text_("nextval('ftp_cdr_log_id_seq'::regclass)"))
    ftp_start_time = Column(DateTime(True))
    ftp_end_time = Column(DateTime(True))
    status = Column(ChoiceType(STATUS))
    ftp_ip = Column(String(255))
    ftp_dir = Column(String)
    alias = Column(String(255))
    ftp_conf_id = Column(Integer)
    cdr_start_time = Column(DateTime(True))
    cdr_end_time = Column(DateTime(True))
    pid = Column(Integer)
    detail = Column(Text)

    client_alias = synonym('alias')
    result = relationship('FtpCdrLogDetail', uselist=True, back_populates='job',
                          single_parent=True,
                          cascade="all, delete-orphan")


class FtpCdrLogDetail(DnlApiBaseModel):
    __tablename__ = 'ftp_cdr_log_detail'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('ftp_cdr_log_detail_id_seq'::regclass)"))
    ftp_cdr_log_id = Column(ForeignKey('ftp_cdr_log.id', ondelete='CASCADE'), nullable=False)
    create_time = Column(DateTime(True))
    file_name = Column(String)
    ftp_ip = Column(String(255))
    ftp_dir = Column(String)
    detail = Column(Text)
    local_file_path = Column(String(500))

    ftp_post = synonym('detail')
    target = synonym('file_name')

    job = relationship(FtpCdrLog, uselist=False, back_populates='result')


class AuthorizationLog(DnlApiBaseModel):
    __tablename__ = 'authorization_logs'
    DIRECTION = {1: 'GET', 2: 'POST', 3: 'DELETE', 4: 'PATCH'}
    AUTH_TYPE = {1: 'pass', 2: 'key'}
    ERROR_TYPE = {0: 'success', 1: 'fail', 2: 'forbidden'}
    id = Column(Integer, primary_key=True)
    direction = Column(ChoiceType(DIRECTION))  # Column(Integer)
    auth_type = Column(ChoiceType(AUTH_TYPE))  # Column(Integer)
    error_type = Column(ChoiceType(ERROR_TYPE))  # Column(Integer)
    request_ip = Column(String(100))
    request_port = Column(Integer)
    username = Column(String(64))
    authname = Column(String(64))
    sip_callid = Column(String(128))
    time = Column(BigInteger)
    agent = Column(String(512))
    referer = Column(String(512))

    status = synonym('auth_type')
    login_ip = synonym('request_ip')
    failed_reason = synonym('error_type')
    entered_password = synonym('authname')

    # login_time= column_property(func.cast('epoch',TIMESTAMP(timezone=True)) + time*func.cast('1 second',Interval) )
    login_time = column_property(func.to_timestamp(time))

    # @hybrid_property
    # def login_time(self):
    #    try:
    #        return datetime.fromtimestamp(self.time)
    #    except:
    #        return None

    def set_time(self):
        self.time = datetime.now(UTC).timestamp()
        return self


class BalanceLog(DnlApiBaseModel):
    __tablename__ = 'balance_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('balance_log_id_seq'::regclass)"))
    client_id = Column(Integer, index=True)
    balance = Column(Numeric)
    date = Column(Date, index=True)
    client = relationship('Client', primaryjoin='foreign(BalanceLog.client_id)==Client.client_id', uselist=False)
    ingress_balance = Column(Numeric(30, 6), nullable=False, server_default=text_("0"))
    egress_balance = Column(Numeric(30, 6), nullable=False, server_default=text_("0"))


class BlockLog(DnlApiBaseModel):
    __tablename__ = 'block_log'

    log_id = Column(Integer, primary_key=True, server_default=text_("nextval('block_log_log_id_seq'::regclass)"))
    block_on = Column(DateTime(True))
    block_by = Column(String(100))
    code_detail = Column(String(500))
    re_enable_time = Column(DateTime(True))
    asr = Column(String(100))
    abr = Column(String(100))
    acd = Column(String(100))
    pdd = Column(String(100))
    margin = Column(String(100))
    re_enable = Column(Boolean)
    type = Column(SmallInteger, nullable=False)


class CreditLog(DnlApiBaseModel):
    __tablename__ = 'credit_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('credit_log_id_seq'::regclass)"))
    modified_by = Column(String(200))
    modified_from = Column(Numeric(30, 10))
    modified_to = Column(Numeric(30, 10))
    modified_on = Column(DateTime(True), server_default=func.now())
    carrier_name = Column(String(200))


class CdrExportLog(DnlApiBaseModel):
    __tablename__ = 'cdr_export_log'
    STATUS = {0: 'sucess', 1: 'fail', None: 'undefined'}
    id = Column(Integer, primary_key=True, server_default=text_("nextval('cdr_export_log_id_seq'::regclass)"))
    export_time = Column(DateTime(True))
    status = Column(ChoiceType(STATUS))
    file_name = Column(String(500))
    user_id = Column(Integer)
    is_dipp = Column(Boolean)
    backend_pid = Column(Integer)
    cdr_start_time = Column(DateTime(True))
    cdr_end_time = Column(DateTime(True))
    sql = Column(String)
    file_rows = Column(Integer)
    error_msg = Column(Text)
    send_mail = Column(String(200))
    where_sql = Column(String)
    show_fields_sql = Column(String)
    total_hours = Column(Integer)
    finished_hours = Column(Integer)
    stop_time = Column(DateTime(True))
    download_cdr_from = Column(String(200))
    download_cdr_subject = Column(Text)
    download_cdr_content = Column(Text)
    download_cdr_cc = Column(String(200))
    send_type = Column(Integer)
    total_date = Column(Integer)
    finished_date = Column(Integer)
    finished_time = Column(DateTime(True))
    file_size = Column(Integer)

    triggered_start_time = synonym('export_time')
    triggered_end_time = synonym('finished_time')
    number_of_rows = synonym('file_rows')

    user = relationship('User', primaryjoin='foreign(CdrExportLog.user_id)==User.user_id', uselist=False)

    progress = column_property(cast(100 * case([(total_hours == 0, 0)], else_=finished_hours / total_hours), Integer))

    @hybrid_property
    def user_name(self):
        try:
            return self.user.name
        except:
            return ''


class InvoiceCdrLog(DnlApiBaseModel):
    __tablename__ = 'invoice_cdr_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('invoice_cdr_log_id_seq'::regclass)"))
    start_time = Column(DateTime(True))
    end_time = Column(DateTime(True))
    type = Column(Integer)
    invoice_number = Column(String(255))
    carrier_name = Column(String(255))
    client_name = synonym('carrier_name')


class IpModifLog(DnlApiBaseModel):
    __tablename__ = 'ip_modif_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('ip_modif_log_id_seq'::regclass)"))
    modify = Column(Integer)
    detail = Column(String(100))
    update_at = Column(DateTime(True), server_default=text_("('now'::text)::timestamp(0) with time zone"))
    update_by = Column(String)
    trunk_id = Column(Integer)
    email = Column(String(100))
    old = Column(String(100))
    new = Column(String(100))

    trunk = relationship('Resource', primaryjoin='foreign(IpModifLog.trunk_id) == Resource.resource_id', uselist=False)

    @hybrid_property
    def carrier_name(self):
        try:
            return self.trunk.carrier
        except:
            return ''


class ModifLog(DnlApiBaseModel):
    __tablename__ = 'modif_log'
    TYPE = {0: 'Creation', 1: 'Deletion', 2: 'Modification'}

    id = Column(Integer, primary_key=True, server_default=text_("nextval('modif_log_id_seq'::regclass)"))
    time = Column(DateTime(True), server_default=text_("('now'::text)::timestamp(0) with time zone"))
    module = Column(String(100))
    type = Column(ChoiceType(TYPE))
    name = Column(String(100))
    detail = Column(String(200))
    rollback = Column(Text)
    rollback_msg = Column(String(500))
    rollback_flg = Column(SmallInteger)
    rollback_extra_info = Column(Text)


class LicenseModificationLog(DnlApiBaseModel):
    __tablename__ = '#license_modification_log'
    TYPE = {1: 'Self-Defined Cap Limit', 2: 'Self-Defined CPS Limit', 3: 'Initialize(Cap Limit)',
            4: 'Initialize(CPS Limit)'}
    id = Column(Integer, primary_key=True, server_default=text_("nextval('license_modification_log_id_seq'::regclass)"))
    modify_on = Column(DateTime(True), nullable=False,
                       server_default=text_("('now'::text)::timestamp(0) with time zone"))
    modify_by = Column(String(200))
    old_value = Column(Integer)
    new_value = Column(Integer)
    type = Column(ChoiceType(TYPE))
    switch_name = Column(String(200))


class OrigLog(DnlApiBaseModel):
    __tablename__ = 'orig_log'
    TYPE = {0: 'Creation', 1: 'Deletion', 2: 'Modification'}
    log_id = Column(Integer, primary_key=True, server_default=text_("nextval('orig_log_log_id_seq'::regclass)"))
    update_on = Column(DateTime(True), server_default=text_("('now'::text)::timestamp(0) with time zone"))
    update_by = Column(String(100))
    module = Column(String(100))
    type = Column(ChoiceType(TYPE))
    detail = Column(String(500))


class RateDownloadLog(DnlApiBaseModel):
    __tablename__ = 'rate_download_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('rate_download_log_id_seq'::regclass)"))
    resource_id = Column(Integer)
    file_path = Column(String)
    download_time = Column(DateTime(True))
    download_ip = Column(String)
    log_detail_id = Column(Integer)
    download_username = Column(String(100))

    resource = relationship('Resource', primaryjoin='foreign(RateDownloadLog.resource_id) == Resource.resource_id',
                            uselist=False)
    send_log = relationship('RateSendLogDetail',
                            primaryjoin='foreign(RateSendLogDetail.id) == RateDownloadLog.log_detail_id',
                            back_populates='download_log', uselist=False)


class RateMassEditLog(DnlApiBaseModel):
    __tablename__ = 'rate_mass_edit_log'
    ACTION_TYPE = {0: 'delete found rates',
                   1: 'insert as new rates',
                   2: 'update current rates',
                   3: 'update all rates',
                   4: 'update future rates with specific effective date',
                   5: 'delete future rates with specific effective date',
                   6: 'delete all rates',
                   7: 'delete all future rates'}
    id = Column(Integer, primary_key=True, server_default=text_("nextval('rate_mass_edit_log_id_seq'::regclass)"))
    action_time = Column(DateTime(True))
    client_id = Column(Integer)
    action_type = Column(ChoiceType(ACTION_TYPE))
    down_file_path = Column(Text)
    rate_table_id = Column(Integer)
    action_rate_rows = Column(Integer)
    edited_by = Column(String(100))

    client = relationship('Client', primaryjoin='foreign(RateMassEditLog.client_id) == Client.client_id', uselist=False)

    rate_table = relationship('RateTable',
                              primaryjoin='foreign(RateMassEditLog.rate_table_id) == RateTable.rate_table_id',
                              uselist=False)


class RetrievePasswordLog(DnlApiBaseModel):
    __tablename__ = 'retrieve_password_log'
    STATUS = {1: 'failure', 2: 'E-mail has been sent', 3: 'Modified successfully'}
    id = Column(Integer, primary_key=True, server_default=text_("nextval('retrieve_password_log_id_seq'::regclass)"))
    username = Column(String(500))
    operation_time = Column(DateTime(True))
    email_addresses = Column(String(500))
    modify_time = Column(DateTime(True))
    status = Column(ChoiceType(STATUS))
    request_ip = Column(String(16))
    confirm_ip = Column(String(16))


class ScheduledReportLog(DnlApiBaseModel):
    __tablename__ = 'scheduled_report_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('scheduled_report_log_id_seq'::regclass)"))
    email_to = Column(String(500))
    report_name = Column(String(50))
    attachment_path = Column(String(500))
    execute_time = Column(DateTime(True))


class SchedulerLog(DnlApiBaseModel):
    __tablename__ = 'scheduler_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('scheduler_log_id_seq'::regclass)"))
    script_name = Column(String(200))
    start_time = Column(DateTime)
    end_time = Column(DateTime)


class RerateReportExecLog(DnlApiBaseModel):
    __tablename__ = 'rerate_report_exec_log'
    EXEC_TYPE = {1: 'report', 2: 'balance'}
    STATUS = {0: 'waiting', 1: 'progress', 2: 'done', 3: 'error', None: 'undefined'}
    id = Column(Integer, primary_key=True, server_default=text_("nextval('rerate_report_exec_log_id_seq'::regclass)"))
    start_time = Column(DateTime(True))
    finish_time = Column(DateTime(True))
    create_by = Column(String(100))
    status = Column(ChoiceType(STATUS))
    exec_type = Column(ChoiceType(EXEC_TYPE))
    task_id = Column(ForeignKey('rerate_cdr_task.id', ondelete='SET NULL'))
    total_files_count = Column(Integer)
    success_files_count = Column(Integer)
    create_on = Column(DateTime(True))

    task = relationship('RerateCdrTask')


class RerateCdrDownloadLog(DnlApiBaseModel):
    __tablename__ = 'rerate_cdr_download_log'
    STATUS = {0: 'waiting', 1: 'progress', 2: 'done', 3: 'error'}
    id = Column(Integer, primary_key=True,
                server_default=text_("nextval('rerate_cdr_download_log_id_seq'::regclass)"))
    task_id = Column(ForeignKey('rerate_cdr_task.id', ondelete='SET NULL'))
    create_by = Column(String(100))
    create_on = Column(DateTime(True))
    download_file = Column(String(200))
    finished_time = Column(DateTime(True))
    status = Column(ChoiceType(STATUS), server_default=text_("0"))

    task = relationship('RerateCdrTask')


class ExecutionLog(DnlApiBaseModel):
    __tablename__ = 'execution_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('execution_log_id_seq'::regclass)"))
    rule_name = Column(String(100))
    start_time = Column(DateTime(True))
    end_time = Column(DateTime(True))
    ani_find = Column(String(500))
    of_calls = Column(String(100))
    msg = Column(Text)
    status = Column(Integer)
    exec_type = Column(Integer)


class ImportRateFileLog(DnlApiBaseModel):
    __tablename__ = 'import_rate_file_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('import_rate_file_log_id_seq'::regclass)"))
    file_path = Column(String(256))
    file_name = Column(String(225))
    client_id = Column(Integer)
    egress_trunk_id = Column(Integer)
    end_date = Column(String(225))
    date_format = Column(String(225))
    sample_do = Column(String(225))
    ratetable_id = Column(Integer)
    status = Column(Integer)
    product_id = Column(Integer)
    agent_id = Column(Integer)
    par_id = Column(Integer)
    old_file_path = Column(String)


class ImportRateLog(DnlApiBaseModel):
    __tablename__ = 'import_rate_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('import_rate_log_id_seq'::regclass)"))
    import_file = Column(String(300))
    status = Column(Integer, nullable=False)
    cli_type = Column(Integer)
    dtmf = Column(Boolean)
    g729 = Column(Boolean)
    resource_id = Column(Integer)
    prefix = Column(String(30))
    order_type = Column(Integer, nullable=False)
    client_id = Column(Integer)
    error_file = Column(Integer)
    create_time = Column(DateTime(True))
    duplicate_type = Column(String(30))
    code_deck_id = Column(Integer)


class MailCdrLogDetail(DnlApiBaseModel):
    __tablename__ = 'mail_cdr_log_detail'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('mail_cdr_log_detail_id_seq'::regclass)"))
    mail_cdr_log_id = Column(ForeignKey('mail_cdr_log.id'))
    order = Column(Integer)
    cdr_start_time = Column(DateTime(True))
    cdr_end_time = Column(DateTime(True))
    file_size = Column(Integer)
    filename = Column(String(255))

    mail_cdr_log = relationship('MailCdrLog')


class WatchdogSystemdLog(DnlApiBaseModel):
    __tablename__ = 'watchdog_systemd_log'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('watchdog_systemd_log_id_seq'::regclass)"))
    server_name = Column(Text, nullable=False)
    time = Column(DateTime, nullable=False, server_default=text_("now()"))
    service = Column(Text, nullable=False)
    unit = Column(Text, nullable=False)
    priority = Column(Integer, nullable=False)
    message = Column(Text, nullable=False)


class WatchdogSystemdEvents(DnlApiBaseModel):
    __tablename__ = 'watchdog_systemd_events'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('watchdog_systemd_log_id_seq'::regclass)"))
    server_name = Column(Text, nullable=False)
    time = Column(DateTime, nullable=False, server_default=text_("now()"))
    service = Column(Text, nullable=False)
    unit = Column(Text, nullable=False)
    event = Column(Text, nullable=False)
    message = Column(Text, nullable=False)


class DidClientLog(DnlApiBaseModel):
    __tablename__ = 'did_client_log'
    METHOD = {0: 'UI Entry', 1: 'Import', 2: 'API'}
    id = Column(Integer, primary_key=True)
    did = Column(String(50), index=True, nullable=False)
    client_id = Column(Integer())
    buy_billing_plan_id = Column(Integer)
    sell_billing_plan_id = Column(Integer)
    ingress_res_id = Column(Integer, index=True)
    egress_res_id = Column(Integer, index=True)
    start_date = Column(DateTime(True), index=True)
    assigned_on = Column(DateTime(True))
    assigned_by = Column(Integer())
    released_on = Column(DateTime(True))
    released_by = Column(Integer())
    assign_method = Column(ChoiceType(METHOD))
    release_method = Column(ChoiceType(METHOD))
    created_on = Column(DateTime(True), server_default=func.now())


    did_billing_rel = relationship('DidBillingRel', primaryjoin='foreign(DidBillingRel.did)==DidClientLog.did', uselist=False)

    @hybrid_property
    def is_assigned(self):
        if self.did_billing_rel:
            return self.did_billing_rel.is_assigned

    @hybrid_property
    def is_available(self):
        if self.did_billing_rel:
            return self.did_billing_rel.is_available
    

    @classmethod
    def on_assign_did(cls, did, client_id, assigned_by, assign_method):
        from api_dnl.model import DidBillingRel
        # start_date = did_bil.start_date if did_bil else datetime.now(UTC)
        # old_obj = cls.filter(and_(cls.did == did, cls.client_id == client_id)).order_by(cls.id.desc()).first()
        # if old_obj:
        #     old_obj.assigned_by = assigned_by
        #     old_obj.assigned_method = assign_method
        #     old_obj.assigned_on = datetime.now(UTC)
        #     old_obj.save()
        rel = DidBillingRel.filter(DidBillingRel.did == did).first()
        if not rel:
            cls.session().add(cls(did=did, client_id=client_id, assigned_by=assigned_by, assign_method=assign_method,
                                  assigned_on=datetime.now(UTC)))
            return
        cls.session().add(cls(did=did, client_id=client_id, assigned_by=assigned_by, assign_method=assign_method,
                              assigned_on=datetime.now(UTC), start_date=rel.start_date,
                              buy_billing_plan_id=rel.buy_billing_plan_id, sell_billing_plan_id=rel.sell_billing_plan_id,
                              ingress_res_id=rel.ingress_res_id, egress_res_id=rel.egress_res_id
                              ))

    @classmethod
    def on_release_did(cls, did, released_by, release_method, client_id = None):
        from api_dnl.model import DidBillingRel
        # old_obj = cls.filter(cls.did == did).order_by(cls.id.desc()).first()
        # if old_obj:
        #     old_obj.released_by = released_by
        #     old_obj.release_method = release_method
        #     old_obj.released_on = datetime.now(UTC)
        #     if client_id:
        #         old_obj.client_id = client_id
        #     old_obj.save()
        #     return
        rel = DidBillingRel.filter(DidBillingRel.did == did).first()
        if not rel:
            cls.session().add(
                cls(did=did, released_by=released_by, release_method=release_method, released_on=datetime.now(UTC), client_id=client_id))
        cls.session().add(cls(did=did, client_id=client_id, released_by=released_by, release_method=release_method,
                              released_on=datetime.now(UTC), start_date=rel.start_date,
                              buy_billing_plan_id=rel.buy_billing_plan_id, sell_billing_plan_id=rel.sell_billing_plan_id,
                              ingress_res_id=rel.ingress_res_id, egress_res_id=rel.egress_res_id
                              ))


class DidVendorLog(DnlApiBaseModel):
    __tablename__ = 'did_vendor_log'
    METHOD = {0: 'UI Entry', 1: 'Import', 2: 'API'}
    TYPE = {0: 'Manual dids', 1: 'Inteliquent API', 2: 'Teli API', 3: 'SMSC API'}
    id = Column(Integer, primary_key=True)
    did = Column(String(50), index=True, nullable=False)
    vendor_id = Column(Integer())
    created_on = Column(DateTime(True))
    created_by = Column(Integer())
    deleted_on = Column(DateTime(True))
    deleted_by = Column(Integer())
    created_method = Column(ChoiceType(METHOD))
    delete_method = Column(ChoiceType(METHOD))
    api_vendor_type = Column(ChoiceType(TYPE), server_default='0')

    @classmethod
    def on_create_did(cls, did, vendor_id, created_by, created_method):
        from api_dnl.model import Client
        api_vendor_type = None
        try:
            vendor = Client.get(vendor_id)
            api_vendor_type = vendor.did_vendor.type
        except:
            pass
        cls.session().add(cls(did=did, vendor_id=vendor_id, created_by=created_by, created_method=created_method,
                              created_on=datetime.now(UTC), api_vendor_type=api_vendor_type))

    @classmethod
    def on_delete_did(cls, did, deleted_by, delete_method):
        cls.session().add(cls(did=did, deleted_by=deleted_by, delete_method=delete_method,
                              deleted_on=datetime.now(UTC)))


class DidRepositoryLog(DnlApiBaseModel):
    __tablename__ = 'did_repository_log'
    id = Column(BigInteger, nullable=False, primary_key=True)
    did = Column(String(50))
    vendor_trunk_id = Column(Integer)
    vendor_billing_plan_id = Column(Integer)
    created_at = Column(Date, index=True, nullable=False)
    created_by = Column(Integer)
    deleted_at = Column(Date)
    deleted_by = Column(Integer)
    vendor_id = Column(Integer)
    created_at_time = Column(DateTime(True))
    deleted_at_time = Column(DateTime(True))


class DidAssignmentsLog(DnlApiBaseModel):
    __tablename__ = 'did_assignments_log'
    id = Column(BigInteger, nullable=False, primary_key=True)
    did = Column(String(50))
    vendor_trunk_id = Column(Integer)
    vendor_billing_plan_id = Column(Integer)
    client_trunk_id = Column(Integer)
    client_billing_plan_id = Column(Integer)
    fallback_id = Column(Integer)
    created_at = Column(Date, index=True, nullable=False)
    created_by = Column(Integer)
    deleted_at = Column(Date)
    deleted_by = Column(Integer)
    vendor_id = Column(Integer)
    created_at_time = Column(DateTime(True))
    deleted_at_time = Column(DateTime(True))
    vendor_mrc_cycle = Column(Integer)
    vendor_mrc = Column(Numeric(20, 5))
    vendor_nrc = Column(Numeric(20, 5))
    client_mrc_cycle = Column(Integer)
    client_mrc = Column(Numeric(20, 5))
    client_nrc = Column(Numeric(20, 5))