# coding: utf-8

"""
    DNL API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 1.3.33
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest

import cli_dnl
from cli_dnl.rest import ApiException
from cli_dnl.apis.finance_api import FinanceApi

from . settings import *

def invoice(**kwargs):
    start = datetime.now(UTC) - timedelta(days=5)
    end = datetime.now(UTC) - timedelta(days=4)
    data = {
        "start_date": str(start.date()),
        "end_date": str(end.date()),
        "show_cdr": get_rand('bool'),
        "show_jurisdiction_detail": get_rand('bool'),
        "due_date": str((end+timedelta(days=7)).date()),  # get_rand('date'),
        "invoice_time": str(datetime.now()),  # get_rand('date'),
        "gmt": "{:+03d}:00".format(random.randint(-11,12)),
        "show_detail_by_trunk": get_rand('bool'),
        "show_trunk_breakdown": get_rand('bool'),
        "show_code_summary": get_rand('bool'),
        "show_detail_by_code_name": get_rand('bool'),
        "rate_decimal": random.randint(0, 5),
        "show_daily_breakdown": get_rand('bool'),
        "include_account_detail": get_rand('bool'),
        "send_invoice_as_link": get_rand('bool'),
        "show_payment_summary": get_rand('bool'),
        "include_cdr_in_email": True,#get_rand('bool'),
        "auto_send_invoice": True,#get_rand('bool'),
        "show_detail_by_country": get_rand('bool'),
        "show_rate_table_breakdown": get_rand('bool')
    }
    for key in kwargs:
        data[key]=kwargs[key]
    return data

def gateway_payment(**kwargs):
    data=dict(amount=round(random.random()*1000,2),
             type=random.choice(['paypal','yourpay']),
             paypal_fee=round(random.random() * 10, 2),
             actual_received=round(random.random() * 1000, 2),
             paypal_transaction_id = dig(10),
             cardnumber ='{}-{}-{}-{}'.format(dig(4),dig(4),dig(4),dig(4)),
             status = 'initial'
             )
    for key in kwargs:
        data[key]=kwargs[key]
    return data


class TestFinanceApi(unittest.TestCase):
    """ FinanceApi unit test stubs """

    def setUp(self):
        self.api = cli_dnl.apis.finance_api.FinanceApi()
        auth()

    def tearDown(self):
        pass

    def test_carrier_all_regenerate_balance_post(self):
        """
        Test case for carrier_all_regenerate_balance_post


        """
        pass

    def test_carrier_client_id_actual_balance_get(self):
        """
        Test case for carrier_client_id_actual_balance_get

        
        """
        id = rand_client()[0]
        #id=2255
        ret = self.api.carrier_client_id_actual_balance_get(order_by='date',client_id=id,date_gte='2018-01-15',date_lte='2018-01-31')
        assert(ret.success)
        assert ('beginning_balance' in ret.payload.account_summary)
        print(ret)
        pass

    def test_carrier_client_id_balance_get(self):
        """
        Test case for carrier_client_id_balance_get

        
        """
        pass

    def test_carrier_client_id_gateway_payment_post(self):
        """
        Test case for carrier_client_id_gateway_payment_post

        
        """
        pass

    def test_carrier_client_id_gateway_payments_get(self):
        """
        Test case for carrier_client_id_gateway_payments_get

        
        """
        pass

    def test_carrier_client_id_invoice_list_get(self):
        """
        Test case for carrier_client_id_invoice_list_get

        
        """
        pass

    def test_carrier_client_id_invoice_post(self):
        """
        Test case for carrier_client_id_invoice_post

        
        """
        auth()

        cr = rand_client()[1]

        data = invoice()
        print(cr.client_id,data)
        ret=self.api.carrier_client_id_invoice_post(client_id=cr.client_id,body=data)
        assert(ret.success)
        print(ret)
        pass

    def test_carrier_client_id_manual_invoice_post(self):
        """
        Test case for carrier_client_id_manual_invoice_post


        """
        pass

    def test_carrier_client_id_mutual_balance_get(self):
        """
        Test case for carrier_client_id_mutual_balance_get

        """
        from .test_carrier_api import data_full
        data = data_full()

        ret = cli_dnl.CarrierApi().carrier_full_create_post(body=data)
        assert (ret.success)
        print(ret)
        client_id=ret.object_id
        try:
            ret =  self.api.carrier_client_id_mutual_balance_get(client_id=client_id)
            print(ret)
        finally:
            cli_dnl.CarrierApi().carrier_client_id_delete(client_id=client_id)
        pass

    def test_carrier_client_id_payment_list_get(self):
        """
        Test case for carrier_client_id_payment_list_get

        
        """

        pass

    def test_carrier_client_id_payment_post_1(self):
        auth()
        id = rand_client()[0]
        # id = 2934

        c = cli_dnl.CarrierApi().carrier_client_id_alerts_patch(client_id=id,
                                                                body=dict(enable_payment_received_alert=True)).payload
        print(c)
        #pt = 'prepay payment received'
        pt = 'payment sent'
        data = dict(
            payment_type=pt,
            note=pt + ' ' + bla(6) + ' ' + dig(6),
            paid_on=datetime.now() - timedelta(hours=random.randint(1, 128)),
            amount=round(random.random() * 1000, 2)
        )
        print(id, data)
        ret = self.api.carrier_client_id_payment_post(client_id=id, body=data)
        assert (ret.success)
        print(ret)
        pass

    def test_carrier_client_id_payment_post(self):
        """
        Test case for carrier_client_id_payment_post

        
        """
        PAYMENT_TYPE_DICT = {#1: 'n/a', 2: 'undefined',
                             3: 'invoice payment sent',
                             4: 'invoice payment received',
                             5: 'prepay payment received',
                             6: 'payment sent',
                             7: 'credit note received',
                             8: 'credit note sent',
                             #9: 'reset',
                             #10: 'offset',
                             11: 'debit received',
                             12: 'debit sent',
                             #13: 'mutual reset',
                             #14: 'actual reset',
                             #15: 'prepayment'
        }
        auth()
        id = rand_client()[0]
        id = 2900

        c = cli_dnl.CarrierApi().carrier_client_id_get(client_id=id).payload
        print(c.actual_balance, c.mutual_balance)

        pt=random.choice(tuple(PAYMENT_TYPE_DICT.values()))
        data  = dict(
            payment_type = pt,
            #payment_type='prepay payment received',
            note= pt+' '+bla(6)+' '+dig(6),
            paid_on=datetime.now()-timedelta(hours=random.randint(1,5)),
            amount = round(random.random()*10000,2)
        )
        print(id,data)
        ret = self.api.carrier_client_id_payment_post(client_id=id, body=data)
        assert (ret.success)
        print(ret)
        c=cli_dnl.CarrierApi().carrier_client_id_get(client_id=id).payload
        print(c.actual_balance,c.mutual_balance)
        #ret = self.api.finance_payment_client_payment_id_delete(client_payment_id=ret.object_id)
        #c = cli_dnl.CarrierApi().carrier_client_id_get(client_id=id).payload
        #print(c.actual_balance, c.mutual_balance)
        pass

    def test_carrier_client_id_regenerate_balance_post(self):
        """
        Test case for carrier_client_id_regenerate_balance_post

        
        """
        data={
  'start_time': get_rand('datetime'),
  'new_balance': random.random()*5000,
  'reset_actual_balance': get_rand('bool'),
  'reset_mutual_balance': get_rand('bool')
}
        id=rand_client()[0]
        ret=self.api.carrier_client_id_regenerate_balance_post(client_id=id,body=data)
        assert(ret.success)
        print(id,data)
        pass

    def test_carrier_client_id_transactions_list_get(self):
        """
        Test case for carrier_client_id_transactions_list_get

        
        """
        pass

    def test_finance_all_invoice_payment_list_get(self):
        """
        Test case for finance_all_invoice_payment_list_get


        """
        pass

    def test_finance_all_payment_list_get(self):
        """
        Test case for finance_all_payment_list_get

        
        """
        auth()
        ret=self.api.finance_all_payment_list_get()
        assert(ret.success and len(ret.payload.items))
        ret = self.api.finance_all_payment_list_get(amount_lt=1000)
        assert (ret.success and len(ret.payload.items))

        pass

    def test_finance_auto_invoice_list_get(self):
        """
        Test case for finance_auto_invoice_list_get

        
        """
        order = ['name', 'payment_term_id','pt_name']
        for o in order:
            ret = self.api.finance_auto_invoice_list_get(order_by=o)
            assert (ret.success)
        pass

    def test_finance_gateway_payments_get(self):
        """
        Test case for finance_gateway_payments_get

        
        """
        order=['client_id','type','paypal_id',
                         'paypal_transaction_id','status']
        for o in order:
            ret=self.api.finance_gateway_payments_get(order_by=o)
            assert(ret.success)

        pass

    def test_finance_invoice_all_delete(self):
        """
        Test case for finance_invoice_all_delete


        """
        pass

    def test_finance_invoice_file_invoice_id_get(self):
        """
        Test case for finance_invoice_file_invoice_id_get


        """
        pass

    def test_finance_invoice_invoice_id_create_credit_note_post(self):
        """
        Test case for finance_invoice_invoice_id_create_credit_note_post


        """
        id,inv,inv_lst = rand_invoice(amount_gt=1)
        data = {'amount':round(random.random()*inv.amount,2),'note':'credit note '+bla(8)}
        ret = self.api.finance_invoice_invoice_id_create_credit_note_post(invoice_id=id,body=data)
        assert(ret.success)
        print(id,data,ret)
        ret = self.api.finance_all_payment_list_get(invoice_id=id)
        print(ret)
        pass

    def test_finance_invoice_invoice_id_delete(self):
        """
        Test case for finance_invoice_invoice_id_delete

        
        """
        ret = self.api.finance_invoice_invoice_id_delete(invoice_id=rand_invoice()[0])
        assert (ret.success)
        pass

    def test_finance_invoice_invoice_id_get(self):
        """
        Test case for finance_invoice_invoice_id_get

        
        """
        ret=self.api.finance_invoice_invoice_id_get(invoice_id=rand_invoice()[0])
        assert (ret.success)
        pass

    def test_finance_invoice_invoice_id_patch(self):
        """
        Test case for finance_invoice_invoice_id_patch

        
        """
        data={'state':random.choice(['void','normal','verify','send'])}
        ret=self.api.finance_invoice_invoice_id_patch(invoice_id=rand_invoice()[0],body=data)
        assert(ret.success,ret.payload.state==data['state'])
        print(ret,data)

        pass

    def test_finance_invoice_invoice_id_payment_list_get(self):
        """
        Test case for finance_invoice_invoice_id_payment_list_get


        """
        #id = rand_invoice()[0]
        id= 374
        r = self.api.finance_invoice_invoice_id_payment_list_get(invoice_id=id)
        assert (r.success)
        print(r)
        pass

    def test_finance_invoice_invoice_id_regenerate_post(self):
        """
        Test case for finance_invoice_invoice_id_regenerate_post


        """
        # id = rand_invoice()[0]
        id = 374
        r = self.api.finance_invoice_invoice_id_regenerate_post(invoice_id=id)
        assert (r.success)
        print(r)
        pass

    def test_finance_invoice_invoice_id_send_patch(self):
        """
        Test case for finance_invoice_invoice_id_send_patch


        """
        auth()
        id=rand_invoice()[0]
        r = self.api.finance_invoice_invoice_id_send_patch(invoice_id=id)
        assert (r.success)
        pass
        pass

    def test_finance_invoice_list_get(self):
        """
        Test case for finance_invoice_list_get

        
        """
        pass



    def test_finance_invoice_post(self):
        """
        Test case for finance_invoice_post


        """
        #data=invoice(clients=[rand_client()[0],rand_client()[0],rand_client()[0]])
        #check invoices_logo_id
        ret = cli_dnl.ConfigApi().config_invoice_patch(body={'invoice_number_format': '1',
                                                        #'cdr_fields': ['ingress_call_cost'],
                                                         "company_info_position":"top",
                                                        "billing_info_position":"top"})
        assert (ret.success)
        ret = cli_dnl.ConfigApi().config_invoice_get()
        print('invoice_logo_id {}'.format(ret.payload.invoices_logo_id))

        data = invoice(clients=[rand_client(ingress_count_gt=1)[0]])
        print(json.dumps(data))
        ret=self.api.finance_invoice_post(body=data)
        assert(ret.success)
        print(ret)
        for id in ret.object_ids:
            ret1=self.api.finance_invoice_invoice_id_get(invoice_id=id)
            assert(ret1.success)
            print(ret1.payload.to_dict())
        pass
        try:
            ret1 = self.api.finance_invoice_post(body=data)
            assert(not ret1.success)
        except Exception as e:
            assert('overlapping' in str(e))

    def test_finance_payment_client_payment_id_delete(self):
        """
        Test case for finance_payment_client_payment_id_delete

        
        """
        pass

    def test_finance_payment_client_payment_id_edit_and_send_note_post(self):
        """
        Test case for finance_payment_client_payment_id_edit_and_send_note_post


        """
        auth()
        ret = self.api.finance_all_payment_list_get(per_page=150)
        assert (ret.success and len(ret.payload.items))
        random.shuffle(ret.payload.items)
        pay=None
        for p in ret.payload.items:
            if p.client_id:
                pay=p
                break
        if not pay:
            return

        cli_dnl.CarrierApi().carrier_client_id_patch(client_id=pay.client_id,body={'billing_email':'_novvv@mail.ru'})
        data={'note':bla_bla(7)}
        try:
            note=self.api.finance_payment_client_payment_id_edit_and_send_note_post(client_payment_id=pay.client_payment_id,
                                                                    body=data)
            assert(ret.success)
        except Exception as e:
            assert ('mail has errors' in str(e) or 'Payment has no client!' in str(e))
        pass

    def test_finance_payment_client_payment_id_get(self):
        """
        Test case for finance_payment_client_payment_id_get

        
        """
        pass

    def test_finance_payment_client_payment_id_patch(self):
        """
        Test case for finance_payment_client_payment_id_patch

        
        """
        pass

    def test_finance_received_payment_list_get(self):
        """
        Test case for finance_received_payment_list_get

        
        """
        order = ['client_payment_id', 'client_id', 'update_by', 'payment_type', 'client_name',
                 'payment_time', 'amount', 'receiving_time']
        for o in order:
            lst = self.api.finance_received_payment_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)
        pass
        pass

    def test_finance_sent_payment_client_payment_id_delete(self):
        """
        Test case for finance_sent_payment_client_payment_id_delete

        
        """
        pass

    def test_finance_sent_payment_client_payment_id_get(self):
        """
        Test case for finance_sent_payment_client_payment_id_get

        
        """
        pass

    def test_finance_sent_payment_client_payment_id_patch(self):
        """
        Test case for finance_sent_payment_client_payment_id_patch

        
        """
        pass

    def test_finance_sent_payment_list_get(self):
        """
        Test case for finance_sent_payment_list_get

        
        """
        order = ['client_payment_id','client_id','update_by','payment_type','client_name',
                 'payment_time', 'amount', 'receiving_time']
        for o in order:
            lst = self.api.finance_sent_payment_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)
        pass

    def test_finance_sent_payment_post(self):
        """
        Test case for finance_sent_payment_post

        
        """
        pass


if __name__ == '__main__':
    unittest.main()
