import sys
import contextlib
import re
from gunicorn.app.wsgiapp import run as grun
from celery.__main__ import main as celery
from .. import settings


@contextlib.contextmanager
def redirect_argv(args):
    sys._argv = sys.argv[:]
    sys.argv = [sys._argv[0]] + args
    yield
    sys.argv = sys._argv


def my_gunicorn():
    args = 'api_dnl.wsgi:app -b localhost:{} -t 600 -w 8 --reload'.format(settings.API_PORT).split(' ')
    with redirect_argv(args):
        grun()


def my_worker():
    if len(sys.argv) < 2:
        print('usage:\n {} [NAME]'.format(sys.argv[0]))
        print('NAME is worker name')
        return
    name = sys.argv[1]
    log_level = 'info'  # settings.LOG_LEVEL
    # args = '-q -b redis://localhost:6379/0 -E -A api_dnl.tasks worker -l debug -n "worker.{}" -P gevent -c 4'.format(name).split(' ')
    # for priority in ('low','normal','high'):
    priority = 'normal'
    try:
        n = int(re.match('^\D+(\d+)$', name)[1])
        if n % 3 == 0:
            # if n in ('0', '3', '6', '9', '12', '15'):
            priority = 'high'
        elif n % 3 == 1:
            # in ('1', '4', '7', '10', '13', '16'):
            priority = 'low'
    except:
        pass

    args = '-q -b {} -E -A api_dnl.tasks worker -l {} --autoscale=8,2 -n worker_{}.{} -Q {}'.format(
        settings.CELERY['CELERY_BROKER_URL'], log_level, priority, name, priority)
    args = args.split(' ')
    with redirect_argv(args):
        celery()


def my_beat():
    args = '-q -b {} -A api_dnl.tasks beat -l info'.format(settings.CELERY['CELERY_BROKER_URL'])
    args = args.split(' ')
    with redirect_argv(args):
        celery()
