import re
import jwt
import json
import sys, os
from urllib.parse import parse_qsl, urlencode
from datetime import date, datetime, timedelta
import traceback
from pytz import UTC
import mimetypes
from time import mktime
from dateutil.parser import parse as parse_datetime
import requests
import falcon
from sqlalchemy.orm import aliased, make_transient, foreign
from sqlalchemy import or_, and_, select, inspect, alias
from api_dnl import model
from falcon_rest import conf
from falcon_rest.logger import log
from falcon_rest.responses import responses
from falcon_rest.responses import errors
from falcon_rest.resources.resources import swagger, ResourcesBaseClass, DEFAULT_SECURITY, ATTRIBUTE_ERROR_RE

from api_dnl.resources import DnlResource, DnlList, DnlCreate, CustomAction, CustomPatchAction, ValidationError, \
    client_context, check_context
from api_dnl.view import NoResultFound, DEFAULT_SECURITY, OperationErrorResponse, generate_uuid_str
from api_dnl.schemes.smshook import SmsHookScheme
from api_dnl import settings


class SmsCreate(DnlCreate):
    scheme_class = SmsHookScheme
    model_class = model.Sms
    entity = 'Sms'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    no_auth_needed = True

    def on_post(self, req, resp, **kwargs):

        log.debug('smshook headers {} req.data {} kwargs {}'.format(req.headers, req.data, kwargs))
        try:
            log.debug('smshook X-AUTH-TOKEN:{}'.format(req.headers['X-AUTH-TOKEN']))
            token = req.headers['X-AUTH-TOKEN']
            if ',' in token:
                token = token.split(',')[0]
            auth_data = jwt.decode(token, settings.JWT_SIGNATURE, verify=False)
            log.debug('smshook auth_data:{}'.format(auth_data))
            if not 'client_id' in auth_data:
                self.set_response(responses.UnauthenticatedErrorResponse())
                return
            client_id = auth_data['client_id']
            log.debug('smshook client_id:{}'.format(client_id))
            client = model.Client.get(client_id)
            if not client or not client.status:
                self.set_response(responses.ForbiddenErrorResponse())
                return
            data = req.data
            msg = data['text']
            log.debug('message text:{}'.format(msg))
            if data['deliveryReceipt'] or 'dlvrd:' in msg:
                g = re.search(
                    r'id:(\w+) sub:(\w+) dlvrd:(\w+) submit date:(\w+) done date:(\w+) stat:(\w+) err:(\w+) text:',
                    msg).groups()
                log.debug('parsed message text:{}'.format(g))
                ref_id = data['referenceId']  # g[0] #'{:x}'.format(int(g[0])).upper()
                stat = g[5]
                delivered_on = datetime.strptime(g[4], '%y%m%d%H%M')
                delivery_error = g[6]
                log.debug('smshook delivery ref_id {} stat {}'.format(ref_id, stat))
                obj = self.model_class.filter(self.model_class.reference_id == ref_id).first()
                if not obj:
                    log.debug('smshook delivery state not found {}'.format(msg))
                    resp.status = falcon.HTTP_200
                    resp.body = b'{"success":false,"error":"wrong reference id"}'
                    return
                obj.stat = stat
                obj.delivered_on = datetime.now(UTC)
                obj.delivery_error = delivery_error
                if obj.delivery_error == '000':
                    obj.send_dlr(sms_id=obj.id, sender=obj.sender, receiver=obj.receiver, message=obj.message,
                                 status=obj.stat)
                else:
                    obj.send_fail_dlr(sms_id=obj.id, sender=obj.sender, receiver=obj.receiver, message=msg,
                                      status=obj.stat, error=obj.delivery_error)
                log.debug('smshook set delivery state of sms {}'.format(obj))
            else:
                # received msgs
                obj = self.model_class(client_id=client_id, sender=data['from'], receiver=data['to'][0],
                                       message=msg, direction='received', reference_id=data['referenceId'])
                log.debug('smshook relay to client wehook...')
                try:
                    jdata = json.dumps(data)
                    whcls = model.WebHook
                    wh = whcls.filter(and_(whcls.client_id == client_id, or_(whcls.number == data['to'][0],
                                                                             whcls.number == '+' + data['to'][0],
                                                                             whcls.number == '+1' + data['to'][0], )
                                           )).first()
                    if wh:
                        headers = wh.header_vars or {}
                        if 'CONTENT-TYPE' not in headers:
                            headers['CONTENT-TYPE'] = 'application/json'
                        if 'USER-AGENT' not in headers:
                            headers['USER-AGENT'] = '{} {}'.format(settings.API_TITLE, settings.VERSION)
                        response = requests.post(wh.url, data=jdata, timeout=(30, 30), headers=headers, verify=False)
                        log.debug('smshook relay number found, response is {} {}'.format(response.status_code,
                                                                                         response.content))
                    wh = whcls.filter(and_(whcls.client_id == client_id, whcls.number == '')).first()
                    if wh:
                        headers = wh.header_vars or {}
                        if 'CONTENT-TYPE' not in headers:
                            headers['CONTENT-TYPE'] = 'application/json'
                        if 'USER-AGENT' not in headers:
                            headers['USER-AGENT'] = '{} {}'.format(settings.API_TITLE, settings.VERSION)
                        response = requests.post(wh.url, data=jdata, timeout=(30, 30), headers=headers, verify=False)
                        log.debug('smshook relay common webhook found, response is {} {}'.format(response.status_code,
                                                                                                 response.content))
                except Exception as e:
                    log.debug('smshook relay error: {}'.format(e))
            obj.save()

            log.debug('smshook success')

            resp.status = falcon.HTTP_200
            resp.body = b'{"success":true}'
            ##billing
            receiver = data['to'][0]
            cls = model.DidBillingRel
            did = cls.filter(or_(cls.did == receiver, cls.did == receiver[1:])).first()
            if did and did.vendor_res and model.DidVendor.get(did.vendor_res.client_id):
                if did.buy_billing_plan and did.sell_billing_plan:
                    vendor_api = model.DidVendor.get(did.vendor_res.client_id)
                    obj.vendor_id = vendor_api.id
                    obj.cost = did.buy_billing_plan.rate_per_sms_received or 0.0
                    obj.vendor_cost = did.sell_billing_plan.rate_per_sms_received or 0.0
                    model.ClientBalanceOperationAction(client_id=client_id, action=3,
                                                           balance=obj.cost,
                                                           create_by='sms_received', create_time=datetime.now(UTC)).save()

        except Exception as e:
            log.warning('smshook:{}'.format(e))
            self.set_response(resp, OperationErrorResponse(e))
            return


class SmsTestHook(DnlCreate):
    scheme_class = SmsHookScheme
    model_class = model.Sms
    entity = 'Sms'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    no_auth_needed = True

    def on_post(self, req, resp, **kwargs):
        log.debug('sms test hook headers {} req.data {} kwargs {}'.format(req.headers, req.data, kwargs))
        self.set_response(resp, responses.SuccessResponseJustOk())
        return
