#!/usr/bin/python3
import sys,json

def caps(s):
    return ''.join([x.capitalize() for x in s.strip().split('_')])

def class_name(path):
    p=path.split('/')
    return 'class '+''.join([caps(n) for n in p if '{' not in n])+'Scheme(BaseModelScheme):'


def gen(d,path):
    if path in d['paths']:
        gen_post(d,path)
        gen_patch(d,path)
        gen_post(d,path,method='get')

    if path in d['definitions']:
            gen_definition(d,path)
    if not path in d['definitions'] and not path in d['paths']:
            print("PATHS:",len(d['paths'].keys()) )
            print( ", ".join(d['paths'].keys()) )
            print("MODELS:",len(d['definitions'].keys()))
            print( ", ".join(d['definitions'].keys()) )
    
def gen_comments(d):
    if 'title' in d:
        print('    #---',d['title'],'---')
    if 'summary' in d:
        print('    #',d['summary'])
    if 'description' in d:
        print('    #',d['description'])
    

def gen_schema(schema):
    #print(schema)
    #return
    for f,t in schema['properties'].items():
        if 'type' in t:
            if t['type']=='object':
                print("    " + f.strip()+" = Nested("+caps(f) +"Scheme)")
            else:
                print("    " + f.strip()+" = "+t['type'].capitalize()[0:3]+"()")

            
    
    print("    class Meta:")
    print("        model=model.XXX")
    print("        fields=(%s)" %
        ",".join(["'"+f.strip()+"'" for f,t in schema['properties'].items() if 'type' in t ] ) )
    
    
def gen_post(d,path,method='post'):
    
    if method in d['paths'][path]:
        #print(d['paths'][path])
        print(class_name(path))
        print('    #gen  ',method,path)
        gen_comments(d['paths'][path][method])
        if 'responses' in d['paths'][path][method]:
            gen_schema(d['paths'][path][method]['responses']['200']['schema'])
        if  'parameters' in d['paths'][path][method]:
            params=d['paths'][path][method]['parameters']
            for f in params:
                if 'type' in f:
                    print("    #" + f['name'].strip()+" = sa.fields."+f['type'].capitalize()+"()")
                    print("    " + f['name'].strip()+" = "+f['type'].capitalize()+
                    "(attribute='"+f['name'].strip()+"',load_from='"+f['name'].strip()+"',dump_to='"+f['name'].strip()+"' )\n", end='')
            
            print("    class Meta:")
            print("        fields=(%s)" %
                ",".join(["'"+f['name'].strip()+"'" for f in params if 'type' in f ] ) )

def gen_patch(d,path,method='patch'):
    
    if method in d['paths'][path]:
        if 'schema' in d['paths'][path][method]['parameters'][0]:
            print(class_name(path))
            print('    #gen  ',method,path)
            gen_comments(d['paths'][path][method])
            prop=d['paths'][path][method]['parameters'][0]['schema']['properties']
            gen_prop(prop)
        else:
            gen_post(d,path,method='patch')
        
def gen_prop(prop):
    for f in sorted(prop.keys()):
       print("    " + f.strip()+" = "+prop[f]['type'].capitalize()[0:3]+"()")
    print("    class Meta:")    
    print("        fields=(%s)" % ",".join(["'"+f.strip()+"'" for f in sorted(prop.keys()) ] ) )
    print("#---synonyms---#")
    for f in sorted(prop.keys()):
       print("    " + f.strip()+" = synonym()")
    
   
def gen_definition(d,path):
   print(class_name(path))
   print('    #gen module ',path)
   gen_comments(d['definitions'][path])
   prop=d['definitions'][path]['properties']
   gen_prop(prop)





if __name__ == '__main__':
    txt=open(sys.argv[1],'rt').read()
    d=json.JSONDecoder().decode(txt)
    
    gen(d,sys.argv[2])
