"""rate_upload_template

Revision ID: 00cb7e781257
Revises: 490fa8f8519f
Create Date: 2017-11-30 01:27:03.295402

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '00cb7e781257'
down_revision = '490fa8f8519f'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute("delete from balance_history_actual where ctid not in (select max(ctid) from balance_history_actual s  group by s.date,s.client_id)")
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('rate_upload_template',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('append_prefix', sa.Boolean(), nullable=True),
    sa.Column('append_prefix_value', sa.String(length=20), nullable=True),
    sa.Column('check_effective', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('code_name_match', sa.Integer(), nullable=True),
    sa.Column('create_by', sa.String(length=100), nullable=True),
    sa.Column('create_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('dup_method', sa.Integer(), nullable=True),
    sa.Column('effective_date_default', sa.DateTime(timezone=True), nullable=True),
    sa.Column('effective_date_format', sa.String(length=50), nullable=True),
    sa.Column('end_date', sa.DateTime(), nullable=True),
    sa.Column('end_date_all', sa.DateTime(), nullable=True),
    sa.Column('end_date_all_gmt', sa.String(length=5), server_default=sa.text('(+ 0)'), nullable=True),
    sa.Column('end_date_gmt', sa.String(length=5), server_default=sa.text('(+ 0)'), nullable=True),
    sa.Column('has_code_deck', sa.Boolean(), nullable=True),
    sa.Column('header_fields', sa.String(length=200), nullable=True),
    sa.Column('interval_default', sa.Integer(), nullable=True),
    sa.Column('min_time_default', sa.Integer(), nullable=True),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('new_code_days', sa.Integer(), nullable=True),
    sa.Column('rate_increase_days', sa.Integer(), nullable=True),
    sa.Column('reject_rate', sa.Integer(), nullable=True),
    sa.Column('send_error_email_to', sa.Integer(), server_default=sa.text('0'), nullable=True),
    sa.Column('update_on', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.Column('with_header', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date'], unique=False)
    op.drop_table('rate_upload_template')
    # ### end Alembic commands ###
