"""version_information switch_name

Revision ID: 109a9ba6effe
Revises: a4ac0e166e3a
Create Date: 2019-10-10 17:24:55.707293

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl


# revision identifiers, used by Alembic.
revision = '109a9ba6effe'
down_revision = 'a4ac0e166e3a'
branch_labels = None
depends_on = None


def upgrade():

    import imp, os
    alembic_helpers = imp.load_source('alembic_helpers', (
        # os.getcwd() + '/' +
            op.get_context().script.dir + '/alembic_helpers.py'))

    # ### commands auto generated by Alembic - please adjust! ###
    if not alembic_helpers.table_has_column('version_information','expires'):
        op.add_column('version_information', sa.Column('expires', sa.DateTime(timezone=True), nullable=True))
    if not alembic_helpers.table_has_column('version_information', 'licensed_channel'):
        op.add_column('version_information', sa.Column('licensed_channel', sa.Integer(), nullable=True))
    if not alembic_helpers.table_has_column('version_information', 'licensed_cps'):
        op.add_column('version_information', sa.Column('licensed_cps', sa.Integer(), nullable=True))
    if not alembic_helpers.table_has_column('version_information', 'serial_number'):
        op.add_column('version_information', sa.Column('serial_number', sa.String(length=100), nullable=True))
    if not alembic_helpers.table_has_column('version_information', 'switch_name'):
        op.add_column('version_information', sa.Column('switch_name', sa.String(length=100), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('version_information', 'switch_name')
    op.drop_column('version_information', 'serial_number')
    op.drop_column('version_information', 'licensed_cps')
    op.drop_column('version_information', 'licensed_channel')
    op.drop_column('version_information', 'expires')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))