"""codecs

Revision ID: 3ef67c8a9aef
Revises: 7e53c4221824
Create Date: 2020-12-22 13:32:40.606483

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '3ef67c8a9aef'
down_revision = '7e53c4221824'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
    connection = op.get_bind()
    connection.execute(
"""
delete from resource_codecs_ref;
delete from codecs;
""")
    def c(s):
        connection.execute('insert into codecs (id, name, detail) values({})'.format(s))
    c("0,'PCMU(G711.u 8000)','ITU-T G.711 PCM µ-Law Audio 64 kbit/s'")
    c("3,'GSM(8000)','European GSM Full Rate Audio 13 kbit/s (GSM 06.10)'")
    c("4,'G723(8000)','ITU-T G.723.1'")
    c("8,'PCMA(G711.a 8000)','ITU-T G.711 PCM A-Law Audio 64 kbit/s'")
    c("9,'G722(8000)','ITU-T G.722 Audio'")
    c("13,'CN(8000)','Comfort noise'")
    c("15,'G728(8000)','ITU-T G.728 Audio 16 kbit/s'")
    c("16,'DV14(11025)','IMA ADPCM'")
    c("17,'DV14(22050)','IMA ADPCM'")
    c("18,'G729(8000)','ITU-T G.729 and G.729a'")
    c("96,'AMR(8000)/dynamic','Adaptive Multi-Rate audio'")
    c("97,'iLBC/dynamic','Internet low Bitrate Codec 13.33 or 15.2 kbit/s'")
    c("99,'Speex(8000, 16000 or 32000)/dynamic','RTP Payload Format for the Speex Codec'")
    c("101,'telephone-event/dynamic','?'")
    c("107,'G7221(16000 or 32000)/dynamic','ITU-T G.722.1'")
    c("115,'G7221C(32000)/dynamic','?'")
    c("121,'G726-40(8000)/dynamic','ITU-T G.726 audio with 40 kbit/s'")
    c("122,'G726-32(8000)/dynamic','ITU-T G.726 audio with 32 kbit/s'")
    c("123,'G726-24(8000)/dynamic','ITU-T G.726 audio with 24 kbit/s'")
    c("124,'G726-16(8000)/dynamic','ITU-T G.726 audio with 16 kbit/s'")
    c("145,'G729a',NULL")
    c("146,'G729b',NULL")



def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))