"""empty message

Revision ID: 423545fbe10c
Revises: 3dfdcffbc5b4
Create Date: 2017-10-04 05:08:26.039710

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '423545fbe10c'
down_revision = '3dfdcffbc5b4'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('auto_rate_import_rule',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('from_email', sa.String(length=100), nullable=True),
    sa.Column('mail_server_ip', sa.String(length=100), nullable=True),
    sa.Column('mail_server_password', sa.String(length=100), nullable=True),
    sa.Column('create_by', sa.String(length=100), nullable=True),
    sa.Column('create_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('egress_trunk_id', sa.Integer(), nullable=True),
    sa.Column('digits', api_dnl.fields.prefix_range.PrefixRange(), nullable=True),
    sa.ForeignKeyConstraint(['egress_trunk_id'], ['resource.resource_id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_auto_rate_import_rule_egress_trunk_id'), 'auto_rate_import_rule', ['egress_trunk_id'], unique=False)
    #op.drop_table('api_permissions')
    op.drop_table('carrier')
    op.drop_table('captcha')
    op.drop_table('agent_client')
    op.alter_column('agent', 'agent_name',
               existing_type=sa.VARCHAR(length=100),
               nullable=False)
    op.alter_column('agent', 'create_on',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=False)
    op.alter_column('agent', 'email',
               existing_type=sa.VARCHAR(length=200),
               nullable=False)
    op.alter_column('agent', 'frequency_type',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.alter_column('agent', 'method_type',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.create_unique_constraint(None, 'agent', ['agent_name'])
    op.alter_column('balance_daily_reset_task', 'create_time',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=False,
               existing_server_default=sa.text("('now'::text)::timestamp(0) with time zone"))
    op.alter_column('balance_daily_reset_task', 'status',
               existing_type=sa.SMALLINT(),
               nullable=True,
               existing_server_default=sa.text('0'))
    op.drop_index('balance_daily_reset_task_status_idx', table_name='balance_daily_reset_task')
    op.drop_index('balance_history_date_idx', table_name='balance_history')
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index(op.f('ix_balance_history_actual_date'), 'balance_history_actual', ['date'], unique=False)
    op.drop_index('balance_history_actual_date_idx', table_name='balance_history_actual')
    op.create_index(op.f('ix_c4_client_balance_client_id'), 'c4_client_balance', ['client_id'], unique=False)
    op.drop_index('c4_client_balance_client_id_idx', table_name='c4_client_balance')
    op.create_index(op.f('ix_c4_livecall_user_name'), 'c4_livecall_user', ['name'], unique=False)
    op.drop_index('c4_livecall_user_name_idx', table_name='c4_livecall_user')
    op.alter_column('client', 'profit_type',
               existing_type=sa.INTEGER(),
               nullable=True,
               existing_server_default=sa.text('1'))
    op.create_index(op.f('ix_client_currency_id'), 'client', ['currency_id'], unique=False)
    op.create_index(op.f('ix_client_group_id'), 'client', ['group_id'], unique=False)
    op.create_index(op.f('ix_client_orig_rate_table_id'), 'client', ['orig_rate_table_id'], unique=False)
    op.create_index(op.f('ix_client_payment_term_id'), 'client', ['payment_term_id'], unique=False)
    op.create_index(op.f('ix_client_role_id'), 'client', ['role_id'], unique=False)
    op.create_index(op.f('ix_client_term_rate_table_id'), 'client', ['term_rate_table_id'], unique=False)
    op.drop_index('client_currency_id_idx', table_name='client')
    op.drop_index('client_group_id_idx', table_name='client')
    op.drop_index('client_orig_rate_table_id_idx', table_name='client')
    op.drop_index('client_payment_term_id_idx', table_name='client')
    op.drop_index('client_role_id_idx', table_name='client')
    op.drop_index('client_term_rate_table_id_idx', table_name='client')
    op.create_foreign_key(None, 'client', 'carrier_group', ['group_id'], ['group_id'], ondelete='SET NULL')
    op.create_index(op.f('ix_client_balance_operation_action_client_id'), 'client_balance_operation_action', ['client_id'], unique=False)
    op.create_index(op.f('ix_client_balance_operation_action_update_result'), 'client_balance_operation_action', ['update_result'], unique=False)
    op.drop_index('client_balance_operation_action_client_id_idx', table_name='client_balance_operation_action')
    op.drop_index('client_balance_operation_action_update_result_idx', table_name='client_balance_operation_action')
    op.create_index(op.f('ix_client_cdr_time'), 'client_cdr', ['time'], unique=False)
    op.drop_index('client_cdr_time_idx', table_name='client_cdr')
    op.create_index(op.f('ix_client_payment_client_id'), 'client_payment', ['client_id'], unique=False)
    op.create_index(op.f('ix_client_payment_invoice_number'), 'client_payment', ['invoice_number'], unique=False)
    op.drop_index('client_payment_client_id_idx', table_name='client_payment')
    op.drop_index('client_payment_invoice_number_idx', table_name='client_payment')
    op.drop_index('client_payment_payment_time_idx', table_name='client_payment')
    op.create_index(op.f('ix_code_code'), 'code', ['code'], unique=False)
    op.create_index(op.f('ix_code_code_deck_id'), 'code', ['code_deck_id'], unique=False)
    op.drop_index('class4_idx_code_prefix', table_name='code')
    op.drop_index('fki_class4_fkey_code_code_deck_id', table_name='code')
    op.create_foreign_key(None, 'code', 'code_deck', ['code_deck_id'], ['code_deck_id'], ondelete='CASCADE')
    op.drop_constraint('code_deck_client_id_key', 'code_deck', type_='unique')
    op.create_index(op.f('ix_currency_updates_currency_id'), 'currency_updates', ['currency_id'], unique=False)
    op.drop_index('currency_updates_currency_id_idx', table_name='currency_updates')
    op.drop_constraint('fkey_currency_updates_currency_currency_id', 'currency_updates', type_='foreignkey')
    op.create_foreign_key(None, 'currency_updates', 'currency', ['currency_id'], ['currency_id'], ondelete='SET NULL')
    op.drop_column('currency_updates', 'last_rate')
    op.drop_column('currency_updates', 'modify_time')
    op.create_foreign_key(None, 'did_billing_plan', 'rate_table', ['rate_table_id'], ['rate_table_id'])
    op.drop_column('did_report', 'cdr_date')
    op.create_index(op.f('ix_dynamic_route_time_profile_id'), 'dynamic_route', ['time_profile_id'], unique=False)
    op.drop_index('dynamic_route_time_profile_id_idx', table_name='dynamic_route')
    op.create_index(op.f('ix_dynamic_route_items_dynamic_route_id'), 'dynamic_route_items', ['dynamic_route_id'], unique=False)
    op.create_index(op.f('ix_dynamic_route_items_resource_id'), 'dynamic_route_items', ['resource_id'], unique=False)
    op.drop_index('dynamic_route_items_dynamic_route_id_idx', table_name='dynamic_route_items')
    op.drop_index('dynamic_route_items_resource_id_idx', table_name='dynamic_route_items')
    op.create_index(op.f('ix_dynamic_route_override_dynamic_route_id'), 'dynamic_route_override', ['dynamic_route_id'], unique=False)
    op.create_index(op.f('ix_dynamic_route_override_resource_id'), 'dynamic_route_override', ['resource_id'], unique=False)
    op.drop_index('fki_class4_fkey_dynamic_route_override_dynamic_route_id', table_name='dynamic_route_override')
    op.drop_index('fki_class4_fkey_dynamic_route_override_resource_id', table_name='dynamic_route_override')
    op.create_index(op.f('ix_dynamic_route_pri_dynamic_route_id'), 'dynamic_route_pri', ['dynamic_route_id'], unique=False)
    op.create_index(op.f('ix_dynamic_route_pri_resource_id'), 'dynamic_route_pri', ['resource_id'], unique=False)
    op.drop_index('dynamic_route_pri_dynamic_route_id_idx', table_name='dynamic_route_pri')
    op.drop_index('dynamic_route_pri_resource_id_idx', table_name='dynamic_route_pri')
    op.create_index(op.f('ix_dynamic_route_qos_dynamic_route_id'), 'dynamic_route_qos', ['dynamic_route_id'], unique=False)
    op.drop_index('dynamic_route_qos_dynamic_route_id_idx', table_name='dynamic_route_qos')
    op.alter_column('fraud_detection', 'active',
               existing_type=sa.BOOLEAN(),
               nullable=False)
    op.create_foreign_key(None, 'ftp_cdr_log_detail', 'ftp_cdr_log', ['ftp_cdr_log_id'], ['id'], ondelete='CASCADE')
    op.create_index(op.f('ix_invoice_client_id'), 'invoice', ['client_id'], unique=False)
    op.create_index(op.f('ix_invoice_invoice_log_id'), 'invoice', ['invoice_log_id'], unique=False)
    op.drop_index('invoice_client_id_idx', table_name='invoice')
    op.create_foreign_key(None, 'invoice', 'invoice_log', ['invoice_log_id'], ['id'], ondelete='SET NULL')
    op.create_index(op.f('ix_invoice_history_client_id'), 'invoice_history', ['client_id'], unique=False)
    op.create_index(op.f('ix_invoice_history_last_invoice_for'), 'invoice_history', ['last_invoice_for'], unique=False)
    op.drop_index('invoice_history_client_id_idx', table_name='invoice_history')
    op.drop_index('invoice_history_last_invoice_for_idx', table_name='invoice_history')
    op.create_index(op.f('ix_jurisdiction_prefix_jurisdiction_country_id'), 'jurisdiction_prefix', ['jurisdiction_country_id'], unique=False)
    op.create_index(op.f('ix_jurisdiction_prefix_jurisdiction_id'), 'jurisdiction_prefix', ['jurisdiction_id'], unique=False)
    op.create_index(op.f('ix_jurisdiction_prefix_prefix'), 'jurisdiction_prefix', ['prefix'], unique=False)
    op.drop_index('jurisdiction_prefix_jurisdiction_country_id_idx', table_name='jurisdiction_prefix')
    op.drop_index('jurisdiction_prefix_jurisdiction_id_idx', table_name='jurisdiction_prefix')
    op.drop_index('jurisdiction_prefix_prefix_idx', table_name='jurisdiction_prefix')
    op.alter_column('loop_detection_detail', 'loop_detection_id',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.create_foreign_key(None, 'loop_detection_detail', 'loop_detection', ['loop_detection_id'], ['id'], ondelete='CASCADE')
    op.create_unique_constraint(None, 'origination_global_failover', ['from_sip_code'])
    op.create_index(op.f('ix_payment_gateway_history_client_id'), 'payment_gateway_history', ['client_id'], unique=False)
    op.drop_index('payment_gateway_history_invoice_id_keys', table_name='payment_gateway_history')
    op.create_foreign_key(None, 'payment_gateway_history', 'client', ['client_id'], ['client_id'], ondelete='SET NULL')
    op.drop_constraint('name_uniq', 'product', type_='unique')
    op.create_foreign_key(None, 'product', 'code_deck', ['code_deck_id'], ['code_deck_id'], ondelete='SET NULL')
    op.drop_index('product_items_product_id_idx', table_name='product_items')
    op.drop_index('product_items_time_profile_id_idx', table_name='product_items')
    op.create_index(op.f('ix_product_items_resource_item_id'), 'product_items_resource', ['item_id'], unique=False)
    op.create_index(op.f('ix_product_items_resource_resource_id'), 'product_items_resource', ['resource_id'], unique=False)
    op.drop_index('product_items_resource_item_id_idx', table_name='product_items_resource')
    op.drop_index('product_items_resource_resource_id_idx', table_name='product_items_resource')
    op.create_index(op.f('ix_qos_ip_report_time'), 'qos_ip', ['report_time'], unique=False)
    op.create_index(op.f('ix_qos_ip_server_ip'), 'qos_ip', ['server_ip'], unique=False)
    op.create_index(op.f('ix_qos_ip_server_port'), 'qos_ip', ['server_port'], unique=False)
    op.drop_index('qos_ip_report_time_idx', table_name='qos_ip')
    op.drop_index('qos_ip_server_ip_idx', table_name='qos_ip')
    op.drop_index('qos_ip_server_port_idx', table_name='qos_ip')
    op.create_index(op.f('ix_qos_resource_report_time'), 'qos_resource', ['report_time'], unique=False)
    op.create_index(op.f('ix_qos_resource_server_ip'), 'qos_resource', ['server_ip'], unique=False)
    op.create_index(op.f('ix_qos_resource_server_port'), 'qos_resource', ['server_port'], unique=False)
    op.drop_index('qos_resource_report_time_idx', table_name='qos_resource')
    op.drop_index('qos_resource_server_ip_idx', table_name='qos_resource')
    op.drop_index('qos_resource_server_port_idx', table_name='qos_resource')
    op.create_index(op.f('ix_qos_route_report_report_time'), 'qos_route_report', ['report_time'], unique=False)
    op.drop_index('qos_route_report_report_time_idx', table_name='qos_route_report')
    op.create_index(op.f('ix_qos_total_report_time'), 'qos_total', ['report_time'], unique=False)
    op.drop_index('qos_total_report_time_idx', table_name='qos_total')
    op.drop_column('qos_total', 'egress_channels')
    op.create_index(op.f('ix_random_ani_generation_ani_number'), 'random_ani_generation', ['ani_number'], unique=False)
    op.create_index(op.f('ix_random_ani_generation_random_table_id'), 'random_ani_generation', ['random_table_id'], unique=False)
    op.drop_index('random_ani_generation_ani_number_idx', table_name='random_ani_generation')
    op.drop_index('random_ani_generation_random_table_id_idx', table_name='random_ani_generation')
    op.alter_column('rate', 'code',
               existing_type=api_dnl.fields.prefix_range.PrefixRange(),
               nullable=True,
               existing_server_default=sa.text("''::prefix_range"))
    op.alter_column('rate', 'effective_date',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=True,
               existing_server_default=sa.text("('now'::text)::timestamp(0) with time zone"))
    op.create_index(op.f('ix_rate_did_type'), 'rate', ['did_type'], unique=False)
    op.create_index(op.f('ix_rate_end_date'), 'rate', ['end_date'], unique=False)
    op.create_index(op.f('ix_rate_rate_table_id'), 'rate', ['rate_table_id'], unique=False)
    op.create_index(op.f('ix_rate_time_profile_id'), 'rate', ['time_profile_id'], unique=False)
    op.drop_index('rate_did_type_idx', table_name='rate')
    op.drop_index('rate_end_date_idx', table_name='rate')
    op.drop_index('rate_rate_table_id_idx', table_name='rate')
    op.drop_index('rate_time_profile_id_idx', table_name='rate')
    op.drop_constraint('fkey_rate_time_profile_time_profile_id', 'rate', type_='foreignkey')
    op.create_foreign_key(None, 'rate', 'time_profile', ['time_profile_id'], ['time_profile_id'], ondelete='CASCADE')
    op.create_index(op.f('ix_rate_generation_code_deck_rate_generation_template_id'), 'rate_generation_code_deck', ['rate_generation_template_id'], unique=False)
    op.drop_index('rate_generation_code_deck_rate_generation_template_id_idx', table_name='rate_generation_code_deck')
    op.drop_constraint('fkey_rate_generation_code_deck_rate_gen_template_id', 'rate_generation_code_deck', type_='foreignkey')
    op.create_foreign_key(None, 'rate_generation_code_deck', 'rate_generation_template', ['rate_generation_template_id'], ['id'], ondelete='CASCADE')
    op.create_index(op.f('ix_rate_generation_history_status'), 'rate_generation_history', ['status'], unique=False)
    op.drop_index('rate_generation_history_status_idx', table_name='rate_generation_history')
    op.create_index(op.f('ix_rate_generation_rate_rate_generation_history_id'), 'rate_generation_rate', ['rate_generation_history_id'], unique=False)
    op.drop_index('rate_generation_rate_rate_generation_history_id_idx', table_name='rate_generation_rate')
    op.create_index(op.f('ix_rate_generation_template_detail_rate_generation_template_id'), 'rate_generation_template_detail', ['rate_generation_template_id'], unique=False)
    op.drop_index('rate_generation_template_detail_rate_generation_template_id_idx', table_name='rate_generation_template_detail')
    op.create_index(op.f('ix_rate_generation_template_margin_rate_generation_template_id'), 'rate_generation_template_margin', ['rate_generation_template_id'], unique=False)
    op.drop_index('rate_generation_template_margin_tmplate_id_idx', table_name='rate_generation_template_margin')
    op.create_index(op.f('ix_rate_table_code_deck_id'), 'rate_table', ['code_deck_id'], unique=False)
    op.create_index(op.f('ix_rate_table_currency_id'), 'rate_table', ['currency_id'], unique=False)
    op.create_index(op.f('ix_rate_table_jurisdiction_country_id'), 'rate_table', ['jurisdiction_country_id'], unique=False)
    op.drop_index('rate_table_code_deck_id_idx', table_name='rate_table')
    op.drop_index('rate_table_currency_id_idx', table_name='rate_table')
    op.drop_index('rate_table_jurisdiction_country_id_idx', table_name='rate_table')
    op.alter_column('resource', 'name',
               existing_type=sa.VARCHAR(length=100),
               nullable=False)
    op.create_index(op.f('ix_resource_client_id'), 'resource', ['client_id'], unique=False)
    op.create_index(op.f('ix_resource_rate_table_id'), 'resource', ['rate_table_id'], unique=False)
    op.create_index(op.f('ix_resource_route_strategy_id'), 'resource', ['route_strategy_id'], unique=False)
    op.drop_index('resource_client_id_idx', table_name='resource')
    op.drop_index('resource_rate_table_id_idx', table_name='resource')
    op.drop_index('resource_route_strategy_id_idx', table_name='resource')
    op.alter_column('resource_block', 'create_time',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=True,
               existing_server_default=sa.text("('now'::text)::timestamp(0) with time zone"))
    op.create_index(op.f('ix_resource_block_time_profile_id'), 'resource_block', ['time_profile_id'], unique=False)
    op.drop_index('resource_block_engress_res_id_idx', table_name='resource_block')
    op.drop_index('resource_block_ingress_res_id_idx', table_name='resource_block')
    op.drop_index('resource_block_time_profile_id_idx', table_name='resource_block')
    op.drop_constraint('fkey_resource_block_resource_engress_res_id', 'resource_block', type_='foreignkey')
    op.create_foreign_key(None, 'resource_block', 'resource', ['engress_res_id'], ['resource_id'], ondelete='CASCADE')
    op.create_foreign_key(None, 'resource_block', 'client', ['ingress_client_id'], ['client_id'], ondelete='CASCADE')
    op.create_foreign_key(None, 'resource_block', 'client', ['egress_client_id'], ['client_id'], ondelete='CASCADE')
    op.create_index(op.f('ix_resource_capacity_egress_id'), 'resource_capacity', ['egress_id'], unique=False)
    op.create_index(op.f('ix_resource_capacity_ingress_id'), 'resource_capacity', ['ingress_id'], unique=False)
    op.drop_index('resource_capacity_egress_id_idx', table_name='resource_capacity')
    op.drop_index('resource_capacity_ingress_id_idx', table_name='resource_capacity')
    op.create_index(op.f('ix_resource_codecs_ref_codec_id'), 'resource_codecs_ref', ['codec_id'], unique=False)
    op.create_index(op.f('ix_resource_codecs_ref_resource_id'), 'resource_codecs_ref', ['resource_id'], unique=False)
    op.drop_index('resource_codecs_ref_codec_id_idx', table_name='resource_codecs_ref')
    op.drop_index('resource_codecs_ref_resource_id_idx', table_name='resource_codecs_ref')
    op.drop_constraint('fkey_resource_codecs_ref_codecs_id', 'resource_codecs_ref', type_='foreignkey')
    op.create_foreign_key(None, 'resource_codecs_ref', 'codecs', ['codec_id'], ['id'])
    op.create_index(op.f('ix_resource_direction_resource_id'), 'resource_direction', ['resource_id'], unique=False)
    op.create_index(op.f('ix_resource_direction_time_profile_id'), 'resource_direction', ['time_profile_id'], unique=False)
    op.drop_index('resource_direction_resource_id_idx', table_name='resource_direction')
    op.drop_index('resource_direction_time_profile_id_idx', table_name='resource_direction')
    op.create_index(op.f('ix_resource_ip_resource_id'), 'resource_ip', ['resource_id'], unique=False)
    op.drop_index('resource_ip_resource_id_idx', table_name='resource_ip')
    op.create_index(op.f('ix_resource_ip_limit_ip_id'), 'resource_ip_limit', ['ip_id'], unique=False)
    op.create_index(op.f('ix_resource_ip_limit_time_profile_id'), 'resource_ip_limit', ['time_profile_id'], unique=False)
    op.drop_index('resource_ip_limit_ip_id_idx', table_name='resource_ip_limit')
    op.drop_index('resource_ip_limit_time_profile_id_idx', table_name='resource_ip_limit')
    op.create_index(op.f('ix_resource_prefix_resource_id'), 'resource_prefix', ['resource_id'], unique=False)
    op.drop_index('resource_prefix_resource_id_idx', table_name='resource_prefix')
    op.create_index(op.f('ix_resource_replace_action_resource_id'), 'resource_replace_action', ['resource_id'], unique=False)
    op.drop_index('resource_replace_action_resource_id_idx', table_name='resource_replace_action')
    op.alter_column('resource_translation_ref', 'resource_id',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.alter_column('resource_translation_ref', 'translation_id',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.create_index(op.f('ix_resource_translation_ref_resource_id'), 'resource_translation_ref', ['resource_id'], unique=False)
    op.create_index(op.f('ix_resource_translation_ref_time_profile_id'), 'resource_translation_ref', ['time_profile_id'], unique=False)
    op.create_index(op.f('ix_resource_translation_ref_translation_id'), 'resource_translation_ref', ['translation_id'], unique=False)
    op.drop_index('resource_translation_ref_resource_id_idx', table_name='resource_translation_ref')
    op.drop_index('resource_translation_ref_time_profile_id_idx', table_name='resource_translation_ref')
    op.drop_index('resource_translation_ref_translation_id_idx', table_name='resource_translation_ref')
    op.drop_constraint('fkey_resource_translation_ref_resource_resource_id', 'resource_translation_ref', type_='foreignkey')
    op.drop_constraint('fkey_resource_translation_ref_time_profile_time_profile_id', 'resource_translation_ref', type_='foreignkey')
    op.drop_constraint('fkey_resource_translation_ref_digit_translation_translation_id', 'resource_translation_ref', type_='foreignkey')
    op.create_foreign_key(None, 'resource_translation_ref', 'time_profile', ['time_profile_id'], ['time_profile_id'])
    op.create_foreign_key(None, 'resource_translation_ref', 'digit_translation', ['translation_id'], ['translation_id'])
    op.create_foreign_key(None, 'resource_translation_ref', 'resource', ['resource_id'], ['resource_id'])
    op.create_index(op.f('ix_route_dynamic_route_id'), 'route', ['dynamic_route_id'], unique=False)
    op.create_index(op.f('ix_route_route_strategy_id'), 'route', ['route_strategy_id'], unique=False)
    op.create_index(op.f('ix_route_static_route_id'), 'route', ['static_route_id'], unique=False)
    op.drop_index('route_dynamic_route_id_idx', table_name='route')
    op.drop_index('route_route_strategy_id_idx', table_name='route')
    op.drop_index('route_static_route_id_idx', table_name='route')
    op.create_index(op.f('ix_sip_registrations_username'), 'sip_registrations', ['username'], unique=False)
    op.drop_index('c4_sip_registrations_username_idx', table_name='sip_registrations')
    op.drop_index('sip_registrations_username_idx', table_name='sip_registrations')
    op.create_index(op.f('ix_spam_traffic_ip_ip'), 'spam_traffic_ip', ['ip'], unique=False)
    op.drop_index('spam_traffic_ip_idx', table_name='spam_traffic_ip')
    op.create_index(op.f('ix_switch_profile_voip_gateway_id'), 'switch_profile', ['voip_gateway_id'], unique=False)
    op.drop_index('switch_profile_voip_gateway_id_idx', table_name='switch_profile')
    op.create_index(op.f('ix_system_configure_create_time'), 'system_configure', ['create_time'], unique=False)
    op.create_index(op.f('ix_system_configure_switch_name'), 'system_configure', ['switch_name'], unique=False)
    op.drop_index('system_configure_create_time_idx', table_name='system_configure')
    op.drop_index('system_configure_switch_name_idx', table_name='system_configure')
    op.alter_column('system_function', 'func_type',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.create_unique_constraint(None, 'termination_global_failover', ['from_sip_code'])
    op.create_index(op.f('ix_translation_item_translation_id'), 'translation_item', ['translation_id'], unique=False)
    op.drop_index('translation_item_translation_id_idx', table_name='translation_item')
    op.alter_column('trunk_group', 'group_name',
               existing_type=sa.VARCHAR(),
               nullable=False)
    op.create_foreign_key(None, 'users', 'role', ['role_id'], ['role_id'], ondelete='SET NULL')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'users', type_='foreignkey')
    op.alter_column('trunk_group', 'group_name',
               existing_type=sa.VARCHAR(),
               nullable=True)
    op.create_index('translation_item_translation_id_idx', 'translation_item', ['translation_id'], unique=False)
    op.drop_index(op.f('ix_translation_item_translation_id'), table_name='translation_item')
    op.drop_constraint(None, 'termination_global_failover', type_='unique')
    op.alter_column('system_function', 'func_type',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.create_index('system_configure_switch_name_idx', 'system_configure', ['switch_name'], unique=False)
    op.create_index('system_configure_create_time_idx', 'system_configure', ['create_time'], unique=False)
    op.drop_index(op.f('ix_system_configure_switch_name'), table_name='system_configure')
    op.drop_index(op.f('ix_system_configure_create_time'), table_name='system_configure')
    op.create_index('switch_profile_voip_gateway_id_idx', 'switch_profile', ['voip_gateway_id'], unique=False)
    op.drop_index(op.f('ix_switch_profile_voip_gateway_id'), table_name='switch_profile')
    op.create_index('spam_traffic_ip_idx', 'spam_traffic_ip', ['ip'], unique=False)
    op.drop_index(op.f('ix_spam_traffic_ip_ip'), table_name='spam_traffic_ip')
    op.create_index('sip_registrations_username_idx', 'sip_registrations', ['username'], unique=False)
    op.create_index('c4_sip_registrations_username_idx', 'sip_registrations', ['username'], unique=False)
    op.drop_index(op.f('ix_sip_registrations_username'), table_name='sip_registrations')
    op.create_index('route_static_route_id_idx', 'route', ['static_route_id'], unique=False)
    op.create_index('route_route_strategy_id_idx', 'route', ['route_strategy_id'], unique=False)
    op.create_index('route_dynamic_route_id_idx', 'route', ['dynamic_route_id'], unique=False)
    op.drop_index(op.f('ix_route_static_route_id'), table_name='route')
    op.drop_index(op.f('ix_route_route_strategy_id'), table_name='route')
    op.drop_index(op.f('ix_route_dynamic_route_id'), table_name='route')
    op.drop_constraint(None, 'resource_translation_ref', type_='foreignkey')
    op.drop_constraint(None, 'resource_translation_ref', type_='foreignkey')
    op.drop_constraint(None, 'resource_translation_ref', type_='foreignkey')
    op.create_foreign_key('fkey_resource_translation_ref_digit_translation_translation_id', 'resource_translation_ref', 'digit_translation', ['translation_id'], ['translation_id'], ondelete='CASCADE')
    op.create_foreign_key('fkey_resource_translation_ref_time_profile_time_profile_id', 'resource_translation_ref', 'time_profile', ['time_profile_id'], ['time_profile_id'], ondelete='SET NULL')
    op.create_foreign_key('fkey_resource_translation_ref_resource_resource_id', 'resource_translation_ref', 'resource', ['resource_id'], ['resource_id'], ondelete='CASCADE')
    op.create_index('resource_translation_ref_translation_id_idx', 'resource_translation_ref', ['translation_id'], unique=False)
    op.create_index('resource_translation_ref_time_profile_id_idx', 'resource_translation_ref', ['time_profile_id'], unique=False)
    op.create_index('resource_translation_ref_resource_id_idx', 'resource_translation_ref', ['resource_id'], unique=False)
    op.drop_index(op.f('ix_resource_translation_ref_translation_id'), table_name='resource_translation_ref')
    op.drop_index(op.f('ix_resource_translation_ref_time_profile_id'), table_name='resource_translation_ref')
    op.drop_index(op.f('ix_resource_translation_ref_resource_id'), table_name='resource_translation_ref')
    op.alter_column('resource_translation_ref', 'translation_id',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.alter_column('resource_translation_ref', 'resource_id',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.create_index('resource_replace_action_resource_id_idx', 'resource_replace_action', ['resource_id'], unique=False)
    op.drop_index(op.f('ix_resource_replace_action_resource_id'), table_name='resource_replace_action')
    op.create_index('resource_prefix_resource_id_idx', 'resource_prefix', ['resource_id'], unique=False)
    op.drop_index(op.f('ix_resource_prefix_resource_id'), table_name='resource_prefix')
    op.create_index('resource_ip_limit_time_profile_id_idx', 'resource_ip_limit', ['time_profile_id'], unique=False)
    op.create_index('resource_ip_limit_ip_id_idx', 'resource_ip_limit', ['ip_id'], unique=False)
    op.drop_index(op.f('ix_resource_ip_limit_time_profile_id'), table_name='resource_ip_limit')
    op.drop_index(op.f('ix_resource_ip_limit_ip_id'), table_name='resource_ip_limit')
    op.create_index('resource_ip_resource_id_idx', 'resource_ip', ['resource_id'], unique=False)
    op.drop_index(op.f('ix_resource_ip_resource_id'), table_name='resource_ip')
    op.create_index('resource_direction_time_profile_id_idx', 'resource_direction', ['time_profile_id'], unique=False)
    op.create_index('resource_direction_resource_id_idx', 'resource_direction', ['resource_id'], unique=False)
    op.drop_index(op.f('ix_resource_direction_time_profile_id'), table_name='resource_direction')
    op.drop_index(op.f('ix_resource_direction_resource_id'), table_name='resource_direction')
    op.drop_constraint(None, 'resource_codecs_ref', type_='foreignkey')
    op.create_foreign_key('fkey_resource_codecs_ref_codecs_id', 'resource_codecs_ref', 'codecs', ['codec_id'], ['id'], ondelete='CASCADE')
    op.create_index('resource_codecs_ref_resource_id_idx', 'resource_codecs_ref', ['resource_id'], unique=False)
    op.create_index('resource_codecs_ref_codec_id_idx', 'resource_codecs_ref', ['codec_id'], unique=False)
    op.drop_index(op.f('ix_resource_codecs_ref_resource_id'), table_name='resource_codecs_ref')
    op.drop_index(op.f('ix_resource_codecs_ref_codec_id'), table_name='resource_codecs_ref')
    op.create_index('resource_capacity_ingress_id_idx', 'resource_capacity', ['ingress_id'], unique=False)
    op.create_index('resource_capacity_egress_id_idx', 'resource_capacity', ['egress_id'], unique=False)
    op.drop_index(op.f('ix_resource_capacity_ingress_id'), table_name='resource_capacity')
    op.drop_index(op.f('ix_resource_capacity_egress_id'), table_name='resource_capacity')
    op.drop_constraint(None, 'resource_block', type_='foreignkey')
    op.drop_constraint(None, 'resource_block', type_='foreignkey')
    op.drop_constraint(None, 'resource_block', type_='foreignkey')
    op.create_foreign_key('fkey_resource_block_resource_engress_res_id', 'resource_block', 'resource', ['engress_res_id'], ['resource_id'], ondelete='SET NULL')
    op.create_index('resource_block_time_profile_id_idx', 'resource_block', ['time_profile_id'], unique=False)
    op.create_index('resource_block_ingress_res_id_idx', 'resource_block', ['ingress_res_id'], unique=False)
    op.create_index('resource_block_engress_res_id_idx', 'resource_block', ['engress_res_id'], unique=False)
    op.drop_index(op.f('ix_resource_block_time_profile_id'), table_name='resource_block')
    op.alter_column('resource_block', 'create_time',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=False,
               existing_server_default=sa.text("('now'::text)::timestamp(0) with time zone"))
    op.create_index('resource_route_strategy_id_idx', 'resource', ['route_strategy_id'], unique=False)
    op.create_index('resource_rate_table_id_idx', 'resource', ['rate_table_id'], unique=False)
    op.create_index('resource_client_id_idx', 'resource', ['client_id'], unique=False)
    op.drop_index(op.f('ix_resource_route_strategy_id'), table_name='resource')
    op.drop_index(op.f('ix_resource_rate_table_id'), table_name='resource')
    op.drop_index(op.f('ix_resource_client_id'), table_name='resource')
    op.alter_column('resource', 'name',
               existing_type=sa.VARCHAR(length=100),
               nullable=True)
    op.create_index('rate_table_jurisdiction_country_id_idx', 'rate_table', ['jurisdiction_country_id'], unique=False)
    op.create_index('rate_table_currency_id_idx', 'rate_table', ['currency_id'], unique=False)
    op.create_index('rate_table_code_deck_id_idx', 'rate_table', ['code_deck_id'], unique=False)
    op.drop_index(op.f('ix_rate_table_jurisdiction_country_id'), table_name='rate_table')
    op.drop_index(op.f('ix_rate_table_currency_id'), table_name='rate_table')
    op.drop_index(op.f('ix_rate_table_code_deck_id'), table_name='rate_table')
    op.create_index('rate_generation_template_margin_tmplate_id_idx', 'rate_generation_template_margin', ['rate_generation_template_id'], unique=False)
    op.drop_index(op.f('ix_rate_generation_template_margin_rate_generation_template_id'), table_name='rate_generation_template_margin')
    op.create_index('rate_generation_template_detail_rate_generation_template_id_idx', 'rate_generation_template_detail', ['rate_generation_template_id'], unique=False)
    op.drop_index(op.f('ix_rate_generation_template_detail_rate_generation_template_id'), table_name='rate_generation_template_detail')
    op.create_index('rate_generation_rate_rate_generation_history_id_idx', 'rate_generation_rate', ['rate_generation_history_id'], unique=False)
    op.drop_index(op.f('ix_rate_generation_rate_rate_generation_history_id'), table_name='rate_generation_rate')
    op.create_index('rate_generation_history_status_idx', 'rate_generation_history', ['status'], unique=False)
    op.drop_index(op.f('ix_rate_generation_history_status'), table_name='rate_generation_history')
    op.drop_constraint(None, 'rate_generation_code_deck', type_='foreignkey')
    op.create_foreign_key('fkey_rate_generation_code_deck_rate_gen_template_id', 'rate_generation_code_deck', 'rate_generation_template', ['rate_generation_template_id'], ['id'])
    op.create_index('rate_generation_code_deck_rate_generation_template_id_idx', 'rate_generation_code_deck', ['rate_generation_template_id'], unique=False)
    op.drop_index(op.f('ix_rate_generation_code_deck_rate_generation_template_id'), table_name='rate_generation_code_deck')
    op.drop_constraint(None, 'rate', type_='foreignkey')
    op.create_foreign_key('fkey_rate_time_profile_time_profile_id', 'rate', 'time_profile', ['time_profile_id'], ['time_profile_id'], ondelete='SET NULL')
    op.create_index('rate_time_profile_id_idx', 'rate', ['time_profile_id'], unique=False)
    op.create_index('rate_rate_table_id_idx', 'rate', ['rate_table_id'], unique=False)
    op.create_index('rate_end_date_idx', 'rate', ['end_date'], unique=False)
    op.create_index('rate_did_type_idx', 'rate', ['did_type'], unique=False)
    op.drop_index(op.f('ix_rate_time_profile_id'), table_name='rate')
    op.drop_index(op.f('ix_rate_rate_table_id'), table_name='rate')
    op.drop_index(op.f('ix_rate_end_date'), table_name='rate')
    op.drop_index(op.f('ix_rate_did_type'), table_name='rate')
    op.alter_column('rate', 'effective_date',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=False,
               existing_server_default=sa.text("('now'::text)::timestamp(0) with time zone"))
    op.alter_column('rate', 'code',
               existing_type=api_dnl.fields.prefix_range.PrefixRange(),
               nullable=False,
               existing_server_default=sa.text("''::prefix_range"))
    op.create_index('random_ani_generation_random_table_id_idx', 'random_ani_generation', ['random_table_id'], unique=False)
    op.create_index('random_ani_generation_ani_number_idx', 'random_ani_generation', ['ani_number'], unique=False)
    op.drop_index(op.f('ix_random_ani_generation_random_table_id'), table_name='random_ani_generation')
    op.drop_index(op.f('ix_random_ani_generation_ani_number'), table_name='random_ani_generation')
    op.add_column('qos_total', sa.Column('egress_channels', sa.INTEGER(), autoincrement=False, nullable=True))
    op.create_index('qos_total_report_time_idx', 'qos_total', ['report_time'], unique=False)
    op.drop_index(op.f('ix_qos_total_report_time'), table_name='qos_total')
    op.create_index('qos_route_report_report_time_idx', 'qos_route_report', ['report_time'], unique=False)
    op.drop_index(op.f('ix_qos_route_report_report_time'), table_name='qos_route_report')
    op.create_index('qos_resource_server_port_idx', 'qos_resource', ['server_port'], unique=False)
    op.create_index('qos_resource_server_ip_idx', 'qos_resource', ['server_ip'], unique=False)
    op.create_index('qos_resource_report_time_idx', 'qos_resource', ['report_time'], unique=False)
    op.drop_index(op.f('ix_qos_resource_server_port'), table_name='qos_resource')
    op.drop_index(op.f('ix_qos_resource_server_ip'), table_name='qos_resource')
    op.drop_index(op.f('ix_qos_resource_report_time'), table_name='qos_resource')
    op.create_index('qos_ip_server_port_idx', 'qos_ip', ['server_port'], unique=False)
    op.create_index('qos_ip_server_ip_idx', 'qos_ip', ['server_ip'], unique=False)
    op.create_index('qos_ip_report_time_idx', 'qos_ip', ['report_time'], unique=False)
    op.drop_index(op.f('ix_qos_ip_server_port'), table_name='qos_ip')
    op.drop_index(op.f('ix_qos_ip_server_ip'), table_name='qos_ip')
    op.drop_index(op.f('ix_qos_ip_report_time'), table_name='qos_ip')
    op.create_index('product_items_resource_resource_id_idx', 'product_items_resource', ['resource_id'], unique=False)
    op.create_index('product_items_resource_item_id_idx', 'product_items_resource', ['item_id'], unique=False)
    op.drop_index(op.f('ix_product_items_resource_resource_id'), table_name='product_items_resource')
    op.drop_index(op.f('ix_product_items_resource_item_id'), table_name='product_items_resource')
    op.create_index('product_items_time_profile_id_idx', 'product_items', ['time_profile_id'], unique=False)
    op.create_index('product_items_product_id_idx', 'product_items', ['product_id'], unique=False)
    op.drop_constraint(None, 'product', type_='foreignkey')
    op.create_unique_constraint('name_uniq', 'product', ['name'])
    op.drop_constraint(None, 'payment_gateway_history', type_='foreignkey')
    op.create_index('payment_gateway_history_invoice_id_keys', 'payment_gateway_history', ['invoice_id'], unique=False)
    op.drop_index(op.f('ix_payment_gateway_history_client_id'), table_name='payment_gateway_history')
    op.drop_constraint(None, 'origination_global_failover', type_='unique')
    op.drop_constraint(None, 'loop_detection_detail', type_='foreignkey')
    op.alter_column('loop_detection_detail', 'loop_detection_id',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.create_index('jurisdiction_prefix_prefix_idx', 'jurisdiction_prefix', ['prefix'], unique=False)
    op.create_index('jurisdiction_prefix_jurisdiction_id_idx', 'jurisdiction_prefix', ['jurisdiction_id'], unique=False)
    op.create_index('jurisdiction_prefix_jurisdiction_country_id_idx', 'jurisdiction_prefix', ['jurisdiction_country_id'], unique=False)
    op.drop_index(op.f('ix_jurisdiction_prefix_prefix'), table_name='jurisdiction_prefix')
    op.drop_index(op.f('ix_jurisdiction_prefix_jurisdiction_id'), table_name='jurisdiction_prefix')
    op.drop_index(op.f('ix_jurisdiction_prefix_jurisdiction_country_id'), table_name='jurisdiction_prefix')
    op.create_index('invoice_history_last_invoice_for_idx', 'invoice_history', ['last_invoice_for'], unique=False)
    op.create_index('invoice_history_client_id_idx', 'invoice_history', ['client_id'], unique=False)
    op.drop_index(op.f('ix_invoice_history_last_invoice_for'), table_name='invoice_history')
    op.drop_index(op.f('ix_invoice_history_client_id'), table_name='invoice_history')
    op.drop_constraint(None, 'invoice', type_='foreignkey')
    op.create_index('invoice_client_id_idx', 'invoice', ['client_id'], unique=False)
    op.drop_index(op.f('ix_invoice_invoice_log_id'), table_name='invoice')
    op.drop_index(op.f('ix_invoice_client_id'), table_name='invoice')
    op.drop_constraint(None, 'ftp_cdr_log_detail', type_='foreignkey')
    op.alter_column('fraud_detection', 'active',
               existing_type=sa.BOOLEAN(),
               nullable=True)
    op.create_index('dynamic_route_qos_dynamic_route_id_idx', 'dynamic_route_qos', ['dynamic_route_id'], unique=False)
    op.drop_index(op.f('ix_dynamic_route_qos_dynamic_route_id'), table_name='dynamic_route_qos')
    op.create_index('dynamic_route_pri_resource_id_idx', 'dynamic_route_pri', ['resource_id'], unique=False)
    op.create_index('dynamic_route_pri_dynamic_route_id_idx', 'dynamic_route_pri', ['dynamic_route_id'], unique=False)
    op.drop_index(op.f('ix_dynamic_route_pri_resource_id'), table_name='dynamic_route_pri')
    op.drop_index(op.f('ix_dynamic_route_pri_dynamic_route_id'), table_name='dynamic_route_pri')
    op.create_index('fki_class4_fkey_dynamic_route_override_resource_id', 'dynamic_route_override', ['resource_id'], unique=False)
    op.create_index('fki_class4_fkey_dynamic_route_override_dynamic_route_id', 'dynamic_route_override', ['dynamic_route_id'], unique=False)
    op.drop_index(op.f('ix_dynamic_route_override_resource_id'), table_name='dynamic_route_override')
    op.drop_index(op.f('ix_dynamic_route_override_dynamic_route_id'), table_name='dynamic_route_override')
    op.create_index('dynamic_route_items_resource_id_idx', 'dynamic_route_items', ['resource_id'], unique=False)
    op.create_index('dynamic_route_items_dynamic_route_id_idx', 'dynamic_route_items', ['dynamic_route_id'], unique=False)
    op.drop_index(op.f('ix_dynamic_route_items_resource_id'), table_name='dynamic_route_items')
    op.drop_index(op.f('ix_dynamic_route_items_dynamic_route_id'), table_name='dynamic_route_items')
    op.create_index('dynamic_route_time_profile_id_idx', 'dynamic_route', ['time_profile_id'], unique=False)
    op.drop_index(op.f('ix_dynamic_route_time_profile_id'), table_name='dynamic_route')
    op.add_column('did_report', sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True))
    op.drop_constraint(None, 'did_billing_plan', type_='foreignkey')
    op.add_column('currency_updates', sa.Column('modify_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False))
    op.add_column('currency_updates', sa.Column('last_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True))
    op.drop_constraint(None, 'currency_updates', type_='foreignkey')
    op.create_foreign_key('fkey_currency_updates_currency_currency_id', 'currency_updates', 'currency', ['currency_id'], ['currency_id'], ondelete='CASCADE')
    op.create_index('currency_updates_currency_id_idx', 'currency_updates', ['currency_id'], unique=False)
    op.drop_index(op.f('ix_currency_updates_currency_id'), table_name='currency_updates')
    op.create_unique_constraint('code_deck_client_id_key', 'code_deck', ['client_id'])
    op.drop_constraint(None, 'code', type_='foreignkey')
    op.create_index('fki_class4_fkey_code_code_deck_id', 'code', ['code_deck_id'], unique=False)
    op.create_index('class4_idx_code_prefix', 'code', ['code'], unique=False)
    op.drop_index(op.f('ix_code_code_deck_id'), table_name='code')
    op.drop_index(op.f('ix_code_code'), table_name='code')
    op.create_index('client_payment_payment_time_idx', 'client_payment', ['payment_time'], unique=False)
    op.create_index('client_payment_invoice_number_idx', 'client_payment', ['invoice_number'], unique=False)
    op.create_index('client_payment_client_id_idx', 'client_payment', ['client_id'], unique=False)
    op.drop_index(op.f('ix_client_payment_invoice_number'), table_name='client_payment')
    op.drop_index(op.f('ix_client_payment_client_id'), table_name='client_payment')
    op.create_index('client_cdr_time_idx', 'client_cdr', ['time'], unique=False)
    op.drop_index(op.f('ix_client_cdr_time'), table_name='client_cdr')
    op.create_index('client_balance_operation_action_update_result_idx', 'client_balance_operation_action', ['update_result'], unique=False)
    op.create_index('client_balance_operation_action_client_id_idx', 'client_balance_operation_action', ['client_id'], unique=False)
    op.drop_index(op.f('ix_client_balance_operation_action_update_result'), table_name='client_balance_operation_action')
    op.drop_index(op.f('ix_client_balance_operation_action_client_id'), table_name='client_balance_operation_action')
    op.drop_constraint(None, 'client', type_='foreignkey')
    op.create_index('client_term_rate_table_id_idx', 'client', ['term_rate_table_id'], unique=False)
    op.create_index('client_role_id_idx', 'client', ['role_id'], unique=False)
    op.create_index('client_payment_term_id_idx', 'client', ['payment_term_id'], unique=False)
    op.create_index('client_orig_rate_table_id_idx', 'client', ['orig_rate_table_id'], unique=False)
    op.create_index('client_group_id_idx', 'client', ['group_id'], unique=False)
    op.create_index('client_currency_id_idx', 'client', ['currency_id'], unique=False)
    op.drop_index(op.f('ix_client_term_rate_table_id'), table_name='client')
    op.drop_index(op.f('ix_client_role_id'), table_name='client')
    op.drop_index(op.f('ix_client_payment_term_id'), table_name='client')
    op.drop_index(op.f('ix_client_orig_rate_table_id'), table_name='client')
    op.drop_index(op.f('ix_client_group_id'), table_name='client')
    op.drop_index(op.f('ix_client_currency_id'), table_name='client')
    op.alter_column('client', 'profit_type',
               existing_type=sa.INTEGER(),
               nullable=False,
               existing_server_default=sa.text('1'))
    op.create_index('c4_livecall_user_name_idx', 'c4_livecall_user', ['name'], unique=False)
    op.drop_index(op.f('ix_c4_livecall_user_name'), table_name='c4_livecall_user')
    op.create_index('c4_client_balance_client_id_idx', 'c4_client_balance', ['client_id'], unique=False)
    op.drop_index(op.f('ix_c4_client_balance_client_id'), table_name='c4_client_balance')
    op.create_index('balance_history_actual_date_idx', 'balance_history_actual', ['date'], unique=False)
    op.drop_index(op.f('ix_balance_history_actual_date'), table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    op.create_index('balance_history_date_idx', 'balance_history', ['date'], unique=False)
    op.create_index('balance_daily_reset_task_status_idx', 'balance_daily_reset_task', ['status'], unique=False)
    op.alter_column('balance_daily_reset_task', 'status',
               existing_type=sa.SMALLINT(),
               nullable=False,
               existing_server_default=sa.text('0'))
    op.alter_column('balance_daily_reset_task', 'create_time',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=True,
               existing_server_default=sa.text("('now'::text)::timestamp(0) with time zone"))
    op.drop_constraint(None, 'agent', type_='unique')
    op.drop_constraint(None, 'agent', type_='unique')
    op.alter_column('agent', 'method_type',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.alter_column('agent', 'frequency_type',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.alter_column('agent', 'email',
               existing_type=sa.VARCHAR(length=200),
               nullable=True)
    op.alter_column('agent', 'create_on',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=True)
    op.alter_column('agent', 'agent_name',
               existing_type=sa.VARCHAR(length=100),
               nullable=True)
    op.create_table('cdr_report_detail20170715',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('lnp_cost', sa.NUMERIC(precision=15, scale=8), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_18s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_24s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_2h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_3h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_4h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_12s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('product_rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('incoming_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('outgoing_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('inter_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('npr_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.Column('ingress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ring_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.CheckConstraint("(report_time >= '2017-07-15 00:00:00+00'::timestamp with time zone) AND (report_time < '2017-07-16 00:00:00+00'::timestamp with time zone)", name='timecheck')
    )
    op.create_table('agent_client',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('commission', sa.NUMERIC(precision=5, scale=2), autoincrement=False, nullable=True),
    sa.Column('update_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('method_type', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['agent_id'], ['agent.agent_id'], name='fkey_agent_client_agent_agent_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='fkey_agent_client_client_client_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='agent_client_pkey')
    )
    op.create_table('cdr_report_detail20170923',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('lnp_cost', sa.NUMERIC(precision=15, scale=8), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_18s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_24s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_2h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_3h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_4h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_12s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('product_rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('incoming_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('outgoing_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('inter_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('npr_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.Column('ingress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ring_pdd', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_table('captcha',
    sa.Column('captcha_id', sa.INTEGER(), nullable=False),
    sa.Column('captcha_time', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('ip_address', sa.VARCHAR(length=16), autoincrement=False, nullable=False),
    sa.Column('word', sa.VARCHAR(length=20), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('captcha_id', name='captcha_pkey')
    )
    op.create_table('cdr_report_detail20170920',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('lnp_cost', sa.NUMERIC(precision=15, scale=8), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_18s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_24s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_2h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_3h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_4h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_12s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('product_rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('incoming_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('outgoing_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('inter_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('npr_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.Column('ingress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ring_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.CheckConstraint("(report_time >= '2017-09-20 00:00:00+00'::timestamp with time zone) AND (report_time < '2017-09-21 00:00:00+00'::timestamp with time zone)", name='timecheck')
    )
    op.create_table('carrier',
    sa.Column('carrier_id', sa.INTEGER(), nullable=False),
    sa.Column('carrier_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('is_prepay', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('payment_term', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('credit_limit', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('enable_auto_invoice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('enable_low_balance', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('invoice_format', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('company_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('address', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('username', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('carrier_id', name='carrier_pkey')
    )
    op.create_table('cdr_report_detail20170922',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('lnp_cost', sa.NUMERIC(precision=15, scale=8), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_18s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_24s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_2h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_3h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_4h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_12s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('product_rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('incoming_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('outgoing_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('inter_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('npr_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.Column('ingress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ring_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.CheckConstraint("(report_time >= '2017-09-22 00:00:00+00'::timestamp with time zone) AND (report_time < '2017-09-23 00:00:00+00'::timestamp with time zone)", name='timecheck')
    )
    op.create_table('api_permissions',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('role_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('entity_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('read', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('write', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['role_id'], ['role.role_id'], name='api_permissions_role_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='api_permissions_pkey'),
    sa.UniqueConstraint('role_id', 'entity_id', name='api_permissions_role_id_entity_id_key')
    )
    op.drop_index(op.f('ix_auto_rate_import_rule_egress_trunk_id'), table_name='auto_rate_import_rule')
    op.drop_table('auto_rate_import_rule')
    # ### end Alembic commands ###
