"""missing sql to migration

Revision ID: 4d9182082105
Revises: 1fc4d2e74474
Create Date: 2024-06-01 19:09:28.654060

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '4d9182082105'
down_revision = '1fc4d2e74474'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # ### end Alembic commands ###
    connection = op.get_bind()
    connection.execute("""
    DROP TABLE IF EXISTS cdr_report_daily;
    CREATE TABLE if not exists public.cdr_report_daily (
        id bigint NOT NULL,
        cdr_date character varying NOT NULL,
        report_time timestamp without time zone NOT NULL,
        ingress_client_id integer,
        ingress_id integer,
        egress_client_id integer,
        egress_id integer,
        ingress_code_name character varying,
        egress_code_name character varying,
        ingress_total_calls integer,
        ingress_success_calls integer,
        ingress_busy_calls integer,
        ingress_cancel_calls integer,
        ingress_bill_time integer,
        ingress_bill_time_intra integer,
        ingress_bill_time_inter integer,
        ingress_call_cost real,
        ingress_call_cost_intra real,
        ingress_call_cost_inter real,
        ingress_call_cost_local real,
        ingress_call_cost_ij real,
        ingress_duration integer,
        ingress_duration_6 integer,
        ingress_duration_30 integer,
        ingress_inter_duration integer,
        ingress_intra_duration integer,
        ingress_not_zero_calls integer,
        ingress_not_zero_calls_6 integer,
        ingress_not_zero_calls_30 integer,
        ingress_inter_not_zero_calls integer,
        ingress_intra_not_zero_calls integer,
        ingress_call_12s integer,
        ingress_call_18s integer,
        ingress_call_24s integer,
        ingress_call_2h integer,
        ingress_call_3h integer,
        ingress_call_4h integer,
        egress_total_calls integer,
        egress_success_calls integer,
        egress_busy_calls integer,
        egress_cancel_calls integer,
        egress_bill_time integer,
        egress_bill_time_intra integer,
        egress_bill_time_inter integer,
        egress_call_cost real,
        egress_call_cost_intra real,
        egress_call_cost_inter real,
        egress_call_cost_local real,
        egress_call_cost_ij real,
        duration integer,
        duration_6 integer,
        duration_30 integer,
        inter_duration integer,
        intra_duration integer,
        not_zero_calls integer,
        not_zero_calls_6 integer,
        not_zero_calls_30 integer,
        inter_not_zero_calls integer,
        intra_not_zero_calls integer,
        call_12s integer,
        call_18s integer,
        call_24s integer,
        call_2h integer,
        call_3h integer,
        call_4h integer,
        agent_cost real,
        inter_ingress_total_calls integer,
        intra_ingress_total_calls integer,
        npr_count integer,
        egress_no_ring integer,
        pdd integer,
        q850_cause_count integer,
        orig_shaken_ocn text,
        orig_shaken_lvl character varying (1),
        term_shaken_ocn text,
        term_shaken_lvl character varying (1)
    )
    PARTITION BY RANGE (report_time);
    CREATE SEQUENCE IF NOT EXISTS public.cdr_report_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
   ALTER TABLE ONLY public.cdr_report_daily OWNER TO class4_user;
   ALTER TABLE ONLY public.cdr_report_daily_id_seq OWNER TO class4_user;
   ALTER TABLE ONLY public.cdr_report_daily ALTER COLUMN id SET DEFAULT nextval('public.cdr_report_daily_id_seq'::regclass);
   ALTER SEQUENCE public.cdr_report_daily_id_seq OWNED BY public.cdr_report_daily.id;
   CREATE INDEX IF NOT EXISTS cdr_report_daily_report_time_idx ON ONLY public.cdr_report_daily USING btree (report_time);
   

""")
    connection.execute("""CREATE TABLE if not exists public.code_report (
        id bigint NOT NULL,
        cdr_date character varying NOT NULL,
        report_time timestamp without time zone NOT NULL,
        code character varying NOT NULL,
        ingress_client_id integer,
        ingress_id integer,
        egress_client_id integer,
        egress_id integer,
        not_zero_calls integer,
        total_calls integer,
        ingress_not_zero_calls integer,
        ingress_total_calls integer
    )
    PARTITION BY RANGE (report_time);
    CREATE SEQUENCE IF NOT EXISTS public.code_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
    ALTER TABLE public.code_report_id_seq OWNER TO class4_user;
    ALTER TABLE public.code_report OWNER TO class4_user;
    ALTER SEQUENCE public.code_report_id_seq OWNED BY public.code_report.id;
    ALTER TABLE ONLY public.code_report ALTER COLUMN id SET DEFAULT nextval('public.code_report_id_seq'::regclass);
    CREATE INDEX IF NOT EXISTS code_report_report_time_idx ON ONLY public.code_report USING btree (report_time);
   
    """)
    connection.execute("""CREATE TABLE if not exists public.code_report_daily (
        id bigint NOT NULL,
        cdr_date character varying NOT NULL,
        report_time timestamp without time zone NOT NULL,
        code character varying NOT NULL,
        ingress_client_id integer,
        ingress_id integer,
        egress_client_id integer,
        egress_id integer,
        not_zero_calls integer,
        total_calls integer,
        ingress_not_zero_calls integer,
        ingress_total_calls integer
    )
    PARTITION BY RANGE (report_time);
    CREATE SEQUENCE IF NOT EXISTS public.code_report_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
    ALTER TABLE public.code_report_daily_id_seq OWNER TO class4_user;
    ALTER TABLE public.code_report_daily OWNER TO class4_user;
    ALTER SEQUENCE public.code_report_daily_id_seq OWNED BY public.code_report_daily.id;
    ALTER TABLE ONLY public.code_report_daily ALTER COLUMN id SET DEFAULT nextval('public.code_report_daily_id_seq'::regclass);
    CREATE INDEX IF NOT EXISTS code_report_daily_report_time_idx ON ONLY public.code_report_daily USING btree (report_time);
    """)
    op.create_table('shaken_sti_sp_conf',
    sa.Column('id', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('priv_key', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('passphrase', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('x5u', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('enabled', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=False),
    sa.CheckConstraint('id = true', name='shaken_sti_sp_conf_id_check'),
    sa.UniqueConstraint('id', name='shaken_sti_sp_conf_id_key')
    )
    op.create_table('shaken_sti_sp_conf_record',
    sa.Column('id', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('priv_key', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('passphrase', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('x5u', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('enabled', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=False),
    sa.CheckConstraint('id = true', name='shaken_sti_sp_conf_id_check'),
    sa.UniqueConstraint('id', name='shaken_sti_sp_conf_record_id_key')
    )

    connection.execute("ALTER TABLE public.cdr_report_daily OWNER TO class4_user;")
    connection.execute("ALTER TABLE public.code_report OWNER TO class4_user;")
    connection.execute("ALTER TABLE public.code_report_daily OWNER TO class4_user;")
    connection.execute("ALTER TABLE shaken_sti_sp_conf OWNER TO class4_user;")

    connection.execute("""
    DROP TABLE if exists public.did_transaction;
    CREATE TABLE if not exists public.did_transaction (
        id integer NOT NULL,
        date timestamp with time zone DEFAULT now() NOT NULL,
        did_number character varying(50) NOT NULL,
        client_id integer NOT NULL,
        mrc numeric,
        nrc numeric,
        port_fee numeric,
        created_on timestamp with time zone DEFAULT now() NOT NULL
    )
    PARTITION BY RANGE (date);
    DROP SEQUENCE IF EXISTS  public.did_transaction_id_seq;
    CREATE SEQUENCE IF NOT EXISTS public.did_transaction_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
    ALTER TABLE public.did_transaction_id_seq OWNER TO class4_user;
    ALTER TABLE public.did_transaction OWNER TO class4_user;
    ALTER TABLE ONLY public.did_transaction ALTER COLUMN id SET DEFAULT nextval('public.did_transaction_id_seq'::regclass);
    ALTER TABLE ONLY public.did_transaction ADD CONSTRAINT did_transaction_pkey PRIMARY KEY (id, date);
    CREATE INDEX IF NOT EXISTS did_transaction_client_id_idx ON ONLY public.did_transaction USING btree (client_id);
    CREATE INDEX IF NOT EXISTS did_transaction_date_idx ON ONLY public.did_transaction USING btree (date);
    """)
    connection.execute("""
    DROP TABLE if exists public.did_assignments_log;
    CREATE TABLE public.did_assignments_log (
        id bigint NOT NULL,
        did character varying(50),
        vendor_trunk_id integer,
        vendor_billing_plan_id integer,
        client_trunk_id integer,
        client_billing_plan_id integer,
        fallback_id integer,
        created_at date NOT NULL,
        created_by integer,
        deleted_at date,
        deleted_by integer
    )
    PARTITION BY RANGE (created_at);
    CREATE SEQUENCE IF NOT EXISTS public.did_assignments_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
    ALTER TABLE public.did_assignments_log_id_seq OWNER TO class4_user;
    ALTER TABLE public.did_assignments_log OWNER TO class4_user;
    ALTER TABLE public.did_assignments_log ALTER COLUMN id SET DEFAULT nextval('public.did_assignments_log_id_seq'::regclass);
    ALTER TABLE ONLY public.did_assignments_log ADD CONSTRAINT did_assignments_log_pkey PRIMARY KEY (id, created_at);
    CREATE INDEX IF NOT EXISTS ix_did_assignments_log_created_at ON ONLY public.did_assignments_log USING btree (created_at);
    """)
    connection.execute("""
    DROP TABLE if exists public.did_repository_log;
    CREATE TABLE public.did_repository_log (
        id bigint NOT NULL,
        did character varying(50),
        vendor_trunk_id integer,
        vendor_billing_plan_id integer,
        created_at date NOT NULL,
        created_by integer,
        deleted_at date,
        deleted_by integer
    )
    PARTITION BY RANGE (created_at);
    CREATE SEQUENCE IF NOT EXISTS public.did_repository_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
    ALTER TABLE public.did_repository_log_id_seq OWNER TO class4_user;
    ALTER TABLE public.did_repository_log OWNER TO class4_user;
    ALTER SEQUENCE public.did_repository_log_id_seq OWNED BY public.did_repository_log.id;
    ALTER TABLE ONLY public.did_repository_log ALTER COLUMN id SET DEFAULT nextval('public.did_repository_log_id_seq'::regclass);
    ALTER TABLE ONLY public.did_repository_log ADD CONSTRAINT did_repository_log_pkey PRIMARY KEY (id, created_at);
    CREATE INDEX IF NOT EXISTS ix_did_repository_log_created_at ON ONLY public.did_repository_log USING btree (created_at);
     """)

    up_rec('shaken_sti_sp_conf')



def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('code_report_daily')
    op.drop_table('code_report')
    op.drop_table('cdr_report_daily')
    op.drop_table('shaken_sti_sp_conf')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger if exists class4_trig_record_{table} on {table};
drop table if exists {table}_record;
DROP FUNCTION if exists class4_trigfun_record_{table}();
DROP SEQUENCE if exists {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE IF NOT EXISTS {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index IF NOT EXISTS c4_{table}_record_id_idx on {table}_record (record_id);
create index IF NOT EXISTS {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))
