"""schema and existing data changes

Revision ID: 541e01458586
Revises: 79fe4181f801
Create Date: 2024-09-23 05:32:41.014293

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '541e01458586'
down_revision = '79fe4181f801'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # ### end Alembic commands ###
    return
    connection = op.get_bind()
    connection.execute(r"""
        DECLARE
            _rec record;
        BEGIN
            FOR _rec IN
                SELECT DISTINCT resource_id FROM resource_record WHERE client_id NOT IN (SELECT client_id FROM client)
            LOOP
                DELETE FROM did_assignments WHERE client_trunk_id = _rec.resource_id OR vendor_trunk_id = _rec.resource_id;
                DELETE FROM did_assignments_log WHERE client_trunk_id = _rec.resource_id OR vendor_trunk_id = _rec.resource_id;
                DELETE FROM did_repository WHERE vendor_trunk_id = _rec.resource_id;
                DELETE FROM did_repository_log WHERE vendor_trunk_id = _rec.resource_id;
                DELETE FROM did_transaction WHERE client_id = _rec.resource_id;
            END LOOP;
        END $remove_deleted_clients$ LANGUAGE plpgsql;


        -- Tbl: did_repository
        --

        -- link to client
        ALTER TABLE did_repository ADD COLUMN vendor_id integer REFERENCES client(client_id) ON DELETE RESTRICT;
        UPDATE did_repository SET vendor_id = resource.client_id FROM resource
        WHERE did_repository.vendor_trunk_id = resource.resource_id;
        UPDATE did_repository SET vendor_id = res.client_id FROM resource_record AS res
        WHERE vendor_id IS NULL AND vendor_trunk_id = res.resource_id AND res.client_id IS NOT NULL;
        ALTER TABLE did_repository ALTER COLUMN vendor_id SET NOT NULL;
        -- Restrict trunk removal
        ALTER TABLE did_repository ADD CONSTRAINT fk_did_repository_vendor_trunk_id
        FOREIGN KEY (vendor_trunk_id) REFERENCES resource(resource_id) ON DELETE RESTRICT;
        -- Restrict billing plan removal
        ALTER TABLE did_repository ADD CONSTRAINT fk_did_repository_vendor_billing_plan_id
        FOREIGN KEY (vendor_billing_plan_id) REFERENCES did_billing_plan(id) ON DELETE RESTRICT;

        -- Tbl: did_assignments
        --

        -- link to client
        ALTER TABLE did_assignments ADD COLUMN client_id bigint REFERENCES client(client_id);
        UPDATE did_assignments SET client_id = res.client_id FROM resource AS res
        WHERE client_trunk_id = res.resource_id;
        UPDATE did_assignments SET client_id = res.client_id FROM resource_record AS res
        WHERE did_assignments.client_id IS NULL AND client_trunk_id = res.resource_id AND res.client_id IS NOT NULL;
        ALTER TABLE did_assignments ALTER COLUMN client_id SET NOT NULL;
        -- link to vendor
        ALTER TABLE did_assignments ADD COLUMN vendor_id bigint REFERENCES client(client_id);
        UPDATE did_assignments SET vendor_id = res.client_id FROM resource AS res
        WHERE vendor_trunk_id = res.resource_id;
        UPDATE did_assignments SET vendor_id = res.client_id FROM resource_record AS res
        WHERE vendor_id IS NULL AND vendor_trunk_id = res.resource_id AND res.client_id IS NOT NULL;
        ALTER TABLE did_assignments ALTER COLUMN vendor_id SET NOT NULL;
        -- billing info snapshot at the time of the assignent
        ALTER TABLE did_assignments ADD COLUMN vendor_mrc_cycle integer;
        ALTER TABLE did_assignments ADD COLUMN vendor_mrc numeric;
        ALTER TABLE did_assignments ADD COLUMN vendor_nrc numeric;
        ALTER TABLE did_assignments ADD COLUMN client_mrc_cycle integer;
        ALTER TABLE did_assignments ADD COLUMN client_mrc numeric;
        ALTER TABLE did_assignments ADD COLUMN client_nrc numeric;
        -- Restrict trunk deletion
        ALTER TABLE did_assignments ADD CONSTRAINT fk_did_assignments_vendor_trunk_id
        FOREIGN KEY (vendor_trunk_id) REFERENCES resource(resource_id) ON DELETE RESTRICT;
        ALTER TABLE did_assignments ADD CONSTRAINT fk_did_assignments_client_trunk_id
        FOREIGN KEY (client_trunk_id) REFERENCES resource(resource_id) ON DELETE RESTRICT;
        ALTER TABLE did_assignments ADD CONSTRAINT fk_did_assignments_fallback_id
        FOREIGN KEY (fallback_id) REFERENCES resource(resource_id) ON DELETE RESTRICT;
        -- Restring billing data deletion
        ALTER TABLE did_assignments ADD CONSTRAINT fk_did_assignments_vendor_billing_plan_id
        FOREIGN KEY (vendor_billing_plan_id) REFERENCES did_billing_plan(id) ON DELETE RESTRICT;
        ALTER TABLE did_assignments ADD CONSTRAINT fk_did_assignments_client_billing_plan_id
        FOREIGN KEY (client_billing_plan_id) REFERENCES did_billing_plan(id) ON DELETE RESTRICT;

        -- Tbl: did_repository_log
        --

        -- Add link to vendor
        ALTER TABLE did_repository_log ADD COLUMN vendor_id integer;
        -- Use timestamps instead of dates
        ALTER TABLE did_repository_log ADD COLUMN created_at_time timestamp with time zone;
        ALTER TABLE did_repository_log ADD COLUMN deleted_at_time timestamp with time zone;

        -- Tbl: did_assignments_log
        --
        ALTER TABLE did_assignments_log ADD COLUMN vendor_id integer;
        ALTER TABLE did_assignments_log ADD COLUMN vendor_mrc numeric;
        ALTER TABLE did_assignments_log ADD COLUMN vendor_mrc_cycle integer;
        ALTER TABLE did_assignments_log ADD COLUMN vendor_nrc numeric;
        ALTER TABLE did_assignments_log ADD COLUMN client_id integer;
        ALTER TABLE did_assignments_log ADD COLUMN client_mrc numeric;
        ALTER TABLE did_assignments_log ADD COLUMN client_mrc_cycle integer;
        ALTER TABLE did_assignments_log ADD COLUMN client_nrc numeric;
        -- Use timestamps instead of dates
        ALTER TABLE did_assignments_log ADD COLUMN created_at_time timestamp with time zone;
        ALTER TABLE did_assignments_log ADD COLUMN deleted_at_time timestamp with time zone;

        -- Delete port fees from everywhere
        ALTER TABLE did_billing_plan DROP COLUMN fee_per_port;
        ALTER TABLE did_billing_plan_record DROP COLUMN fee_per_port;
        ALTER TABLE did_transaction DROP COLUMN port_fee;


        --
        -- Set default currency id in client table
        --
        ALTER TABLE client ALTER COLUMN currency_id SET DEFAULT 1;

        --
        -- Drop unnecessary triggers
        --
        DROP TRIGGER class4_trig_client_cdr_insert ON client_cdr;
        DROP FUNCTION class4_trigfun_cdr_insert;

        DROP TRIGGER class4_trig_client_report_detail_insert ON cdr_report_detail;
        DROP FUNCTION class4_trigfun_report_detail_insert;

        DROP TRIGGER class4_trig_did_report_insert ON did_report;
        DROP FUNCTION class4_trigfun_did_report_insert;

        DROP TRIGGER class4_trig_chost_based_report_insert ON host_based_report;
        DROP FUNCTION class4_trigfun_host_based_report_insert;

        --
        -- [SIPSWITCH-553] Database version for backend
        --
        CREATE TABLE c4db_version (
            id integer NOT NULL DEFAULT 1 UNIQUE,
            version_num text NOT NULL,
            tag text,
            CHECK (id = 1)
        );

        ALTER TABLE c4db_version OWNER TO class4_user;

        INSERT INTO c4db_version (version_num, tag)
        VALUES ('d5747a7be8a3354e2900b23e27c6c5e5', '7.4.2');

        COMMIT;
    """)
    connection.execute(r"""
        DECLARE
            count INT;
        BEGIN
            RAISE INFO 'Updating did_assignments';

            -- vendor billing info
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE vendor_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty vendor billing info: % rows', count;
                RAISE INFO '-- Trying did_billing_plan table';
                EXECUTE 'UPDATE did_assignments SET vendor_mrc_cycle = plan.price_type
                        FROM did_billing_plan AS plan
                        WHERE vendor_mrc_cycle IS NULL AND vendor_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE vendor_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty vendor billing info: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan_record table';
                EXECUTE 'UPDATE did_assignments SET vendor_mrc_cycle = plan.price_type
                        FROM did_billing_plan_record AS plan
                        WHERE vendor_mrc_cycle IS NULL AND vendor_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE vendor_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments.vendor_mrc_cycle from did_billing_plan and did_billing_plan_record tables (% rows left)', count;
            END IF;

            -- vendor prices
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty vendor prices: % rows', count;
                RAISE INFO '-- Trying did_transaction table';
                EXECUTE 'UPDATE did_assignments SET vendor_mrc = tx.mrc, vendor_nrc = tx.nrc
                        FROM did_transaction AS tx
                        WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL
                        AND vendor_id = tx.client_id AND did = tx.did_number AND created_at::date = tx.date';
            END IF;

            EXECUTE 'SELECT count(*) FROM did_assignments WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty vendor billing prices: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan_record table';
                EXECUTE 'UPDATE did_assignments
                        SET vendor_mrc = plan.monthly_charge, vendor_nrc = plan.did_price
                        FROM did_billing_plan_record AS plan
                        WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL
                        AND vendor_billing_plan_id = plan.id
                        AND to_timestamp(plan.time)::date <= created_at';
            END IF;

            EXECUTE 'SELECT count(*) FROM did_assignments WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty vendor prices: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan table';
                EXECUTE 'UPDATE did_assignments
                        SET vendor_mrc = plan.monthly_charge, vendor_nrc = plan.did_price
                        FROM did_billing_plan AS plan
                        WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL
                        AND vendor_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments.vendor_mrc, did_assignments.vendor_nrc from did_transaction and did_billing_plan tables (% rows left)', count;
            END IF;

            -- client billing info
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE client_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty client billing info: % rows', count;
                RAISE INFO '-- Trying did_billing_plan table';
                EXECUTE 'UPDATE did_assignments SET client_mrc_cycle = plan.price_type
                        FROM did_billing_plan AS plan
                        WHERE client_mrc_cycle IS NULL AND client_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE client_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty client billing info: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan_record table';
                EXECUTE 'UPDATE did_assignments SET client_mrc_cycle = plan.price_type
                        FROM did_billing_plan_record AS plan
                        WHERE client_mrc_cycle IS NULL AND client_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE client_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments.client_mrc_cycle from did_billing_plan and did_billing_plan_record tables (% rows left)', count;
            END IF;

            -- client prices
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE client_mrc IS NULL AND client_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty client prices: % rows', count;
                RAISE INFO '-- Trying did_transaction table';
                EXECUTE 'UPDATE did_assignments SET client_mrc = tx.mrc, client_nrc = tx.nrc
                        FROM did_transaction AS tx
                        WHERE client_mrc IS NULL AND client_nrc IS NULL
                        AND did_assignments.client_id = tx.client_id AND did = tx.did_number AND created_at::date = tx.date';
            END IF;

            EXECUTE 'SELECT count(*) FROM did_assignments WHERE client_mrc IS NULL AND client_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty client billing prices: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan_record table';
                EXECUTE 'UPDATE did_assignments
                        SET client_mrc = plan.monthly_charge, client_nrc = plan.did_price
                        FROM did_billing_plan_record AS plan
                        WHERE client_mrc IS NULL AND client_nrc IS NULL
                        AND client_billing_plan_id = plan.id
                        AND to_timestamp(plan.time)::date <= created_at';
            END IF;

            EXECUTE 'SELECT count(*) FROM did_assignments WHERE client_mrc IS NULL AND client_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty client prices: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan table';
                EXECUTE 'UPDATE did_assignments
                        SET client_mrc = plan.monthly_charge, client_nrc = plan.did_price
                        FROM did_billing_plan AS plan
                        WHERE client_mrc IS NULL AND client_nrc IS NULL
                        AND client_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments WHERE client_mrc IS NULL AND client_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments.client_mrc, did_assignments.client_nrc from did_transaction and did_billing_plan tables (% rows left)', count;
            END IF;

        END $update_did_assignments$ LANGUAGE plpgsql;

        -- Table: did_assignments_log
        DECLARE
            count INT;
        BEGIN
            RAISE INFO 'Updating did_assignments_log';

            -- vendor_id
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_id IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty vendor_id: % rows', count;
                RAISE INFO '-- Trying resource table';
                EXECUTE 'UPDATE did_assignments_log SET vendor_id = res.client_id
                        FROM resource AS res
                        WHERE vendor_id IS NULL
                        AND vendor_trunk_id = res.resource_id AND res.client_id IS NOT NULL';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_id IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty vendor_id: % rows', count;
                RAISE WARNING '-- Trying resource_record table';
                EXECUTE 'UPDATE did_assignments_log SET vendor_id = res.client_id
                        FROM resource_record AS res
                        WHERE vendor_id IS NULL
                        AND vendor_trunk_id = res.resource_id AND res.client_id IS NOT NULL';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_id IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments_log.vendor_id from resource and resource_record tables (% rows left)', count;
            END IF;

            -- vendor billing info
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty vendor billing info: % rows', count;
                RAISE INFO '-- Trying did_billing_plan table';
                EXECUTE 'UPDATE did_assignments_log SET vendor_mrc_cycle = plan.price_type
                        FROM did_billing_plan AS plan
                        WHERE vendor_mrc_cycle IS NULL AND vendor_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty vendor billing info: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan_record table';
                EXECUTE 'UPDATE did_assignments_log SET vendor_mrc_cycle = plan.price_type
                        FROM did_billing_plan_record AS plan
                        WHERE vendor_mrc_cycle IS NULL AND vendor_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments_log.vendor_mrc_cycle from did_billing_plan and did_billing_plan_record tables (% rows left)', count;
            END IF;

            -- vendor prices
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty vendor prices: % rows', count;
                RAISE INFO '-- Trying did_transaction table';
                EXECUTE 'UPDATE did_assignments_log SET vendor_mrc = tx.mrc, vendor_nrc = tx.nrc
                        FROM did_transaction AS tx
                        WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL
                        AND vendor_id = tx.client_id AND did = tx.did_number AND created_at::date = tx.date';
            END IF;

            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty vendor billing prices: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan_record table';
                EXECUTE 'UPDATE did_assignments_log
                        SET vendor_mrc = plan.monthly_charge, vendor_nrc = plan.did_price
                        FROM did_billing_plan_record AS plan
                        WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL
                        AND vendor_billing_plan_id = plan.id
                        AND to_timestamp(plan.time)::date <= created_at';
            END IF;

            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty vendor prices: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan table';
                EXECUTE 'UPDATE did_assignments_log
                        SET vendor_mrc = plan.monthly_charge, vendor_nrc = plan.did_price
                        FROM did_billing_plan AS plan
                        WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL
                        AND vendor_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE vendor_mrc IS NULL AND vendor_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments_log.vendor_mrc, did_assignments_log.vendor_nrc from did_transaction and did_billing_plan tables (% rows left)', count;
            END IF;

            -- client_id
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_id IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty client_id: % rows', count;
                RAISE INFO '-- Trying resource table';
                EXECUTE 'UPDATE did_assignments_log SET client_id = res.client_id
                        FROM resource AS res
                        WHERE did_assignments_log.client_id IS NULL
                        AND client_trunk_id = res.resource_id AND res.client_id IS NOT NULL';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_id IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty client_id: % rows', count;
                RAISE WARNING '-- Trying resource_record table';
                EXECUTE 'UPDATE did_assignments_log SET client_id = res.client_id
                        FROM resource_record AS res
                        WHERE did_assignments_log.client_id IS NULL
                        AND client_trunk_id = res.resource_id AND res.client_id IS NOT NULL';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_id IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments_log.client_id from resource and resource_record tables (% rows left)', count;
            END IF;

            -- client billing info
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty client billing info: % rows', count;
                RAISE INFO '-- Trying did_billing_plan table';
                EXECUTE 'UPDATE did_assignments_log SET client_mrc_cycle = plan.price_type
                        FROM did_billing_plan AS plan
                        WHERE client_mrc_cycle IS NULL AND client_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty client billing info: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan_record table';
                EXECUTE 'UPDATE did_assignments_log SET client_mrc_cycle = plan.price_type
                        FROM did_billing_plan_record AS plan
                        WHERE client_mrc_cycle IS NULL AND client_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_mrc_cycle IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments_log.client_mrc_cycle from did_billing_plan and did_billing_plan_record tables (% rows left)', count;
            END IF;

            -- client prices
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_mrc IS NULL AND client_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE INFO '-- Empty client prices: % rows', count;
                RAISE INFO '-- Trying did_transaction table';
                EXECUTE 'UPDATE did_assignments_log SET client_mrc = tx.mrc, client_nrc = tx.nrc
                        FROM did_transaction AS tx
                        WHERE client_mrc IS NULL AND client_nrc IS NULL
                        AND did_assignments_log.client_id = tx.client_id AND did = tx.did_number AND created_at::date = tx.date';
            END IF;

            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_mrc IS NULL AND client_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty client billing prices: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan_record table';
                EXECUTE 'UPDATE did_assignments_log
                        SET client_mrc = plan.monthly_charge, client_nrc = plan.did_price
                        FROM did_billing_plan_record AS plan
                        WHERE client_mrc IS NULL AND client_nrc IS NULL
                        AND client_billing_plan_id = plan.id
                        AND to_timestamp(plan.time)::date <= created_at';
            END IF;

            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_mrc IS NULL AND client_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE WARNING '-- Still empty client prices: % rows', count;
                RAISE WARNING '-- Trying did_billing_plan table';
                EXECUTE 'UPDATE did_assignments_log
                        SET client_mrc = plan.monthly_charge, client_nrc = plan.did_price
                        FROM did_billing_plan AS plan
                        WHERE client_mrc IS NULL AND client_nrc IS NULL
                        AND client_billing_plan_id = plan.id';
            END IF;
            EXECUTE 'SELECT count(*) FROM did_assignments_log WHERE client_mrc IS NULL AND client_nrc IS NULL' INTO count;
            IF count > 0 THEN
                RAISE EXCEPTION 'Failed to fill did_assignments_log.client_mrc, did_assignments_log.client_nrc from did_transaction and did_billing_plan tables (% rows left)', count;
            END IF;
        END $update_did_assignments_log$ LANGUAGE plpgsql;
    """)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))