"""spam_traffic_ip

Revision ID: 5a0d61bdb7f2
Revises: a3b385d145de
Create Date: 2019-10-22 18:23:12.106604

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '5a0d61bdb7f2'
down_revision = 'a3b385d145de'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_spam_traffic_ip_ip', table_name='spam_traffic_ip')
    op.drop_table('spam_traffic_ip')
    op.create_table('spam_traffic_ip',
    sa.Column('ip', sa.VARCHAR(length=30), primary_key=True),
    sa.Column('brief', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('netmask', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_index('ix_spam_traffic_ip_ip', 'spam_traffic_ip', ['ip'], unique=False)

    # ### end Alembic commands ###
    up_rec('spam_traffic_ip')

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('spam_traffic_ip')
    op.create_table('spam_traffic_ip',
    sa.Column('ip', sa.VARCHAR(length=30), autoincrement=False, nullable=False),
    sa.Column('brief', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('netmask', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_index('ix_spam_traffic_ip_ip', 'spam_traffic_ip', ['ip'], unique=False)
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))