"""did_client_log table change

Revision ID: 5c6cd696b0ef
Revises: 4f6f6c088dce
Create Date: 2022-02-25 09:37:52.626148

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '5c6cd696b0ef'
down_revision = '4f6f6c088dce'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('did_client_log', sa.Column('created_on', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True))
    op.alter_column('did_client_log', 'released_on',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=False,
               server_default=sa.text('now()'))
    connection = op.get_bind()
    connection.execute(
"""
COMMENT ON COLUMN did_client_log.assign_method IS '0 - admin assign via UI/API 1 - admin assign via Import 2- client purchase from portal';
COMMENT ON COLUMN did_client_log.release_method IS '0 - admin release via UI/API 1 - admin release via UI/API 2 - client release via portal 3 - auto expiry due to end-date met';
""")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('did_client_log', 'released_on',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=True)
    op.drop_column('did_client_log', 'created_on')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))