"""resource_ip username unique

Revision ID: 7135e93fc1ea
Revises: 3de4ff9e83bf
Create Date: 2022-06-21 09:32:47.324662

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '7135e93fc1ea'
down_revision = '3de4ff9e83bf'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index('resource_ip_username_key', 'resource_ip', ['username'], unique=True, postgresql_where=sa.text('username IS NOT NULL'))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('resource_ip_username_key', table_name='resource_ip')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE if not exists {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))