"""NEW TABLES

Revision ID: 7e3959fcd0e2
Revises: 5d15626f8e3f
Create Date: 2019-09-06 21:30:54.482653

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '7e3959fcd0e2'
down_revision = '5d15626f8e3f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('banned_ip',
    sa.Column('ip', sa.String(length=30), nullable=False),
    sa.Column('brief', sa.String(length=100), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True)
    )
    op.create_index(op.f('ix_banned_ip_ip'), 'banned_ip', ['ip'], unique=False)
    op.create_table('block_number_import_task',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('operator_user', sa.String(length=40), nullable=True),
    sa.Column('import_file_path', sa.String(length=256), nullable=True),
    sa.Column('orig_import_file', sa.String(length=256), nullable=True),
    sa.Column('format_import_file', sa.String(length=256), nullable=True),
    sa.Column('import_log_path', sa.String(length=256), nullable=True),
    sa.Column('redup_in_block_rable_action', sa.SmallInteger(), server_default=sa.text('0'), nullable=False),
    sa.Column('redup_in_file_action', sa.SmallInteger(), server_default=sa.text('0'), nullable=False),
    sa.Column('status', sa.SmallInteger(), server_default=sa.text('0'), nullable=False),
    sa.Column('progress', sa.String(length=1024), nullable=True),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('c4_us_lerg',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('npa', sa.String(length=4), nullable=True),
    sa.Column('nxx', sa.String(length=4), nullable=True),
    sa.Column('block', sa.String(length=4), nullable=True),
    sa.Column('lata', sa.String(length=8), nullable=True),
    sa.Column('ocn', sa.String(length=8), nullable=True),
    sa.Column('ratecenter', sa.String(length=24), nullable=True),
    sa.Column('state', sa.String(length=4), nullable=True),
    sa.Column('category', sa.String(length=24), nullable=True),
    sa.Column('company', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index('c4_us_lerg_npanxx_block_idx', 'c4_us_lerg', ['npa', 'nxx', 'block'], unique=True)
    op.create_index('c4_us_lerg_npanxx_idx', 'c4_us_lerg', ['npa', 'nxx'], unique=False)
    op.create_index(op.f('ix_c4_us_lerg_lata'), 'c4_us_lerg', ['lata'], unique=False)
    op.create_index(op.f('ix_c4_us_lerg_ocn'), 'c4_us_lerg', ['ocn'], unique=False)
    op.create_table('frund_detection',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('rule_name', sa.String(length=100), nullable=True),
    sa.Column('trunk_id_list', sa.String(length=100), nullable=True),
    sa.Column('criteria_1hour_min', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('criteria_1hour_revenue', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('criteria_24hour_min', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('criteria_24hour_revenue', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('is_block', sa.Boolean(), nullable=True),
    sa.Column('send_email_type', sa.Integer(), nullable=True),
    sa.Column('email_from', sa.Integer(), nullable=True),
    sa.Column('email_ticket_subject', sa.String(length=200), nullable=True),
    sa.Column('email_ticket_content', sa.Text(), nullable=True),
    sa.Column('trigger_criteria_1hour_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('trigger_criteria_24hour_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_frund_detection_rule_name'), 'frund_detection', ['rule_name'], unique=False)
    op.create_table('frund_detection_history',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('frund_detection_id', sa.Integer(), nullable=True),
    sa.Column('ingress_id', sa.Integer(), nullable=True),
    sa.Column('block_type', sa.Integer(), nullable=True),
    sa.Column('criteria_1hour_min', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('criteria_1hour_revenue', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('criteria_24hour_min', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('criteria_24hour_revenue', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('actual_1h_minute', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('actual_24h_minute', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('actual_1h_revenue', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('actual_24h_revenue', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('is_block', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('send_email_type', sa.Integer(), nullable=True),
    sa.Column('is_send_email', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('partner_email_msg', sa.Text(), nullable=True),
    sa.Column('partner_email_status', sa.Boolean(), nullable=True),
    sa.Column('partner_email', sa.String(length=200), nullable=True),
    sa.Column('system_email_msg', sa.Text(), nullable=True),
    sa.Column('system_email_status', sa.Boolean(), nullable=True),
    sa.Column('system_email', sa.String(length=200), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_frund_detection_history_frund_detection_id'), 'frund_detection_history', ['frund_detection_id'], unique=False)
    op.create_table('monitored_rule',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('rule_name', sa.String(length=100), nullable=True),
    sa.Column('is_active', sa.Boolean(), server_default=sa.text('true'), nullable=False),
    sa.Column('is_ingress_trunk', sa.Boolean(), server_default=sa.text('true'), nullable=True),
    sa.Column('is_all_trunk', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('trunk_id_list', sa.String(length=200), nullable=True),
    sa.Column('include_codes', sa.String(length=500), nullable=True),
    sa.Column('exclude_codes', sa.String(length=500), nullable=True),
    sa.Column('monitored_type', sa.Integer(), server_default=sa.text('0'), nullable=True),
    sa.Column('acd_action', sa.SmallInteger(), nullable=True),
    sa.Column('acd_value', sa.Integer(), nullable=True),
    sa.Column('asr_action', sa.SmallInteger(), nullable=True),
    sa.Column('asr_value', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('sdp_action', sa.SmallInteger(), nullable=True),
    sa.Column('sdp_value', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('sdp_duation', sa.Integer(), nullable=True),
    sa.Column('pdd_action', sa.SmallInteger(), nullable=True),
    sa.Column('pdd_value', sa.Integer(), nullable=True),
    sa.Column('profit_action', sa.SmallInteger(), nullable=True),
    sa.Column('profit_value', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('revenue_action', sa.SmallInteger(), nullable=True),
    sa.Column('revenue_value', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True),
    sa.Column('min_call_attempt', sa.Integer(), nullable=True),
    sa.Column('exe_schedule_type', sa.SmallInteger(), nullable=True),
    sa.Column('specific_minutes', sa.Integer(), nullable=True),
    sa.Column('daily_run_time', sa.Time(), nullable=True),
    sa.Column('weekly_run_time', sa.Time(), nullable=True),
    sa.Column('run_day_of_week', sa.SmallInteger(), nullable=True),
    sa.Column('sample_size', sa.Integer(), server_default=sa.text('5'), nullable=False),
    sa.Column('is_block', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('is_auto_unblock', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('unblock_after_min', sa.Integer(), nullable=True),
    sa.Column('last_run_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('next_run_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('send_email_type', sa.Integer(), server_default=sa.text('3'), nullable=True),
    sa.Column('email_from', sa.Integer(), nullable=True),
    sa.Column('email_ticket_subject', sa.String(length=200), nullable=True),
    sa.Column('email_ticket_content', sa.Text(), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('monitored_rule_history',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('monitored_rule_id', sa.Integer(), nullable=True),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('is_ingress_trunk', sa.Boolean(), nullable=True),
    sa.Column('trunk_id', sa.Integer(), nullable=True),
    sa.Column('dnis', sa.String(length=64), nullable=True),
    sa.Column('ani', sa.String(length=64), nullable=True),
    sa.Column('code_name', sa.String(length=100), nullable=True),
    sa.Column('country', sa.String(length=100), nullable=True),
    sa.Column('code', sa.String(length=64), nullable=True),
    sa.Column('total_call', sa.Integer(), nullable=True),
    sa.Column('not_zero_call', sa.Integer(), nullable=True),
    sa.Column('sdp_call', sa.Integer(), nullable=True),
    sa.Column('call_duration', sa.Integer(), nullable=True),
    sa.Column('pdd', sa.Integer(), nullable=True),
    sa.Column('ingress_cost', api_dnl.migration_types.Numeric(length=30, collation=6), nullable=True),
    sa.Column('egress_cost', api_dnl.migration_types.Numeric(length=30, collation=6), nullable=True),
    sa.Column('block_id_list', sa.Text(), nullable=True),
    sa.Column('unblock_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('unblock_exe_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_monitored_rule_history_monitored_rule_id'), 'monitored_rule_history', ['monitored_rule_id'], unique=False)
    op.create_index(op.f('ix_monitored_rule_history_unblock_exe_time'), 'monitored_rule_history', ['unblock_exe_time'], unique=False)
    op.create_index(op.f('ix_monitored_rule_history_unblock_time'), 'monitored_rule_history', ['unblock_time'], unique=False)
    op.create_table('sip_404_number',
    sa.Column('number', sa.String(length=32), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.UniqueConstraint('number')
    )
    op.add_column('cdr_report_detail', sa.Column('dst_lata', sa.Integer(), nullable=True))
    op.add_column('cdr_report_detail', sa.Column('dst_ocn', sa.String(length=100), nullable=True))
    op.add_column('cdr_report_detail', sa.Column('lrn_lata', sa.Integer(), nullable=True))
    op.add_column('cdr_report_detail', sa.Column('lrn_ocn', sa.String(length=100), nullable=True))
    op.add_column('cdr_report_detail', sa.Column('src_lata', sa.Integer(), nullable=True))
    op.add_column('cdr_report_detail', sa.Column('src_ocn', sa.String(length=100), nullable=True))
    op.add_column('client_cdr', sa.Column('dst_lata', sa.Integer(), nullable=True))
    op.add_column('client_cdr', sa.Column('dst_ocn', sa.String(length=100), nullable=True))
    op.add_column('client_cdr', sa.Column('dst_rc', sa.String(length=100), nullable=True))
    op.add_column('client_cdr', sa.Column('lrn_lata', sa.Integer(), nullable=True))
    op.add_column('client_cdr', sa.Column('lrn_ocn', sa.String(length=100), nullable=True))
    op.add_column('client_cdr', sa.Column('lrn_rc', sa.String(length=100), nullable=True))
    op.add_column('client_cdr', sa.Column('src_lata', sa.Integer(), nullable=True))
    op.add_column('client_cdr', sa.Column('src_ocn', sa.String(length=100), nullable=True))
    op.add_column('client_cdr', sa.Column('src_rc', sa.String(length=100), nullable=True))
    op.add_column('host_based_report', sa.Column('ingress_duration', sa.Integer(), nullable=True))
    op.add_column('host_based_report', sa.Column('ingress_not_zero_calls', sa.Integer(), nullable=True))
    op.add_column('resource', sa.Column('priv_value', sa.Integer(), server_default=sa.text('0'), nullable=True))
    op.add_column('resource', sa.Column('use_sip404_ani', sa.Boolean(), server_default=sa.text('false'), nullable=True))
    op.add_column('resource_block', sa.Column('dnis_block_type', sa.SmallInteger(), nullable=True))
    # ### end Alembic commands ###
    up_rec('banned_ip')
    up_rec('resource')
    up_rec('sip_404_number')



def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('resource_block', 'dnis_block_type')
    op.drop_column('resource', 'use_sip404_ani')
    op.drop_column('resource', 'priv_value')
    op.drop_column('host_based_report', 'ingress_not_zero_calls')
    op.drop_column('host_based_report', 'ingress_duration')
    op.drop_column('client_cdr', 'src_rc')
    op.drop_column('client_cdr', 'src_ocn')
    op.drop_column('client_cdr', 'src_lata')
    op.drop_column('client_cdr', 'lrn_rc')
    op.drop_column('client_cdr', 'lrn_ocn')
    op.drop_column('client_cdr', 'lrn_lata')
    op.drop_column('client_cdr', 'dst_rc')
    op.drop_column('client_cdr', 'dst_ocn')
    op.drop_column('client_cdr', 'dst_lata')
    op.drop_column('cdr_report_detail', 'src_ocn')
    op.drop_column('cdr_report_detail', 'src_lata')
    op.drop_column('cdr_report_detail', 'lrn_ocn')
    op.drop_column('cdr_report_detail', 'lrn_lata')
    op.drop_column('cdr_report_detail', 'dst_ocn')
    op.drop_column('cdr_report_detail', 'dst_lata')
    op.drop_table('sip_404_number')
    op.drop_index(op.f('ix_monitored_rule_history_unblock_time'), table_name='monitored_rule_history')
    op.drop_index(op.f('ix_monitored_rule_history_unblock_exe_time'), table_name='monitored_rule_history')
    op.drop_index(op.f('ix_monitored_rule_history_monitored_rule_id'), table_name='monitored_rule_history')
    op.drop_table('monitored_rule_history')
    op.drop_table('monitored_rule')
    op.drop_index(op.f('ix_frund_detection_history_frund_detection_id'), table_name='frund_detection_history')
    op.drop_table('frund_detection_history')
    op.drop_index(op.f('ix_frund_detection_rule_name'), table_name='frund_detection')
    op.drop_table('frund_detection')
    op.drop_index(op.f('ix_c4_us_lerg_ocn'), table_name='c4_us_lerg')
    op.drop_index(op.f('ix_c4_us_lerg_lata'), table_name='c4_us_lerg')
    op.drop_index('c4_us_lerg_npanxx_idx', table_name='c4_us_lerg')
    op.drop_index('c4_us_lerg_npanxx_block_idx', table_name='c4_us_lerg')
    op.drop_table('c4_us_lerg')
    op.drop_table('block_number_import_task')
    op.drop_index(op.f('ix_banned_ip_ip'), table_name='banned_ip')
    op.drop_table('banned_ip')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))
