"""rate_upload

Revision ID: 88f56ef2a7d7
Revises: 0abd2d65e669
Create Date: 2017-12-28 00:59:24.367156

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '88f56ef2a7d7'
down_revision = '0abd2d65e669'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('rate_upload_values',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('task_id', sa.Integer(), nullable=True),
    sa.Column('Code', api_dnl.fields.prefix_range.PrefixRange(), server_default=sa.text("''::prefix_range"), nullable=True),
    sa.Column('Rate', falcon_rest.db.fields.numeric.Numeric(length=30, collation=10), nullable=True),
    sa.Column('Inter_rate', falcon_rest.db.fields.numeric.Numeric(length=30, collation=10), nullable=True),
    sa.Column('Intra_rate', falcon_rest.db.fields.numeric.Numeric(length=30, collation=10), nullable=True),
    sa.Column('Local_rate', falcon_rest.db.fields.numeric.Numeric(length=30, collation=10), nullable=True),
    sa.Column('Effective_date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('Min_time', sa.Integer(), server_default=sa.text('1'), nullable=False),
    sa.Column('Interval', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.Column('Code_name', sa.String(length=100), nullable=True),
    sa.Column('Country', sa.String(length=1000), nullable=True),
    sa.ForeignKeyConstraint(['task_id'], ['rate_upload_task.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_rate_upload_values_task_id'), 'rate_upload_values', ['task_id'], unique=False)
    op.add_column('rate_upload_task', sa.Column('code_name_match', sa.Boolean(), nullable=True))
    op.add_column('rate_upload_task', sa.Column('start_from', sa.Integer(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('rate_upload_task', 'start_from')
    op.drop_column('rate_upload_task', 'code_name_match')
    op.drop_index(op.f('ix_rate_upload_values_task_id'), table_name='rate_upload_values')
    op.drop_table('rate_upload_values')
    # ### end Alembic commands ###
