"""calling_call rev1

Revision ID: 9aac5344ebcb
Revises: 72b82a843a71
Create Date: 2018-05-05 22:51:36.939262

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '9aac5344ebcb'
down_revision = '72b82a843a71'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('calling_queue',
    sa.Column('qid', sa.BigInteger(), nullable=False),
    sa.Column('req_uuid', sa.String(length=36), nullable=False),
    sa.Column('call_id', sa.BigInteger(), nullable=False),
    sa.PrimaryKeyConstraint('qid'),
    sa.UniqueConstraint('req_uuid', 'call_id')
    )
    op.create_table('calling_request',
    sa.Column('req_uuid', sa.String(length=36), nullable=False),
    sa.Column('req_from_ip', sa.String(length=64), nullable=True),
    sa.Column('req_from_port', sa.Integer(), nullable=True),
    sa.Column('start_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=False),
    sa.Column('finish_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('total_call_cnt', sa.Integer(), nullable=False),
    sa.Column('complete_call_cnt', sa.Integer(), server_default=sa.text('0'), nullable=True),
    sa.Column('status', sa.String(length=64), nullable=True),
    sa.PrimaryKeyConstraint('req_uuid')
    )
    op.create_table('calling_track',
    sa.Column('uuid', sa.String(length=36), nullable=False),
    sa.Column('orig_filename', sa.String(length=256), nullable=True),
    sa.Column('create_by', sa.String(length=100), nullable=True),
    sa.Column('create_on', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=False),
    sa.PrimaryKeyConstraint('uuid')
    )
    op.create_table('calling_call',
    sa.Column('call_id', sa.BigInteger(), nullable=False),
    sa.Column('call_uuid', sa.String(length=36), nullable=True),
    sa.Column('req_uuid', sa.String(length=36), nullable=True),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('finish_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('dst_number', sa.String(length=128), nullable=False),
    sa.Column('track_uuid', sa.String(length=36), nullable=True),
    sa.Column('state', sa.SmallInteger(), nullable=False),
    sa.Column('pdd', sa.Integer(), nullable=True),
    sa.Column('ring_duration', sa.Integer(), nullable=True),
    sa.Column('call_duration', sa.Integer(), nullable=True),
    sa.Column('rbt_packet', sa.Integer(), nullable=True),
    sa.Column('call_packet', sa.Integer(), nullable=True),
    sa.Column('response_code', sa.Integer(), nullable=True),
    sa.Column('result', sa.String(length=512), nullable=True),
    sa.Column('rbt_audio_path', sa.String(length=256), nullable=True),
    sa.Column('call_audio_path', sa.String(length=256), nullable=True),
    sa.Column('sip_pcap_path', sa.String(length=256), nullable=True),
    sa.Column('caller_id', sa.String(length=128), nullable=True),
    sa.Column('pcap_stat', sa.String(length=1024), nullable=True),
    sa.Column('create_by', sa.String(length=100), nullable=True),
    sa.ForeignKeyConstraint(['req_uuid'], ['calling_request.req_uuid'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['track_uuid'], ['calling_track.uuid'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('call_id'),
    sa.UniqueConstraint('req_uuid', 'dst_number')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('calling_call')
    op.drop_table('calling_track')
    op.drop_table('calling_request')
    op.drop_table('calling_queue')
    # ### end Alembic commands ###
