"""cdr_async_task request_client_id

Revision ID: c2a18c18958a
Revises: 3a9e96a1a4fd
Create Date: 2019-09-17 20:36:47.518872

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'c2a18c18958a'
down_revision = '3a9e96a1a4fd'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('cdr_async_task', sa.Column('request_client_id', sa.Integer(), nullable=True))
    op.drop_constraint('cdr_async_task_client_id_fkey', 'cdr_async_task', type_='foreignkey')
    op.create_foreign_key(None, 'cdr_async_task', 'client', ['request_client_id'], ['client_id'], ondelete='CASCADE')
    op.drop_column('cdr_async_task', 'client_id')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('cdr_async_task', sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.drop_constraint(None, 'cdr_async_task', type_='foreignkey')
    op.create_foreign_key('cdr_async_task_client_id_fkey', 'cdr_async_task', 'client', ['client_id'], ['client_id'], ondelete='CASCADE')
    op.drop_column('cdr_async_task', 'request_client_id')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))