"""invoice_daily_detail

Revision ID: c604dc6e61dd
Revises: 75c10d159b43
Create Date: 2020-05-01 17:36:59.555377

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = 'c604dc6e61dd'
down_revision = '75c10d159b43'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute("create sequence invoice_daily_detail_id_seq")
    connection.execute("alter table invoice_daily_detail drop constraint invoice_daily_detail_pkey")
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('invoice_daily_detail', sa.Column('invoice_daily_detail_id', sa.Integer(), server_default=sa.text("nextval('invoice_daily_detail_id_seq')"), nullable=False,primary_key=True))

    connection.execute("alter table invoice_daily_detail add constraint invoice_daily_detail_pkey primary key (invoice_daily_detail_id)")
    op.alter_column('invoice_daily_detail', 'did_number',
               existing_type=sa.VARCHAR(length=64),
               nullable=True)
    op.alter_column('invoice_daily_detail', 'invoice_number',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.alter_column('invoice_daily_detail', 'report_date',
               existing_type=sa.DATE(),
               nullable=True)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('invoice_daily_detail', 'report_date',
               existing_type=sa.DATE(),
               nullable=False)
    op.alter_column('invoice_daily_detail', 'invoice_number',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.alter_column('invoice_daily_detail', 'did_number',
               existing_type=sa.VARCHAR(length=64),
               nullable=False)
    connection = op.get_bind()

    connection.execute("drop sequence invoice_daily_detail_id_seq")
    connection.execute("alter table invoice_daily_detail drop constraint invoice_daily_detail_pkey")
    connection.execute(
        "alter table invoice_daily_detail add constraint invoice_daily_detail_pkey primary key (report_date,invoice_number,did_number)")
    op.drop_column('invoice_daily_detail', 'invoice_daily_detail_id')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))