"""send cdr direct

Revision ID: c7fc6556cc6f
Revises: 1fd860c9d1d0
Create Date: 2018-03-06 17:44:28.511744

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'c7fc6556cc6f'
down_revision = '1fd860c9d1d0'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('send_cdr_direct',
    sa.Column('id', sa.String(length=16), nullable=False),
    sa.Column('subject', sa.String(length=200), nullable=True),
    sa.Column('html_content', sa.Text(), nullable=True),
    sa.Column('sender_id', sa.Integer(), nullable=True),
    sa.Column('cc_mail', sa.String(length=200), nullable=True),
    sa.Column('to_mail', sa.String(length=200), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['cdr_download_task.request_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['sender_id'], ['mail_sender.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id')
    )
    op.add_column('cdr_download_task', sa.Column('content', sa.Text(), nullable=True))
    op.add_column('cdr_download_task', sa.Column('mail_cc', sa.String(length=512), nullable=True))
    op.add_column('cdr_download_task', sa.Column('sender_id', sa.Integer(), nullable=True))
    op.add_column('cdr_download_task', sa.Column('subject', sa.String(length=512), nullable=True))
    op.create_foreign_key(None, 'cdr_download_task', 'mail_sender', ['sender_id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'cdr_download_task', type_='foreignkey')
    op.drop_column('cdr_download_task', 'subject')
    op.drop_column('cdr_download_task', 'sender_id')
    op.drop_column('cdr_download_task', 'mail_cc')
    op.drop_column('cdr_download_task', 'content')
    op.drop_table('send_cdr_direct')
    # ### end Alembic commands ###
