"""rate_upload_template

Revision ID: d95feef0e3e7
Revises: b8a9b1667191
Create Date: 2020-04-27 20:08:22.747167

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'd95feef0e3e7'
down_revision = 'b8a9b1667191'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('rate_upload_template', sa.Column('auto_ij_rate', api_dnl.migration_types.ChoiceType({}), nullable=True))
    op.add_column('rate_upload_template', sa.Column('code_deck_id', sa.Integer(), nullable=True))
    op.add_column('rate_upload_template', sa.Column('code_name_provider', api_dnl.migration_types.ChoiceType({}), server_default='0', nullable=False))
    op.add_column('rate_upload_template', sa.Column('effective_date', sa.DateTime(timezone=True), nullable=True))
    op.add_column('rate_upload_template', sa.Column('end_date_other_code_time', sa.DateTime(timezone=True), nullable=True))
    op.add_column('rate_upload_template', sa.Column('import_rate_date_format', sa.String(length=40), nullable=True))
    op.add_column('rate_upload_template', sa.Column('rate_table_id', sa.Integer(), nullable=True))
    op.add_column('rate_upload_template', sa.Column('redup_in_file_action', api_dnl.migration_types.ChoiceType({}), server_default='0', nullable=False))
    op.add_column('rate_upload_template', sa.Column('redup_in_rate_table_action', api_dnl.migration_types.ChoiceType({}), server_default='0', nullable=False))

    op.drop_column('rate_upload_template', 'reject_rate')
    op.drop_column('rate_upload_template', 'check_effective')
    op.drop_column('rate_upload_template', 'dup_method')
    op.drop_column('rate_upload_template', 'send_error_email_to')
    op.drop_column('rate_upload_template', 'append_prefix_value')
    op.drop_column('rate_upload_template', 'rate_increase_days')
    op.drop_column('rate_upload_template', 'header_fields')

    op.drop_column('rate_upload_template', 'end_date_all_gmt')
    op.drop_column('rate_upload_template', 'new_code_days')
    op.drop_column('rate_upload_template', 'min_time_default')
    op.drop_column('rate_upload_template', 'end_date')
    op.drop_column('rate_upload_template', 'has_code_deck')
    op.drop_column('rate_upload_template', 'append_prefix')
    op.drop_column('rate_upload_template', 'effective_date_format')
    op.drop_column('rate_upload_template', 'end_date_gmt')
    op.drop_column('rate_upload_template', 'interval_default')
    op.drop_column('rate_upload_template', 'end_date_all')
    op.drop_column('rate_upload_template', 'code_name_match')
    op.drop_column('rate_upload_template', 'effective_date_default')
    op.drop_column('rate_upload_template', 'with_header')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('rate_upload_template', sa.Column('with_header', sa.BOOLEAN(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('effective_date_default', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('code_name_match', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('end_date_all', postgresql.TIMESTAMP(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('interval_default', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('end_date_gmt', sa.VARCHAR(length=5), server_default=sa.text('(+ 0)'), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('effective_date_format', sa.VARCHAR(length=50), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('append_prefix', sa.BOOLEAN(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('has_code_deck', sa.BOOLEAN(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('end_date', postgresql.TIMESTAMP(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('min_time_default', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('new_code_days', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('end_date_all_gmt', sa.VARCHAR(length=5), server_default=sa.text('(+ 0)'), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('header_fields', sa.VARCHAR(length=200), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('rate_increase_days', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('append_prefix_value', sa.VARCHAR(length=20), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('send_error_email_to', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('dup_method', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('check_effective', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True))
    op.add_column('rate_upload_template', sa.Column('reject_rate', sa.INTEGER(), autoincrement=False, nullable=True))
    op.create_unique_constraint('rate_upload_template_name_key', 'rate_upload_template', ['name'])
    op.drop_column('rate_upload_template', 'redup_in_rate_table_action')
    op.drop_column('rate_upload_template', 'redup_in_file_action')
    op.drop_column('rate_upload_template', 'rate_table_id')
    op.drop_column('rate_upload_template', 'import_rate_date_format')
    op.drop_column('rate_upload_template', 'end_date_other_code_time')
    op.drop_column('rate_upload_template', 'effective_date')
    op.drop_column('rate_upload_template', 'code_name_provider')
    op.drop_column('rate_upload_template', 'code_deck_id')
    op.drop_column('rate_upload_template', 'auto_ij_rate')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))