from falcon_rest.db import errors
from api_dnl.models.logs import AuthorizationLog
from api_dnl.models.role import SystemFunction, Role
from falcon_rest.logger import log


def _check_permission(entity_name, req, permission):
    user = req.context['user']
    log.debug(f"ENTITY = {entity_name}, PERMISSION = {permission}")
    if user.user_type == "admin" and user.role_id == 0:     # user can be support, so we need to check for role Administrator
        #if entity_name in ['Ticket']:
        #    return False
        return True
    try:
        # permission_obj = api_permission.api_permission.ApiPermissionModel.query().join(
        #    api_permission.api_entity.ApiEntityModel
        # ).filter(api_permission.api_entity.ApiEntityModel.name == entity_name).one()
        log.debug('Check permission for {} user {}'.format(entity_name, user.name))
        func = SystemFunction.get_by_name(entity_name)
        if func:
            if func.image_name == 'ClientPortal' and user.user_type == 'client':
                return True
            if func.image_name == 'AgentPortal' and user.user_type == 'agent':
                return True

        if user.user_type in ('client', 'admin'):
            if entity_name in ['RateUploadTaskUpload','RateImportTask','RateImportTaskGet','OrigInvoice','ClientInvoiceSettingss','ClientDidProduct','MailTemplateGet',
                               'DidProduct', 'DidReportGroppedRequest', 'ProductRoutRateTableGet', 'ClientPaymentGet', 'ExportCreate', 'TicketTypeGet', 'TicketType',
                               'DidBillingPlan', 'ResourceIpPort', 'RateGet', 'RateCreate', 'RateTable', 'DidBillingPlanGet', 'ResourceIpClientGet',
                               'VoipGatewayFullGet', 'RateUploadTemplate', 'ClientPortalResourceIpPort', 'ResourceDirectionGet', 'ImportExportLogsExport']:
                return True

        if user.user_type in ('agent', 'admin'):
            if entity_name in [
                'ResourceIpAllGet', 'SwitchProfileGet', 'PcapQueryTaskGet', 'PcapQueryTask', 'CarrierGet',
                'RateSend','MailSenderGet','AgentCommissionPaymentGet', 'AgentMailTemplate', 'RateCreate', 'AgentPortalGet'
            ]:
                return True

        if user.user_type in ('client', 'agent', 'admin'):
            if entity_name in ['SystemParameterPaymentSetting',]:
                return False

        if entity_name in ['ImportCreate','UserInfo', 'Ticket', 'TicketGet', 'TicketComment', 'TicketCommentGet', 'TicketSend',
                           'TicketAttachment', 'TicketAttachmentGet', 'CdrAsyncTask','VoipGatewaySystemCallStat']:
            return True
        if entity_name in ['UserInfoGet', 'ClientSimpleGet', 'ResourceInfoGet', 'RateSendLogDetailGet',
                           'RateSendLogDetailGetResult', 'CdrDownloadTaskGet', 'RoleFunctionGroupGet',
                           'SystemParameterSystemSetting', 'Role', 'SysSubMenuGet',
                           'DailyCdrFieldGet', 'IngressTrunkGet', 'EgressTrunkGet', 'ResourcePrefixGet','VoipGatewayGet',
                           'RouteStrategyGet', 'CodecGet','ExportGet','DidVendorGet',
                           'SwitchProfileSipHostGet', 'CdrReportDetailGet', 'CdrReportGet', 'CdrReportGroppedRequest',
                           'CdrAsyncTaskGet', 'User', 'DidReportGroppedRequest', 'ResourceBlock', 'ResourceBlockGet',
                           'SystemParameterPaymentSettingPublic', 'CarrierGet', 'CarrierSmallGet',
                           'CodeDeckGet', 'CodeAllGet', 'ImportExportLogs', 'DidNumberUploadTasks', 'RateTableGet',
                           'CodeDeck', 'DidNumberUploadTask', 'ImportExportLogsImport'] and permission == 'read':
            return True

        if user.user_type == 'admin' and entity_name in ['UserInfoGet', 'ClientSimpleGet', 'ResourceInfoGet',
                            'RateSendLogDetailGet', 'RateSendLogDetailGetResult', 'CdrDownloadTaskGet',
                            'RoleFunctionGroupGet', 'SystemParameterSystemSetting', 'Role', 'SysSubMenuGet',
                           'DailyCdrFieldGet', 'IngressTrunkGet', 'EgressTrunkGet', 'ResourcePrefixGet','VoipGatewayGet',
                           'RouteStrategyGet', 'CodecGet','ExportGet','DidVendorGet',
                           'SwitchProfileSipHostGet', 'CdrReportDetailGet', 'CdrReportGet', 'CdrReportGroppedRequest',
                           'CdrAsyncTaskGet', 'User', 'DidReportGroppedRequest', 'ResourceBlock', 'ResourceBlockGet',
                           'SystemParameterPaymentSettingPublic', 'CarrierGet', 'CarrierSmallGet',
                           'CodeDeckGet', 'CodeAllGet', 'ImportExportLogs', 'DidNumberUploadTasks', 'RateTableGet',
                           'CodeDeck', 'DidNumberUploadTask', 'ImportExportLogsImport', 'Rate', 'PaymentGatewayHistory',
                            'Code', 'PaymentTerms', 'SystemParameter - Payment settings', 'ClientInvoiceSettingss']:
            return True

        if user.user_type == 'admin' and entity_name in ['Roles', 'SwitchProfile', 'DidVendors', 'InvoiceSummarys',
                                                         'DidClients', 'DidRepository items', 'PaymentGatewayHistory',
                                                         'TimeProfiles', 'Static Routes', 'SwitchProfileModify',
                                                         'TimeProfileGet', 'ProductGet'] and permission == 'read':
            return True

        if user.user_type == 'client' and entity_name in ['ClientPortal', 'ClientPortalPaymentGet']:
            return True

        role = user.role
        if not role:
            if user.user_type == 'client':
                role = Role.get(1)
            if user.user_type == 'agent':
                role = Role.get(2)
            if user.user_type == 'admin':
                role = Role.get(0)
        priv = role.privilege_for_func(entity_name)
        for p in priv:
            if p.allow(permission):
                return True
        return False
    except Exception as e:  # pragma: no cover
        log.debug(f"ERROR OCCURED - {e}")
        return False


def check_permission(entity_name, req, permission):
    if permission == 'write' and entity_name in ['Signup', 'RateTable', 'RateImportTask']:
        return True
    if permission == 'read' and entity_name in (
    'SystemParameterLoginPage', 'ProductRoutRateTablePublicGet', 'RateDownload', 'AgentReferalName',
    'SystemParameterSystemSettingPublicGet'):
        return True
    user = None
    if 'user' in req.context:
        user = req.context['user']
    else:
        return False
    if _check_permission(entity_name, req, permission):
        # AuthorizationLog(username=user.name, request_ip=user.login_ip,
        #                 direction=req.method, auth_type='key', error_type='success').set_time().save()
        return True
    else:
        AuthorizationLog(username=user.name, request_ip=user.login_ip,
                         direction=req.method, auth_type='key', error_type='forbidden',
                         agent=req.user_agent).set_time().save()
        return False


def has_create_permission(entity_name, req):
    return check_permission(entity_name, req, 'write')


def has_list_permission(entity_name, req):
    return check_permission(entity_name, req, 'read')


# noinspection PyUnusedLocal
def has_show_permission(entity_name, req, obj):
    return check_permission(entity_name, req, 'read')


# noinspection PyUnusedLocal
def has_modify_permission(entity_name, req, obj):
    return check_permission(entity_name, req, 'write')


# noinspection PyUnusedLocal
def has_delete_permission(entity_name, req, obj):
    return check_permission(entity_name, req, 'write')


# noinspection PyUnusedLocal
def has_restore_permission(entity_name, req, obj):
    return check_permission(entity_name, req, 'write')
