import os
from .__version__ import __version__
import configparser
from datetime import datetime

API_INI = 'api.ini'
# d=os.getcwd()
# print(d)
# print(open(API_INI,'rt').read())
config = configparser.ConfigParser(interpolation=None)
config.read(API_INI)
_p_changed = False


def conf_get(name, default, sec='DEFAULT'):
    global _p_changed
    if not sec in config:
        config.add_section(sec)
        _p_changed = True
    if not name in config[sec]:
        config[sec][name] = default
        _p_changed = True
        return default
    else:
        return config[sec][name]


LOG_FILE = (str(datetime.now().date()) + '.').join(conf_get('log_file', 'dnl.log').split('.'))
LOG_LEVEL = conf_get('log_level', 'debug')
LOG_TO_CONSOLE = True if conf_get('log_to_console', 'True') == 'True' else False
LOG_FORMAT = conf_get('log_format', '%(asctime)s [%(levelname)s] \'%(message)s\' at %(filename)s: %(lineno)s')
ALLOW_ORIGINS = ''
ALLOW_ORIGIN = conf_get('allow_origin', '*').split(' ')
API_TITLE = 'DNL API'
API_HOST = conf_get('api_host', 'localhost:8000')
API_PORT = conf_get('api_port', '8000')
API_SCHEME = conf_get('api_schema', 'http://')
API_BASE_PATH = conf_get('api_base_path', '/api_dnl/v1')
API_URL = API_SCHEME + API_HOST + API_BASE_PATH
FILE_URL = API_SCHEME + API_HOST
API_TEST_ROUTES = conf_get('api_test_routes', 'False')
DB_CONN_STRING = conf_get('db_conn_string', 'postgresql://webbackend:password@127.0.0.1:5432/class4_dnl')
DB_CONN_STRING_EXT = conf_get('db_conn_string_ext', 'postgresql://postgres:password@127.0.0.1:5432/class4_dnl')
DB_CONN_STRING_TEST = conf_get('db_conn_string_test', 'postgresql://webbackend:password@127.0.0.1:5432/class4_dnl')
DB_POOLSIZE = conf_get('db_pool_size', '1')
API_SAVE_OBJECT_HISTORY = conf_get('api_save_object_history', 'True') == 'True'
FALCON_SETTING_MODULE = 'api_dnl.settings'

WS_HOST = conf_get('ws_host', 'localhost:8010')

CREATE_TABLES = True if conf_get('create_tables', 'False') == 'True' else False

JWT_SIGNATURE = conf_get('jwt_signature', '8<2V*cd(7gBn>sIon#XJ[NLat%[HXhzG,Xi{Fawu{dayS0ef-!RrE|\WUbm[-CE}')
JWT_TTL_DAYS = int(conf_get('jwt_ttl_days', '14'))
JWT_REFRESH_THRESHOLD_DAYS = int(conf_get('jwt_refresh_threshold_days', '7'))

DEFAULT_ITEMS_PER_PAGE = int(conf_get('default_items_per_page', '30'))

AUTH_END_POINT = '/auth'

FAST_TESTING = True if conf_get('fast_testing', 'False') == 'True' else False
AUTO_RATE_ENABLED = True if conf_get('auto_rate_enabled', 'False') == 'True' else False
TEST_TO = conf_get('test_to', '')
AUTO_INVOICE_DEBUG = True if conf_get('auto_invoice_debug', 'True') in ('True', 'true', '1') else False
VERSION = __version__

# MIDDLEWARE_CLASSES = ['falcon_rest.contrib.middleware']
MIDDLEWARE = ['api_dnl.middleware.Middleware']
# MIDDLEWARE = ['falcon_rest.contrib.middleware.Middleware']
# AUTH_MODULE = 'falcon_rest.contrib.auth'
AUTH_MODULE = 'api_dnl.auth'
AUTH_USER_MODEL = 'api_dnl.models.user.User'
PERMISSIONS_MODULE = 'api_dnl.permissions'
TESTING_APP_CREATION_FUNC = 'api_dnl.create_app'

COLLECT_ENTITIES = True

PATHS_NOT_NEEDED_AUTH = (
    '{}{}'.format(API_BASE_PATH, AUTH_END_POINT),
    '{}/user/auth'.format(API_BASE_PATH),
    '{}/registration/create'.format(API_BASE_PATH),
    '{}/auth/reset_email'.format(API_BASE_PATH),
    '{}/auth/reset_password'.format(API_BASE_PATH),
    '{}/product/public'.format(API_BASE_PATH),
    '{}/swagger.yaml'.format(API_BASE_PATH),
    '{}/swagger.json'.format(API_BASE_PATH),
    '{}/client_swagger.json'.format(API_BASE_PATH)
)

ALWAYS_ALLOWED_AUTH_IPS = conf_get('always_allowed_auth_ips', '127.0.0.1').split(' ')

AUTH_ICX = {
    'name': conf_get('name', '#icx_api', 'AUTH_ICX'),
    'password': conf_get('password', 'ppu4XKZCcXa0Ag6lJ8gj', 'AUTH_ICX')
}

GOOGLE_DRIVE = {
    'application_name': 'api_dnl',
    'service_lifetime': '36000',
    'credential_dir': '~/',
    'client_secret_file': 'google-drive-client-secret.json'
}

if not 'STATISTIC' in config:
    config.add_section('STATISTIC')
# STATISTIC = {
#     'auth_host': conf_get('auth_host','localhost','STATISTIC'),
#     'auth_port': conf_get('auth_port','8887','STATISTIC'),
#     'cdr_host': conf_get('cdr_host','localhost','STATISTIC'),
#     'cdr_port': conf_get('cdr_port','8888','STATISTIC'),
#     'async_host': conf_get('async_host','localhost','STATISTIC'),
#     'async_port': conf_get('async_port','8889','STATISTIC'),
#     'host': conf_get('host','localhost','STATISTIC'),
#     'port': conf_get('port','8890','STATISTIC'),
#     'qos_host': conf_get('qos_host','localhost','STATISTIC'),
#     'qos_port': conf_get('qos_port','8891','STATISTIC'),
#     'ftp_host': conf_get('ftp_host','localhost','STATISTIC'),
#     'ftp_port': conf_get('ftp_port','8892','STATISTIC'),
# }

FILES = {
    'upload_to': conf_get('upload_to', '/opt/denovo_v6/api_dnl/files', 'FILES'),
    'invoices': conf_get('invoices', 'files/invoices', 'FILES'),
    'invoice_logs': conf_get('invoice_logs', 'files/invoice_logs', 'FILES'),
    'call_uploads': conf_get('call_uploads', 'files/uploads', 'FILES'),
    'call_tracks': conf_get('call_tracks', 'files/tracks', 'FILES'),
    'call_pcapdump': conf_get('call_pcapdump', 'files/dumps', 'FILES'),
}

PCAP_PCAP_DIR =conf_get('PCAP_PCAP_DIR','/opt/denovo_v6/api_dnl/files/pjsua')

CELERY = {
    'CELERY_BROKER_URL': conf_get('celery_broker_url', 'redis://localhost:6379/0', 'CELERY'),
    'CELERY_RESULT_BACKEND': conf_get('celery_result_backend', 'redis://localhost:6379/0', 'CELERY'),
    'CELERYD_TASK_SOFT_TIME_LIMIT': conf_get('celeryd_task_soft_time_limit', '300', 'CELERY')
}

SENTRY_URL = conf_get('sentry_url', '')
if SENTRY_URL == 'False':
    SENTRY_URL = None

# PCAP_LZCAT = conf_get('lzcat','lzcat','PCAP')
# PCAP_TSHARK = conf_get('tshark','tshark','PCAP')
# PCAP_STORAGE_TYPE = conf_get('storage_type','local','PCAP') #[ftp,sftp,gcs,local]
# PCAP_STORAGE_ROOT = conf_get('storage_root','/opt/denovo_v6/api_dnl/files/pcap','PCAP')
# PCAP_STORAGE_DIR = PCAP_STORAGE_ROOT+'/storage/'
# PCAP_STAGING_DIR = PCAP_STORAGE_ROOT+'/tmp/'
# PCAP_WEB_PUBLIC_DIR = PCAP_STORAGE_ROOT+'/www/'
# PCAP_PCAP_DIR = PCAP_STORAGE_ROOT+'/tcpdumpdir/'
# PCAP_GCS_SUPPORT = conf_get('gcs_support','disabled','PCAP')
# PCAP_SFTP_SUPPORT = conf_get('sftp_support','disabled','PCAP')
# PCAP_FTP_HOST = conf_get('ftp_host','local','PCAP')
# PCAP_FTP_PORT = int(conf_get('ftp_port','21','PCAP'))
# PCAP_FTP_USER = conf_get('ftp_user','user','PCAP')
# PCAP_FTP_PASS = conf_get('ftp_pass','pass','PCAP')
# PCAP_DURATION_MARGIN = int(conf_get('duration_margin','120','PCAP'))
# PCAP_CREDENTIALS_FILE=conf_get('credentials_file','/dev/null','PCAP')
# PCAP_PROJECT_NAME=conf_get('project_name','project','PCAP')
#
# #--loader
# COMMAND_TIMEOUT = conf_get('command_timeout','600.0','PCAP')
# PCAP_TCPDUMP = conf_get('tcpdump','/usr/sbin/tcpdump','PCAP')
# PCAP_SKIP_NEWER_SECONDS = int(conf_get('skip_newer_seconds','600','PCAP'))
# PCAP_MAX_FILES_CYCLE = int(conf_get('max_files_cycle','100','PCAP'))
# PCAP_TCPDUMP_DIR = conf_get('tcpdump_dir',PCAP_STORAGE_ROOT+'/tcpdumpdir/','PCAP')
# PCAP_VOICE_IPS = conf_get('voice_ips','127.0.0.1,172.31.1.100','PCAP')
# PCAP_VOICE_IPS_LIST = PCAP_VOICE_IPS.split(',')
#
# #PCAP_VOICE_PORT = '5060'
# PCAP_VOICE_PORT = conf_get('voice_port','8000','PCAP')
# PCAP_TCPDUMP_USER = conf_get('tcpdump_user','webbackend','PCAP')
# PCAP_UPLOADERS_POOL = int(conf_get('uploaders_pool','8','PCAP'))
# PCAP_ACTIVE = bool(int(conf_get('active','1','PCAP')))
#
#
CALL_RING_TIMEOUT = 60
CALL_TIMEOUT = 60
CALL_MAX_CALLS = 8
CALL_VOIPMON_EXE = '/opt/denovo_v6/voipmon/voipmon'

INTELIQUENT = {
    'auth_base': conf_get('auth_base', 'https://services-token-sandbox.inteliquent.com', 'INTELIQUENT'),
    'base': conf_get('base', 'https://services-sandbox.inteliquent.com', 'INTELIQUENT'),
    'msg_base': conf_get('msg_base', 'https://messagebroker.inteliquent.com', 'INTELIQUENT')
}
TELE = {
    'base': conf_get('base', 'https://apiv1.teleapi.net', 'TELE')
}
SMSC = {
    'base': conf_get('base', 'http://88.198.219.62/api_smsc/v1', 'SMSC')
}


SIPSHARK = {
    #'base': conf_get('base', 'http://api.sipshark.denovolab.com', 'SIPSHARK'),
    'base': conf_get('base', 'https://sipshark.org/api', 'SIPSHARK'),
    'baseui': conf_get('baseui', 'http://sipshark.org', 'SIPSHARK'),
}

UI_BASE_DIR=conf_get('ui_base_dir','False')



if _p_changed:
    with open(API_INI, 'w') as configfile:
        config.write(configfile)
