#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  helper.py
#  
#  Copyright 2017 krasytod <krasytod@krasytod-desktop>
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
#  
#  

import psycopg2
import psycopg2.extras
import time ,re , zipfile
from datetime import datetime
from datetime import timedelta
#from decimal import *
import configparser , imaplib,email , mimetypes ,random,string
import logging,os,sys,signal
from logging.handlers import TimedRotatingFileHandler
from logging.handlers import RotatingFileHandler
from collections import defaultdict
from itertools import islice

import smtplib,base64,csv ,math
from email.mime.multipart import MIMEMultipart
from email.mime.base import MIMEBase
from email.mime.text import MIMEText
from email.utils import COMMASPACE, formatdate
from email import encoders
#import pdfCreate,templates
from api_dnl.task.auto_rate_pdf import LetterMaker

EMAIL_TEMPLATE_SUBJECT = """Successful delivery of the price list from {from}. {violation}"""  # to {to}
# {file_ext}
EMAIL_TEMPLATE = """<pre> NOTIFICATION: DELIVERY SUCCESSFUL

  Please be aware that the attached price list(s) has been delivered. The original price list
  provided by  {from} is attached to this message, as well 
as a document describing the results of the validations performed .Please see the summary below:

    via email sent by {email_from} at {email_date}

     CONVERSION SUMMARY

     Content Rows Read: ROW start from {start_from} 
     Skipped Rows Report:
     - Incomplete Data Pattern Found: {fail_data_pat}
     - Rows With Errors: {num_fail}
     Successfully processed {num_succ} rows 

     New Codes :  {new_code}
     Delete Codes :  {del_code}
     Increased Codes :  {inc_code}
     Decreased Codes :  {dec_code}
     Penalty Codes :  {pen_code}

     {table}
     </pre>"""

EMAIL_TEMPLATE_REJECT = """<pre> NOTIFICATION: DELIVERY SUCCESSFUL

  Please be aware that the attached price list(s) has been delivered. The original price list
 provided by  {from} is attached to this message, as well 
as a document describing the results of the validations performed .Please see the summary below:

  via email sent by {email_from} at {email_date}
   Your rates were REJECTED

     {table}
     </pre>"""

TIMESTAMP_PATTERN = '%Y-%m-%d %H:%M:%S'


logger = logging.getLogger('rate send worker subprocess')

def connect_to_postgresql(host, port, database, user, password=None):
	try:
		conn = psycopg2.connect(host=host, port=port, database=database, user=user, password=password)
		conn.autocommit = True
		cursor = conn.cursor(cursor_factory=psycopg2.extras.DictCursor)
		print("connected to DBw")
	except Exception as e: 
		print (" Exception in DB connecting:  %s" % (str(e) ) )
		raise 'I am unable to connect to the PostgreSQL. %s'% (str(e))
	return conn, cursor


def makeQueryNoHelp(codes_set,pg_cur, resource_id):
	"""Gets codes set and perform postgres query for them.With returned csv file it is creating default dict with keys codes and values list [rate,end_date] 
	in case that are few different codes with same code/different end_date it leaves the code with nearest end_date"""
	# get rate_table_id
	sql = "select rate_table_id from resource where resource_id = %s" % resource_id
	print(sql)
	try:
		pg_cur.execute(sql)
		result = pg_cur.fetchone()
		if result==None:
			print("There is no0 resource with this id %s"%resource_id)
			return -1
		rate_table_id = result['rate_table_id']
		if rate_table_id == None:
			print("There is no 0 rate_table for that resource id %s"%resource_id)
			return -1
	except Exception as e: 
		print (" Exception in getting rate_table_id:  %s" % (str(e) ) )
		return -1 #raise 'Exception in getting rate_table_id: %s'% (str(e))
	_where = "rate_table_id = %s and  ( end_date is NULL  or end_date >= now() ) and    (" % rate_table_id  # 
	for code in codes_set:
		_where += "cast(code as text) LIKE '%s' OR "%code
	_where = _where[:-3]
	_where +=") "
	sql_query = """select code,rate ,end_date from rate where %s"""% _where   #2017-05-24 00:00:00+00'
	outputquery = "COPY ({0}) TO STDOUT WITH CSV HEADER".format(sql_query)
		
	#print (sql_query, outputquery)
	random_name ="files/"+ ''.join(random.choice(string.ascii_uppercase + string.digits) for _ in range(8)) + ".csv"
	with open(random_name , 'w') as f:
		pg_cur.copy_expert(outputquery,f)
	old_rates_dict = defaultdict(lambda: [-1,33053914547] )  # difference is very large number so every real value will evaluate to True in IF 
	old_rate_list =[]
	
	now_epoch_secs =  int(time.time())
	#print("Now seconds",now_epoch_secs )
	with open(random_name) as f:
		old_rate_list=[line.strip("\r\n").strip("\n").split(",") for line in f] 
	for row in old_rate_list:
		# if None use very big number
		try:
			date_time_sec = 33053914547 if row[2].strip() =="" else int(time.mktime(time.strptime(row[2].replace("+00",""),TIMESTAMP_PATTERN )))  
			seconds_difference = date_time_sec - now_epoch_secs
		except Exception as e: 
			print( "Exception in getting timedifference %s"%str(e) )
			print( row[2].replace("+00",""), TIMESTAMP_PATTERN  )
			continue
		# if that row secs difference is smaller from the one in dict: replace
		if seconds_difference  < old_rates_dict[ row[0] ][1] :
			old_rates_dict[ row[0] ] = [row[1],seconds_difference]
	try:
		os.remove(random_name)
	except Exception as e: 
		print( "Exception in deleting copy_to file %s"%str(e) )
		
	return  old_rates_dict,rate_table_id 
		

def minimalist_xldate_as_datetime(xldate, datemode=0):
    # datemode: 0 for 1900-based, 1 for 1904-based
    return (
        datetime(1899, 12, 30)   + timedelta(days=xldate + 1462 * datemode)
        )


def nohelp(list_rules_email_extracted_info,pg_cur):
	"""When we do not have any keywords. Returns dict with keys codes and values rate , time_difference to now"""
	#generate all possible codes
	code_super_sets = set ()  # set for all possible supersets
	print ("num of code column %s"%  list_rules_email_extracted_info[1]['code_col'] )
	for row in list_rules_email_extracted_info[2]: # allrows
		
		code = row[list_rules_email_extracted_info[1]['code_col']]
		try:
			code = str( code) . replace (".0","")
			int(code)
		except Exception as e:
			print ("This row is incorrect %s with exception %s "%(code[:10],e))
			continue
		try:
			code = str(code)
		except:
			print ("This row is incorrect2",code)
			continue

		for _idx in range (1,len( code)):
			code_super_sets.add  ( code[0:_idx]  ) 
		code_super_sets.add(code+"%")
	try:
		old_rates_dict,rate_table_id  = makeQueryNoHelp(code_super_sets,pg_cur,list_rules_email_extracted_info[1]['resource_id'])
	except Exception as e:  
		print (" makeQuery:  %s" % (str(e) ) )
		return -1,-1
	return old_rates_dict,rate_table_id 
	
	
def withhelp(list_rules_email_extracted_info,pg_cur):
	"""When we do not have any keywords. Returns dict with keys codes and values rate , time_difference to now"""
	
	rule = list_rules_email_extracted_info[1]
	print ("With help",rule['rate_status_col'])
	lead_time_new = rule.get('min_lead_time_new_code',7) if rule.get('min_lead_time_new_code',None) != None else 7
	lead_time_del = rule.get('min_lead_time_del_code',7) if rule.get('min_lead_time_del_code',None) != None else 7
	#decrease_keyword = rule.get('decrease_code_keyword',None).lower() if rule.get('decrease_code_keyword',None) != None else "decrease"
	lead_time_increase = rule.get('min_lead_time_inc_rate',7) if rule.get('min_lead_time_inc_rate',None) != None else 7
	min_lead_time = rule.get('min_lead_time',7)  if rule.get('min_lead_time',7) != None else 7
	
	new_keyword = "new"
	del_keyword = "delete"
	decrease_keyword = "decrease"
	#decrease_keyword2 = "decreased"
	increase_keyword ="increase"
	#print (new_keyword,del_keyword, decrease_keyword_list ,increase_keyword  )
	
	inc_codes = []
	del_codes = []# this is for subsets of delete codes with decreased rate
	penalty_codes = []
	new_codes = []# this is for subsets of new codes with increased rate
	dec_codes = []  # decremented codes
	same_rates = []
	decided_codes_dict =defaultdict(list)
	fail_rows = []

	
	try:
		rate_status_col = int(rule['rate_status_col'] )
		print ("rate_status_col",rate_status_col)
	except:
		print("Error Rate status column must be set!")
		print (rule['rate_status_col'],type(rule['rate_status_col'] ) )
		return -1,-1
	
	#print ("all rows",list_rules_email_extracted_info[2])
	for row in list_rules_email_extracted_info[2]: # allrows
		#print ("row",row )
		code = row[list_rules_email_extracted_info[1]['code_col']]
		try:
			code = str( code) . replace (".0","")
			int(code)
		except Exception as e:
			print ("This row is incorrect %s with exception %s "%(code[:10],e))
			fail_rows.append( row)
			continue
			
		rate = row[list_rules_email_extracted_info[1]['rate_col']]
		rate = str( rate) . replace ("$","")
		row[list_rules_email_extracted_info[1]['rate_col']]  = rate
		try:
			code = str(code)
		except:
			print ("This row is incorrect2",code)
			fail_rows.append( row)
			continue
		try:
			status = row [rate_status_col ]
			
		except Exception as e:
			print ("This row is incorrect [rate_status_col: %s row: %s with exception %s "%(rate_status_col,str(row),e))
			fail_rows.append( row)
			continue
		#print ("status",status)
		
		if   new_keyword in status.strip().lower() :
			datetime_effective_date_time = convertTimeString(  str(row [ rule ['effective_date_col'] ]) ,rule.get('date_pattern',"%Y-%m-%d")   )
			if datetime_effective_date_time == -1:
				#print ("Error in datetime_effective_date_time")
				continue
			if  datetime_effective_date_time  <   datetime.now()  - timedelta(days=min_lead_time ):  # 7 must be changed to ruling days
				penalty_codes .append(row)
			else:
				new_codes.append(row)
			
				
				
		elif  del_keyword in status.strip().lower()   :
			
			datetime_effective_date_time = convertTimeString(  str(row [ rule ['effective_date_col'] ]) ,rule.get('date_pattern',"%Y-%m-%d")   )
			if datetime_effective_date_time == -1:
				#print ("Error in datetime_effective_date_time")
				fail_rows.append( row)
				continue
			#for the case when only some multicodes are with status delete
			
			if  datetime_effective_date_time  <   datetime.now()  - timedelta(days=min_lead_time ):  # 7 must be changed to ruling days
				penalty_codes .append(row)
			else:
				del_codes.append(row)
		elif  decrease_keyword in status.strip().lower()   :
			#print("added decreased code", row)
			dec_codes.append(row)
		elif  increase_keyword in status.strip().lower() :
			datetime_effective_date_time = convertTimeString(  str(row [ rule ['effective_date_col'] ]) ,rule.get('date_pattern',"%Y-%m-%d")   )
			if datetime_effective_date_time == -1:
				#print ("Error in datetime_effective_date_time")
				fail_rows.append( row)
				continue
			if  datetime_effective_date_time  <   datetime.now()  - timedelta(days=min_lead_time ):  # 7 must be changed to ruling days
				penalty_codes .append(row)
			else:
				inc_codes.append(row)
		else: # the same
			#print ("same rate")
			same_rates.append(row)
		
	decided_codes_dict['dec_codes'] = dec_codes
	decided_codes_dict['inc_codes'] = inc_codes
	decided_codes_dict['del_codes'] = del_codes
	decided_codes_dict['penalty_codes'] = penalty_codes
	decided_codes_dict['new_codes'] = new_codes
	decided_codes_dict['same_rates'] = same_rates
	decided_codes_dict['fail_rows'] =fail_rows
	print ("decrem code", len(dec_codes),"inc code", len(inc_codes),"same code", len(same_rates))
	
	sql = "select rate_table_id from resource where resource_id = %s" % list_rules_email_extracted_info[1]['resource_id']
	print(sql)
	try:
		pg_cur.execute(sql)
		result = pg_cur.fetchone()
		if result==None:
			print("There is no resource with this id %s"% list_rules_email_extracted_info[1]['resource_id'])
			return -1,-1
		rate_table_id = result['rate_table_id']
		if rate_table_id == None:
			print("There is no rate_table for that resource id %s"% list_rules_email_extracted_info[1]['resource_id'])
			return -1,-1
	except Exception as e: 
		print (" Exception in getting rate_table_id:  %s" % (str(e) ) )
		return -1,-1
		
	return decided_codes_dict, rate_table_id 
	

def checkSubset(key,old_rates_dict ):
	"""Checks if key is 'subset' of existing code/rate. example: 86177 is a new code/key that is subset of 86 (in terms of rate table) 
	if superset/code is found, returns it  with second param - True for the whole CODE, False for superset . else False"""
	#make all possible combinations of supersets for the key:
	supersets_posibles = []
	for idx in range(1, len (key)+1):
		if key[0:idx] in old_rates_dict: 
			#superset is found!
			return key[0:idx] , idx == len (key)  # returns list of the found  superset /code .second param: True if is the code it self, False if is superset 
	
	return False

def convertTimeString(time_str,rule_pattern= "N/A",time_zone = None):
	
	#time_str = str(time_str). replace("Jan","01"). replace("Feb","02"). replace("Mar","03"). replace("Apr","04"). replace("May","05"). replace("Jun","06"). replace("Jul","07"). replace("Aug","08") \
	#. replace("Sep","09"). replace("Oct","10"). replace("Nov","11"). replace("Dec","12")
	
	#print ("rule_pattern %s"%rule_pattern)
	pat1 = "%Y-%m-%d"
	pat2 = "%Y:%m:%d"
	pat3 = "%Y/%m/%d"
	pat4 = "%d-%m-%Y"
	pat5 = "%d:%m:%Y"
	pat6 = "%d/%m/%Y"
	pat7 = "%d-%b-%y %H:%M:%S"
	#18-Aug-17 20:00:00  
	#%d-%b-%Y %H:%M:%S
	
	try:
		datetime_object = datetime.strptime(time_str, rule_pattern)
	except:
		#print ("Cannot match with provided pattern %s  %s" % (time_str, rule_pattern ))
		
		try:
			datetime_object = datetime.strptime(time_str, pat1)
		except:
			try:
				datetime_object = datetime.strptime(time_str, pat2)
			except:
				try:
					datetime_object = datetime.strptime(time_str, pat3)
				except:
					try:
						datetime_object = datetime.strptime(time_str, pat4)
					except:
						try:
							datetime_object = datetime.strptime(time_str, pat5)
						except:
							try:
								datetime_object = datetime.strptime(time_str, pat6)
							except Exception as e: 
								try:
									datetime_object = datetime.strptime(time_str, pat7)
								except Exception as e: 
									# xls or xlsx format
									try:
										datetime_object =  minimalist_xldate_as_datetime(int(time_str))
									except Exception as e: 
										#print (" Cannot match rate effеctive date with any known pattern:  %s" % (str(e) ) )
										print ("Cannot match with provided pattern %s  %s" % (time_str, rule_pattern ))
										return -1
	if time_zone !=None:
		datetime_object =datetime_object +  timedelta(hours = int(time_zone))

		
	return datetime_object


def checkForNewCode(list_rules_email_extracted_info,old_rates_dict,pg_cur):
	"""Checks all Codes and rule violation , delete, new, inc,new or decrease. Returns dict with all codes in appropriate keys:lists """
	import_rule = list_rules_email_extracted_info[1]
	new_code_table = list(list_rules_email_extracted_info[2])
	new_codes_rates_dict = dict()  #   code: [rate,index in new rate list , effective_date]
	#inc_new_codes = []  
	inc_codes = []
	del_codes = []# this is for subsets of delete codes with decreased rate
	penalty_codes = []
	new_codes = []# this is for subsets of new codes with increased rate
	dec_codes = []  # decremented codes
	same_rates = []
	decided_codes_dict =defaultdict(list)
	min_lead_time = import_rule.get('min_lead_time',7)  if import_rule.get('min_lead_time',7) != None else 7
	index = 0  #we must keep the index of row which rate we are appending to the dict
	print("check For New Code")
	for row in  new_code_table:
		try:
			
			new_codes_rates_dict [ str(row [ import_rule ['code_col']  ] )   ] = [  str( row [ import_rule ['rate_col']] ) ,index,row [ import_rule ['effective_date_col']] ]
		except Exception as e: 
			print (" for row in  new_code_table:  %s" % (str(e) ) )
			continue
		index += 1
	#If the Code is a subset of or equal to existing code
	for key, value in new_codes_rates_dict.items():
		result = checkSubset(key,old_rates_dict )
		if result:  #if code(key) is in the rate table as superset or like the whole code, check rule violations, if not add as new code
			superset_or_code_value =  result[0]
			superset_or_code_type =  result[1]  #True for the whole code, False for superset
			index =  new_codes_rates_dict [key] [1]  # get the index in new_code_table
			current_row = new_code_table[index]
			#print("current_row",current_row, import_rule ['effective_date_col'],import_rule )
			try:
				datetime_effective_date_time = convertTimeString(  str(current_row [ import_rule ['effective_date_col'] ])  ,import_rule.get('date_pattern',"%Y-%m-%d")    )
			except Exception as e:
				print (e)
				
			
			if datetime_effective_date_time == -1:
				print ("problematic row ", str(current_row))
				continue
			if superset_or_code_type == True:  #it is increase or decrease
				# if   
				#print (value[0] ,old_rates_dict[superset_or_code_value]  )
				#print ( float(value[0] ) , float( old_rates_dict[superset_or_code_value] [0] )   ) 
				if float(value[0] ) < float( old_rates_dict [superset_or_code_value][0] ):
					#print (  "Increase"  )
					if  datetime_effective_date_time  <   datetime.now()  - timedelta(days=min_lead_time):  # 7 must be changed to ruling days
						#print ( "Must have penalty %s" %str(current_row))
						current_row.append(old_rates_dict [superset_or_code_value][0] )
						penalty_codes.append(current_row)
					else:
						# increased codes but good effective date
						#print (  "Increase code with good date %s" %str(current_row) )
						current_row.append(old_rates_dict [superset_or_code_value][0] )
						inc_codes.append(current_row    )
						
				elif  float(value[0] ) > float( old_rates_dict [superset_or_code_value][0] )  : 
					#print (  "Decrease code %s" %str(current_row) )
					current_row.append(old_rates_dict [superset_or_code_value][0] )
					dec_codes.append(current_row)
					
					
				else:  #same rate
					#print (  "Same rate %s" %str(current_row) )
					current_row.append(old_rates_dict [superset_or_code_value][0] )
					same_rates.append(current_row)
					

			else:
				#superset handling
				#print("key ,value ",key,value,old_rates_dict [superset_or_code_value],"superset_or_code_value",superset_or_code_value)
				# if rates are equal.. do not touch
								
				if float(value [0] ) == float(old_rates_dict [superset_or_code_value][0]):
					#print("Same  Rate %s %s" % (str(value) ,str(old_rates_dict [superset_or_code_value]) ) )
					current_row.append(old_rates_dict [superset_or_code_value][0] )
					same_rates.append(current_row)
				
				else:
					#else check date for violation
					if  datetime_effective_date_time  <   datetime.now()  - timedelta(days=min_lead_time):  # 7 must be changed to ruling days
						#print ( "Must have penalty %s" %str(current_row))
						current_row.append(old_rates_dict [superset_or_code_value][0] )
						penalty_codes.append(current_row)
					
					else:
						if float(value [0]) > float(old_rates_dict [superset_or_code_value][0]):  #NEW
							#print("NEW!  Rate %s %s" % (str(value) ,str(old_rates_dict [superset_or_code_value]) ) )
							current_row.append(old_rates_dict [superset_or_code_value][0] )
							new_codes.append(current_row)
						else:  #DELETE
							#print("DELETE!  Rate %s %s" % (str(value) ,str(old_rates_dict [superset_or_code_value]) ) )
							current_row.append(old_rates_dict [superset_or_code_value][0] )
							del_codes.append(current_row)
		else:
			index =  new_codes_rates_dict [key] [1]  # get the index in new_code_table
			current_row = new_code_table[index]
			#print("Entire New Codes" %str(current_row))
			#current_row.append(old_rates_dict [superset_or_code_value][0] )
			new_codes.append(current_row)
			#new_code.append(new_code_table [index]  )  # append this row to the list with confrimed new codes
	decided_codes_dict['dec_codes'] = dec_codes
	decided_codes_dict['inc_codes'] = inc_codes
	decided_codes_dict['del_codes'] = del_codes
	decided_codes_dict['penalty_codes'] = penalty_codes
	decided_codes_dict['new_codes'] = new_codes
	decided_codes_dict['same_rates'] = same_rates
	return decided_codes_dict

def get_smtp_info(cursor):
	sql = """SELECT smtphost as host,smtpport as port,emailusername as username,emailpassword as password,loginemail as is_auth,fromemail as from_email, smtp_secure as smtp_secure,noc_email as noc_email ,switch_alias FROM system_parameter LIMIT 1"""
	cursor.execute(sql)
	smtp_setting = cursor.fetchone()
	return smtp_setting

def htmlTablegenerator(decided_codes_dict,list_rules):
	"""generates html table with rates"""
	rate_col = list_rules['rate_col']
	code_col = list_rules['code_col']
	code_name_col = list_rules['code_name_col']
	effective_date_col = list_rules['effective_date_col']

	table_content= """<tr> <th> Code </th> <th> Code Name </th> <th> Old Rate </th> <th> New Rate </th> <th>  Effective Date </th> <th> Status  </th>  </tr>"""
	for row in decided_codes_dict['dec_codes']:
		table_content+= """<tr> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td>  </tr>""" % (row[code_col],row[code_name_col],
		row[-1],row[rate_col],row[effective_date_col],"Decrease"  )
	
	for row in decided_codes_dict['inc_codes']:
		table_content+= """<tr> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td>  </tr>""" % (row[code_col],row[code_name_col],
		row[-1],row[rate_col],row[effective_date_col],"Increase"  )
	
	for row in decided_codes_dict['new_codes']:
		table_content+= """<tr> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td>  </tr>""" % (row[code_col],row[code_name_col],
		row[-1],row[rate_col],row[effective_date_col],"New code"  )
	
	for row in decided_codes_dict['del_codes']:
		table_content+= """<tr> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td>  </tr>""" % (row[code_col],row[code_name_col],
		row[-1],row[rate_col],row[effective_date_col],"Delete code"  )
	
	
	html_table = """<table cellspacing="2" cellpadding="0" border="1" align="center" >  %s  </table> """ % table_content
	#print (html_table)
	return html_table


def htmlTablegeneratorNew(decided_codes_dict,list_rules,status_dict_default,rejected= False):
	"""generates html table with first 4 rates"""
	
	if rejected != False:
		rate_col = list_rules['rate_col']
		code_col = list_rules['code_col']
		code_name_col = list_rules['code_name_col']
		effective_date_col = list_rules['effective_date_col']
		new_dict = dict() #  defaultdict(lambda: dict)
		dt_v_list = defaultdict(lambda: list)
		
		for key in decided_codes_dict:
			#_key = convert_status_dict[key]
			new_dict[key] = defaultdict(lambda : defaultdict(str))
			#code_name_dict = defaultdict(lambda: dict)
			for row in decided_codes_dict[key]:
				new_dict[key][row[code_name_col]] [ row[rate_col] ]  +=  "%s," % row[code_col]
				new_dict[key][row[code_name_col]] ['effective_date'] = row[effective_date_col]
		
		convert_status_dict =  { 'dec_codes': "Decrease", 'inc_codes': "Increase",'new_codes': "New code",'del_codes':"Delete code",'same_rates': 'Same Rate'}
		table_content= """<tr> <th> Code Name</th> <th> Code </th> <th> New Rate </th> <th>  Effective Date </th> <th> Status  </th>  </tr>"""
		counter = 0 # only first 100 rates
		status_dict_default['num_suc'] = 0
		for status,value in new_dict.items():
			for code_name,value_1 in value.items():
				for rate,code in value_1.items():
					if rate != "effective_date":
						status_dict_default['num_suc'] += 1
						if status_dict_default['num_suc'] < 5:
							#print ("status_dict_default['num_suc']", status_dict_default['num_suc'])
							table_content+= """<tr> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td>  </tr>""" % (code_name,code[:-1] , rate,
							value_1['effective_date'] ,convert_status_dict.get(status,status) )
		table_content+= """<tr> <td> %s more rows ..</td> </tr>"""  % (status_dict_default['num_suc'] - 5)
		html_table = """<table cellspacing="2" cellpadding="0" border="1" align="center" >  %s  </table> """ % table_content
		
	else:
		rate_col = list_rules['rate_col']
		code_col = list_rules['code_col']
		code_name_col = list_rules['code_name_col']
		effective_date_col = list_rules['effective_date_col']
		new_dict = dict() #  defaultdict(lambda: dict)
		dt_v_list = defaultdict(lambda: list)
		
		for key in decided_codes_dict:
			#_key = convert_status_dict[key]
			if key != "penalty_codes" or key != "fail_rows" :
				print ("key is %s, continue"%key )
				continue
			new_dict[key] = defaultdict(lambda : defaultdict(str))
			#code_name_dict = defaultdict(lambda: dict)
			for row in decided_codes_dict[key]:
				new_dict[key][row[code_name_col]] [ row[rate_col] ]  +=  "%s," % row[code_col]
				new_dict[key][row[code_name_col]] ['effective_date'] = row[effective_date_col]
		
		convert_status_dict =  { 'penalty_codes':"Rejected" }
		table_content= """<tr> <th> Code Name</th> <th> Code </th> <th> New Rate </th> <th>  Effective  Date </th> <th> Status  </th>  </tr>"""
		counter = 0 # only first 100 rates
		status_dict_default['num_suc'] = 0
		for status,value in new_dict.items():
			for code_name,value_1 in value.items():
				for rate,code in value_1.items():
					if rate != "effective_date":
						status_dict_default['num_suc'] += 1
						if status_dict_default['num_suc'] < 5:
							#print ("status_dict_default['num_suc']", status_dict_default['num_suc'])
							table_content+= """<tr> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td>  </tr>""" % (code_name,code[:-1] , rate,
							value_1['effective_date'] ,convert_status_dict.get(status,status) )
		table_content+= """<tr> <td> %s more rows ..</td> </tr>"""  % (status_dict_default['num_suc'] - 5)
		html_table = """<table cellspacing="2" cellpadding="0" border="1" align="center" >  %s  </table> """ % table_content
		
	#print (html_table)
	return html_table






def take(n, _dict):
	"Return first n items of the iterable as a list"
	counter = 0 
	new_dict = dict()
	for key in _dict:
		if counter == n:
			break
		#new_dict[key] = _dict.pop(key)
		counter +=1
	for key in new_dict:
		_dict.pop(key)
	return new_dict


def createTable(decided_codes_dict,rule):
		
	dec_codes =  decided_codes_dict['dec_codes'] 
	inc_codes =  decided_codes_dict['inc_codes']  
	del_codes =  decided_codes_dict['del_codes']  
	penalty_codes =  decided_codes_dict['penalty_codes'] 
	new_codes =  decided_codes_dict['new_codes']  
	same_codes =  decided_codes_dict['same_rates']
	rate_col= rule['rate_col']
	code_col = rule['code_col']
	code_col_name = rule['code_name_col']
	effective_date_col= rule['effective_date_col']
	table = [[ "Code", "Code Name", "New Rate",  "Effective Date" , "Status"  ] ]
	
	
	for rate_row in dec_codes:
		row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"Decreased" ]
		table.append(row)
		
	for rate_row in inc_codes:
		row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"Increased" ]
		table.append(row)
	
	for rate_row in del_codes:
		row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"Deleted" ]
		table.append(row)
    
		
	for rate_row in new_codes:
		row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"New" ]
		table.append(row)
		
	for rate_row in same_codes:
		row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"Same rate" ]
		table.append(row)
		
	if  rule.get('violation_action',0) ==1:
		
		for rate_row in penalty_codes:
			row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "" ,rate_row[rate_col],rate_row[effective_date_col],"Codes with penalty" ]
			table.append(row)
		
	return table

def createTableNewJur(decided_codes_dict,list_rules_email_extracted_info):
	from reportlab.lib.styles import getSampleStyleSheet
	from reportlab.platypus import Paragraph, Table, TableStyle
	styles = getSampleStyleSheet()
	rules = list_rules_email_extracted_info[1]
	status_dict_default = list_rules_email_extracted_info[3]
	rate_rows = list_rules_email_extracted_info[2]
	#print ("rate_rows len ",len(rate_rows),rate_rows[2],rate_rows[5] )
	inter_rate_col =  rules['inter_rate_col'] 
	intra_rate_col = rules['intra_rate_col'] 
	rate_col=rules['rate_col']
	code_col = rules['code_col']
	table = [[ "Code", "inter_rate" ,"intra_rate","Rate","effective_date" ] ]
	table_content= """<tr> <th> Code </th> <th> Inter rate</th> <th> Intra rate</th> <th>  Rate </th> <th> Effective date  </th>  </tr>"""
	counter = 0
	conter_dict = defaultdict(lambda : int )
	tables_dict = defaultdict(lambda : [] )
	
	
	print (rate_col, inter_rate_col,rules['effective_date_col'],code_col)
	for row in rate_rows:
		
		if rules['effective_date_col'] == None:
			try:
				effective_date = status_dict_default['effective_date'].strftime('%Y-%m-%d')  #2012-06-27
			except :
				effective_date = status_dict_default['effective_date']
			effective_date = str(effective_date )
		else:
			effective_date = str(row[rules['effective_date_col']  ] )

		
		tables_dict[  str( row [rate_col]) + ":"+ str(row [ inter_rate_col   ]) +":"+str(effective_date)+":"+str(math.ceil(counter/1000))] . append (str( row [  code_col  ])   )
		if counter < 5:
			table_content+= """<tr> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td> <td> %s </td>  </tr>""" %  ( row [  code_col  ],row [ inter_rate_col   ],row [intra_rate_col],row [rate_col],effective_date  )
		counter +=1
		
	for key, value in tables_dict.items():
		
		inter_rate,intra_rate,effective_date,count =   key.split(":")
		#print ([value, inter_rate,intra_rate,intra_rate, effective_date ])
		code  =  ",".join ( value )
		row = [Paragraph("%s"%code[:-1], styles['Normal'])   , inter_rate,intra_rate,intra_rate,effective_date  ]
		table.append (row )
		

	status_dict_default['num_suc'] = counter
	table_content+= """<tr> <td> %s more rows .. </td>  </tr>"""%(counter - 5)
	html_table = """<table cellspacing="2" cellpadding="0" border="1" align="center" >  %s  </table> """ % table_content

		
	return table,html_table 

def createTableNew(decided_codes_dict,list_rules,status_dict_default):
	print("createTableNew")
	from reportlab.lib.styles import getSampleStyleSheet
	from reportlab.platypus import Paragraph, Table, TableStyle
	styles = getSampleStyleSheet()
	
	new_dict = dict() #  defaultdict(lambda: dict)
	rate_col = list_rules['rate_col']
	code_col = list_rules['code_col']
	code_name_col = list_rules['code_name_col']
	effective_date_col = list_rules['effective_date_col']
	#print ("decided_codes_dict decrease len:",len(decided_codes_dict['dec_codes']  ))
	for key in decided_codes_dict:
		#_key = convert_status_dict[key]
		print(key,  len(decided_codes_dict[key]) )
		new_dict[key] = defaultdict(lambda : defaultdict(str))
		#code_name_dict = defaultdict(lambda: dict)
		for row in decided_codes_dict[key]:
			try:
				code_n = row[code_name_col]
			except:
				code_n = ""
			new_c = True
			while True:
				try:
					if len(new_dict[key][code_n] [ row[rate_col] ] ) < 2000:
						break
				except Exception as e:
					print (e)
					print (key ,  code_n,  rate_col  , row)
					break
				code_n += " "
				#print (code_n)
			try:
				new_dict[key][code_n] [ row[rate_col] ]  +=  "%s," % row[code_col]
				new_dict[key][code_n] ['effective_date'] = row[effective_date_col]
			except Exception as e:
				print ("exception in createTableNew in  'new_dict[key][code_n] [ row[rate_col] ]  +=' ", e)
				print("row",row)
	
	convert_status_dict =  { 'dec_codes': "Decrease", 'inc_codes': "Increase",'new_codes': "New code",'del_codes':"Delete code",'same_rates':"Same  Rate"}
	
	status_dict_default['new_codes'] = 0 
	status_dict_default['del_codes'] = 0  
	status_dict_default['inc_codes'] = 0 
	status_dict_default['dec_codes'] = 0 
	
	table = [[ "Code Name", "Code", "New Rate",  "Effective Date" , "Status"  ] ]
	#print ("new_dict dec",new_dict['dec_codes'] )
	rate_is_counter = 0 
	
	for status,value in new_dict.items():
		for code_name,value_1 in value.items():
			for rate,code in value_1.items():
				if rate != "effective_date":
					#print ("status",status)
					if status == 'fail_rows' :
						continue
						#pass #status_dict_default['inc_codes'] +=1
					elif status == 'new_codes' :
						pass #status_dict_default['new_codes'] +=1
					elif status == 'del_codes' :
						pass #status_dict_default['del_codes'] +=1
					elif status == 'dec_codes' :
						pass #status_dict_default['dec_codes'] +=1
					row = [Paragraph("%s"%code_name, styles['Normal']), Paragraph("%s"%code[:-1], styles['Normal'])   , rate,value_1['effective_date'] ,convert_status_dict.get(status,status)  ]
					table.append(row)
					#print (row)
				else:
					rate_is_counter +=1 #print ("rate is  = effective date")
	print("rate is  = effective date  for %s rows"%rate_is_counter)
	return table




def send_email(list_rules_email_extracted_info,config,dict_of_list_codes,pg_cur ,reject = False,us_jur= False):
	"""Email client"""
	msg = MIMEMultipart()
	#print (list_rules_email_extracted_info[1],list_rules_email_extracted_info ) 
	text = "test test "
	try:
		send_to  =  list_rules_email_extracted_info[1]['from_email']+ ","+list_rules_email_extracted_info[0]['add_email']  #'krasytod@gmail.com' #
	except Exception as e:
		print(e)
		send_to  = 'pranoy@denovolab.com'  #'krasytod@gmail.com' #'shuvankar@intlcx.com' #'shuvankar@intlcx.com' str(list_rules_email_extracted_info[1][0] )   #'piyali@intlcx.com'  #str(list_rules_email_extracted_info[1][0] )   #'krasytod@gmail.com'  #
	#print ( type(dict_of_list_codes) )
	print("will send to",send_to)
	smtp_info = get_smtp_info(pg_cur)
	#print(list_rules_email_extracted_info[1],list_rules_email_extracted_info[3])
	email_info = list_rules_email_extracted_info[0]
	status_dict_default = list_rules_email_extracted_info[3]
	_from = email_info['from']
	#_to =  "_to_"
	
	#Jira RRI-64

	
                   #"Hello. We are emailing you about %s" % list_rules_email_extracted_info[0]['subj']
	msg['From'] = "denovo_test@krasytod.org"
	msg['To'] =  str(send_to)  #COMMASPACE.join()
	send_to = send_to.split(",")
	#msg['cc'] = invoice_cc
	msg['Date'] = formatdate(localtime = True)

	if us_jur == False:
		table_list = createTableNew(dict_of_list_codes,list_rules_email_extracted_info[1],status_dict_default)
	else:
		table_list,html_table = createTableNewJur(dict_of_list_codes,list_rules_email_extracted_info)
		# debug
		#show only first 100 records
		print ("Tale length for pdf to be generated", len(table_list) )
		table_list = table_list[:2000]
	print ("size of table_list",len(table_list))
	if not reject :
		if us_jur == False:
			html_table =   htmlTablegeneratorNew(dict_of_list_codes,list_rules_email_extracted_info[1],status_dict_default,False)
		
		print("Not reject, not Us")
		attachment = email_info ['filename'] [0]
		_date = email_info ['date']
		#content = ""
		file_ext = attachment[-3:]
		file_ext_map = {'xls':"Excel",'lsx':"Excel",'zip':"Archive",'csv':"CSV"}
		file_ext =  file_ext_map.get(file_ext,file_ext)
		try:
			
			
			violation = ""
			if len(dict_of_list_codes['penalty_codes'])  > 0:
				violation = " %s codes with violation found " % len(dict_of_list_codes['penalty_codes'])
				import_rule = list_rules_email_extracted_info[1]
				violation_action =import_rule.get('violation_action',0)
				if violation_action == 1:
					violation += ". All rates are accepted, but your resource is blocked"
				elif violation_action == 0:
					violation += ". Entire deck is rejected"
				else:
					violation += ". Codes in violation are rejected"
				subject = EMAIL_TEMPLATE_SUBJECT.replace('{from}',_from) .replace('{violation}', violation)
				
				msg['Subject'] = subject
				print ("SubjectVio ",subject)
				
			else :
				violation = "No codes with violation found"
				import_rule = list_rules_email_extracted_info[1]
				violation_action =import_rule.get('violation_action',0)
				if violation_action == 1:
					violation += ". All rates are accepted"
				elif violation_action == 0:
					violation += ". All rates are accepted"
				else:
					violation += ". All rates are accepted"
				subject = EMAIL_TEMPLATE_SUBJECT.replace('{from}',_from) .replace('{violation}', violation)
				
				msg['Subject'] = subject
				print ("SubjectNoVio",subject)
				
			
			#print ()
			status_dict_default['num_suc'] = len(dict_of_list_codes['dec_codes'])+len(dict_of_list_codes['inc_codes'])+len(dict_of_list_codes['del_codes']) \
			+len(dict_of_list_codes['new_codes'])+len(dict_of_list_codes['penalty_codes']) +len(dict_of_list_codes['same_rates']  )
			print( "Number of codes: success %s , Dec %s , Inc %s , Del %s, New %s , Pen %s , Same %s "  % (status_dict_default['num_suc'] ,
			 len(dict_of_list_codes['dec_codes']),len(dict_of_list_codes['inc_codes']),len(dict_of_list_codes['del_codes'])  ,len(dict_of_list_codes['new_codes']),
			 len(dict_of_list_codes['penalty_codes']) ,len(dict_of_list_codes['same_rates'])  )) 
			fail_rows_num = len(dict_of_list_codes['fail_rows'])

			content = EMAIL_TEMPLATE.replace("{attachment_name}",attachment).replace("{from}",_from).replace("{email_from}",_from).replace("{email_date}",
			_date).replace("{start_from}",str(status_dict_default.get('start_from_row',0)+1 )).replace("{end_to}","N/A").replace("{fail_data_pat}",
			str(status_dict_default.get('date_fail',"N/A"))).replace("{empty_rows}","N/A").replace("{num_fail}",
			str(fail_rows_num)).replace("{num_succ}",str(status_dict_default.get('num_suc',"N/A"))).replace("{new_code}",str(len(dict_of_list_codes['new_codes']))) \
			.replace("{del_code}",str(len(dict_of_list_codes['del_codes']))).replace("{inc_code}",str(len(dict_of_list_codes['inc_codes']))).replace("{table}",html_table) \
			.replace ('{file_ext}',file_ext).replace("{dec_code}",str(len(dict_of_list_codes['dec_codes']))).replace("{pen_code}",str(len(dict_of_list_codes['penalty_codes'])) )
			print(content)
			
			msg.attach( MIMEText(content, 'html') )
			print ("num succ",status_dict_default['num_suc'])
		except Exception as e:
			print("Exception in Not reject, not Us")
			print(e)
			fail_rows_num =0
			content = EMAIL_TEMPLATE.replace("{attachment_name}",attachment).replace("{from}",_from).replace("{email_from}",_from).replace("{email_date}",
			_date).replace("{start_from}",str(status_dict_default.get('start_from_row',0)+1 )).replace("{end_to}","N/A").replace("{fail_data_pat}",
			str(status_dict_default.get('date_fail',"N/A"))).replace("{empty_rows}","N/A").replace("{num_fail}",
			str(fail_rows_num)).replace("{num_succ}",str(status_dict_default.get('num_suc',"N/A"))).replace("{new_code}",str(status_dict_default.get('new_codes',"N/A"))) \
			.replace("{del_code}","Delete codes N/A").replace("{inc_code}", "Inc codes N/A" ).replace("{pen_code}",str(len(dict_of_list_codes['penalty_codes'])) ). replace("{table}",html_table) \
			.replace ('{file_ext}',file_ext).replace("{dec_code}", "Dec codes N/A"  )                  
			msg.attach( MIMEText(content, 'html') )
			subject = EMAIL_TEMPLATE_SUBJECT.replace('{from}',_from) .replace('{violation}', "")
			msg['Subject'] = subject
			print ("Subject",subject)
		
		counter = 0 
		start = 0
		if us_jur == False:
			for end in range(0, len(table_list), 5000):
				print ("range", start,end)
				if start == end :
					continue
				new_pdf = "./files/"+''.join(random.choice(string.ascii_uppercase + string.digits) for _ in range(10))+"part_%s"%counter+".pdf"
					#take(n, d.iteritems())

				pdf_file  = LetterMaker(new_pdf,table_list[start:end],  list_rules_email_extracted_info[1] ,us_jur )
				pdf_file.createDocument()
				pdf_file.savePDF()
						# add file attachment
				part = MIMEBase('application', "octet-stream")
					
				part.set_payload( open(new_pdf,"rb").read() )
				encoders.encode_base64(part)
				part.add_header('Content-Disposition', 'attachment; filename="{0}"'.format(os.path.basename(new_pdf)))
				msg.attach(part)
				counter +=1
				start = end
			
			new_pdf = "./files/"+''.join(random.choice(string.ascii_uppercase + string.digits) for _ in range(10))+".pdf"
				#take(n, d.iteritems())
			pdf_file  = LetterMaker(new_pdf,table_list[start:],  list_rules_email_extracted_info[1] ,us_jur )
			pdf_file.createDocument()
			pdf_file.savePDF()
					# add file attachment
			part = MIMEBase('application', "octet-stream")
			part.set_payload( open(new_pdf,"rb").read() )
			encoders.encode_base64(part)
			part.add_header('Content-Disposition', 'attachment; filename="{0}"'.format(os.path.basename(new_pdf)))
			msg.attach(part)
		else:
			print ("jurisdiction US do not have attachment")

			
			
			
	else:
		print ("it is reject")
		html_table =   htmlTablegeneratorNew(dict_of_list_codes,list_rules_email_extracted_info[1],status_dict_default,False)
		rejected = dict_of_list_codes['penalty_codes']
		print ("Number of rejectec codes: %s "%len(rejected))
		_date = email_info ['date']
		content = EMAIL_TEMPLATE_REJECT.replace("{from}",_from).replace("{email_from}",_from).replace("{email_date}",
		_date).replace("{start_from}",str(status_dict_default.get('start_from_row',0)+1 )).replace("{end_to}","N/A").replace("{fail_data_pat}",
		str(status_dict_default.get('date_fail',"N/A"))).replace("{empty_rows}","N/A").replace("{num_fail}",
		str(status_dict_default.get('row_fail',"N/A"))).replace("{num_succ}",str(status_dict_default.get('num_suc',"N/A"))).replace("{new_code}",str(status_dict_default.get('new_codes',"N/A"))) \
		.replace("{del_code}",str(status_dict_default.get('del_codes',"N/A"))).replace("{inc_code}",str(status_dict_default.get('inc_codes',"N/A"))).replace("{table}",html_table).replace("{dec_code}",str(status_dict_default.get('dec_codes',"N/A")))
		msg['Subject'] = """You have violation in some rates. The whole rate file is rejected."""
		msg.attach( MIMEText(content, 'html') )
		
		
		
	#print("sent to",send_to)
		
	if smtp_info['smtp_secure'] == 1:
		isTls=True
	else:
		isTls=False
	server =  smtp_info['host']
	port = smtp_info['port'] 
	username = smtp_info['username']
	password = smtp_info['password'] 
	send_from  = smtp_info.get('from_email',"NA@krasytod.org") 
	if not reject :
		pass
		
	if smtp_info['smtp_secure'] == 2:
		smtp = smtplib.SMTP_SSL(server, port)
		#smtp = smtplib.SMTP(server, port)
	else:
		smtp = smtplib.SMTP(server, port)
	try:
		smtp.set_debuglevel(False)
		if isTls: smtp.starttls() 
		smtp.ehlo()
		smtp.login(smtp_info['username'], smtp_info['password'])
		smtp.sendmail(smtp_info['from_email'], send_to, msg.as_string())

	except smtplib.SMTPRecipientsRefused:
		print( 'All recipients were refused.')
	except smtplib.SMTPHeloError:
		print( 'The server didn’t reply properly to the HELO greeting.')
	except smtplib.SMTPSenderRefused:
		print( 'The server didn’t accept the %s.' % smtp_info['from_email'] )
	except smtplib.SMTPDataError:
		print( 'The server replied with an unexpected error code (other than a refusal of a recipient).' )
	except Exception as e:
		print( e)
	else:
		print( 'OK' )
	finally:
		smtp.quit()
 
def getTimeZone(rate_row,time_zone_col ):
	'''Extracts time zone from the row if any '''
	if time_zone_col  != None:
		time_zone_str = rate_row[time_zone_col]
		number_l = re.findall(r'[-\d]+', time_zone_str )
		try:
			number = number_l[0]
		except Exception as e:
			print (e)
			number = None
	else:
		number= None
	#print("Timezone is", number)
	return number
 
def convertFile(list_rules_email_extracted_info,config,dict_of_list_codes,pg_cur,rate_table_id ):
	"""Converts the file to csv and add new record to rate_upload_task"""  
	
	rule = list_rules_email_extracted_info[1]
	cwd = os.getcwd() +"/files" 
	new_csv = ''.join(random.choice(string.ascii_uppercase + string.digits) for _ in range(10))+".csv"
	new_csv_full_path = cwd +"/" +new_csv
	
	print ("New CSV %s"%new_csv)
	
	dec_codes = dict_of_list_codes['dec_codes'] 
	inc_codes = dict_of_list_codes['inc_codes']  
	del_codes = dict_of_list_codes['del_codes']  
	penalty_codes = dict_of_list_codes['penalty_codes'] 
	new_codes = dict_of_list_codes['new_codes']  
	same_codes = dict_of_list_codes['same_rates']
	rate_col= rule['rate_col']
	code_col = rule['code_col']
	code_col_name =rule['code_name_col']
	effective_date_col=rule['effective_date_col']
	end_date_col=rule['end_date_col']
	if end_date_col == None:
		data = [["code","rate","effective_date", "min time","interval"]  ]  #28-06-2016
	else:
		data = [["code","rate","effective_date", "min time","interval","end_date"]  ]
	
	
	#for testing 
	#rule['time_zone_col'] = 6
	
	for rate_row in dec_codes:
		try:
			time_zone = getTimeZone(rate_row,rule['time_zone_col'] )
			if end_date_col == None:
				row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col] ,rule.get('date_pattern',"N/A"),time_zone ).strftime("%Y-%m-%d") ,rule['min_time'],rule['interval']]
			else:
				row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col] ,rule.get('date_pattern',"N/A"),time_zone ).strftime("%Y-%m-%d") ,rule['min_time'],rule['interval'],rate_row[end_date_col]]
			data.append(row)
		except Exception as e:
			print("Exception %s for row %s in Decrease codes"  %(e, rate_row)  )
		
	for rate_row in inc_codes:
		try:
			time_zone = getTimeZone(rate_row,rule['time_zone_col'] )
			if end_date_col == None:
				row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col],rule.get('date_pattern',"N/A"),time_zone).strftime("%Y-%m-%d") ,rule['min_time'],rule['interval']]
			else:
				row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col] ,rule.get('date_pattern',"N/A"),time_zone ).strftime("%Y-%m-%d") ,rule['min_time'],rule['interval'],rate_row[end_date_col]]
			data.append(row)
		except Exception as e:
			print("Exception %s for row %s " % (e, rate_row)  )
	
	for rate_row in del_codes:
		try:
			time_zone = getTimeZone(rate_row,rule['time_zone_col'] )
			if end_date_col == None:
				row	= [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col],rule.get('date_pattern',"N/A"),time_zone).strftime("%Y-%m-%d")  ,rule['min_time'],rule['interval']]
			else:
				row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col] ,rule.get('date_pattern',"N/A"),time_zone ).strftime("%Y-%m-%d") ,rule['min_time'],rule['interval'],rate_row[end_date_col]]
			data.append(row)
		except Exception as e:
			print("Exception %s for row %s " % (e, rate_row)  )
			
	for rate_row in new_codes:
		try:
			time_zone = getTimeZone(rate_row,rule['time_zone_col'] )
			if end_date_col == None:
				row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col],rule.get('date_pattern',"N/A"),time_zone).strftime("%Y-%m-%d")  ,rule['min_time'],rule['interval']]
			else:
				row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col] ,rule.get('date_pattern',"N/A"),time_zone ).strftime("%Y-%m-%d") ,rule['min_time'],rule['interval'],rate_row[end_date_col]]
			data.append(row)
		except Exception as e:
			print("Exception %s for row %s " % (e, rate_row)  )

	if rule.get('violation_action',0) ==1:
		for rate_row in penalty_codes:
			try:
				time_zone = getTimeZone(rate_row,rule['time_zone_col'] )
				if end_date_col == None:
					row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col],rule.get('date_pattern',"N/A") ,time_zone).strftime("%Y-%m-%d")  ,rule['min_time'],rule['interval']]
				else:
					row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col] ,rule.get('date_pattern',"N/A"),time_zone ).strftime("%Y-%m-%d") ,rule['min_time'],rule['interval'],rate_row[end_date_col]]
					data.append(row)
			except Exception as e:
				print("Exception %s for row %s in cF "%  (e, rate_row)  )

	for rate_row in same_codes:
		try:
			time_zone = getTimeZone(rate_row,rule['time_zone_col'] )
		except Exception as e:
			print("Exception %s for row %s in same codes time_zone " % (e, rate_row)  )
			time_zone = None
			if end_date_col == None:
				row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col] ,rule.get('date_pattern',"N/A"),time_zone).strftime("%Y-%m-%d")  ,rule['min_time'],rule['interval']]
			else:
				row = [  rate_row[code_col],rate_row[rate_col],convertTimeString( rate_row[effective_date_col] ,rule.get('date_pattern',"N/A"),time_zone ).strftime("%Y-%m-%d") ,rule['min_time'],rule['interval'],rate_row[end_date_col]]
			data.append(row)
		except Exception as e:
			print("Exception %s for row %s in same codes cF " % (e, rate_row)  )

	
	
	with open(new_csv_full_path, 'w', newline='') as fp:
		a = csv.writer(fp, delimiter=',')
		a.writerows(data)
	
	#setting all_rate_end_date
	all_rate_end_date = datetime.now().strftime('%Y-%m-%d') + " 23:59:59 +00"
	
	
	sql = """ INSERT INTO rate_upload_task ( operator_user, upload_file_path,upload_orig_file , upload_format_file ,rate_table_id ,
	rate_date_format,all_rate_end_date,reduplicate_rate_action ) VALUES ('Rate Script','%s', '%s','%s',%s,  'yyyy-mm-dd','%s',2)""" %  ( cwd, new_csv,new_csv, rate_table_id ,all_rate_end_date  )
	print(sql)
	try:
		pg_cur.execute (sql)
	except Exception as e: 
		print (" Error in uploding to rate task  %s" % (str(e) ) )
		return -1
	
	return 0 

def doViolation(dict_of_list_codes,list_rules_email_extracted_info,pg_cur):
	"""Gets list of codes and decides what to do with them"""
	import_rule = list_rules_email_extracted_info[1]
	violation_action =import_rule.get('violation_action',0)
	try:
		if violation_action == 1 and len ( dict_of_list_codes['penalty_codes'] ) >0: #accept rates but block egress trunk
			dict_of_list_codes['penalty_codes']
			now = datetime.now()
			not_now = now + timedelta(days = import_rule .get("min_lead_time",7))
			epoch_secs_unblock = int (not_now.timestamp())
			sql = """INSERT INTO resource_block (engress_res_id ,create_by, unblock_after  ) VALUES (%s, 'Rate Bote',%s   )""" % (import_rule.get('resource_id',0), epoch_secs_unblock )
			print("SQL FOR BLOCKING %s"%sql)
			pg_cur.execute(sql)
	except Exception as e: 
		print (" Error in blocking rate trunk  %s" % (str(e) ) )
		return -1


def withUsJur(list_rules_email_extracted_info,pg_cur):
	
	
	sql = "select rate_table_id from resource where resource_id = %s" % list_rules_email_extracted_info[1]['resource_id']
	print(sql)
	try:
		pg_cur.execute(sql)
		result = pg_cur.fetchone()
		if result==None:
			print("There is no resource with this id %s"% list_rules_email_extracted_info[1]['resource_id'])
			return -1,-1
		rate_table_id = result['rate_table_id']
		if rate_table_id == None:
			print("There is no rate_table for that resource id %s"% list_rules_email_extracted_info[1]['resource_id'])
			return -1,-1
	except Exception as e: 
		print (" Exception in getting rate_table_id:  %s" % (str(e) ) )
		return -1,-1
	
	rules = list_rules_email_extracted_info[1]
	status_dict_default = list_rules_email_extracted_info[3]
	rate_rows = list_rules_email_extracted_info[2]
	#print ("rate_rows len ",len(rate_rows),rate_rows[2],rate_rows[5] )
	inter_rate_col =  rules['inter_rate_col'] 
	intra_rate_col = rules['intra_rate_col'] 
	rate_col=rules['rate_col']
	code_col = rules['code_col']
	new_csv_file_list = [  ['Country','code_name','Code','inter_rate','intra_rate','Rate','Interval','effective_date','min_time'] ]
	
	#print (row)
	
	for row in rate_rows:
		try:
			effective_date = status_dict_default['effective_date'].strftime('%Y-%m-%d')  #2012-06-27
		except Exception as e:
			#print (e)
			#print (status_dict_default['effective_date'])
			continue
		#new_row = " USA ,USA ,%s ,%s ,%s, %s ,6 ,%s ,6  " %   ( row [  code_col  ],row [ inter_rate_col   ],row [intra_rate_col],row [rate_col],effective_date)
		new_csv_file_list.append (["USA" ,"USA",    row [  code_col  ],row [ inter_rate_col   ],row [intra_rate_col],row [rate_col],6,effective_date,6 ]    )
		#new_csv_file.append(new_row)
	#print ("new_csv_file",new_csv_file[:20])
	
	cwd = os.getcwd() +"/files" 
	new_csv = ''.join(random.choice(string.ascii_uppercase + string.digits) for _ in range(10))+".csv"
	new_csv_full_path = cwd +"/" +new_csv
	
	with open(new_csv_full_path, 'w', newline='') as fp:
		a = csv.writer(fp, delimiter=',')
		a.writerows(new_csv_file_list)
	
	#setting all_rate_end_date
	all_rate_end_date = datetime.now().strftime('%Y-%m-%d') + " 23:59:59 +00"
	
	
	sql = """ INSERT INTO rate_upload_task ( operator_user, upload_file_path,upload_orig_file , upload_format_file ,rate_table_id ,
	rate_date_format,all_rate_end_date,reduplicate_rate_action ) VALUES ('Rate Script','%s', '%s','%s',%s,  'yyyy-mm-dd','%s',2)""" %  ( cwd, new_csv,new_csv, rate_table_id ,all_rate_end_date  )
	print(sql)
	try:
		pg_cur.execute (sql)
	except Exception as e: 
		print (" Error in uploding to rate task  %s" % (str(e) ) )
		return -1
	return new_csv_file_list

def work(list_rules_email_extracted_info):
	# list_rules_email_extracted_info [0] - orig email, [1] - rule , [2] - list with rates file info , [3] - Status default dict
	#status_dict_default['effective_date']  - effective datetime object in case is set in subject
	
	config = configparser.ConfigParser()
	config.read('config.ini')
	rules = list_rules_email_extracted_info[1]
	status_def_dict = list_rules_email_extracted_info[3]
	
	global DEBUG_LEVEL 
	DEBUG_LEVEL = int (config["log"]["debug_level"] )
	# logger

	if int(config["log"].get('by_time',0) )== 1:
		handler = TimedRotatingFileHandler(config["log"].get ("sent_rate_path","sent_rate.log"),when=config["log"].get ("sent_rate_when",'m'),
		interval= int( config["log"].get ("sent_rate_interval",0) ),backupCount= int( config["log"].get ("sent_rate_backupCount",5)  ) )
	else: # by size
		handler = RotatingFileHandler(config["log"].get ("sent_rate_path","sent_rate.log"),maxBytes=int( config["log"].get ("sent_rate_maxBytes", 1024*1024*128 ) ),
		backupCount= int( config["log"].get ("sent_rate_backupCount",5)  ) )
	
	if int (config["log"].get ("debug_level",0) ) == 1: 
		logger.setLevel(logging.DEBUG)
	else:
		logger.setLevel(logging.INFO)
	formatstr = '%(asctime)s - %(name)s - %(levelname)s - %(message)s'
	formatstr = '%(asctime)s: %(levelname)s:  %(message)s'
	formatter = logging.Formatter(formatstr)
	handler.setFormatter(formatter)
	logger.addHandler(handler)
	
	
	try:
		pg_conn, pg_cur = connect_to_postgresql(config["POSTGRES"]["hostaddr"],int(config["POSTGRES"]["port"]), config["POSTGRES"]["dbname"], config["POSTGRES"]["user"],config["POSTGRES"]["password"]) #config["POSTGRES"]["password"]
		
	except Exception as e: 
		print (" Exception in connect_to_postgresql:  %s" % (str(e) ) )
		#logger.error(" Exception in connect_to_postgresql:  %s" % (str(e) ) )
		return (-1,-1)
	
	print ("new code lead time ",list_rules_email_extracted_info[1]['min_lead_time_new_code'])
	
	if rules['inter_rate_col'] != None or  rules['intra_rate_col'] != None:
		us_jur = True
	else:
		us_jur = False
	print ("us_jur",us_jur)
	if us_jur == False:
		#A-Z Rates
		if list_rules_email_extracted_info[1]['rate_status_col'] == None :
			# no keywords for help. Brote Force
			print ("no keywords for help. Brote Force")
			old_rates_dict ,rate_table_id = nohelp(list_rules_email_extracted_info,pg_cur)
			if old_rates_dict == -1:
				print("ERROR In NoHelp. Returning !")
				pg_cur.close()
				return -1
			# check for new code
			dict_of_list_codes  = checkForNewCode(list_rules_email_extracted_info,old_rates_dict,pg_cur)  # values are lists of checked codes
		
		else:
			print ("YES keywords for help. Brote Force")
			dict_of_list_codes ,rate_table_id  = withhelp(list_rules_email_extracted_info,pg_cur)  # values are lists of checked codes
			if rate_table_id  == -1:
				print("ERROR in with help. Exiting")
				pg_cur.close()
				return -1
		
		print ("dict_of_list_codes len2: ",len(dict_of_list_codes) )
		doViolation(dict_of_list_codes,list_rules_email_extracted_info,pg_cur)
		if list_rules_email_extracted_info[1].get('violation_action',0) == 0 and len ( dict_of_list_codes['penalty_codes'] ) >0 :  # reject entire rate
			print("There is a rates that are in violation. Rejecting the entire rate")
			send_email(list_rules_email_extracted_info,config,dict_of_list_codes,pg_cur,True,False )
			return -1
		convertFile(list_rules_email_extracted_info,config,dict_of_list_codes,pg_cur,rate_table_id )
		send_email(list_rules_email_extracted_info,config,dict_of_list_codes,pg_cur,False,False )
		pg_cur.close()
	else:
		#US Rates
		print ("US Rates")
		#dict_of_list_codes  = checkForNewCode(list_rules_email_extracted_info,old_rates_dict,pg_cur)  # values are lists of checked codes
		withUsJur(list_rules_email_extracted_info,pg_cur)
		send_email(list_rules_email_extracted_info,config,[],pg_cur,False ,True)
		
		pg_cur.close()
		return 0
	


	return 0


def main():
	
	return 0







if __name__ == '__main__':
	main()





#prom:
#old_rates_dict  - key : code, value : [ rate, effective date in seconds from now ]

