from datetime import datetime, timedelta

from pytz import UTC
from sqlalchemy import (and_)
from sqlalchemy.orm import foreign
from sqlalchemy.sql import func, select, case

from api_dnl import model, settings
from api_dnl.model import Client, Resource, BalanceHistoryActual, MailSender, User, RateSendLogDetail, DailyCdrField, \
    ResourceCidBlockConfig, ResourceCidBlockLog, client_cdr, ResourceBlock
from api_dnl.tasks import app, log, db, SqlAlchemyTask
from api_dnl.utils.imp_exp import (csv2xls, dict_to_csv)

TEST_TO = settings.TEST_TO


@app.task(base=SqlAlchemyTask)
def do_cid_block():
    log.info('do_cid_block started')
    d1 = datetime.now(UTC).replace(second=0, microsecond=0)
    d0 = d1 - timedelta(minutes=5)
    d1 = d1 - timedelta(seconds=1)
    cdr = client_cdr(d0.date())
    query = ResourceCidBlockConfig.query()
    for rule in query:
        try:
            if not rule.resource.enfource_cid:
                continue

            q = select([cdr.c.origination_source_number.label('ani'), func.count(cdr.c.id).label('total_calls'),
                        func.sum(cdr.c.call_duration).label('total_duration'),
                        func.sum(case([(cdr.c.call_duration < 12, 1)], else_=0)).label('total_short_calls'),
                        func.sum(case([(cdr.c.call_duration > 0, 1)], else_=0)).label('total_non_zero'),
                        ]).where(and_(cdr.c.final_route_indication == 'F',
                                      cdr.c.ingress_id == rule.resource_id,
                                      cdr.c.time >= d0,
                                      cdr.c.time < d1,
                                      )).group_by(cdr.c.origination_source_number)
            q_data = model.get_db().session.execute(q)
            data_items = []
            block_ani = []
            for item in q_data:
                asr = 0
                sdp = 0
                cpm = 0
                if item.total_calls:
                    asr = int(item.total_non_zero / item.total_calls * 100)
                    sdp = int(item.total_short_calls / item.total_calls * 100)
                    cpm = int(item.total_calls / 5)
                acd = 0
                if item.total_non_zero:
                    acd = int(item.total_duration / item.total_non_zero)
                data_items.append(dict(ani=item.ani,
                                       total_non_zero=item.total_non_zero,
                                       total_calls=item.total_calls,
                                       total_short_calls=item.total_short_calls,
                                       asr=asr, sdp=sdp, cpm=cpm, acd=acd
                                       ))
                is_block = False
                if rule.min_asr and asr < rule.min_asr:
                    is_block = True
                if rule.min_acd and asr < rule.min_acd:
                    is_block = True
                if rule.max_sdp and sdp > rule.max_sdp:
                    is_block = True
                if rule.max_cpm and cpm > rule.max_cpm:
                    is_block = True
                if is_block:
                    block_ani.append(item.ani)
                    prev_block = ResourceBlock.filter(and_(ResourceBlock.ani == item.ani,
                                                           ResourceBlock.ingress_client_id == rule.resurce_id)).all()
                    if prev_block:
                        log.debug('ingress trunk {} blocked ani {} has already been blocked'.format(rule.resource_id,
                                                                item.ani))

                    rbid = ResourceBlock(ani_prefix=item.ani, ingress_res_id=rule.resource_id,
                                         block_type='specific trunk',
                                         create_by='dnl_api_do_cid_block',
                                         create_time=datetime.now(UTC),
                                         action_type='alert rule').save()
                    log.debug('ingress trunk {} blocked ani {} block_id {}'.format(rule.resource_id,
                                                                                   item.ani, rbid))
                else:
                    log.debug('ingress trunk {} not blocked block_id {} asr: {}, sdp: {}, cpm: {}'.format(rule.resource_id
                                                                                   , rbid, asr, sdp, cpm))
            if block_ani:
                result = 'ingress trunk {} blocked ani {}'.format(rule.resource_id, ','.join(block_ani))
            else:
                result = 'ingress trunk {} no blocks'.format(rule.resource_id)
            ResourceCidBlockLog(result=result,resource_id=rule.resource_id, data=dict(items=data_items) if data_items else None).save()
        except Exception as e:
            log.warning('do_cid_block error: {}'.format(e))

    log.debug('do_cid_block finished')
