import celery
from api_dnl import settings
from datetime import datetime,timedelta
from pytz import UTC
from time import mktime
import io,csv,gzip,zipfile
import os,shutil
import xlwt
import json
from api_dnl.utils.imp_exp import (csv2xls,dict_to_csv)
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_,or_,not_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.utils.imp_exp import JsonReader, XmlReader
from api_dnl.model import JurisdictionPrefix,SystemParameter,Code,\
    Client,Client,Resource,ResourcePrefix,Rate,RateTable,RateSendLog,BalanceHistoryActual,C4ClientBalance,\
    RateSendLogDetail,CrdReportDetailTable,MailSender,FraudDetection,FraudDetectionLog,FraudDetectionLogDetail,\
    ResourceBlock,IngressTrunk,AlertRule,AlertRuleLog,AlertRulesLogDetail,CdrReportDetail,client_cdr,\
    SendRateDirect,MailTemplate,SendRateTemplate
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast,generate_uuid_str,aliased
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.scheme import RateScheme
from dulwich.repo import Repo
from dulwich.client import HttpGitClient
from dulwich import porcelain

US_CODEDECK_FILE = 'Jurisdiction.csv'
AZ_CODEDECK_FILE = 'Codedeck.csv'
REMOTE = 'http://stash.denovolab.com/scm/cd/public.git'

@app.task(base=SqlAlchemyTask)
def do_code_deck_update_check():
    log.debug('code_deck_update_check started')
    conf = SystemParameter.get(1)
    path = settings.FILES['upload_to']+'/public'

    if not os.path.isdir(path):
        porcelain.clone(REMOTE,path)
    lck = path+'/.git/index.lock'
    if os.path.exists(lck):
        os.system('rm -f {}'.format(lck)) # remove stale lock
    porcelain.pull(path,remote_location=REMOTE)

    file_name = path+'/' +US_CODEDECK_FILE
    try:
        mtime = os.path.getmtime(file_name)
    except OSError:
        mtime = 0
    codedeck_prompt_us_update = datetime.fromtimestamp(mtime,tz=UTC)

    file_name = path + '/' + AZ_CODEDECK_FILE
    try:
        mtime = os.path.getmtime(file_name)
    except OSError:
        mtime = 0
    codedeck_prompt_az_update = datetime.fromtimestamp(mtime,tz=UTC)

    if not conf.codedeck_prompt_us_update or codedeck_prompt_us_update > conf.codedeck_prompt_us_update:
        conf.codedeck_prompt_us_update=codedeck_prompt_us_update
        conf.save()
    if not conf.codedeck_prompt_az_update or codedeck_prompt_az_update > conf.codedeck_prompt_az_update:
        conf.codedeck_prompt_az_update=codedeck_prompt_az_update
        conf.save()
    log.debug('code_deck_update_check finish')



@app.task(base=SqlAlchemyTask,time_limit=1800,soft_time_limit=1790)
def code_deck_update_us():
    slog = SchLog('code_deck_update_us')
    log.debug('code_deck_update_us')
    try:
        conf = SystemParameter.get(1)
        if conf.codedeck_last_us_update and conf.codedeck_prompt_us_update and conf.codedeck_last_us_update > conf.codedeck_prompt_us_update:
            log.debug('code_deck_update_us up to date skip')
            slog.close()
            return
        path = settings.FILES['upload_to'] + '/public'
        file_name = path+'/'+US_CODEDECK_FILE
        JurisdictionPrefix.query().delete()
        db.session.commit()
        file = open(file_name,'rt+')
        reader = csv.DictReader(file)
        for it in reader:
            try:
                JurisdictionPrefix(**it).save()
            except Exception as e:
                log.debug('code_deck_update_us failed:{}'.format(str(e)))
        conf.codedeck_last_us_update = datetime.now(UTC)
        conf.save()
    except Exception as e:
        log.error('code_deck_update_us failed:{}'.format(str(e)))

    slog.close()

@app.task(base=SqlAlchemyTask,time_limit=1800,soft_time_limit=1790)
def code_deck_update_az():
    slog = SchLog('code_deck_update_az')
    log.debug('code_deck_update_az')
    try:
        conf = SystemParameter.get(1)
        if conf.codedeck_last_az_update and conf.codedeck_prompt_az_update and  conf.codedeck_last_az_update > conf.codedeck_prompt_az_update:
            log.debug('code_deck_update_az up to date skip')
            slog.close()
            return
        path = settings.FILES['upload_to'] + '/public'
        file_name = path+'/'+AZ_CODEDECK_FILE
        Code.query().delete()
        db.session.commit()
        file = open(file_name,'rt+')
        reader = csv.DictReader(file)
        for it in reader:
            try:
                Code(**it).save()
            except Exception as e:
                log.debug('code_deck_update_us failed:{}'.format(str(e)))
        conf.codedeck_last_az_update = datetime.now(UTC)
        conf.save()
    except Exception as e:
        log.error('code_deck_update_us failed:{}'.format(str(e)))
    slog.close()

@app.task(base=SqlAlchemyTask,time_limit=1800,soft_time_limit=1790)
def do_code_deck_import_preprocess(tsk_id):
    log.debug('do_code_deck_import_preprocess start')
    log.debug('do_code_deck_import_preprocess finish')