import celery
from api_dnl import settings
from datetime import datetime,timedelta
from pytz import UTC
from time import mktime
from itertools import islice
import io,csv,gzip,zipfile
import xlwt
import json
import traceback
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, asc, and_,or_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from sqlalchemy.dialects import postgresql
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import Client,Client,Resource,Rate,RateTable,RateSendLog,BalanceHistoryActual,C4ClientBalance,\
    RateSendLogDetail,CrdReportDetailTable,MailSender,FraudDetection,FraudDetectionLog,FraudDetectionLogDetail,\
    ResourceBlock,IngressTrunk,SystemParameter,AlertRule,AlertRuleLog,AlertRulesLogDetail,CdrReportDetail,client_cdr,\
    ImportExportLogs,User
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast,generate_uuid_str
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.utils.ws_broker_api import WSBrokerAPI
from api_dnl.scheme import RateScheme,ValidationError,BaseModelScheme
from api_dnl import view
from api_dnl.view import IntegrityError,_scheme_get,_json_write,_xls_write,_xml_write
from api_dnl.utils.imp_exp import (csv2xls,dict_to_csv)


def create_export_query(obj):
    query = obj._query
    fmt = query['format']

    if not obj.obj in model.__dict__:
        raise ValidationError('Entity does not exists :{}'.format(obj.obj))

    BaseSchemeClass = _scheme_get(obj.obj)
    if not BaseSchemeClass:
        log.warning('Scheme class for {} not found. Use default.'.format(obj.obj))
        BaseSchemeClass = BaseModelScheme

    names = list(BaseSchemeClass.Meta.fields)

    cls = model.__dict__[obj.obj]
    meta = inspect(cls)
    q = cls.query()

    cols = []

    if 'select' in query:
        if query['select']:
            if query['select'][0] == '*':
                cols = names
            else:
                for s in query['select']:
                    if not s in names:
                        raise ValidationError('wrong field name :{}'.format(s))
                    cols.append(s)
    else:
        cols = names
    _select = []
    for f in cols:
        _select.append(getattr(cls,f).label(f))
    q = model.get_db().tr_session.query(*_select)
    export_scheme = BaseSchemeClass(only=cols)
    # q=qu.session.query(*tuple(cols))

    if 'where' in query:
        f1 = []
        for f in query['where']:
            if f['op'] == 'in':
                if 'select' in f['value'] or 'insert' in f['value'] or 'delete' in f['value']:
                    raise ValidationError('wrong field value :{}'.format(f['value']))
                f1.append(text_("{} {} ({})".format(f['field'], f['op'], f['value'])))
            elif f['op'] == 'between':
                if not ',' in f['field']:
                    raise ValidationError('wrong field name :{} for op between'.format(f['field']))
                fstart = f['field'].split(',')[0]
                fend = f['field'].split(',')[1]
                f1.append(text_("'{}' {} {} and coalesce({},now())".format(f['value'], f['op'], fstart, fend)))
            elif f['field'] == 'is_effective_now' and f['op'] == '=':
                f1.append(text_('("effective_date" <= now() and ("end_date" >= now() or "end_date" is null)) = {}'.format(f['value'])))
            elif f['field'] == 'effective_at' and f['op'] == '=':
                f1.append(text_('("effective_date" <= \'{}\' and ("end_date" >= \'{}\' or "end_date" is null))'.format(f['value'], f['value'])))
            else:
                f1.append(text_("{} {} '{}'".format(f['field'], f['op'], f['value'])))
        if 'or_where' in query:
            f2 = []
            for f in query['or_where']:
                f2.append(text_("{} {} '{}'".format(f['field'], f['op'], f['value'])))
            q = q.filter(or_(and_(*tuple(f1)), and_(*tuple(f1))))
        else:
            q = q.filter(and_(*tuple(f1)))

    if 'order' in query:
        for order in query['order']:
            direction = order.get('direction', 'asc')
            field = order['field']
            if field == 'code':
                casted_field = cast(getattr(cls, field).cast(String), BigInteger)
                if direction == 'desc':
                    q = q.order_by(desc(casted_field))
                else:
                    q = q.order_by(asc(casted_field))
            else:
                if direction == 'desc':
                    q = q.order_by(desc(getattr(cls, field)))
                else:
                    q = q.order_by(asc(getattr(cls, field)))

    # todo make synonyms in  models and schemes not in generic methods
    # if obj.obj == 'Rate' and 'rate' in cols:
    #     rate = q.first()
    #     if rate and rate.rate_table.jur_type == 'US Jurisdictional':
    #         cols[cols.index('rate')] = 'indeterminte'

    return q, cols, export_scheme


def _csv_write(file, result, scheme, only=None, headers=True, row_callback=None):
    def _q_str(q):
        return str(q.statement.compile(dialect=postgresql.dialect(), compile_kwargs={"literal_binds": True}))

    def _batched_query(query, batch_size):
        iterable = query.yield_per(batch_size).enable_eagerloads(False)
        iterator = iter(iterable)
        while True:
            batch = list(islice(iterator, batch_size))
            if not batch:
                break
            yield batch

    csvfile = file  # open(file, 'wt+')
    if not only:
        fieldnames = scheme.Meta.fields
    else:
        fieldnames = only
    writer = csv.DictWriter(csvfile, fieldnames=fieldnames)
    if headers:
        writer.writeheader()
    # dump=SchemeClass().dump(result,many=True).data
    # writer.writerows(dump)
    i = 0
    model.get_db().tr_session.commit()
    result = model.get_db().tr_session.query(*fieldnames).from_statement(_q_str(result))
    batch_size = 5000
    for rows in _batched_query(result, batch_size):
        # Dump multiple rows at once
        dumps = scheme.dump(rows, many=True)
        
        # Write all rows in batch
        writer.writerows(dumps.data)
        
        if i == 0:
            log.debug('export row scheme {}'.format(scheme.__dict__))
            log.debug('export row fieldnames {}'.format(fieldnames))
            log.debug('export first row content {}'.format(rows[0]))
            log.debug('export first row dump {}'.format(dumps.data[0]))
            log.debug('export row dump errors {}'.format(dumps.errors))
        
        i += len(rows)
        if row_callback:
            row_callback(i)
    return i


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def export_file(object_id):
    def _norm(fn):
        return fn.replace(' ', '_').replace(':', '_').replace('+', '_').replace('.', '_').replace('-', '_')

    db1 = initialize_db(conn_string=settings.DB_CONN_STRING, declarative_base=DnlApiBaseModel, db_label='support')
    ImportExportLogs.db_label = 'support'
    try:
        obj = ImportExportLogs.get(object_id)
        if obj.status == 'in progress':
            log.debug('export_file already running {}'.format(object_id))
            return True
        if obj.log_type != 'export':
            log.debug('export_file got not not export id {}'.format(object_id))
            return
        q, cols, export_scheme = create_export_query(obj)
        query = obj._query
        fmt = query['format']
        obj.file_path = settings.FILES['upload_to']
        obj.file_name = _norm(obj.obj + '_' + str(datetime.now(UTC)) + '.' + query['format'])
        if obj.obj == 'Rate':
            rate_table_id = query['where']['value'] if 'where' in query and 'value' in query['where'] else 0
            if rate_table_id:
                rt = RateTable.filter(RateTable.rate_table_id == rate_table_id).first()
                if rt:
                    obj.file_name = rt.name + obj.file_name
        obj.error_file_path = _norm(obj.obj + '_' + str(datetime.now(UTC)) + '.err')
        error_path = obj.file_path + '/' + obj.error_file_path
        error = open(error_path, 'wt+' if fmt != 'xls' else 'wb+')

        log.debug('final export query is:{}'.format(str(q)))
        # result = q.first()
        # if not result:
        #    error.write('nothing to export!')
        #    raise ValidationError('nothing to export!')
        result = q
        obj.finished_time = None
        obj.status = 'in progress'
        obj.save()
        # --ouput--
        if fmt == 'xls':
            query['header'] = 'no'
        file_path = obj.file_path + '/' + obj.file_name
        file = open(file_path, 'wt+' if fmt != 'xls' else 'wb+')

        headers = 'header' not in query or query['header'] == 'yes'
        if 'header_text' in query and query['header_text'] != '':
            file.write(query['header_text'])
            file.write('\n')
        if fmt == 'csv':
            def row_callback(i):
                if i % 5000 == 0:
                    cls = ImportExportLogs
                    cls.filter(cls.id == object_id).update(dict(db_process_number=i, finished_time=None),
                                                           synchronize_session='fetch')
                    cls.session().commit()
                    log.debug('export_file rows exported: {}'.format(str(i)))
            rows = _csv_write(file, result, export_scheme, cols, headers, row_callback)
            obj.db_process_number = rows
        elif fmt == 'json':
            _json_write(file, result, export_scheme, cols)
        elif fmt == 'xml':
            _xml_write(file, result, export_scheme, cols)
        elif fmt == 'xls':
            _xls_write(file, result, export_scheme, cols)
        else:
            obj.status = 'fail'
            error.write('Format not implemented...')
            raise ValidationError('Format not implemented...')
        if 'footer_text' in query and query['footer_text'] != '':
            file.writelines(query['footer_text'])
        file.close()
        obj.status = 'success'
        obj.finished_time = datetime.now(UTC)
        obj.save()
    except Exception as e:
        error.write(str(e))
        obj.status = 'fail'
        obj.finished_time = datetime.now(UTC)
        obj.save()
        raise e
    finally:
        ImportExportLogs.db_label = 'default'
        error.close()

