import celery
import logging
from api_dnl import settings
from datetime import datetime, timedelta
from pytz import UTC
from time import mktime
import io, csv, gzip, zipfile
import os, shutil
import xlwt
import json
from api_dnl.utils.imp_exp import (csv2xls, dict_to_csv)
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, or_, not_, text as text_, PrimaryKeyConstraint, inspect, Index,
                        UniqueConstraint)
from sqlalchemy.sql import func, select, alias, case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import Client, Client, Resource, ResourcePrefix, Rate, RateTable, RateSendLog, BalanceHistoryActual, \
    C4ClientBalance, \
    RateSendLogDetail, CrdReportDetailTable, MailSender, FraudDetection, FraudDetectionLog, FraudDetectionLogDetail, \
    ResourceBlock, IngressTrunk, SystemParameter, AlertRule, AlertRuleLog, AlertRulesLogDetail, CdrReportDetail, \
    client_cdr, \
    SendRateDirect, MailTemplate, SendRateTemplate, ProductRoutRateTable, ProductClientsRef
from api_dnl.model import PrimaryKeyConstraint, func, query_to_sting, cast, generate_uuid_str, aliased
from api_dnl.tasks import app, log, db, SqlAlchemyTask, SchLog, custom_logger
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.scheme import RateGetScheme

rate_logger = custom_logger('rate')


class SQLALchemyLoggingTask(SqlAlchemyTask):
    def __call__(self, *args, **kwargs):
        # Enable logging
        logger = logging.getLogger('sqlalchemy.engine')
        old_level = logger.getEffectiveLevel()
        logger.setLevel(logging.INFO)

        try:
            # Call the task
            return super().__call__(*args, **kwargs)
        finally:
            # Reset logging level to what it was before the task started
            logger.setLevel(old_level)


@app.task(base=SqlAlchemyTask)
def do_send_rate():
    log.debug('Send rate started')
    sr = RateSendLog.filter(RateSendLog.status == 'waiting').all()
    log.debug('Send rate waiting {}'.format(len(sr)))
    for r in RateSendLog.filter(RateSendLog.status == 'waiting').all():
        send_rate.delay(r.id)


vlog = custom_logger('send_rate')


@app.task(base=SQLALchemyLoggingTask, time_limit=288000, soft_time_limit=287400)
def send_rate(send_rate_id):
    slog = SchLog('send_rate')
    vlog.debug('Send rate log id={} scheduled.'.format(send_rate_id))
    sr = RateSendLog.get(send_rate_id)
    if not sr:
        vlog.debug('Send rate log id={} scheduled. but not found'.format(send_rate_id))
        return False
    # if sr.status != 'waiting':
    #     vlog.warning('Send rate log id={} sheduled but not waiting! skip.'.format(send_rate_id))
    #     return False
    if sr.status != 'waiting':
        vlog.warning('Send rate log id={} already started! skip.'.format(send_rate_id))
        return False
    if not sr.email_template and not sr.email_direct:
        sr.status = 'sent failed'
        sr.error = 'No email template and no direct email!'
        sr.save()
        vlog.warning('Send rate log id={} No email template and no direct email!'.format(send_rate_id))
        return False
    try:

        sr.status = 'generated'
        sr.error = 'temporary busy '
        sr.save()
        vlog.debug('Send rate log id={}'.format(send_rate_id))
        rt = RateTable.get(sr.rate_table_id)
        if not rt:
            sr.status = 'sent failed'
            sr.error = 'No rate_table_id '
            sr.save()
            vlog.warning('Send rate log id={} no rate_table_id'.format(send_rate_id))
            return False

        if sr.start_effective_date:
            objects_list = Rate.filter(and_(Rate.rate_table_id == sr.rate_table_id,
                                            Rate.effective_date <= sr.start_effective_date,
                                            or_(Rate.end_date.is_(None),
                                                Rate.end_date >= sr.start_effective_date))).order_by(
                Rate.effective_date.desc(), Rate.rate_id.desc())
        else:
            objects_list = Rate.filter(and_(Rate.rate_table_id == sr.rate_table_id,
                                            #Rate.effective_date <= func.now(),
                                            or_(Rate.end_date.is_(None), Rate.end_date >= func.now()))).order_by(Rate.rate_id.desc())

        if not sr.effective_date:
            if sr.start_effective_date:
                qed = Rate.session().query(Rate.effective_date).filter(and_(Rate.rate_table_id == sr.rate_table_id,
                                                                            Rate.effective_date <= sr.start_effective_date,
                                                                            or_(Rate.end_date.is_(None),
                                                                                Rate.end_date >= sr.start_effective_date))).group_by(
                    Rate.effective_date).all()
            else:
                qed = Rate.session().query(Rate.effective_date).filter(and_(Rate.rate_table_id == sr.rate_table_id,
                                                                            # Rate.effective_date <= func.now(),
                                                                            or_(Rate.end_date.is_(None),
                                                                                Rate.end_date >= func.now()))).group_by(
                    Rate.effective_date).all()
            if len(qed) == 1:
                eff_date = str(qed[0].effective_date)
            else:
                eff_date = 'Varying Dates'
        else:
            eff_date = str(sr.effective_date)

        hdrs = []
        if sr.email_template:
            hdrs = sr.email_template.headers
            tpl = sr.email_template
        else:
            hdrs = sr.email_direct.headers
            tpl = sr.email_direct
        if sr.indicate_inc_dec:
            hdrs += ['change_status']
        if 'rate' in hdrs and sr.rate_table.jur_type != 'US Jurisdictional':
            new_hdrs = hdrs
        elif 'rate' in hdrs:
            new_hdrs = hdrs[:hdrs.index('rate')] + ['indet_rate'] + hdrs[hdrs.index('rate') + 1:]
        else:
            new_hdrs = hdrs

        class SchemeClass(RateGetScheme):
            class Meta:
                model = Rate
                fields = new_hdrs

        sr.headers = ','.join(new_hdrs)

        vlog.debug('Starting write to file. send_rate_id={} rate_table_id={}'.format(send_rate_id, sr.rate_table_id))

        att = None
        if sr.format in ['csv', 'xls']:
            if not objects_list.first():
                sr.status = 'sent failed'
                sr.err = 'No rates for send_rate_id={} rate_table_id={}'.format(send_rate_id, sr.rate_table_id)
                sr.save()
                vlog.warning('Send rate log send_rate_id={} rate_table_id={} empty '.format(send_rate_id, sr.rate_table_id))
                return
            vlog.debug('Preparing Send rate log')
            csvfile = io.StringIO()
            #fieldnames = data[0].keys()
            writer = csv.DictWriter(csvfile, fieldnames=list(new_hdrs))
            writer.writeheader()
            i = 0
            window_size = 1000  # or whatever limit you like
            rate_list = objects_list.all()
            vlog.debug("send_rate send_rate_id={} rate_table_id={}, things len: {}".format(send_rate_id, sr.rate_table_id, len(rate_list)))
            for start in range(0, len(rate_list), window_size):
                stop = start + window_size
                vlog.debug(
                    "send_rate send_rate_id={} rate_table_id={}. start={} stop={} window_size={} total_len={}".format(
                        send_rate_id, sr.rate_table_id, start, stop, window_size, len(rate_list)
                    )
                )
                temp = rate_list[start:stop]
                if not temp:
                    break
                added = set()
                for rate in temp:
                    setattr(rate, 'indet_rate', rate.rate)
                    data = SchemeClass().dump(rate).data

                    if data['code'] in added:
                        continue

                    if sr.date_format == 'Date Only':
                        if 'effective_date' in data and data['effective_date']:
                            data['effective_date'] = data['effective_date'][0:10]
                        if 'end_date' in data and data['end_date']:
                            data['end_date'] = data['end_date'][0:10]

                    # if sr.effective_date and 'effective_date' in hdrs:
                    #     eff_d = sr.effective_date[0:10]  # str(sr.effective_date.date())
                    #     data['effective_date'] = eff_d
                    # rnd = 2
                    # try:
                    #     rnd = SystemParameter.session().query(SystemParameter.default_billing_decimal).first().default_billing_decimal
                    #     if not rnd:
                    #         rnd = 2
                    # except:
                    #     pass
                    # for f in data.keys():
                    #     if f in ('inter_rate', 'rate','intra_rate','local_rate','indet_rate',) and data[f]:
                    #         data[f] = str(data[f])
                    added.add(data['code'])
                    writer.writerow(data)
                    i += 1
                vlog.debug('send_rate_id={} Send rate {} records done'.format(send_rate_id, i))
                vlog.debug("send_rate_id={} Temp: {}:{}".format(send_rate_id, start, stop))
                vlog.debug("send_rate_id={} Temp: {} (first 10)".format(send_rate_id, temp[:10]))
                if len(temp) < window_size:
                    vlog.debug('len(things) < window_size')
                    break
            sr.total_records = i
            vlog.debug('Send rate send_rate_id={} rate_table_id={}. log total_records={}'.format(send_rate_id, sr.rate_table_id, sr.total_records))
            acsv = csvfile.getvalue()
            csvfile.seek(0)
            vlog.debug('Send rate log csv file ready. send_rate_id={} rate_table_id={}'.format(send_rate_id, sr.rate_table_id))
            sr.completed_records = sum(1 for line in csvfile) - 1
            att = [('{}_{}.csv'.format(rt.name, datetime.now().strftime("%d%Y%m%d%H%M%S")), acsv)]
            if sr.format == 'xls':
                att = [('{}_{}.xls'.format(rt.name, datetime.now().strftime("%d%Y%m%d%H%M%S")), csv2xls(acsv, 'Rate'))]
        elif sr.format == 'json':
            data = SchemeClass().dump(objects_list.all(), many=True).data
            sr.completed_records = len(data)
            att = [('{}_{}.json'.format(rt.name, datetime.now().strftime("%d%Y%m%d%H%M%S")), json.dumps(data))]
        if sr.zip and att:
            out = io.BytesIO()
            name = '{}_{}.zip'.format(rt.name, datetime.now().strftime("%d%Y%m%d%H%M%S"))
            with zipfile.ZipFile(out, mode="w") as f:
                f.writestr(name, att[0][1], zipfile.ZIP_DEFLATED)
            att = [(name, out.getvalue())]
            vlog.debug('Send rate log zip file ready. send_rate_id={} rate_table_id={}'.format(send_rate_id, sr.rate_table_id))
        method = 'attachment'
        #if sr.download_method == 'link' or
        sr.file = att[0][0]
        file_path = os.path.expanduser(settings.FILES['upload_to']) + '/' + sr.file
        if type(att[0][1]) == type(b''):
            f = open(file_path, 'wb')
            f.write(att[0][1])
        else:
            f = open(file_path, 'wt')
            f.write(att[0][1])
        if (sr.email_direct and sr.email_direct.download_method == 'send as link') or \
                (sr.email_template and sr.email_template.download_method == 'send as link'):
            method = 'link'
            att = []
            if not sr.download_deadline:
                sr.download_deadline = (datetime.now(UTC) + timedelta(days=2)).date()
        f.close()
        sr.status = 'generated'
        sr.save()
        vlog.debug("Finished writing to file. send_rate_id={} rate_table_id={}".format(send_rate_id, sr.rate_table_id))
        vlog.warning(
            'Send rate log send_rate_id={} rate_table_id={} attachment {} generated '.format(send_rate_id, sr.rate_table_id,
                                                                                   sr.file))
        errors = 0
        err_list = []

        vlog.debug("Send rate. send_rate_id={} rate_table_id={} . send_type: {}, trunks: {}".format(send_rate_id, sr.rate_table_id, sr.send_type, sr.trunks))
        if sr.send_type in (
                'Send to carriers using this rate table', 'Send to specified trunks', 'Send to specified carriers'):
            if sr.send_type == 'Send to carriers using this rate table':
                if not sr.trunks:
                    vlog.debug('send_rate. resource_ids. 1 method.')
                    res_pref = aliased(ResourcePrefix)
                    active_resources = (
                        Resource.query()
                        .filter(Resource.active == True, Resource.ingress == True)
                        .with_entities(Resource.resource_id)
                        .subquery()
                    )
                    q = (
                        res_pref.query()
                        .filter(
                            res_pref.rate_table_id == sr.rate_table_id,
                            res_pref.resource_id.in_(active_resources)
                        )
                        .all()
                    )
                    trunks = [tr.resource_id for tr in q]
                    vlog.debug("send_rate. send_rate_id={}. trunks: {}".format(send_rate_id, trunks))
                    sr.trunks = trunks
                else:
                    sr.send_type = 'Send to specified trunks'
            for resource_id in sr.trunks:
                if resource_id == '':
                    continue
                trunk = Resource.get(resource_id)
                is_sent = False
                if trunk and trunk.client:
                    try:
                        email = getattr(trunk.client, tpl.to_mail, '')
                        if email is None or email == '':
                            email = trunk.client.email
                        if sr.send_specify_email:
                            email = '{};{}'.format(sr.send_specify_email, email)
                        l = RateSendLogDetail(log_id=send_rate_id, resource_id=resource_id, send_to=email,
                                              status='In Progress')
                        l.save()
                        trunk.download_deadline = str(sr.download_deadline)
                        if method == 'link':
                            trunk.download_link = str(l.download_link)
                            trunk.download_token = str(l.download_token)
                        else:
                            trunk.download_link = 'download in attachment link not applicable'
                            trunk.download_token = 'download in attachment link not applicable'
                            trunk.download_deadline = 'not applicable with attachment'
                            sr.download_deadline = None
                            sr.save()
                        trunk.effective_date = eff_date
                        trunk.fmt_billing_type = rt.rate_type
                        trunk.fmt_jur_type = rt.jur_type
                        trunk.rate_filename = l.file
                        trunk.fmt_rate_table_name = rt.name
                        trunk.fmt_name = trunk.client_name

                        trunk.fmt_prefix = ','.join([p.tech_prefix for p in trunk.prefixes if p.rate_table_id == sr.rate_table_id])
                        res = None
                        if not is_sent:
                            if sr.email_template:
                                res = trunk.apply_mail('sendrate_' + str(sr.email_template_id), email, att=att)
                            else:
                                res = trunk.apply_mail('sendratedirect_' + str(sr.id), email, att=att)
                            is_sent = True
                        vlog.debug('send_rate_id={}. Send rate apply mail(1) res {}'.format(send_rate_id, res))
                        if res:
                            mail_sender_last_error = res[1]
                            l.error = mail_sender_last_error
                            err_list.append(mail_sender_last_error)
                            l.status = 'failed'
                            errors += 1
                        else:
                            if method == 'link':
                                l.status = 'Not Yet Downloaded'
                            else:
                                l.status = 'completed'
                            l.sent_on = datetime.now(UTC)
                            sr.save()
                    except Exception as e:
                        l.error = str(e)[0:500]
                        l.status = 'failed'
                    l.save()
        else:
            class Rec:
                def __init__(self):
                    self.prefixes = []

            emails = sr.send_specify_email.split(';')
            for email in emails:
                try:
                    if not email or email == '':
                        continue
                    trunk = Rec()
                    trunk.email = email
                    trunk.rate_email = email
                    trunk.client_name = email
                    trunk.effective_date = eff_date
                    l = RateSendLogDetail(log_id=send_rate_id, resource_id=None, send_to=email,
                                          status='In Progress')
                    l.save()
                    trunk.download_deadline = str(sr.download_deadline)
                    if method == 'link':
                        trunk.download_link = str(l.download_link)
                        trunk.download_token = str(l.download_token)
                    else:
                        trunk.download_link = 'download in attachment link not applicable'
                        trunk.download_token = 'download in attachment link not applicable'
                        trunk.download_deadline = 'not applicable with attachment'
                        sr.download_deadline = None
                        sr.save()
                    trunk.fmt_billing_type = rt.rate_type
                    trunk.fmt_jur_type = rt.jur_type
                    trunk.fmt_rate_table_name = rt.name
                    trunk.fmt_allowed_ip = 'n/a'
                    trunk.fmt_switch_ip = rt.switch_ip
                    trunk.rate_filename = l.file
                    trunk.fmt_rate_table_name = rt.name
                    trunk.fmt_name = trunk.client_name
                    trunk.trunk_name = 'trunk name not applicable'

                    
                    trunk.fmt_prefix = ','.join([p.tech_prefix for p in model.ResourcePrefix.filter(model.ResourcePrefix.rate_table_id == sr.rate_table_id).all()])
                    res = None
                    if sr.email_template:
                        res = MailSender.apply_mail(trunk, 'sendrate_' + str(sr.email_template_id), email, att=att)
                    else:
                        res = MailSender.apply_mail(trunk, 'sendratedirect_' + str(sr.id), email, att=att)
                    vlog.debug('send_rate_id={}. Send rate apply mail(2) res {}'.format(send_rate_id, res))
                    if res:
                        mail_sender_last_error = res[1]
                        l.error = mail_sender_last_error
                        err_list.append(mail_sender_last_error)
                        l.status = 'failed'
                        errors += 1
                    else:
                        if method == 'link':
                            l.status = 'Not Yet Downloaded'
                        else:
                            l.status = 'completed'
                        l.sent_on = datetime.now(UTC)
                        sr.save()
                except Exception as e:
                    l.error = str(e)[0:500]
                    l.status = 'failed'
                    l.save()
        vlog.debug('Send rate send_rate_id={}. errors={}'.format(send_rate_id, errors))
        if not errors:
            sr.status = 'sent success'
            sr.error = None
            sr.save()
            vlog.debug('Send rate finished with success. send_rate_id={}'.format(send_rate_id))
        else:
            try:
                err_list = set(err_list)
                e = ','.join(err_list)
            except:
                e = 'mail send error'
            vlog.debug('Send rate finished with errors. send_rate_id={}, errors={}'.format(send_rate_id, e))
            sr.status = 'sent failed'
            sr.err = 'Send rate mail failed {} times'.format(e)
            sr.save()
            vlog.warning('Send rate id={} mail errors={}'.format(send_rate_id, e))
    except Exception as e:
        sr.status = 'sent failed'
        sr.err = 'Send rate id={} error={}'.format(send_rate_id, str(e))
        try:
            sr.save()
            vlog.error('Send rate send_rate_id={} error={}'.format(send_rate_id, str(e)))
        except Exception as e:
            vlog.error('Send rate send_rate_id={} fatal error={}'.format(send_rate_id, str(e)))
            db.session.rollback()
        slog.close()
        return False
    slog.close()
    return True


@app.task(base=SqlAlchemyTask, time_limit=1800, soft_time_limit=1790)
def send_rate_task(rate_table_id, clients):
    log.debug('send_rate_task start')
    slog = SchLog('send_rate_task')
    sr = RateSendLog(rate_table_id=rate_table_id, status='waiting')
    try:
        sr.error = 'temporary busy'
        tpl = MailTemplate.get('rate')
        email_direct = SendRateDirect(sender_id=tpl.from_mail_id, subject=tpl.subject, content=tpl.html_content,
                                      #header=SendRateTemplate.HEADERS,
                                      download_method='send as link',
                                      mail_cc=tpl.cc_mail)
        sr.email_direct = email_direct

        trunks = []
        for client_id in clients:
            cl = Client.get(client_id)
            if cl.resources and len(cl.resources):
                trunks.append(cl.resources[0].resource_id)
        log.debug(f'send_rate_task rate_table_id: {rate_table_id}, trunks: {trunks}')
        sr.trunks = trunks
        sr.send_type == 'Send to specified trunks'
        sr.format = 'csv'
        rate_id = sr.save()
        slog.close()
        log.debug('send_rate_task end success')
        return send_rate(rate_id)
    except Exception as e:
        sr.status = 'sent failed'
        sr.err = 'Send rate task error={}'.format(str(e))
        try:
            sr.save()
            log.error('Send rate task error={}'.format(str(e)))
        except Exception as e:
            log.error('Send rate task fatal error={}'.format(str(e)))
            db.session.rollback()
        slog.close()
        log.debug('send_rate_task end error')
        return False


@app.task(base=SqlAlchemyTask, time_limit=1800, soft_time_limit=1790)
def send_client_product_to_emails_task(client_id, product_id, emails):
    job_id = None
    slog = SchLog('send_rate_to_emails_task')
    pr = ProductRoutRateTable.get(product_id)
    sr = RateSendLog(rate_table_id=pr.rate_table_id, status='waiting')
    try:
        sr.error = 'temporary busy'
        tpl = MailTemplate.get('rate')
        email_direct = SendRateDirect(sender_id=tpl.from_mail_id, subject=tpl.subject, content=tpl.html_content,
                                      #header=SendRateTemplate.HEADERS,
                                      download_method='send as link',
                                      mail_cc=tpl.cc_mail)
        sr.email_direct = email_direct

        sr.send_type == 'Specify my own recipients'
        sr.send_specify_email = emails
        sr.format = 'csv'
        job_id = sr.save()
        if job_id:  #send_rate(job_id):
            q = ProductClientsRef.filter(
                and_(ProductClientsRef.product_id == product_id, ProductClientsRef.client_id == client_id))
            if not q:
                q = ProductClientsRef(product_id == product_id, client_id=client_id)
            q.rate_last_sent = datetime.now(UTC)
            q.save()

    except Exception as e:
        sr.status = 'sent failed'
        sr.err = 'Send rate task error={}'.format(str(e))
        try:
            job_id = sr.save()
            log.error('Send rate task error={}'.format(str(e)))
        except Exception as e:
            log.error('Send rate task fatal error={}'.format(str(e)))
            db.session.rollback()
    finally:
        slog.close()
        return job_id
