from reportlab.lib.pagesizes import letter,A4
from reportlab.lib import colors
from reportlab.lib.styles import getSampleStyleSheet, ParagraphStyle
from reportlab.lib.units import inch, mm
from reportlab.platypus.flowables import KeepTogether
from reportlab.platypus import SimpleDocTemplate, Paragraph, Spacer, Image, Table, \
    Frame, BaseDocTemplate, PageTemplate, FrameBreak,TableStyle
from reportlab.lib.enums import TA_LEFT, TA_CENTER,TA_RIGHT,TA_JUSTIFY


class ColorFrame(Frame):
    def __init__(
            self, x1, y1, width, height, leftPadding=6, bottomPadding=6,
            rightPadding=6, topPadding=6, id=None, showBoundary=0,
            overlapAttachedSpace=None, _debug=None, background=None):
        Frame.__init__(
            self, x1, y1, width, height, leftPadding,
            bottomPadding, rightPadding, topPadding, id, showBoundary,
            overlapAttachedSpace, _debug)

        self.background = background

    def drawBackground(self, canv):
        color = colors.toColor(self.background)

        canv.saveState()
        canv.setFillColor(color)
        canv.rect(
            self._x1, self._y1, self._x2 - self._x1, self._y2 - self._y1,
            stroke=0, fill=1
        )
        canv.restoreState()

    def addFromList(self, drawlist, canv):
        if self.background:
            self.drawBackground(canv)
        Frame.addFromList(self, drawlist, canv)


class OrigInvoiceRender(object):
    def __init__(self, data, filename):
        self._cont = data
        self._filename = filename
        self._logo = data.pop('logo',None)
        self._doc = None
        self._story = []
        self._frame = None

        style_sheet = getSampleStyleSheet()
        self._style = style_sheet["BodyText"]
        self._t_style = ParagraphStyle(
            name='Tables', leftIndent=40, rightIndent=40)

    def _add_page_number(self, canvas, doc):
        page_num = canvas.getPageNumber()
        text = "Page #%s" % page_num
        canvas.drawRightString(200 * mm, 20 * mm, text)
        # self.frame.drawBackground(canvas)

    @staticmethod
    def _get_total_by_column(table, column, column_type=float, round_digits=2):
        return round(
            sum([column_type(row[column]) for row in table]), round_digits)

    def _para(self, content):
        # adding check in case the content is None
        if content == None:
            return Paragraph(" ", self._style)

        return Paragraph(content, self._style)

    def _t_para(self, content):
        # adding check in case the content is None
        if content == None:
            return Paragraph(" ", self._t_style)
        return Paragraph(content, self._t_style)

    def _para_bank_info(self):
        if self._cont["pdf_tpl"] == None:
            return self._para(" ")
        return self._para(self._cont["pdf_tpl"])

    def _render_footer(self):
        data = [
            ["", "", ""],
            [
                self._para_bank_info() if self._cont["tpl_number"] == 0 else "",
                self._para_bank_info() if self._cont["tpl_number"] == 2 else "",
                ""
            ],
            ["", "", ""],
        ]
        return Table(
            data,
            style=[
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('TOPPADDING', (0, 0), (-1, -1), 0),
                ('ALIGN', (0, 0), (-1, -1), 'CENTER'),
                ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
            ])

    def _render_header(self):
        logo = Image(self._logo)
        logo.drawHeight = 0.5 * inch
        logo.drawWidth = 1 * inch

        c_name = self._para(
            "<para align=right><font size=9><b>Billed to:</b> {}</font></para>".format(
                self._cont["client_name"]))
        inv_number = self._para(
            "<para align=right><font size=9><b>Invoice#:</b> {}</font></para>".format(
                self._cont["invoice_name"]))
        inv_date = self._para(
            "<para align=right><font size=9><b>Invoice Date:</b> {}</font></para>".format(
                self._cont["bill_date"]))
        due_date = self._para(
            "<para align=right><font size=9><b>Payment Due Date:</b> {}</font></para>".format(
                self._cont["due_date"]))
        billing_period = self._para(
            "<para align=right><font size=9><b>Billing Period:</b> {}</font></para>".format(
                self._cont["billing_period"]))
        client_data = [
            [c_name],
            [inv_number],
            [inv_date],
            [due_date],
            [billing_period],
        ]
        client_table = Table(
            client_data,
            style=[
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('TOPPADDING', (0, 0), (-1, -1), 0),
                ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
            ])

        p_name = self._para(self._cont["company_info"])
        p_bank = self._para_bank_info() if self._cont["tpl_number"] == 1 else ""
        data = [
            [logo, ""],
            ["", ""],
            [p_name, client_table],
            ["", ""],
            [p_bank, ""],
        ]
        return Table(
            data,
            style=[
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('TOPPADDING', (0, 0), (-1, -1), 0),
                ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
            ])

    def _render_summary(self):
        account_summary = self._para(
            "<b><font size=11>Account Summary</font></b>")
        prev_balance_label = self._para("<font size=9>Previous Balance</font>")
        prev_balance = self._para(
            "<b><font size=9>{}</font></b>".format(self._cont["prev_balance"]))
        long_distance_charges_label = self._para(
            "<font size=9>Long Distance Charges</font>")
        long_distance_charges = self._para(
            "<b><font size=9>{}</font></b>".format(self._cont["long_distance_charges"]))
        recurring_charges_label = self._para(
            "<font size=9>Recurring Charges</font>")
        recurring_charges = self._para(
            "<b><font size=9>{}</font></b>".format(self._cont["recurring_charges"]))
        amount_due_label = self._para("<font size=9>Amount Due</font>")
        amount_due = self._para(
            "<b><font size=9>{}</font></b>".format(self._cont["amount_due"]))
        due_date_label = self._para("<font size=9>Due Date</font>")
        due_date = self._para(
            "<b><font size=9>{}</font></b>".format(self._cont["due_date"]))
        data = [
            [account_summary, ""],
            [prev_balance_label, prev_balance],
            [long_distance_charges_label, long_distance_charges],
            [recurring_charges_label, recurring_charges],
            [amount_due_label, amount_due],
            [due_date_label, due_date],
        ]
        return Table(
            data,
            style=[
                ('BOTTOMPADDING', (0, 0), (1, 0), 4),
                ('TOPPADDING', (0, 1), (-1, -1), 0),
                ('BOTTOMPADDING', (0, 1), (-1, -1), 0),
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('SPAN', (0, 0), (1, 0)),
                ('LINEABOVE', (0, 1), (1, 1), 0.5, colors.black),
                ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
            ])

    def _render_transaction_summary_analysis(self):
        table_header = self._para(
            "<b><font size=11>Transaction Summary Analysis</font></b>")
        date_label = self._para("<b><font size=9>Date</font></b>")
        description_label = self._para(
            "<b><font size=9>Description</font></b>")
        amount_label = self._para("<b><font size=9>Amount</font></b>")
        data = [
            [table_header, "", ""],
            ["", "", ""],
            [date_label, description_label, amount_label],
        ]
        data.extend(self._cont["transaction_summary_analysis"])
        return Table(
            data,
            style=[
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                ('SPAN', (0, 0), (2, 0)),
                ('LINEABOVE', (0, 1), (2, 1), 0.5, colors.black),
                ('BACKGROUND', (0, 2), (2, 2), colors.HexColor('#b5b5b5')),
                ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                ('INNERGRID', (0, 2), (-1, -1), 0.5, colors.white),
                ('ALIGN', (2, 3), (2, -1), 'RIGHT'),
            ])

    @property
    def _total_label(self):
        return self._para("<b><font size=9>TOTAL</font></b>")

    @property
    def _num_calls_label(self):
        return self._para("<b><font size=9># OF CALLS</font></b>")

    @property
    def _total_minutes_label(self):
        return self._para("<b><font size=9>TOTAL MINUTES</font></b>")

    @property
    def _charge_label(self):
        return self._para("<b><font size=9>CHARGE</font></b>")

    @property
    def _location_label(self):
        return self._para("<b><font size=9>LOCATION</font></b>")

    def _render_authorization_code_summary_report(self):
        report_table = self._cont["authorization_code_summary_report"]
        table_header = self._para(
            "<b><font size=11>AUTHORIZATION CODE (800) SUMMARY REPORT</font></b>")
        authorization_code_label = self._para(
            "<b><font size=9>DID</font></b>")
        name_label = self._para("<b><font size=9>Type</font></b>")
        data = [
            [table_header, "", "", "", ""],
            ["", "", "", "", ""],
            [
                authorization_code_label, name_label, self._num_calls_label,
                self._total_minutes_label, self._charge_label],
        ]
        # report table must be cut without end line
        new_rp_table = []
        for row in report_table:
            new_rp_table.append(row[:-1])
        report_table = new_rp_table
        data.extend(report_table)

        total = [
            self._total_label,
            "",
            self._get_total_by_column(report_table, 2, int),
            self._get_total_by_column(report_table, 3, float),
            self._get_total_by_column(report_table, 4, float),
        ]
        data.extend([total])
        return Table(
            data,
            style=[
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                ('SPAN', (0, 0), (4, 0)),
                ('LINEABOVE', (0, 1), (4, 1), 0.5, colors.black),
                ('BACKGROUND', (0, 2), (4, 2), colors.HexColor('#b5b5b5')),
                ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                ('INNERGRID', (0, 2), (-1, -1), 0.5, colors.white),
                ('ALIGN', (2, 3), (4, -1), 'RIGHT'),
                ('SPAN', (0, -1), (1, -1)),
                ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')),
            ])

    def _render_all_area_codes_summary_report(self):
        report_table = self._cont["all_area_codes_summary_report"]
        table_header = self._para(
            "<b><font size=11>ALL AREA CODES SUMMARY REPORT</font></b>")
        area_code_inbound_label = self._para(
            "<b><font size=9>AREA CODE INBOUND</font></b>")
        data = [
            [table_header, "", "", "", ""],
            ["", "", "", "", ""],
            [
                area_code_inbound_label, self._location_label,
                self._num_calls_label, self._total_minutes_label,
                self._charge_label],
        ]
        data.extend(report_table)
        total = [
            self._total_label,
            "",
            self._get_total_by_column(report_table, 2, int),
            self._get_total_by_column(report_table, 3, float),
            self._get_total_by_column(report_table, 4, float),
        ]
        data.extend([total])
        return Table(
            data,
            style=[
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                ('SPAN', (0, 0), (4, 0)),
                ('LINEABOVE', (0, 1), (4, 1), 0.5, colors.black),
                ('BACKGROUND', (0, 2), (4, 2), colors.HexColor('#b5b5b5')),
                ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                ('INNERGRID', (0, 2), (-1, -1), 0.5, colors.white),
                ('ALIGN', (2, 3), (4, -1), 'RIGHT'),
                ('SPAN', (0, -1), (1, -1)),
                ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')),
            ])

    def _render_origination_lata_summary_report(self):
        report_table = self._cont["origination_lata_summary_report"]
        table_header = self._para(
            "<b><font size=11>ORIGINATION LATA SUMMARY REPORT</font></b>")
        origination_lata_label = self._para(
            "<b><font size=9>ORIGINATION LATA</font></b>")
        data = [
            [table_header, "", "", "", ""],
            ["", "", "", "", ""],
            [
                origination_lata_label, self._location_label,
                self._num_calls_label, self._total_minutes_label,
                self._charge_label],
        ]
        data.extend(report_table)
        total = [
            self._total_label,
            "",
            self._get_total_by_column(report_table, 2, int),
            self._get_total_by_column(report_table, 3, float),
            self._get_total_by_column(report_table, 4, float),
        ]
        data.extend([total])
        return Table(
            data,
            style=[
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                ('SPAN', (0, 0), (4, 0)),
                ('LINEABOVE', (0, 1), (4, 1), 0.5, colors.black),
                ('BACKGROUND', (0, 2), (4, 2), colors.HexColor('#b5b5b5')),
                ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                ('INNERGRID', (0, 2), (-1, -1), 0.5, colors.white),
                ('ALIGN', (2, 3), (4, -1), 'RIGHT'),
                ('SPAN', (0, -1), (1, -1)),
                ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')),
            ])

    def generate(self):
        # self.doc = SimpleDocTemplate(
        #     self.filename, pagesize=letter)
        self._doc = BaseDocTemplate(
            self._filename, pagesize=letter)
        page_width, page_height = letter
        self._frame = Frame(
            self._doc.leftMargin, self._doc.bottomMargin,
            self._doc.width, self._doc.height,
            leftPadding=10, rightPadding=10,
            showBoundary=0)
        self._doc.addPageTemplates(
            [PageTemplate(id='Col', onPage=self._add_page_number, frames=[self._frame]), ])

        self._story.append(self._render_header())
        self._story.append(Spacer(page_width, 30))

        # data = [
        #     [""],
        #     [self._render_summary()],
        #     [self._render_transaction_summary_analysis()],
        #     [self._render_authorization_code_summary_report()],
        #     [self._render_all_area_codes_summary_report()],
        #     [self._render_origination_lata_summary_report()],
        #     [""],
        # ]
        # inv_table = Table(
        #     data,
        #     style=[
        #         ('LEFTPADDING', (0, 0), (-1, -1), 40),
        #         ('RIGHTPADDING', (0, 0), (-1, -1), 40),
        #         ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
        #     ])
        # self.story.append(inv_table)
        if self._cont['show_account_summary']:
            self._story.append(self._render_summary())
        if self._cont['show_transaction_summary_analysis']:
            self._story.append(KeepTogether(self._render_transaction_summary_analysis()))
        if self._cont['show_authorization_code_summary']:
            self._story.append(KeepTogether(self._render_authorization_code_summary_report()))
        if self._cont['show_all_area_codes_summary']:
            self._story.append(KeepTogether(self._render_all_area_codes_summary_report()))
        if self._cont['show_origination_lata_summary']:
            self._story.append(KeepTogether(self._render_origination_lata_summary_report()))
        self._story.append(Spacer(page_width, 30))
        self._story.append(self._render_footer())

        self._doc.build(self._story)

        # self.doc.build(
        #     self.story,
        #     onFirstPage=self._add_page_number,
        #     onLaterPages=self._add_page_number)

        return True


ROWHEIGHT = 15
MM_TO_PIXEL = 297 / 842
PIXEL_TO_MM = 842 / 297


class TermInvoiceRender(object):
    """"""

    # ----------------------------------------------------------------------
    def __init__(self, pdf_file, org, client_info, summary_of_charges, acount_sumary, summary_of_payments, usage_detail,
                 get_jurisdict, day_usage, ingress_prefix,
                 show_trafic_code_name, show_trafic_country, show_code_summery, detail_trunk, show_calls_date,
                 include_origination_billing, logo_file, switch_settings, ShowDetailByCodeName,
                 breakdown_by_rate_table, is_jurisdict=False):
        if is_jurisdict == False:
            self.c = SimpleDocTemplate(pdf_file, pagesize=A4, rightMargin=10, leftMargin=10)
        else:
            self.c = SimpleDocTemplate(pdf_file, pagesize=A4, rightMargin=5, leftMargin=5)
        self.c.title = 'Your invoice'
        self.styles = getSampleStyleSheet()
        self.width, self.height = A4
        self.page_width = self.width
        # self.stylesp =  ParagraphStyle()
        self.organization = org
        # self.seconds  = 10
        self.client_info = client_info
        self.summary_of_charges = summary_of_charges
        self.acount_sumary = acount_sumary
        self.summary_of_payments = summary_of_payments
        self.usage_detail = usage_detail
        self.get_jurisdict = get_jurisdict
        self.day_usage = day_usage
        self.ingress_prefix = ingress_prefix
        self.ShowDetailByCodeName = ShowDetailByCodeName
        self.show_trafic_code_name = show_trafic_code_name
        self.show_trafic_country = show_trafic_country
        self.show_code_summery = show_code_summery
        self.detail_trunk = detail_trunk
        self.show_calls_date = show_calls_date
        self.include_origination_billing = include_origination_billing
        self.logo_file = logo_file
        self.switch_settings = switch_settings
        self.tpl_number = self.switch_settings.get('tpl_number', 0)
        # print ("self.tpl_number ",self.tpl_number)
        self.breakdown_by_rate_table = breakdown_by_rate_table
        self.parts = []
        self.Story = []
        styleSheet = getSampleStyleSheet()
        self.styleN = styleSheet["BodyText"]
        self.style = styleSheet["BodyText"]
        self.drawHeight = 0.5 * inch
        self.drawWidth = 1 * inch
        self.is_jurisdict = is_jurisdict

    def get_total_by_column(self, table, column, column_type=float, round_digits=0):
        print(table[0][column])
        print(type(table[0][column]))
        print(float(table[0][column]))
        return round(sum([column_type(row[column]) for row in table]), round_digits)

    # ----------------------------------------------------------------------
    def createDocument(self):
        client_info = self.client_info
        print("client_info", client_info)
        client_info[1] = """Address:%s<br/> """ % client_info[1] if client_info[1] != None and len(
            client_info[1]) != 0 else ""
        if client_info[6] == None:
            client_info[6] = '+0'
        company_info = self.switch_settings.get("company_info", "N/A")
        if company_info == None or company_info.strip() == "":
            company_info = " N/A  "
        try:
            denovo_info = """<font size=9> %s
		</font>
		""" % company_info.replace("<br />", "").replace("<br/>", "").replace('</p>\r', '</p><br/> ').strip()  # [1:]
        except:
            denovo_info = "N/A "

        print("createDocument")
        print("denovo_info", denovo_info)

        bill_address = """<para align=right> <font size="9">
		Billed to:%s<br/>
		%s
		<b>Invoice#</b> %s<br/>
		<b>Invoice Date:</b>%s<br/>
		<b>Payment Due Date:</b> %s<br/>
		<b>Billing Period:</b> %s<br/>
		<b>Invoice time zone:</b> GMT %s</font></para>
		"""
        bill_address = bill_address % (
        client_info[0], client_info[1], client_info[2], client_info[3], client_info[4], client_info[5], client_info[6])
        logo_style = self.styles["Normal"]
        logo_style.alignment = TA_LEFT
        # ParagraphStyle
        address_p = Paragraph(denovo_info, self.styleN)
        bill_address_p = Paragraph(bill_address, self.style)  # self.style['right']
        # bill_address_p.wrapOn(self.c, self.width-200, self.height)

        # add a logo and size it
        logo = Image(self.logo_file)
        logo.drawHeight = inch
        logo.drawWidth = inch

        if self.tpl_number == 1:
            try:
                denovo_billing = """<font size=9>%s</font>""" % self.switch_settings.get("pdf_tpl", "N/A").replace(
                    '</p>\r', '</p><br/>').replace('<br />', '<br/>').replace('\r', '<br/>').replace('：', ':').strip()
                denovo_billing_p = Paragraph(denovo_billing, self.styleN)
            except:
                denovo_billing = " N/A"
                denovo_billing_p = Paragraph(denovo_billing, self.styleN)


        else:
            denovo_billing_p = ""

        data = [[logo, bill_address_p], ["", ""], [address_p, ""], [denovo_billing_p, ""]]  # ,["",bill_address_p]]
        table = Table(data)

        table.setStyle([('VALIGN', (0, 0), (1, 1), 'MIDDLE'), ('VALIGN', (0, 1), (0, 1), 'TOP'), (
        'ALIGN', (0, 1), (0, 1), 'LEFT')])  # .setStyle(TableStyle([('VALIGN',(-1,-1),(-1,-1),'MIDDLE')]))

        self.Story.append(table)
        self.Story.append(Spacer(self.width, 30))

        # ACOUNT SUMMARY
        if self.acount_sumary != None and len(self.acount_sumary) > 1:
            plabel = Paragraph("<b><font size=11 > Account Summary</font></b>", self.style)
            data = [[plabel, ""]]
            data.extend(self.acount_sumary)
            print("Account summery", len(data))
            summary_report = Table(data)
            summary_report.setStyle(TableStyle([
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                ('SPAN', (0, 0), (-1, 0)),
                ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                # ('BACKGROUND', (0, 2), (-1, 2), colors.HexColor('#b5b5b5')),
                ##('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                ('INNERGRID', (0, -1), (-1, -1), 0.5, colors.white),
                ('ALIGN', (-1, 0), (-1, -1), 'RIGHT'),
                # ('SPAN', (0, -1), (1, -1)),
                # ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')),
            ]
            ))

            self.Story.append(summary_report)
            self.Story.append(Spacer(self.width, 30))

        # Summary of Charges
        print("Summary of Charges")
        plabel = Paragraph("<b><font size=11 > Summary of Charges</font></b>", self.style)
        data = [[plabel, ""]]
        data.extend(self.summary_of_charges)
        charges_report = Table(
            data, style=[
                ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                ('SPAN', (0, 0), (-1, 0)),
                ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                ##('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                ('ALIGN', (1, 2), (-1, -1), 'RIGHT'),
                ('SPAN', (0, -1), (-2, -1)),
                # ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')),
            ])
        # print("charges_report",charges_report)
        self.Story.append(charges_report)
        self.Story.append(Spacer(self.width, 30))

        # summary_of_payments
        if self.summary_of_payments != None:
            if len(self.summary_of_payments) > 1:

                print("summary_of_payments ")
                plabel = Paragraph("<b><font size=11 > Summary of Payments</font></b>", self.style)
                data = [[plabel, ""]]
                data.extend(self.summary_of_payments)
                # print ("self.summary_of_payments",self.summary_of_payments)
                # total_row =  ["Total" ,str(self.get_total_by_column(self.summary_of_payments[1:], 1))]
                # print("total_row",total_row)
                # data.extend(total_row)
                payments_report = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                        # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        ('ALIGN', (1, 2), (1, -1), 'RIGHT'),
                    ])
            else:
                # http://jira.denovolab.com/browse/CLAS-5787
                print("summary_of_payments ")
                plabel = Paragraph("<b><font size=11 > Summary of Payments</font></b>", self.style)
                data = [[plabel, ""]]
                data.extend(self.summary_of_payments)
                # greyRow  = Paragraph("<b><font size=11 >  </font></b>",self.style  )
                data.extend(["", ""])
                # print ("self.summary_of_payments",self.summary_of_payments)
                # total_row =  ["Total" ,str(self.get_total_by_column(self.summary_of_payments[1:], 1))]
                # print("total_row",total_row)
                # data.extend(total_row)
                payments_report = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),  # table header
                        ('BACKGROUND', (0, 2), (-1, 2), colors.HexColor('#b5b5b5')),  # greyed row
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        ('ALIGN', (1, 2), (1, -1), 'RIGHT'),
                    ])

            self.Story.append(KeepTogether(payments_report))
            self.Story.append(Spacer(self.width, 30))

        # day_usage

        if self.day_usage != None and len(self.day_usage) > 1:
            print("day_usage_report")
            if not self.is_jurisdict:
                plabel = Paragraph("<b><font size=11 > Daily Usage</font></b>", self.style)
                data = [[plabel, ""]]
                data.extend(self.day_usage)
                day_usage_report = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                        # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        ('ALIGN', (0, 2), (-1, -1), 'RIGHT'),
                        ('SPAN', (0, -1), (1, -1)),
                        ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ])

            else:
                plabel = Paragraph("<b><font size=11 > Daily Usage</font></b>", self.style)
                data = [[plabel, ""]]
                data.extend(self.day_usage)
                day_usage_report = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),  # label
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 2), colors.HexColor('#b5b5b5')),
                        ('FONTSIZE', (0, 1), (-1, 2), 10),  # headers
                        ('FONTSIZE', (0, 3), (-1, -1), 9),  # cells
                        ('FONTSIZE', (0, -1), (0, -1), 10),  # Total cell
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        ('ALIGN', (0, 3), (-1, -1), 'RIGHT'),
                        ('ALIGN', (0, 1), (-1, 2), 'CENTER'),  # headers one
                        ('SPAN', (1, 1), (2, 1)), ('SPAN', (3, 1), (4, 1)), ('SPAN', (5, 1), (6, 1)),
                        ('SPAN', (7, 1), (8, 1)),
                        ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ], colWidths=62.5)

            # print ("day_usage_report new:",day_usage_report)
            self.Story.append(KeepTogether(day_usage_report))
            self.Story.append(Spacer(self.width, 30))

            # ingress_prefix
        if self.ingress_prefix != None and len(self.ingress_prefix) > 1:
            plabel = Paragraph("<b><font size=11 > Summary By Trunk</font></b>", self.style)
            data = [[plabel, ""]]
            data.extend(self.ingress_prefix)
            print("Summary By Trunk")
            if not self.is_jurisdict:

                # data.extend(total_row)
                tb_report_st = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                        # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        ('ALIGN', (2, 2), (-1, -1), 'RIGHT'),
                        ('SPAN', (0, -1), (1, -1)),
                        ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ])
                self.Story.append(KeepTogether(tb_report_st))
                self.Story.append(Spacer(self.width, 30))

            else:
                tb_report_st = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),  # label
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 2), colors.HexColor('#b5b5b5')),
                        ('FONTSIZE', (0, 1), (-1, 2), 10),  # headers
                        ('FONTSIZE', (0, 3), (-1, -1), 9),  # cells
                        ('FONTSIZE', (0, -1), (0, -1), 10),  # Total cell
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        ('ALIGN', (0, 3), (-1, -1), 'RIGHT'),
                        ('ALIGN', (0, 1), (-1, 2), 'CENTER'),  # headers one
                        ('SPAN', (2, 1), (4, 1)), ('SPAN', (5, 1), (7, 1)), ('SPAN', (8, 1), (-1, 1)),
                        ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ],
                    colWidths=[75, 56, 47.5, 47.5, 47.5, 47.5, 47.5, 47.5, 47.5, 47.5, 47.5])  # Summary By Trunk

                self.Story.append(KeepTogether(tb_report_st))
                self.Story.append(Spacer(self.width, 30))

                # usage_detail
        if self.usage_detail != None and len(self.usage_detail) > 1:
            print("Usage Detail")
            print(self.usage_detail)
            plabel = Paragraph("<b><font size=11 > Usage Detail</font></b>", self.style)
            data = [[plabel, ""]]
            data.extend(self.usage_detail)
            tb_usage_detail = Table(
                data, style=[
                    ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                    ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                    ('SPAN', (0, 0), (-1, 0)),  # label
                    ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                    ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                    ('FONTSIZE', (0, 1), (-1, 1), 10),  # headers
                    ('FONTSIZE', (0, 2), (-1, -1), 9),  # cells
                    ('FONTSIZE', (0, -1), (0, -1), 10),  # Total cell
                    ('INNERGRID', (0, 1), (-1, 1), 0.5, colors.white),
                    ('INNERGRID', (0, 2), (-1, -1), 0.5, colors.black),
                    ('ALIGN', (0, 2), (-1, -1), 'RIGHT'),
                    ('ALIGN', (0, 0), (-1, 1), 'CENTER'),  # headers one
                    # ('SPAN', (2, 1), (4, 1)),('SPAN', (5, 1), (7, 1)) , ('SPAN', (8, 1), (-1, 1)),
                    # ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')),
                ],
                colWidths=[100, 90, 90, 50, 120, 110])  # 560: 260,50,50,50,100,50

            self.Story.append(tb_usage_detail)  # KeepTogether(
            self.Story.append(Spacer(self.width, 30))

            # show_trafic_code_name
        if self.show_trafic_code_name != None and len(self.show_trafic_code_name) > 1:
            print("Show traffic code name")
            print(self.show_trafic_code_name)
            plabel = Paragraph("<b><font size=11 >Show traffic code name</font></b>", self.style)
            data = [[plabel, ""]]
            data.extend(self.show_trafic_code_name)
            if not self.is_jurisdict:
                tb_report_code_name = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                        # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        # ('ALIGN', (2, 3), (4, -1), 'RIGHT'),
                        ('SPAN', (0, -1), (1, -1)),
                        ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ])
                self.Story.append(KeepTogether(tb_report_code_name))
                self.Story.append(Spacer(self.width, 30))
            elif len(self.show_trafic_code_name) > 3:
                tb_report_code_name = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),  # label
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 2), colors.HexColor('#b5b5b5')),
                        ('FONTSIZE', (0, 1), (-1, 2), 10),  # headers
                        ('FONTSIZE', (0, 3), (-1, -1), 9),  # cells
                        ('FONTSIZE', (0, -1), (0, -1), 10),  # Total cell
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        ('ALIGN', (0, 3), (-1, -1), 'RIGHT'),
                        ('ALIGN', (0, 1), (-1, 2), 'CENTER'),  # headers one
                        ('INNERGRID', (0, 2), (-1, -1), 0.5, colors.black),
                        ('SPAN', (1, 1), (3, 1)), ('SPAN', (4, 1), (6, 1)), ('SPAN', (7, 1), (9, 1)),
                        ('SPAN', (10, 1), (-11, 1)),
                        ('BACKGROUND', (0, 2), (-1, -1), colors.HexColor('#b5b5b5')), ],
                    colWidths=[60, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7])  # ]  )
                self.Story.append(KeepTogether(tb_report_code_name))
                self.Story.append(Spacer(self.width, 30))

                # show_trafic_country
        if self.show_trafic_country != None and len(self.show_trafic_country) > 1:
            print("Show traffic by Country")
            plabel = Paragraph("<b><font size=11 >Show traffic by Country</font></b>", self.style)
            data = [[plabel, ""]]
            data.extend(self.show_trafic_country)
            if not self.is_jurisdict:

                tb_report_trafic_country = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                        # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        # ('ALIGN', (2, 3), (4, -1), 'RIGHT'),
                        # ('SPAN', (0, -1), (1, -1)),
                        ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ])
                self.Story.append(KeepTogether(tb_report_trafic_country))
                self.Story.append(Spacer(self.width, 30))

            elif len(self.show_trafic_country) > 3:
                tb_report_trafic_country = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),  # label
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 2), colors.HexColor('#b5b5b5')),
                        ('FONTSIZE', (0, 1), (-1, 2), 10),  # headers
                        ('FONTSIZE', (0, 3), (-1, -1), 9),  # cells
                        ('FONTSIZE', (0, -1), (0, -1), 10),  # Total cell
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        ('ALIGN', (0, 3), (-1, -1), 'RIGHT'),
                        ('ALIGN', (0, 1), (-1, 2), 'CENTER'),  # headers one
                        ('SPAN', (1, 1), (3, 1)), ('SPAN', (4, 1), (6, 1)), ('SPAN', (7, 1), (9, 1)),
                        ('SPAN', (10, 1), (-11, 1)),
                        ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ],
                    colWidths=[60, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7])  # ]  )
                self.Story.append(KeepTogether(tb_report_trafic_country))
                self.Story.append(Spacer(self.width, 30))

        if self.show_code_summery != None and len(self.show_code_summery) > 1:
            plabel = Paragraph("<b><font size=11 >Show Code Summary (top 10)</font></b>", self.style)
            print("Show Code Summary (top 10)")
            data = [[plabel, ""]]
            data.extend(self.show_code_summery)
            # total_row =  ["Total" ,self.get_total_by_column(self.show_code_summery [1:], 1, int),self.get_total_by_column(self.show_code_summery [1:], 2),
            # self.get_total_by_column(self.show_code_summery [1:], 3)]
            tb_report_10 = Table(
                data, style=[
                    ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                    ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                    ('SPAN', (0, 0), (-1, 0)),
                    ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                    ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                    # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                    ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                    ('ALIGN', (1, 2), (-1, -1), 'RIGHT'),
                    # ('SPAN', (0, -1), (1, -1)),
                    ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ])
            self.Story.append(KeepTogether(tb_report_10))
            self.Story.append(Spacer(self.width, 30))

        # detail_trunk
        # self.detail_trunk = None
        if self.detail_trunk != None and len(self.detail_trunk) > 2:
            plabel = Paragraph("<b><font size=11 >Detail By Trunk</font></b>", self.style)
            print("Detail By Trunk")
            data = [[plabel, ""]]
            data.extend(self.detail_trunk)
            if True:  # not self.is_jurisdict:

                tb_report_detail_trunk = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                        # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        # ('ALIGN', (2, 3), (4, -1), 'RIGHT'),
                        # ('SPAN', (0, -1), (1, -1)),
                        ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ])
                self.Story.append(KeepTogether(tb_report_detail_trunk))
                self.Story.append(Spacer(self.width, 30))

            elif len(self.detail_trunk) > 3:
                tb_report_detail_trunk = Table(
                    data, style=[
                        ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                        ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                        ('SPAN', (0, 0), (-1, 0)),  # label
                        ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                        ('BACKGROUND', (0, 1), (-1, 2), colors.HexColor('#b5b5b5')),
                        ('FONTSIZE', (0, 1), (-1, 2), 10),  # headers
                        ('FONTSIZE', (0, 3), (-1, -1), 9),  # cells
                        ('FONTSIZE', (0, -1), (0, -1), 10),  # Total cell
                        ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                        ('ALIGN', (0, 3), (-1, -1), 'RIGHT'),
                        ('ALIGN', (0, 1), (-1, 2), 'CENTER'),  # headers one
                        ('SPAN', (1, 1), (3, 1)), ('SPAN', (4, 1), (6, 1)), ('SPAN', (7, 1), (9, 1)),
                        ('SPAN', (10, 1), (-1, 1)),
                        ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ],
                    colWidths=[60, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7, 41.7])  # ]
                self.Story.append(KeepTogether(tb_report_detail_trunk))
                self.Story.append(Spacer(self.width, 30))

        # Show Calls By Date Summary

        if self.show_calls_date != None and len(self.show_calls_date) > 1:
            plabel = Paragraph("<b><font size=11 >Show Calls By Date Summary</font></b>", self.style)
            data = [[plabel, ""]]
            data.extend(self.show_calls_date)
            tb_report_calls_date = Table(
                data, style=[
                    ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                    ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                    ('SPAN', (0, 0), (-1, 0)),
                    ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                    ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                    # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                    ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                    ('ALIGN', (1, 2), (-1, -1), 'RIGHT'),
                    # ('SPAN', (0, -1), (1, -1)),
                    ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ])

            self.Story.append(KeepTogether(tb_report_calls_date))
            self.Story.append(Spacer(self.width, 30))

        # include Origination Billing
        if self.include_origination_billing != None and len(self.include_origination_billing) > 0:
            print("include Origination Billing")
            plabel = Paragraph("<b><font size=11 >Origination Billing</font></b>", self.style)
            data = [[plabel, ""]]
            data.extend(self.include_origination_billing)
            tb_report_origination_billing = Table(
                data, style=[
                    ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                    ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                    ('SPAN', (0, 0), (-1, 0)),
                    ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                    ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                    # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                    ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                    # ('ALIGN', (2, 3), (4, -1), 'RIGHT'),
                    ('SPAN', (0, -1), (1, -1)),
                    ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ])

            self.Story.append(KeepTogether(tb_report_origination_billing))
            self.Story.append(Spacer(self.width, 30))

        # ShowDetailByCodeName
        if self.ShowDetailByCodeName != None and len(self.ShowDetailByCodeName) > 1:
            print("SDCN")
            plabel = Paragraph("<b><font size=11 >Detail by Code Name</font></b>", self.style)
            data = [[plabel, ""]]
            data.extend(self.ShowDetailByCodeName)
            tb_report_ByCodeName = Table(
                data, style=[
                    ('VALIGN', (0, 0), (-1, -1), 'TOP'),
                    ('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
                    ('SPAN', (0, 0), (-1, 0)),
                    ('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
                    ('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
                    # ('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
                    ('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white),
                    # ('ALIGN', (2, 3), (4, -1), 'RIGHT'),
                    ('SPAN', (0, -1), (1, -1)),
                    ('BACKGROUND', (0, -1), (-1, -1), colors.HexColor('#b5b5b5')), ])

            self.Story.append(KeepTogether(tb_report_ByCodeName))
            self.Story.append(Spacer(self.width, 30))

        tpl = self.switch_settings.get("pdf_tpl", "N/A")
        if tpl == None or tpl.strip() == "":
            pass
        elif self.switch_settings.get("pdf_tpl", "N/A").replace("<p>&nbsp;</p>\r", "").replace("\r", "").replace(" ",
                                                                                                                 "").strip() == "":
            pass
        else:
            if self.tpl_number == 0:
                denovo_billing = """<font  size="9"><p> %s </p>
			</font>
			  """ % self.switch_settings.get("pdf_tpl", "N/A")

                denovo_billing_p = Paragraph(denovo_billing, self.style)

                data = [[denovo_billing_p, "", ""]]
                tb_report = Table(data, style=[('INNERGRID', (0, 0), (-1, -1), 0.5, colors.white)])
                print("tb_report1", tb_report)
            # self.Story.append(tb_report)  #KeepTogether(

            elif self.tpl_number == 2:  # bottem and middle

                denovo_billing = """<font  size="9"><p> %s </p>
			</font>
			  """ % self.switch_settings.get("pdf_tpl", "N/A")

                denovo_billing_p = Paragraph(denovo_billing, self.style)

                data = [["", denovo_billing_p, ""]]
                tb_report = Table(data, style=[('INNERGRID', (0, 0), (-1, -1), 0.5, colors.white)])
                print("tb_report2", tb_report)
            # self.Story.append(tb_report)  #KeepTogether()

            else:
                pass

    def addPageNumber(canvas, doc):
        page_num = canvas.getPageNumber()
        text = "Page #%s" % page_num
        canvas.drawRightString(200 * mm, 20 * mm, text)

    # ----------------------------------------------------------------------
    def savePDF(self):
        """"""
        self.c.build(self.Story)

    def generate(self):
        self.createDocument()
        self.savePDF()

    # ----------------------------------------------------------------------


if __name__ == "__main__":
    doc = TermInvoiceRender("example.pdf", "The MVP", 10)
    doc.createDocument()
    doc.savePDF()
