# from falcon_rest.db import fields, orm , get_db
import smtplib
import csv
import falcon
import requests
import io
import random
import shutil
import json
from datetime import datetime, timedelta
from time import mktime
import os
from scapy.all import rdpcap
import re

from OpenSSL import crypto
from dateutil.parser import parse as parse_datetime
from pytz import UTC
import traceback
import mimetypes
from urllib.parse import parse_qsl, urlencode, quote
from inspect import isclass
from dateutil import parser
from falcon_rest.helpers import get_request_ip
from falcon_rest.db.fields import (Numeric)
# from falcon_rest.db import Column
# from falcon_rest.conf import settings
# from falcon_rest.contrib.files import create_file_model_class, create_scheme
# from falcon_rest.contrib.files.endpoints import UploadFile, GetDownloadLink, DownloadFile, ShowFile
# from marshmallow_sqlalchemy import field_for, fields as sa
from sqlalchemy import (Column, event, desc, or_, not_, and_, text as text_, Integer as Integer_, PrimaryKeyConstraint,
                        inspect, Index, Float, String as _String,
                        UniqueConstraint, literal, alias)

from sqlalchemy.sql import func, select, case, literal_column, cast as cast_
from sqlalchemy.orm import aliased, make_transient, foreign
from sqlalchemy.exc import OperationalError
import sqlalchemy

from collections import Counter
# from api_dnl.base_model import DnlApiBaseModel
# from api_dnl.model import rev

from api_dnl.resources import client_context, check_context, BaseResource, DnlCreate, DnlResource, DnlPatchManyResource, \
    DnlList, \
    DnlSummaryList, CustomPostAction, CustomPatchAction, CustomAction, CustomGetAction, DnlResourceAll, \
    CustomDeleteAction, AlreadyExistsResponse, AlreadyExists, OperationErrorResponse, SuccessResponseJustOk, \
    OperationalErrorResponse
from falcon_rest import schemes, resources, responses, conf
from falcon_rest.db.errors import IntegrityError, FkConstraintViolation, NoResultFound, DataError
from falcon_rest.helpers import check_permission
from falcon_rest.logger import log

from falcon_rest.resources.resources import swagger, ResourcesBaseClass, DEFAULT_SECURITY, ATTRIBUTE_ERROR_RE
from falcon_rest.responses import errors
from api_dnl import settings
# from api_dnl.tasks import apply_mail_task
from api_dnl import model
from api_dnl.scheme import *
from api_dnl import scheme as my_scheme
from api_dnl.scheme import _valid, _valid_unique, _valid_unique2
from api_dnl.utils.dnl_switch import CallApi
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.view_all_delete import *
from api_dnl.utils.dnl_switch import DnlSwitchSession, get_dnl_switch_session
from api_dnl.utils.dnl_active_calls import DnlActiveCallSession, get_dnl_active_calls_session
from functools import wraps
from datetime import datetime
import cProfile


def profile(f):
    dump_file = 'profile.pstat'

    @wraps(f)
    def wrapped(*args, **kw):
        pr = cProfile.Profile()
        pr.enable()
        ret = f(*args, **kw)
        pr.disable()
        pr.dump_stats(dump_file)
        return ret

    return wrapped


def _scheme(cls_name):
    if cls_name + 'SchemeImport' in my_scheme.__dict__:
        return my_scheme.__dict__[cls_name + 'SchemeImport']
    if cls_name + 'ImportScheme' in my_scheme.__dict__:
        return my_scheme.__dict__[cls_name + 'ImportScheme']
    if cls_name + 'ModifyScheme' in my_scheme.__dict__:
        return my_scheme.__dict__[cls_name + 'ModifyScheme']
    if cls_name + 'SchemeModify' in my_scheme.__dict__:
        return my_scheme.__dict__[cls_name + 'SchemeModify']
    if cls_name + 'Scheme' in my_scheme.__dict__:
        return my_scheme.__dict__[cls_name + 'Scheme']
    return None


def _scheme_get(cls_name):
    if cls_name + 'SchemeImport' in my_scheme.__dict__:
        return my_scheme.__dict__[cls_name + 'SchemeImport']
    if cls_name + 'ImportScheme' in my_scheme.__dict__:
        return my_scheme.__dict__[cls_name + 'ImportScheme']
    if cls_name + 'SchemeGet' in my_scheme.__dict__:
        return my_scheme.__dict__[cls_name + 'SchemeGet']
    if cls_name + 'GetScheme' in my_scheme.__dict__:
        return my_scheme.__dict__[cls_name + 'GetScheme']
    return None


def _create_get(cls_name):
    from api_dnl import view as module
    if cls_name + 'Import' in module.__dict__:
        return module.__dict__[cls_name + 'Import']
    if cls_name + 'Create' in module.__dict__:
        return module.__dict__[cls_name + 'Create']


DEFAULT_SECURITY = ['auth_token']
import uuid


def generate_uuid_str():
    return lambda: str(uuid.uuid4())


def resp_file_header(resp, file):
    resp.content_type = mimetypes.guess_type(file)[0]
    try:
        file.encode('ascii')
        resp.append_header('Content-Disposition',
                           'attachment; filename="{}"'.format(file))
    except UnicodeEncodeError:
        resp.append_header('Content-Disposition',
                           "attachment; filename*=utf-8''{}".format(quote(file)))


# Revisions
# from  falcon_rest.contrib.objects_history.object_revision.object_revision import ObjectRevisionModel,ObjectRevisionSchemeGet


class EntityList(DnlList):
    scheme_class = EntityScheme
    model_class = model.ObjectRevisionModel
    entity_plural = 'Entity list'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_objects_list(self, req, model_class, **kwargs):
        l = [(k, v) for k, v in model.__dict__.items() if isclass(v) and issubclass(v, model.DnlApiBaseModel)]
        object_list = [{'name': i[0], 'tablename': i[1].__tablename__,
                        'fields': [c.name for c in inspect(i[1]).columns if c.name[0] != '%']} for i in l if
                       hasattr(i[1], '__tablename__')]
        object_list.sort(key=lambda k: k['name'])
        total = len(object_list)
        page = 0
        per_page = total
        return object_list, total, page, per_page, None


class RestoreObject(BaseResource):
    allow_methods = ['post']

    def __init__(self, **kwargs):
        super(RestoreObject, self).__init__()
        self.security = kwargs.get('security', DEFAULT_SECURITY)

    def on_post(self, req, resp, **kwargs):
        from falcon_rest.contrib.objects_history.object_revision.object_revision import ObjectRevisionModel, \
            RestoreExceptionToRevisionWhereWasDeleted, RestoreExceptionToCurrentRevision, \
            CantRestoreToDeleted, CantRestoreToCurrentRevision
        obj = self.get_object(resp, ObjectRevisionModel, **kwargs)
        user = self.get_user(req)
        if not check_permission('ObjectRevision', req, 'restore', obj) or (
                hasattr(user, 'can_restore') and not user.can_restore(obj)
        ):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return

        try:
            if obj.restore(self.get_user(req)):
                self.set_response(resp, responses.SuccessResponseJustOk())
        except RestoreExceptionToRevisionWhereWasDeleted:
            self.set_response(resp, responses.OperationErrorResponse(data=CantRestoreToDeleted))
        except RestoreExceptionToCurrentRevision:
            self.set_response(resp, responses.OperationErrorResponse(data=CantRestoreToCurrentRevision))
        except Exception as e:
            self.set_response(resp, responses.OperationErrorResponse(data=errors.Error(
                1121, str(e), 'cant_restore'
            )))

    def get_spec(self):
        return swagger.specify.get_spec(
            method='post', description='Restores object to the specified revision',
            path_parameters=({'name': 'id', 'description': 'ID of revision to restore to'},),
            responses=(
                responses.SuccessResponseJustOk(),
                responses.ObjectNotFoundErrorResponse()
            ),
            security=self.security
        )


class ObjectRevisionList(DnlList):
    scheme_class = ObjectRevisionFilterSchemeGet
    model_class = model.ObjectRevisionModel
    entity_plural = 'Object revisions'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):

        ret, q = super(ObjectRevisionList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        return ret, q
        if 'entity_name' in filtering:
            name = filtering.pop('object_name', None)
            if name:
                ent = filtering.pop('entity_name', None)
                if ent in model.__dict__:
                    ent_class = model.__dict__[ent]
                    rec = model.ObjectRevisionRecordModel
                    name_field = None
                    f_names = ('alias', 'name', 'group_name', 'template_name', 'rule_name')
                    for n in f_names:
                        if hasattr(ent_class, n):
                            name_field = getattr(ent_class, n, None)
                    if not name_field:
                        raise ValidationError('Entity {} has no one name field!'.format(ent))
                    # pk_name=inspect(ent_class).primary_key.name
                    pk_name = ent_class.get_model_class_primary_key()
                    pk = getattr(ent_class, pk_name)
                    q = q.outerjoin(ent_class, func.cast(model.ObjectRevisionModel.entity_pk, model.Integer) == pk)
                    q = q.outerjoin(model.ObjectRevisionRecordModel,
                                    rec.object_revision_id == model.ObjectRevisionModel.id)
                    if '*' in name:
                        name = name.replace('*', '%')
                        filt_1 = and_(rec.field_name.in_(f_names),
                                      or_(rec.old_value.like(name),
                                          rec.new_value.like(name)))
                        q = q.filter(or_(name_field.like(name), filt_1))
                    else:
                        filt_1 = and_(rec.field_name.in_(f_names),
                                      or_(rec.old_value == name,
                                          rec.new_value == name))
                        q = q.filter(or_(name_field == name, filt_1))
                    q = q.group_by(model.ObjectRevisionModel.id)
                    log.debug(model.query_to_sting(q))

                else:
                    raise ValidationError('Entity {} not exists!'.format(ent))
        return ret, q


# ++++++++++++++User
class UserCreate(DnlCreate):
    scheme_class = UserScheme
    entity = 'User'
    unique_field = 'user_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    # noinspection PyUnusedLocal
    def before_create(self, obj, **kwargs):
        obj.create_user_id = self.get_user(self.req).user_id
        obj.update_by = self.get_user(self.req).name
        if obj.user_type == "admin":
            obj.show_carrier_trunk_drop_only = True
        return obj

    def create_object(self, req, scheme, **kwargs):
        client_data = req.data.pop('client', None)
        client_id = req.data.pop('client_id', None)
        oid = super(UserCreate, self).create_object(req, scheme, **kwargs)
        obj = model.User.get(oid)
        cl = None
        if client_id:
            cl = model.Client.get(client_id)
        if client_data:
            cl = model.Client()
        if cl:
            cl.user_id = oid
            cl.login = obj.name
            cl.password = req.data['passwd']
            cl.update_by = self.get_user(self.req).name
            # user.email = obj.email
            # kwargs = dict(client_id=user.client_id)
            if client_data:
                sch = CarrierInnerUserScheme()
                sch.load(client_data, instance=cl)
            cid = cl.save()
            if not obj.client_id:
                obj.client_id = cid
                obj.save()
        return oid


class UserCreateAdmin(CustomPostAction):
    scheme_class = UserAdminScheme
    entity = 'User'
    unique_field = 'user_id'
    body_parameters = ('Admin credentials', UserAdminScheme)
    additional_responses = ()
    path_parameters = ()
    no_auth_needed = True

    # noinspection PyUnusedLocal
    def proceed(self, req, resp, **kwargs):
        try:
            errors = self.scheme_class().validate(req.data)
            if errors:
                self.set_response(resp, responses.ValidationErrorResponse(data=errors))
                return False
            if model.User.query().first():
                raise Exception("Cannot setup. Users already exists")
            obj = model.User(name=req.data['name'], passwd=req.data['passwd'])
            obj.user_type = 'admin'
            obj.active = True
            obj.role_id = 0
            obj.user_id = 1
            obj.create_user_id = 1
            obj.update_by = obj.name
            obj.show_carrier_trunk_drop_only = True
            obj.save()
            self.set_response(resp, responses.SuccessResponse(
                data={
                    'result': "user '{}' with admin rights created".format(req.data['name']),
                },
                scheme=schemes.ObjectScheme
            ))
            return True
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


class UserResource(DnlResource):
    model_class = model.User
    scheme_class = UserScheme
    scheme_class_get = UserGetScheme
    scheme_class_modify = UserScheme
    entity = 'User'
    id_field = 'user_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        kwargs.pop('client_id', None)
        if self.get_user(self.req).user_type == 'client' and kwargs['user_id'] != '1':
            return None
        return super(UserResource, self).get_object(resp, model_class, **kwargs)

    def delete_object(self, req, resp, model_class, **kwargs):
        if kwargs['user_id'] == '1':
            raise ValidationError('Cannot delete superadmin from UI')
        # return True
        return super(UserResource, self).delete_object(req, resp, model_class, **kwargs)

    def before_update(self, obj, req):
        # if obj.user_id == 1:
        #     if 'name' in req.data:
        #         del req.data['name']
        #     if 'passwd' in req.data:
        #         del req.data['passwd']
        #     if 'user_type' in req.data:
        #         del req.data['user_type']

        if obj.user_type == 'client':
            if 'client_id' in req.data and req.data['client_id'] != obj.client_id:
                if obj.client_id:
                    data = dict(user_id=None, login=None, password=None)
                    model.Client.filter(model.Client.user_id == obj.user_id).update(data, synchronize_session='fetch')
                    model.Client.session().commit()
                cl = model.Client.get(req.data['client_id'])
            else:
                cl = model.Client.filter(model.Client.user_id == obj.user_id).first()
                if not cl:
                    cl = model.Client(name=obj.name, user_id=obj.user_id)
            if 'client' in req.data:
                sch = CarrierInnerUserScheme()
                sch.load(req.data['client'], instance=cl, partial=True)
                # cl=sch.data
                cl.login = obj.name
                cl.email = obj.email
                del req.data['client']
            if cl:
                cl.user_id = obj.user_id
                if 'name' in req.data:
                    cl.login = req.data['name']
                if 'passwd' in req.data:
                    cl.password = req.data['passwd']
                if 'email' in req.data:
                    cl.email = req.data['email']
            cid = cl.save()
            obj.client_id = cid
        # raise Exception('bad update')
        return obj


class UserList(DnlList):
    scheme_class = UserGetScheme
    model_class = model.User
    entity_plural = 'Users'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_filter_has_limit_carrier_id(self, q, val, kwargs):
        cls = self.model_class
        lim = model.UsersLimit
        q = q.filter(cls.user_id.in_(select([lim.user_id]).where(lim.client_id == val)))
        return q

    def get_fields_for_list(self, parsed_qs, **kwargs):
        fields = parsed_qs.get('fields', None)
        if fields is None:
            fields = 'user_id,name,role_name'
        if fields:
            fields = fields.split(',')
            for f in fields:
                if not f in self.get_all_fields_from_scheme(self.scheme_class)[0]:
                    raise Exception('fields {} not valid!'.format(f))
        elif hasattr(self, 'large_list_fields'):
            log.debug('large_list query {} headers {}'.format(parsed_qs, self.req.headers))
            if 'per_page' in parsed_qs and int(parsed_qs['per_page']) >= 1000:
                fields = self.large_list_fields
        return fields


class UserActivate(DnlResourceAll):
    scheme_class = UserActivateScheme
    model_class = model.User
    scheme_class_get = ObjectUpdatedScheme
    entity = 'User'

    def modify_query(self, filt, qs, req, resp, model_class, **kwargs):
        qs = qs.filter(model.User.user_id != 1)
        return filt, qs


class UserInfoResource(DnlResource):
    model_class = model.User
    scheme_class = UserInfoScheme
    scheme_class_get = UserInfoGetScheme
    scheme_class_modify = UserInfoScheme
    entity = 'UserInfo'
    # id_field = 'user_id'
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):  # pragma: no cover
        kwargs['user_id'] = self.get_user(req).user_id
        return super(UserInfoResource, self).on_get(req, resp, **kwargs)

    def on_patch(self, req, resp, **kwargs):
        kwargs['user_id'] = self.get_user(req).user_id
        return super(UserInfoResource, self).on_patch(req, resp, **kwargs)

    def before_update(self, obj, req):

        if obj.user_type == 'client':
            if 'client_id' in req.data and req.data['client_id'] != obj.client_id:
                if obj.client_id:
                    data = dict(user_id=None, login=None, password=None)
                    model.Client.filter(model.Client.user_id == obj.user_id).update(data, synchronize_session='fetch')
                    model.Client.session().commit()
                cl = model.Client.get(req.data['client_id'])
            else:
                cl = model.Client.filter(model.Client.user_id == obj.user_id).first()
                if not cl:
                    cl = model.Client(name=obj.name, user_id=obj.user_id)
            if 'client' in req.data:
                sch = CarrierInnerUserScheme()
                sch.load(req.data['client'], instance=cl, partial=True)
                # cl=sch.data
                # user.login = obj.name
                # user.email = obj.email
                del req.data['client']
            if cl:
                cl.user_id = obj.user_id
                if 'name' in req.data:
                    cl.login = req.data['name']
                if 'passwd' in req.data:
                    cl.password = req.data['passwd']
                if 'email' in req.data:
                    cl.email = req.data['email']
                cid = cl.save()
                obj.client_id = cid
        # raise Exception('bad update')
        return obj

    def after_update(self, result, obj, data):
        model.get_db().session.flush()


class UserResetPasswordEmail(CustomAction):
    scheme_class = UserResetPasswordLetterScheme
    body_parameters = ('User name', UserResetPasswordLetterScheme)
    method = 'post'
    model_class = model.User
    no_auth_needed = True

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def proceed(self, req, resp, **kwargs):

        import jwt
        from urllib3.util import parse_url
        config = model.SystemParameter.get(1)
        cls = self.model_class
        user = cls.filter(cls.name == req.data['name']).first()
        log_pass = model.RetrievePasswordLog(username=req.data['name'], status='failure',
                                             operation_time=datetime.now(UTC))
        log_pass.request_ip = get_request_ip(req)
        log_pass.save()
        try:
            if user:
                email = user.client.email if user.client else user.email
                log_pass.email_addresses = email
                exp = (datetime.now(UTC) + timedelta(hours=2)).timestamp()
                # token_data ={'user_id':user.user_id,'password':req.data['password'],'exp':exp}
                token_data = {'user_id': user.user_id, 'log_id': log_pass.id, 'exp': exp}
                user.token = jwt.encode(token_data, settings.JWT_SIGNATURE, algorithm='HS256').decode('utf-8')
                url = parse_url(config.base_url)
                new_url = '{}://{}/#/auth/reset/{}'.format(url.scheme, url.netloc, user.token)
                user.fmt_login_url = new_url
                ret = model.MailSender.apply_mail(user, 'retrieve_password',
                                                  email)  # obj.client.billing_email
                if ret:
                    self.set_response(resp, responses.OperationErrorResponse(
                        data=errors.Error(code=43, message=ret[1], reason='mail error')))
                    return False
                log_pass.status = 'E-mail has been sent'
                log_pass.save()
                self.set_response(resp, responses.SuccessResponseJustOk())
                return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False
        self.set_response(resp, responses.ObjectNotFoundErrorResponse())
        return False


class UserResetPassword(CustomAction):
    scheme_class = UserResetPasswordScheme
    model_class = model.User
    body_parameters = ('User data', UserResetPasswordScheme)
    method = 'post'
    path_parameters = ({'name': 'token', 'description': 'Token from email'},)

    no_auth_needed = True

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def proceed(self, req, resp, **kwargs):
        import jwt
        try:
            token_data = jwt.decode(kwargs['token'], settings.JWT_SIGNATURE)
            user = model.User.get(token_data['user_id'])
            if user:
                user.passwd = req.data['passwd']
                if user.client:
                    user.client.password = req.data['passwd']
                user.save()
                log_pass = model.RetrievePasswordLog.get(token_data['log_id'])
                if log_pass:
                    log_pass.confirm_ip = get_request_ip(req)
                    log_pass.modify_time = datetime.now(UTC)
                    log_pass.status = 'Modified successfully'
                    log_pass.save()
                self.set_response(resp, responses.SuccessResponseJustOk())
                return True
        # model.MailSender.apply_mail(user, 'retrieve_password', user.email) # obj.client.billing_email)
        except:
            pass
        self.set_response(resp, responses.ObjectNotFoundErrorResponse())


# --------------User

# ++++++++++++++WebSession
class WebSessionList(DnlList):
    scheme_class = WebSessionGetScheme
    model_class = model.WebSession
    entity_plural = 'Sessions'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# --------------WebSession

# ++++++++++++++SystemFunction


class SystemFunctionCreate(DnlCreate):
    scheme_class = SystemFunctionScheme
    entity = 'SystemFunction'
    unique_field = 'system_function_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    # noinspection PyUnusedLocal
    def before_create(self, obj, **kwargs):
        # obj.create_user_id = self.get_user(self.req).user_id
        return obj


class SystemFunctionResource(DnlResource):
    model_class = model.SystemFunction
    scheme_class = SystemFunctionScheme
    scheme_class_get = SystemFunctionGetScheme
    scheme_class_modify = SystemFunctionScheme
    entity = 'SystemFunction'
    id_field = 'system_function_id'
    has_update_by = True
    unique_field = 'func_name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class SystemFunctionList(DnlList):
    scheme_class = SystemFunctionGetScheme
    model_class = model.SystemFunction
    entity_plural = 'SystemFunctions'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class SystemGroupFunctionList(SystemFunctionList):
    path_parameters = ({'name': 'group_id', 'description': 'Parent group id'},)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(SystemGroupFunctionList, self).get_filtering_for_list(parsed_qs, **kwargs)
        if 'group_id' in kwargs:
            ret['group_id'] = kwargs['group_id']
        return ret


# +++
class SystemFunctionGroupCreate(DnlCreate):
    scheme_class = SystemFunctionGroupScheme
    entity = 'SystemFunctionGroup'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    # noinspection PyUnusedLocal
    def before_create(self, obj, **kwargs):
        # obj.create_user_id = self.get_user(self.req).user_id
        return obj


class SystemFunctionGroupResource(DnlResource):
    model_class = model.SystemFunctionGroup
    scheme_class = SystemFunctionGroupScheme
    scheme_class_get = SystemFunctionGroupGetScheme
    scheme_class_modify = SystemFunctionGroupModifyScheme
    entity = 'SystemFunctionGroup'
    id_field = 'id'
    has_update_by = True
    unique_field = 'group_name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class SystemFunctionGroupList(DnlList):
    scheme_class = SystemFunctionGroupGetScheme
    model_class = model.SystemFunctionGroup
    entity_plural = 'SystemFunctionGroups'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class SysMainMenuCreate(DnlCreate):
    scheme_class = SysMainMenuScheme
    entity = 'SysMainMenu'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class SysMainMenuResource(DnlResource):
    model_class = model.SysMainMenu
    scheme_class = SysMainMenuScheme
    scheme_class_get = SysMainMenuGetScheme
    scheme_class_modify = SysMainMenuScheme
    entity = 'SysMainMenu'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()


class SysMainMenuList(DnlList):
    scheme_class = SysMainMenuGetScheme
    model_class = model.SysMainMenu
    entity_plural = 'SysMainMenus'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    no_auth_needed = True


class SysSubMenuCreate(DnlCreate):
    scheme_class = SysSubMenuScheme
    entity = 'SysSubMenu'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class SysSubMenuResource(DnlResource):
    model_class = model.SysSubMenu
    scheme_class = SysSubMenuScheme
    scheme_class_get = SysSubMenuGetScheme
    scheme_class_modify = SysSubMenuScheme
    entity = 'SysSubMenu'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()


class SysSubMenuList(DnlList):
    scheme_class = SysSubMenuGetScheme
    model_class = model.SysSubMenu
    entity_plural = 'SysSubMenus'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# ---


class SystemFunctionModulesList(DnlList):
    scheme_class = SystemFunctionModulesGetScheme
    model_class = model.SystemModule
    entity_plural = 'SystemModules'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(SystemFunctionModulesList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # q = q.filter(m.id.in_( m.query().session.query(func.max(m.id)).group_by(m.username).all() ) )
        # m=self.model_class
        # ret={}
        # cls=model.SystemFunction
        # q=cls.query().session.query(cls.image_name,func.count().label('usage_count')).group_by(cls.image_name)
        return ret, q


# def get_filtering_for_list(self, parsed_qs, **kwargs):
#    ret = super(SystemFunctionModulesList, self).get_filtering_for_list(parsed_qs, **kwargs)
#    ret['system_function_id'] = 1
#    return ret


# --------------SystemFunction

# ++++++++++++++RolePrivilege

class RolePrivilegeCreate(DnlCreate):
    scheme_class = RolePrivilegeScheme
    entity = 'RolePrivilege'
    unique_field = 'role_privilege_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'role_id', 'description': 'Parent role role_id'},
                       {'name': 'system_function_id', 'description': 'Assigned system_function_id'},
                       )
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        cls = model.RolePrivilege
        old_obj = cls.filter(
            and_(cls.role_id == kwargs['role_id'], cls.system_function_id == kwargs['system_function_id'])).first()
        if old_obj:
            old_obj.readable = obj.readable
            old_obj.writable = obj.writable
            old_obj.executable = obj.executable
            obj = old_obj
        obj.role_id = kwargs['role_id']
        obj.system_function_id = kwargs['system_function_id']
        return obj


class RolePrivilegeMultiplyCreate(DnlCreate):
    scheme_class = RolePrivilegeSchemeMultiple
    entity = 'RolePrivilege'
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        for trunk_id in obj.resource_id[1:]:
            it = model.DynamicRouteItem(dynamic_route_id=kwargs['dynamic_route_id'], resource_id=trunk_id)
            it.save()
        obj.resource_id = obj.resource_id[0]
        obj.dynamic_route_id = kwargs['dynamic_route_id']
        return obj


class RolePrivilegeResource(DnlResource):
    model_class = model.RolePrivilege
    scheme_class = RolePrivilegeScheme
    scheme_class_get = RolePrivilegeGetScheme
    scheme_class_modify = RolePrivilegeScheme
    entity = 'RolePrivilege'
    id_field = 'role_privilege_id'
    has_update_by = True
    # unique_field='role_name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class RolePrivilegeList(DnlList):
    scheme_class = RolePrivilegeGetScheme
    model_class = model.RolePrivilege
    entity_plural = 'RolePrivileges'
    # path_parameters=()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'role_id', 'description': 'Parent role role_id'},)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RolePrivilegeList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['role_id'] = kwargs['role_id']
        return ret


class RoleFunctionGroupPrivilegeList(RolePrivilegeList):
    path_parameters = ({'name': 'role_id', 'description': 'Parent role role_id'},
                       {'name': 'system_function_group_id', 'description': 'Parent group id'})

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super().get_filtering_for_list(parsed_qs, **kwargs)
        ret['system_function_group_id'] = kwargs['system_function_group_id']
        return ret


# ---- RolePrivilege


# ++++++++++++++Role

class RoleCreate(DnlCreate):
    scheme_class = RoleScheme
    entity = 'Role'
    unique_field = 'role_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    # noinspection PyUnusedLocal
    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        # obj.create_default_privileges()
        return obj


class RoleResource(DnlResource):
    model_class = model.Role
    scheme_class = RoleScheme
    scheme_class_get = RoleGetScheme
    scheme_class_modify = RoleScheme
    entity = 'Role'

    id_field = 'role_id'
    has_update_by = True
    unique_field = 'role_name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class RoleFunctionGroupList(RoleResource):
    scheme_class = RoleFunctionGroupGetScheme
    scheme_class_get = RoleFunctionGroupGetScheme
    has_delete_operation = False
    has_modify_operation = False
    has_info_operation = True


class RoleCreateDefaultPrivileges(CustomPatchAction):
    model_class = model.Role
    scheme_class = RoleScheme
    entity = 'Role default privileges'
    id_field = 'role_id'
    path_parameters = ({'name': 'role_id', 'description': 'role_id to fill'},)

    def apply(self, obj, req, resp, **kwargs):
        obj.create_default_privileges()
        obj.create_default_ui_privileges()
        obj.save()
        return True


class RoleList(DnlList):
    scheme_class = RoleGetScheme
    model_class = model.Role
    entity_plural = 'Roles'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):  # pragma: no cover
        log.debug("ON_GET for RoleList")
        if 'order_by=user_count' in req.query_string:
            req.query_string = req.query_string.replace('order_by=user_count', '')
            if 'order_dir=desc' in req.query_string:
                self.sort_by_usage = 'desc'
            else:
                self.sort_by_usage = 'asc'
        return super(RoleList, self).on_get(req, resp, **kwargs)

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        log.debug("MODIFYING QUERY")
        filt, q = super(RoleList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        if hasattr(self, 'sort_by_usage'):
            if self.sort_by_usage == 'desc':
                q = q.join(model.User, isouter=True).group_by(model.Role.role_id).order_by(
                    model.func.count(model.User.user_id.distinct()).desc())
            else:
                q = q.join(model.User, isouter=True).group_by(model.Role.role_id).order_by(
                    model.func.count(model.User.user_id.distinct()))

        return (filt, q)


# ---- Role

# +++ WebSession
class WebSessionList(DnlList):
    scheme_class = WebSessionScheme
    model_class = model.WebSession
    entity_plural = 'WebSession'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# --- WebSession


# --------------Agent
class AgentCreate(DnlCreate):
    scheme_class = AgentScheme
    entity = 'Agent'
    unique_field = 'agent_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    develop_status = 1
    comments = 'Email for user auto assigned'

    def before_create(self, obj, **kwargs):
        if obj.agent_name:
            q = model.Agent.filter(model.Agent.agent_name == obj.agent_name).first()
            if q:
                raise ValidationError('Agent already exists! agent_name = "{}" '.format(obj.agent_name))
        if obj.user:
            if obj.user.name:
                q = model.User.filter(model.User.name == obj.user.name).first()
                if q:
                    raise ValidationError('User name already exists! User.name="{}"'.format(obj.user.name))
        obj.create_on = datetime.now(UTC)
        obj.update_on = datetime.now(UTC)
        obj.update_by = self.get_user().name
        if obj.user:
            obj.user.user_type = "agent"
            obj.user.email = obj.email
            obj.user.role_id = 2
        # obj.user_id=obj.user.user_id
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        obj = model.Agent.get(object_id)
        if obj:
            model.AgentCommissionHistory(agent_id=object_id,
                                         create_date=datetime.now(UTC),
                                         start_time=datetime.now(UTC),
                                         finished=False,
                                         amount=obj.commission).save()


class AgentResource(DnlResource):
    model_class = model.Agent
    scheme_class = AgentScheme
    scheme_class_get = AgentGetScheme
    scheme_class_modify = AgentModifyScheme
    entity = 'Agent'
    id_field = 'agent_id'
    has_update_by = True
    unique_field = 'agent_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        if 'agent_name' in req.data:
            q = model.Agent.filter(
                and_(model.Agent.agent_name == req.data['agent_name'], model.Agent.agent_id != obj.agent_id)).first()
            if q:
                raise ValidationError('Agent already exists! agent_name = "{}" '.format(req.data['agent_name']))
        if 'user' in req.data:
            if 'name' in req.data['user']:
                q = model.User.filter(
                    and_(model.User.name == req.data['user']['name'], model.User.user_id != obj.user_id)).first()
                if q:
                    raise ValidationError('User name already exists! User.name="{}"'.format(obj.user.name))
        obj.update_on = datetime.now(UTC)
        obj.update_by = self.get_user().name
        if 'user' in req.data:
            if req.data['user']:
                user = req.data['user']
                if not obj.user:
                    if 'name' in user and 'passwd' in user:
                        obj.user = model.User(name=user['name'], passwd=user['passwd'])
                    else:
                        raise ValidationError('User name and passwd must exists! ')
                if 'email' in user:
                    obj.user.email = user['email']
                if 'name' in user:
                    obj.user.name = user['name']
                if 'passwd' in user:
                    obj.user.passwd = user['passwd']
                if 'first_name' in user:
                    obj.user.first_name = user['first_name']
                if 'last_name' in user:
                    obj.user.last_name = user['last_name']
                if 'avatar_id' in user:
                    obj.user.avatar_id = user['avatar_id']
                obj.user.user_type = 'agent'
                obj.user.role_id = 2
                if 'status' in req.data:
                    obj.user.active = req.data['status']
                del req.data['user']
        if 'commission' in req.data and float(req.data['commission']) != obj.commission:
            acls = model.AgentCommissionHistory
            acls().filter(and_(acls.agent_id == obj.agent_id, acls.finished != True)).update(
                {'finished': True, 'end_time': datetime.now(UTC)})
            acls(agent_id=obj.agent_id,
                 create_date=datetime.now(UTC),
                 start_time=datetime.now(UTC),
                 finished=False,
                 amount=req.data['commission']).save()
        return obj


class AgentList(DnlList):
    scheme_class = AgentGetScheme
    model_class = model.Agent
    entity_plural = 'Agents'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        usage_count_gt = None
        if 'usage_count_gt' in filtering:
            usage_count_gt = filtering['usage_count_gt']
            del filtering['usage_count_gt']

        usage_count_lt = None
        if 'usage_count_lt' in filtering:
            usage_count_lt = filtering['usage_count_lt']
            del filtering['usage_count_lt']

        filt, q = super(AgentList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        filtered = False
        if 'usage_count' in filt:
            filtered = True
            q = q.outerjoin(model.AgentClient). \
                group_by(model.Agent.agent_id).having(
                model.func.count(model.AgentClient.id) == filtering['usage_count'])
            del filt['usage_count']
        if not usage_count_gt is None and not filtered:
            q = q.outerjoin(model.AgentClient, model.AgentClient.agent_id == model.Agent.agent_id). \
                group_by(model.Agent.agent_id).having(
                model.func.count(model.AgentClient.id) > int(usage_count_gt))
        if not usage_count_lt is None and not filtered:
            q = q.outerjoin(model.AgentClient, model.AgentClient.agent_id == model.Agent.agent_id). \
                group_by(model.Agent.agent_id).having(
                model.func.count(model.AgentClient.id) < int(usage_count_gt))

        return (filt, q)


class AgentProductList(DnlList):
    scheme_class = AgentProductsGetScheme
    model_class = model.ProductAgentsRef
    entity_plural = 'AgentPortalProducts'
    path_parameters = ({'name': 'agent_id', 'description': 'Parent agent id'},)
    security = DEFAULT_SECURITY
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super(AgentProductList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        # ref = aliased(model.ProductAgentsRef)
        agent_id = kwargs['agent_id']
        ret = ret.filter(cls.agent_id == agent_id)
        return filt, ret


class AgentActivate(DnlResourceAll):
    scheme_class = AgentActivateScheme
    model_class = model.Agent
    scheme_class_get = ObjectUpdatedScheme
    entity = 'Agent'


class AgentCarriersResource(DnlResource):
    comments = 'agent to carriers assignment'
    model_class = model.Agent
    scheme_class = AgentCarriersAddScheme
    scheme_class_get = AgentCarriersGetScheme
    scheme_class_modify = AgentCarriersAddScheme
    entity = 'Agent'
    id_field = 'agent_id'
    has_update_by = True
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = True
    unique_field = 'agent_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        for client in req.data['carriers']:
            client_id = client['client_id']

            ca = model.AgentClient.filter(
                and_(model.AgentClient.client_id == client_id, model.AgentClient.agent_id != obj.agent_id)).first()
            if ca:
                raise ValidationError('Client {} already assigned to agent {}'.format(ca.client_id, ca.agent_id))
            for ca in model.AgentClient.filter(model.AgentClient.client_id == client_id).all():
                ca.delete()  # delete other client agent assigments
        self._user = self.get_user(req).name
        return obj

    def _after_update(self, result, obj, data):
        new = model.Agent.get(result)
        for ca in new.carriers:
            ca.assigned_by = self._user
            ca.commission = new.commission
            ca.save()


class AgentAssignProducts(resources.CustomAction):
    scheme_class = AgentAssignProductsScheme
    model_class = model.Agent
    description = 'assign product list to agent'
    path_parameters = ({'name': 'agent_id', 'description': 'Parent agent id'},)
    method = 'patch'
    body_parameters = ('Products to add', AgentAssignProductsScheme)

    def on_patch(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        if not obj:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return False
        try:
            ret = []
            ref = model.ProductAgentsRef
            q = ref.filter(ref.agent_id == obj.agent_id)
            if q.first():
                q.delete(synchronize_session='fetch')
                q.session.commit()
            for product_id in req.data['products']:

                q = ref.filter(and_(ref.agent_id == obj.agent_id, ref.product_id == product_id)).first()
                if q:
                    # self.set_response(resp, responses.ValidationErrorResponse(data='Already assigned!'))
                    # return False
                    continue
                oid = ref(agent_id=obj.agent_id, product_id=product_id).save()
                ret.append(oid)
            self.set_response(
                resp, responses.ObjectCreatedResponse(
                    data=ret,
                    scheme=schemes.ObjectCreated
                )
            )
            return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


class AgentSendLinkAction(resources.CustomAction):
    scheme_class = AgentSendLinkScheme
    model_class = model.Agent
    description = 'assign product list to agent'
    path_parameters = ({'name': 'agent_id', 'description': 'Parent agent id'},)
    method = 'post'
    body_parameters = ('Emails to send', AgentSendLinkScheme)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        if not obj:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return False
        try:
            send_to = req.data['emails']

            ret = model.MailSender.apply_mail(obj, 'agent_share_link', send_to)  # obj.client.billing_email
            if ret:
                self.set_response(resp, responses.OperationErrorResponse(
                    data=errors.Error(code=43, message=ret[1], reason='mail error')))
                return False
            return True
            self.set_response(
                resp, responses.ObjectCreatedResponse(
                    data=ret,
                    scheme=schemes.ObjectCreated
                )
            )
            return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


class AgentCarriersAdd(resources.CustomAction):
    "add carrier list to agent--not in use now"
    carriers = List(Int())

    class Meta:
        model = model.Agent
        fields = ('carriers',)

    scheme_class = AgentCarriersAddScheme
    model_class = model.Agent
    description = 'add carrier list to agent'
    path_parameters = ({'name': 'agent_id', 'description': 'Parent agent id'},)
    body_parameters = ('Carriers to add', AgentCarriersAddScheme)
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        # raise Exception('req_data='+str(req.data)+' ags='+str(kwargs) )
        # raise Exception('obj='+str(obj))
        result = []
        try:

            for data in req.data['carriers']:

                # raise Exception('data='+str(data))
                ca = model.AgentClient.filter(client_id=data['client_id']).first()
                if ca:
                    raise ValidationError(
                        'Client {} already assigned to agent {}'.format(ca.client.name, ca.agent.agent_name))
                child, errors = AgentClientScheme().load(data)
                if errors:
                    self.set_response(resp, responses.ValidationErrorResponse(data=errors))
                    return False
                child.agent_id = kwargs['agent_id']
                child.assigned_on = datetime.now(UTC)
                child.assigned_by = self.get_user(req).name
                try:
                    obj_id = child.save()
                except Exception as e:
                    self.set_response(resp, OperationErrorResponse(e))
                    return False

                # raise Exception('obj='+str(obj_id),'err='+str(errors))
                result.append(obj_id)

            if result:
                self.set_response(
                    resp, responses.SuccessResponse(
                        data={
                            'items': result,
                        },
                        scheme=schemes.ObjectScheme
                    )
                )
                return True
            else:
                self.set_response(
                    resp, responses.SuccessResponseJustOk())
                return True
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


# raise e
# raise NotImplementedError('Ill be back!')


# ------ Agent ------
class AgentClientResource(DnlResource):
    comments = 'agent to carriers assignment'
    model_class = model.AgentClient
    scheme_class = AgentClientScheme
    scheme_class_get = AgentClientScheme
    scheme_class_modify = AgentClientScheme
    entity = 'AgentClient'
    id_field = ('agent_id', 'carrier_id')
    # has_update_by=True
    has_delete_operation = True
    has_modify_operation = True
    has_info_operation = False
    # unique_field='agent_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        q = model_class.filter(model_class.agent_id == kwargs['agent_id']).filter(
            model_class.client_id == kwargs['carrier_id']).first()
        if q:
            _id = q.id
            kwargs['id'] = _id
            return super(AgentClientResource, self).get_object(resp, model_class, **kwargs)
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return None


class AgentClientList(DnlList):
    scheme_class = AgentClientGetScheme
    model_class = model.AgentClient
    entity_plural = 'All AgentClients'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# ---AgentCommissionHistory---
class AgentCommissionHistoryList(DnlList):
    scheme_class = AgentCommissionHistoryGetScheme
    model_class = model.AgentCommissionHistory
    entity_plural = 'AgentCommissionHistory list'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class AgentCommissionHistoryDetailList(DnlList):
    scheme_class = AgentCommissionHistoryDetailGetScheme
    model_class = model.AgentCommissionHistoryDetail
    entity_plural = 'AgentCommissionHistoryDetail list'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):  # pragma: no cover
        if 'order_by=agent_id' in req.query_string:
            self.agent_id_order = 'asc'
            if 'order_dir=desc' in req.query_string:
                self.agent_id_order = 'desc'
            req.query_string = req.query_string.replace('order_by=agent_id', '')
        return super(AgentCommissionHistoryList, self).on_get(req, resp, **kwargs)

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, query = super(AgentCommissionHistoryList,
                            self).modify_query_from_filtering_for_list(filtering, **kwargs)
        agent_id = filt.pop('agent_id', None)
        if agent_id:
            query = query.join(model.AgentCommissionHistoryDetail.parent)
            query = query.filter(
                model.AgentCommissionHistory.agent_id == agent_id
            )
        if hasattr(self, 'agent_id_order'):
            query = query.join(model.AgentCommissionHistoryDetail.parent)
            if self.agent_id_order == desc:
                query = query.order_by(model.AgentCommissionHistory.agent_id.desc())
            else:
                query = query.order_by(model.AgentCommissionHistory.agent_id.asc())

        return (filt, query)


# ---AgentCommissionHistory---


# region +++AgentCommissionPayment+++
class AgentCommissionPaymentCreate(DnlCreate):
    scheme_class = AgentCommissionPaymentScheme
    model_class = model.AgentCommissionPayment
    entity = 'AgentCommissionPayment'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.create_by = user.name
        obj.create_on = datetime.now(UTC)
        return obj


class AgentCommissionPaymentResource(DnlResource):
    model_class = model.AgentCommissionPayment
    scheme_class = AgentCommissionPaymentScheme
    scheme_class_get = AgentCommissionPaymentSchemeGet
    scheme_class_modify = AgentCommissionPaymentSchemeModify
    entity = 'AgentCommissionPayment'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class AgentCommissionPaymentList(DnlList):
    scheme_class = AgentCommissionPaymentSchemeGet
    model_class = model.AgentCommissionPayment
    entity_plural = 'AgentCommissionPayments'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            ret = ret.filter(cls.agent_id == user.agent_id)
        return filt, ret


# endregion ---AgentCommissionPayment---


class AgentNotAssignedClientList(DnlList):
    scheme_class = ClientSimpleGetScheme
    model_class = model.Client
    entity_plural = 'Not assigned clients'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, query = super(AgentNotAssignedClientList,
                            self).modify_query_from_filtering_for_list(filtering, **kwargs)
        query = query.filter(model.Client.client_id.notin_(select([model.AgentClient.client_id])))
        return (filt, query)


# --------------TimeProfile
class TimeProfileCreate(DnlCreate):
    scheme_class = TimeProfileScheme
    entity = 'TimeProfile'
    unique_field = 'time_profile_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        return obj


class TimeProfileResource(DnlResource):
    model_class = model.TimeProfile
    scheme_class = TimeProfileScheme
    scheme_class_get = TimeProfileGetScheme
    scheme_class_modify = TimeProfileScheme
    entity = 'TimeProfile'
    id_field = 'time_profile_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class TimeProfileList(DnlList):
    scheme_class = TimeProfileGetScheme
    model_class = model.TimeProfile
    entity_plural = 'TimeProfiles'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# ------ TimeProfile ------


# --------------DigitTranslation
class DigitTranslationCreate(DnlCreate):
    scheme_class = DigitTranslationScheme
    entity = 'DigitTranslation'
    unique_field = 'translation_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        return obj


class DigitTranslationResource(DnlResource):
    model_class = model.DigitTranslation
    scheme_class = DigitTranslationScheme
    scheme_class_get = DigitTranslationGetScheme
    scheme_class_modify = DigitTranslationScheme
    entity = 'DigitTranslation'
    id_field = 'translation_id'
    has_update_by = False
    unique_field = 'translation_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_at = datetime.now(UTC)
        # super(DigitTranslationResource,self).before_update(self,obj,req)
        return obj


class DigitTranslationList(DnlList):
    scheme_class = DigitTranslationGetScheme
    model_class = model.DigitTranslation
    entity_plural = 'DigitTranslations'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):  # pragma: no cover
        if 'order_by=digit_map_count' in req.query_string:
            req.query_string = req.query_string.replace('order_by=digit_map_count', '')
            if 'order_dir=desc' in req.query_string:
                self.sort_by_usage = 'desc'
            else:
                self.sort_by_usage = 'asc'
        return super(DigitTranslationList, self).on_get(req, resp, **kwargs)

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(DigitTranslationList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        if hasattr(self, 'sort_by_usage'):
            if self.sort_by_usage == 'desc':
                q = q.join(model.TranslationItem, isouter=True).group_by(
                    model.DigitTranslation.translation_id).order_by(
                    model.func.count(model.TranslationItem.ref_id.distinct()).desc())
            else:
                q = q.join(model.TranslationItem, isouter=True).group_by(
                    model.DigitTranslation.translation_id).order_by(
                    model.func.count(model.TranslationItem.ref_id.distinct()))

        return (filt, q)


# ------ DigitTranslation ------


# --------------TranslationItem
class TranslationItemCreate(DnlCreate):
    scheme_class = TranslationItemScheme
    entity = 'TranslationItem'
    unique_field = 'ref_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'translation_id', 'description': 'Parent digit map'},)

    def before_create(self, obj, **kwargs):
        obj.translation_id = kwargs['translation_id']
        return obj


class TranslationItemResource(DnlResource):
    model_class = model.TranslationItem
    scheme_class = TranslationItemScheme
    scheme_class_get = TranslationItemGetScheme
    scheme_class_modify = TranslationItemScheme
    entity = 'TranslationItem'
    id_field = 'ref_id'
    has_update_by = False
    # unique_field='translation_name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class TranslationItemList(DnlList):
    scheme_class = TranslationItemGetScheme
    model_class = model.TranslationItem
    entity_plural = 'TranslationItems'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'translation_id', 'description': 'Parent digit map'},)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(TranslationItemList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['translation_id'] = kwargs['translation_id']
        return ret

    def _get_objects_list(self, req, model_class, **kwargs):
        model_class.filter(model.text_("(translation_id=%s)" % kwargs['translation_id']))
        return super(TranslationItemList, self).get_objects_list(req, model_class, **kwargs)


# ------ TranslationItem ------

# --------------Currency
class CurrencyCreate(DnlCreate):
    scheme_class = CurrencyScheme
    entity = 'Currency'
    unique_field = 'currency_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def create_object(self, req, scheme, **kwargs):
        oid = resources.BaseResource.create_object(self, req, scheme, **kwargs)
        model.Currency.get(oid).rate = req.data['rate']
        return oid

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        return obj


class CurrencyResource(DnlResource):
    model_class = model.Currency
    scheme_class = CurrencyScheme
    scheme_class_get = CurrencyGetScheme
    scheme_class_modify = CurrencyScheme
    entity = 'Currency'
    id_field = 'currency_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def after_update(self, result, obj, data):
        obj.rates[0].save(save_history=True, user=self.get_user(self.req),
                          module=getattr(self.__class__, 'api_module', 'N/A'))


class CurrencyList(DnlList):
    scheme_class = CurrencyGetScheme
    model_class = model.Currency
    entity_plural = 'Currencies'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# ------ Currency ------
# ------ Codec ------
class CodecList(DnlList):
    scheme_class = CodecGetScheme
    model_class = model.Codec
    entity_plural = 'Codec'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# ------ Codec ------


# ------ PaymentTerm ------
class PaymentTermCreate(DnlCreate):
    scheme_class = PaymentTermScheme
    entity = 'PaymentTerm'
    unique_field = 'payment_term_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        return obj


class PaymentTermResource(DnlResource):
    model_class = model.PaymentTerm
    scheme_class = PaymentTermScheme
    scheme_class_get = PaymentTermGetScheme
    scheme_class_modify = PaymentTermScheme
    entity = 'PaymentTerm'
    id_field = 'payment_term_id'
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class PaymentTermList(DnlList):
    scheme_class = PaymentTermGetScheme
    model_class = model.PaymentTerm
    entity_plural = 'PaymentTerms'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# +++ VoipGateway

class VoipGatewayCreate(DnlCreate):
    scheme_class = VoipGatewayScheme
    entity = 'VoipGateway'
    unique_field = 'switch_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        return obj


class VoipGatewayResource(DnlResource):
    model_class = model.VoipGateway
    scheme_class = VoipGatewayScheme
    scheme_class_get = VoipGatewayGetScheme
    scheme_class_modify = VoipGatewayScheme
    entity = 'VoipGateway'
    id_field = 'switch_id'
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        kwargs['id'] = kwargs['switch_id']
        del kwargs['switch_id']
        try:
            i = int(kwargs['id'])
        except:
            self.set_response(
                resp,
                responses.ValidationErrorResponse(data={'switch_id': '{} bad value'.format(kwargs['id'])})
            )
            return None
        return super(VoipGatewayResource, self).get_object(resp, model_class, **kwargs)

    def on_get(self, req, resp, **kwargs):
        user = self.get_user(req)
        if not user.is_admin:
            permission_error = errors.Error(
                errors.CommonErrors.PermissionError.code,
                'Only the admin has permission'
            )
            self.set_response(
                resp,
                responses.OperationErrorResponse(data=permission_error)
            )
            return
        return super(VoipGatewayResource, self).on_get(req, resp, **kwargs)


class VoipGatewayList(DnlList):
    scheme_class = VoipGatewayGetScheme
    model_class = model.VoipGateway
    entity_plural = 'VoipGateways'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    
    def on_get(self, req, resp, **kwargs):
        user = self.get_user(req)
        if not user.is_admin:
            permission_error = errors.Error(
                errors.CommonErrors.PermissionError.code,
                'Only the admin has permission'
            )
            self.set_response(
                resp,
                responses.OperationErrorResponse(data=permission_error)
            )
            return
        return super(VoipGatewayList, self).on_get(req, resp, **kwargs)


class VoipGatewayFullList(DnlList):
    scheme_class = VoipGatewayFullGetScheme
    model_class = model.VoipGateway
    entity_plural = 'VoipGateways'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    
    def on_get(self, req, resp, **kwargs):
        user = self.get_user(req)
        if not user.is_admin:
            permission_error = errors.Error(
                errors.CommonErrors.PermissionError.code,
                'Only the admin has permission'
            )
            self.set_response(
                resp,
                responses.OperationErrorResponse(data=permission_error)
            )
            return
        return super(VoipGatewayFullList, self).on_get(req, resp, **kwargs)


class VoipGatewayReloadResource(CustomPatchAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewayScheme
    entity = 'VoipGateway reload profile'
    id_field = 'switch_id'
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id refresh'},)

    def apply(self, obj, req, resp, **kwargs):
        from api_dnl.utils.dnl_switch import CallApi
        if not obj:
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        try:
            ret = CallApi.sip_profile_start(obj.lan_ip, obj.lan_port)
        except Exception as e:
            self.set_response(
                resp, responses.OperationErrorResponse(data={'error': str(e)}))
            return False
        self.set_response(
            resp, responses.SuccessResponse(data={'voip_gateway_result': ret}, scheme=schemes.ObjectScheme))
        return False


def _human_readable(data):
    if 'start_time' in data:
        try:
            d = datetime.fromtimestamp(float(data['start_time'][:-6] + '.' + data['start_time'][-6:]), UTC)
            data['start_date_time'] = str(d)
        except:
            pass
    m = {'ingress_carrier': (model.Client, 'name'),
         'egress_carrier': (model.Client, 'name'),
         'routing_plan': (model.RouteStrategy, 'name'),
         'ingress_trunk': (model.Resource, 'alias'),
         'egress_trunk': (model.Resource, 'alias'),
         'orig_rate_table': (model.RateTable, 'name'),
         'egress_rate_table': (model.RateTable, 'name'),
         'dynamic_route': (model.RouteStrategy, 'name'),
         'static_route': (model.RouteStrategy, 'name'),
         }
    for k, v in dict(m).items():
        cls, name = v
        try:
            q = cls.get(int(data[k]))
            data[k] = getattr(q, name, '') if q else ''
        except:
            pass
    return data


class VoipGatewayActiveCalls(CustomAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewayActiveCallsScheme
    entity = 'VoipGateway active calls report'
    id_field = 'switch_id'
    body_parameters = ('Query for active call', VoipGatewayActiveCallsScheme)
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},)
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):

        if not obj:
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        if not obj.active_call_ip or not obj.active_call_port:
            self.set_response(resp, responses.ValidationErrorResponse(
                data={'switch_id': ['selected switch has no settings! check active_call_ip and active_call_port']}))
            return False
        if not obj.connected:
            self.set_response(resp, responses.OperationErrorResponse(
                data=responses.errors.Error(code=42, message='switch {} not connected'.format(obj.name),
                                            reason='switch_error')))
            return False
        try:
            # api = DnlActiveCallSession(obj.active_call_ip, obj.active_call_port)
            # api.login()
            # api.logout()
            api = get_dnl_active_calls_session(obj.active_call_ip, obj.active_call_port)
        except Exception as e:
            self.set_response(resp, responses.ValidationErrorResponse(
                data={'switch_id': [
                    'cannot connect to selected switch! check active_call_ip and active_call_port in switch settings']}))
            return False
        try:

            filters = req.data.pop('filters', None)

            if filters or filters == {}:
                for k in filters.keys():
                    if k not in DnlActiveCallSession.FIELDS:
                        self.set_response(
                            resp, responses.ValidationErrorResponse(
                                data={'error': {'filters': ['invalid field {}'.format(k)]}}))
                        return False
            else:
                filters = None

            fields = req.data.pop('fields', None)

            page = req.data.pop('page', 0)
            per_page = req.data.pop('per_page', 10)

            if per_page is not None and page is not None:
                first_record_number = page * per_page + 1
                last_record_number = (page + 1) * per_page
            # api = DnlActiveCallSession(obj.active_call_ip, obj.active_call_port)
            # api.login()
            api = get_dnl_active_calls_session(obj.active_call_ip, obj.active_call_port)
            ret, display_count, total = api.get_active_call(obj.name, fields, filters, first_record_number,
                                                            last_record_number)
            # api.logout()
            raw_values = req.data.pop('raw_values', False)
            if raw_values:
                hrret = ret
            else:
                hrret = [_human_readable(it) for it in ret]

            # page = req.data.pop('page', 0)
            # per_page = req.data.pop('per_page', 10)
            # if per_page == 0:
            #     per_page = 10
            # hrret = hrret[page * per_page:(page + 1) * per_page]
            self.set_response(
                resp, responses.SuccessResponse(data={
                    'items': hrret,
                    'display_count': display_count,
                    'total': total,
                    'page': page,
                    'per_page': len(hrret)
                },
                    scheme=schemes.ObjectScheme)
            )
        except Exception as e:
            log.debug('VoipGatewayActiveCalls error:{}'.format(e))
            self.set_response(
                resp, responses.OperationErrorResponse(e))

        return False


class VoipGatewayFullActiveCalls(CustomAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewayActiveCallsScheme
    entity = 'VoipGateway active calls report'
    id_field = 'switch_id'
    body_parameters = ('Query for active call', VoipGatewayActiveCallsScheme)
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        user = self.get_user(req)
        if not user.is_admin:
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return False
        
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):

        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        try:
            filters = req.data.pop('filters', None)

            if filters or filters == {}:
                for k in filters.keys():
                    if k not in DnlActiveCallSession.FIELDS:
                        self.set_response(
                            resp, responses.ValidationErrorResponse(
                                data={'error': {'filters': ['invalid field {}'.format(k)]}}))
                        return False
            else:
                filters = None

            fields = req.data.pop('fields', None)
            last_record_number = req.data.pop('last_record_number', 10)
            if last_record_number == 0:
                last_record_number = 10
            first_record_number = req.data.pop('first_record_number', 1)
            if first_record_number == 0:
                first_record_number = 10
            cls = self.model_class
            hrret = []
            total = 0
            raw_values = req.data.pop('raw_values', False)

            for obj in cls.filter(and_(cls.active_call_ip.isnot(None), cls.active_call_port.isnot(None))).all():
                try:
                    # api = DnlActiveCallSession(obj.active_call_ip, obj.active_call_port, timeout=2)
                    # api.login()
                    api = get_dnl_active_calls_session(obj.active_call_ip, obj.active_call_port)
                    ret, display_count, _total = api.get_active_call(obj.name, fields, filters, first_record_number,
                                                                     last_record_number)
                    # api.logout()
                    if raw_values:
                        hrret = hrret + ret
                    else:
                        hrret = hrret + [_human_readable(it) for it in ret]
                    total += int(_total)
                except Exception as e:
                    log.debug('VoipGatewayFullActiveCalls switch {} error {}'.format(obj.id, str(e)))
                    continue
            self.set_response(
                resp, responses.SuccessResponse(data={'items': hrret,
                                                      # 'display_count': display_count,
                                                      'total': total},
                                                scheme=schemes.ObjectScheme))
        except Exception as e:
            self.set_response(
                resp, responses.OperationErrorResponse(data={'error': str(e)}))

        return False


class VoipGatewayCallStats(CustomAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewayCallStatScheme
    entity = 'VoipGateway statistic report'
    id_field = 'switch_id'
    body_parameters = ('Query for statistics', VoipGatewayCallStatScheme)
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},)
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=VoipGatewayCallStatGetScheme,
                                                                description='Call statistics result'),)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        if not obj and kwargs['switch_id'] != '0':
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        period = req.data.pop('period', None)

        now = datetime.now(UTC)
        now0 = now.replace(hour=0, minute=0, second=0, microsecond=0)
        now_week = now0 - timedelta(days=now0.weekday())
        now_month = now0.replace(day=1)
        now_year = now0.replace(day=1, month=1)
        minutes = {'last hour': 60,
                   'last 24 hours': 60 * 24,
                   'today': round((now - now0).total_seconds() / 60),
                   'last week': round((now - now_week).total_seconds() / 60),
                   'last month': round((now - now_month).total_seconds() / 60),
                   'last year': round((now - now_year).total_seconds() / 60),
                   }
        try:
            mins = minutes[period]
        except:
            self.set_response(resp, responses.ValidationErrorResponse(
                data={'period': ['invalid period']}))
            return False

        if not obj:
            lst = model.VoipGateway.query().filter(model.VoipGateway.connected == True).all()
        else:
            lst = [obj]
        ret = []
        api = None
        for obj in lst:
            log.debug('VoipGatewayCallStats calling  swith {} minutes {}'.format(obj.id, mins))
            if not obj.active_call_ip or not obj.active_call_port:
                self.set_response(resp, responses.ValidationErrorResponse(
                    data={'switch_id': ['selected switch has no settings! check active_call_ip and active_call_port']}))
                return False
            try:
                # api = DnlActiveCallSession(obj.active_call_ip, obj.active_call_port)
                # api.login()
                api = get_dnl_active_calls_session(obj.active_call_ip, obj.active_call_port)
                log.debug('VoipGatewayCallStats swith {} logged in'.format(obj.id))
                sw_data = api.get_call_stat(mins)
                log.debug('VoipGatewayCallStats swith {} returned {}'.format(obj.id, str(sw_data)))
                ret.append(sw_data)
                # api.logout()
            except Exception as e:
                log.warning('call stat error {}'.format(e))
                continue
                # self.set_response(resp, responses.ValidationErrorResponse(
                #     data={'switch_id': ['selected switch {} has error {}'.format(obj.id, e)]}))
                # return False
        data = {}
        if len(ret):
            for k in list(ret[0].keys()):
                data[k] = sum([item[k] for item in ret if k in item])
        try:
            data['last_asr_percentage'] = round(
                (data['last_non_zero_calls'] / data['last_total_calls']) * 100.0 if data['last_total_calls'] else 0.0,
                2)
        except:
            pass
        log.debug('VoipGatewayCallStats final returned {}'.format(str(data)))
        self.set_response(
            resp, responses.SuccessResponseObjectInfo(data=data,
                                                      payload_scheme=VoipGatewayCallStatGetScheme))
        return False


class VoipGatewayRateSorting(CustomAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewayRateSortingScheme
    entity = 'VoipGateway rate sorting'
    id_field = 'switch_id'
    body_parameters = ('Query for statistics', VoipGatewayRateSortingScheme)
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},)
    security = (DEFAULT_SECURITY)
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=VoipGatewayRateSortingScheme,
                                                                description='Rate sorting result'),)


    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        if not obj and kwargs['switch_id'] != '0':
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        effective_date = req.data.pop('effective_date', '')
        code = req.data.pop('code', '')
        rate_tables = req.data.pop('rate_table_ids', [])

        if not obj:
            lst = model.VoipGateway.query().filter(model.VoipGateway.connected == True).all()
            obj = lst[0]
        ret = []
        api = None
        log.debug('VoipGatewayCallStats calling  switch {}'.format(obj.id))
        if not obj.lan_ip or not obj.lan_port:
            self.set_response(resp, responses.ValidationErrorResponse(
                data={'switch_id': ['selected switch has no settings! check lan_ip and lan_port']}))
            return False
        try:
            # api = DnlActiveCallSession(obj.active_call_ip, obj.active_call_port)
            # api.login()
            api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
            log.debug('VoipGatewayCallStats swith {} logged in'.format(obj.id))
            sw_data = api.get_rate_sorting(effective_date, code, rate_tables)
            log.debug('VoipGatewayCallStats swith {} returned {}'.format(obj.id, str(sw_data)))
            data = {'result': sw_data}
            # api.logout()
        except Exception as e:
            log.warning('call stat error {}'.format(e))
            self.set_response(resp, responses.ValidationErrorResponse(
                data={'switch_id': ['selected switch {} has error {}'.format(obj.id, e)]}))
            return False
    
        log.debug('VoipGatewayCallStats final returned {}'.format(str(data)))
        self.set_response(
            resp, responses.SuccessResponseObjectInfo(data=data,
                                                      payload_scheme=VoipGatewayRateSortingScheme))
        return False


class VoipGatewayCallSigning(CustomAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewaySignCallScheme
    entity_plural = 'VoipGatewayCalls'
    id_field = 'switch_id'
    body_parameters = ('Query for statistics', VoipGatewaySignCallScheme)
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},)
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=VoipGatewayRateSortingScheme,
                                                                description='Rate sorting result'),)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        if not obj and kwargs['switch_id'] != '0':
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False

        ani = req.data['ani']
        dnis = req.data['dnis']
        attestation_lvl = req.data['attestation_lvl']
        if not obj:
            lst = model.VoipGateway.query().filter(model.VoipGateway.connected == True).all()
            obj = lst[0]
        ret = []
        api = None
        log.debug('VoipGatewayCallStats calling  switch {}'.format(obj.id))
        if not obj.active_call_ip or not obj.active_call_port:
            self.set_response(resp, responses.ValidationErrorResponse(
                data={'switch_id': ['selected switch has no settings! check active_call_ip and active_call_port']}))
            return False
        try:
            # api = DnlActiveCallSession(obj.active_call_ip, obj.active_call_port)
            # api.login()
            api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
            log.debug('VoipGatewayCallStats swith {} logged in'.format(obj.id))
            sw_data = api.sign_call(ani, dnis, attestation_lvl)
            log.debug('VoipGatewayCallStats swith {} returned {}'.format(obj.id, str(sw_data)))
            data = sw_data
            # api.logout()
        except Exception as e:
            log.warning('call stat error {}'.format(e))
            self.set_response(resp, responses.ValidationErrorResponse(
                data={'switch_id': ['selected switch {} has error {}'.format(obj.id, e)]}))
            return False

        log.debug('VoipGatewayCallStats final returned {}'.format(str(data)))
        self.set_response(
            resp, responses.SuccessResponseObjectInfo(data=data,
                                                      payload_scheme=VoipGatewayRateSortingScheme))
        return False


class VoipGatewayTestTelnet(CustomAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewayTestTelnetScheme
    entity = 'VoipGateway system statistic report'
    id_field = 'switch_id'
    # body_parameters = ('Query for statistics', VoipGatewaySystemCallStatScheme)
    body_parameters = ('Command line', VoipGatewayTestTelnetScheme)
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},)
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=VoipGatewaySystemCallStatGetScheme,
                                                                description='System Call statistics result'),)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        if not obj and kwargs['switch_id'] != '0':
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        cmd_line = req.data['cmd_line']
        if not obj:
            lst = model.VoipGateway.query().filter(model.VoipGateway.connected == True).all()
        else:
            lst = [obj]
        ret = []
        se_data = None
        for obj in lst:
            if not obj.lan_ip or not obj.lan_port:
                continue
                # self.set_response(resp, responses.ValidationErrorResponse(
                #     data={'switch_id': ['selected switch has no settings! check lan_ip and lan_port']}))
                # return False
            try:
                # api = None
                # api = DnlSwitchSession(obj.lan_ip, obj.lan_port)
                # api.login()
                api = get_dnl_switch_session(obj.lan_ip, obj.lan_port)
                sw_data = api.api_call(cmd_line).decode('utf-8')
                log.debug('VoipGateway swith {} returned {}'.format(obj.id, str(sw_data)))
                ret.append(sw_data)
                # api.logout()
            except Exception as e:
                log.warning(' system call stat error {}'.format(e))
                # if api:
                #     try:
                #         api.logout()
                #     except:
                #         pass
                continue
                # self.set_response(resp, responses.ValidationErrorResponse(
                #     data={
                #         'switch_id': [
                #             'cannot connect to selected switch! check lan_ip and lan_port in switch settings error: {}'.format(
                #                 e)]}))
                # return False
        data = {}
        data['items'] = sw_data
        log.debug('VoipGatewaySystemCallStats returned %s' % str(data))
        self.set_response(
            resp, responses.SuccessResponseObjectInfo(data=data,
                                                      payload_scheme=VoipGatewaySystemCallStatGetScheme))
        return False

    def x(self):
        pass


class VoipGatewaySystemCallStats(CustomAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewaySystemCallStatScheme
    entity = 'VoipGateway system statistic report'
    id_field = 'switch_id'
    body_parameters = ('Query for statistics', VoipGatewaySystemCallStatScheme)
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},)
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=VoipGatewaySystemCallStatGetScheme,
                                                                description='System Call statistics result'),)

    def on_post(self, req, resp, **kwargs):
        user = self.get_user(req)
        if user and user.user_type == 'client':
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return False

        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        if not obj and kwargs['switch_id'] != '0':
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        if not obj:
            lst = model.VoipGateway.query().filter(and_(model.VoipGateway.connected == True,
                                                        model.VoipGateway.lan_ip == '127.0.0.1')).all()
        else:
            lst = [obj]
        ret = []
        if 'type' in req.data and req.data['type'] != 'term':
            cls = model.QosIp
            scheme_class = QosIpSchemeGet
            
            fmt = 'YYYY-MM-DD HH24:MI:00'
            group_time = func.to_char(cls.report_time, fmt)
            _select = [
                func.sum(cls.call).label('call'),
                func.sum(cls.cps).label('cps'),
                func.sum(cls.channels).label('chan'),
            ]
            o_q = model.get_db().session.query(*_select)
            i_q = model.get_db().session.query(*_select)

            if req.data['type'] == 'orig':
                client_type = 'vendor'
                company_type = 'origination'
            elif req.data['type'] == 'term':
                client_type = 'client'
                company_type = 'termination'
            i_q = i_q.filter(cls.client_id.in_(select(
                [model.Client.client_id]).where(and_(model.Client.client_type == 'client',
                                                        model.Client.company_type == company_type))))
            
            o_q = o_q.filter(cls.client_id.in_(select(
                [model.Client.client_id]).where(and_(model.Client.client_type == 'vendor',
                                                        model.Client.company_type == company_type))))

            start_time = datetime.now() - timedelta(minutes=1)

            o_q = o_q.filter(cls.report_time >= start_time).group_by(cls.trunk_type2).limit(1)
            i_q = i_q.filter(cls.report_time >= start_time).group_by(cls.trunk_type2).limit(1)
            i_data = o_q.all()
            o_data = i_q.all()

            data = {
                "o_chan": o_data[0].chan if o_data else 0,
                "t_chan": i_data[0].chan if i_data else 0,
                "t_cps": i_data[0].cps if i_data else 0,
                "o_cps": o_data[0].cps if o_data else 0,
                "t_call": i_data[0].call if i_data else 0,
                "o_call": o_data[0].call if o_data else 0,
            }
            data["call"] = data["t_call"] + data["o_call"]
            data["cps"] = data["t_cps"] + data["o_cps"]
            data["chan"] = data["t_chan"] + data["o_chan"]

            self.set_response(
                resp, responses.SuccessResponseObjectInfo(data=data,
                                                        payload_scheme=VoipGatewaySystemCallStatGetScheme))
            return False

        for obj in lst:
            if not obj.lan_ip or not obj.lan_port:
                continue
                # self.set_response(resp, responses.ValidationErrorResponse(
                #     data={'switch_id': ['selected switch has no settings! check lan_ip and lan_port']}))
                # return False
            try:
                # api = None
                # api = DnlSwitchSession(obj.lan_ip, obj.lan_port)
                # api.login()
                api = get_dnl_switch_session(obj.lan_ip, obj.lan_port)
                sw_data = api.get_system_call_stat()
                log.debug('VoipGatewaySystemCallStats swith {} returned {}'.format(obj.id, str(sw_data)))
                ret.append(sw_data)
                # api.logout()
            except Exception as e:
                log.warning(' system call stat error {}'.format(e))
                # if api:
                #     try:
                #         api.logout()
                #     except:
                #         pass
                continue
                # self.set_response(resp, responses.ValidationErrorResponse(
                #     data={
                #         'switch_id': [
                #             'cannot connect to selected switch! check lan_ip and lan_port in switch settings error: {}'.format(
                #                 e)]}))
                # return False
        data = {}
        if len(ret):
            for k in list(ret[0].keys()):
                data[k] = sum([item[k] for item in ret if k in item])
        else:
            data = {
                "call": 0,
                "cps": 0,
                "chan": 0,
                "o_cps": 0,
                "t_cps": 0,
                "o_chan": 0,
                "t_chan": 0
            }
        log.debug('VoipGatewaySystemCallStats returned %s' % str(data))
        self.set_response(
            resp, responses.SuccessResponseObjectInfo(data=data,
                                                      payload_scheme=VoipGatewaySystemCallStatGetScheme))
        return False

    def x(self):
        pass


class VoipGatewayKillAllChannels(CustomPostAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewaySystemCallStatScheme
    entity = 'VoipGateway kill all running sip channels'
    id_field = 'switch_id'

    body_parameters = ()
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},)
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=VoipGatewaySystemCallStatGetScheme,
                                                                description='System Call statistics result'),)

    def apply(self, obj, req, resp, **kwargs):
        if not obj and kwargs['switch_id'] != '0':
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        if not obj:
            lst = model.VoipGateway.query().filter(model.VoipGateway.connected == True).all()
        else:
            lst = [obj]
        ret = {"items": []}
        for obj in lst:
            if not obj.lan_ip or not obj.lan_port:
                continue
            try:
                api = get_dnl_switch_session(obj.lan_ip, obj.lan_port)
                sw_data = api.kill_all_channels()
                log.debug('VoipGatewayKillAllChannels swith {} returned {}'.format(obj.id, str(sw_data)))
                ret['items'] = ret['items'] + sw_data['items']
            except Exception as e:
                log.warning(' system call stat error {}'.format(e))
                continue

        log.debug('VoipGatewayKillAllChannels returned %s' % str(ret))
        self.set_response(
            resp, responses.SuccessResponseObjectInfo(data=ret,
                                                      payload_scheme=VoipGatewaySystemCallStatGetScheme))
        return False

    def x(self):
        pass


class VoipGatewayKillChannel(CustomPostAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewaySystemCallStatScheme
    entity = 'VoipGateway kill all running sip channels'
    id_field = 'switch_id'

    body_parameters = ()
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},
                       {'name': 'uuid', 'description': 'channel uuid to kill'})
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=VoipGatewaySystemCallStatGetScheme,
                                                                description='System Call statistics result'),)

    def apply(self, obj, req, resp, **kwargs):
        if not obj and kwargs['switch_id'] != '0':
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        if not obj:
            lst = model.VoipGateway.query().filter(model.VoipGateway.connected == True).all()
        else:
            lst = [obj]
        ret = {"items": []}
        uuid = kwargs['uuid']
        for obj in lst:
            if not obj.lan_ip or not obj.lan_port:
                continue
            try:
                api = get_dnl_switch_session(obj.lan_ip, obj.lan_port)
                sw_data = api.kill_channel(uuid)
                log.debug('VoipGatewayKillChannel swith {} returned {}'.format(obj.id, str(sw_data)))
                ret['items'] = ret['items'] + [sw_data]
            except Exception as e:
                log.warning(' system call stat error {}'.format(e))
                continue

        log.debug('VoipGatewayKillChannel returned %s' % str(ret))
        self.set_response(
            resp, responses.SuccessResponseObjectInfo(data=ret,
                                                      payload_scheme=VoipGatewaySystemCallStatGetScheme))
        return False

    def x(self):
        pass


class VoipGatewaySystemPeakStats(CustomAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewaySystemCallStatScheme
    entity = 'VoipGateway system peak statistic report'
    id_field = 'switch_id'
    # body_parameters = ('Query for statistics', VoipGatewaySystemCallStatScheme)
    body_parameters = ()
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},)
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=VoipGatewaySystemPeakStatGetScheme,
                                                                description='System peak statistics result'),)

    def on_post(self, req, resp, **kwargs):
        user = self.get_user(req)
        if user and user.user_type == 'client':
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return False
        
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        kwargs['switch_id'] = req.data['switch_id'] if 'switch_id' in req.data else '0'
        if not obj and kwargs['switch_id'] != '0':
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False

        if not obj:
            lst = model.VoipGateway.query().filter(and_(model.VoipGateway.connected == True,
                                                        model.VoipGateway.lan_ip == '127.0.0.1')).all()
        else:
            lst = [obj]
        ret = None
        for obj in lst:
            if not obj.lan_ip or not obj.lan_port:
                self.set_response(resp, responses.ValidationErrorResponse(
                    data={'switch_id': ['selected switch has no settings! check lan_ip and lan_port']}))
                continue

            api = None
            try:
                api = get_dnl_switch_session(obj.lan_ip, obj.lan_port)
            except Exception as e:
                self.set_response(resp, responses.ValidationErrorResponse(
                    data={
                        'switch_id': [
                            'cannot connect to selected switch! check lan_ip and lan_port in switch settings']}))
                continue
            try:
                # api = DnlSwitchSession(obj.lan_ip, obj.lan_port)
                # api.login()
                sw_data = api.get_system_peak_stat()
                if not ret:
                    ret = sw_data
                else:
                    ret = dict(Counter(ret) + Counter(sw_data))
            except Exception as e:
                # if api:
                # 	try:
                # 		api.logout()
                # 	except:
                # 		pass
                self.set_response(
                    resp, responses.OperationErrorResponse(data={'error': str(e)}))
            # api.logout()
        if ret:
            self.set_response(
                resp, responses.SuccessResponseObjectInfo(data=ret,
                                                        payload_scheme=VoipGatewaySystemPeakStatGetScheme))
        # obj.check_info()
        # ret = obj.info.system_peak_stats
        return False


class VoipGatewayGetLicenseLimit(CustomAction):
    model_class = model.VoipGateway
    scheme_class = VoipGatewaySystemCallStatScheme
    entity = 'VoipGateway license limit  report'
    id_field = 'switch_id'
    body_parameters = ()
    path_parameters = ({'name': 'switch_id', 'description': 'gateway id to call'},)
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=VoipGatewayLicenseLimitGetScheme,
                                                                description='License limits result'),)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):

        if not obj:
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'switch_id': '{} not found'.format(kwargs['switch_id'])})
            )
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        if not obj.lan_ip or not obj.lan_port:
            self.set_response(resp, responses.ValidationErrorResponse(
                data={'switch_id': ['selected switch has no settings! check lan_ip and lan_port']}))
            return False

        api = None
        try:
            api = get_dnl_switch_session(obj.lan_ip, obj.lan_port)
        except Exception as e:
            self.set_response(resp, responses.ValidationErrorResponse(
                data={
                    'switch_id': ['cannot connect to selected switch! check lan_ip and lan_port in switch settings']}))
            return False
        try:
            ret = api.get_license_limit()

            self.set_response(
                resp, responses.SuccessResponseObjectInfo(data=ret,
                                                          payload_scheme=VoipGatewaySystemPeakStatGetScheme))
        except Exception as e:
            self.set_response(
                resp, responses.OperationErrorResponse(data={'error': str(e)}))

        self.set_response(
            resp, responses.SuccessResponseObjectInfo(data=ret,
                                                      payload_scheme=VoipGatewaySystemPeakStatGetScheme))
        return False


# --- VoipGateway


# +++ SwitchProfile

class SwitchProfileCreate(DnlCreate):
    scheme_class = SwitchProfileSipHostScheme
    entity = 'SwitchProfile'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        return obj


class SwitchProfileResource(DnlResource):
    model_class = model.SwitchProfile
    scheme_class = SwitchProfileModifyScheme
    scheme_class_get = SwitchProfileMinGetScheme
    scheme_class_modify = SwitchProfileModifyScheme
    entity = 'SwitchProfile'
    id_field = 'id'
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_patch(self, req, resp, **kwargs):
        user = self.get_user(req)
        if user.user_type == 'client':
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return False
        
        result = super().on_patch(req, resp, **kwargs)
        if result is False:
            return False

        try:
            switch_profile = self.get_object(resp, self.model_class, **kwargs)
            if not switch_profile:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(data="SwitchProfile object not found"))
                return
            voip_gateway = switch_profile.voip_gateway
            if not voip_gateway:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(data="VoipGateway object not found"))
                return
            if 'cps' in self.req_data:
                voip_gateway.cps = self.req_data['cps']
            if 'cap' in self.req_data:
                voip_gateway.cap = self.req_data['cap']
            self.model_class.session().commit()
            data = self.get_object_data(resp, self.model_class, self.scheme_class_get, **kwargs)
            if data:
                self.set_response(resp, responses.SuccessResponseObjectInfo(data=data))
            else:
                self.set_response(resp, responses.SuccessResponseJustOk())

        except Exception as e:
            log.error(str(e))
            self.set_response(resp, OperationErrorResponse(e))

    def on_get(self, req, resp, **kwargs):
        user = self.get_user(req)
        if not user.is_admin:
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        return super().on_get(req, resp, **kwargs)


class SwitchProfileList(DnlList):
    scheme_class = SwitchProfileGetScheme
    model_class = model.SwitchProfile
    entity_plural = 'SwitchProfiles'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class SipHostCreate(DnlCreate):
    scheme_class = SwitchProfileSipHostScheme
    entity = 'SipHost'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'switch_id', 'description': 'Parent gateway id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.switch_id = kwargs['switch_id']
        switch = model.VoipGateway.get(obj.switch_id)
        if not switch:
            raise ValidationError({'switch_id': ['switch_id {} invalid'.format(obj.switch_id)]})
        obj.switch_name = switch.name
        return obj


class SipHostResource(DnlResource):
    model_class = model.SwitchProfile
    scheme_class = SwitchProfileSipHostScheme
    scheme_class_get = SwitchProfileSipHostGetScheme
    entity = 'SipHost'
    id_field = 'id'
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_patch(self, req, resp, **kwargs):
        user = self.get_user(req)
        if user.user_type == 'client':
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return False

        result = super().on_patch(req, resp, **kwargs)
        if result is False:
            return False

        try:
            data = self.get_object_data(resp, self.model_class, self.scheme_class_get, **kwargs)
            if data:
                self.set_response(resp, responses.SuccessResponseObjectInfo(data=data))
            else:
                self.set_response(resp, responses.SuccessResponseJustOk())

        except Exception as e:
            log.error(str(e))
            self.set_response(resp, OperationErrorResponse(e))


class SipHostList(DnlList):
    scheme_class = SwitchProfileSipHostGetScheme
    model_class = model.SwitchProfile
    entity_plural = 'SwitchProfiles'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    
    def get_fields_for_list(self, parsed_qs, **kwargs):
        fields = super(SipHostList, self).get_fields_for_list(parsed_qs, **kwargs)
        user = self.get_user(self.req)
        if user and user.user_type == 'client':
            allowed_fields = ['sip_ip', 'sip_port']
            if fields is None:
                fields = allowed_fields
            else:
                fields = [f for f in fields if f in allowed_fields]
        return fields
    
    def on_get(self, req, resp, **kwargs):
        user = self.get_user(req)
        config = model.SystemParameter.get(1)
        if not config.portal_display_sip_ip and user and user.user_type == 'client':
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        ret = super(SipHostList, self).on_get(req, resp, **kwargs)
        return ret


# --- SwitchProfile

# --- CertificateVerification
class VerifyCertificate(DnlList):
    scheme_class = ShakenStiSpConfScheme
    model_class = model.ShakenStiSpConf
    entity_plural = 'VerifyCertificate'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec(self):
        return swagger.specify.get_spec(
            method='get', description='Certificate verification',
            path_parameters=(),
            query_parameters=[
                                 {'name': 'cert_url', 'type': 'string', 'required': True},
                             ],
            responses=(
                responses.SuccessResponseJustOk(),
                responses.ObjectNotFoundErrorResponse()
            ),
            security=self.security
        )

    def on_get(self, req, resp, **kwargs):  # pragma: no cover
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        kwargs = client_context(self, req, resp, **kwargs)
        try:
            return self._on_get(req, resp, **kwargs)
        except NoResultFound:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return None

    def _on_get(self, req, resp, **kwargs):
        # if (not hasattr(self, 'no_auth_needed') or self.no_auth_needed == False) and not check_permission(self, req,
        #                                                                                                   'list'):
        #     self.set_response(
        #         resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
        #     )
        #     return


        # cert_url = self.model_class.query().first().x5u
        params = dict(parse_qsl(req.query_string))
        cert_url = params.pop('cert_url', None)
        response = requests.get(cert_url)

        cert = crypto.load_certificate(crypto.FILETYPE_PEM, response.content)

        try:
            self.set_response(
                resp, responses.SuccessResponse(
                    data={
                        'items': crypto.dump_certificate(crypto.FILETYPE_TEXT, cert).decode()
                    },
                    scheme=schemes.ObjectScheme
                )
            )
        except Exception as e:
            log.debug(f"ERROR - {e}")


# --- Token header verification
class VerifyTokenHeader(resources.CustomAction):
    scheme_class = VerifyTokenHeaderScheme
    model_class = model.ShakenStiSpConf
    entity_plural = 'VerifyTokenHeaders'
    path_parameters = ()
    body_parameters = ('Token header to validate', VerifyTokenHeaderScheme)
    additional_responses = (responses.SuccessResponseObjectInfo(scheme=CallApiScheme,
                                                                description='Verify token header result'),)
    security = (DEFAULT_SECURITY)
    restrict = ()
    method = 'post'

    #def get_spec(self):
    #    return swagger.specify.get_spec(
    #        method='get', description='Token header verification',
    #        path_parameters=(),
    #        responses=(
    #            responses.SuccessResponseJustOk(),
    #            responses.ObjectNotFoundErrorResponse()
    #        ),
    #        security=self.security
    #    )

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        scheme = self.scheme_class().load(req.data)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False

        if not obj:
            lst = [gw for gw in model.VoipGateway.query() if gw._connected]
            if len(lst) == 0:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                    data={'message': 'Connected voip gateway not found'}))
                return False

            obj = lst[0]

        if req.data and req.data['token_header']:
            try:
                api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
                log.debug('VoipGatewayCallStats switch {} logged in'.format(obj.id))
                sw_data = api.verify_token_header(req.data['token_header'])
                log.debug(sw_data)
                # self.set_response(
                #     resp, responses.SuccessResponse(data={'success': True, 'payload': sw_data}))
                self.set_response(resp, responses.SuccessResponseObjectInfo(data=sw_data))
                return False
            except Exception as e:
                self.set_response(resp, OperationErrorResponse(e))
                return False
        else:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False

# --------------RouteStrategy
class RouteStrategyCreate(DnlCreate):
    scheme_class = RouteStrategyScheme
    entity = 'RouteStrategy'
    unique_field = 'route_plan_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        return obj


class RouteStrategyExCreate(CustomPostAction):
    scheme_class = RouteStrategyExScheme
    entity = 'RouteStrategy'
    unique_field = 'route_plan_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_parameters = ('Create route plan and routes for this data', scheme_class,)

    def on_post(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        try:
            self.apply(None, req, resp, **kwargs)
        except Exception as e:
            log.error(e)
            self.set_response(resp, OperationErrorResponse(e))

    def apply(self, obj, req, resp, **kwargs):
        errors = self.scheme_class().validate(data=req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        obj = model.RouteStrategy(name=self.req_data['name'], is_virtual=False)
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        type = self.req_data['type']
        dr = None
        sr = None
        if type == 'LCR':
            dr = model.DynamicRoute(name=obj.name)
            for tr in self.req_data['egress_trunks']:
                dr.egress_trunks.append(model.DynamicRouteItem(resource_id=tr))
            r = model.Route(route_type_flg='Dynamic Routing', route_type='dynamic routing')
            r.dynamic_route = dr
            obj.routes.append(r)
        else:
            sr = model.Product(name=obj.name)
            sri = model.ProductItems(alias=obj.name, strategy=type)
            sr.items.append(sri)
            for tr in self.req_data['egress_trunks']:
                sri.trunks.append(model.ProductItemsResource(resource_id=tr))
            r = model.Route(route_type_flg='Static Routing', route_type='static routing')
            r.static_route = sr
            obj.routes.append(r)
        data = obj.save()
        self.set_response(
            resp, self.scheme_class.get_object_created_response(data=data)
        )
        return False


class RouteStrategyResource(DnlResource):
    model_class = model.RouteStrategy
    scheme_class = RouteStrategyScheme
    scheme_class_get = RouteStrategyGetScheme
    scheme_class_modify = RouteStrategyScheme
    entity = 'RouteStrategy'
    id_field = 'route_plan_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        return super(RouteStrategyResource, self).before_update(obj, req)

    def get_object_data(self, resp, model_class, scheme_class, **kwargs):
        kwargs['route_strategy_id'] = kwargs['route_plan_id']
        return super(RouteStrategyResource, self).get_object_data(resp, model_class, scheme_class, **kwargs)

    def on_delete(self, req, resp, **kwargs):
        kwargs['route_strategy_id'] = kwargs['route_plan_id']
        return super(RouteStrategyResource, self).on_delete(req, resp, **kwargs)


class RouteStrategyCopy(DnlCreate):
    scheme_class = RouteStrategyCopyScheme
    entity = 'RouteStrategy copy'
    id_field = 'route_plan_id'
    has_update_by = True
    path_parameters = ({'name': 'route_plan_id', 'description': 'Route Strategy to copy'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        old_obj = model.RouteStrategy.get(kwargs['route_plan_id'])
        if not old_obj:
            raise NoResultFound('Not found {}'.format(kwargs['route_plan_id']))

        f = tuple([c.name for c in inspect(model.RouteStrategy).columns if
                   not '%' in c.name and c.name not in ['name', 'route_strategy_id']])

        class Schema(BaseModelScheme):
            class Meta:
                model = model.RouteStrategy
                fields = f

        s = Schema()
        s.load(data=s.dump(old_obj).data, instance=obj)

        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)

        for route in old_obj.routes:
            make_transient(route)
            route.route_id = None
            route.create_time = obj.update_at
            obj.routes.append(route)
            obj.save()

        return obj


class RouteStrategyList(DnlList):
    scheme_class = RouteStrategyGetScheme
    model_class = model.RouteStrategy
    entity_plural = 'RouteStrategys'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_filter_dynamic_name(self, q, val, kwargs):
        Dr = aliased(model.DynamicRoute)
        R = aliased(model.Route)
        cls = self.model_class
        if '*' in val:
            val = val.replace('*', '%')
            log.debug(model.query_to_sting(q))
            return q.filter(cls.route_strategy_id.in_(select([R.route_strategy_id]).where(
                and_(R.dynamic_route_id == Dr.dynamic_route_id, Dr.name.like(val)))))
        else:
            q = q.filter(cls.route_strategy_id.in_(
                select([R.route_strategy_id]).where(and_(R.dynamic_route_id == Dr.dynamic_route_id, Dr.name == val))))
            log.debug(model.query_to_sting(q))
            return q

    def on_filter_static_name(self, q, val, kwargs):
        P = aliased(model.Product)
        R = aliased(model.Route)
        cls = self.model_class
        if '*' in val:
            val = val.replace('*', '%')
            q = q.filter(cls.route_strategy_id.in_(
                select([R.route_strategy_id]).where(and_(R.static_route_id == P.product_id, P.name.like(val)))))
            log.debug(model.query_to_sting(q))
            return q
        else:
            q = q.filter(cls.route_strategy_id.in_(
                select([R.route_strategy_id]).where(and_(R.static_route_id == P.product_id, P.name == val))))
            log.debug(model.query_to_sting(q))
            return q

    def on_filter_dynamic_route_id(self, q, val, kwargs):
        R = aliased(model.Route)
        cls = self.model_class
        q = q.filter(
            cls.route_strategy_id.in_(select([R.route_strategy_id]).where(and_(R.dynamic_route_id == int(val)))))
        log.debug(model.query_to_sting(q))
        return q

    def on_filter_static_route_id(self, q, val, kwargs):
        R = aliased(model.Route)
        cls = self.model_class
        q = q.filter(
            cls.route_strategy_id.in_(select([R.route_strategy_id]).where(and_(R.static_route_id == int(val)))))
        log.debug(model.query_to_sting(q))
        return q

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        model_class = self.model_class
        # if 'by' in ordering and ordering['by'] == 'usage_count':
        #     if ordering['dir'] == 'desc':
        #         query = query.join(model.Route, isouter=True).group_by(model.RouteStrategy.route_strategy_id).order_by(
        #             model.func.count(model.Route.route_id.distinct()).desc())
        #     else:
        #         query = query.join(model.Route, isouter=True).group_by(model.RouteStrategy.route_strategy_id).order_by(
        #             model.func.count(model.Route.route_id.distinct()))
        return ordering, query

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(RouteStrategyList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        model_class = self.model_class
        q = q.filter(model_class.route_plan_id != 1)
        q = q.filter(model_class.name != 'ORIGINATION_ROUTING_PLAN')
        return (filt, q)


# ------ RouteStrategy ------


# +++ CarrierGroupScheme
# ------ CarrierGroup ------
class CarrierGroupCreate(DnlCreate):
    scheme_class = CarrierGroupScheme
    entity = 'CarrierGroup'
    unique_field = 'group_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        return obj

    def create_object(self, req, scheme, **kwargs):
        clients = None
        if 'clients' in req.data:
            clients = req.data['clients']
            del req.data['clients']
        else:
            raise ValidationError('Client list not exists')
        ret = super(CarrierGroupCreate, self).create_object(req, scheme, **kwargs)
        if clients:
            obj = model.CarrierGroup.get(ret)
            obj.clients = clients
            obj.save()
        return ret


class CarrierGroupResource(DnlResource):
    model_class = model.CarrierGroup
    scheme_class = CarrierGroupScheme
    scheme_class_get = CarrierGroupGetScheme
    scheme_class_modify = CarrierGroupScheme
    entity = 'CarrierGroup'
    id_field = 'group_id'
    has_update_by = False
    unique_field = 'group_name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class CarrierGroupList(DnlList):
    scheme_class = CarrierGroupGetScheme
    model_class = model.CarrierGroup
    entity_plural = 'CarrierGroups'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(CarrierGroupList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


# -- CarrierGroupScheme

# ------ ResourceIpLimit ------
class ResourceIpLimitCreate(DnlCreate):
    scheme_class = ResourceIpLimitScheme
    entity = 'ResourceIpLimit'
    unique_field = 'limit_id'
    additional_responses = ()
    path_parameters = ({'name': 'resource_ip_id', 'description': 'Parent IP id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        resource_ip_id = kwargs['resource_ip_id']
        resource_ip = model.ResourceIp.get(resource_ip_id)
        if not resource_ip:
            raise ValidationError('ResourceIp {} is not found!'.format(resource_ip_id))
        obj.resource_ip_id = kwargs['resource_ip_id']
        return obj


class ResourceIpLimitResource(DnlResource):
    model_class = model.ResourceIpLimit
    scheme_class = ResourceIpLimitScheme
    scheme_class_get = ResourceIpLimitGetScheme
    scheme_class_modify = ResourceIpLimitScheme
    entity = 'ResourceIpLimit'
    id_field = 'limit_id'
    has_update_by = False
    # unique_field = 'ip_id'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ResourceIpLimitList(DnlList):
    scheme_class = ResourceIpLimitGetScheme
    model_class = model.ResourceIpLimit
    entity_plural = 'ResourceIpLimits'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceIpLimitList, self).get_filtering_for_list(parsed_qs, **kwargs)
        # ret['resource_id'] = kwargs['trunk_id']
        return ret


class ResourceIpLimitExtList(DnlList):
    scheme_class = ResourceIpLimitExtGetScheme
    model_class = model.ResourceIpLimitQuery
    entity_plural = 'ResourceIpLimits'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_field(self, fn):
        c = model.Client
        r = model.Resource
        i = model.ResourceIp
        l = model.ResourceIpLimit
        """'cps','capacity','resource_ip','resource_port','resource_active','resource_alias','resource_cps_limit',
                'resource_capacity','client_name','client_call_limit','client_cps_limit'"""
        fmap = {
            'cps': l.cps,
            'capacity': l.capacity,
            'resource_id': r.resource_id,
            'resource_ip_id': r.resource_id,
            'client_id': r.client_id,
            'resource_ip': i.ip,
            'resource_port': i.port,
            'resource_active': r.active,
            'resource_alias': r.alias,
            'resource_cps_limit': r.cps_limit,
            'resource_call_limit': r.call_limit,
            'resource_capacity': r.capacity,
            'client_name': c.name,
            'client_cps_limit': c.cps_limit,
            'client_call_limit': c.call_limit,
            'client_type': c.client_type,
            'company_type': c.company_type,
        }
        if fn in fmap:
            return fmap[fn]
        return None

    def on_filtering(self, q, fn, val, kwargs):
        f = self.get_field(fn)
        if f:
            if '*' in val:
                val = val.replace('*', '%')
                return q.filter(f.like(val))
            return q.filter(f == val)
        return q

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(ResourceIpLimitExtList, self).modify_query_from_ordering_for_list(ordering, query,
                                                                                                  **kwargs)

        if 'by' in ordering:
            f = self.get_field(ordering['by'])
            if f:
                odir = 'desc' if ordering['dir'] == 'desc' else 'asc'
                query = query.order_by(ordering['by'] + ' ' + odir)
                ordering = {}
        return ordering, query


# ------ ResourceIp ------
class ResourceIpCreate(DnlCreate):
    scheme_class = ResourceIpAllScheme
    entity = 'ResourceIp'
    unique_field = 'resource_ip_id'
    additional_responses = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    import_key_fields = ('ip', 'port')
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        if 'trunk_id' in kwargs:
            obj.resource_id = kwargs['trunk_id']
        if obj.ip:
            obj.addr_type = 'ip'
        if not model.Resource.get(obj.resource_id):
            raise NoResultFound()
        # _valid('Resource', 'resource_id',obj.resource_id,'invalid trink_id {}'.format('resource_id'))
        # if not model.ResourceIp.validate_ip(obj.resource_id,obj.ip):
        #   raise ValidationError('Ip {} is duplicate on ingress trunks!'.format(obj.ip))

        return obj


class ResourceIpResource(DnlResource):
    model_class = model.ResourceIp
    scheme_class = ResourceIpAllScheme
    scheme_class_get = ResourceIpAllGetScheme
    scheme_class_modify = ResourceIpAllScheme
    entity = 'ResourceIp'
    id_field = 'resource_ip_id'
    has_update_by = False
    unique_field = 'resource_ip_id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = False


class ResourceIpLimitsResource(DnlResource):
    model_class = model.ResourceIp
    scheme_class = ResourceIpLimitsScheme
    scheme_class_get = ResourceIpAllGetScheme
    scheme_class_modify = ResourceIpLimitsScheme
    entity = 'ResourceIp'
    id_field = 'resource_ip_id'
    has_update_by = False
    unique_field = 'resource_ip_id'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ResourceIpList(DnlList):
    scheme_class = ResourceIpAllGetScheme
    model_class = model.ResourceIp
    entity_plural = 'ResourceIps'
    path_parameters = ()  # ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceIpList, self).get_filtering_for_list(parsed_qs, **kwargs)
        # ret['resource_id'] = kwargs['trunk_id']
        return ret


# -- CarrierGroupScheme


# --------------ResourcePrefix
class ResourcePrefixCreate(DnlCreate):
    scheme_class = ResourcePrefixWithIPScheme
    entity = 'ResourcePrefix'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.resource_id = kwargs['trunk_id']
        if obj.product_id:
            product = model.ProductRoutRateTable.get(obj.product_id)
            if not obj.tech_prefix:
                obj.tech_prefix = product.prefix
            if not obj.route_strategy_id:
                obj.route_strategy_id = product.rout_id
            if not obj.rate_table_id:
                obj.rate_table_id = product.rate_table_id
        return obj

    def create_object(self, req, scheme, **kwargs):
        if 'ips' in self.req_data:
            for ip in self.req_data['ips']:
                it = model.ResourceIp(resource_id=kwargs['trunk_id'], ip=ip, direction=0)
                it.save()
            del self.req_data['ips']
        data = resources.BaseResource.create_object(self, req, scheme, **kwargs)
        return data


class ResourcePrefixResource(DnlResource):
    model_class = model.ResourcePrefix
    scheme_class = ResourcePrefixScheme
    scheme_class_get = ResourcePrefixGetScheme
    scheme_class_modify = ResourcePrefixModifyScheme
    entity = 'ResourcePrefix'
    id_field = 'id'
    has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        if 'product_id' in req.data:
            pr = model.ProductRoutRateTable.get(int(req.data['product_id']))
            if pr:
                if not 'rate_table_id' in req.data:
                    obj.rate_table_id = pr.rate_table_id
                if not 'routing_plan_id' in req.data:
                    obj.routing_plan_id = pr.route_plan_id
                if not 'tech_prefix' in req.data:
                    obj.tech_prefix = pr.prefix
        return obj


class ResourcePrefixList(DnlList):
    scheme_class = ResourcePrefixGetScheme
    model_class = model.ResourcePrefix
    entity_plural = 'ResourcePrefixs'
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourcePrefixList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['resource_id'] = kwargs['trunk_id']
        return ret


class ResourcePrefixFullList(DnlList):
    scheme_class = ResourcePrefixGetScheme
    model_class = model.ResourcePrefix
    entity_plural = 'ResourcePrefixs'
    security = (DEFAULT_SECURITY)
    restrict = ()


# ------ ResourcePrefix ------


# --------------ResourceDirection
class ResourceDirectionCreate(DnlCreate):
    scheme_class = ResourceDirectionScheme
    entity = 'ResourceDirection'
    unique_field = 'direction_id'
    additional_responses = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.resource_id = kwargs['trunk_id']
        return obj


class ResourceDirectionResource(DnlResource):
    model_class = model.ResourceDirection
    scheme_class = ResourceDirectionScheme
    scheme_class_get = ResourceDirectionGetScheme
    scheme_class_modify = ResourceDirectionScheme
    entity = 'ResourceDirection'
    id_field = 'direction_id'
    has_update_by = False
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ResourceDirectionList(DnlList):
    scheme_class = ResourceDirectionGetScheme
    model_class = model.ResourceDirection
    entity_plural = 'ResourceDirections'
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        user = self.get_user(self.req)
        if (user.user_type == 'client') and user.client:
            resources = model.Resource.session().query(model.Resource.resource_id).filter(
                    model.Resource.client_id == user.client.client_id).all()
            resource_ids = [resource.resource_id for resource in resources]
            ret = ret.filter(cls.resource_id.in_(resource_ids))
        return filt, ret


    def on_filter_empty_dnis(self, query, value, kwargs):
        cls = self.model_class
        if value:
            q = query.filter(or_(cls.dnis.is_(None), cls.dnis == ''))
        else:
            q = query.filter(and_(cls.dnis.isnot(None), cls.dnis != ''))
        return q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceDirectionList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['resource_id'] = kwargs['trunk_id']
        return ret


class ResourceOcnCreate(resources.CustomAction):
    scheme_class = OcnBlocklistPostScheme
    entity = 'OcnBlocklist'
    unique_field = 'direction_id'
    additional_responses = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    security = (DEFAULT_SECURITY)
    has_update_by = True
    restrict = ()
    description = 'Create multiply ocn items in trunk'
    body_parameters = ('Ocns to create', OcnBlocklistManyScheme)
    model_class = model.Resource
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        # raise Exception('req_data='+str(req.data)+' ags='+str(kwargs) )
        # raise Exception('obj='+str(obj))
        result = []
        try:
            cls = model.OcnBlocklist
            query = cls.session().query(cls.ocn, cls.res_id).filter(cls.res_id == kwargs['trunk_id'])
            existing_ocns = [i[0] for i in query]

            seen_ocns = set()
            data_processed = []
            for item in req.data['ocns']:
                for ocn in item['ocn'].split("\\"):
                    if ocn not in seen_ocns and ocn not in existing_ocns:
                        new_item = item.copy()
                        new_item['ocn'] = ocn
                        data_processed.append(new_item)
                        seen_ocns.add(ocn)
            req.data['ocns'] = data_processed

            import jwt
            token = req.headers.get('X-AUTH-TOKEN')
            payload = jwt.decode(token, settings.JWT_SIGNATURE)
            user = model.User.filter(model.User.user_id == payload['user_id']).first()
            for data in req.data.get('ocns', []):
                data['res_id'] = kwargs['trunk_id']
                data['created_by'] = user.name
                child, errors = OcnBlocklistScheme().load(data)
                if errors:
                    self.set_response(resp, responses.ValidationErrorResponse(data=errors))
                    return False
                try:
                    obj.session().add(child)
                    obj.session().commit()
                    log.debug(f"Saved OCN: {child.ocn}, ID: {child.id}")
                    result.append(child.id)
                except Exception as e:
                    obj.session().rollback()
                    self.set_response(resp, OperationErrorResponse(e))
                    return False

            if result:
                self.set_response(
                    resp, responses.SuccessResponse(
                        data={
                            'items': result,
                        },
                        scheme=schemes.ObjectScheme
                    )
                )
                return True
            else:
                self.set_response(
                    resp, responses.SuccessResponseJustOk())
                return True
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


class ResourceOcnResource(DnlResource):
    model_class = model.OcnBlocklist
    scheme_class = OcnBlocklistScheme
    scheme_class_get = OcnBlocklistScheme
    scheme_class_modify = OcnBlocklistScheme
    entity = 'OcnBlocklist'
    id_field = 'id'
    has_update_by = False
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ResourceOcnList(DnlList):
    scheme_class = OcnBlocklistScheme
    model_class = model.OcnBlocklist
    entity_plural = 'ResourceDirections'
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceOcnList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['res_id'] = kwargs['trunk_id']
        return ret

class TrunkWithDirectionResource(DnlResource):
    model_class = model.Resource
    scheme_class = ResourceWithDirectionScheme
    scheme_class_get = ResourceWithDirectionScheme
    scheme_class_modify = ResourceWithDirectionScheme
    entity = 'Trunk directions'
    id_field = 'trunk_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = True
    has_info_operation = False

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        return obj

    def delete_object(self, req, resp, model_class, **kwargs):
        model.ResourceDirection.filter(model.ResourceDirection.resource_id == kwargs['trunk_id']).delete(
            synchronize_session='fetch')
        return True


# ------ ResourceDirection ------


# --------------ResourceReplaceAction
class ResourceReplaceActionCreate(DnlCreate):
    scheme_class = ResourceReplaceActionScheme
    entity = 'ResourceReplaceAction'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.resource_id = kwargs['trunk_id']
        return obj


class ResourceReplaceActionResource(DnlResource):
    model_class = model.ResourceReplaceAction
    scheme_class = ResourceReplaceActionScheme
    scheme_class_get = ResourceReplaceActionGetScheme
    scheme_class_modify = ResourceReplaceActionScheme
    entity = 'ResourceReplaceAction'
    id_field = 'id'
    has_update_by = False
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ResourceReplaceActionList(DnlList):
    scheme_class = ResourceReplaceActionGetScheme
    model_class = model.ResourceReplaceAction
    entity_plural = 'ResourceReplaceActions'
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent trunk id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceReplaceActionList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['resource_id'] = kwargs['trunk_id']
        return ret


class TrunkWithReplaceActionResource(DnlResource):
    model_class = model.Resource
    scheme_class = ResourceWithReplaceActionScheme
    scheme_class_get = ResourceWithReplaceActionScheme
    scheme_class_modify = ResourceWithReplaceActionScheme
    entity = 'Trunk replace actions'
    id_field = 'trunk_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = False
    has_info_operation = False

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        return obj


# ------ ResourceReplaceAction ------


# --------------ProductRoutRateTable???Product???
class ProductRoutRateTableCreate(DnlCreate):
    model_class = model.ProductRoutRateTable
    scheme_class = ProductRoutRateTableScheme
    entity = 'Product'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_on = datetime.now(UTC)
        if self.get_user():
            obj.update_by = self.get_user().name
        return obj

    def create_object(self, req, scheme, **kwargs):
        if 'clients' in req.data:
            client_list = req.data.pop('clients')
        else:
            client_list = None
        _id = super(ProductRoutRateTableCreate, self).create_object(req, scheme, **kwargs)
        if _id and client_list:
            obj = self.scheme_class.Meta.model.get(_id)
            obj.clients = client_list
            obj.save(save_history=True, user=self.get_user(req), module=getattr(self.__class__, 'api_module', 'N/A'))
        return _id


class ProductRoutRateTableResource(DnlResource):
    model_class = model.ProductRoutRateTable
    scheme_class = ProductRoutRateTableScheme
    scheme_class_get = ProductRoutRateTableGetScheme
    scheme_class_modify = ProductRoutRateTableScheme
    entity = 'Product'
    id_field = 'id'
    has_update_by = True
    unique_field = 'product_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_on = datetime.now(UTC)
        obj.update_by = self.get_user().name

        return obj


class ProductRoutRateTableList(DnlList):
    scheme_class = ProductRoutRateTableGetScheme
    model_class = model.ProductRoutRateTable
    entity_plural = 'Products'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        user = self.get_user(self.req)
        if user and user.client:
            filtering['client_id'] = user.client.client_id
        return super(ProductRoutRateTableList, self).modify_query_from_filtering_for_list(filtering, **kwargs)

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(ProductRoutRateTableList, self).modify_query_from_ordering_for_list(ordering, query,
                                                                                                    **kwargs)
        cls = self.model_class
        if ordering and 'by' in ordering:
            if ordering['by'] == 'tech_prefix':
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    query = query.order_by(func.length(cls.prefix)).order_by(cls.prefix)
                else:
                    query = query.order_by(func.length(cls.prefix).desc()).order_by(cls.prefix.desc())
        return ordering, query

    def on_filter_client_id(self, query, value, kwargs):
        cls = self.model_class
        ref = model.ProductClientsRef
        q = query.filter(
            or_(cls.type == 'public', cls.id.in_(select([ref.product_id]).where(ref.client_id == int(value)))))
        log.debug(model.query_to_sting(q))
        return q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ProductRoutRateTableList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


class ProductRoutRateTablePublicList(DnlList):
    scheme_class = ProductRoutRateTablePublicGetScheme
    model_class = model.ProductRoutRateTable
    entity_plural = 'PublicProducts'
    path_parameters = ()
    security = ({'api_auth': []})
    restrict = ()
    no_auth_needed = True

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ProductRoutRateTablePublicList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ref = None
        if 'reference' in filtering:
            ref = filtering['reference']
            del filtering['reference']
        filt, ret = super(ProductRoutRateTablePublicList, self).modify_query_from_filtering_for_list(filtering,
                                                                                                     **kwargs)
        if ref:
            import jwt
            try:
                data = jwt.decode(ref, settings.JWT_SIGNATURE)
                agent_id = data['agent_id']
                ar = model.ProductAgentsRef
                ret = ret.filter(or_(self.model_class.agent_id == agent_id,
                                     self.model_class.id.in_(select([ar.product_id]).where(ar.agent_id == agent_id))))
            except Exception as e:
                raise e
        # raise ValidationError('Invalid reference key')
        else:
            ret = ret.filter(self.model_class.type == 'public')

        return (filt, ret)


class ProductRoutRateTableClientsResource(resources.CustomPatchAction):
    model_class = model.ProductRoutRateTable
    scheme_class = ProductRoutRateTableClientsScheme
    scheme_class_get = ProductRoutRateTableClientsScheme
    scheme_class_modify = ProductRoutRateTableClientsScheme
    entity = 'Product'
    id_field = 'id'
    has_update_by = True
    unique_field = 'product_name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = False

    def apply(self, obj, req, resp, **kwargs):
        # def before_update(self, obj, req):
        if not obj:
            self.set_response(resp, OperationErrorResponse('Product does not exist:{}'.format(kwargs['id'])))
            return False
        for cl in obj.clients:
            cl.user.par_id = None
        obj.query().session.refresh(obj)
        for cid in req.data['clients']:
            cl = model.Client.get(cid)
            if cl:
                cl.user.par_id = obj.id
            else:
                self.set_response(resp, OperationErrorResponse('Client does not exist:{}'.format(cid)))
                return False
        return True


class ProductRoutRateTableSendResource(resources.CustomPatchAction):
    model_class = model.ProductRoutRateTable
    scheme_class = ProductRoutRateTableGetScheme
    # scheme_class_get = ProductRoutRateTableGetScheme
    # scheme_class_modify = ProductRoutRateTableMinScheme
    entity = 'Product send letter'
    # id_field = 'id'
    # has_update_by = True
    # unique_field = 'product_name'
    # security = (DEFAULT_SECURITY)
    # restrict = ()
    path_parameters = ({'name': 'id', 'description': 'Product to proceed'},)

    def apply(self, obj, req, resp, **kwargs):
        # def before_update(self, obj, req):
        if not obj:
            self.set_response(resp, OperationErrorResponse('Product does not exist:{}'.format(kwargs['id'])))
            return False
        for cid in obj.clients:
            cl = model.Client.get(cid)
            cl.product_name = obj.product_name
            cl.route_plan_name = obj.route_plan.name
            cl.product_rate_table_name = obj.rate_table.name
            cl.apply_mail('rate')
        return True


# ------ ProductRoutRateTable ------


class ProductRouteAnalysisCreate(DnlCreate):
    scheme_class = ProductRouteAnalysisScheme
    entity = 'ProductRouteAnalysisRequest'
    unique_field = 'uuid'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.create_by = self.get_user().name
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        try:
            from api_dnl.task.product_route_analysis import product_route_analysis
            product_route_analysis.delay(object_id)
        except:
            pass


class ProductRouteAnalysisResource(DnlResource):
    model_class = model.ProductRouteAnalysis
    scheme_class = ProductRouteAnalysisScheme
    scheme_class_get = ProductRouteAnalysisGetScheme
    entity = 'ProductRouteAnalysisRequest'
    id_field = 'uuid'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ProductRouteAnalysisList(DnlList):
    scheme_class = ProductRouteAnalysisGetScheme
    model_class = model.ProductRouteAnalysis
    entity_plural = 'ProductRouteAnalysisRequests'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class ProductRouteAnalysisLogList(DnlList):
    scheme_class = ProductRouteAnalysisLogGetScheme
    model_class = model.ProductRouteAnalysisLog
    entity_plural = 'ProductRouteAnalysisResults'
    path_parameters = ({'name': 'uuid', 'description': 'UUID of analysis request'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(ProductRouteAnalysisLogList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        ret = ret.filter(cls.uuid == kwargs['uuid'])
        return filt, ret


# +++++ Resource

class ResourceList(DnlList):
    scheme_class = ResourceInfoGetScheme
    model_class = model.Resource
    entity_plural = 'Trunks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    #large_list_fields = ['trunk_id', 'trunk_name', 'type', 'direction', 'active', 'carrier', 'carrier_id', 'client_name']

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(ResourceList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # ret = ret.filter(cls.client_id.in_(self.get_user(self.req).clients_id))
        ret = ret.filter(model.user_id_filter(cls, self.get_user(self.req).user_id))
        return filt, ret

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(ResourceList, self).modify_query_from_ordering_for_list(ordering, query, **kwargs)
        if ordering and 'by' in ordering:
            if ordering['by'] == 'type':
                ordering['by'] = 'ingress'
            if ordering['by'] == 'direction':
                ordering['by'] = 'egress'
        return ordering, query

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceList, self).get_filtering_for_list(parsed_qs, **kwargs)

        if 'carrier' in ret:
            q = model.Client.filter(model.Client.name == ret['carrier']).first()
            if q:
                ret['client_id'] = str(q.client_id)
            else:
                raise Exception('Invalid carrier name ' + str(ret['carrier']))
            del ret['carrier']
        if 'type' in ret:
            if 'active' in ret and ret['active'] == 'false':
                raise Exception('Invalid input: active =' + str(ret['active']) + ' and type=' + ret['type'])
            ret['active'] = 'true'
            if ret['type'] == 'orig':
                ret['ingress'] = 'true'
            if ret['type'] == 'term':
                ret['egress'] = 'true'
            if not ret['type'] in ['orig', 'term']:
                raise Exception('Invalid type:' + str(ret['type']))
            del ret['type']
        if 'direction' in ret:
            if ret['direction'] == 'ingress':
                ret['ingress'] = 'true'
            if ret['direction'] == 'egress':
                ret['egress'] = 'true'
            if not ret['direction'] in ['ingress', 'egress']:
                raise Exception('Invalid direction:' + str(ret['direction']))
            del ret['direction']

        # raise Exception('RET='+str(ret))
        return ret


class ResourceGatewayGroupList(DnlList):
    scheme_class = ClientGatewayGroupGetScheme
    model_class = model.Client
    entity_plural = 'Gateway groups'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_filter_resource_id(self, q, val, kwargs):
        cls = self.model_class
        r = model.Resource
        q = q.filter(cls.client_id.in_(select([r.client_id]).where(r.resource_id == val)))
        return q

    def on_filter_alias(self, q, val, kwargs):
        cls = self.model_class
        r = model.Resource
        if '*' in val:
            q = q.filter(cls.client_id.in_(select([r.client_id]).where(r.alias.like(val.replace('*', '%')))))
        else:
            q = q.filter(cls.client_id.in_(select([r.client_id]).where(r.alias == val)))
        return q

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(ResourceGatewayGroupList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # ret = ret.filter(cls.status == True)
        return filt, ret


class ResourceUnclaimedList(ResourceList):
    scheme_class = ResourceUnclaimedGetScheme

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(ResourceUnclaimedList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        q = q.filter(and_(cls.client_id.is_(None), cls.is_virtual.isnot(True)))
        return (filt, q)


class ResourceEgressList(DnlList):
    scheme_class = EgressTrunkGetScheme  # ResourceGetScheme #
    model_class = model.EgressTrunk
    entity_plural = 'Egress Trunks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    large_fields = ['trunk_id', 'resource_id', 'name', 'trunk_name', 'client_name', 'carrier_id']

    def on_filter_is_rt_null(self, q, val, kwargs):
        cls = self.model_class
        if val in (False, 'false', 'False'):
            q = q.filter(cls.rate_table_id.isnot(None))
        return q

    def on_filter_has_ip(self, q, val, kwargs):
        cls = self.model_class
        clsip = aliased(model.ResourceIp)
        q = q.filter(cls.resource_id.in_(select([clsip.resource_id]).where(clsip.ip == val)))
        return q

    def on_filter_client_type(self, q, val, kwargs):
        cls = self.model_class
        if val == 'carrier':
            q = q.filter(cls.client_type.is_(None))
        else:
            q = q.filter(cls.client_type == val)
        return q

    def on_filter_dynamic_route_id(self, q, val, kwargs):
        cls = self.model_class
        r = model.EgressTrunk
        p = aliased(model.DynamicRouteItem)
        q = q.filter(r.resource_id.in_(select([p.resource_id]).where(p.dynamic_route_id == val)))
        return q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceEgressList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['egress'] = 'true'
        if 'carrier' in ret:
            q = model.Client.filter(model.Client.name == ret['carrier']).first()
            if q:
                ret['client_id'] = str(q.client_id)
            else:
                raise Exception('Invalid carrier name ' + str(ret['carrier']))
            del ret['carrier']
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(ResourceEgressList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # ret = ret.filter(and_(cls.egress == True, cls.alias != '', cls.client_type.is_(None),
        # or_(cls.client_id.is_(None), cls.client_id.in_(self.get_user(self.req).clients_id))))
        ret = ret.filter(
            and_(cls.egress == True, cls.alias != '', cls.purged == False,
                 model.user_id_filter(cls, self.get_user(self.req).user_id)))
        return filt, ret

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        all_fields = self.get_all_fields_from_scheme(self.scheme_class)[0]
        if ordering:
            if ',' in ordering['by']:
                ordl = ordering['by'].split(',')
                dirl = ordering['dir'].split(',')
                if len(ordl) != len(dirl):
                    raise Exception('Multi order_by must contain also all order_dir asc/desc specifications!')
                for ord in ordl:
                    if ord not in all_fields:
                        raise Exception('Order by {} not valid!'.format(ord))
                for dir in dirl:
                    if dir not in ['asc', 'desc']:
                        raise Exception('Wrong order dir {} ! Valid are ["ask","desk"]'.format(ord))
        return ordering, query


class ResourceEgressSmallList(ResourceEgressList):
    scheme_class = EgressTrunkGetSmallScheme


class ResourceIngressList(DnlList):
    scheme_class = IngressTrunkGetScheme  # ResourceGetScheme #
    model_class = model.IngressTrunk
    entity_plural = 'Ingress Trunks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    large_list_fields = ['trunk_id', 'resource_id', 'name', 'trunk_name', 'client_name', 'carrier_id']

    def on_filter_has_ip(self, q, val, kwargs):
        cls = self.model_class
        clsip = aliased(model.ResourceIp)
        q = q.filter(
            cls.resource_id.in_(
                select([clsip.resource_id]).where(
                    and_(clsip.ip == val, or_(clsip.username.is_(None), clsip.password.is_(None)))
                )
            )
        )
        return q

    def on_filter_client_type(self, q, val, kwargs):
        cls = self.model_class
        if val == 'carrier':
            q = q.filter(cls.client_type.is_(None))
        else:
            q = q.filter(cls.client_type == val)
        return q

    def on_filter_ip_count(self, q, val, kwargs):
        cls = self.model_class
        log.debug("START FILTERING BY NON-ZERO FIELD")
        if val.isdigit():
            log.debug("Digit parameter was chosen - {}".format(val))
            q = q.filter(cls.ip_count == int(val))
        elif val == 'zero':
            log.debug("Zero parameter was chosen")
            q = q.filter(cls.ip_count == 0)
        elif val == 'non-zero':
            log.debug("Non-zero parameter was chosen")
            q = q.filter(cls.ip_count > 0)
        return q

    def on_filter_product_id(self, q, val, kwargs):
        cls = self.model_class
        r = model.IngressTrunk
        p = aliased(model.ResourcePrefix)
        q = q.filter(r.resource_id.in_(select([p.resource_id]).where(p.product_id == val)))
        return q

    def on_filter_rate_table_name(self, q, val, kwargs):
        cls = self.model_class
        r = model.IngressTrunk
        p = aliased(model.ResourcePrefix)
        if '*' in val:
            val = val.replace('*', '%')
            q = q.filter(or_(cls.rate_table_name.like(val),
                             r.resource_id.in_(select([p.resource_id]).where(p.rate_table_name.like(val)))))
        else:
            q = q.filter(
                or_(cls.rate_table_name == val,
                    r.resource_id.in_(select([p.resource_id]).where(p.rate_table_name == val))))
        log.debug(model.query_to_sting(q))
        return q

    def on_filter_rate_table_id(self, q, val, kwargs):
        cls = self.model_class
        r = model.IngressTrunk
        p = aliased(model.ResourcePrefix)

        q = q.filter(
            or_(cls.rate_table_id == val, r.resource_id.in_(select([p.resource_id]).where(p.rate_table_id == val)))
        )
        log.debug(model.query_to_sting(q))
        return q

    def on_filter_routing_plan_id(self, q, val, kwargs):
        r = model.IngressTrunk
        p = aliased(model.ResourcePrefix)
        q = q.filter(r.resource_id.in_(select([p.resource_id]).where(p.route_strategy_id == val))
                     )
        log.debug(model.query_to_sting(q))
        return q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceIngressList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['ingress'] = 'true'
        if 'carrier' in ret:
            q = model.Client.filter(model.Client.name == ret['carrier']).first()
            if q:
                ret['client_id'] = str(q.client_id)
            else:
                raise Exception('Invalid carrier name ' + str(ret['carrier']))
            del ret['carrier']
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(ResourceIngressList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # ret = ret.filter(and_(cls.ingress == True, cls.alias != '', cls.client_type.is_(None),
        #                      or_(cls.client_id.is_(None), cls.client_id.in_(self.get_user(self.req).clients_id))))
        ret = ret.filter(and_(cls.ingress == True, cls.purged == False, cls.alias != ''))
        if not self.get_user(self.req).is_admin:
            ret = ret.filter(and_(cls.client_id == model.Client.client_id,
                                  model.Client.user_id_filter(self.get_user(self.req).user_id)))
        log.debug(model.query_to_sting(ret))
        return filt, ret

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        all_fields = self.get_all_fields_from_scheme(self.scheme_class)[0]
        if ordering:
            if ',' in ordering['by']:
                ordl = ordering['by'].split(',')
                dirl = ordering['dir'].split(',')
                if len(ordl) != len(dirl):
                    raise Exception('Multi order_by must contain also all order_dir asc/desc specifications!')
                for ord in ordl:
                    if ord not in all_fields:
                        raise Exception('Order by {} not valid!'.format(ord))
                for dir in dirl:
                    if dir not in ['asc', 'desc']:
                        raise Exception('Wrong order dir {} ! Valid are ["ask","desk"]'.format(ord))
        return ordering, query


class ResourceIngressOrigVendorList(ResourceIngressList):
    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(ResourceIngressList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        ret = ret.filter(and_(or_(cls.client_type.is_(None), cls.client_type == 'vendor'), cls.ingress == True))
        return filt, ret


class IngressTrunkRateSummaryList(DnlList):
    scheme_class = IngressTrunkRateSummaryGetScheme
    model_class = model.ResourcePrefix
    entity_plural = 'Ingress prefixes'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(IngressTrunkRateSummaryList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        clsres = aliased(model.Resource)
        filt, ret = super(IngressTrunkRateSummaryList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        ret = ret.filter(and_(cls.ingress == True, cls.alias != '', cls.client_id == model.Client.client_id,
                              model.Client.user_id_filter(self.get_user(self.req).user_id),
                              cls.resource_id.in_(select([clsres.resource_id]).where(clsres.purged == False))))
        return (filt, ret)


class IngressTrunkRateSummaryUniqueList(DnlList):
    scheme_class = IngressTrunkRateSummaryUniqueGetScheme
    model_class = model.ResourcePrefix
    entity_plural = 'ResourcePrefix'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):
        try:
            parsed_qs = dict(parse_qsl(req.query_string))
            order_dir = parsed_qs.get('order_dir', 'asc')
            order_by = parsed_qs.get('order_by', 'resource_id')
            cls = self.model_class
            query = cls.session().query(
                cls.resource_id.distinct().label('trunk_id'),
                cls.carrier_id,
                cls.carrier_name,
                cls.trunk_name,
                cls.prefix,
                cls.trunk_type2
            )
            if 'carrier_name' in parsed_qs:
                query = query.filter(cls.carrier_name == parsed_qs['carrier_name'])
            if 'trunk_name' in parsed_qs:
                query = query.filter(cls.trunk_name == parsed_qs['trunk_name'])
            if 'trunk_type2' in parsed_qs:
                query = query.filter(cls.trunk_type2 == parsed_qs['trunk_type2'])
            if 'prefix' in parsed_qs:
                query = query.filter(cls.prefix == parsed_qs['prefix'])
            if 'is_active' in parsed_qs:
                query = query.filter(cls.is_active == True)

            if order_by:
                if order_dir == 'desc':
                    query = query.order_by(getattr(cls, order_by).desc())
                else:
                    query = query.order_by(getattr(cls, order_by))

            ret = [i for i in query]
            per_page = int(parsed_qs.get('per_page', len(ret)))
            page = int(parsed_qs.get('page', 0))

            self.set_response(resp, responses.SuccessResponse(data={
                'items': ret[page * per_page:(page + 1) * per_page],
                'total': len(ret), 'page': page,
                'per_page': per_page
            }, scheme=schemes.ObjectScheme))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


# ----- Resource

# --------------Product???StaticRoute???
class ProductCreate(DnlCreate):
    scheme_class = ProductScheme
    entity = 'Static Route'  # 'Product'
    unique_field = 'static_route_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        if 'defined_by' in req.data and req.data['defined_by'] != 'Code Name':
            req.data.pop('code_deck_id', None)
        return super().on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        return obj


class ProductResource(DnlResource):
    model_class = model.Product
    scheme_class = ProductScheme
    scheme_class_get = ProductGetScheme
    scheme_class_modify = ProductModifyScheme
    entity = 'Static Route'  # 'Product'
    id_field = 'static_route_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def _before_update(self, obj, req):
        # if req.data['name']!=obj.name:
        #    _valid('Product', 'name', value)
        req.data['defined_by'] = obj.defined_by
        sch = self.scheme_class_modify()
        sch.check_code_deck(req.data)
        return obj


class ProductList(DnlList):
    scheme_class = ProductGetScheme
    model_class = model.Product
    entity_plural = 'Static Routes'  # 'Products'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec(self):
        sfields_names, search_fields_list = self.get_fields_from_scheme(self.scheme_class)
        qfields_names, query_fields_list = self.get_query_fields_from_scheme(self.scheme_class)
        fields_names = list(set(sfields_names + qfields_names))
        return swagger.specify.get_spec(
            method='get', description='Gets {}'.format(self.entity_plural.lower()),
            path_parameters=self.path_parameters,
            query_parameters=[
                                 {'name': 'fields', 'type': 'string'},
                                 {'name': 'page', 'type': 'integer'}, {'name': 'per_page', 'type': 'integer'},
                                 {'name': 'order_by', 'enum': fields_names + ['prefix_count', 'route_count']},
                                 {'name': 'order_dir', 'enum': ['asc', 'desc']}
                             ] + search_fields_list + query_fields_list,
            responses=(
                          responses.SuccessResponseObjectsList(payload_scheme_items=self.scheme_class),
                          responses.AttributeNotExitsErrorResponse()
                      ) + self.get_additional_responses(method='get'),
            security=self.get_security(method='get')
        )

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        tr_id = filtering.pop('has_trunk_id', None)
        filt, query = super(ProductList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        query = query.filter(cls.name != 'ORIGINATION_STATIC_ROUTE')
        pi = model.ProductItems
        if tr_id:
            query = query.filter(model.Product.product_id.in_(
                select([pi.product_id]).where(and_(pi.item_id == model.ProductItemsResource.item_id, \
                                                   model.ProductItemsResource.resource_id == tr_id))))

        return (filt, query)

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        model_class = self.model_class
        if 'by' in ordering and ordering['by'] == 'route_count':
            if ordering['dir'] == 'desc':
                query = query.outerjoin(model.Route).group_by(model_class.product_id).order_by(
                    func.count(model.Route.static_route_id).desc())
            else:
                query = query.outerjoin(model.Route).group_by(model_class.product_id).order_by(
                    func.count(model.Route.static_route_id))
            ordering = {}
        if 'by' in ordering and ordering['by'] == 'prefix_count':
            if ordering['dir'] == 'desc':
                query = query.outerjoin(model.ProductItems).group_by(model_class.product_id).order_by(
                    func.count(model.ProductItems.product_id).desc())
            else:
                query = query.outerjoin(model.ProductItems).group_by(model_class.product_id).order_by(
                    func.count(model.ProductItems.product_id))
            ordering = {}
        if 'by' in ordering and ordering['by'] == 'code_deck_name':
            if ordering['dir'] == 'desc':
                query = query.outerjoin(model.CodeDeck).order_by(model.CodeDeck.name)
            else:
                query = query.outerjoin(model.CodeDeck).order_by(model.CodeDeck.name.desc())
            ordering = {}
        return ordering, query


# ------ Product ------

# --------------ProductIProductItems
class ProductItemsCreate(DnlCreate):
    scheme_class = ProductItemsScheme
    entity = 'StaticRouteItem'  # 'ProductItems'
    unique_field = 'item_id'
    additional_responses = ()
    path_parameters = ({'name': 'static_route_id', 'description': 'Parent id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.product_id = kwargs['static_route_id']
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        if 'digits' in self.req_data:
            self.req_data['digits'] = self.req_data['digits'].strip()
        if obj.digits:
            obj.digits = obj.digits.strip()
        # if 'trunks' in self.req_data:
        #    for t in self.req_data['trunks']:
        #        obj.trunks.append(model.ProductItemsResource(**t))
        #    del self.req_data['trunks']
        if 'digits' in self.req_data and ',' in self.req_data['digits']:
            digits = self.req_data['digits'].split(',')
            obj.digits = digits[0]
            for d in digits[1:]:
                item = obj.copy()
                item.digits = d
                for tr in obj.trunks:
                    item.trunks.append(model.ProductItemsResource(trunk_id=tr.trunk_id))
                if obj.product_id == 1:
                    old = model.ProductItems.filter(and_(model.ProductItems.digits == d,
                                                         model.ProductItems.product_id == 1)).first()
                    if old:
                        raise Exception('Digit {} already exists with product_id 1'.format(d))
                obj.session().add(item)
        return obj


class ProductItemsCopy(DnlCreate):
    scheme_class = ProductItemsCopyScheme
    entity = 'StaticRouteItem'  # 'ProductItems'
    unique_field = 'item_id'
    additional_responses = ()
    path_parameters = ({'name': 'item_id', 'description': 'Item id to copy'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, item_id, **kwargs):
        old = model.ProductItems.get(item_id)
        if not old:
            raise NoResultFound()
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.product_id = old.product_id
        obj.strategy = old.strategy
        obj.time_profile_id = old.time_profile_id
        obj.min_len = old.min_len
        obj.max_len = old.max_len
        obj.min_asr = old.max_len
        obj.max_asr = old.max_asr
        obj.min_abr = old.min_abr
        obj.max_abr = old.max_abr
        obj.min_acd = old.min_acd
        obj.max_acd = old.max_acd
        obj.min_pdd = old.min_pdd
        obj.max_pdd = old.max_pdd
        obj.min_aloc = old.min_aloc
        obj.max_aloc = old.max_aloc
        obj.digits = obj.code_name
        for r in old.trunks:
            obj.trunks.append(model.ProductItemsResource(resource_id=r.resource_id,
                                                         by_percentage=r.by_percentage,
                                                         order_id=r.order_id,
                                                         order_type=r.order_type
                                                         ))
        return obj


class ProductItemsManyResource(DnlResource):
    model_class = model.ProductItems
    scheme_class = ProductItemsScheme
    scheme_class_get = ProductItemsGetScheme
    scheme_class_modify = ProductItemsModifyScheme
    entity = 'StaticRouteItem'  # 'ProductItem'
    id_field = 'item_id'
    has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = True
    has_modify_operation = False
    has_info_operation = False

    def get_path_parameters(self):
        return ({'name': 'item_id', 'description': 'item_id', 'type': 'string'},)

    def on_delete(self, req, resp, **kwargs):
        if not check_permission(self, req, 'modify'):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            ret = []
            for id in kwargs['item_id'].split(','):
                skwargs = kwargs
                skwargs['item_id'] = id
                delete = ProductItemsResource()
                delete.on_delete(req, resp, **skwargs)
                if resp.status != falcon.HTTP_200:
                    return
            resp.data = {'success': True}
            self.set_response(resp, responses.SuccessResponseJustOk())
            return True
        except Exception as e:
            self.set_response(resp, responses.OperationErrorResponse(e))
            return True


class ProductItemsResource(DnlResource):
    model_class = model.ProductItems
    scheme_class = ProductItemsScheme
    scheme_class_get = ProductItemsGetScheme
    scheme_class_modify = ProductItemsModifyScheme
    entity = 'StaticRouteItem'  # 'ProductItem'
    id_field = 'item_id'
    has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        # trunks=model.ProductItemsResource.filter(model.ProductItems.item_id==obj.item_id).all()
        for t in obj.trunks:
            t.delete()
        if 'digits' in self.req_data:
            self.req_data['digits'] = self.req_data['digits'].strip()
        if 'digits' in self.req_data and ',' in self.req_data['digits']:
            digits = self.req_data['digits'].split(',')
            obj.digits = digits[0]
            for d in digits[1:]:
                item = self.scheme_class_modify().load(self.req_data).data
                item.digits = d
                item.product_id = obj.product_id
                item.update_by = self.get_user().name
                item.update_at = datetime.now(UTC)
                # if 'trunks' in self.req_data:
                #     for tr in self.req_data['trunks']:
                #         item.trunks.append(model.ProductItemsResource(trunk_id=tr['trunk_id']))
                # obj.session().add(item)
                item.save()
            self.req_data['digits'] = obj.digits
        if 'trunks' in self.req_data:
            for tr in self.req_data['trunks']:
                pir = model.ProductItemsResource(**tr)
                pir.item_id = obj.item_id
                obj.trunks.append(pir)
            del self.req_data['trunks']
        obj.update_at = datetime.now(UTC)

        return obj
        """
        for t in self.req_data['trunks']:
            t['item_id']=obj.item_id
            obj.trunks.append(model.ProductItemsResource(**t))
        if 'trunks' in self.req_data:
            del self.req_data['trunks']
        trunks.session.commit()
        return obj
        """


class ProductItemsAllList(DnlList):
    scheme_class = ProductItemsGetScheme
    model_class = model.ProductItems
    entity_plural = 'StaticRouteItems'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        tr_id = filtering.pop('has_trunk_id', None)
        filt, query = super(ProductItemsAllList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        if tr_id:
            query = query.outerjoin(model.ProductItemsResource,
                                    model.ProductItems.item_id == model.ProductItemsResource.item_id). \
                filter(model.ProductItemsResource.resource_id == tr_id)

        return (filt, query)

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super().modify_query_from_ordering_for_list(ordering, query, **kwargs)
        cls = self.model_class
        if ordering and 'by' in ordering:
            if ordering['by'] == 'code_name':
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    query = query.order_by(func.length(cls.code_name)).order_by(cls.code_name)
                else:
                    query = query.order_by(func.length(cls.code_name).desc()).order_by(cls.code_name.desc())
        return ordering, query


class ProductItemsList(ProductItemsAllList):
    path_parameters = ({'name': 'static_route_id', 'description': 'Parent id'},)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ProductItemsList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['product_id'] = kwargs['static_route_id']
        return ret


# ------ Product ------


# carrier_group

# --------------Code

class CodeCreate(DnlCreate):
    scheme_class = CodeAllScheme
    entity = 'Code'
    unique_field = 'code_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    import_key_fields = ('code', 'code_deck_id')

    def before_create(self, obj, **kwargs):
        cls = model.Code
        if cls.filter(
                and_(cls.code == self.req_data['code'], cls.code_deck_id == self.req_data['code_deck_id'])).first():
            raise ValidationError({'code': ['duplicate code']})
        return obj


class CodeResource(DnlResource):
    model_class = model.Code
    scheme_class = CodeAllScheme
    scheme_class_get = CodeAllGetScheme
    scheme_class_modify = CodeAllScheme
    entity = 'Code'
    id_field = 'code_id'
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        cls = model.Code
        if cls.filter(and_(cls.code == self.req_data['code'], cls.code_deck_id == self.req_data['code_deck_id'],
                           cls.code_id != obj.code_id)).first():
            raise ValidationError({'code': ['duplicate code']})
        return obj


class CodeList(DnlList):
    scheme_class = CodeAllGetScheme
    model_class = model.Code
    entity_plural = 'Codes'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(CodeList, self).modify_query_from_ordering_for_list(ordering, query, **kwargs)
        cls = self.model_class
        if ordering and 'by' in ordering:
            if ordering['by'] == 'code':
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    query = query.order_by(func.length(cls.code)).order_by(cls.code)
                else:
                    query = query.order_by(func.length(cls.code).desc()).order_by(cls.code.desc())
        return ordering, query

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(CodeList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


class CodeUniqueList(DnlList):
    scheme_class = CodeAllGetScheme
    model_class = model.Code
    entity_plural = 'Codes'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):
        try:
            parsed_qs = dict(parse_qsl(req.query_string))
            order_dir = parsed_qs.get('order_dir', 'asc')
            order_by = parsed_qs.get('order_by', 'country')
            code_deck_id = parsed_qs.get('code_deck_id', None)
            cls = self.model_class
            query = cls.session().query(
                cls.name.distinct().label('name'),
            )
            if code_deck_id:
                query = query.filter(cls.code_deck_id == code_deck_id)
            if 'country' in parsed_qs:
                query = query.filter(cls.country == parsed_qs['country'])
            if order_by == 'name':
                if order_dir == 'desc':
                    query = query.order_by(cls.name.desc())
                else:
                    query = query.order_by(cls.name)
            try:
                per_page = int(dict(parse_qsl(req.query_string)).get('per_page'))
                log.debug("PER_PAGE TRIES SUCCESSFULLY - {}".format(per_page))
            except (ValueError, TypeError):
                per_page = conf.get_default_items_per_page()
                log.debug("PER_PAGE TRIES, but got an error - {}".format(per_page))
            try:
                page = int(dict(parse_qsl(req.query_string)).get('page'))
                log.debug("PER_PAGE TRIES SUCCESSFULLY - {}".format(per_page))
            except (ValueError, TypeError):
                page = 0
                log.debug("PER_PAGE TRIES, but got an error - {}".format(page))

            ret = [i for i in query]
            total = len(ret)
            start_idx = page * per_page
            end_idx = (page + 1) * per_page
            if start_idx < len(ret):
                ret = ret[start_idx:end_idx]
            else:
                ret = []
            self.set_response(resp, responses.SuccessResponse(data={
                'items': ret,
                'total': total, 'page': page,
                'per_page': per_page
            }, scheme=schemes.ObjectScheme))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(CodeUniqueList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


# --------------Code

# --------------CodeCountry

class CodeCountryCreate(DnlCreate):
    scheme_class = CodeCountryScheme
    entity = 'CodeCountry'
    unique_field = 'country_code'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        return obj


class CodeCountryResource(DnlResource):
    model_class = model.CodeCountry
    scheme_class = CodeCountryScheme
    scheme_class_get = CodeCountryScheme
    scheme_class_modify = CodeCountryScheme
    entity = 'CodeCountry'
    id_field = 'country_code'
    has_update_by = False
    unique_field = 'country'
    security = (DEFAULT_SECURITY)
    restrict = ()


class CodeCountryList(DnlList):
    scheme_class = CodeCountryScheme
    model_class = model.CodeCountry
    entity_plural = 'CodeCountrys'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    no_auth_needed = True

    def on_filter_country(self, q, val, kwargs):
        cls = self.model_class
        if '*' in val:  # pragma: no cover
            q = q.filter(func.upper(cls.country).like(val.upper().replace('*', '%')))
        else:
            q = q.filter(func.upper(cls.country) == val.upper())
        return q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(CodeCountryList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


# --------------CodeCountry

# ---- CodeDestination
class CodeDestinationList(DnlList):
    scheme_class = CodeDestinationGetScheme
    model_class = model.CodeDestination
    entity_plural = 'CodeDestinations'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    no_auth_needed = True

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(CodeDestinationList, self).modify_query_from_ordering_for_list(ordering, query,
                                                                                               **kwargs)
        cls = model.Code
        all_fields = self.get_all_fields_from_scheme(self.scheme_class)[0]
        if ordering:
            if ',' in ordering['by']:
                ordl = ordering['by'].split(',')
                dirl = ordering['dir'].split(',')
                for key, dir in zip(ordl, dirl):
                    query = query.order_by(getattr(cls, key)) if dir == 'asc' else query.order_by(
                        getattr(cls, key).desc())
            else:
                dir = 'asc' if not 'by' in ordering or ordering['by'] == 'asc' else 'desc'
                key = ordering['by']
                query = query.order_by(getattr(cls, key)) if dir == 'asc' else query.order_by(getattr(cls, key).desc())
        return {}, query

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, qs = super(CodeDestinationList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = model.Code
        if filt:
            if 'destination' in filt:
                filt['name'] = filt['destination']
                del filt['destination']
            for k, v in filt.items():
                if '*' in v:  # pragma: no cover
                    qs = qs.filter(getattr(cls, k).like(v.replace('*', '%')))
                else:
                    qs = qs.filter(getattr(cls, k) == v)
        return {}, qs


# --- CodeDestination

# --------------CodeDeck
class CodeDeckCreate(DnlCreate):
    scheme_class = CodeDeckScheme
    entity = 'CodeDeck'
    unique_field = 'code_deck_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        cl_id = model.CodeDeck.query().session.query(
            func.max(model.CodeDeck.code_deck_id).label('client_id')).one().client_id
        obj.client_id = cl_id + 1 if cl_id else 1
        return obj


class CodeDeckResource(DnlResource):
    model_class = model.CodeDeck
    scheme_class = CodeDeckScheme
    scheme_class_get = CodeDeckGetScheme
    scheme_class_modify = CodeDeckScheme
    entity = 'CodeDeck'
    id_field = 'code_deck_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.client_id = obj.code_deck_id
        self.req_data['client_id'] = obj.code_deck_id
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        if 'codes' in self.req_data:
            for t in obj.codes:
                t.delete()
            # obj.query().session.refresh(obj)
            for t in self.req_data['codes']:
                obj.codes.append(model.Code(**t))
        return obj

    def on_delete(self, req, resp, **kwargs):
        # raise Exception(str(kwargs))
        if kwargs['code_deck_id'] in ['0', '1']:
            e = Exception('Do not delete system codes!')
            self.set_response(resp, OperationErrorResponse(e))
            return None
        model.Code.filter(model.Code.code_deck_id == kwargs['code_deck_id']).delete(
                synchronize_session='fetch')
        model.RateTable.filter(model.RateTable.code_deck_id == kwargs['code_deck_id']).update({'code_deck_id': None},
                synchronize_session='fetch')
        return super(CodeDeckResource, self).on_delete(req, resp, **kwargs)


class CodeDeckList(DnlList):
    scheme_class = CodeDeckGetScheme
    model_class = model.CodeDeck
    entity_plural = 'CodeDecks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    large_list_fields = ['code_deck_id', 'name', 'client_id']

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        model_class = self.model_class
        if 'by' in ordering and ordering['by'] == '__usage_count':
            if ordering['dir'] == 'desc':
                query = query.join(model.Code, isouter=True).group_by(model.CodeDeck.code_deck_id).order_by(
                    model.func.count(model.Code.code_id.distinct()).desc())
            else:
                query = query.join(model.Code, isouter=True).group_by(model.CodeDeck.code_deck_id).order_by(
                    model.func.count(model.Code.code_id.distinct()))
            ordering = {}
        return ordering, query


# ------ CodeDeck ------


# --------------RateTable
class RateTableCreate(DnlCreate):
    scheme_class = RateTableScheme
    entity = 'RateTable'
    unique_field = 'rate_table_id'
    additional_responses = ()
    path_parameters = ()
    # no_auth_needed = True
    # security = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        if self.get_user():
            obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        if not 'jurisdiction_country_id' in self.req_data:
            q = model.JurisdictionPrefix.query().order_by(model.JurisdictionPrefix.id).first()
            if q:
                obj.jurisdiction_country_id = q.jurisdiction_country_id
        return obj


class RateTableResource(DnlResource):
    model_class = model.RateTable
    scheme_class = RateTableScheme
    scheme_class_get = RateTableGetScheme
    scheme_class_modify = RateTableScheme
    entity = 'RateTable'
    id_field = 'rate_table_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        obj = super(RateTableResource, self).get_object(resp, model_class, **kwargs)
        if 'client_id' in kwargs and obj:
            client_id = kwargs['client_id']
            ref = model.ProductClientsRefUsed
            ref.update_used(client_id)
            ref.session().commit()
            product_ids = [i.product_id for i in ref.filter(ref.client_id == client_id).all()]
            product_rate_table_ids = [
                int(i.rate_table_id) for i in
                model.ProductRoutRateTable.filter(model.ProductRoutRateTable.id.in_(product_ids)).all()
            ]
            client_product_rate_table_ids = []
            for cliend_did_product in model.ClientDidProduct.filter(
                    model.ClientDidProduct.client_id == client_id).all():
                client_product_rate_table_ids += cliend_did_product.rate_table_ids
            if int(obj.rate_table_id) not in product_rate_table_ids + client_product_rate_table_ids:
                raise ValidationError({'message': 'permission revoked'})
        return obj

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        if not 'jurisdiction_country_id' in req.data:
            q = model.JurisdictionPrefix.query().order_by(model.JurisdictionPrefix.id).first()
            if q:
                obj.jurisdiction_country_id = q.jurisdiction_country_id
        return obj

    def on_delete(self, req, resp, **kwargs):
        cls = self.model_class
        rt = model.ResourceTemplate
        q = cls.filter(cls.rate_table_id == kwargs['rate_table_id']).first()
        q1 = rt.filter(rt.rate_table_id == kwargs['rate_table_id'])
        if q:
            sql = text_("delete from rate where rate_table_id={};".format(kwargs['rate_table_id']))
            cls.session().execute(sql)
            cls.session().commit()
            q.delete()
            q1.delete(synchronize_session='fetch')
            self.set_response(resp, responses.SuccessResponseJustOk())
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())


class RateTableList(DnlList):
    scheme_class = RateTableGetScheme
    model_class = model.RateTable
    entity_plural = 'RateTables'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    large_list_fields = ['rate_table_id', 'name', 'rate_type_name', 'billing_method', 'code_deck_name']

    def on_filter_billing_method(self, q, val, kwargs):
        cls = self.model_class
        for value in val.split(','):
            if not value in cls.RATE_TYPE_DICT.values():
                raise ValidationError(
                    {'billing_method': ['valid values only {}'.format(list(cls.RATE_TYPE_DICT.values()))]})
        q = q.filter(cls.rate_type.in_(value.split(',')))
        log.debug(model.query_to_sting(q))
        return q

    def on_filter_code_count_gt(self, q, val, kwargs):
        cls = self.model_class
        q = q.filter(cls.code_count >= int(val))
        log.debug(model.query_to_sting(q))
        return q

    def on_filter_usage_count_gt(self, q, val, kwargs):
        cls = self.model_class
        q = q.filter(cls.usage_count >= int(val))
        log.debug(model.query_to_sting(q))
        return q

    def on_filter_has_billing_rule(self, q, val, kwargs):
        cls = self.model_class
        orig_ids = model.DidBillingPlan.session().query(
            select([model.DidBillingPlan.rate_table_id]).group_by(model.DidBillingPlan.rate_table_id).alias(
                'orig_ids')).all()
        if val in ('true', 'True', True):
            q = q.filter(cls.rate_table_id.in_(orig_ids))
        else:
            q = q.filter(cls.rate_table_id.notin_(orig_ids))

        log.debug(model.query_to_sting(q))
        return q

    def xx_modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        return ordering, query

    def xx_get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RateTableList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super(RateTableList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        # cls_br = model.DidBillingPlan
        # ret = ret.filter(
        #     cls.rate_table_id.notin_(select([cls_br.rate_table_id]).where(cls_br.rate_table_id.isnot(None))))

        return (filt, ret)


class RateSendToClients(resources.CustomAction):
    scheme_class = RateTableScheme
    model_class = model.RateTable
    description = 'Send rates to clients'
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)
    body_parameters = ('Rates to create', RateSendToClientsScheme)
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        clients = req.data.pop('clients')
        if not obj:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return False
        rates = obj.rates
        try:
            from api_dnl.task.send_rate import send_rate_task
            task = send_rate_task.delay(obj.rate_table_id, clients)
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False
        return True


class RateTableCopyTo(DnlCreate):
    scheme_class = RateTableCopyScheme
    entity = 'RateTable copy'
    unique_field = 'rate_table_id'
    additional_responses = ()
    path_parameters = ({'name': 'rate_table_id', 'description': 'Rate table to copy'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        old_obj = model.RateTable.get(kwargs['rate_table_id'])
        if not old_obj:
            raise NoResultFound('Not found {}'.format(kwargs['rate_table_id']))
        # name=obj.name
        f = tuple([c.name for c in inspect(model.RateTable).columns if
                   not '%' in c.name and c.name not in ['name', 'rate_table_id']])

        class Schema(BaseModelScheme):
            class Meta:
                model = model.RateTable
                fields = f

        s = Schema()
        if not getattr(obj, 'name', None):
            raise ValidationError('Name can\'t be empty')
        name = getattr(obj, 'name', None) or old_obj.name
        new_name = name
        if 'Copy' in new_name and (new_name.rsplit('Copy', 1)[-1] == '' or new_name.rsplit('Copy', 1)[-1].isdigit()):
            new_name = new_name.rsplit('Copy', 1)[0]
        i = 0
        while model.RateTable.filter(model.RateTable.name == new_name).first():
            new_name = name + 'Copy' + str(i)
            i += 1
        obj.name = new_name
        s.load(data=s.dump(old_obj).data, instance=obj)
        obj.jur_type = old_obj.jur_type
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        if len(old_obj.rates) < 1000:
            for rate in old_obj.rates:
                make_transient(rate)
                rate.rate_id = None
                rate.create_time = obj.update_at
                obj.rates.append(rate)
        return obj

    def after_create(self, data, req, resp, **kwargs):
        old_obj = model.RateTable.get(kwargs['rate_table_id'])
        if len(old_obj.rates) < 1000:
            return
        obj = model.RateTable.get(data)
        try:
            from api_dnl.tasks import copy_rates_task
            copy_rates_task.delay(old_obj.rate_table_id, obj.rate_table_id)
        except Exception as e:
            log.error('Failed copy rates task! {}'.format(e))
            pass


# ------ RateTable ------


# --------------Rate
class RateCreate(DnlCreate):
    scheme_class = RateScheme
    entity = 'Rate'
    unique_field = 'rate_id'
    additional_responses = ()
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        if 'rate_table_id' in kwargs:
            obj.rate_table_id = kwargs['rate_table_id']
        else:
            log.warning('RateCreate: rate_table_id not provided in kwargs!')
        return obj


class RateResource(DnlResource):
    model_class = model.Rate
    scheme_class = RateScheme
    scheme_class_get = RateGetScheme
    scheme_class_modify = RateModifyScheme
    entity = 'Rate'
    id_field = 'rate_id'
    has_update_by = False
    unique_field = 'code'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        if 'code' in req.data:
            new = req.data['code']
            old = obj.code
            cls = self.model_class
            field = cls.code
            rate_table_id = req.data['rate_table_id'] if 'rate_table_id' in req.data else obj.rate_table_id
            if new != old:
                if cls.filter(
                        and_(field == new, cls.rate_table_id == obj.rate_table_id, cls.end_date.is_(None))).first():
                    raise ValidationError({self.unique_field: ['{} {} is invalid (duplicate)'.format(field.name, new)]})
        return obj


class RateByCodeResource(DnlResource):
    description = 'Rate by rate_table_id and code'
    model_class = model.Rate
    scheme_class = RateScheme
    scheme_class_get = RateGetScheme
    scheme_class_modify = RateModifyScheme
    entity = 'Rate'
    id_field = 'code'
    has_update_by = False
    unique_field = 'rate_id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)

    def on_get(self, req, resp, **kwargs):
        cls = self.model_class
        q = cls.filter(cls.rate_table_id == kwargs['rate_table_id']). \
            filter(cls.code == kwargs['code']).first()
        if q:
            kwargs['rate_id'] = q.rate_id
            super(RateByCodeResource, self).on_get(req, resp, **kwargs)
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())

    def on_patch(self, req, resp, **kwargs):
        cls = self.model_class
        q = cls.filter(cls.rate_table_id == kwargs['rate_table_id']). \
            filter(cls.code == kwargs['code']).first()
        if q:
            kwargs['rate_id'] = q.rate_id
            super(RateByCodeResource, self).on_patch(req, resp, **kwargs)
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())

    def on_delete(self, req, resp, **kwargs):
        cls = self.model_class
        q = cls.filter(cls.rate_table_id == kwargs['rate_table_id']). \
            filter(cls.code == kwargs['code']).first()
        if q:
            kwargs['rate_id'] = q.rate_id
            super(RateByCodeResource, self).on_delete(req, resp, **kwargs)
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())


class RateAllList(DnlList):
    scheme_class = RateGetScheme
    model_class = model.Rate
    entity_plural = 'Rates'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_filter_effective_date(self, q, val, kwargs):
        cls = self.model_class
        q = q.filter(and_(or_(cls.end_date.is_(None), cls.end_date >= val), cls.effective_date <= val))
        log.debug(model.query_to_sting(q))
        return q
    
    def on_filter_code(self, q, val, kwargs):
        search_type = self.req.data.get('search_type', 'Exact Match')
        if search_type == 'Exact_Match':
            pattern = val
        else:
            pattern = '%' + val + '%'
        q = q.filter(cast_(model.Rate.code, _String).like(pattern))
        return q

    def on_filter_change_status(self, q, val, kwargs):
        if val == 'none':
            q = q.filter(model.Rate.change_status.is_(None))
        # raise Exception('test')
        else:
            q = q.filter(model.Rate.change_status == val)
        return q

    def on_filter_is_effective_now(self, q, val, kwargs):
        if val in ('True', 'true'):
            q = q.filter(and_(model.Rate.is_effective_now, model.Rate.effective_date <= func.now(),
                              or_(model.Rate.end_date.is_(None), model.Rate.end_date >= func.now())))
        else:
            q = q.filter(not_(and_(model.Rate.is_effective_now, model.Rate.effective_date <= func.now(),
                                   or_(model.Rate.effective_date.is_(None), model.Rate.end_date >= func.now()))))
        log.debug(model.query_to_sting(q))
        return q


class RateList(RateAllList):
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)

    def on_filter_effective_date(self, q, val, kwargs):
        cls = self.model_class
        d0 = parse_datetime(val[0:10]).replace(tzinfo=UTC)
        d1 = d0 + timedelta(hours=24)
        q = q.filter(and_(cls.effective_date >= d0, or_(cls.effective_date.is_(None), cls.effective_date < d1)))
        log.debug(model.query_to_sting(q))
        return q

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(RateList, self).modify_query_from_ordering_for_list(ordering, query, **kwargs)
        cls = self.model_class
        if ordering and 'by' in ordering:
            if ordering['by'] == 'code':
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    query = query.order_by(func.length(cls.code)).order_by(cls.code)
                else:
                    query = query.order_by(func.length(cls.code).desc()).order_by(cls.code.desc())
        return ordering, query

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RateList, self).get_filtering_for_list(parsed_qs, **kwargs)
        if 'rate_table_id' in kwargs:
            ret['rate_table_id'] = kwargs['rate_table_id']
        if 'rate_table_id' in parsed_qs:
            ret['rate_table_id'] = parsed_qs['rate_table_id']
        if 'client_id' in kwargs:
            client_id = kwargs['client_id']
            ref = model.ProductClientsRefUsed
            ref.update_used(client_id)
            ref.session().commit()
            product_ids = [i.product_id for i in ref.filter(ref.client_id == client_id).all()]
            product_rate_table_ids = [
                int(i.rate_table_id) for i in
                model.ProductRoutRateTable.filter(model.ProductRoutRateTable.id.in_(product_ids)).all()
            ]
            client_product_rate_table_ids = []
            for cliend_did_product in model.ClientDidProduct.filter(
                    model.ClientDidProduct.client_id == client_id).all():
                client_product_rate_table_ids += cliend_did_product.rate_table_ids
            if int(ret['rate_table_id']) not in product_rate_table_ids + client_product_rate_table_ids:
                raise ValidationError({'message': 'permission revoked'})
        return ret


class RateCsvList(DnlList):
    scheme_class = RateGetScheme
    model_class = model.Rate
    entity_plural = 'Rates'
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)
    # security = (DEFAULT_SECURITY)
    restrict = ()
    no_auth_needed = True

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RateCsvList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['rate_table_id'] = kwargs['rate_table_id']
        return ret

    def on_get(self, req, resp, **kwargs):
        # if not check_permission(self, req, 'list'):
        #     self.set_response(
        #         resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
        #     )
        #     return
        try:
            if not req.query_string:
                req.query_string = 'per_page=9223372036854775807'
            objects_list, total, page, per_page, fields = self.get_objects_list(req, self.model_class, **kwargs)
            data = self.scheme_class(only=fields).dump(objects_list, many=True).data

            csvfile = io.StringIO()
            fieldnames = data[0].keys()
            writer = csv.DictWriter(csvfile, fieldnames=fieldnames)
            writer.writeheader()
            writer.writerows(data)
            resp.data = str.encode(csvfile.getvalue())

            resp.content_type = 'text/csv'
            resp.status = falcon.HTTP_200
            """
            self.set_response(
                resp, responses.SuccessResponse(
                    data={
                        'items': self.scheme_class().dump(objects_list, many=True).data,
                        'total': total, 'page': page, 'per_page': per_page
                    },
                    scheme=schemes.ObjectScheme
                )
            )"""
        except AttributeError as e:
            self.set_response(
                resp, responses.AttributeNotExitsErrorResponse(
                    data=ATTRIBUTE_ERROR_RE.search(str(e)).group(1)
                )
            )
        except Exception as e:
            log.error(e)
            # self.set_response(resp, responses.OperationErrorResponse(data=errors.CommonErrors.DataError))
            self.set_response(resp, OperationErrorResponse(e))


class RateCodeNameList(DnlList):
    scheme_class = RateTableCodeNameScheme
    model_class = model.Rate
    entity_plural = 'RateCodeNames'
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):
        try:
            parsed_qs = dict(parse_qsl(req.query_string))
            order_dir = parsed_qs.get('order_dir', 'asc')
            order_by = parsed_qs.get('order_by', 'country')
            cls = self.model_class
            query = cls.session().query(
                cls.code_name.distinct().label('code_name'),
                cls.country,
            ).filter(and_(
                cls.rate_table_id == kwargs['rate_table_id'],
                cls.code_name.isnot(None)
                # cls.country.isnot(None)
            ))
            if 'country' in parsed_qs:
                query = query.filter(cls.country == parsed_qs['country'])
            if 'code_name' in parsed_qs:
                query = query.filter(cls.code_name == parsed_qs['code_name'])
            if order_by == 'code_name':
                if order_dir == 'desc':
                    query = query.order_by(cls.code_name.desc())
                else:
                    query = query.order_by(cls.code_name)
            else:
                if order_dir == 'desc':
                    query = query.order_by(cls.country.desc())
                else:
                    query = query.order_by(cls.country)

            ret = [i for i in query]

            self.set_response(resp, responses.SuccessResponse(data={
                'items': ret,
                'total': len(ret), 'page': 0,
                'per_page': len(ret)
            }, scheme=schemes.ObjectScheme))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


class RateEffectiveDate(CustomGetAction):
    model_class = model.Rate
    description = "Get Effective Date Range"
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)
    allow_methods = ["get"]
    scheme_class = RateTableEffectiveDateScheme
    
    def on_get(self, req, resp, **kwargs):
        try:
            log.debug("Start processing effective date range")
            cls = self.model_class
            rate_table_id = kwargs['rate_table_id']

            # Conditions for max past date and min future date
            past_condition = and_(
                cls.effective_date < func.now(),
                or_(cls.end_date > func.now(), cls.end_date.is_(None))
            )
            future_condition = and_(
                cls.effective_date >= func.now(),
                or_(cls.end_date.is_(None), cls.end_date > cls.effective_date)
            )

            # Subquery to find effective dates per code
            subquery = cls.session().query(
                cls.code,
                func.coalesce(
                    func.max(cls.effective_date).filter(past_condition),
                    func.min(cls.effective_date).filter(future_condition)
                ).label('effective_date')
            ).filter(cls.rate_table_id == rate_table_id).group_by(cls.code).subquery()

            # Final query to get earliest and latest effective dates
            query = cls.session().query(
                func.min(subquery.c.effective_date).label('earliest_effective_date'),
                func.max(subquery.c.effective_date).label('last_effective_date')
            )
            log.debug("Query executed successfully")

            result = query.one_or_none()
            log.debug("Result fetched successfully")

            # Prepare the response with Unix timestamps
            self.set_response(resp, responses.SuccessResponse(data={
                'earliest_effective_date': int(result.earliest_effective_date.timestamp()) if result.earliest_effective_date else None,
                'last_effective_date': int(result.last_effective_date.timestamp()) if result.last_effective_date else None
            }, scheme=schemes.ObjectScheme))
            return True

        except Exception as e:
            log.error(f"Error processing effective dates: {e}")
            self.set_response(resp, OperationErrorResponse(e))
            return None


class RateDownload(DnlList):
    scheme_class = RateDownloadScheme
    model_class = model.Rate
    entity_plural = 'Rates'
    path_parameters = ({'name': 'token', 'description': 'token to download rates'},
                       {'name': 'filename', 'description': 'desired filename'},)
    security = (DEFAULT_SECURITY)
    restrict = ()
    # no_auth_needed = True

    def on_get(self, req, resp, **kwargs):  # pragma: no cover
        import jwt

        if not check_context(self, req, resp, **kwargs):
            self.set_response(resp, responses.ForbiddenErrorResponse())
            return
        try:
            data = jwt.decode(kwargs['token'], settings.JWT_SIGNATURE)
        except jwt.ExpiredSignatureError:
            resp.status = falcon.HTTP_406
            resp.body = '{"error":"link_expired"}'
            return False
        except jwt.InvalidTokenError:
            resp.status = falcon.HTTP_404
            return None
        try:
            rate_table_id = data.get('rate_table_id', None)
            if not rate_table_id:
                resp.status = falcon.HTTP_404
                resp.body = '{"error":"wrong token used"}'
                return False
            # kwargs['rate_table_id'] = str(rate_table_id)
            del kwargs['token']

            parsed_qs = dict(parse_qsl(req.query_string))
            try:
                per_page = int(parsed_qs.get('per_page'))
            except (ValueError, TypeError):
                parsed_qs['rate_table_id'] = rate_table_id
                q = model.Rate.session().query(func.count(model.Rate.rate_id).label('cnt')).filter(
                    model.Rate.rate_table_id == rate_table_id).first()
                if q:
                    parsed_qs['per_page'] = q.cnt
                else:
                    parsed_qs['per_page'] = 1

            filename = kwargs['filename'] if 'filename' in kwargs else 'rate_{}.csv'.format(rate_table_id)

            req.query_string = urlencode(parsed_qs)
            self.req = req
            objects_list, total, page, per_page, fields = self.get_objects_list(req, self.model_class, query_only=True,
                                                                                **kwargs)

            resp_stream = self.csv_resp_stream(objects_list, resp, 0, total)
            resp.append_header('Content-Disposition', 'attachment; filename="{}"'.format(filename))
            resp.content_type = 'text/csv;charset=utf-8'
            resp.stream = resp_stream
            resp.status = falcon.HTTP_PARTIAL_CONTENT
            resp.status = falcon.HTTP_200
            return True

        except Exception as e:
            log.error(e)
            # self.set_response(resp, responses.OperationErrorResponse(data=errors.CommonErrors.DataError))
            self.set_response(resp, OperationErrorResponse(e))


class RateManyCreate(resources.CustomAction):
    scheme_class = RateManyScheme
    model_class = model.RateTable
    description = 'Create multiply rate items in rate table'
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)
    body_parameters = ('Rates to create', RateManyScheme)
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        # raise Exception('req_data='+str(req.data)+' ags='+str(kwargs) )
        # raise Exception('obj='+str(obj))
        result = []
        try:

            for data in req.data['rates']:

                # raise Exception('data='+str(data))
                child, errors = RateScheme().load(data)
                if errors:
                    self.set_response(resp, responses.ValidationErrorResponse(data=errors))
                    return False
                child.rate_table_id = kwargs['rate_table_id']
                try:
                    obj_id = child.save()
                except Exception as e:
                    self.set_response(resp, OperationErrorResponse(e))
                    return False

                # raise Exception('obj='+str(obj_id),'err='+str(errors))
                result.append(obj_id)

            if result:
                self.set_response(
                    resp, responses.SuccessResponse(
                        data={
                            'items': result,
                        },
                        scheme=schemes.ObjectScheme
                    )
                )
                return True
            else:
                self.set_response(
                    resp, responses.SuccessResponseJustOk())
                return True
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


# raise e
# raise NotImplementedError('Ill be back!')


class RateManyResource(resources.CustomPatchAction):
    scheme_class = RateManyScheme
    model_class = model.RateTable
    description = 'Patch multiply rate items in rate table'
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)
    body_parameters = ('Rates to create', RateManyScheme)

    # method = 'patch'
    # allow_methods =['patch']
    # modify_only=False

    def on_path(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        # raise Exception('req_data='+str(req.data)+' ags='+str(kwargs) )
        # raise Exception('obj='+str(obj))
        log.debug(f"DATA = {req.data}")

        def check_duplicates(data):
            d = dict()
            for i in data['rates']:
                k = (i.get('code'), i.get('effective_date'))
                if k in d:
                    # raise ValidationError('can not create rates with same effective date and code {}'.format(k))
                    return k
                else:
                    d[k] = 0
            return None

        k = check_duplicates(req.data)
        if k:
            self.set_response(resp, responses.ValidationErrorResponse(
                data='can not create rates with same code and effective date {}'.format(k)))
            return False

        deleted = []
        result = []
        try:

            ids = [it['rate_id'] for it in req.data['rates'] if 'rate_id' in it]
            q = model.Rate.filter(model.Rate.rate_table_id == kwargs['rate_table_id'])
            if ids:
                q = q.filter(model.Rate.id.notin(ids))
            deleted = q.delete(synchronize_session='fetch')
            model.Rate.session().commit()
            rates = model.Rate.filter(model.Rate.rate_table_id == kwargs['rate_table_id']).all()
            rids = [r.rate_id for r in rates]
            for data in req.data['rates']:
                # raise Exception('data='+str(data))
                child, errors = RateModify2Scheme().load(data)
                if errors:
                    self.set_response(resp, responses.ValidationErrorResponse(data=errors))
                    return False
                child.rate_table_id = kwargs['rate_table_id']
                try:
                    if child.rate_id in rids:
                        pass
                    obj_id = child.save()

                except IntegrityError as e:
                    try:
                        msg = str(e).split('\n')[1].split(':')[1]
                    except:
                        msg = str(e)

                    self.set_response(resp, AlreadyExistsResponse('Rate', msg))
                    return False
                except Exception as e:
                    self.set_response(resp, OperationErrorResponse(e))
                    return False

                # raise Exception('obj='+str(obj_id),'err='+str(errors))
                result.append(obj_id)

            if result:
                self.set_response(
                    resp, responses.SuccessResponse(
                        data={
                            'deleted_items': deleted,
                            'seved_items': result,
                        },
                        scheme=schemes.ObjectScheme
                    )
                )
                return True
            else:
                self.set_response(
                    resp, responses.SuccessResponseJustOk())
                return True
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


# raise e
# raise NotImplementedError('Ill be back!')


# ------ Rate ------


# --- RateMassEditResource ------
class RateMassEditResource(resources.CustomPatchAction):
    scheme_class = RateMassEditScheme
    scheme_class_get = ObjectUpdatedScheme

    model_class = model.RateTable
    description = 'Mass edit for rates in rate table'
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)
    body_parameters = ('Mass edit action', RateMassEditScheme)
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=scheme_class_get),)

    def on_path(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply_delete(self, obj, req, resp, **kwargs):
        ids = [it for it in req.data['rate_id_list']]
        pass

    def apply_field(self, table, data, field):
        if field in ['rate_id_list', 'action_type', 'filter_effective_date']:
            return
        if data['operation'] == 'No Change':
            return
        if data['operation'] == 'set to':
            table[field] = data['value']
        if data['operation'] == 'increase by':
            table[field] = model.Rate.get_field(field).op('+')(data['value'])
        if data['operation'] == 'decrease by':
            table[field] = model.Rate.get_field(field).op('-')(data['value'])
        if data['operation'] == 'multiple by':
            table[field] = model.Rate.get_field(field).op('*')(data['value'])

    def proceed(self, req, resp, **kwargs):
        scheme = self.scheme_class().load(req.data)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False
        deleted = 0
        result = 0
        updated = 0
        old_result = []
        now = datetime.now(UTC)
        cls = model.Rate
        try:
            if 'action_type' not in req.data:
                self.set_response(resp, responses.ValidationErrorResponse(data='action_type missing!'))
                return False
            action = req.data['action_type']
            codes = None

            # Build base query
            if not 'rate_id_list' in req.data or not req.data['rate_id_list']:
                s = select([cls.code.label('code'), func.max(cls.effective_date).label('effective_date')])\
                    .where(cls.rate_table_id == kwargs['rate_table_id'])\
                    .group_by(cls.code)\
                    .alias('subq')

                my_filter = and_(cls.rate_table_id == kwargs['rate_table_id'],
                               cls.effective_date == s.c.effective_date,
                               cls.code == s.c.code)
            else:
                ids = [it for it in req.data['rate_id_list']]
                my_filter = and_(cls.rate_table_id == kwargs['rate_table_id'], cls.rate_id.in_(ids))

            # Handle different action types
            if action == 'update current rates':
                my_filter = and_(my_filter,
                               or_(and_(cls.effective_date <= func.now(),
                                       or_(cls.end_date.is_(None), cls.end_date >= func.now())),
                                  cls.is_effective_now))
            elif action == 'update future rates with specific effective date':
                if 'filter_effective_date' in req.data:
                    # self.set_response(resp, responses.ValidationErrorResponse(data='filter_effective_date missing!'))
                    # return False
                    my_filter = and_(my_filter, cls.effective_date == req.data['filter_effective_date'])
            elif action == 'delete all rates':
                deleted = cls.filter(cls.rate_table_id == kwargs['rate_table_id']).delete(synchronize_session='fetch')
            elif action == 'delete all future rates':
                my_filter = and_(my_filter, cls.effective_date > func.now())
                deleted = cls.filter(my_filter).delete(synchronize_session='fetch')
            elif action == 'delete future rates with specific effective date':
                if 'filter_effective_date' in req.data:
                    # self.set_response(resp, responses.ValidationErrorResponse(data='filter_effective_date missing!'))
                    # return False
                    my_filter = and_(my_filter, cls.effective_date == req.data['filter_effective_date'])
                deleted = cls.filter(my_filter).delete(synchronize_session='fetch')

            rates = cls.filter(my_filter)

            if action == 'delete found rates':
                rate_ids = [r.rate_id for r in rates.all()]
                deleted = cls.filter(cls.rate_id.in_(rate_ids)).delete(synchronize_session='fetch')

            if action == 'insert as new rates':
                if 'effective_date' in req.data and req.data['effective_date']['operation'] == 'set to':
                    effective_date = req.data['effective_date']['value']
                else:
                    effective_date = datetime.now(UTC).date()
                stmt = cls.__table__.insert().from_select(select=select(
                    [text_("nextval('rate_rate_id_seq'::regclass)"),
                     cls.rate_table_id, cls.code, cls.rate, cls.setup_fee,
                     literal(str(effective_date)).label('effective_date'),
                     literal(None).label('end_date'),
                     cls.min_time, cls.grace_time, cls.interval,
                     cls.time_profile_id, cls.seconds, cls.code_name, cls.basic_percentages, cls.gift_percentages,
                     cls.rate_type, cls.inter_rate, cls.intra_rate, cls.country, cls.zone, cls.ocn, cls.lata,
                     literal(str(datetime.now(UTC))).label('create_time'),
                     cls.did_type
                     ]).where(my_filter), names=['rate_id', 'rate_table_id', 'code', 'rate',
                                                'setup_fee', 'effective_date', 'end_date',
                                                'min_time', 'grace_time', 'interval',
                                                'time_profile_id', 'seconds', 'code_name',
                                                'basic_percentages', 'gift_percentages',
                                                'rate_type', 'inter_rate', 'intra_rate', 'country',
                                                'zone', 'ocn', 'lata', 'create_time', 'did_type'])
                inserted = rates.update({'end_date': effective_date}, synchronize_session='fetch')
                cls.session().commit()
                cls.session().connection().execute(stmt)
                rates = cls.filter(
                    and_(cls.rate_table_id == kwargs['rate_table_id'], cls.effective_date == effective_date))

            if action in ('update current rates', 'update all rates', 'insert as new rates', 'update future rates with specific effective date'):
                upd = {}
                for field in req.data:
                    self.apply_field(upd, req.data[field], field)
                if upd:
                    updated = rates.update(upd, synchronize_session='fetch')
                cls.session().commit()
            result = updated + deleted
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False

        if result:
            try:
                edited_by = self.get_user(req).name
            except:
                edited_by = 'no user found'
            l = model.RateMassEditLog(action_time=datetime.utcnow(), action_type=req.data['action_type'],
                                    rate_table_id=kwargs['rate_table_id'], action_rate_rows=result,
                                    edited_by=edited_by)
            l.save()
            self.set_response(resp, responses.SuccessResponseObjectInfo(data={'updated': updated,
                                                                            'deleted': deleted
                                                                            }, payload_scheme=self.scheme_class_get))
            return True
        else:
            self.set_response(resp, responses.SuccessResponseJustOk())
            return True


# --- RateMassEditResource ------


# --- RateTableAssignTrunks ------
class RateTableAssignTrunks(resources.CustomPatchAction):
    scheme_class = RateTableAssignTrunksScheme
    model_class = model.RateTable
    entity = 'RateTableAssignTrunks'
    description = 'Mass assign trunks to rate table'
    path_parameters = ({'name': 'rate_table_id', 'description': 'Parent rate table'},)
    body_parameters = ('Mass edit action', RateTableAssignTrunksScheme)
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=ResourcePrefixGetScheme),)

    def on_path(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        if not obj:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return False
        try:
            cls = model.ResourcePrefix
            """
            scheme_class = self.scheme_class
            scheme = scheme_class().load(req.data, instance=obj, partial=True)
            if scheme.errors:
                self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
                return False
            result = scheme.data.save()
            """
            cls.filter(cls.rate_table_id == obj.rate_table_id).delete(synchronize_session='fetch')
            for d in req.data['trunks']:
                d['rate_table_id'] = obj.rate_table_id
                cls(**d).save()

            object_list = cls.filter(cls.rate_table_id == obj.rate_table_id).all()
            resp_scheme = ResourcePrefixGetScheme()
            data = resp_scheme.dump(object_list, many=True).data
            totl = len(data)
            if data:
                self.set_response(resp, responses.SuccessResponseObjectsList(
                    data=dict(items=data, total=totl, page=0, per_page=totl)))
                return False
            else:
                return True
        except IntegrityError as e:
            try:
                msg = str(e).split('\n')[1].split(':')[1]
            except:
                msg = str(e)
            self.set_response(resp, AlreadyExistsResponse(self.entity, msg))

            return False

        except AlreadyExists as e:
            r = AlreadyExistsResponse(self.entity, str(e))
            r.status_code = 1000
            self.set_response(resp, r)

        except FkConstraintViolation as e:
            self.set_response(resp, responses.FkConstraintViolationResponse(
                data=errors.CommonErrors.get_fk_violation_error(e.table_name, e.column_name, e.value))
                              )
            return False

        except NoResultFound as e:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(data=str(e)))
            return False

        except Exception as e:
            log.error(e)
            self.set_response(resp, OperationErrorResponse(e))
            return False


# --- RateTableAssignTrunks ------


# --------------RateGenerationTemplate
class RateGenerationTemplateCreate(DnlCreate):
    scheme_class = RateGenerationTemplateScheme
    entity = 'RateGenerationTemplate'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.create_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        return obj


class RateGenerationTemplateResource(DnlResource):
    model_class = model.RateGenerationTemplate
    scheme_class = RateGenerationTemplateScheme
    scheme_class_get = RateGenerationTemplateGetScheme
    scheme_class_modify = RateGenerationTemplateScheme
    entity = 'RateGenerationTemplate'
    id_field = 'id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        return obj


class RateGenerationTemplateList(DnlList):
    scheme_class = RateGenerationTemplateGetScheme
    model_class = model.RateGenerationTemplate
    entity_plural = 'RateGenerationTemplates'
    path_parameters = ()

    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_filter_egress_trunks_names_search(self, q, val, kwargs):
        cls = self.model_class
        res = model.Resource
        if '*' in val:
            val.replace('*', '%')
            q = q.filter(and_(res.alias.like(val), res.resource_id.in_(
                select([cast_(func.split_part(func.regexp_split_to_table(cls.egress_str, ';'), ',', 1), Integer)]))))
        else:
            q = q.filter(and_(res.alias == val, res.resource_id.in_(
                select([cast_(func.split_part(func.regexp_split_to_table(cls.egress_str, ';'), ',', 1), Integer)]))))
        return q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RateGenerationTemplateList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


class RateGenerationHistoryCreate(DnlCreate):
    scheme_class = RateGenerationHistoryScheme
    entity = 'RateGeneration start'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'id', 'description': 'RateGeneration template id to start'},)
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_params = ()

    def before_create(self, obj, **kwargs):
        obj.rate_generation_template_id = kwargs['id']
        obj.status = 'initial'
        obj.create_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        return obj


class RateGenerationHistoryList(DnlList):
    scheme_class = RateGenerationHistoryGetScheme
    model_class = model.RateGenerationHistory
    entity_plural = 'RateGenerationHistory log'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RateGenerationHistoryList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


class RateGenerationHistoryDetailList(DnlList):
    scheme_class = RateGenerationHistoryDetailGetScheme
    model_class = model.RateGenerationHistoryDetail
    entity_plural = 'RateGenerationHistoryDetail log'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super().modify_query_from_ordering_for_list(ordering, query, **kwargs)
        ordering['by'] = ordering['by'].replace('email_template', 'email_template_id')
        return ordering, query

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RateGenerationHistoryDetailList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


class RateGenerationRateList(DnlList):
    scheme_class = RateGenerationRateGetScheme
    model_class = model.RateGenerationRate
    entity_plural = 'RateGenerationRate'
    path_parameters = ({'name': 'rate_generation_history_id', 'description': 'RateGeneration history id '},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        search_type = filtering.pop('search_type', None)
        code = filtering.pop('code', None)

        filt, q = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        q = q.filter(self.model_class.rate_generation_history_id == int(kwargs['rate_generation_history_id']))

        if code is not None:
            col = cast_(self.model_class.code, _String)
            if search_type == 'Start With':
                q = q.filter(col.like(f"{code}%"))
            elif search_type == 'Match Any':
                q = q.filter(col.like(f"%{code}%"))
            else:
                q = q.filter(col == str(code))

        return (filt, q)


class RateGenerationHistoryApply(CustomPatchAction):
    scheme_class = RateGenerationApplyRateScheme
    model_class = model.RateGenerationHistory
    entity_plural = 'RateGenerationRateConfirm'
    body_parameters = ('New rate table parameters', RateGenerationApplyRateScheme)
    path_parameters = ({'name': 'id', 'description': 'RateGeneration history id '},)
    # path_parameters = ({'name': 'rate_table_name', 'description': 'Name for generated'},)
    # parameters = ({'name': 'rate_table_name', 'description': 'Name for generated','type':'string'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def apply(self, obj, req, resp, **kwargs):
        # def before_update(self, obj, req):
        rt_id = None
        if 'rate_table_id' in req.data:
            rt_id = req.data['rate_table_id']
        elif 'rate_table_name' in req.data:
            rt_name = req.data['rate_table_id']
        else:
            self.set_response(resp, OperationErrorResponse('rate_table_id not set!'))
            return False
        min_time = req.data.get('min_time', None)
        interval = req.data.get('interval', None)

        if 'action' in req.data:
            action = req.data['action']
        else:
            self.set_response(resp, OperationErrorResponse('action not set!'))
            return False
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        effective_date = req.data.get('effective_date', datetime.now(UTC).date())
        end_date = req.data.get('end_date', None)  # datetime.now(UTC).date())
        email_template_id = req.data.get('email_template_id', None)
        code_deck_id = req.data.get('code_deck_id', None)
        create_by = self.get_user(req).name
        _id = kwargs['id']
        if not obj:
            self.set_response(resp, OperationErrorResponse('Generate does not exist:{}'.format(_id)))
            return False
        rate_count = 0
        try:
            from api_dnl.task.apply_rates import apply_rates_task
            # if not obj.rates or len(obj.rates) == 0:
            rate_count = model.RateGenerationRate.session().query(
                func.count(model.RateGenerationRate.generation_rate_id).label('cnt')).filter(
                model.RateGenerationRate.rate_generation_history_id == _id).first().cnt
            if not rate_count:
                self.set_response(resp, OperationErrorResponse('Generated rates is empty:{}'.format(id)))
                return False
            if rt_id:
                rt = model.RateTable.get(rt_id)
            else:
                rt = model.RateTable.filter(model.RateTable.name == rt_name).first()
            if not rt:
                self.set_response(resp, OperationErrorResponse('Rate Table doesn\'t exist!'))
                # rt = model.RateTable(name=name)
                # rt.save()

            detail = model.RateGenerationHistoryDetail(rate_generation_history_id=_id, create_by=create_by,
                                                       create_on=datetime.now(UTC), end_date_method=action,
                                                       effective_date_new=effective_date,
                                                       end_date=end_date,
                                                       code_deck_id=code_deck_id,
                                                       rate_table_id=rt.rate_table_id,
                                                       email_template_id=email_template_id,
                                                       progress='not started. scheduled apply to rate table {} length {}...'.format(
                                                           rt_id, rate_count))
            object_id = detail.save()

            obj.is_applied = False
            obj.finished_time = None
            obj.progress = 'applying to rate table {} length {}...'.format(rt.name, len(obj.rates))
            obj.save()
            from kombu.exceptions import OperationalError

            if object_id:
                try:
                    apply_rates_task.delay(object_id, min_time, interval)
                except OperationalError as e:
                    msg = 'Celery not works, trying apply rates online {}'.format(str(e))
                    log.error(msg)
                    apply_rates_task(object_id, min_time, interval)

            self.set_response(resp, responses.ObjectCreatedResponse(data=object_id))
            return False

        except Exception as e:
            msg = 'Apply generated Rate {}'.format(str(e))
            log.error(msg)
            self.set_response(resp, OperationErrorResponse(msg))
            return False
        return True

class RateGenerationTemplateWhatIf(DnlResource):
    model_class = model.RateGenerationHistory
    scheme_class = RateGenerationWhatIfScheme
    scheme_class_get = RateGenerationWhatIfScheme
    entity = 'RateGenerationWhatIf'
    path_parameters = ({'name': 'id', 'description': 'Rate generation history ID'},
                        {'name': 'rate_table_id', 'description': 'Rate table ID'})
    security = (DEFAULT_SECURITY)

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        try:
            _id = kwargs.get('id')
            if not _id:
                raise ValueError('id is required')

            rate_table_id = kwargs.get('rate_table_id')
            if not rate_table_id:
                raise ValueError('rate_table_id is required')

            obj = self.model_class.get(_id)
            if not obj:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return False

            # Get current rates
            current_rates = {}
            rate_table = model.RateTable.get(rate_table_id)
            if rate_table:
                # s = select([model.Rate.code.label('code'), func.max(model.Rate.effective_date).label('effective_date')])\
                #     .where(model.Rate.rate_table_id == rate_table.rate_table_id)\
                #     .group_by(model.Rate.code)\
                #     .alias('subq')

                # current_query = model.Rate.filter(and_(
                #     model.Rate.rate_table_id == rate_table.rate_table_id,
                #     model.Rate.effective_date == s.c.effective_date,
                #     model.Rate.code == s.c.code
                # ))

                # for rate in current_query:
                #     current_rates[rate.code] = {
                #         'rate': rate.rate,
                #         'effective_date': rate.effective_date
                #     }

                sql = f"""
                    SELECT code, rate, effective_date
                    FROM (
                        SELECT
                            code,
                            rate,
                            effective_date,
                            ROW_NUMBER() OVER (PARTITION BY code ORDER BY effective_date DESC) AS rn
                        FROM rate
                        WHERE rate_table_id = {rate_table.rate_table_id}
                    ) t
                    WHERE rn = 1
                """

                result = model.get_db().engine.execute(sql)
                current_rates = {
                    row["code"]: {"rate": row["rate"], "effective_date": row["effective_date"]}
                    for row in result
                }

            # Get new rates
            comparison = []
            new_rates = list(model.RateGenerationRate.filter(
                model.RateGenerationRate.rate_generation_history_id == _id
            ))
            # Get code info
            codes = model.Code.filter(
                model.Code.code.in_([nr.code for nr in new_rates])
            ).all()
            code_map = {c.code: (c.name, c.country) for c in codes}
            for new_rate in new_rates:
                current = current_rates.get(new_rate.code, {})
                current_rate = current.get('rate')
                current_effective = current.get('effective_date')

                status = ''
                if current_rate:
                    if new_rate.rate > current_rate:
                        status = 'Increase'
                    elif new_rate.rate < current_rate:
                        status = 'Decrease'
                    else:
                        status = 'No Change'

                code_name, country = code_map.get(new_rate.code, ('', ''))

                comparison.append({
                    'code': new_rate.code,
                    'code_name': code_name,
                    'country': country,
                    'current_rate': current_rate,
                    'current_effective_date': current_effective.isoformat() if current_effective else None,
                    'new_rate': new_rate.rate,
                    'new_effective_date': new_rate.effective_date.isoformat() if new_rate.effective_date else None,
                    'status': status
                })
            
            self.set_response(
                resp, responses.SuccessResponse(
                    data={
                        'items': comparison,
                    },
                    scheme=schemes.ObjectScheme
                )
            )
            return True

        except Exception as e:
            msg = f'Error getting rate comparison: {str(e)}'
            log.error(msg)
            self.set_response(resp, responses.OperationErrorResponse(msg))
            return False


class RateTypeOverrideResource(DnlResource):
    #    no_auth_needed = True
    model_class = model.RateTypeOverride
    scheme_class = RateTypeOverrideScheme
    scheme_class_get = RateTypeOverrideScheme
    scheme_class_modify = RateTypeOverrideScheme
    entity = 'RateTypeOverride'
    id_field = 'id'
    security = (DEFAULT_SECURITY)


class RateTypeOverrideByTrunkResource(DnlResource):
    model_class = model.RateTypeOverride
    scheme_class = RateTypeOverrideByTrunkScheme
    scheme_class_get = RateTypeOverrideByTrunkScheme
    scheme_class_modify = RateTypeOverrideByTrunkModifyScheme
    entity = 'RateTypeOverride'
    # id_field = 'resource_id'
    security = (DEFAULT_SECURITY)
    has_delete_operation = False
    path_parameters = ({'name': 'trunk_id', 'description': 'id of resource'},)

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        try:
            trunk_id = kwargs.get('trunk_id')
            if not trunk_id:
                raise ValueError('trunk_id is required')

            trunk_id = int(trunk_id)
            cls = self.model_class
            query = cls.session().query(
                cls.id,
                cls.src_country,
                cls.dest_country,
                cls.rate_type,
                cls.comment
            ).filter(
                cls.resource_id == trunk_id
            )

            ret = [i for i in query]
            log.debug('Fetched data: %s', ret)
            if not ret:
                query = cls.session().query(
                    cls.id,
                    cls.src_country,
                    cls.dest_country,
                    cls.rate_type,
                    cls.comment
                ).filter()

                ret = [i for i in query]

            # Send the response
            self.set_response(resp, responses.SuccessResponse(data={
                'items': ret,
                'total': len(ret),
                'page': 0,
                'per_page': len(ret)
            }, scheme=schemes.ObjectScheme))

        except Exception as e:
            log.error("Error occurred: %s", e)
            self.set_response(resp, OperationErrorResponse(e))
            return None

    def on_patch(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        try:
            trunk_id = kwargs.get('trunk_id')
            if not trunk_id:
                raise ValueError("trunk_id is required")
            try:
                trunk_id = int(trunk_id)  # Try to convert trunk_id to an integer
            except ValueError:
                raise ValueError(f"Invalid trunk_id: {trunk_id} is not an integer")

            cls = self.model_class
            query = cls.session().query(cls).filter(cls.resource_id == trunk_id)
            if not query.count():
                last_id = cls.session().query(cls).order_by(cls.id.desc()).first().id
                obj = cls(id=last_id+1,resource_id=trunk_id, src_country='', dest_country='', rate_type=1)
                obj.save()
                query = cls.session().query(cls).filter(cls.resource_id == trunk_id)
                # raise ValueError(f"Resource with trunk_id {trunk_id} not found")

            update_data = req.data
            for row in query:
                for key, value in update_data.items():
                    if key == 'id':
                        continue
                    setattr(row, key, value)
            cls.session().commit()
            query = cls.session().query(
                cls.id,
                cls.src_country,
                cls.dest_country,
                cls.rate_type,
                cls.comment
            ).filter()

            # Return a successful response with the modified data
            ret = [i for i in query]
            self.set_response(resp, responses.SuccessResponse(data={
                'items': ret,
                'total': len(ret),
                'page': 0,
                'per_page': len(ret)
            }, scheme=schemes.ObjectScheme))

        except Exception as e:
            log.error("Error occurred: %s", e)
            self.set_response(resp, OperationErrorResponse(e))
            return None


class RateTypeOverrideManyResource(resources.CustomPatchAction):
    model_class = model.RateTypeOverride
    scheme_class = RateTypeOverrideScheme
    scheme_class_get = ObjectUpdatedScheme
    entity = 'RateTypeOverride'
    body_parameters = ('RateTypeOverrideToModify', RateTypeOverrideEditManyScheme)
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    modify_only = True

    def get_spec(self):
        return swagger.specify.get_spec(
            method=self.method, description=self.description,
            path_parameters=self.path_parameters,
            body_parameters=self.body_parameters,
            responses=(
                          responses.SuccessResponseObjectInfo(payload_scheme=self.scheme_class_get),
                          responses.SuccessResponseJustOk(),
                          responses.ObjectNotFoundErrorResponse()
                      ) + self.additional_responses,
            security=self.get_security(method=self.method)
        )

    def on_patch(self, req, resp, **kwargs):
        kwargs['id'] = 1
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        cnt = 0
        try:
            for data in req.data['items']:
                req.data = data
                kwargs[self.id_field] = data[self.id_field]
                obj = self.model_class.get(data[self.id_field])
                if obj:
                    cnt += 1
                    scheme = self.scheme_class().load(data, instance=obj, partial=True)
                    if scheme.errors:
                        self.set_response(resp, responses.ValidationErrorResponse(
                            data={'items:{}'.format(cnt): scheme.errors}))
                        return False
                    self.model_class.session().add(scheme.data)
            if cnt:
                self.model_class.session().commit()
                self.set_response(resp, responses.SuccessResponseObjectInfo(data={'updated': cnt}))
                return False
            else:
                self.set_response(
                    resp, responses.SuccessResponseJustOk())
                return True

        except IntegrityError:
            self.model_class.session().rollback()
            self.set_response(resp, responses.AlreadyExistsResponse(
                data=errors.CommonErrors.get_already_exists_error(self.entity, self.unique_field))
                              )
            return False
        except FkConstraintViolation as e:
            self.set_response(resp, responses.FkConstraintViolationResponse(
                data=errors.CommonErrors.get_fk_violation_error(e.table_name, e.column_name, e.value))
                              )
            return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


class RateTypeOverrideList(DnlList):
    scheme_class = RateTypeOverrideScheme
    model_class = model.RateTypeOverride
    entity_plural = 'RateTypeOverride'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# +++ RateSend
class RateSendCreate(DnlCreate):
    scheme_class = RateSendScheme
    entity = 'RateSend'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.create_time = datetime.now(UTC)
        obj.status = 'waiting'
        if obj.email_template_id:
            if obj.email_direct:
                raise ValidationError('You must set or template or direct send!')
            obj.is_temp = False
        else:
            obj.is_temp = True

        if obj.send_type == 'Send to carriers using this rate table':
            if obj.trunks:
                raise ValidationError({'trunks': 'must be empty when send using this rate table'})
            res_pref = aliased(model.ResourcePrefix)
            res = aliased(model.Resource)
            q = res.query().outerjoin(res_pref).filter(or_(res.rate_table_id == obj.rate_table_id,
                                                           res_pref.rate_table_id == obj.rate_table_id)).group_by(
                res.resource_id).all()
            if len(q) == 0:
                raise ValidationError('No one trunk use rate table {}. Nowhere to send!'.format(obj.rate_table_id))
        if obj.send_type == 'Specify my own recipients':
            if not obj.send_specify_email:
                raise ValidationError('No one email specified. Nowhere to send!'.format(obj.rate_table_id))
        return obj


class RateSendCopyCreate(DnlCreate):
    scheme_class = RateSendCopyScheme
    entity = 'RateSend'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'job_id', 'description': 'Rate send job id to run again'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj = model.RateSendLog.get(kwargs['job_id'])
        if not obj:
            raise NoResultFound()
        if obj.email_direct:
            make_transient(obj.email_direct)
            obj.email_direct.id = None
        make_transient(obj)
        obj.id = None
        if 'download_deadline' in self.req_data:
            obj.download_deadline = self.req_data['download_deadline']
        if 'send_specify_email' in self.req_data:
            obj.send_specify_email = self.req_data['send_specify_email']
        obj.status = 'waiting'
        obj.create_time = datetime.now(UTC)
        return obj


class RateSendLogResultGet(DnlResource):
    #    no_auth_needed = True
    model_class = model.RateSendLogDetail
    scheme_class = RateSendLogDetailGetResultScheme
    scheme_class_get = RateSendLogDetailGetResultScheme
    entity = 'Rate send result'
    id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = (DEFAULT_SECURITY)


class RateSendLogGet(DnlResource):
    #    no_auth_needed = True
    model_class = model.RateSendLogDetail
    scheme_class = RateSendLogDetailGetScheme
    scheme_class_get = RateSendLogDetailGetScheme
    entity = 'Rate send file'
    # id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = DEFAULT_SECURITY
    no_auth_needed = True
    path_parameters = ({'name': 'token', 'description': 'download rate token '},)

    def get_spec_info(self):
        spec = super(RateSendLogGet, self).get_spec_info()
        spec['get']['produces'] = ['text/csv', 'application/vnd.ms-excel', 'application/zip']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')
        try:
            import jwt
            token = kwargs.pop('token', None)
            data = jwt.decode(token, settings.JWT_SIGNATURE)
            kwargs['id'] = data['id']
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj:

                if obj.status not in ['completed', 'Not Yet Downloaded', 'Downloaded']:
                    self.set_response(resp, OperationErrorResponse('Rate send file not ready! {}'.format(obj.status)))
                    return False
                import os
                if not obj.parent_job.file:
                    self.set_response(resp, OperationErrorResponse('Rate send file not generated! '))
                    return False
                file_path = os.path.expanduser(settings.FILES['upload_to']) + '/' + obj.parent_job.file
                file = open(file_path, 'rb')
                if not file:
                    self.set_response(resp, OperationErrorResponse('Rate send file not exists! '))
                    return False
                # file.name = obj.query_key +'.pcap'
                resp.data = file.read()
                if not resp.data:
                    self.set_response(resp, OperationErrorResponse('This rate send file has no data! '))
                    return False
                # check new rate
                cls = self.model_class
                new_rate_sent = cls.filter(and_(cls.resource_id == obj.resource_id,
                                                cls.rate_table_id == obj.rate_table_id,
                                                cls.id > obj.id
                                                )).first()
                if new_rate_sent:
                    self.set_response(resp, responses.OperationErrorResponse(
                        data=responses.errors.Error(407, 'Sorry, the rate download url has expired.  '
                                                         'Please contact support for assistance.', 'expiration error')
                    ))

                try:
                    model.MailSender.apply_mail(obj.parent_job, 'rate_mail_success', obj.parent_job.send_specify_email)
                except Exception as e:
                    log.debug('mail sending error:{}'.format(e))

                obj.status = 'Downloaded'
                obj.download_date = datetime.now(UTC).date()
                trunk = model.Resource.get(obj.resource_id) if obj.resource_id else None
                if trunk and trunk.active == False:
                    log.debug('unsuspending trunk {}'.format(obj.resource_id))
                    obj.error = (obj.error or '') + ' trunk was unblocked by api_dnl daemon'
                    trunk.active = True
                    trunk.save()
                if self.get_user(req):
                    download_username = self.get_user(req).name
                else:
                    download_username = ''
                dl = model.RateDownloadLog(resource_id=obj.resource_id, file_path=file_path,
                                           download_time=datetime.now(UTC),
                                           download_ip=get_request_ip(req), log_detail_id=obj.id,
                                           download_username=download_username)
                obj.download_log.append(dl)
                try:
                    ret = model.MailSender.apply_mail(dl, 'download_rate_notice')
                    if ret:
                        log.error('download_rate_notice {} send mail error {}'.format(str(dl.id), ret))
                except Exception as e:
                    log.debug('error when creating registration: {}'.format(e))
                obj.save()
                fmt = obj.parent_job.file.split('.')[-1]
                import mimetypes
                ctype, enc = mimetypes.guess_type(file_path)
                resp.content_type = ctype
                resp.append_header('Content-Disposition',
                                   'attachment; filename="{}.{}"'.format(obj.rate_table_name, fmt))
                resp.status = falcon.HTTP_200
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


# self.set_response(resp, responses.SuccessResponseObjectInfo(data=data))


class RateSendList(DnlList):
    scheme_class = RateSendGetScheme
    model_class = model.RateSendLog
    entity_plural = 'RateSendLog'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RateSendList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(RateSendList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        return (filt, q)


class RateSendDetailList(DnlList):
    scheme_class = RateSendLogDetailGetScheme
    model_class = model.RateSendLogDetail
    entity_plural = 'RateSendLogDetail'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RateSendDetailList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(RateSendDetailList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        return (filt, q)


# --- RateSend


# --------------TrunkGroup
class TrunkGroupCreate(DnlCreate):
    scheme_class = TrunkGroupScheme
    entity = 'TrunkGroup'
    unique_field = 'group_id'
    additional_responses = ()
    path_parameters = ( )
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        errors = []
        if 'trunk_type' in self.req_data:
            obj.trunk_type = self.req_data['trunk_type']
        if 'all_trunks' in self.req_data:
            for res_id in self.req_data['all_trunks']:
                r = model.Resource.get(res_id)
                if r:
                    if r.trunk_type2 != 'Termination Traffic':
                        errors.append('trunk id {} is not termination trunk'.format(res_id))
                    if obj.trunk_type and r.direction != obj.trunk_type:
                        errors.append('trunk id {} is not {} trunk'.format(res_id, obj.trunk_type))
                else:
                    errors.append('trunk id {} not exists'.format(res_id))
            if errors:
                raise ValidationError(errors)
            obj.all_trunks = self.req_data['all_trunks']

        return obj


class TrunkGroupResource(DnlResource):
    model_class = model.TrunkGroup
    scheme_class = TrunkGroupScheme
    scheme_class_get = TrunkGroupGetScheme
    scheme_class_modify = TrunkGroupModifyScheme
    entity = 'TrunkGroup'
    id_field = 'group_id'
    has_update_by = False
    unique_field = 'group_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_at = datetime.now(UTC)
        if 'trunk_type' in self.req_data:
            obj.trunk_type = req.data['trunk_type']
        # tlist = [{'resource_id':id } for id in req.data['trunks']]
        # req.data['trunks']=tlist
        # return super(TrunkGroupResource,self).before_update(obj,req)
        return obj


class TrunkGroupList(DnlList):
    scheme_class = TrunkGroupGetScheme
    model_class = model.TrunkGroup
    entity_plural = 'TrunkGroups'
    path_parameters = (  )
    security = (DEFAULT_SECURITY)
    restrict = ()


class TrunkGroupAddTrunk(DnlResource):
    model_class = model.TrunkGroup
    scheme_class = TrunkGroupScheme
    scheme_class_get = TrunkGroupGetScheme
    scheme_class_modify = TrunkGroupAddTrunkScheme
    entity = 'TrunkGroup'
    id_field = 'group_id'
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = False

    has_update_by = False
    unique_field = 'group_name'
    # path_parameters=( {'name': 'group_id', 'description': 'Parent group'}, )
    security = (DEFAULT_SECURITY)
    restrict = ()


# ------ TrunkGroup ------

class EgressTrunkFromTemplateCreate(DnlCreate):
    scheme_class = ResourceFromTemplateScheme
    entity = 'EgressTrunk'
    unique_field = 'resource_id'
    additional_responses = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},
                       {'name': 'resource_template_id', 'description': 'Template'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        if not kwargs['client_id']:
            raise ValidationError('missing client_id')
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.create_time = obj.update_at
        obj.client_id = kwargs['client_id']
        obj.alias = obj.name
        obj.create_from_template(obj.name, kwargs['resource_template_id'])
        obj.egress = True
        obj.ingress = False
        return obj


class IngressTrunkFromTemplateCreate(DnlCreate):
    scheme_class = ResourceFromTemplateScheme
    entity = 'IngressTrunk'
    unique_field = 'resource_id'
    additional_responses = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},
                       {'name': 'resource_template_id', 'description': 'Template'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        if not kwargs['client_id']:
            raise ValidationError('missing client_id')
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.create_time = obj.update_at
        obj.client_id = kwargs['client_id']
        obj.alias = obj.name
        obj.create_from_template(obj.name, kwargs['resource_template_id'])
        obj.egress = False
        obj.ingress = True
        return obj


# --------------EgressProfile
class EgressProfileCreate(DnlCreate):
    scheme_class = EgressProfileScheme
    entity = 'EgressProfile'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'resource_id', 'description': 'Parent egress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        _valid('Resource', 'resource_id', kwargs['resource_id'])
        _valid('Resource', 'resource_id', kwargs['resource_id'])
        kwargs['egress_id'] = kwargs['resource_id']
        obj.egress_id = kwargs['resource_id']
        return obj


class EgressProfileResource(DnlResource):
    model_class = model.EgressProfile
    scheme_class = EgressProfileScheme
    scheme_class_get = EgressProfileGetScheme
    # scheme_class_modify = EgressProfileModifyScheme
    entity = 'EgressProfile'
    id_field = 'id'
    has_update_by = False
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        return obj


class EgressProfileList(DnlList):
    scheme_class = EgressProfileGetScheme
    model_class = model.EgressProfile
    entity_plural = 'EgressProfiles'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent egress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(EgressProfileList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['egress_id'] = kwargs['resource_id']
        return ret


# --------------ResourceCapacity
class ResourceCapacityCreate(DnlCreate):
    scheme_class = ResourceCapacityScheme
    entity = 'ResourceCapacity'
    unique_field = ('egress_id', 'ingress_id')
    additional_responses = ()
    path_parameters = ({'name': 'resource_id', 'description': 'Parent egress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        _valid('Resource', 'resource_id', kwargs['resource_id'])
        kwargs['egress_id'] = kwargs['resource_id']
        obj.egress_id = kwargs['resource_id']
        return obj


class ResourceCapacityResource(DnlResource):
    model_class = model.ResourceCapacity
    scheme_class = ResourceCapacityScheme
    scheme_class_get = ResourceCapacityGetScheme
    # scheme_class_modify = ResourceCapacityModifyScheme
    entity = 'ResourceCapacity'
    id_field = ('ingress_id', 'egress_id')
    has_update_by = False
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        if hasattr(self, 'id_field') and self.id_field in kwargs:
            log.debug("hasattr(self, 'id_field') and self.id_field in kwargs")
            id = kwargs[self.id_field]
            log.debug("id - {}".format(id))
            key = getattr(self.model_class, self.id_field)
            log.debug("key - {}".format(key))
            if key.type.python_type == type(0):
                try:
                    _id = int(id)
                except:
                    return None
        obj = model.ResourceCapacity.filter(and_(model.ResourceCapacity.ingress_id == kwargs['ingress_id'],
                                                 model.ResourceCapacity.egress_id == kwargs['egress_id'])).first()
        log.debug("OBJ - {}".format(obj))
        if obj and hasattr(obj, 'name') and obj.name and obj.name[0] == '#':
            return None
        return obj

    def before_update(self, obj, req):
        if 'ingress_id' in req.data and obj.ingress_id != req.data['ingress_id']:
            self._ingress_id = req.data['ingress_id']
            log.debug('before update ingress id old {} new {}'.format(obj.ingress_id, self._ingress_id))

        return obj

    def get_object_data(self, resp, model_class, scheme_class_get, **kwargs):
        if hasattr(self, '_ingress_id'):
            log.debug('before get  old {} new {}'.format(kwargs['ingress_id'], self._ingress_id))
            kwargs['ingress_id'] = self._ingress_id
            delattr(self, '_ingress_id')
        return super(ResourceCapacityResource, self).get_object_data(resp, model_class, scheme_class_get, **kwargs)

    def on_patch(self, req, resp, **kwargs):
        return super(ResourceCapacityResource, self).on_patch(req, resp, **kwargs)


class ResourceCapacityList(DnlList):
    scheme_class = ResourceCapacityGetScheme
    model_class = model.ResourceCapacity
    entity_plural = 'ResourceCapacity items'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent egress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceCapacityList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['egress_id'] = kwargs['resource_id']
        return ret


class ResourceCapacityIngressList(DnlList):
    scheme_class = ResourceCapacityGetScheme
    model_class = model.ResourceCapacity
    entity_plural = 'ResourceCapacity items'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent ingress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super().get_filtering_for_list(parsed_qs, **kwargs)
        ret['ingress_id'] = kwargs['resource_id']
        return ret


# ------- EgressTrunk
class EgressTrunkCreate(DnlCreate):
    scheme_class = EgressTrunkScheme
    entity = 'EgressTrunk'
    unique_field = 'resource_id'
    additional_responses = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        try:
            directions = req.data.pop('prefixes', None)
            if directions:
                directions = [{'digits': direction['tech_prefix'],
                               'direction': 'egress',
                               'action': 'plus prefix',
                               'type': 'modify the called'} for direction in directions if direction['tech_prefix']]
                req.data['directions'] = directions
        except Exception as e:
            log.debug('unable to change directions error: {}'.format(str(e)))
        return super().on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):

        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.create_time = obj.update_at
        obj.egress = True
        obj.ingress = False
        if self.req_data == {}:
            raise ValidationError('missing body parameters! (may be wrong call)')
        if 'name' not in self.req_data and 'trunk_name' not in self.req_data:
            raise ValidationError({'name': ['missing  "name" field!']})

        if not obj.client_id:
            if 'client_id' in kwargs:
                obj.client_id = kwargs['client_id']
                cli = model.Client.get(kwargs['client_id'])
                if not cli:
                    raise NoResultFound('no client_id {} not found!'.format(kwargs['client_id']))
            elif 'carrier_id' in kwargs:
                obj.client_id = kwargs['carrier_id']
            else:
                raise ValidationError('no client_id in path!')

        # obj.name = str(obj.name).strip()
        # obj.alias = obj.name
        if not obj.alias:
            if 'name' in self.req_data:
                obj.alias = str(self.req_data['name']).strip()
            else:
                obj.alias = str(self.req_data['trunk_name']).strip()
        if 'media_type' not in self.req_data:
            obj.media_type = 'Bypass Media'
        if 'profit_type' not in self.req_data:
            obj.profit_type = 'percentage'

        # obj.profit_type='Percentage'
        for reg in obj.reg_user:
            reg.reg_type = 1
        for reg in obj.reg_gateway:
            reg.reg_type = 2

        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        obj = model.Resource.get(object_id)
        if 'pdd' in req.data and req.data['pdd'] is None:
            obj.pdd = None
            obj.save()


class EgressTrunkResource(DnlResource):
    model_class = model.EgressTrunk
    scheme_class = EgressTrunkScheme
    scheme_class_get = EgressTrunkSmallGetScheme
    scheme_class_modify = EgressTrunkScheme
    entity = 'EgressTrunk'
    id_field = 'resource_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):
        if req.data.pop('include_route_info', 0) in (1, '1', 'True', 'true'):
            self.scheme_class_get = EgressTrunkGetScheme
        return super().on_get(req, resp, **kwargs)

    def get_object(self, resp, model_class, **kwargs):
        obj = super(EgressTrunkResource, self).get_object(resp, model_class, **kwargs)
        if obj and obj.egress and not obj.purged:  # and obj.client_type == 'carrier':
            return obj
        self.set_response(resp, responses.ObjectNotFoundErrorResponse(
            data={'message': 'Trunk {} not found!'.format(kwargs['resource_id'])}))
        return None

    def on_patch(self, req, resp, **kwargs):
        try:
            directions = req.data.pop('prefixes', None)
            if directions:
                directions = [{'digits': direction['tech_prefix'],
                               'direction': 'egress',
                               'action': 'plus prefix',
                               'type': 'modify the called'} for direction in directions if direction['tech_prefix']]
                req.data['directions'] = directions
        except Exception as e:
            log.debug('unable to change directions error: {}'.format(str(e)))
        return super().on_patch(req, resp, **kwargs)

    def before_update(self, obj, req):
        # if 'ip' in req.data:  # ???
        #     for ip in req.data['ip']:
        #         dup = model.ResourceIp.filter(model.ResourceIp.ip == ip['ip']).filter(
        #             model.ResourceIp.resource_id != obj.resource_id).first()
        #         if dup:
        #             raise ValidationError('The IP {} is used already in trunk {}'.format(ip, dup.resource_id))
        if 'rate_table_id' in req.data and req.data['rate_table_id']:
            _valid('RateTable', 'rate_table_id', req.data['rate_table_id'])
        if obj.client:
            if obj.client.cps_limit and 'cps_limit' in req.data and req.data['cps_limit'] and int(req.data['cps_limit']) > obj.client.cps_limit:
                raise ValidationError('Resource\'s cps_limit shouldn\'t exceed client\'s cps_limit')
            if obj.client.call_limit and 'call_limit' in req.data and req.data['call_limit'] and int(req.data['call_limit']) > obj.client.call_limit:
                raise ValidationError('Resource\'s call_limit shouldn\'t exceed client\'s call_limit')

        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.store_old_detail()
        # obj.alias = obj.name
        return obj

    def _after_update(self, result, obj, data):
        try:

            if obj.client and obj.client.is_send_trunk_update:# and obj.is_ip_changed:
                ret = model.MailSender.apply_mail(obj, 'trunk_change')
                if ret:
                    log.error('EgressTrunkResource trunk_change send mail error {}'.format(ret))
        except Exception as e:
            log.error('EgressTrunkResource after_update error {}'.format(str(e)))

    def after_update(self, result, obj, data):
        from api_dnl.tasks import apply_mail_task
        try:
            if 'ip' in self.req_data:
                obj.sync_adjacent_ips()
                obj.session().commit()
        except Exception as e:
            if obj.is_ip_changed:
                apply_mail_task(obj.resource_id, 'trunk_change')
            log.error('EgressTrunkResource after_update sync_adjacent_ips error {}'.format(str(e)))
        if obj.client and obj.client.is_send_trunk_update:# and obj.is_ip_changed:
            try:
                apply_mail_task.delay(obj.resource_id, 'trunk_change')
            except Exception as e:
                apply_mail_task(obj.resource_id, 'trunk_change')
                log.error('EgressTrunkResource after_update error {}'.format(str(e)))

    def delete_object(self, req, resp, model_class, **kwargs):
        resource = model.Resource.get(kwargs['resource_id'])
        resource.purged = True
        resource.client_id = None
        resource.group_id = None
        resource.save(save_history=True, user=self.get_user(req), module=getattr(self.__class__, 'api_module', 'N/A'))
        model.ResourceIp.filter(model.ResourceIp.resource_id == kwargs['resource_id']).delete(
            synchronize_session='fetch')
        return True


class EgressTrunkOriginationResource(EgressTrunkResource):
    scheme_class = EgressTrunkScheme
    scheme_class_get = EgressTrunkOriginationGetScheme
    scheme_class_modify = EgressTrunkScheme


class EgressTrunkActionsResource(EgressTrunkResource):
    model_class = model.EgressTrunk
    scheme_class = EgressTrunkActionsScheme
    scheme_class_get = EgressTrunkActionsScheme
    scheme_class_modify = EgressTrunkActionsScheme
    entity = 'EgressTrunkActions'
    has_delete_operation = False

    def after_update(self, result, obj, data):
        pass


class EgressFailOverCreate(DnlCreate):
    scheme_class = ResourceNextRouteRuleModifyScheme
    model_class = model.ResourceNextRouteRule
    entity = 'ResourceNextRouteRule'
    entity_plural = 'ResourceNextRouteRule item'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent egress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        resource = model.EgressTrunk.get(kwargs['resource_id'])
        if not resource or not resource.egress:
            raise NoResultFound('no egress_trunk {} found!'.format(kwargs['resource_id']))
        obj.resource_id = resource.resource_id

        return obj


class EgressFailOverResource(DnlResource):
    scheme_class = ResourceNextRouteRuleScheme
    scheme_class_get = ResourceNextRouteRuleScheme
    scheme_class_modify = ResourceNextRouteRuleModifyScheme
    model_class = model.ResourceNextRouteRule
    entity = 'ResourceNextRouteRule'
    entity_plural = 'ResourceNextRouteRule items'
    path_parameters = ({'name': 'resource_id',
                        'description': 'Parent egress trunk'},)  # ,{'name': 'id', 'description': 'ResourceFailover id to get info abount'}
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(EgressFailOverResource, self).modify_query_from_filtering_for_list(filtering, **kwargs)

        resource = model.EgressTrunk.get(kwargs['resource_id'])
        if not resource or not resource.egress:
            raise NoResultFound('no egress_trunk {} found!'.format(kwargs['resource_id']))

        q.filter(model.ResourceNextRouteRule.resource_id == kwargs['resource_id'])
        return ret, q


class EgressFailOverList(DnlList):
    scheme_class = ResourceNextRouteRuleScheme
    model_class = model.ResourceNextRouteRule
    entity = 'ResourceFailover'
    entity_plural = 'ResourceFailover items'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent egress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(EgressFailOverList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        q = q.filter(model.ResourceNextRouteRule.resource_id == kwargs['resource_id'])
        return ret, q


class EgressTrunkDynRouteResource(EgressTrunkResource):
    scheme_class_modify = EgressTrunkDynRoutesScheme
    scheme_class_get = EgressTrunkDynRoutesGetScheme
    has_delete_operation = False
    has_info_operation = False

    def before_update(self, obj, req):
        for dyn in obj.dynamic_routes:
            dyn.delete()
        #    dyn.resource_id=obj.resource_id
        #    obj.session().add(dyn)
        return obj

    def after_update(self, result, obj, data):
        pass


class EgressTrunkProfilesResource(EgressTrunkResource):
    scheme_class_modify = EgressTrunkProfilesScheme
    scheme_class_get = EgressTrunkProfilesGetScheme
    has_delete_operation = False
    has_info_operation = False


class EgressTrunkStaticRouteItemsResource(EgressTrunkResource):
    scheme_class_modify = EgressTrunkStaticRouteItemsScheme
    scheme_class_get = EgressTrunkStaticRouteItemsGetScheme  # EgressTrunkProfilesGetScheme
    has_delete_operation = False
    has_info_operation = False


class EgressTrunkPassResource(DnlResource):
    model_class = model.EgressTrunk
    scheme_class = EgressTrunkPassScheme
    scheme_class_get = EgressTrunkPassScheme
    scheme_class_modify = EgressTrunkPassScheme
    entity = 'EgressTrunk Pass'
    id_field = 'resource_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = False


# EgressTrunkCreate.before_create = carrier_before_create
class EgressTrunkList(DnlList):
    scheme_class = EgressTrunkGetScheme
    model_class = model.EgressTrunk
    entity_plural = 'EgressTrunks'
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(EgressTrunkList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # ret = ret.filter(and_(cls.client_type.is_(None), cls.client_id.in_(self.get_user(self.req).clients_id)))
        if not 'purged' in filtering:
            ret = ret.filter(cls.purged == False)
        ret = ret.filter(and_(cls.egress == True, cls.alias != '', cls.client_id == model.Client.client_id,
                              model.Client.user_id_filter(self.get_user(self.req).user_id)))
        return filt, ret

    def on_filter_has_ip(self, q, val, kwargs):
        cls = self.model_class
        clsip = aliased(model.ResourceIp)
        q = q.filter(cls.resource_id.in_(select([clsip.resource_id]).where(clsip.ip == val))). \
            filter(cls.auth_type == 'Authorized by Host Only')
        return q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(EgressTrunkList, self).get_filtering_for_list(parsed_qs, **kwargs)
        cli = model.Client.get(kwargs['client_id'])
        if not cli:
            raise NoResultFound('no client_id {} not found!'.format(kwargs['client_id']))
        ret['client_id'] = kwargs['client_id']
        ret['egress'] = 'true'
        return ret


class EgressTrunkResourceAll(DnlResourceAll):
    model_class = model.EgressTrunk
    scheme_class = EgressTrunkActivateScheme
    scheme_class_get = ObjectUpdatedScheme
    entity = 'All EgressTrunks'
    has_update_by = True
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query(self, filt, qs, req, resp, model_class, **kwargs):
        qs = qs.filter(model.EgressTrunk.egress == True)
        return filt, qs


class TrunkAction(resources.CustomPatchAction):
    model_class = model.Resource
    scheme_class = ResourceSimpleScheme
    scheme_class_get = ResourceInfoGetScheme
    scheme_class_modify = ResourceSimpleScheme
    entity = 'Resource'
    id_field = 'resource_id'
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'Trunk to proceed'},)


class TrunkSendInterop(TrunkAction):
    path_parameters = ({'name': 'trunk_id', 'description': 'Trunk to proceed'},)

    def apply(self, obj, req, resp, **kwargs):
        if obj:
            ret = obj.apply_mail('trunk_interop')
            if ret:
                self.set_response(resp, responses.OperationErrorResponse(
                    data=errors.Error(code=43, message=ret[1], reason='mail error')))
                return False
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(data='trunk_id  not found'))
            return False
        return not ret


class EgressTrunkReapplyTemplate(TrunkAction):
    path_parameters = ({'name': 'trunk_id', 'description': 'Trunk to proceed'},
                       {'name': 'template_id', 'description': 'Template'}
                       )

    def apply(self, obj, req, resp, **kwargs):
        template_id = kwargs['template_id']
        tpl = model.ResourceTemplate.filter(and_(model.ResourceTemplate.resource_template_id == template_id,
                                                 model.ResourceTemplate.direction == 'egress')).first()
        if not tpl:
            self.set_response(resp, responses.ValidationErrorResponse(data='template_id not found'))
            return False
        if not obj.egress:
            self.set_response(resp, responses.ValidationErrorResponse(data='This is no EGRESS trunk'))
            return False
        try:
            obj.create_from_template(obj.name, template_id)
            obj.save(save_history=True, user=self.get_user(req), module=getattr(self.__class__, 'api_module', 'N/A'))
        except Exception as e:
            self.set_response(resp, responses.OperationErrorResponse(data=e))
            return False
        return True


class IngressTrunkReapplyTemplate(TrunkAction):
    path_parameters = ({'name': 'trunk_id', 'description': 'Trunk to proceed'},
                       {'name': 'template_id', 'description': 'Template'}
                       )

    def apply(self, obj, req, resp, **kwargs):
        template_id = kwargs['template_id']
        tpl = model.ResourceTemplate.filter(and_(model.ResourceTemplate.resource_template_id == template_id,
                                                 model.ResourceTemplate.direction == 'ingress')).first()
        if not tpl:
            self.set_response(resp, responses.ValidationErrorResponse(data='template_id not found'))
            return False
        if not obj.ingress:
            self.set_response(resp, responses.ValidationErrorResponse(data='This is no INGRESS trunk'))
            return False
        try:
            obj.create_from_template(obj.name, template_id)
            obj.save(save_history=True, user=self.get_user(req), module=getattr(self.__class__, 'api_module', 'N/A'))
        except Exception as e:
            self.set_response(resp, responses.OperationErrorResponse(data=e))
            return False
        return True


class TrunkAssignProduct(DnlResource):
    model_class = model.Resource
    has_delete_operation = False
    has_info_operation = False
    entity = 'Trunk'
    scheme_class = ResourceWithIpsScheme
    scheme_class_get = IngressTrunkGetScheme  # ResourceWithIpsGetScheme
    # body_parameters = ('Ip list for trunk' , ResourceWithIpsScheme )
    path_parameters = ({'name': 'trunk_id', 'description': 'Trunk to proceed'},
                       {'name': 'product_id', 'description': 'Product to assign'},)

    def on_patch(self, req, resp, **kwargs):
        try:
            # kwargs['resource_id']=kwargs['trunk_id']
            req.data['product_id'] = kwargs['product_id']
            _valid('ProductRoutRateTable', 'id', kwargs['product_id'])
            # model.MailSender.apply_mail(obj, 'trunk_change')
            prod = model.ProductRoutRateTable.get(kwargs['product_id'])
            del kwargs['product_id']
            _valid('RateTable', 'rate_table_id', prod.rate_table_id)
            _valid('RouteStrategy', 'route_strategy_id', prod.rout_id)
            req.data['rate_table_id'] = prod.rate_table_id
            req.data['route_strategy_id'] = prod.rout_id

            return super(TrunkAssignProduct, self).on_patch(req, resp, **kwargs)
        # return self.proceed(req, resp, **kwargs)
        except schemes.validate.ValidationError as e:
            self.set_response(resp, responses.ValidationErrorResponse(data=e.messages))

    def before_update(self, obj, req):
        # obj.rate_table_id = req.data['rate_table_id']
        # obj.route_strategy_id = req.data['route_strategy_id']
        # obj.product_id=req.data['product_id']
        prod = model.ProductRoutRateTable.get(req.data['product_id'])
        pref = model.ResourcePrefix(resource_id=obj.resource_id, tech_prefix=prod.prefix,
                                    rate_table_id=req.data['rate_table_id'],
                                    route_strategy_id=req.data['route_strategy_id'], product_id=req.data['product_id'])
        # obj.prefixes.append(pref)
        # prod.trunks.append(pref)
        pref.save()
        obj.store_old_detail()
        return obj

    def after_update(self, result, obj, data):
        try:
            if obj.client and obj.client.is_send_trunk_update:# and obj.is_ip_changed:
                ret = model.MailSender.apply_mail(obj, 'trunk_change')
                if ret:
                    log.error('EgressTrunkResource trunk_change send mail error {}'.format(ret))
        except Exception as e:
            log.error('EgressTrunkResource after_update error {}'.format(str(e)))


class OcnBlocklistList(DnlList):
    scheme_class = OcnBlocklistGetMainScheme
    model_class = model.OcnBlocklist
    entity_plural = 'Ocn Blocklist'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        with_res_id = filtering.pop('with_res_id', None)
        filt, query = super(OcnBlocklistList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        if with_res_id is not None:
            if str(with_res_id).lower() == 'true':
                query = query.filter(self.model_class.res_id.isnot(None))
            elif str(with_res_id).lower() == 'false':
                query = query.filter(self.model_class.res_id.is_(None))

        return filt, query

class OcnBlocklist(DnlResource):
    model_class = model.OcnBlocklist
    scheme_class = OcnBlocklistGetMainScheme
    scheme_class_get = OcnBlocklistGetMainScheme
    entity = 'OcnBlocklist'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_modify_operation = False

class OcnBlocklistPost(DnlCreate):
    scheme_class = OcnBlocklistMainScheme
    entity = 'OcnBlocklist'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        q = model.get_db().session.query(model.OcnBlocklist).filter_by(
            res_id=obj.res_id, ocn=obj.ocn
        ).first()

        if q:
            raise AlreadyExists(f"OcnBlocklist with res_id={obj.res_id} and ocn={obj.ocn} already exists.")
        obj.created_by = self.get_user().name

        return obj

# ------------


# ---
class IngressTrunkCreate(DnlCreate):
    scheme_class = IngressTrunkScheme
    entity = 'IngressTrunk'
    unique_field = 'resource_id'
    additional_responses = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.create_time = obj.update_at
        obj.ingress = True
        obj.egress = False
        if self.req_data == {}:
            raise ValidationError('missing body parameters! (may be wrong call)')
        if 'name' not in self.req_data:
            raise ValidationError({'name': ['missing  "name" field!']})

        if 'client_id' in kwargs:
            cli = model.Client.get(kwargs['client_id'])
            if not cli:
                # raise ValidationError('no client_id {} not found!'.format(kwargs['client_id']))
                raise NoResultFound('no client_id {} not found!'.format(kwargs['client_id']))
            obj.client_id = kwargs['client_id']
        elif 'carrier_id' in kwargs:
            obj.client_id = kwargs['carrier_id']
        else:
            raise ValidationError('no client_id in path!')
        obj.alias = self.req_data['name']
        if model.Resource.filter(model.Resource.alias == obj.alias).first():
            raise ValidationError(
                'trunk "{}" already exists (see trunk list ), cannot create such name!'.format(obj.alias))
        # obj.profit_type = 'Percentage'
        if 'media_type' not in self.req_data:
            obj.media_type = 'Bypass Media'
        if 'profit_type' not in self.req_data:
            obj.profit_type = 'percentage'
        # checks
        prefs = []
        if obj.prefixes:
            prefs = [p.tech_prefix for p in obj.prefixes]
        if obj.prefix:
            prefs = [obj.prefix]
        if obj.prefixes or obj.prefix:
            for i in obj.ip:
                q = model.Resource.query().outerjoin(model.ResourceIp).outerjoin(model.ResourcePrefix). \
                    filter(and_(model.ResourceIp.ip == i.ip, model.ResourceIp.port == i.port)). \
                    filter(model.Resource.ingress).filter(model.Resource.status == 1). \
                    filter(model.ResourcePrefix.tech_prefix.in_(prefs)).first()
                if q:
                    raise ValidationError('Inrgess trunk {} already uses this prefix and IP'.format(q.resource_id))

        if not (obj.prefixes):
            if len(obj.ip) > 1:
                raise ValidationError('Cannot add more than one IP when no prefix!')
        for reg in obj.reg_user:
            reg.reg_type = 1
        for reg in obj.reg_gateway:
            reg.reg_type = 2
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        obj = model.Resource.get(object_id)
        if 'pdd' in req.data and req.data['pdd'] is None:
            obj.pdd = None
            obj.save()

class IngressTrunkResource(DnlResource):
    model_class = model.IngressTrunk
    scheme_class = IngressTrunkScheme
    scheme_class_get = IngressTrunkGetScheme
    scheme_class_modify = IngressTrunkModifyScheme
    entity = 'IngressTrunk'
    id_field = 'resource_id'
    has_update_by = True
    unique_field = 'alias'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        obj = super(IngressTrunkResource, self).get_object(resp, model_class, **kwargs)
        if obj and obj.ingress and not obj.purged:  # obj.client_type == 'carrier':
            return obj
        self.set_response(resp, responses.ObjectNotFoundErrorResponse(
            data={'message': 'Trunk {} not found!'.format(kwargs['resource_id'])}))
        return None

    def on_patch(self, req, resp, **kwargs):
        log.debug("on_patch")
        for k, v in req.data.items():
            if isinstance(v, str) and '\xa0' in v:
                req.data[k] = v.replace('\xa0', ' ')
                log.debug(f"non-breaking space found. {k}: {v}")
        if 'shaken_vfy_policy' in req.data and not req.data['shaken_vfy_policy'] and not isinstance(req.data['shaken_vfy_policy'], int):
            req.data['shaken_vfy_policy'] = None
        ret = super().on_patch(req, resp, **kwargs)
        log.debug("finished on_patch")
        return ret

    def on_get(self, req, resp, **kwargs):
        ret = super().on_get(req, resp, **kwargs)
        data = json.loads(resp.body)
        if 'payload' in data and 'prefixes' in data['payload']:
            prefixes = data['payload']['prefixes']
            log.debug(prefixes)
            new_prefixes = []
            tech_prefixes = set([prefix['tech_prefix'] for prefix in prefixes])
            for tech_prefix in tech_prefixes.copy():
                tprefixes = [prefix for prefix in prefixes if prefix['tech_prefix'] == tech_prefix]
                code = set([str(i['code']) for i in tprefixes])
                code_cps = set([str(i['code_cps']) for i in tprefixes])
                code_cap = set([str(i['code_cap']) for i in tprefixes])
                ids = set([str(i['id']) for i in tprefixes])
                prefix = tprefixes[0]
                prefix['code'] = ','.join(code)
                prefix['code_cap'] = ','.join(code_cap)
                prefix['code_cps'] = ','.join(code_cps)
                prefix['id'] = ','.join(ids)
                new_prefixes += [prefix]
            data['payload']['prefixes'] = new_prefixes
            resp.body = json.dumps(data)
        return ret

    def before_update(self, obj, req):
        if obj.client:
            if obj.client.cps_limit and 'cps_limit' in req.data and req.data['cps_limit'] and int(req.data['cps_limit']) > obj.client.cps_limit:
                raise ValidationError('Resource\'s cps_limit shouldn\'t exceed client\'s cps_limit')
            if obj.client.call_limit and 'call_limit' in req.data and req.data['call_limit'] and int(req.data['call_limit']) > obj.client.call_limit:
                raise ValidationError('Resource\'s call_limit shouldn\'t exceed client\'s call_limit')

        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)

        obj.store_old_detail()

        if obj.name and not obj.alias:
            obj.alias = obj.name
        data = req.data
        if 'ip' in data:  # ???
            for ip in data['ip']:
                if ip['addr_type'] == 'host':
                    dups = model.ResourceIp.filter(model.ResourceIp.fqdn == ip['fqdn']).filter(and_(
                        model.ResourceIp.resource_id != obj.resource_id,
                        model.ResourceIp.trunk_type2 == obj.trunk_type2,
                        model.ResourceIp.ingress == obj.ingress,
                        model.ResourceIp.port == ip['port'])).all()
                else:
                    dups = model.ResourceIp.filter(model.ResourceIp.ip == ip['ip']).filter(and_(
                        model.ResourceIp.resource_id != obj.resource_id,
                        model.ResourceIp.trunk_type2 == obj.trunk_type2,
                        model.ResourceIp.ingress == obj.ingress,
                        model.ResourceIp.port == ip['port'])).all()
                for dup in dups:
                    if dup and dup.resource:
                        prefixes = bool(set([prefix['tech_prefix'] for prefix in data['prefixes'] if
                                             prefix['tech_prefix']])) if 'prefixes' in data else False
                        routing_plan = bool(set([prefix.get('routing_plan_id', None) for prefix in data['prefixes'] if
                                                 prefix.get('routing_plan_id', None)])) if 'prefixes' in data else False
                        rate_table = bool(set([prefix.get('rate_table_id', None) for prefix in data['prefixes'] if
                                               prefix.get('rate_table_id', None)])) if 'prefixes' in data else False
                        # up_prefixes = (not 'prefixes' in data) or prefixes
                        if (not ((obj.prefix or prefixes) and dup.resource.prefix) and (
                                routing_plan or rate_table)) and not dup.resource.purged:
                            raise ValidationError(
                                'The IP {} is used already in trunk {}'.format(ip, dup.resource.alias))
        prefs = []
        if 'prefixes' in data:
            prefixes = data['prefixes']
            new_prefixes = []
            for i in prefixes.copy():
                for j in range(len(str(i.get('code', '')).split(','))):
                    prefix = i.copy()
                    prefix['code'] = str(i.get('code', '')).split(',')[j] or None
                    prefix['code_cap'] = str(i.get('code_cap', '')).split(',')[j] or None
                    prefix['code_cps'] = str(i.get('code_cps', '')).split(',')[j] or None
                    new_prefixes += [prefix]

            data['prefixes'] = new_prefixes
            pref_count = len(model.ResourcePrefix.filter(model.ResourcePrefix.resource_id == obj.resource_id).all())
            del_count = pref_count - len(data['prefixes'])
            if del_count >= 0:
                to_delete = model.ResourcePrefix.filter(model.ResourcePrefix.resource_id == obj.resource_id).limit(
                    del_count).all()
                to_delete_ids = [i.id for i in to_delete]
                model.ResourcePrefix.filter(model.ResourcePrefix.id.in_(to_delete_ids)).delete(
                    synchronize_session='fetch')
                prefixes = model.ResourcePrefix.filter(model.ResourcePrefix.resource_id == obj.resource_id).all()
                new_prefixes = req.data.pop('prefixes')
                for old, new in zip(prefixes, new_prefixes):
                    for field in ('tech_prefix', 'routing_plan_id', 'rate_table_id', 'product_id'):
                        setattr(old, field, new.get(field, None))
                        old.save()
                    for field in ('code_cap', 'code_cps', 'code'):
                        setattr(old, field, new.get(field, None) or None)
                        old.save()
                prefs = [p['tech_prefix'] for p in new_prefixes if 'tech_prefix' in p and p['tech_prefix']]
            else:
                model.ResourcePrefix.filter(model.ResourcePrefix.resource_id == obj.resource_id).delete()
                prefixes = model.ResourcePrefix.filter(model.ResourcePrefix.resource_id == obj.resource_id).all()
                new_prefixes = req.data.pop('prefixes')
                i = 0
                for old, new in zip(prefixes, new_prefixes):
                    i += 1
                    for field in ('tech_prefix', 'routing_plan_id', 'rate_table_id', 'product_id'):
                        setattr(old, field, new.get(field, None))
                    for field in ('code_cap', 'code_cps', 'code'):
                        setattr(old, field, new.get(field, None) or None)
                    old.save()
                for new in new_prefixes[i:]:
                    new_prefix = model.ResourcePrefix(**new)
                    new_prefix.resource_id = obj.resource_id
                    new_prefix.save()
                prefs = [p['tech_prefix'] for p in new_prefixes if 'tech_prefix' in p and p['tech_prefix']]
        if 'prefix' in data and data['prefix']:
            prefs = [data['prefix']]
        if 'reg_user' in data:
            for reg_user in obj.reg_user:
                reg_user.delete()
        if 'reg_gateway' in data:
            for reg_user in obj.reg_gateway:
                reg_user.delete()
        if len(prefs) and 'ip' in data:  # obj.prefixes or obj.prefix:
            for i in data['ip']:
                q = None
                if 'port' not in i:
                    i['port'] = None
                if i['addr_type'] == 'ip':
                    q = model.Resource.query().outerjoin(model.ResourceIp).outerjoin(model.ResourcePrefix). \
                        filter(and_(model.ResourceIp.ip == i['ip'], model.ResourceIp.port == i['port'])). \
                        filter(model.Resource.resource_id != obj.resource_id). \
                        filter(model.Resource.ingress).filter(model.Resource.status == 1). \
                        filter(model.ResourcePrefix.tech_prefix.in_(prefs)).first()
                if q:
                    raise ValidationError('Inrgess trunk with such prefix and IP already exists!')
        if False and len(prefs) == 0 and 'ip' in data:
            if len(data['ip']) > 1:
                raise ValidationError('Cannot add more than one IP when no prefix!')
        return obj

    def _after_update(self, result, obj, data):
        try:
            if obj.client and obj.client.is_send_trunk_update:# and obj.is_ip_changed:
                ret = model.MailSender.apply_mail(obj, 'trunk_change')
                if ret:
                    log.error('EgressTrunkResource trunk_change send mail error {}'.format(ret))
        except Exception as e:
            log.error('EgressTrunkResource after_update error {}'.format(str(e)))

    def after_update(self, result, obj, data):
        try:
            from api_dnl.tasks import apply_mail_task
            from kombu.exceptions import OperationalError
            if obj.client and obj.client.is_send_trunk_update:# and obj.is_ip_changed:
                try:
                    apply_mail_task.delay(result, 'trunk_change')
                except OperationalError as e:
                    apply_mail_task(result, 'trunk_change')
        except Exception as e:
            log.error('IngressTrunkResource after_update error {}'.format(str(e)))

    def get_object_data(self, resp, model_class, scheme_class, **kwargs):
        data = super(IngressTrunkResource, self).get_object_data(resp, model_class, scheme_class, **kwargs)
        if data and 'auth_type' in data:
            if data['auth_type'] == 'Authorized by Host Only':
                data.pop('reg_gateway')
            elif data['auth_type'] == 'Authorized by SIP Registration':
                data.pop('ip')
        return data

    def delete_object(self, req, resp, model_class, **kwargs):
        resource = model.Resource.get(kwargs['resource_id'])
        resource.purged = True
        resource.client_id = None
        resource.group_id = None
        # resource.alias = ''
        resource.save()
        model.ResourceIp.filter(model.ResourceIp.resource_id == kwargs['resource_id']).delete(
            synchronize_session='fetch')
        return True


class EnfourceCidCreate(DnlCreate):
    scheme_class = EnfourceCidScheme
    model_class = model.MonitoredRule
    entity = 'MonitoredRule'
    entity_plural = 'MonitoredRule item'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent resource'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        kwargs = client_context(self, req, resp, **kwargs)

        resource = model.Resource.get(kwargs['resource_id'])

        if not resource:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Resource {} not found!'.format(kwargs['resource_id'])}))
            return False

        old_obj = model.MonitoredRule.filter(model.MonitoredRule.rule_name == 'CID_block_' + str(resource.resource_id))

        if old_obj and old_obj.first():
            self.set_response(resp, OperationErrorResponse(
                'Resource {} already has EnfourceCid'.format(kwargs['resource_id'])))
            return False

        return self._on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):
        # id = model.MonitoredRule.query().order_by(model.MonitoredRule.id.desc()).first().id + 1
        resource = model.Resource.get(kwargs['resource_id'])

        resource.enfource_cid = True
        resource.save()
        obj.rule_name = 'CID_block_' + str(resource.resource_id)
        obj.acd_action = '<'
        obj.asr_action = '<'
        obj.sdp_action = '>'
        obj.is_ingress_trunk = True
        # obj.ingress_trunk_id = kwargs['resource_id']
        # obj.id = id

        return obj


class EnfourceCidResource(DnlResource):
    scheme_class = EnfourceCidScheme
    scheme_class_get = EnfourceCidScheme
    scheme_class_modify = EnfourceCidScheme
    model_class = model.MonitoredRule
    entity = 'EnfourceCid'
    entity_plural = 'EnfourceCid items'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent resource'},)
    # id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        resource = model.Resource.get(kwargs['resource_id'])

        if not resource:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Resource {} not found!'.format(kwargs['resource_id'])}))
            return False

        obj = model.MonitoredRule.filter(model.MonitoredRule.rule_name == 'CID_block_' + str(resource.resource_id))

        if not (obj or obj.first()):
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'EnfourceCid of resource {} not found!'.format(kwargs['resource_id'])}))
            return False

        if obj and obj.first():
            return obj.first()

        return None


class IngressTrunkActionsResource(IngressTrunkResource):
    model_class = model.IngressTrunk
    scheme_class = IngressTrunkActionsScheme
    scheme_class_get = IngressTrunkActionsScheme
    scheme_class_modify = IngressTrunkActionsScheme
    entity = 'IngressTrunkActions'
    has_delete_operation = False


class IngressFailOverCreate(DnlCreate):
    scheme_class = ResourceNextRouteRuleModifyScheme
    model_class = model.ResourceNextRouteRule
    entity = 'ResourceNextRouteRule'
    entity_plural = 'ResourceNextRouteRule item'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent ingress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        resource = model.IngressTrunk.get(kwargs['resource_id'])
        if not resource or not resource.ingress:
            raise NoResultFound('no ingress_trunk {} found!'.format(kwargs['resource_id']))
        obj.resource_id = resource.resource_id

        return obj


class IngressFailOverResource(DnlResource):
    scheme_class = ResourceNextRouteRuleScheme
    scheme_class_get = ResourceNextRouteRuleScheme
    scheme_class_modify = ResourceNextRouteRuleModifyScheme
    model_class = model.ResourceNextRouteRule
    entity = 'ResourceNextRouteRule'
    entity_plural = 'ResourceNextRouteRule items'
    path_parameters = ({'name': 'resource_id',
                        'description': 'Parent ingress trunk'},)  # ,{'name': 'id', 'description': 'ResourceFailover id to get info abount'}
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(IngressFailOverResource, self).modify_query_from_filtering_for_list(filtering, **kwargs)

        resource = model.IngressTrunk.get(kwargs['resource_id'])
        if not resource or not resource.ingress:
            raise NoResultFound('no ingress_trunk {} found!'.format(kwargs['resource_id']))

        q.filter(model.ResourceNextRouteRule.resource_id == kwargs['resource_id'])
        return ret, q


class IngressFailOverList(DnlList):
    scheme_class = ResourceNextRouteRuleScheme
    model_class = model.ResourceNextRouteRule
    entity = 'ResourceNextRouteRule'
    entity_plural = 'ResourceNextRouteRule items'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent ingress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(IngressFailOverList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        q = q.filter(model.ResourceNextRouteRule.resource_id == kwargs['resource_id'])
        return ret, q


class IngressSipErrorCodeCreate(DnlCreate):
    scheme_class = SipErrorCodeScheme
    model_class = model.SipErrorCode
    entity = 'SipErrorCode'
    entity_plural = 'SipErrorCode item'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent ingress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        resource = model.IngressTrunk.get(kwargs['resource_id'])
        if not resource or not resource.ingress:
            raise NoResultFound('no ingress_trunk {} found!'.format(kwargs['resource_id']))
        obj.resource_id = resource.resource_id

        return obj


class IngressSipErrorCodeResource(DnlResource):
    scheme_class = SipErrorCodeScheme
    scheme_class_get = SipErrorCodeSchemeGet
    scheme_class_modify = SipErrorCodeScheme
    model_class = model.SipErrorCode
    entity = 'SipErrorCode'
    entity_plural = 'SipErrorCode items'
    path_parameters = ({'name': 'resource_id',
                        'description': 'Parent ingress trunk'},)
    id_field = 'sip_error_code_id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(IngressSipErrorCodeResource, self).modify_query_from_filtering_for_list(filtering, **kwargs)

        resource = model.IngressTrunk.get(kwargs['resource_id'])
        if not resource or not resource.ingress:
            raise NoResultFound('no ingress_trunk {} found!'.format(kwargs['resource_id']))

        q.filter(model.SipErrorCode.resource_id == kwargs['resource_id'])
        return ret, q


class IngressSipErrorCodeList(DnlList):
    scheme_class = SipErrorCodeSchemeGet
    model_class = model.SipErrorCode
    entity = 'SipErrorCode'
    entity_plural = 'SipErrorCode items'
    path_parameters = ({'name': 'resource_id', 'description': 'Parent ingress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(IngressSipErrorCodeList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        q = q.filter(model.SipErrorCode.resource_id == kwargs['resource_id'])
        return ret, q


# IngressTrunkCreate.before_create = carrier_before_create
class IngressTrunkList(DnlList):
    scheme_class = IngressTrunkGetScheme
    model_class = model.IngressTrunk
    entity_plural = 'IngressTrunks'
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)
    security = (DEFAULT_SECURITY)
    restrict = ()
    large_list_fields = ['trunk_id', 'trunk_name', 'client_name', 'client_id']

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(IngressTrunkList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # ret = ret.filter(and_(cls.client_type.is_(None), cls.client_id.in_(self.get_user(self.req).clients_id)))
        if not 'purged' in filtering:
            ret = ret.filter(cls.purged == False)
        ret = ret.filter(and_(cls.ingress == True, cls.alias != '', cls.client_id == model.Client.client_id,
                              model.Client.user_id_filter(self.get_user(self.req).user_id)))
        return filt, ret

    def on_filter_has_ip(self, q, val, kwargs):
        cls = self.model_class
        clsip = aliased(model.ResourceIp)
        q = q.filter(cls.resource_id.in_(select([clsip.resource_id]).where(clsip.ip == val))). \
            filter(cls.auth_type == 'Authorized by Host Only')
        return q

    def on_filter_rate_table_id(self, q, val, kwargs):
        cls = self.model_class
        r = model.IngressTrunk
        p = aliased(model.ResourcePrefix)

        q = q.filter(
            or_(cls.rate_table_id == val, r.resource_id.in_(select([p.resource_id]).where(p.rate_table_id == val)))
        )
        log.debug(model.query_to_sting(q))
        return q

    def on_filter_routing_plan_id(self, q, val, kwargs):
        r = model.IngressTrunk
        p = aliased(model.ResourcePrefix)
        q = q.filter(r.resource_id.in_(select([p.resource_id]).where(p.route_strategy_id == val))
                     )
        log.debug(model.query_to_sting(q))
        return q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(IngressTrunkList, self).get_filtering_for_list(parsed_qs, **kwargs)
        cli = model.Client.get(kwargs['client_id'])
        if not cli:
            raise NoResultFound('no client_id {} not found!'.format(kwargs['client_id']))
        ret['client_id'] = kwargs['client_id']
        ret['ingress'] = 'true'
        return ret


class IngressTrunkResourceAll(DnlResourceAll):
    model_class = model.IngressTrunk
    scheme_class = IngressTrunkActivateScheme
    scheme_class_get = ObjectUpdatedScheme
    entity = 'All IngressTrunks'
    has_update_by = True
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query(self, filt, qs, req, resp, model_class, **kwargs):
        qs = qs.filter(model.IngressTrunk.ingress == True)
        return filt, qs


class ProductCodeNameCreate(DnlCreate):
    scheme_class = ProductCodeNameScheme
    model_class = model.ProductCodeName
    entity = 'ProductCodeName'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ProductCodeNameResource(DnlResource):
    scheme_class = ProductCodeNameScheme
    scheme_class_get = ProductCodeNameGetScheme
    scheme_class_modify = ProductCodeNameScheme
    model_class = model.ProductCodeName
    id_field = 'item_id'
    entity = 'ProductCodeName'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ProductCodeNameList(DnlList):
    scheme_class = ProductCodeNameGetScheme
    model_class = model.ProductCodeName
    entity = 'ProductCodeName'
    entity_plural = 'ProductCodeName items'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ProductCodeNameResourceCreate(CustomPostAction):
    scheme_class = ProductCodeNameResourceScheme
    model_class = model.ProductCodeNameResource
    entity = 'ProductCodeNameResource'
    security = (DEFAULT_SECURITY)
    path_parameters = ({"name": "item_id", 'description': 'id of ProductCodeName item'},
                       {'name': 'resource_id', 'type': 'integer', 'description': "resource_id",},)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        cls = self.model_class
        obj = cls(item_id=kwargs['item_id'], resource_id=kwargs['resource_id'])
        if obj:
            obj.save()
            self.set_response(resp, responses.SuccessResponseJustOk())
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
        return False


class ProductCodeNameResourceDelete(CustomDeleteAction):
    scheme_class = ProductCodeNameResourceScheme
    model_class = model.ProductCodeNameResource
    entity = 'ProductCodeNameResource'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({"name": "item_id", 'description': 'id of ProductCodeName item'},
                       {'name': 'resource_id', 'type': 'integer', 'description': "resource_id",},)

    def apply(self, obj, req, resp, **kwargs):
        from kombu.exceptions import OperationalError
        cls = self.model_class
        try:
            cls.filter(and_(cls.item_id == kwargs['item_id'], cls.resource_id == kwargs['resource_id'])).delete(
                synchronize_session='fetch')
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
        self.set_response(resp, responses.SuccessResponseJustOk())
        return False

# +++ ClientDid
class ClientDidCreate(DnlCreate):
    scheme_class = ClientDidScheme
    entity = 'ClientDid'
    unique_field = 'client_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):

        if not 'billing_mode' in self.req_data:
            obj.billing_mode = 'prepay'
        if not 'billing_method' in self.req_data:
            obj.billing_method = 'percentage'
        if not 'auto_invoice_type' in self.req_data:
            obj.auto_invoice_type = 'buy'

        r = obj.resource
        if not r:
            r = model.Resource(name=obj.name)
        if r:
            r.profit_type = obj.billing_method
            r.name = obj.name
            r.alias = obj.name
            r.egress = True
            r.ingress = False
            r.trunk_type2 = 'DID Traffic'
            r.update_by = self.get_user().name
            r.update_at = datetime.now(UTC)
            r.create_time = obj.update_at
            obj.resources.append(r)
        if obj.login and obj.password:
            un = obj.login
            if un:
                if model.User.filter(and_(model.User.name == un)).first():
                    raise ValidationError(
                        'username "{}" already exists (see user list ), cannot create such name!'.format(un))
            obj.user = model.User(name=obj.login, passwd=obj.password, user_type='client', role_id=1)
            if 'auth_ip' in self.req.data:
                auth_ip_json = {'auth_ip': self.req.data['auth_ip']}
                auth_ip_scheme = UserScheme()
                scheme = auth_ip_scheme.load(auth_ip_json, instance=obj.user, partial=True)
                if scheme.errors:
                    log.debug('Error while changing auth_ip {}'.format(scheme.errors))

        obj.client_type = 'client'
        obj.company_type = 'origination'
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.create_time = datetime.now(UTC)
        if obj.did_product:
            obj.did_product.created_by = self.get_user().name
        # obj.apply_mail('welcome')
        return obj


class ClientDidResource(DnlResource):
    model_class = model.Client
    scheme_class = ClientDidScheme
    scheme_class_get = ClientDidGetScheme
    scheme_class_modify = ClientDidScheme
    entity = 'ClientDid'
    id_field = 'client_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_delete(self, req, resp, **kwargs):
        if not check_permission(self, req, 'modify', self.get_object(resp, self.model_class, **kwargs)):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        obj = self.get_object(resp, self.model_class, **kwargs)
        try:
            if obj.vendor_res_id:
                model.DidRepository.filter(model.DidRepository.vendor_trunk_id == obj.vendor_res_id).delete(
                    synchronize_session='fetch')
            model.Resource.filter(model.Resource.client_id == obj.client_id, model.Resource.egress).update(
                {'active': False, 'purged': True},
                synchronize_session='fetch')
            cls = self.model_class
            cls.filter(cls.client_id == obj.client_id).delete()
            self.set_response(resp, responses.SuccessResponseJustOk())
        except Exception as e:
            msg = 'Client delete error:{}'.format(str(e))
            log.error(msg)
            self.set_response(resp, OperationErrorResponse(msg))
            return False
        # ret = super(ClientDidResource, self).on_delete(req, resp, **kwargs)

    def before_update(self, obj, req):
        errors = self.scheme_class_modify().validate(req.data)
        if errors:
            raise ValidationError(errors)
        if 'username' in req.data or 'password' in req.data:
            login = None
            if 'username' in req.data:
                login = req.data['username']
            password = '*'
            if 'password' in req.data:
                password = req.data['password']
            if model.User.filter(and_(model.User.name == login, model.User.client_id != obj.client_id)).first():
                raise ValidationError('username "{}" already exists (see user list) !'.format(login))

            # if obj.username != un:
            if not obj.user:
                if not login:
                    login = obj.name
                obj.user = model.User(name=login, passwd=password, user_type='client',
                                      client_id=obj.client_id)
            else:
                if login:
                    obj.user.name = login
                if password:
                    obj.user.passwd = password
                obj.user.user_type = 'client'
                obj.user.client_id = obj.client_id

        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)

        if obj.client_type != 'client':
            raise ValidationError('Carrier {} not is did client !'.format(obj.client_id))
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        billing_rule = model.DidBillingPlan.filter(model.DidBillingPlan.name == obj.name).first()
        rate_table = model.RateTable.filter(model.RateTable.name == obj.name).first()

        if 'name' in req.data and req.data['name'] != obj.name:
            old_name = obj.name
            for robj in obj.resources:
                log.debug('Change resource {} alias and rate table {} name'.format(obj.resource.resource_id,
                                                                                   obj.resource.rate_table_id))
                robj.alias = robj.alias.replace(old_name, req.data['name'])
                robj.name = robj.alias
                obj.session().add(robj)
            # obj.resource.rate_table.name=req.data['name']
            if rate_table:
                rate_table.name = req.data['name']
                rate_table.session().add(rate_table)

            if billing_rule:
                billing_rule.name = req.data['name']
                billing_rule.session().add(billing_rule)
            name = req.data['name']
        else:
            name = obj.name

        if 'active' in req.data and obj.resource:
            obj.resource.active = req.data['active']

        if 'resource' in req.data:
            res_data = req.data['resource']
            if 'billing_method' in self.req_data:
                res_data['profit_type'] = req.data['billing_method']
            res = obj.resource
            if not res:
                old = model.Resource.filter(model.Resource.alias == obj.name).first()
                if old:
                    old.alias = old.alias + '_backup_{}'.format(int(datetime.now(UTC).timestamp()))
                    old.save()
                res = model.Resource(name=obj.name, alias=obj.name, client_id=obj.client_id)
            # if 'ip' in res_data and len(res_data['ip']) == 1:
            if 'ip' in res_data:
                for res_x in obj.resources:
                    for ip_x in res_x.ip:
                        ip_x.delete()
                    for ip in res_data['ip']:
                        inst = model.ResourceIp(addr_type=0, resource_id=res_x.resource_id)
                        res_x.ip.append(inst)
                        scheme = ResourceIpScheme().load(ip, instance=inst, partial=True)
                        inst.save()
                del res_data['ip']
            if 'reg_user' in res_data:
                for reg_user in res.reg_user:
                    reg_user.delete()
            scheme = ClientResourceDidScheme().load(res_data, instance=res, partial=True)
            # res.save()
            scheme.data.save()
            # obj.resource = scheme.data
            # obj.resource.save()
            del self.req_data['resource']
        return obj


class ClientDidList(DnlList):
    model_class = model.Client
    scheme_class = ClientDidGetScheme
    entity_plural = 'DidClients'
    # entity = 'DidClient'
    # unique_field = 'client_id'
    # additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ClientDidList, self).get_filtering_for_list(parsed_qs, **kwargs)
        # ret['egress'] = 'true'
        ret['is_orig'] = 'true'
        ret['is_client'] = 'true'
        return ret


class ClientDidOrCarrierList(DnlList):
    model_class = model.Client
    scheme_class = ClientSimpleGetScheme
    entity_plural = 'clients and carriers'
    # entity = 'DidClient'
    # unique_field = 'client_id'
    # additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(ClientDidOrCarrierList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        q = q.filter(or_(cls.client_type.is_(None), cls.client_type == 'client'))
        log.debug(model.query_to_sting(q))
        return ret, q


class ClientDidAssignDidsAction(resources.CustomAction):
    scheme_class = ClientDidAssignDidsScheme
    model_class = model.Client
    description = 'assign multiple dids to client'
    path_parameters = ({'name': 'client_id', 'description': 'client'},
                       {'name': 'client_billing_rule_id', 'description': 'client billing rule'},)
    body_parameters = ('Dids to assign ', ClientDidAssignDidsScheme)
    method = 'patch'

    def on_patch(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        client_billing_rule_id = kwargs['client_billing_rule_id']
        dids = set(req.data.pop('dids', []))
        force = req.data.pop('force_reassign', False)
        if not obj:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return False
        client = model.Client.get(obj.client_id)
        try:

            ret = []
            for did in dids:
                cls = model.DidBillingRel
                obj = cls.filter(and_(cls.did == str(did), cls.end_date.is_(None))).first()
                if obj:
                    try:
                        if obj.client_res_id and not force:
                            ret.append(dict(did=did, result='already assigned'))
                            continue
                        obj.end_date = datetime.utcnow().replace(microsecond=0)
                        d = obj.did
                        eres = obj.vendor_res
                        eru = obj.vendor_billing_rule
                        obj.save()
                        make_transient(obj)
                        obj.id = None
                        obj.end_date = None
                        obj.did = d
                        obj.vendor_res = eres
                        obj.vendor_billing_rule = eru
                        rule = model.DidBillingPlan.get(client_billing_rule_id)
                        res = client.get_assigned_billing_plan_resource(rule, None)
                        # obj.session().add(res)
                        res.update_by = self.get_user(req).name
                        obj.client_res = res
                        obj.client_billing_rule = rule
                        obj.did_billing_id = client_billing_rule_id
                        if obj.vendor_res:
                            if obj.vendor_billing_rule:
                                vendor_billing_rule = obj.vendor_billing_rule  # model.DidBillingPlan.get(obj.vendor_billing_rule_id)
                                rate_table = vendor_billing_rule.rate_table
                                vendor_res = obj.vendor_res  # model.Resource.get(obj.vendor_res_id)
                                prefix = vendor_res.assign_vendor_did_prefix(obj.did, rate_table)
                                # obj.session().add(vendor_res)
                                obj.session().add(prefix)
                        try:
                            if obj.buy_billing_plan_id and obj.client_res_id:
                                plan = model.DidBillingPlan.get(obj.buy_billing_plan_id)
                                client_id = model.Resource.get(obj.client_res_id).client_id
                                if plan.setup_fee:
                                    model.ClientBalanceOperationAction(client_id=client_id, balance=plan.setup_fee,
                                                                       egress_balance=plan.setup_fee,
                                                                       action=5,
                                                                       create_by='did_setup_fee_on_assign').save()
                        except Exception as e:
                            log.debug('did_billing_rel created, but deducting setupo fee errors: {}'.format(e))
                        # prefix.save()
                        obj.start_date = datetime.utcnow().replace(microsecond=0)
                        obj.save()
                        ret.append(dict(did=did, result='success'))
                    except Exception as e:
                        ret.append(dict(did=did, result='error on assign: {}'.format(str(e))))
                else:
                    ret.append(dict(did=did, result='not free'))
            self.set_response(resp, responses.SuccessResponseObjectInfo(data={'items': ret}))
            return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False
        return True


# --- ClientDid

# +++ CountryDid


class AvailableCountryList(CustomGetAction):
    scheme_class = AvailableCountrySearchScheme
    path_parameters = ()
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=AvailableCountrySearchScheme),)
    query_parameters = [
        {'name': n, 'type': swagger.specify.get_field_type(f)} for n, f in scheme_class._declared_fields.items()
    ]

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            self.set_response(resp, responses.ForbiddenErrorResponse())
            return
        params = dict(parse_qsl(req.query_string))
        country = params.pop('country', None)
        try:
            mdp = model.DidParam
            mdbr = model.DidRepository
            query = model.get_db().session.query(
                mdp.country_iso
            ).distinct().filter(and_(
                mdp.did == mdbr.did,
                mdp.country_iso.isnot(None)
                # mdbr.is_available
            ))
            if country:
                query = query.filter(mdp.country_iso == country)
            ret = [{'country': i.country_iso} for i in query]
            self.set_response(resp, responses.SuccessResponse(data={
                'items': ret,
                'total': len(ret), 'page': 0,
                'per_page': len(ret)
            }, scheme=schemes.ObjectScheme))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


class AvailableStateList(CustomGetAction):
    scheme_class = AvailableStateSearchScheme
    path_parameters = ()
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=AvailableStateSearchScheme),)
    query_parameters = [
        {'name': n, 'type': swagger.specify.get_field_type(f)} for n, f in scheme_class._declared_fields.items()
    ]

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            self.set_response(resp, responses.ForbiddenErrorResponse())
            return
        params = dict(parse_qsl(req.query_string))
        country = params.pop('country', None)
        state = params.pop('state', None)
        try:
            mdp = model.DidParam
            mdbr = model.DidRepository
            query = model.get_db().session.query(mdp.state.distinct()).filter(
                mdp.country_iso.isnot(None)
            )
            if state:
                query = query.filter(mdp.state == state)
            if country:
                query = query.filter(mdp.country_iso == country)
            # ret = [{'state': i.state} for i in query.all()]
            ret = [{'state': i[0]} for i in query.all()]
            self.set_response(resp, responses.SuccessResponse(data={
                'items': ret,
                'total': len(ret), 'page': 0,
                'per_page': len(ret)
            }, scheme=schemes.ObjectScheme))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


class AvailableLataList(CustomGetAction):
    scheme_class = AvailableLataSearchScheme
    path_parameters = ()
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=AvailableLataSearchScheme),)
    query_parameters = [
        {'name': n, 'type': swagger.specify.get_field_type(f)} for n, f in scheme_class._declared_fields.items()
    ]

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            self.set_response(resp, responses.ForbiddenErrorResponse())
            return
        params = dict(parse_qsl(req.query_string))
        country = params.pop('country', None)
        lata = params.pop('lata', None)
        try:
            mdp = model.DidParam
            mdbr = model.DidRepository
            query = model.get_db().session.query(
                mdp.lata
            ).distinct().filter(and_(
                mdp.did == mdbr.did,
                mdp.country_iso.isnot(None)
                # mdbr.is_available
            ))
            if lata:
                query = query.filter(mdp.lata == lata)
            if country:
                query = query.filter(mdp.country_iso == country)
            ret = [{'lata': i.lata} for i in query]
            self.set_response(resp, responses.SuccessResponse(data={
                'items': ret,
                'total': len(ret), 'page': 0,
                'per_page': len(ret)
            }, scheme=schemes.ObjectScheme))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


class AvailableNpaList(CustomGetAction):
    scheme_class = AvailableNpaSearchScheme
    path_parameters = ()
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=AvailableNpaSearchScheme),)
    query_parameters = [
        {'name': n, 'type': swagger.specify.get_field_type(f)} for n, f in scheme_class._declared_fields.items()
    ]

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            self.set_response(resp, responses.ForbiddenErrorResponse())
            return
        params = dict(parse_qsl(req.query_string))
        country = params.pop('country', None)
        npa = params.pop('npa', None)
        try:
            mdp = model.DidParam
            mdbr = model.DidRepository
            mdda = model.DidAssignments

            subquery = model.get_db().session.query(mdda.did).subquery()
            query = mdbr.filter(mdp.country_iso.isnot(None), not_(mdbr.did.in_(subquery)))
            if country:
                query = query.filter(mdp.country_iso == country)
            if npa:
                query = query.filter(mdbr.did.like('1{}%'.format(npa)))

            npas = list(set([i.npa for i in query.all()]))
            if npa:
                npas = list([i for i in npas if str(i) == str(npa)])
            ret = [{'npa': npa} for npa in npas]
            self.set_response(resp, responses.SuccessResponse(data={
                'items': ret,
                'total': len(ret), 'page': 0,
                'per_page': len(ret)
            }, scheme=schemes.ObjectScheme))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


# --- CountryDid

# +++ VendorDid

class VendorDidCreate(DnlCreate):
    scheme_class = VendorDidScheme
    entity = 'DidVendor'
    unique_field = 'client_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        if 'vendor_billing_rule_id' in req.data:
            kwargs['vendor_billing_rule_id'] = req.data['vendor_billing_rule_id']
            del req.data['vendor_billing_rule_id']
        return super(VendorDidCreate, self).on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):
        if not 'billing_mode' in self.req_data:
            obj.billing_mode = 'prepay'
        if not 'billing_method' in self.req_data:
            obj.billing_method = 'percentage'
        if not 'auto_invoice_type' in self.req_data:
            obj.auto_invoice_type = 'sell'
        _valid_unique('Client', 'name', obj.name)
        resource_name = obj.name
        i = 1
        while model.Resource.filter(model.Resource.alias == resource_name).first():
            resource_name = obj.name + str(i)
            i += 1
        # _valid_unique('Resource', 'alias', obj.name)
        # _valid_unique('Resource', 'name', obj.name)
        if obj.resource and obj.resource.vendor_dids:
            for did in obj.resource.vendor_dids:
                rep = model.DidBillingRel
                q = rep.filter(and_(rep.did == did.did, rep.vendor_res_id.isnot(None), rep.end_date.is_(None))).first()
                if q:
                    raise ValidationError(
                        'Did {} already used by another vendor {} !'.format(did.did, q.did_vendor_name))
        billing_rule = None
        rate_table = None
        if 'vendor_billing_rule_id' in kwargs and kwargs['vendor_billing_rule_id']:
            bill_rule_id = kwargs['vendor_billing_rule_id']
            _valid('DidBillingPlan', 'id', bill_rule_id)
            billing_rule = model.DidBillingPlan.get(bill_rule_id)
            rate_table = billing_rule.rate_table
        else:
            billing_rule = model.DidBillingPlan.filter(model.DidBillingPlan.name == obj.name).first()
            if not billing_rule:
                billing_rule = model.DidBillingPlan(name=obj.name)
            rate_table = model.RateTable.filter(model.RateTable.name == obj.name).first()
            if not rate_table:
                rate_table = billing_rule.rate_table
            if not rate_table:
                rate_table = None
            else:
                billing_rule.rate_table = rate_table
        r = obj.resource
        if r:
            r.profit_type = obj.billing_method
            r.name = resource_name
            r.alias = resource_name
            r.egress = False  # True
            r.ingress = True  # False
            r.trunk_type2 = 'DID Traffic'
            if rate_table:
                r.rate_table = rate_table
            obj.resources.append(r)
            for did in r.vendor_dids:
                log.debug('vendor assign did {}'.format(did.did))
                did.start_date = datetime.utcnow().replace(microsecond=0)
                if not did.sell_billing_plan_id:
                    did.sell_billing_plan = billing_rule
                else:
                    rate_table = model.DidBillingPlan.get(did.sell_billing_plan_id).rate_table
                    r.rate_table = rate_table

                q = model.DidBillingRel.filter(and_(model.DidBillingRel.did == did.did,
                                                    # model.DidBillingRel.vendor_res_id != r.resource_id,
                                                    model.DidBillingRel.end_date.is_(None))).first()
                if q and q.vendor_res and q.vendor_res.alias != r.alias:
                    raise ValidationError('Did {} already used by another vendor {} !'.format(did.did, q.vendor_res_id))
                if rate_table:
                    r.assign_vendor_did_prefix(did.did, rate_table)
        # did.vendor_res_id=r.resource_id

        obj.client_type = 'vendor'
        obj.company_type = 'origination'
        obj.unlimited_credit = True
        obj.create_time = datetime.now(UTC)
        obj.update_at = datetime.now(UTC)
        obj.update_by = self.get_user().name
        # obj.apply_mail('welcome')
        return obj


class VendorDidResource(DnlResource):
    model_class = model.Client
    scheme_class = VendorDidGetScheme
    scheme_class_get = VendorDidGetScheme
    scheme_class_modify = VendorDidModifyScheme
    entity = 'DidVendor'
    id_field = 'client_id'
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_delete(self, req, resp, **kwargs):
        if not check_permission(self, req, 'modify', self.get_object(resp, self.model_class, **kwargs)):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        obj = self.get_object(resp, self.model_class, **kwargs)
        try:
            if obj.name:
                model.RateTable.filter(model.RateTable.name == obj.name).delete(synchronize_session='fetch')
                model.DidBillingPlan.filter(model.DidBillingPlan.name == obj.name).delete(synchronize_session='fetch')
            if obj.vendor_res_id:
                model.DidRepository.filter(model.DidRepository.vendor_trunk_id == obj.vendor_res_id).delete(
                    synchronize_session='fetch')
            model.Resource.filter(and_(model.Resource.client_id == obj.client_id, model.Resource.egress)).update(
                {'active': False, 'client_id': None},
                synchronize_session='fetch')
        except Exception as e:
            msg = 'Vendor delete error:{}'.format(str(e))
            log.error(msg)
            self.set_response(resp, OperationErrorResponse(msg))
            return False
        ret = super(VendorDidResource, self).on_delete(req, resp, **kwargs)

    def update_object(self, req, resp, model_class, scheme_class, **kwargs):
        self.init_req(req)
        obj = self.get_object(resp, model_class, **kwargs)
        if not obj:
            return None
        obj = self.before_update(obj, req)
        scheme = scheme_class().load(self.req_data, instance=obj, partial=True)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False

        result = scheme.data.save(save_history=True, user=self.get_user(req),
                                  module=getattr(self.__class__, 'api_module', 'N/A'))

        self.after_update(result, obj, scheme.data)

        return result

    def before_update(self, obj, req):
        if obj.client_type != 'vendor':
            raise ValidationError('Client {} not is vendor !'.format(obj.client_id))
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        billing_rule = model.DidBillingPlan.filter(model.DidBillingPlan.name == obj.name).first()
        rate_table = model.RateTable.filter(model.RateTable.name == obj.name).first()
        if 'name' in req.data and req.data['name'] != obj.name:
            old_name = obj.name
            for robj in obj.resources:
                # log.debug('Change resource {} alias and rate table {} name'.format(obj.resource.resource_id,
                #                                                                    obj.resource.rate_table_id))
                r = model.Resource.filter(
                    model.Resource.alias == robj.alias.replace(old_name, req.data['name'])).first()
                if not r:
                    robj.alias = robj.alias.replace(old_name, req.data['name'])
                    robj.name = robj.alias
                    obj.session().add(robj)

            # obj.resource.rate_table.name=req.data['name']
            name = req.data['name']
            if rate_table:
                _valid_unique('RateTable', 'name', name, msg='in rate table')
                rate_table.name = req.data['name']
                rate_table.session().add(rate_table)

            if billing_rule:
                _valid_unique('DidBillingPlan', 'name', name, msg='in billing rules')
                billing_rule.name = req.data['name']
                billing_rule.session().add(billing_rule)
        else:
            name = obj.name
        if 'resource' in req.data:
            res_data = req.data['resource']
            res_data['profit_type'] = 'percentage'
            r = obj.resource
            if not r:
                r = model.Resource.filter(model.Resource.alias == name).filter(
                    model.Resource.client_id.is_(None)).first()
                log.debug(f"R = {r}")
                if not r:
                    r = model.Resource(alias=name)
                    obj.resource = r
                    if not rate_table:
                        rate_table = model.RateTable(name=name)
                    if not billing_rule:
                        billing_rule = model.DidBillingPlan(name=name)
                    billing_rule.rate_table = rate_table
                    r.rate_table = rate_table
                r.client_id = obj.client_id
                obj.resource = r

            dids = r.vendor_dids
            if 'vendor_dids' in res_data:
                for d in dids:
                    d.end_date = datetime.utcnow().replace(microsecond=0)
                    # d.is_available = False
                    model.ResourcePrefix.filter(model.ResourcePrefix.code == d.did).delete()
            # d.save()
            if 'vendor_tech_prefix' in res_data:
                model.ResourcePrefix.filter(model.ResourcePrefix.resource_id == r.resource_id).update(
                    dict(tech_prefix=res_data['vendor_tech_prefix']), synchronize_session='fetch')

            if 'ip' in res_data:
                # for res_x in obj.resources:
                #     for ip_x in res_x.ip:
                #         ip_x.delete()
                #     for ip in res_data['ip']:
                #         inst = model.ResourceIp(addr_type=0, resource_id=res_x.resource_id)
                #         res_x.ip.append(inst)
                #         scheme = ResourceIpScheme().load(ip, instance=inst, partial=True)
                #         inst.save()
                ips = []
                for item in res_data['ip']:
                    if (item['ip'], item.get('port', '')) in ips:
                        raise ValidationError({'ip': ['duplicate ip {}'.format(item['ip'])]})
                    ips.append((item['ip'], item.get('port', '')))
                    ips = list(set(ips))
                r.ip = []
                for idx in range(0, len(res_data['ip'])):
                    inst = model.ResourceIp(addr_type=0, resource_id=r.resource_id)
                    scheme = ResourceIpScheme().load(res_data['ip'][idx], instance=inst, partial=True)
                    inst.save()
                del res_data['ip']

            scheme = VendorResourceDidScheme().load(res_data, instance=r, partial=True)
            if scheme.errors:
                # self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
                log.debug('did vendor update:{}'.format(scheme.errors))
                raise ValidationError({'resource': scheme.errors})
                return False
            if 'vendor_dids' in res_data:
                for did in r.vendor_dids:
                    did.start_date = datetime.utcnow().replace(microsecond=0)
                    if not did.sell_billing_plan_id:
                        did.sell_billing_plan = billing_rule
                    else:
                        rate_table = model.DidBillingPlan.get(did.sell_billing_plan_id).rate_table

                    q = model.DidBillingRel.filter(and_(model.DidBillingRel.did == did.did,
                                                        model.DidBillingRel.vendor_res_id != r.resource_id,
                                                        model.DidBillingRel.end_date.is_(None))).first()
                    if q:
                        raise ValidationError(
                            'Did {} already used by another vendor {} !'.format(did.did, q.vendor_res_id))
                    r.assign_vendor_did_prefix(did.did, rate_table)

                    did.vendor_res_id = r.resource_id
            obj.session().add(scheme.data)
            log.debug('did vendor update saved resource:{}'.format(r))
            # del self.req_data['resource']['vendor_dids']

            del self.req_data['resource']
        return obj


class VendorDidList(DnlList):
    model_class = model.Client
    scheme_class = VendorDidGetScheme
    entity_plural = 'DidVendors'

    # unique_field = 'client_id'
    # additional_responses = ()
    # path_parameters = ()
    # security = (DEFAULT_SECURITY)
    # restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        filtering = {}
        for k, v in parsed_qs.items():
            if k in ['fields', 'per_page', 'page', 'order_by', 'order_dir', 'vendor_tech_prefix']:
                continue
            filtering[k] = v

        filtering['is_vendor'] = 'true'
        filtering['is_orig'] = 'true'
        return filtering

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        f, q = super(VendorDidList, self).modify_query_from_filtering_for_list(filtering, **kwargs)

        if "vendor_tech_prefix" in dict(parse_qsl(self.req.query_string)):
            vendor_tech_prefix = dict(parse_qsl(self.req.query_string))['vendor_tech_prefix'] if \
                dict(parse_qsl(self.req.query_string))['vendor_tech_prefix'] != 'null' else ''
            q = q.join(model.Resource, model.Resource.client_id == model.Client.client_id).join(model.ResourceExt,
                                                                                                model.ResourceExt.resource_id == model.Resource.resource_id).filter(
                text_("resource_ext.vendor_tech_prefix = '%s'" % vendor_tech_prefix))

        return f, q


class VendorDidUpload(ResourcesBaseClass):
    model_class = model.Client
    scheme_class = VendorResourceDidScheme
    # scheme_class_get = VendorDidGetScheme
    scheme_class_get = ObjectUpdatedScheme
    path_parameters = ({'name': 'client_id', 'description': 'Vendor to upload DIDs'},)
    additional_responses = ()
    body_params = ()
    entity = 'VendorDIDs file'

    def on_post(self, req, resp, **kwargs):
        model_class = self.scheme_class.Meta.model
        try:
            cli = model.Client.get(kwargs['client_id'])
            if not cli:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            now = str(datetime.utcnow().replace(microsecond=0))
            res = cli.resource
            file = req.files['file']
            byte_str = file.read()
            # Convert to a "unicode" object
            text_obj = byte_str.decode('UTF-8')  # Or use the encoding you expect
            # Use text_obj how you see fit!
            file = io.StringIO(text_obj)
            reader = csv.DictReader(file)
            i = 0
            for item in reader:
                plan_id = item.get('vendor_billing_rule_id', None)
                rel = model.DidBillingRel.filter(
                    and_(model.DidBillingRel.did == item['did'], model.DidBillingRel.end_date.is_(None))).first()
                if rel:
                    if req.data['dupliate_handling'] != 'Overwrite':
                        self.set_response(resp, responses.ValidationErrorResponse(
                            data='Did {} already exists'.format(item['did'])
                        ))
                        return False
                    rel.end_date = now
                    rel.save()
                i += 1
                rel = model.DidBillingRel(did=item['did'], buy_billing_plan_id=plan_id, start_date=now)
                res.vendor_dids.append(rel)
            res.save(save_history=False, user=self.get_user(req), module=getattr(self.__class__, 'api_module', 'N/A'))
            # data = self.get_object_data(resp, self.model_class, self.scheme_class_get, **kwargs)
            if res:
                self.set_response(resp, responses.SuccessResponseObjectInfo(data={'updated': i}))
            return True
        except PermissionError:
            self.set_response(resp, responses.OperationErrorResponse(
                data=errors.CommonErrors.PermissionError
            ))
        except IntegrityError:
            self.set_response(resp, responses.AlreadyExistsResponse(
                data=errors.CommonErrors.get_already_exists_error(self.entity, self.unique_field)
            ))
        except Exception as e:
            self.set_response(resp, responses.OperationErrorResponse(e))

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = self.body_params or (

            {
                'name': 'dupliate_handling',
                'in': 'formData',
                'description': 'How to handle duplicates',
                'required': True,
                'type': 'string',
                'default': 'Overwrite',
                'enum': ['Overwrite', 'Ignore']
            },
            {
                'name': 'file',
                'in': 'formData',
                'description': 'File to upload',
                'required': True,
                'type': 'file'
            },
            {
                'name': 'vendor_billing_rule_id',
                'in': 'formData',
                'description': 'vendor_billing_rule_id',
                'required': False,
                'type': 'string'
            }
        )

        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(

                responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                 description='Can\'t create file'),
                responses.SuccessResponseObjectInfo(payload_scheme=VendorDidGetScheme),
                responses.ValidationErrorResponse(),

            ),
            security=self.get_security(method='post'),
            ext_body_parameters=ext_body_parameters
        )


# --- VendorDid


# +++ DidBillingRel
class DidRepositoryCreate(DnlCreate):
    scheme_class = DidRepositoryScheme
    entity = 'DidRepository'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        task_api = DidNumberUploadTaskCreate()
        vendor_name = req.data.get('did_vendor_name', None)
        if vendor_name:
            vendor = model.Resource.filter(model.Resource.alias == vendor_name).first()
            if vendor:
                req.data['vendor_trunk_id'] = vendor.resource_id
        vendor_billing_plan_name = req.data.get('vendor_billing_rule_name', None)
        if vendor_billing_plan_name:
            billing_plan = model.DidBillingPlan.filter(model.DidBillingPlan.name == vendor_billing_plan_name).first()
            if billing_plan:
                req.data['vendor_billing_plan_id'] = billing_plan.id
        req.files = {}
        req.data['op_method'] = 'Upload'
        task_api.on_post(req, resp, **kwargs)
        resp.body = task_api.resp.body
        resp.status = task_api.resp.status
        # return self._on_post(req, resp, **kwargs)

    # def after_create(self, object_id, req, resp, **kwargs):
    #     did_assignments = model.DidAssignments()
    #     obj = model.DidRepository.get(object_id)
    #     obj.created_by = 0
    #     did_assignments.created_by = 0
    #     did_assignments.did = obj.did
    #     did_assignments.vendor_trunk_id = obj.vendor_id
    #     did_assignments.vendor_billing_plan_id = obj.vendor_billing_plan_id
    #     client_trunk = model.Resource.filter(model.Resource.alias == self.req_data['did_client_name']).first()
    #     client_billing_rule = model.DidBillingPlan.filter(model.DidBillingPlan.name == self.req_data['client_billing_rule_name']).first()
    #     did_assignments.client_trunk_id = client_trunk.resource_id
    #     did_assignments.client_billing_plan_id = client_billing_rule.id
    #     did_assignments.save()

    #     did_repository_log = model.DidRepositoryLog()
    #     did_repository_log.did = obj.did
    #     did_repository_log.vendor_id = obj.vendor_id
    #     did_repository_log.vendor_billing_plan_id = obj.vendor_billing_plan_id
    #     did_repository_log.created_at = obj.created_at
    #     did_repository_log.created_by = obj.created_by


class DidRepositoryResource(DnlResource):
    model_class = model.DidRepository
    scheme_class = DidRepositoryScheme
    scheme_class_get = DidRepositoryGetScheme
    scheme_class_modify = DidRepositoryModifyScheme
    entity = 'DidRepository item'
    id_field = 'id'
    has_update_by = False
    unique_field = 'did'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = True
    has_modify_operation = True
    has_info_operation = True

    def on_patch(self, req, resp, **kwargs):
        task_api = DidNumberUploadTaskCreate()
        obj = model.DidRepository.get(kwargs['id'])
        if not obj:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return
        if 'actions' in req.data:
            obj.actions = req.data['actions']
            # obj.actions.save()
        req.data['paste'] = obj.did
        req.files = {}
        req.data['vendor_billing_rule_name'] = obj.vendor_billing_rule_name
        req.data['did_vendor_name'] = obj.did_vendor_name
        req.data['op_method'] = 'Assign'
        task_api.on_post(req, resp, **kwargs)
        resp.body = task_api.resp.body
        resp.status = task_api.resp.status

    def on_delete(self, req, resp, **kwargs):
        task_api = DidNumberUploadTaskCreate()
        obj = model.DidRepository.get(kwargs['id'])
        if not obj:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return
        req.data['paste'] = obj.did
        req.files = {}
        req.data['vendor_billing_rule_name'] = obj.vendor_billing_rule_name
        req.data['did_vendor_name'] = obj.did_vendor_name
        req.data['op_method'] = 'Delete'
        task_api.on_post(req, resp, **kwargs)
        resp.body = task_api.resp.body
        resp.status = task_api.resp.status

    def on_post(self, req, resp, **kwargs):
        task_api = DidNumberUploadTaskCreate()
        # obj = model.DidRepository.get(kwargs['id'])
        # if not obj:
        #     self.set_response(resp, responses.ObjectNotFoundErrorResponse())
        #     return
        req.data['paste'] = req.data.pop('vendor_billing_rule_name')
        req.files = {}
        # req.data['vendor_billing_rule_name'] = obj.vendor_billing_rule_name
        # req.data['did_vendor_name'] = obj.did_vendor_name
        req.data['op_method'] = 'Upload'
        task_api.on_post(req, resp, **kwargs)
        resp.body = task_api.resp.body
        resp.status = task_api.resp.status


class DidRepositoryList(DnlList):
    model_class = model.DidRepository
    scheme_class = DidRepositoryGetScheme
    entity_plural = 'DidRepository items'

    def on_filter_did(self, q, val, kwargs):
        cls = self.model_class
        pat = val.replace('*', '%').replace('x', '_') + '%'
        pat1 = '_' + pat
        filt = or_(cls.did.like(pat), cls.did.like(pat1))
        q = q.filter(filt)
        return q
    
    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        assigned_val = filtering.pop('assigned', None)
        filt, query = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        if assigned_val is not None:
            val = str(assigned_val).lower()
            cls = self.model_class

            if val == 'true':
                query = query.join(cls.did_assignment)
            elif val == 'false':
                query = query.outerjoin(cls.did_assignment).filter(cls.did_assignment == None)
            else:
                raise Exception(f"Invalid value for 'assigned': {assigned_val}")

        return filt, query


class DidAssignmentsList(DnlList):
    model_class = model.DidAssignments
    scheme_class = DidAssignmentsGetScheme
    entity_plural = 'DidAssignments items'

    def on_filter_did(self, q, val, kwargs):
        cls = self.model_class
        pat = val.replace('*', '%').replace('x', '_') + '%'
        pat1 = '_' + pat
        filt = or_(cls.did.like(pat), cls.did.like(pat1))
        q = q.filter(filt)
        return q

class VendorDidCount(CustomGetAction):
    description = "Get did repository count of vendor"
    path_parameters = ({'name': 'vendor_id', 'description': 'did vendor_id'},)
    allow_methods = ["get"]

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        params = dict(parse_qsl(req.query_string))
        try:
            did_count = model.DidRepository.filter(model.DidRepository.vendor_id == int(kwargs['vendor_id'])).count()
            resp.body = json.dumps({"did_count": did_count, 'vendor_id': int(kwargs['vendor_id'])})
            resp.status = falcon.HTTP_200
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


class ClientDidAssignCount(CustomGetAction):
    description = "Get did assignment count of client"
    path_parameters = ({'name': 'client_id', 'description': 'did assignment client_id'},)
    allow_methods = ["get"]

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        params = dict(parse_qsl(req.query_string))
        try:
            #did_count = model.DidAssignments.filter(model.DidAssignments.client_id == int(kwargs['client_id'])).count()
            sql = """
                select count(*) from did_assignments where client_id = {}
            """.format(kwargs['client_id'])
            did_count = model.get_db().engine.execute(sql).fetchone()[0]
            resp.body = json.dumps({"did_count": did_count, 'client_id': int(kwargs['client_id'])})
            resp.status = falcon.HTTP_200
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


class DidRepositoryAssign(CustomPostAction):
    scheme_class = DidApiAdminAssignScheme
    path_parameters = ()
    # additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=DidApiOrderLocalGetScheme),)
    id_field = 'id'
    body_parameters = ('Assign', scheme_class,)
    path_parameters = ({'name': 'id', 'description': 'id of did repository to assign'},)

    def on_post(self, req, resp, **kwargs):
        from kombu.exceptions import OperationalError
        # vendors = _get_all_vendors(True, 'local')
        # if not vendors:
        #     self.set_response(resp, responses.ObjectNotFoundErrorResponse())
        #     return
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            self.set_response(resp, responses.ForbiddenErrorResponse())
            return
        user = self.get_user(self.req)
        if not user.is_admin:
            self.set_response(resp, responses.UnAuthorizedErrorResponse())
            return

        task_api = DidNumberUploadTaskCreate()
        obj = model.DidRepository.get(kwargs['id'])
        if not obj:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return

        req.data['paste'] = obj.did
        req.files = {}
        # req.data['vendor_billing_rule_name'] = obj.vendor_billing_rule_name
        # req.data['did_vendor_name'] = obj.did_vendor_name
        req.data['op_method'] = 'Assign'
        task_api.on_post(req, resp, **kwargs)
        resp.body = task_api.resp.body
        resp.status = task_api.resp.status


class DidBillingRelCreate(DnlCreate):
    scheme_class = DidBillingRelScheme
    entity = 'DidVendor'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        if not 'client_id' in req.data:
            kwargs['client_id'] = None
        else:
            kwargs['client_id'] = req.data['client_id']
            del req.data['client_id']
        return super(DidBillingRelCreate, self).on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        # obj.created_time = datetime.now(UTC)
        cls = model.DidBillingRel
        did = cls.filter(and_(cls.did == obj.did, cls.end_date.is_(None), cls.start_date.isnot(None))).first()
        if not obj.id:
            if did:
                raise ValidationError('Did {} already exists !'.format(obj.did))
        did = cls.filter(and_(cls.did == obj.did, cls.end_date.is_(None), cls.is_available == False)).first()
        if did:
            raise ValidationError('Did {} already assigned to another client !'.format(obj.did))

        if not 'client_res_id' in kwargs:
            if not 'client_id' in kwargs or kwargs['client_id'] in (None, '', 'null', 'None'):
                obj.client_res_id = None
                if obj.is_available is None:
                    obj.is_available = True
                if obj.vendor_res_id:
                    vendor_id = model.Resource.get(obj.vendor_res_id).client_id
                    model.DidVendorLog.on_create_did(obj.did, vendor_id, user.user_id, 'UI Entry')
                elif obj.vendor_id:
                    vendor = model.Client.get(obj.vendor_id)
                    if vendor.vendor_res_id:
                        res = model.Resource.get(vendor.vendor_res_id)
                    obj.vendor_res = res
                return obj
            client_id = kwargs['client_id']
            client = model.Client.get(client_id)  # model.Client.get(client_id)
            if not client:
                raise ValidationError('Bad did client {} '.format(client_id))
        else:
            client = model.Client.get(model.Resource.get(kwargs['client_res_id']).client_id)

        if obj.client_res_id and not obj.sell_billing_plan_id:
            raise ValidationError("if client is selected client billing rule should be selected as well.")
        if not obj.buy_billing_plan_id:
            # return obj
            raise ValidationError('No client billing rule {} '.format(obj.sell_billing_plan_id))
        rule = model.DidBillingPlan.get(obj.sell_billing_plan_id)
        if not rule:
            raise ValidationError('Bad client billing rule {} '.format(obj.sell_billing_plan_id))
        if True:  # not user.is_admin:
            cost = rule.did_price
            if client.mode == 'postpay' and \
                    client.balance() + client.allowed_credit < cost and not client.unlimited_credit:
                raise Exception('Due to insufficient balance you can not order this DID.')
            if client.mode == 'prepay' and client.balance() < cost:
                raise Exception('Due to insufficient balance you can not order this DID.')

        if not obj.vendor_res_id and obj.vendor_id and obj.buy_billing_plan_id:
            buy_rule = model.DidBillingPlan.get(obj.buy_billing_plan_id)
            vendor = model.Client.get(obj.vendor_id)
            if vendor.vendor_res_id:
                res = model.Resource.get(vendor.vendor_res_id)
            else:
                res = vendor.get_assigned_billing_plan_resource(buy_rule, obj.ip)
            obj.vendor_res = res
            prefix = res.assign_vendor_did_prefix(obj.did, buy_rule.rate_table)
            prefix.save()

        model.DidClientLog.on_assign_did(obj.did, client.client_id, user.user_id, 'UI Entry')

        old = model.DidBillingRel.filter(model.DidBillingRel.did == obj.did).filter(
            model.DidBillingRel.end_date.is_(None)).all()
        for o in old:
            if o.id == obj.id:
                continue
            o.on_end_date()
            o.end_date = datetime.utcnow().replace(microsecond=0)
            o.is_available = False
            o.save()
        res = client.get_assigned_billing_plan_resource(rule, obj.ip)
        res.update_by = self.get_user().name
        res.save()
        model.ProductItems.assign_client_did(res, obj.did, self.get_user().name)
        obj.client_res = res
        # obj.is_available = False
        obj.did_billing_id = obj.buy_billing_plan_id
        if obj.vendor_res_id:
            vendor_id = model.Resource.get(obj.vendor_res_id).client_id
            model.DidVendorLog.on_create_did(obj.did, vendor_id, user.user_id, 'UI Entry')
            if obj.vendor_billing_rule_id:
                vendor_billing_rule = model.DidBillingPlan.get(obj.vendor_billing_rule_id)
                rate_table = vendor_billing_rule.rate_table
                vendor_res = model.Resource.get(obj.vendor_res_id)
                prefix = vendor_res.assign_vendor_did_prefix(obj.did, rate_table)
                prefix.save()

        obj.start_date = datetime.utcnow().replace(microsecond=0)
        obj.save()
        try:
            if obj.buy_billing_plan_id and obj.client_res_id:
                plan = model.DidBillingPlan.get(obj.buy_billing_plan_id)
                client_id = model.Resource.get(obj.client_res_id).client_id
                model.DidBillingOperationAction(did_billing_id=obj.id, created_by=self.get_user().name).save()
                # if plan.setup_fee:
                #     model.ClientBalanceOperationAction(client_id=client_id, balance=plan.setup_fee,
                #                                        egress_balance=plan.setup_fee,
                #                                        action=5,
                #                                        create_by='did_setup_fee_on_assign').save()
        except Exception as e:
            log.debug('did_billing_rel created, but deducting setupo fee errors: {}'.format(e))
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        obj = model.DidBillingRel.get(object_id)
        # obj.active = True


class DidBillingRelImport(DidBillingRelCreate):
    scheme_class = DidBillingRelImportScheme
    import_key_fields = ('did', 'end_date')
    # def before_create(self, obj, **kwargs):
    #    return super(DidBillingRelImport,self).before_create( obj, **kwargs)
    pass


class DidBillingRelResource(DnlResource):
    model_class = model.DidBillingRel
    scheme_class = DidBillingRelScheme
    scheme_class_get = DidBillingRelGetScheme
    scheme_class_modify = DidBillingRelModifyScheme
    entity = 'DidRepository item'
    id_field = 'id'
    has_update_by = False
    unique_field = 'did'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_delete(self, req, resp, model_class, **kwargs):
        obj = self.model_class.get(kwargs['id'])
        if obj and obj.end_date is None:
            user = self.get_user(self.req)
            if obj.vendor_res_id:
                vendor_id = model.Resource.get(obj.vendor_res_id).client_id
                model.DidVendorLog.on_delete_did(obj.did, user.user_id, 'UI Entry')
            if obj.client_res_id:
                client_id = model.Resource.get(obj.client_res_id).client_id
                model.DidClientLog.on_release_did(obj.did, user.user_id, 'UI Entry')
            obj.on_end_date()

    def get_object_data(self, resp, model_class, scheme_class_get, **kwargs):
        if self.req_data and '_obj_id' in self.req_data:
            kwargs['id'] = self.req_data['_obj_id']
        return super(DidBillingRelResource, self).get_object_data(resp, model_class, scheme_class_get, **kwargs)

    def before_update(self, obj, req):
        user = self.get_user(req)
        if obj.end_date and obj.end_date < datetime.now(UTC):
            raise ValidationError(
                'The DID [{}] has already been end-dated on {}.  Please create a new record instead.'.format(obj.did,
                                                                                                             obj.end_date))
        client_id = None
        data = req.data
        if 'client_res_id' in data and data['client_res_id'] != None and not 'client_billing_rule_id' in data:
            raise Exception("if client is selected client billing rule should be seleted as well.")

        if 'vendor_res_id' in data and data['vendor_res_id'] and not obj.vendor_res_id:
            model.ResourcePrefix.filter(model.ResourcePrefix.code == obj.did). \
                update({'resource_id': data['vendor_res_id']}, synchronize_session='fetch')
            vendor_id = model.Resource.get(int(data['vendor_res_id'])).client_id
            model.DidVendorLog.on_create_did(obj.did, vendor_id, user.user_id, 'UI Entry')
        if 'vendor_id' in data and data['vendor_id']:
            vendor_id = int(data['vendor_id'])
            rule = model.DidBillingPlan.get(obj.buy_billing_plan_id) if obj.buy_billing_plan_id else None
            vendor = model.Client.get(vendor_id)
            if vendor.vendor_res_id:
                res = model.Resource.get(vendor.vendor_res_id)
            else:
                res = vendor.get_assigned_billing_plan_resource(rule, obj.ip)
            model.ResourcePrefix.filter(model.ResourcePrefix.code == obj.did). \
                update({'resource_id': res.resource_id}, synchronize_session='fetch')
            obj.vendor_res = res

        if 'client_id' in data and data['client_id'] and obj.client_id != data['client_id']:
            if 'client_billing_rule_id' in data:
                obj.sell_billing_plan_id = data['client_billing_rule_id']
            if obj.client_id:
                model.DidClientLog.on_release_did(obj.did, user.user_id, 'UI Entry', obj.client_id)
            model.DidClientLog.on_assign_did(obj.did, int(data['client_id']), user.user_id, 'UI Entry')
            obj.is_assigned = True

        if 'client_res_id' in data and data['client_res_id'] == None:
            obj.egress_res_id = None

        if 'client_id' in data and data['client_id']:
            client_id = data['client_id']
        else:
            client_id = obj.client_id

        if 'client_id' in data and not data['client_id']:
            model.DidBillingRel.did_billing_rel_disconnect(
                obj.did, None, None, user_name=user.name)
        elif client_id and 'client_res_id' in data and data['client_res_id'] != None:
            client = model.Client.get(data['client_id'])
            rule = model.DidBillingPlan.get(data['client_billing_rule_id'])
            res = client.get_assigned_billing_plan_resource(rule, obj.ip)
            res.update_by = self.get_user().name
            res.save()
            model.ProductItems.assign_client_did(res, obj.did, self.get_user().name)
            obj.client_res = res

        if client_id:
            client = model.Client.get(client_id)
            if 'vendor_billing_rule_id' in data:
                rule = model.DidBillingPlan.get(data['vendor_billing_rule_id'])
            elif obj.buy_billing_plan_id:
                rule = model.DidBillingPlan.get(obj.buy_billing_plan_id)
            else:
                rule = None
            if not rule:
                raise ValidationError('Bad client billing rule {} '.format(obj.buy_billing_plan_id))
            cost = rule.did_price
            if client.mode == 'postpay' and \
                    client.balance() - client.allowed_credit < cost and not client.unlimited_credit:
                raise Exception('Due to insufficient balance you can not order this DID.')
            if client.mode == 'prepay' and (client.balance() or 0) < cost:
                raise Exception('Due to insufficient balance you can not order this DID.')

            data = req.data
            scheme_errors = self.scheme_class_modify().validate(data)
            if scheme_errors:
                return None
            # new_obj = obj

            # if not obj.client_id and not obj.start_date and False:
            #     self.req_data['_obj_id_to_delete'] = obj.id
            # else:
            #     # obj.on_end_date()
            #     obj.delete()
            # replace old with new
            # obj = self.scheme_class_modify().load(data, instance=new_obj).data
            obj.start_date = datetime.utcnow().replace(microsecond=0)
            # cr = DidBillingRelCreate()
            # cr.req = self.req
            # obj = cr.before_create(obj, client_id=client_id)
            # self.req_data['_obj_id'] = obj.save()
            # obj = self.model_class.get(self.req_data['_obj_id'])
            if rule:
                plan = rule
                if plan.setup_fee:
                    model.ClientBalanceOperationAction(client_id=client_id, balance=plan.setup_fee,
                                                        egress_balance=plan.setup_fee,
                                                        action=5,
                                                        create_by='did_setup_fee_on_assign').save()
        return obj

    def after_update(self, result, obj, data):
        if '_obj_id_to_delete' in self.req_data:
            model.DidBillingRel.filter(model.DidBillingRel.id == self.req_data['_obj_id_to_delete']).delete(
                synchronize_session='fetch')
            model.DidBillingRel.session().commit()


class DidBillingRelMassAssign(CustomPatchAction):
    model_class = model.DidRepository
    scheme_class = DidBillingRelMassAssignScheme
    entity = 'DidRepository items'
    body_parameters = ('Assign to', DidBillingRelMassAssignScheme)
    additional_responses = (responses.SuccessResponseObjectInfo(payload_scheme=ObjectUpdatedScheme),)

    def proceed(self, req, resp, **kwargs):
        task_api = DidNumberUploadTaskCreate()
        # obj = model.DidRepository.get(kwargs['id'])
        # if not obj:
        #     self.set_response(resp, responses.ObjectNotFoundErrorResponse())
        #     return
        client_id = req.data.pop('client_trunk_id', None)
        if client_id:
            client = model.Resource.get(client_id)
            if client:
                req.data['did_client_name'] = client.alias
        client_id = req.data.pop('client_id', None)
        if client_id:
            client = model.Client.get(client_id)
            req.data['did_client_name'] = client.name
        client_billing_rule_id = req.data.pop('client_billing_rule_id', None)
        if client_billing_rule_id:
            billing_plan = model.DidBillingPlan.get(client_billing_rule_id)
            if billing_plan:
                req.data['client_billing_rule_name'] = billing_plan.name
        req.data['paste'] = ','.join(req.data.pop('dids'))
        req.files = {}
        # req.data['vendor_billing_rule_name'] = obj.vendor_billing_rule_name
        # req.data['did_vendor_name'] = obj.did_vendor_name
        req.data['op_method'] = 'Assign'
        task_api.on_post(req, resp, **kwargs)
        resp.body = task_api.resp.body
        resp.status = task_api.resp.status

    def apply(self, obj, req, resp, **kwargs):
        user = self.get_user()
        errors = self.scheme_class().validate(req.data)
        if errors:
            raise ValidationError(errors)
        dids = req.data.get('dids', [])

        if 'src_client_id' in req.data and req.data['src_client_id'] is None:
            src_client_id = None
        else:
            src_client_id = int(req.data.get('src_client_id', 0))

        if 'client_id' in req.data and req.data['client_id'] is None:
            client_id = None
        else:
            client_id = int(req.data.get('client_id', 0))

        if 'client_billing_rule_id' in req.data and req.data['client_billing_rule_id'] is None:
            client_billing_rule_id = None
        else:
            client_billing_rule_id = int(req.data.get('client_billing_rule_id', 0))

        if 'assigned_client_id' in req.data and req.data['assigned_client_id'] is None:
            assigned_client_id = None
        else:
            assigned_client_id = int(req.data.get('assigned_client_id', 0))

        client_res_id = None
        client_resource = None
        cls = model.DidBillingRel
        res = model.Resource
        if client_id:
            client = model.Client.get(req.data['client_id'])
            if not client:
                raise ValidationError('Bad client id {} '.format(client_id))
            if client_billing_rule_id:
                rule = model.DidBillingPlan.get(client_billing_rule_id)
                if not rule:
                    raise ValidationError('Bad client billing rule {} '.format(client_billing_rule_id))

                client_resource = client.get_assigned_billing_plan_resource(rule, None)
                client_res_id = client_resource.save()
            else:
                client_res_id = client.resource.resource_id
                client_resource = res.get(client_res_id)
        result = 0
        ret = []
        rskip = []
        for did in dids:
            old = cls.filter(and_(cls.end_date.is_(None), cls.did == did)).first()
            if not old:
                rskip.append(dict(did=did, err='not found'))
                continue
            if src_client_id and old.client_id != src_client_id:
                rskip.append(dict(did=did, err='wrong src'))
                continue
            try:
                obj = old

                if client_id is None:
                    obj.client_res_id = None
                elif client_res_id:
                    obj.client_res_id = client_res_id
                obj.did_billing_id = obj.buy_billing_plan_id
                # item.is_available = False
                if client_billing_rule_id:
                    obj.client_billing_rule_id = client_billing_rule_id
                obj.save()
                if client_resource:
                    item = model.ProductItems.assign_client_did(client_resource, old.did, self.get_user(req).name)
                    # model.ProductItems.session().commit()
                    item.save()
                if obj.vendor_res_id:
                    vendor_id = model.Resource.get(obj.vendor_res_id).client_id
                    if obj.vendor_billing_rule_id:
                        vendor_billing_rule = model.DidBillingPlan.get(obj.vendor_billing_rule_id)
                        rate_table = vendor_billing_rule.rate_table
                        vendor_res = model.Resource.get(obj.vendor_res_id)
                        prefix = vendor_res.assign_vendor_did_prefix(obj.did, rate_table)
                        prefix.save()
                ret.append(old.did)
                result += 1
            except Exception as e:
                rskip.append(dict(did=did, err=str(e)))

        self.set_response(resp,
                          responses.SuccessResponseObjectInfo(data={'updated': result, 'items': ret, 'errors': rskip}))

        return False


class DidBillingRelList(DnlList):
    model_class = model.DidBillingRel
    scheme_class = DidBillingRelGetScheme
    entity_plural = 'DidRepository items'
    large_list_fields = ['id', 'did', 'client_res_id', 'client_billing_rule_id', 'vendor_res_id',
                         'vendor_billing_rule_id', 'assigned_date', 'end_date']

    # def on_filter_did(self, q, val, kwargs):
    #     q = q.join(model.ResourceExt, model.ResourceExt.resource_id == model.DidBillingRel.ingress_res_id). \
    #         filter(or_(model.DidBillingRel.did == val,
    #                    func.concat(model.ResourceExt.vendor_tech_prefix, model.DidBillingRel.did) == val))

    #     return q

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(DidBillingRelList, self).modify_query_from_ordering_for_list(ordering, query, **kwargs)
        cls = self.model_class
        if ordering and 'by' in ordering:
            if ordering['by'] == 'did':
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    query = query.order_by(func.length(cls.did)).order_by(cls.did)
                else:
                    query = query.order_by(func.length(cls.did).desc()).order_by(cls.did.desc())
        return ordering, query

    def on_filter_did_client_name(self, q, val, kwargs):
        cls = self.model_class
        if val in ('none', 'null'):
            q = q.filter(cls.did_client_name.is_(None))
        else:
            q = q.filter(cls.did_client_name == val)
        return q

    def on_filter_did(self, q, val, kwargs):
        # todo search did pattern
        cls = self.model_class
        pat = val.replace('*', '%').replace('x', '_') + '%'
        pat1 = '_' + pat
        filt = or_(cls.did.like(pat), cls.did.like(pat1))
        q = q.filter(filt)
        return q

    # def on_filter_ip(self, q, val, kwargs):
    #     cls = self.model_class
    #     q = q.filter(or_(cls.ip.is_(None), cls.ip == val))
    #     return q

    def on_filter_vendor_tech_prefix(self, q, val, kwargs):
        filter = val + '%'
        q = q.filter(model.DidBillingRel.did.like(filter))
        return q

    def on_filter_active(self, q, val, kwargs):
        product_items = model.ProductItems.session().query(model.ProductItems.digits).all()
        digits = [product_item.digits for product_item in product_items]
        if val in ('true', 'True', True):
            q = q.filter(self.model_class.did.in_(digits))
        else:
            q = q.filter(self.model_class.did.notin_(digits))
        return q

    def on_filter_is_available(self, q, val, kwargs):
        if val in ('true', 'True', True):
            q = q.filter(and_(self.model_class.is_available == True, self.model_class.client_res_id.is_(None)))
        else:
            q = q.filter(or_(self.model_class.is_available == False, self.model_class.client_res_id.isnot(None)))
        return q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(DidBillingRelList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


class DidBillingRelAvailableList(DnlList):
    model_class = model.DidBillingRel
    scheme_class = DidBillingRelAvailableGetScheme
    entity_plural = 'Available DidRepository items'

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        f, q = super(DidBillingRelAvailableList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        q = q.filter(and_(cls.is_available == True, cls.client_res_id.is_(None)))
        return f, q


class DidRepositoryActiveList(DnlList):
    model_class = model.DidRepository
    scheme_class = DidRepositoryGetScheme
    entity_plural = 'Active DidRepository items'

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        f, q = super(DidRepositoryActiveList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        q = q.filter(cls.is_available == True)
        return f, q

    def on_filter_active(self, query, value, kwargs):
        dids = model.ProductItems.session().query(model.ProductItems.digits).all()
        dids = [str(did.digits) for did in dids]
        return query.filter(self.model_class.did.in_(dids) == value)


class DidParamUpdate(CustomPostAction):
    model_class = model.DidBillingRel
    scheme_class = DidBillingRelGetScheme
    path_parameters = ({'name': 'action', 'description': 'all/missing'},)

    def apply(self, obj, req, resp, action, **kwargs):
        if action not in ('all', 'missing'):
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'action {} not found!'.format(action)}))
            return True

        from .task.did_import_file import did_param_update
        from kombu.exceptions import OperationalError
        try:
            log.debug('did_param_update {} try to schedule'.format(action))
            did_param_update.delay(action)
            log.info('did_param_update task scheduled {}'.format(action))
        except OperationalError as e:
            log.error('did_param_update {} start online:{}'.format(action, str(e)))
            did_param_update(action)
            log.debug('did_param_update {} finished '.format(action))
        self.set_response(resp, responses.SuccessResponseJustOk())
        return False


# --- DidBillingRel

# --- DidRouting (ProductItemsForDid)
class ProductItemsForDidList(DnlList):
    model_class = model.ProductItems
    scheme_class = ProductItemsForDidGetScheme
    entity_plural = 'DidStaticRouting items'

    # unique_field = 'client_id'
    # additional_responses = ()
    # path_parameters = ()
    # security = (DEFAULT_SECURITY)
    # restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ProductItemsForDidList, self).get_filtering_for_list(parsed_qs, **kwargs)
        q = model.Product.filter(model.Product.name == 'ORIGINATION_STATIC_ROUTE').first()
        if not q:
            raise ValidationError(
                'Product with name "ORIGINATION_STATIC_ROUTE"  not exists! Create it first for did routing!')
        ret['product_id'] = str(q.product_id)
        return ret


# --- DidRouting

# +++ ClientCredit
class ClientCreditResource(DnlResource):
    model_class = model.Client
    scheme_class = ClientCreditScheme
    scheme_class_get = ClientCreditSchemeGet
    scheme_class_modify = ClientCreditScheme
    entity = 'ClientCredit'
    id_field = 'client_id'
    has_update_by = True
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ClientCreditList(DnlList):
    scheme_class = ClientCreditSchemeGet
    model_class = model.Client
    entity_plural = 'ClientCredits'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):
        super().on_get(req, resp, **kwargs)
        data = json.loads(resp.body)
        if "payload" in data and "items" in data["payload"]:
            for item in data['payload']['items']:
                client = model.Client.get(item['client_id'])
                last_payment = client.last_payment()
                last_invoice = client.last_invoice()
                item['last_payment'] = {}
                item['last_invoice_date'] = None
                if last_invoice:
                    item['last_invoice_date'] = str(last_invoice.invoice_time)
                if last_payment:
                    item['last_payment'] = {
                        "invoice_number": last_payment.invoice_number,
                        "amount": float(last_payment.amount),
                        "note": last_payment.note,
                        "payment_type": last_payment.payment_type,
                        "paid_on": str(last_payment.paid_on)
                    }
                    # item['last_invoice_number'] = last_payment.invoice_number
                    # item['last_invoice_amount'] = float(last_payment.amount)
            resp.body = json.dumps(data)

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        f, q = super(ClientCreditList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        q = q.filter(or_(cls.client_type.is_(None), cls.client_type == 'client'))
        return f, q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ClientCreditList, self).get_filtering_for_list(parsed_qs, **kwargs)
        if 'billing_mode' in ret:
            if ret['billing_mode'] == 'prepay':
                ret['mode'] = 'prepay'
            else:
                ret['mode'] = 'postpay'
            del ret['billing_mode']
        return ret


# -- ClientCredit

# ------------ Carrier Regenerate Balance
class CarrierRegenerateBalanceAction(resources.CustomAction):
    scheme_class = BaseModelScheme
    model_class = model.Client
    description = 'Edit mail template'
    path_parameters = ({'name': 'client_id', 'description': 'Carrier to regenerate'},)
    method = 'path'

    def on_path(self, req, resp, **kwargs):
        req['client_id'] = kwargs['client_id']
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        obj.regenerate_balance()


# ------

class CarrierLowBalanceConfigResource(DnlResource):
    model_class = model.CarrierLowBalanceConfig
    scheme_class = CarrierLowBalanceConfigScheme
    scheme_class_get = CarrierLowBalanceConfigScheme
    scheme_class_modify = CarrierLowBalanceConfigScheme
    entity = 'CarrierLowBalanceConfig'
    id_field = 'client_id'
    has_delete_operation = False
    has_update_by = False
    # unique_field='name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    # path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)

    def before_create(self, obj, **kwargs):
        obj.client_id = kwargs['client_id']
        return obj

    def on_get(self, req, resp, **kwargs):
        cli = model.Client.get(kwargs['client_id'])
        if not cli:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Client {} not found!'.format(kwargs['client_id'])}))
            return None
        if not self.get_object(resp, self.model_class(), **kwargs):
            oid = self.model_class(client_id=kwargs['client_id']).save()
        return super(CarrierLowBalanceConfigResource, self).on_get(req, resp, **kwargs)

    def on_patch(self, req, resp, **kwargs):
        cli = model.Client.get(kwargs['client_id'])
        if not cli:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Client {} not found!'.format(kwargs['client_id'])}))
            return None
        self.init_req(req)
        if not self.get_object(resp, self.model_class(), **kwargs):
            oid = self.model_class(client_id=kwargs['client_id']).save()
        return super(CarrierLowBalanceConfigResource, self).on_patch(req, resp, **kwargs)


# ------------
class CarrierCreate(DnlCreate):
    scheme_class = CarrierScheme
    entity = 'Carrier'
    unique_field = 'client_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.name = str(obj.name).strip()
        un = obj.login
        if un:  
            if model.User.filter(and_(model.User.name == un)).first():
                raise ValidationError(
                    'username "{}" already exists (see user list ), cannot create such name!'.format(un))
            if not obj.password:
                obj.password = obj.name
            obj.user = model.User(name=obj.login, passwd=obj.password, user_type='client', role_id=1)

        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.create_time = datetime.now(UTC)
        if obj.client_type is None:
            obj.client_type = 'client'
        if obj.company_type is None:
            obj.company_type = 'termination'
        return obj

    def create_object(self, req, scheme, **kwargs):
        if not 'profit_type' in req.data:
            req.data['profit_type'] = 'percentage'
        if not 'auto_invoice_type' in req.data:
            req.data['auto_invoice_type'] = 'buy'
        if 'login' in req.data and (req.data['login'] == '' or req.data['login'] == 'null'):
            del req.data['login']

        data = resources.BaseResource.create_object(self, req, scheme, **kwargs)
        # if hasattr(scheme._test_credit_value) and scheme.test_credit_value:
        #    pay=model.ClientPayment(client_id=data,amount=scheme.test_credit_value)
        #    pay.save()
        obj = model.Client.get(data)

        obj.apply_mail('welcome')
        return data


class CarrierLongCreate(DnlCreate):
    scheme_class = CarrierLongScheme
    entity = 'Carrier'
    unique_field = 'client_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        self.client_invoice_settings_id = req.data.pop('client_invoice_settings_id', None)
        return super().on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):
        # del kwargs['fake']
        # raise Exception(str(obj.__dict__))
        if not 'profit_type' in self.req_data:
            obj.profit_type = 'percentage'
        else:
            obj.profit_type = self.req_data['profit_type'].lower()
        if not 'auto_invoice_type' in self.req_data:
            obj.auto_invoice_type = 'buy'
        if 'login' in self.req.data and (self.req_data['login'] == '' or self.req_data['login'] == 'null'):
            del self.req_data['login']
        if 'tax' in self.req.data and (self.req_data['tax'] == '' or self.req_data['tax'] == 'null'):
            del self.req_data['tax']
        if 'cps_limit' in self.req.data and (self.req_data['cps_limit'] == '' or self.req_data['cps_limit'] == 'null'):
            del self.req_data['cps_limit']
        if 'profit_margin' in self.req.data and (
                self.req_data['profit_margin'] == '' or self.req_data['profit_margin'] == 'null'):
            self.req_data['profit_margin'] = 0
            obj.profit_margin = 0

        obj.name = str(obj.name).strip()

        un = obj.login
        if un:
            if model.User.filter(and_(model.User.name == un)).first():
                raise ValidationError(
                    'username "{}" already exists (see user list ), cannot create such name!'.format(un))
            if not obj.password:
                obj.password = obj.name
            obj.user = model.User(name=obj.login, passwd=obj.password, user_type='client', role_id=1)

        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        obj.create_time = datetime.now(UTC)
        if obj.client_type is None:
            obj.client_type = 'client'
        if obj.company_type is None:
            obj.company_type = 'termination'
        if obj.company_type in ('origination', 'both termination and origination'):
            if model.Resource.filter(model.Resource.alias == obj.name).first():
                raise ValidationError(
                    'trunk "{}" already exists (see trunk list ), cannot create such name!'.format(obj.name))
            r = model.Resource(name=obj.name)
            if r:
                r.profit_type = obj.billing_method
                r.name = obj.name
                r.alias = obj.name
                r.egress = True
                r.ingress = False
                r.trunk_type2 = 'DID Traffic'
                r.update_by = self.get_user().name
                r.update_at = datetime.now(UTC)
                r.create_time = obj.update_at
                obj.resources.append(r)
        # obj.apply_mail('welcome')

        return obj

    def after_create(self, obj_id, req, resp, **kwargs):
        client = model.Client.get(obj_id)
        ext = model.ClientInvoiceSetting(client_id=obj_id)
        ext.invoice_setting_id = self.client_invoice_settings_id
        client.session().add(ext)


# def create_object(self, req, scheme, **kwargs):
# raise Exception(str(self.req_data)+str(kwargs))
#    data = resources.BaseResource.create_object(self, req, scheme, **kwargs)
# if hasattr(scheme.test_credit_value) and scheme.test_credit_value:
#    pay=model.ClientPayment(client_id=data,amount=scheme.test_credit_value)
#    pay.save()
#    return data


class CarrierCreateFromTemplate(DnlCreate):
    scheme_class = CarrierFromTemplateScheme
    entity = 'Carrier'
    unique_field = 'client_id'
    additional_responses = ()
    path_parameters = ({'name': 'id', 'description': 'Carrier template for creation'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.name = str(obj.name).strip()
        obj.create_from_template(obj.name, kwargs['id'])
        obj.update_at = datetime.now(UTC)
        obj.update_by = self.get_user().name
        obj.client_type = 'client'
        obj.company_type = 'termination'
        un = obj.login
        if un:
            if model.User.filter(and_(model.User.name == un)).first():
                raise ValidationError(
                    'username "{}" already exists (see user list ), cannot create such name!'.format(un))
            if not obj.password:
                obj.password = obj.name
            obj.user = model.User(name=obj.login, passwd=obj.password, user_type='client', role_id=1)
        return obj


class CarrierApplyTemplateResource(DnlResource):
    model_class = model.Client
    scheme_class = CarrierGetScheme
    scheme_class_get = CarrierGetUserScheme
    scheme_class_modify = CarrierApplyTemplateScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_update_by = True
    has_delete_operation = False
    has_info_operation = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        obj = super(CarrierApplyTemplateResource, self).get_object(resp, model_class, **kwargs)
        if self.get_user(self.req).is_admin:
            return obj
        if not obj.client_type in ('client', 'vendor'):
            if obj.client_id in self.get_user(self.req).clients_id:
                return obj
        self.set_response(resp, responses.ObjectNotFoundErrorResponse(
            data={'message': 'Carrier {} not found!'.format(kwargs['client_id'])}))
        return None

    def before_update(self, obj, req):
        obj.create_from_template(obj.name, int(req.data['carrier_template_id']))
        obj.update_at = datetime.now(UTC)
        obj.update_by = self.get_user().name
        return obj


class CarrierPasswordResource(DnlResource):
    model_class = model.Client
    scheme_class = CarrierGetScheme
    scheme_class_get = CarrierGetUserScheme
    scheme_class_modify = CarrierPasswordScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_update_by = True
    has_delete_operation = False
    has_info_operation = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        obj = super(CarrierPasswordResource, self).get_object(resp, model_class, **kwargs)
        if self.get_user(self.req).is_admin:
            return obj
        if not obj.client_type in ('client', 'vendor'):
            if obj.client_id in self.get_user(self.req).clients_id:
                return obj
        self.set_response(resp, responses.ObjectNotFoundErrorResponse(
            data={'message': 'Carrier {} not found!'.format(kwargs['client_id'])}))
        return None

    def before_update(self, obj, req):
        if not obj.user:
            log.debug('Client has no user creating new one')
            login = obj.username
            if not login:
                obj.username = obj.name
                login = obj.name
            obj.user = model.User(name=login, passwd=obj.password, user_type='client', role_id=1)
        else:
            obj.user.passwd = req.data['password']
        return obj


class CarrierResource(DnlResource):
    model_class = model.Client
    scheme_class = CarrierGetScheme
    scheme_class_get = CarrierGetScheme
    scheme_class_modify = CarrierModifyScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    # def get_object(self, resp, model_class, **kwargs):
    #     obj = model.Client.get(kwargs['client_id'])
    #     if not obj:
    #         return None
    #     obj = super(CarrierResource, self).get_object(resp, model_class, **kwargs)
    #     if not obj.client_type in ('client', 'vendor'):
    #         o = model.Client.filter(model.Client.user_id_filter(self.get_user(self.req).user_id)).first()
    #         if o:
    #             return obj
    #     self.set_response(resp, responses.ObjectNotFoundErrorResponse(
    #         data={'message': 'Carrier {} not found!'.format(kwargs['client_id'])}))
    #     return None

    def before_update(self, obj, req):
        # if not 'credit_limit' in req.data or req.data['credit_limit'] is None:
        #     obj.credit_limit = 0.0

        if 'login' in req.data or 'password' in req.data:
            login = None
            if 'login' in req.data:
                login = req.data['login']
            password = '*'
            if 'password' in req.data:
                password = req.data['password']
            if model.User.filter(and_(model.User.name == login, model.User.client_id != obj.client_id)).first():
                raise ValidationError('login "{}" already exists (see user list) !'.format(login))

            # if obj.username != un:
            if not obj.user:
                if login:
                    # obj.user = model.User(name=login, passwd=password, user_type='client', client_id=obj.client_id)
                    pass
            else:
                if login:
                    obj.user.name = login
                if password:
                    obj.user.passwd = password
                obj.user.user_type = 'client'
                obj.user.client_id = obj.client_id
                if 'satus' in req.data:
                    obj.user.active = req.data['status']
                if 'is_active' in req.data:
                    obj.user.active = req.data['is_active']
        if 'is_active' in req.data:  # and not obj.is_active:
            is_active = req.data['is_active'] in ('True', 'true', True)
            for r in obj.resources:
                r.active = is_active
                obj.session().add(r)
        if 'enable_auto_invoice' in req.data:
            obj.enable_auto_invoice = req.data['enable_auto_invoice']
        return obj

    def delete_object(self, req, resp, model_class, **kwargs):
        resources = model.Resource.filter(model.Resource.client_id == kwargs['client_id']).all()
        resource_ids = [i.resource_id for i in resources]
        model.ResourceCidBlockConfig.filter(model.ResourceCidBlockConfig.resource_id.in_(resource_ids)).delete(synchronize_session='fetch')
        model.ResourceIp.filter(model.ResourceIp.resource_id.in_(resource_ids)).delete(synchronize_session='fetch')
        model.Resource.filter(model.Resource.client_id == kwargs['client_id']).update({'purged': True},
                                                                                      synchronize_session='fetch')
        return super(CarrierResource, self).delete_object(req, resp, model_class, **kwargs)


class CarrierLongResource(CarrierResource):
    model_class = model.Client
    scheme_class = CarrierLongScheme
    scheme_class_get = CarrierLongGetScheme
    scheme_class_modify = CarrierLongModifyScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = False

    def on_patch(self, req, resp, **kwargs):
        try:
            low_balance_config = req.data.get('low_balance_config', None)
            enable_notification = req.data.get('enable_notification', None)
            if low_balance_config:
                low_balance_config['percentage_notify_balance'] = low_balance_config.pop('percentage_notify_balance',
                                                                                         None) or None
                req.data['low_balance_config'] = low_balance_config
            if enable_notification is not None and enable_notification == False:
                req.data['low_balance_notice'] = False
                req.data['zero_balance_notice'] = False
                req.data['is_send_trunk_update'] = False
            return super().on_patch(req, resp, **kwargs)
        except Exception as e:
            log.debug(f"ERROR - {e}")


class CarrierResourceAll(DnlResourceAll):
    model_class = model.Client
    scheme_class = CarrierActivateScheme
    scheme_class_get = ObjectUpdatedScheme
    entity = 'All Carriers'
    has_update_by = True
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query(self, filt, qs, req, resp, model_class, **kwargs):
        if 'credit_limit_gt' in filt:
            val = filt['credit_limit_gt']
            qs = qs.filter(-model.Client.allowed_credit > val)
            del filt['credit_limit_gt']
        if 'credit_limit_lt' in filt:
            val = filt['credit_limit_lt']
            qs = qs.filter(-model.Client.allowed_credit < val)
            del filt['credit_limit_lt']
        return filt, qs


class ClientDidResourceAll(CarrierResourceAll):
    def modify_query(self, filt, qs, req, resp, model_class, **kwargs):
        filt, qs = super(ClientDidResourceAll, self).modify_query(filt, qs, req, resp, model_class, **kwargs)
        qs = qs.filter(model.Client.client_type == 'client')
        return filt, qs


class VendorDidResourceAll(CarrierResourceAll):
    def modify_query(self, filt, qs, req, resp, model_class, **kwargs):
        filt, qs = super(VendorDidResourceAll, self).modify_query(filt, qs, req, resp, model_class, **kwargs)
        qs = qs.filter(model.Client.client_type == 'vendor')
        return filt, qs


# CarrierCreate.before_create = carrier_before_create
class ClientPastDueList(DnlList):
    scheme_class = ClientGetPastDueScheme
    model_class = model.Client
    entity_plural = 'Past due report'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_filter_over_due_isnull(self, query, value, kwargs):
        return query.filter(model.Client.over_due.is_(None) == value)

    def on_filter_over_due_gt(self, query, value, kwargs):
        return query.filter(model.Client.over_due > value)


class CarrierList(DnlList):
    scheme_class = CarrierGetScheme
    model_class = model.Client
    entity_plural = 'Carriers'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    large_list_fields = ['client_id', 'name']

    # def on_get(self, req, resp, **kwargs):
    #    req.query_string = req.query_string.replace('is_active', 'status')
    #    DnlList.on_get(self, req, resp, **kwargs)

    def on_filter_is_ingress_only(self, query, value, kwargs):
        cls = self.model_class
        r = aliased(model.Resource)
        # query = query.filter(cls.client_id.in_(select([r.client_id]).where(and_(r.ingress == True, r.is_virtual.isnot(True)) == value)))
        query = query.filter(and_(cls.ingress_count > 0, cls.egress_count == 0))
        return query

    def on_filter_is_egress_only(self, query, value, kwargs):
        cls = self.model_class
        r = aliased(model.Resource)
        # query = query.filter(cls.client_id.in_(select([r.client_id]).where(and_(r.egress == True, r.is_virtual.isnot(True)) == value)))
        query = query.filter(and_(cls.ingress_count == 0, cls.egress_count > 0))
        return query

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        q = query
        if self._filtered:
            return {}, q
        return ordering, q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(CarrierList, self).get_filtering_for_list(parsed_qs, **kwargs)
        # if not 'is_term' in ret and not 'is_orig' in ret:
        #     ret['is_term'] = 'true'
        if 'is_active' in ret:
            ret['status'] = ret['is_active']
            del ret['is_active']
        if 'is_prepay' in ret:
            if ret['is_prepay'] == 'true':
                ret['mode'] = 'prepay'
            else:
                ret['mode'] = 'postpay'
            del ret['is_prepay']
        return ret

    def _on_get(self, req, resp, **kwargs):
        if (not hasattr(self, 'no_auth_needed') or self.no_auth_needed == False) and not check_permission(self, req,
                                                                                                          'list'):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            log.debug("req.headers['ACCEPT']={}".format(req.headers['ACCEPT']))
            if 'ACCEPT' in req.headers and '*/*' in req.headers['ACCEPT'] and 'application/json' not in req.headers[
                'ACCEPT']:
                req.headers['ACCEPT'] = 'text/csv'
            log.debug("GETTING OBJECTS LIST")

            additional_fields = []
            parsed_qs = dict(parse_qsl(req.query_string))
            if "fields" in parsed_qs:
                fields = parsed_qs["fields"].split(",")
                if "low_balance_config" in fields:
                    low_balance_config_exists = True
                    fields.remove("low_balance_config")
                    parsed_qs["fields"] = ",".join(fields)
                    req.query_string = urlencode(parsed_qs)
                    additional_fields.append("low_balance_config")

            objects_list, total, page, per_page, fields = self.get_objects_list(req, self.model_class, **kwargs)
            if fields and additional_fields:
                fields += additional_fields
            log.debug("GOT OBJECTS LIST")
            try:
                per_page = int(dict(parse_qsl(req.query_string)).get('per_page'))
                log.debug("PER_PAGE TRIES SUCCESSFULLY - {}".format(per_page))
            except (ValueError, TypeError):
                per_page = conf.get_default_items_per_page()
                log.debug("PER_PAGE TRIES, but got an error - {}".format(per_page))
            if 'ACCEPT' in req.headers and req.headers['ACCEPT'] == 'text/csv':
                log.debug("'ACCEPT' in req.headers and req.headers['ACCEPT'] == 'text/csv'")
                resp.content_type = 'text/csv'
                resp.append_header('Transfer-Encoding', 'chunked')
                resp.append_header('Content-Disposition', 'attachment; filename="{}.csv"'.format(self.entity_plural))
                resp_stream = gen_csv(objects_list, self, resp, 0, total, fields)
                resp.stream = resp_stream
                # resp.status = falcon.HTTP_PARTIAL_CONTENT
                resp.status = falcon.HTTP_200
            else:
                try:
                    self.set_response(
                        resp, responses.SuccessResponse(
                            data={
                                'items': self.scheme_class(only=fields).dump(objects_list, many=True).data,
                                'total': total, 'page': page, 'per_page': per_page
                            },
                            scheme=schemes.ObjectScheme
                        )
                    )
                except Exception as e:
                    log.debug(f"ERROR - {e}")
        except AttributeError as e:
            self.set_response(
                resp, responses.AttributeNotExitsErrorResponse(
                    data=ATTRIBUTE_ERROR_RE.search(str(e)).group(1)
                )
            )
        except Exception as e:
            import traceback
            log.error(traceback.format_exc())
            self.set_response(resp, OperationErrorResponse(e))

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        credit_limit_gt = None
        if 'credit_limit_gt' in filtering:
            credit_limit_gt = filtering['credit_limit_gt']
            del filtering['credit_limit_gt']
        # filtering['allowed_credit_gt']=credit_limit_gt
        credit_limit_lt = None
        if 'credit_limit_lt' in filtering:
            credit_limit_gt = filtering['credit_limit_lt']
            del filtering['credit_limit_lt']
        # filtering['allowed_credit_lt'] = credit_limit_lt

        filt, q = super(CarrierList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # q = q.filter(model.Client.client_type.is_(None))
        user = self.get_user(self.req)
        user_id = user.user_id
        if not user.is_admin:
            q = q.filter(
                # and_(model.Client.client_type.is_(None), model.Client.client_id.in_(self.get_user(self.req).clients_id))
                model.Client.user_id_filter(user_id)
            )
        
        if not user.show_carrier_trunk_drop_only:
            if user.client_limits is not None:
                if user.client_limits:
                    client_ids = [limit.client_id for limit in user.client_limits]
                    q = q.filter(model.Client.client_id.in_(client_ids))
                else:
                    q = q.filter(sqlalchemy.sql.false()) 

        self._filtered = False
        R1 = aliased(model.Resource)

        if 'ingress_count' in filtering:
            self._filtered = True
            q = q.outerjoin(model.Resource,
                            and_(model.Client.client_id == model.Resource.client_id, model.Resource.ingress == True)). \
                group_by(model.Client.client_id).having(
                model.func.count(model.Resource.resource_id.distinct()) == filtering['ingress_count'])
            del filt['ingress_count']
        if 'egress_count' in filtering:
            self._filtered = True
            q = q.outerjoin(R1, and_(model.Client.client_id == R1.client_id, R1.egress == True)). \
                group_by(model.Client.client_id).having(
                model.func.count(R1.resource_id.distinct()) == filtering['egress_count'])
            del filt['egress_count']
        if not credit_limit_gt is None:
            q = q.filter(model.Client.allowed_credit > credit_limit_gt)
        if not credit_limit_lt is None:
            q = q.filter(model.Client.allowed_credit < credit_limit_lt)
        
        return (filt, q)

    def get_spec(self):
        sfields_names, search_fields_list = self.get_fields_from_scheme(self.scheme_class)
        qfields_names, query_fields_list = self.get_query_fields_from_scheme(self.scheme_class)
        fields_names = list(set(sfields_names + qfields_names))
        return swagger.specify.get_spec(
            method='get', description='Gets {}'.format(self.entity_plural.lower()),
            path_parameters=self.path_parameters,
            query_parameters=[{'name': 'fields', 'type': 'string'},
                              {'name': 'page', 'type': 'integer'}, {'name': 'per_page', 'type': 'integer'},
                              {'name': 'order_by', 'enum': fields_names + ['actual_balance', 'mutual_balance']},
                              {'name': 'order_dir', 'enum': ['asc', 'desc']}
                              ] + search_fields_list + query_fields_list,
            responses=(
                          responses.SuccessResponseObjectsList(payload_scheme_items=self.scheme_class),
                          responses.AttributeNotExitsErrorResponse()
                      ) + self.get_additional_responses(method='get'),
            security=self.get_security(method='get')
        )


class CarrierSmallList(DnlList):
    scheme_class = CarrierSmallGetScheme
    model_class = model.Client
    entity_plural = 'Carriers'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    large_list_fields = ['client_id', 'name']

    def get_objects_list(self, req, model_class, **kwargs):
        parsed_qs = dict(parse_qsl(req.query_string))
        try:
            per_page = int(parsed_qs.get('per_page'))
        except (ValueError, TypeError):
            per_page = conf.get_default_items_per_page()

        try:
            page = int(parsed_qs.get('page', 0))
        except ValueError:
            page = 0

        if hasattr(self, 'per_page_limit') and per_page > self.per_page_limit:
            raise ValidationError('per_page  over limit {}'.format(self.per_page_limit))

        if 'order_by' in parsed_qs:
            ordering = {
                'by': parsed_qs['order_by'],
                'dir': parsed_qs.get('order_dir', 'asc')
            }
        elif hasattr(self, 'ordering'):
            ordering = self.ordering
        else:
            ordering = {}
        fields = self.get_fields_for_list(parsed_qs, **kwargs)
        filtering = self.get_filtering_for_list(parsed_qs, **kwargs)
        result = self.modify_query_from_filtering_for_list(filtering, **kwargs)
        if result is not None:
            filtering, query = result
        else:
            filtering, query = None, None
        for c in inspect(self.model_class).columns:
            if c.name in ['alias', 'name', 'template_name', 'group_name']:
                query = query.filter(or_(c.is_(None), c.notlike('#%')))
                break

        if ordering:
            ordering, query = \
                self.modify_query_from_ordering_for_list(ordering, query, **kwargs)
        log.debug("QUERY - {}\nFILTERING - {}\nORDERING - {}".format(query, filtering, ordering))
        if ('ACCEPT' in req.headers and req.headers['ACCEPT'] == 'text/csv'):
            return model_class.get_objects_query(
                query=query,
                filtering=filtering,
                ordering=ordering,
                paging=None
            ) + (0, None, fields)
        else:
            if 'by' in ordering.keys() and ordering['by'] == 'invoice_number':
                per_page = None
            return model_class.get_objects_list(
                query=query,
                filtering=filtering,
                ordering=ordering,
                paging={'from': page * per_page, 'till': (page + 1) * per_page} if per_page else None,
                query_only = 'query_only' in kwargs
            ) + (page, per_page, fields)


class ClientSimpleList(DnlList):
    scheme_class = ClientSimpleGetScheme
    model_class = model.Client
    entity_plural = 'Simple client list'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_filter_client_type(self, query, value, kwargs):
        cls = self.model_class
        if value == 'carrier':
            query = query.filter(cls.client_type.is_(None))
        else:
            query = query.filter(cls.client_type == value)
        return query

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ingress_count_gt = None
        if 'ingress_count_gt' in filtering:
            ingress_count_gt = filtering['ingress_count_gt']
            del filtering['ingress_count_gt']

        egress_count_gt = None
        if 'egress_count_gt' in filtering:
            egress_count_gt = filtering['egress_count_gt']
            del filtering['egress_count_gt']

        filt, q = super(ClientSimpleList, self).modify_query_from_filtering_for_list(filtering, **kwargs)

        q = q.filter(model.Client.user_id_filter(self.get_user(self.req).user_id))
        # and_(model.Client.client_type.is_(None), model.Client.client_id.in_(self.get_user(self.req).clients_id))

        self._filtered = False
        R1 = aliased(model.Resource)

        if 'ingress_count' in filtering or ingress_count_gt:
            self._filtered = True
            q = q.outerjoin(model.Resource,
                            and_(model.Client.client_id == model.Resource.client_id, model.Resource.ingress == True)). \
                group_by(model.Client.client_id)
            if ingress_count_gt:
                q = q.having(model.func.count(model.Resource.resource_id.distinct()) > ingress_count_gt)
            else:
                q = q.having(model.func.count(model.Resource.resource_id.distinct()) == filtering['ingress_count'])
                del filt['ingress_count']
        if 'egress_count' in filtering or egress_count_gt:
            self._filtered = True
            q = q.outerjoin(R1, and_(model.Client.client_id == R1.client_id, R1.egress == True)). \
                group_by(model.Client.client_id)
            if egress_count_gt:
                q = q.having(model.func.count(R1.resource_id.distinct()) > egress_count_gt)
            else:
                q = q.having(model.func.count(R1.resource_id.distinct()) == filtering['egress_count'])
                del filt['egress_count']

        return (filt, q)


class CarrierAutoInvoicingList(DnlList):
    scheme_class = CarrierAutoInvoicingGetScheme
    model_class = model.Client
    entity_plural = 'Auto Invoice Carriers'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(CarrierAutoInvoicingList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        q = q.filter(and_(cls.auto_invoicing == True, cls.payment_term_id.isnot(None)))
        return filt, q

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        model_class = self.model_class
        if 'by' in ordering and ordering['by'] == 'next_invoice_date':
            if ordering['dir'] == 'desc':
                query = query.order_by(model.Client._next_invoice_date.desc())
            else:
                query = query.order_by(model.Client._next_invoice_date)
            ordering = {}

        return ordering, query


# --- Carrier Actions

class CarrierAction(resources.CustomPatchAction):
    model_class = model.Client
    scheme_class = CarrierGetScheme
    scheme_class_get = CarrierGetScheme
    scheme_class_modify = CarrierScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'client_id', 'description': 'Carrier to proceed'},)


class CarrierRegenerateBalance(CarrierAction):
    def apply(self, obj, req, resp, **kwargs):
        try:
            obj.regenerate_balance()
            return True
        except Exception as e:
            log.error(e)
            # self.set_response(resp, responses.OperationErrorResponse(data=errors.CommonErrors.DataError))
            self.set_response(resp, OperationErrorResponse(e))
            return False


class CarrierSendLowBalanceAlert(CarrierAction):
    def apply(self, obj, req, resp, **kwargs):
        ret = model.MailSender.apply_mail(obj, 'lowbalance', obj.billing_email)
        if ret:
            self.set_response(resp, responses.OperationErrorResponse(
                data=errors.Error(code=43, message=ret[1], reason='mail error')))
            return False
        return not ret


class CarrierSendWelcon(CarrierAction):
    def apply(self, obj, req, resp, **kwargs):
        if obj:
            ret = obj.apply_mail('welcome')
            if ret:
                self.set_response(resp, responses.OperationErrorResponse(
                    data=errors.Error(code=43, message=ret[1], reason='mail error')))
                return False
            return True
        else:
            self.set_response(resp, NoResultFound())
            return False


# ---  Carrier Actions

# +++ CarrierAlertsResource
class CarrierAlertsResource(DnlResource):
    model_class = model.Client
    scheme_class = CarrierScheme
    scheme_class_get = CarrierAllertSettingsScheme  # CarrierAlertsScheme
    scheme_class_modify = CarrierAllertSettingsScheme  # CarrierAlertsScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_delete_operation = False
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class CarrierInvoiceSettingsResource(DnlResource):
    model_class = model.Client
    scheme_class = CarrierScheme
    scheme_class_get = CarrierInvoiceSettingScheme
    scheme_class_modify = CarrierInvoiceSettingScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_delete_operation = False
    # has_update_operation = False
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class CarrierSccResource(DnlResource):
    model_class = model.Client
    scheme_class = CarrierScheme
    scheme_class_get = CarrierSccScheme
    scheme_class_modify = CarrierSccScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_delete_operation = False
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class CarrierPortalResource(CarrierResource):
    model_class = model.Client
    scheme_class = CarrierScheme
    scheme_class_get = CarrierPortalScheme
    scheme_class_modify = CarrierPortalScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_delete_operation = False
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class CarrierContactsResource(DnlResource):
    model_class = model.Client
    scheme_class = CarrierScheme
    scheme_class_get = CarrierContactsScheme
    scheme_class_modify = CarrierContactsScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_delete_operation = False
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class CarrierBalanceResource(DnlResource):
    model_class = model.Client
    scheme_class = CarrierScheme
    scheme_class_get = CarrierBalanceGetScheme
    scheme_class_modify = CarrierContactsScheme
    entity = 'Carrier'
    id_field = 'client_id'
    has_delete_operation = False
    has_modify_operation = False
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


# +++PaymentGatewayHistory
# PaymentGatewayHistory
class PaymentGatewayHistoryCreate(DnlCreate):
    scheme_class = PaymentGatewayHistoryScheme
    entity = 'PaymentGatewayHistoryRecord'
    unique_field = 'id'
    additional_responses = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)

    def before_create(self, obj, **kwargs):
        obj.client_id = kwargs['client_id']
        return obj


class PaymentGatewayHistoryClientList(DnlList):
    scheme_class = PaymentGatewayHistoryClientGetScheme
    model_class = model.PaymentGatewayHistory
    entity_plural = 'PaymentGatewayHistory'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(PaymentGatewayHistoryClientList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['client_id'] = kwargs['client_id']
        return ret


class PaymentGatewayHistoryList(DnlList):
    scheme_class = PaymentGatewayHistoryGetScheme
    model_class = model.PaymentGatewayHistory
    entity_plural = 'PaymentGatewayHistory'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super(PaymentGatewayHistoryList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        ret = ret.filter(cls.client_id.isnot(None))
        return filt, ret


# ---PaymentGatewayHistory

# --------------ClientPayment
class ClientPaymentCreate(DnlCreate):
    scheme_class = ClientPaymentScheme
    entity = 'ClientPayment'
    unique_field = 'client_payment_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)

    def on_post(self, req, resp, **kwargs):
        payment_type = req.data.get('payment_type', None)
        if payment_type == 'invoice payment sent':
            req.data.pop('invoice_number', None)
        return super().on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):
        obj.client_id = kwargs['client_id']
        obj.update_by = self.get_user().name
        return obj


class ClientPaymentExtraCreate(ClientPaymentCreate):
    scheme_class = ClientPaymentExtraScheme

    def before_create(self, obj, **kwargs):
        obj = super().before_create(obj, **kwargs)
        obj.payment_type = 'extra charge'
        return obj


class ClientPaymentCreditNoteCreate(DnlCreate):
    scheme_class = ClientPaymentAmountNoteScheme
    entity = 'ClientPayment'
    unique_field = 'client_payment_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'invoice_id', 'description': 'Invoice to create note'},)

    def before_create(self, obj, **kwargs):
        inv = model.Invoice.get(kwargs['invoice_id'])
        if not inv:
            raise NoResultFound()
        if inv.state == 'void':
            raise ValidationError({'invoice_id': ['invoice has "void" state']})
        obj.client_id = inv.client_id
        obj.invoice_number = inv.invoice_number
        # if obj.amount > inv.total_amount:
        #     raise ValidationError({'amount': 'must be less than invoice total amount'})

        obj.update_by = self.get_user().name
        obj.payment_type = 'credit note sent'
        obj.payment_time = datetime.now(UTC)

        return obj


class ClientPaymentResource(DnlResource):
    model_class = model.ClientPayment
    scheme_class = ClientPaymentScheme
    scheme_class_get = ClientPaymentGetScheme
    scheme_class_modify = ClientPaymentScheme
    entity = 'ClientPayment'
    id_field = 'client_payment_id'
    has_update_by = True
    # unique_field='name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ClientPaymentExtraResource(ClientPaymentResource):
    model_class = model.ClientPayment
    scheme_class = ClientPaymentExtraScheme
    scheme_class_get = ClientPaymentExtraGetScheme
    scheme_class_modify = ClientPaymentExtraScheme


class ClientPaymentSendNote(resources.CustomPatchAction):
    scheme_class = ClientPaymentNoteScheme
    body_parameters = ('Note to payment', ClientPaymentNoteScheme)
    method = 'post'
    model_class = model.ClientPayment
    path_parameters = ({'name': 'client_payment_id', 'description': 'Payment id'},)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        obj.note = req.data['note']
        obj.save(save_history=True, user=self.get_user(req), module=getattr(self.__class__, 'api_module', 'N/A'))

        class Ret:
            pass

        ret = Ret()
        ret.__dict__ = obj.__dict__
        if obj.client:
            res = 'unknow payment type'
            if obj.payment_type in ('invoice payment received', 'Prepayment Received', 'credit note received',
                                    'debit received'):
                res = obj.apply_mail('payment_received')
            if obj.payment_type in ('invoice payment sent', 'payment sent', 'credit note sent', 'debit sent'):
                res = obj.apply_mail('payment_sent')
            if res:
                self.set_response(resp, responses.OperationErrorResponse(
                    data=errors.Error(code=43, message=res[1], reason='mail error')))
                return False
        else:
            self.set_response(resp, OperationErrorResponse('Payment has no client!'))
            return False
        return True


class ClientPaymentList(DnlList):
    scheme_class = ClientPaymentGetScheme
    model_class = model.ClientPayment
    entity_plural = 'ClientPayments'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ClientPaymentList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['client_id'] = kwargs['client_id']
        return ret


class ClientPaymentExtraList(ClientPaymentList):
    scheme_class = ClientPaymentExtraGetScheme

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        (filt, query) = super(ClientPaymentExtraList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        query = query.filter(model.ClientPayment.payment_type == 'extra charge')
        return (filt, query)


class ClientPaymentAllExtraList(DnlList):
    scheme_class = ClientPaymentExtraGetScheme
    model_class = model.ClientPayment
    entity_plural = 'ClientPayments'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


class ClientPaymentTransList(DnlList):
    scheme_class = ClientPaymentTransactGetScheme
    model_class = model.ClientPayment
    entity_plural = 'Client transactions'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ClientPaymentTransList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['client_id'] = kwargs['client_id']
        return ret


class ClientPaymentSentCreate(DnlCreate):
    scheme_class = ClientPaymentSentScheme
    entity = 'ClientPayment'
    unique_field = 'client_payment_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.receiving_time = datetime.now(UTC)
        # obj.client_id = kwargs['client_id']
        # TODO: need invoice creation???
        return obj


class ClientPaymentSentResource(DnlResource):
    model_class = model.ClientPayment
    scheme_class = ClientPaymentSentScheme
    scheme_class_get = ClientPaymentSentGetScheme
    scheme_class_modify = ClientPaymentSentScheme
    entity = 'ClientPayment'
    id_field = 'client_payment_id'
    has_update_by = True
    # unique_field='name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ClientPaymentAllList(DnlList):
    scheme_class = ClientPaymentAllGetScheme
    # scheme_class = ClientPaymentGetScheme
    model_class = model.ClientPayment
    entity_plural = 'All payments'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        if 'payment_time_lt' in filtering and len(filtering['payment_time_lt']) == 10:
            filtering['payment_time_lt'] = filtering['payment_time_lt'] + ' 23:59:59'
        if 'receiving_time_lt' in filtering and len(filtering['receiving_time_lt']) == 10:
            filtering['receiving_time_lt'] = filtering['receiving_time_lt'] + ' 23:59:59'
        (filt, query) = super(ClientPaymentAllList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        # query = query.filter(and_cls.client_id == model.Client.client_id)
        return (filt, query)


class ClientPaymentInvoiceList(DnlList):
    # scheme_class = ClientPaymentSentGetScheme
    scheme_class = ClientPaymentGetScheme
    model_class = model.ClientPayment
    entity_plural = 'All invoice payments'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        (filt, query) = super(ClientPaymentInvoiceList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        query = query.filter(and_(cls.payment_type.in_(['invoice payment received']), cls.invoice_number.isnot(None)))
        # query = query.filter(cls.client_id.in_(self.get_user(self.req).clients_id))
        return (filt, query)


class ClientPaymentForInvoiceList(DnlList):
    # scheme_class = ClientPaymentSentGetScheme
    scheme_class = ClientPaymentGetScheme
    model_class = model.ClientPayment
    entity_plural = 'All invoice payments'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'invoice_id', 'description': 'Parent invoice'},)

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        inv = model.Invoice.get(kwargs['invoice_id'])
        if not inv:
            raise NoResultFound

        (filt, query) = super(ClientPaymentForInvoiceList, self).modify_query_from_filtering_for_list(filtering,
                                                                                                      **kwargs)
        cls = self.model_class

        query = query.filter(
            and_(cls.payment_type.in_(['invoice payment received', 'invoice payment sent']),
                 cls.invoice_number == inv.invoice_number))
        # query = query.filter(cls.client_id.in_(self.get_user(self.req).clients_id))
        return (filt, query)


class ClientPaymentCreditNotesForInvoiceList(DnlList):
    # scheme_class = ClientPaymentSentGetScheme
    scheme_class = ClientPaymentGetScheme
    model_class = model.ClientPayment
    entity_plural = 'All invoice payments'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'invoice_id', 'description': 'Parent invoice'},)

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        inv = model.Invoice.get(kwargs['invoice_id'])
        if not inv:
            raise NoResultFound

        (filt, query) = super(ClientPaymentCreditNotesForInvoiceList, self).modify_query_from_filtering_for_list(
            filtering, **kwargs)
        cls = self.model_class

        query = query.filter(and_(cls.payment_type.in_(['credit note sent']), cls.invoice_number == inv.invoice_number))
        # query = query.filter(cls.client_id.in_(self.get_user(self.req).clients_id))
        return (filt, query)


class ClientPaymentSentList(DnlList):
    # scheme_class = ClientPaymentSentGetScheme
    scheme_class = ClientPaymentGetScheme
    model_class = model.ClientPayment
    entity_plural = 'Sent payments'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        if 'payment_time_lt' in filtering and len(filtering['payment_time_lt']) == 10:
            filtering['payment_time_lt'] = filtering['payment_time_lt'] + ' 23:59:59'
        if 'receiving_time_lt' in filtering and len(filtering['receiving_time_lt']) == 10:
            filtering['receiving_time_lt'] = filtering['receiving_time_lt'] + ' 23:59:59'
        (filt, query) = super(ClientPaymentSentList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        query = query.filter(text_(
            "payment_type in (3,6)"))  # or_(model.ClientPayment.payment_type==3,model.ClientPayment.payment_type==6))
        cls = self.model_class
        user_id = self.get_user(self.req).user_id
        query = query.filter(model.user_id_filter(cls, user_id))
        return (filt, query)


class ClientPaymentReceivedList(DnlList):
    scheme_class = ClientPaymentSentGetScheme
    model_class = model.ClientPayment
    entity_plural = 'Received payments'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):

        if 'payment_time_lt' in filtering and len(filtering['payment_time_lt']) == 10:
            filtering['payment_time_lt'] = filtering['payment_time_lt'] + ' 23:59:59'
        if 'receiving_time_lt' in filtering and len(filtering['receiving_time_lt']) == 10:
            filtering['receiving_time_lt'] = filtering['receiving_time_lt'] + ' 23:59:59'

        if 'tz' in filtering:
            tz = int(filtering.pop('tz', 0))
            fmt = '%Y-%m-%d %H:%M:%S'
            filtering['receiving_time_lt'] = datetime.strptime(filtering['receiving_time_lt'], fmt) - timedelta(
                hours=tz)
            filtering['receiving_time_gt'] = datetime.strptime(filtering['receiving_time_gt'], fmt) - timedelta(
                hours=tz)

        (filt, query) = super(ClientPaymentReceivedList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        query = query.filter(text_(
            "payment_type in (4,5,11)"))  # or_(model.ClientPayment.payment_type==3,model.ClientPayment.payment_type==6))
        cls = self.model_class

        user_id = self.get_user(self.req).user_id
        query = query.filter(model.user_id_filter(cls, user_id))
        return (filt, query)


# ------ ClientPayment ------

# +++ TransactionFeeItems

class TransactionFeeItemsList(DnlList):
    scheme_class = TransactionFeeItemsScheme
    model_class = model.TransactionFeeItems
    entity_plural = 'TransactionFeeItems'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(TransactionFeeItemsList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['client_id'] = kwargs['client_id']
        return ret


# --- TransactionFeeItems


# ++++ BalanceHistory
class BalanceHistoryList(DnlList):
    scheme_class = BalanceHistoryGetScheme
    model_class = model.BalanceHistory
    entity_plural = 'BalanceHistory'
    security = (DEFAULT_SECURITY)
    restrict = ()


class BalanceHistoryClientList(DnlSummaryList):
    scheme_class = BalanceHistoryGetScheme
    model_class = model.BalanceHistory
    entity_plural = 'BalanceHistory'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)

    def _on_get(self, req, resp, **kwargs):
        if (not hasattr(self, 'no_auth_needed') or self.no_auth_needed == False) and not check_permission(self, req,
                                                                                                          'list'):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            objects_list, total, page, per_page, fields = self.get_objects_list(req, self.model_class, **kwargs)
            items = self.scheme_class(only=fields).dump(objects_list, many=True).data
            addon = self.get_today_data(req, resp, **kwargs)
            if addon:
                items.append(addon)

            self.set_response(
                resp, responses.SuccessResponse(
                    data={
                        'items': items,
                        'summary': self.get_total_data(req, resp, **kwargs),
                        'total': total, 'page': page, 'per_page': per_page
                    },
                    scheme=ObjectsListWithSummaryScheme
                )
            )
        except AttributeError as e:
            self.set_response(
                resp, responses.AttributeNotExitsErrorResponse(
                    data=ATTRIBUTE_ERROR_RE.search(str(e)).group(1)
                )
            )
        except Exception as e:
            log.error(e)
            # self.set_response(resp, responses.OperationErrorResponse(data=errors.CommonErrors.DataError))
            self.set_response(resp, OperationErrorResponse(e))

    def get_today_data(self, req, resp, **kwargs):
        parsed_qs = dict(parse_qsl(req.query_string))
        client_id = kwargs['client_id']
        cls = self.model_class

        start_date = parsed_qs.get('date_gte', None)
        end_date = parsed_qs.get('date_lte', None)
        if not end_date or parse_datetime(end_date) > parse_datetime(model.now_date()):
            return cls.today_mutual_balance(client_id)
        return None

    def get_total_data(self, req, resp, **kwargs):
        client_id = kwargs['client_id']
        cls = self.model_class
        q = model.get_db().session.query(func.sum(cls.payment_received).label('payment_received'),
                                         func.sum(cls.payment_sent).label('payment_sent'),
                                         func.sum(cls.credit_received).label('credit_received'),
                                         func.sum(cls.credit_sent).label('credit_sent'),
                                         func.sum(cls.invoice_sent).label('invoice_sent'),
                                         func.sum(cls.invoice_received).label('invoice_received')

                                         ).filter(cls.client_id == client_id)

        parsed_qs = dict(parse_qsl(req.query_string))
        start_date = parsed_qs.get('date_gte', None)
        end_date = parsed_qs.get('date_lte', None)
        lst = None
        beginning_balance = None
        ending_balance = None
        if end_date:
            end_date_ = str(parse_datetime(end_date).date() - timedelta(days=1))
            q = q.filter(cls.date <= end_date)
            end = cls.filter(cls.client_id == client_id).filter(cls.date == end_date_).first()
        else:
            end = cls.filter(cls.client_id == client_id).order_by(cls.date.desc()).first()
        ending_balance = end.mutual_balance if end else None
        if start_date:
            start_date_ = str(parse_datetime(start_date).date() - timedelta(days=1))
            beg = cls.filter(cls.client_id == client_id).filter(cls.date == start_date_).first()
            q = q.filter(cls.date >= start_date)
        else:
            beg = cls.filter(cls.client_id == client_id).order_by(cls.date).first()
        beginning_balance = beg.mutual_balance if beg else None

        obj = q.first()
        data = {'beginning_balance': beginning_balance}

        tod = self.get_today_data(req, resp, **kwargs)
        obj = q.first()
        for k in ('payment_received', 'payment_sent', 'credit_received', 'credit_sent',
                  'invoice_sent', 'invoice_received'):
            d = getattr(obj, k)
            data[k] = d if not d is None else model.Decimal(0)
            if tod and k in tod:
                data[k] += tod[k]
        if lst:
            data['mutual_balance'] = lst.mutual_balance
        if tod:
            data['mutual_balance'] = tod['mutual_balance']
            data['ending_balance'] = tod['mutual_balance']
        return data

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(BalanceHistoryClientList, self).get_filtering_for_list(parsed_qs, **kwargs)
        if 'client_id' in kwargs:
            ret['client_id'] = kwargs['client_id']
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(BalanceHistoryClientList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # ret = ret.filter(cls.client_id.in_(self.get_user(self.req).clients_id))
        ret = ret.filter(model.user_id_filter(cls, self.get_user(self.req).user_id))
        return filt, ret


# ---- BalanceHistory

# ++++ ActualBalanceHistory


class ActualBalanceHistoryList(DnlList):
    scheme_class = ActualBalanceHistoryGetScheme
    model_class = model.BalanceHistoryActual
    entity_plural = 'ActualBalanceHistory'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ActualBalanceHistoryClientList(DnlSummaryList):
    scheme_class = ActualBalanceHistoryGetScheme
    model_class = model.BalanceHistoryActual
    entity_plural = 'ActualBalanceHistory'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)

    def get_total_data(self, req, resp, **kwargs):
        client_id = kwargs['client_id']
        cls = self.model_class
        q = model.get_db().session.query(func.sum(cls.payment_received).label('payment_received'),
                                         func.sum(cls.payment_sent).label('payment_sent'),
                                         func.sum(cls.credit_note_received).label('credit_note_received'),
                                         func.sum(cls.credit_note_sent).label('credit_note_sent'),
                                         func.sum(cls.debit_note_received).label('debit_note_received'),
                                         func.sum(cls.debit_note_sent).label('debit_note_sent'),
                                         func.sum(cls.unbilled_outgoing_traffic).label('unbilled_outgoing_traffic'),
                                         func.sum(cls.unbilled_incoming_traffic).label('unbilled_incoming_traffic'),
                                         func.sum(cls.short_charges).label('short_charges')
                                         ).filter(cls.client_id == client_id)
        from urllib.parse import parse_qsl, urlencode
        parsed_qs = dict(parse_qsl(req.query_string))
        start_date = parsed_qs.get('date_gte', None)
        end_date = parsed_qs.get('date_lte', None)
        beginning_balance = None
        ending_balance = None
        if end_date:
            end_date_ = str(parse_datetime(end_date).date())
            q = q.filter(cls.date <= end_date)
            end = cls.filter(cls.client_id == client_id).filter(cls.date == end_date_).first()
        else:
            end = cls.filter(cls.client_id == client_id).order_by(cls.date.desc()).first()
        ending_balance = end.actual_balance if end else None
        if start_date:
            start_date_ = str(parse_datetime(start_date).date() - timedelta(days=1))
            beg = cls.filter(cls.client_id == client_id).filter(cls.date == start_date_).first()
            q = q.filter(cls.date >= start_date)
        else:
            beg = cls.filter(cls.client_id == client_id).order_by(cls.date).first()
        beginning_balance = beg.actual_balance if beg else None

        obj = q.first()
        data = {'beginning_balance': beginning_balance, 'ending_balance': ending_balance}

        for k in ('payment_received', 'payment_sent', 'credit_note_received', 'credit_note_sent', 'debit_note_received',
                  'debit_note_sent', 'unbilled_outgoing_traffic', 'unbilled_incoming_traffic', 'short_charges'):
            data[k] = getattr(obj, k)

        return data

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ActualBalanceHistoryClientList, self).get_filtering_for_list(parsed_qs, **kwargs)
        if 'client_id' in kwargs:
            ret['client_id'] = kwargs['client_id']
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        cls = self.model_class
        filt, ret = super(ActualBalanceHistoryClientList, self).modify_query_from_filtering_for_list(filtering,
                                                                                                     **kwargs)
        ret = ret.filter(model.user_id_filter(cls, self.get_user(self.req).user_id))
        return filt, ret


class ActualBalanceHistoryLogList(DnlList):
    scheme_class = ActualBalanceHistoryLogScheme
    model_class = model.BalanceHistoryActual
    entity_plural = 'ActualBalanceHistory'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- ActualBalanceHistory
# --------------DynamicRoute
class DynamicRouteCreate(DnlCreate):
    scheme_class = DynamicRouteScheme
    entity = 'DynamicRoute'
    unique_field = 'dynamic_route_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        return obj


class DynamicRouteCopy(DnlCreate):
    scheme_class = DynamicRouteCopyScheme
    entity = 'DynamicRoute'
    unique_field = 'dynamic_route_id'
    additional_responses = ()
    path_parameters = ({'name': 'dynamic_route_id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, dynamic_route_id):
        cls = model.DynamicRoute
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        old = cls.get(dynamic_route_id)
        if not old:
            raise Exception('dynamic_route_id {} not found'.format(dynamic_route_id))
        obj.routing_rule = old.routing_rule
        obj.time_profile_id = old.time_profile_id
        obj.lcr_flag = old.lcr_flag
        obj.is_virtual = old.is_virtual
        for item in old.egress_trunks:
            obj.egress_trunks.append(model.DynamicRouteItem(resource_id=item.resource_id))
        for item in old.qos:
            obj.qos.append(
                model.DynamicRouteQos(
                    digits=item.digits,
                    min_asr=item.min_asr,
                    max_asr=item.max_asr,
                    min_abr=item.min_abr,
                    max_abr=item.max_abr,
                    min_acd=item.min_acd,
                    max_acd=item.max_acd,
                    min_pdd=item.min_pdd,
                    max_pdd=item.max_pdd,
                    min_aloc=item.min_aloc,
                    max_aloc=item.max_aloc,
                    limit_price=item.limit_price)
            )
        for item in old.pri:
            obj.pri.append(
                model.DynamicRoutePri(digits=item.digits,
                                      resource_id=item.resource_id,
                                      resource_pri=item.resource_pri))
        for item in old.over:
            obj.over.append(model.DynamicRouteOverride(
                digits=item.digits, resource_id=item.resource_id, percentage=item.percentage))

        if not getattr(obj, 'name', None):
            name = old.name + 'Copy'
            new_name = name
            i = 0
            while cls.filter(cls.name == new_name).first():
                new_name = name + str(i)
                i += 1
            obj.name = new_name

        return obj


class DynamicRouteResource(DnlResource):
    model_class = model.DynamicRoute
    scheme_class = DynamicRouteScheme
    scheme_class_get = DynamicRouteSchemeGet
    scheme_class_modify = DynamicRouteScheme
    entity = 'DynamicRoute'
    id_field = 'dynamic_route_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_filter_route_plan_id(self, query, value, kwargs):
        cls = self.model_class
        i = aliased(model.DynamicRouteItem)
        p = aliased(model.ResourcePrefix)
        return query.filter(cls.dynamic_route_id.in_(select([i.dynamic_route_id]). \
            where(
            and_(i.resource_id == p.resource_id, p.route_strategy_id == int(value)))))

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        if 'egress_trunks' in self.req_data:
            model.DynamicRouteItem.filter(model.DynamicRouteItem.dynamic_route_id == obj.dynamic_route_id).delete()

        """
if 'egress_trunks' in self.req_data:
    d = set([int(r['resource_id']) for r in self.req_data['egress_trunks']])
    e = [t.resource_id for t in obj.egress_trunks]
    self.req_data=[{'resource_id':str(r)} for r in d if not r in e]

    for t in self.req_data['egress_trunks']:
        obj.egress_trunks.append(model.DynamicRouteItem(**t))
"""
        return obj


class DynamicRouteList(DnlList):
    scheme_class = DynamicRouteSchemeGet
    model_class = model.DynamicRoute
    entity_plural = 'DynamicRoutes'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(DynamicRouteList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        it = aliased(model.DynamicRouteItem)
        if 'egress_trunk_id' in ret:
            try:
                eid = int(ret['egress_trunk_id'])
            except:
                raise ValidationError('egress_trunk_id bad integer:"{}"'.format(ret['egress_trunk_id']))
            q = q.filter(cls.dynamic_route_id.in_(select([it.dynamic_route_id]).where(it.resource_id == eid)))
            del ret['egress_trunk_id']
        return ret, q

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        model_class = self.model_class
        if 'by' in ordering and ordering['by'] == 'egress_trunk_id':
            if ordering['dir'] == 'desc':
                query = query.join(model.DynamicRouteItem, isouter=True).order_by(
                    model.DynamicRouteItem.resource_id.desc())
            else:
                query = query.join(model.DynamicRouteItem, isouter=True).order_by(
                    model.DynamicRouteItem.resource_id)
            ordering = {}
        """
        if 'by' in ordering and ordering['by'] == 'usage_count':
            if ordering['dir'] == 'desc':
                query = query.join(model.Route,isouter=True).group_by(model.DynamicRoute.dynamic_route_id).order_by(
                    model.func.count(model.Route.route_id.distinct()).desc() )
            else:
                query = query.join(model.Route,isouter=True).group_by(model.DynamicRoute.dynamic_route_id).order_by(
                    model.func.count(model.Route.route_id.distinct()) )
            ordering={}
        """

        if 'by' in ordering and ordering['by'] == 'modified_by':
            model_class = self.model_class
            print(query)
            if ordering['dir'] == 'desc':
                query = query.order_by(model.DynamicRoute.last_modified.desc()).order_by(
                    model.DynamicRoute.modified_by.desc())
            else:
                query = query.order_by(model.DynamicRoute.last_modified.desc()).order_by(model.DynamicRoute.modified_by)

            ordering = {}

        return ordering, query


# ------ DynamicRouteItem ------

class DynamicRouteItemCreate(DnlCreate):
    scheme_class = DynamicRouteItemScheme
    entity = 'DynamicRouteItem'
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.dynamic_route_id = kwargs['dynamic_route_id']
        return obj


class DynamicRouteItemMultiplyCreate(DnlCreate):
    scheme_class = DynamicRouteItemSchemeMultiple
    entity = 'DynamicRouteItem'
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        for trunk_id in obj.resource_id[1:]:
            it = model.DynamicRouteItem(dynamic_route_id=kwargs['dynamic_route_id'], resource_id=trunk_id)
            it.save()
        obj.resource_id = obj.resource_id[0]
        obj.dynamic_route_id = kwargs['dynamic_route_id']
        return obj


class DynamicRouteItemMultiplyRemove(CustomPatchAction):
    model_class = model.DynamicRoute
    entity = 'DynamicRoute'
    """    
    scheme_class = DynamicRouteItemSchemeMultiple
    scheme_class_get = DynamicRouteSchemeGet
    scheme_class_modify = DynamicRouteScheme
    id_field = 'dynamic_route_id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    """
    body_parameters = ('Trunks to remove', DynamicRouteItemSchemeMultiple)
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)

    def apply(self, obj, req, resp, **kwargs):
        cls = model.DynamicRouteItem
        query = cls.filter(cls.dynamic_route_id == kwargs['dynamic_route_id']).filter(
            cls.resource_id.in_(req.data['trunks']))
        result = query.delete(synchronize_session='fetch')
        cls.session().commit()
        self.set_response(resp, responses.SuccessResponseObjectInfo(data={'deleted': result}))
        return False


# ++++++ DynamicRouteQos +++++++
class DynamicRouteQosCreate(DnlCreate):
    scheme_class = DynamicRouteQosScheme
    entity = 'DynamicRouteQos'
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.dynamic_route_id = kwargs['dynamic_route_id']
        return obj


class DynamicRouteQosResource(DnlResource):
    model_class = model.DynamicRouteQos
    scheme_class = DynamicRouteQosScheme
    scheme_class_get = DynamicRouteQosSchemeGet
    scheme_class_modify = DynamicRouteQosScheme
    entity = 'DynamicRouteQos'
    id_field = 'id'
    has_update_by = True
    security = (DEFAULT_SECURITY)
    restrict = ()


class DynamicRouteQosList(DnlList):
    scheme_class = DynamicRouteQosSchemeGet
    model_class = model.DynamicRouteQos
    entity_plural = 'DynamicRouteQos list'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class DynamicRouteQosInnerList(DynamicRouteQosList):
    scheme_class = DynamicRouteQosSchemeGet
    model_class = model.DynamicRouteQos
    entity_plural = 'DynamicRouteQos list'
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(DynamicRouteQosList, self).get_filtering_for_list(parsed_qs, **kwargs)
        if not model.DynamicRoute.get(int(kwargs['dynamic_route_id'])):
            raise NoResultFound
        if 'dynamic_route_id' in kwargs:
            ret['dynamic_route_id'] = kwargs['dynamic_route_id']
        return ret


# ------ DynamicRouteQos -------

# ++++++ DynamicRoutePri +++++++
class DynamicRoutePriCreate(DnlCreate):
    scheme_class = DynamicRoutePriScheme
    entity = 'DynamicRoutePri'
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.dynamic_route_id = kwargs['dynamic_route_id']
        return obj


class DynamicRoutePriResource(DnlResource):
    model_class = model.DynamicRoutePri
    scheme_class = DynamicRoutePriScheme
    scheme_class_get = DynamicRoutePriSchemeGet
    scheme_class_modify = DynamicRoutePriScheme
    entity = 'DynamicRoutePri'
    id_field = 'id'
    has_update_by = True
    security = (DEFAULT_SECURITY)
    restrict = ()


class DynamicRoutePriList(DnlList):
    scheme_class = DynamicRoutePriSchemeGet
    model_class = model.DynamicRoutePri
    entity_plural = 'DynamicRoutePri list'
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(DynamicRoutePriList, self).modify_query_from_ordering_for_list(ordering, query,
                                                                                                   **kwargs)
        cls = self.model_class
        if ordering and 'by' in ordering:
            if ordering['by'] == 'digits':
                digits = func.cast(cls.digits, model.String)
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    query = query.order_by(func.length(digits)).order_by(digits)
                else:
                    query = query.order_by(func.length(digits).desc()).order_by(digits.desc())
        return ordering, query

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(DynamicRoutePriList, self).get_filtering_for_list(parsed_qs, **kwargs)
        if 'dynamic_route_id' in kwargs:
            ret['dynamic_route_id'] = kwargs['dynamic_route_id']
        return ret


# ------ DynamicRoutePri -------


# ++++++ DynamicRouteOverride +++++++
class DynamicRouteOverCreate(DnlCreate):
    scheme_class = DynamicRouteOverScheme
    entity = 'DynamicRouteOver'
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.dynamic_route_id = kwargs['dynamic_route_id']
        cls = model.DynamicRouteOverride
        q = cls.filter(and_(cls.resource_id == obj.resource_id, cls.digits == obj.digits)).first()
        # if q:
        #     raise ValidationError(
        #         {'digits': ['prefix {} duplicate for resource {}'.format(obj.digits, obj.resource_id)]})
        return obj


class DynamicRouteOverResource(DnlResource):
    model_class = model.DynamicRouteOverride
    scheme_class = DynamicRouteOverScheme
    scheme_class_get = DynamicRouteOverSchemeGet
    scheme_class_modify = DynamicRouteOverScheme
    entity = 'DynamicRouteOver'
    id_field = 'id'
    has_update_by = True
    security = (DEFAULT_SECURITY)
    restrict = ()


class DynamicRouteOverList(DnlList):
    scheme_class = DynamicRouteOverSchemeGet
    model_class = model.DynamicRouteOverride
    entity_plural = 'DynamicRouteOver list'
    path_parameters = ({'name': 'dynamic_route_id', 'description': 'Parent DynamicRoute'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(DynamicRouteOverList, self).modify_query_from_ordering_for_list(ordering, query,
                                                                                                   **kwargs)
        cls = self.model_class
        if ordering and 'by' in ordering:
            if ordering['by'] == 'digits':
                digits = func.cast(cls.digits, model.String)
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    query = query.order_by(func.length(digits)).order_by(digits)
                else:
                    query = query.order_by(func.length(digits).desc()).order_by(digits.desc())
        return ordering, query

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(DynamicRouteOverList, self).get_filtering_for_list(parsed_qs, **kwargs)
        if 'dynamic_route_id' in kwargs:
            ret['dynamic_route_id'] = kwargs['dynamic_route_id']
        return ret


# ------ DynamicRouteOverride -------


# ------ QosTotal ------

class QosTotalIngressList(DnlList):
    scheme_class = QosTotalIngressSchemeGet
    model_class = model.QosTotal
    entity_plural = 'QosTotals'
    # path_parameters=()
    security = (DEFAULT_SECURITY)
    restrict = ()
    # search_fields = ('start_date', 'end_date', 'server_ip')
    """
    def on_get(self, req, resp, **kwargs):
        #raise Exception(req.query_string)
        #req.query_string=req.query_string.replace('is_active','status')
        DnlList.on_get(self,req, resp, **kwargs)
"""

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        filtering = {}

        for k, v in parsed_qs.items():
            if k in ['per_page', 'page', 'order_by', 'order_dir']:
                continue
            # if k == 'start_date':
            filtering[k] = v
        # raise Exception(str(filtering))
        return filtering

    #    @staticmethod
    #    def modify_query_from_filtering_for_list(filtering):
    #        raise Exception(filtering)
    #        #from pudb import set_trace
    def get_objects_list(self, req, model_class, **kwargs):
        # qs = get_db(model_class.db_label).session.query(model_class)
        # raise Exception(str(req.params))
        params = req.params
        return model_class.get_max_ingress_by_period(params['start_date'], params['end_date'], params['server_ip'])


class QosTotalReport(CustomGetAction):
    query_parameters = [
        {"name": "interval", "type": "string", "default": "24 hour",
         "enum": ['15 minute', '30 minute', '1 hour', '24 hour', '7 days', '15 days', '30 days', '60 days'],
         "description": "report interval, one of:('15 minute','30 minute','1 hour','24 hour','7 days','15 days','30 days','60 days')"},
        {"name": "step", "description": "groupping interval", "enum": ['minute', 'hour', 'day', 'month']},

    ]
    scheme_class = QosTotalSchemeGet
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=QosTotalSchemeGet),)
    model_class = model.QosTotal

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        try:
            user = self.get_user(self.req)
            params = dict(parse_qsl(req.query_string))
            cls = self.model_class
            fmt = 'YYYY-MM-DD HH24:MI:00'
            # if 'day' in params['interval']:
            #     fmt = 'YYYY-MM-DD HH24:00:00'
            # if params['interval'] in ('24 hour', '7 days', '15 days', '30 days'):
            #     fmt = 'YYYY-MM-DD HH24:00:00'

            if 'step' in params:
                step = params['step']
                if step == 'hour':
                    fmt = 'YYYY-MM-DD HH24:00:00'
                if step == 'day':
                    fmt = 'YYYY-MM-DD'
                if step == 'month':
                    fmt = 'YYYY-MM'
                if step == 'year':
                    fmt = 'YYYY'
                if step == 'week':
                    fmt = 'WW'
            group_time = func.to_char(cls.report_time, fmt)
            q = cls.session().query(group_time.label('report_time'),
                                    func.max(cls.call).label('call'),
                                    func.max(cls.cps).label('cps'),
                                    func.max(cls.channels).label('channels'),
                                    func.max(cls.ingress_cps).label('ingress_cps'),
                                    func.max(cls.ingress_channels).label('ingress_channels'),
                                    func.max(cls.egress_cps).label('egress_cps'),
                                    func.max(cls.egress_channels).label('egress_channels')
                                    ).filter(
                cls.report_time.between(text_("(now() - interval '{}')::TIMESTAMP".format(params['interval'])),
                                        text_("now()"))).group_by(group_time).order_by(group_time)
            log.debug(str(q))
            objects_list = q.all()
            total = len(objects_list)
            per_page = total
            page = 0
            self.set_response(
                resp, responses.SuccessResponse(
                    data={
                        'items': self.scheme_class().dump(objects_list, many=True).data,
                        'total': total, 'page': page, 'per_page': per_page
                    },
                    scheme=schemes.ObjectScheme
                )
            )
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class QosReport(CustomGetAction):
    query_parameters = [
        {"name": "start_time", "type": "string", "required": True, "description": "report start unix timestamp"},
        {"name": "end_time", "type": "string", "required": True, "description": "report end unix timestamp"},
        {"name": "report_type", "description": "report type", "required": True,
         "enum": ['total_usage_report', 'term_client_report', 'orig_client_report', 'ingress_trunk_report',
                  'egress_trunk_report', 'ingress_ip_report', 'egress_ip_report']},
        {"name": "server_ip", "type": "string", "description": "switch server ip"},
        {"name": "client_id", "type": "string",
         "description": "client id list (works only for 'orig_client_report', 'term_client_report')"},
        {"name": "res_id", "type": "string", "description": "trunk id list (works for 'ingress_trunk_report',\
                  'egress_trunk_report', 'ingress_ip_report', 'egress_ip_report')"},
        {"name": "trunk_type2", "description": "Termination/DID trunk type (works for 'ingress_trunk_report',\
                  'egress_trunk_report', 'ingress_ip_report', 'egress_ip_report')",
         "type": "string", "enum": ['Termination Traffic', 'DID Traffic']},
        {"name": "step", "description": "time groupping interval", "enum": ['minute', 'hour', 'day', 'month', 'all'],
         "description": "'all' means all  qos table time intervals"},

    ]
    scheme_class = QosTotalSchemeGet
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=QosTotalSchemeGet),)
    model_class = model.QosTotal

    def on_get(self, req, resp, **kwargs):
        import time
        _start = time.time()
        self.init_req(req)
        kwargs = client_context(self, req, resp, **kwargs)
        ret = self.proceed(req, resp, **kwargs)
        _end = time.time()
        log.info('report/qos execution time {}'.format(_end - _start))
        return ret

    def apply(self, obj, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        user = self.get_user(self.req)
        params = dict(parse_qsl(req.query_string))

        start_time = params.pop('start_time', None)
        end_time = params.pop('end_time', '0')

        if not start_time:
            raise ValidationError('missing start time')
        try:
            st = int(start_time)
            if st < 0:
                raise ValidationError('wrong start time (unsupported date)')
        except ValueError:
            pass
        try:
            start_time = str(datetime.fromtimestamp(int(start_time), UTC))
            if end_time == '0':
                end_time = str(datetime.now(UTC))
            else:
                end_time = str(datetime.fromtimestamp(int(end_time), UTC))
        except ValueError:
            pass

        fmt = 'YYYY-MM-DD HH24:MI:00'
        # if 'day' in params['interval']:
        #     fmt = 'YYYY-MM-DD HH24:00:00'
        # if params['interval'] in ('24 hour', '7 days', '15 days', '30 days'):
        #     fmt = 'YYYY-MM-DD HH24:00:00'

        if 'step' in params:
            step = params['step']
            if step == 'all':
                fmt = 'YYYY-MM-DD HH24:MI:SS'
            if step == 'hour':
                fmt = 'YYYY-MM-DD HH24:00:00'
            if step == 'day':
                fmt = 'YYYY-MM-DD'
            if step == 'month':
                fmt = 'YYYY-MM'
            if step == 'year':
                fmt = 'YYYY'
            if step == 'week':
                fmt = 'WW'

        server_ip = params.pop('server_ip', None)
        client_id = params.pop('client_id', None)
        res_id = params.pop('res_id', None)
        trunk_type2 = params.pop('trunk_type2', None)
        client_ids = []
        if client_id:
            client_ids = client_id.split(',')
            for cid in client_ids:
                cl = model.Client.get(cid)
                if not cl:
                    raise ValidationError('not found client_id {}'.format(cid))
        res_ids = []
        if res_id:
            res_ids = res_id.split(',')
            for cid in res_ids:
                cl = model.Resource.get(cid)
                if not cl:
                    raise ValidationError('not found trunk resource_id {}'.format(cid))

        report_type = params.pop('report_type', 'total_usage_report')
        cls = None
        _select = []
        _filter = []
        _group = []
        if report_type == 'total_usage_report':
            cls = model.QosTotal
            scheme_class = QosTotalSchemeGet
            group_time = func.to_char(cls.report_time, fmt)
            _select = [group_time.label('report_time'),
                       func.max(cls.call).label('call'),
                       func.max(cls.cps).label('cps'),
                       func.max(cls.channels).label('channels'),
                       func.max(cls.ingress_cps).label('ingress_cps'),
                       func.max(cls.ingress_channels).label('ingress_channels'),
                       func.max(cls.egress_cps).label('egress_cps'),
                       func.max(cls.egress_channels).label('egress_channels'),
                       cls.server_ip,
                       ]
            _group.append(group_time)
            _group.append(cls.server_ip)
        elif report_type in ('orig_client_report', 'term_client_report'):
            cls = model.QosClient
            scheme_class = QosClientSchemeGet
            group_time = func.to_char(cls.report_time, fmt)
            _select = [
                group_time.label('report_time'),
                cls.client_id.label('client_id'),
                cls.client_name.label('client_name'),
                func.max(cls.call).label('call'),
                func.max(cls.inbound_cps).label('inbound_cps'),
                func.max(cls.inbound_chan).label('inbound_chan'),
                func.max(cls.outbound_cps).label('outbound_cps'),
                func.max(cls.outbound_chan).label('outbound_chan'),
            ]
            if report_type == 'orig_client_report':
                _filter.append(cls.is_orig == True)
            else:
                _filter.append(cls.is_term == True)
            _group.append(group_time.label('report_time'))
            _group.append(cls.client_id)
            _group.append(cls.client_name)
        elif report_type in ('ingress_trunk_report', 'egress_trunk_report'):
            cls = model.QosResource
            scheme_class = QosResourceSchemeGet
            group_time = func.to_char(cls.report_time, fmt)
            _select = [
                group_time.label('report_time'),
                cls.res_id.label('res_id'),
                cls.res_name.label('res_name'),
                cls.direction.label('direction'),
                cls.trunk_type2.label('trunk_type2'),
                func.max(cls.call).label('call'),
                func.max(cls.cps).label('cps'),
                func.max(cls.channels).label('channels'),
            ]
            if report_type == 'ingress_trunk_report':
                _filter.append(cls.direction == 'ingress')
            elif report_type == 'egress_trunk_report':
                _filter.append(cls.direction == 'egress')

            _group.append(group_time.label('report_time'))
            _group.append(cls.res_id)
            _group.append(cls.res_name)
            _group.append(cls.direction)
            _group.append(cls.trunk_type2)
        elif report_type in ('ingress_ip_report', 'egress_ip_report'):
            cls = model.QosIp
            scheme_class = QosIpSchemeGet
            group_time = func.to_char(cls.report_time, fmt)
            _select = [
                group_time.label('report_time'),
                cls.res_id.label('res_id'),
                cls.res_name.label('res_name'),
                cls.res_ip.label('res_ip'),
                cls.ip_id.label('ip_id'),
                cls.direction.label('direction'),
                cls.trunk_type2.label('trunk_type2'),
                func.max(cls.call).label('call'),
                func.max(cls.cps).label('cps'),
                func.max(cls.channels).label('channels'),
            ]
            if report_type == 'ingress_ip_report':
                _filter.append(cls.direction == 'ingress')
            elif report_type == 'egress_ip_report':
                _filter.append(cls.direction == 'egress')

            _group.append(group_time.label('report_time'))
            _group.append(cls.ip_id)
            _group.append(cls.res_id)
            _group.append(cls.res_name)
            _group.append(cls.res_ip)
            _group.append(cls.ip_id)
            _group.append(cls.direction)
            _group.append(cls.trunk_type2)

        q = model.get_db().session.query(*_select)
        q = q.filter(cls.report_time.between(start_time, end_time))
        if server_ip:
            _filter.append(cls.server_ip == server_ip)
        if client_ids:
            _filter.append(cls.client_id.in_(client_ids))
        if res_ids:
            _filter.append(cls.res_id.in_(res_ids))
        if trunk_type2:
            _filter.append(cls.trunk_type2 == trunk_type2)
        if _filter:
            q = q.filter(*_filter)

        q = q.group_by(*_group)
        # q = q.order_by(group_time.label('report_time'))
        log.debug(model.query_to_sting(q))
        objects_list = q.all()
        total = len(objects_list)
        per_page = total
        page = 0
        self.set_response(
            resp, responses.SuccessResponse(
                data={
                    'items': scheme_class().dump(objects_list, many=True).data,
                    'total': total, 'page': page, 'per_page': per_page
                },
                scheme=schemes.ObjectScheme
            )
        )


class QosTotalRangeReport(CustomGetAction):
    query_parameters = [
        {"name": "start_time", "type": "string"},
        {"name": "end_time", "type": "string"},
        {"name": "server_ip", "type": "string"},
        {"name": "ingress_id", "type": "string"},
        {"name": "egress_id", "type": "string"},
        {"name": "ingress_client_id", "type": "string"},
        {"name": "egress_client_id", "type": "string"},
        {"name": "step", "description": "groupping interval", "enum": ['minute', 'hour', 'day', 'month', 'all']}
    ]
    scheme_class = QosTotalSchemeGet
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=QosTotalSchemeGet),)
    model_class = model.QosTotal

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        user = self.get_user(self.req)
        params = dict(parse_qsl(req.query_string))

        start_time = params.pop('start_time', None)
        end_time = params.pop('end_time', '0')
        server_ip = params.pop('server_ip', None)
        ingress_id = params.pop('ingress_id', None)
        egress_id = params.pop('egress_id', None)
        egress_client_id = params.pop('egress_client_id', None)
        ingress_client_id = params.pop('ingress_client_id', None)
        if not start_time:
            raise ValidationError('missing start time')
        try:
            st = int(start_time)
            if st < 0:
                raise ValidationError('wrong start time (unsupported date)')
        except ValueError:
            pass
        try:
            start_time = str(datetime.fromtimestamp(int(start_time), UTC))
            if end_time == '0':
                end_time = str(datetime.now(UTC))
            else:
                end_time = str(datetime.fromtimestamp(int(end_time), UTC))
        except ValueError:
            pass

        cls = self.model_class
        if ingress_id or egress_id or egress_client_id or ingress_client_id:
            cls = model.QosResource
        fmt = 'YYYY-MM-DD HH24:MI:00'
        # if 'day' in params['interval']:
        #     fmt = 'YYYY-MM-DD HH24:00:00'
        # if params['interval'] in ('24 hour', '7 days', '15 days', '30 days'):
        #     fmt = 'YYYY-MM-DD HH24:00:00'

        if 'step' in params:
            step = params['step']
            # if step == 'all':
            #     fmt = 'YYYY-MM-DD HH24:MI:SS'
            if step == 'hour':
                fmt = 'YYYY-MM-DD HH24:00:00'
            if step == 'day':
                fmt = 'YYYY-MM-DD'
            if step == 'month':
                fmt = 'YYYY-MM'
            if step == 'year':
                fmt = 'YYYY'
            if step == 'week':
                fmt = 'WW'
        else:
            step = None
        if step and step == 'all':
            q = cls.session().query(func.max(cls.call).label('call'),
                                    func.max(cls.cps).label('cps'),
                                    func.max(cls.channels).label('channels'),
                                    func.max(cls.ingress_cps).label('ingress_cps'),
                                    func.max(cls.ingress_channels).label('ingress_channels'),
                                    func.max(cls.egress_cps).label('egress_cps'),
                                    func.max(cls.egress_channels).label('egress_channels'),
                                    cls.server_ip, cls.ingress_id, cls.egress_id,
                                    cls.egress_client_id, cls.ingress_client_id,
                                    cls.server_name
                                    ).filter(
                cls.report_time.between(start_time, end_time))
        else:
            group_time = func.to_char(cls.report_time, fmt)
            q = cls.session().query(group_time.label('report_time'),
                                    func.max(cls.call).label('call'),
                                    func.max(cls.cps).label('cps'),
                                    func.max(cls.channels).label('channels'),
                                    func.max(cls.ingress_cps).label('ingress_cps'),
                                    func.max(cls.ingress_channels).label('ingress_channels'),
                                    func.max(cls.egress_cps).label('egress_cps'),
                                    func.max(cls.egress_channels).label('egress_channels'),
                                    cls.server_ip, cls.ingress_id, cls.egress_id,
                                    cls.egress_client_id, cls.ingress_client_id,
                                    cls.server_name
                                    ).filter(
                cls.report_time.between(start_time, end_time))
        if ingress_id:
            q = q.filter(cls.ingress_id.in_(ingress_id.split(',')))
        if egress_id:
            q = q.filter(cls.egress_id.in_(egress_id.split(',')))
        if egress_client_id:
            q = q.filter(cls.egress_client_id.in_(egress_client_id.split(',')))
        if ingress_client_id:
            q = q.filter(cls.ingress_client_id.in_(ingress_client_id.split(',')))
        if server_ip:
            q = q.filter(cls.server_ip == server_ip)
        if step and step == 'all':
            q = q.group_by(cls.server_ip, cls.ingress_id, cls.egress_id,
                           cls.egress_client_id, cls.ingress_client_id, cls.server_name)
        else:
            q = q.group_by(group_time, cls.server_ip, cls.ingress_id, cls.egress_id,
                           cls.egress_client_id, cls.ingress_client_id, cls.server_name).order_by(group_time)
        log.debug(str(q))
        objects_list = q.all()
        total = len(objects_list)
        per_page = total
        page = 0
        self.set_response(
            resp, responses.SuccessResponse(
                data={
                    'items': self.scheme_class().dump(objects_list, many=True).data,
                    'total': total, 'page': page, 'per_page': per_page
                },
                scheme=schemes.ObjectScheme
            )
        )


class QosResourceReport(CustomGetAction):
    query_parameters = [
        {"name": "interval", "type": "string", "default": "24 hour",
         "enum": ['15 minute', '30 minute', '1 hour', 'today', '24 hour', '7 days', '15 days', '30 days', '60 days'],
         "description": "report interval, one of:('15 minute','30 minute','1 hour','24 hour','7 days','15 days','30 days','60 days')"
         },
        {"name": "direction", "type": "string", "default": "egress", "enum": ["ingress", "egress"]
         },
        {"name": "res_id", "type": "string", "description": "filter by resource id (array of integers)"
         },
        {"name": "server_ip", "type": "string", "description": "filter by server_ip"
         },
        {"name": "res_ip", "type": "string", "description": "filter by resource ip"
         },
        {"name": "total", "type": "boolean", "description": "add totals aggregation"
         },
        {"name": "top", "type": "integer", "description": "top limit - also top_by needed"
         },
        {"name": "top_by", "type": "string", "default": "call",
         "enum": ['call', 'cps', 'channels'],
         "description": "report top_by, one of:('call', 'cps', 'channels')"
         },
        {"name": "trunk_type2", "enum": ["Termination Traffic", "DID Traffic"]},
        {"name": "tz", "type": "string", "description": "timezone"}
    ]
    scheme_class = QosResourceSchemeGet
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=scheme_class),)
    model_class = model.QosResource

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        user = self.get_user(self.req)
        params = dict(parse_qsl(req.query_string))
        if 'direction' not in params:
            params['direction'] = 'egress'
        cls = self.model_class
        if 'res_ip' in params:  # or user.user_type == 'client':
            cls = model.QosIp
        fmt = 'YYYY-MM-DD HH24:MI:00'
        dmt = '%Y-%m-%d %H:%M:00'
        # if 'day' in params['interval']:
        #     fmt = 'YYYY-MM-DD HH24:00:00'
        # if params['interval'] in ('24 hour', '7 days', '15 days', '30 days'):
        #     fmt = 'YYYY-MM-DD HH24:00:00'
        delta = timedelta(hours=24)
        if 'interval' in params and params['interval'] != 'today':
            interval = params['interval'].split(' ')
            if interval[1] == 'minute':
                delta = timedelta(minutes=int(interval[0]))
            elif interval[1] == 'hour':
                delta = timedelta(hours=int(interval[0]))
            elif interval[1] == 'days':
                delta = timedelta(days=int(interval[0]))
        tz = params['tz'].split(':')[0] if 'tz' in params else 0
        try:
            tz = int(tz)
        except:
            log.debug('Incorrect import for timezone')
            tz = 0
        group_time = func.to_char(cls.report_time + timedelta(hours=tz), fmt)

        start_time = text_("(now() - interval '{}')::TIMESTAMP".format(params['interval']))
        if params['interval'] == 'today':
            start_time = text_("(date_trunc('day', now()))::TIMESTAMP")

        _select = [
            group_time.label('report_time'),
            cls.direction.label('direction'),
            cls.res_id.label('res_id'),
            cls.res_name.label('res_name'),
            cls.trunk_type2.label('trunk_type2'),
            cls.server_ip.label('server_ip'),
            func.max(cls.call).label('call'),
            func.max(cls.cps).label('cps'),
            func.max(cls.channels).label('channels'),
        ]
        if 'res_ip' in params:
            _select.append(
                (select(
                    [
                        case([(func.count(model.ResourceIp.ip) > 1, "")],
                             else_=func.string_agg(model.ResourceIp.ip, ','))
                    ]
                ).where(
                    and_(model.ResourceIp.resource_id == cls.res_id,
                         model.ResourceIp.reg_type == 0,
                         model.ResourceIp.ip == params['res_ip'],
                         )
                ).group_by(model.ResourceIp.resource_id).as_scalar()).label('res_ip')
            )
        else:
            _select.append(
                (select(
                    [
                        case([(func.count(model.ResourceIp.ip) > 1, "")],
                             else_=func.string_agg(model.ResourceIp.ip, ','))
                    ]
                ).where(
                    and_(model.ResourceIp.resource_id == cls.res_id,
                         model.ResourceIp.reg_type == 0)
                ).group_by(model.ResourceIp.resource_id).as_scalar()).label('res_ip')
            )

        q = cls.session().query(*_select).filter(cls.direction == params['direction']).filter(
            cls.report_time.between(
                start_time,
                text_("now()")
            )
        )
        top_res_id = []
        if 'top' in params and 'top_by' in params:
            top = params['top']
            top_by = params['top_by']
            tq = cls.session().query(cls.res_id.label('res_id')).filter(cls.direction == params['direction']).filter(
                cls.report_time.between(start_time,
                                        text_("now()")))
            if 'server_ip' in params:
                tq = tq.filter(cls.server_ip == params['server_ip'])
            if 'res_ip' in params:
                tq = tq.group_by(cls.ip_id)
            tq = tq.group_by(cls.res_id).order_by(func.sum(getattr(cls, top_by)).desc()).limit(top)
            top_res_id = [i.res_id for i in tq]
        if top_res_id:
            q = q.filter(cls.res_id.in_(top_res_id))
        res_id_in = []
        if user.user_type == 'agent':
            res_id_in = user.agent.res_id_list
        elif user.user_type == 'client':
            res_id_in = user.client.res_id_list#[user.client.resource.resource_id] if user.client.resource else
        if 'res_id' in params:
            res_ids = params['res_id'].split(',')
            for rid in res_ids:
                try:
                    rid = int(rid)
                except ValueError:
                    raise ValidationError([{'res_id': 'wrong value {}'.format(rid)}])
                r = model.Resource.get(rid)
                if not r:
                    raise ValidationError([{'res_id': 'no such resource found {}'.format(rid)}])
                res_id_in.append(rid)

        res_ip_in = []
        if 'res_ip' in params:
            res_ips = params['res_ip'].split(',')
            if res_ips:
                q.filter(cls.ip_id.in_(res_ips))
            for rid in res_ips:
                for r in model.ResourceIp.filter(model.ResourceIp.ip == rid):
                    res_ip_in.append(r.resource_id)
        if res_id_in or res_ip_in:
            if res_id_in:
                res_id_in = list(set(res_id_in).intersection(set(res_ip_in))) if res_ip_in else res_id_in
            else:
                res_id_in = res_ip_in
            q = q.filter(cls.res_id.in_(res_id_in))
        if 'trunk_type2' in params and not params['trunk_type2'] is None:
            if params['trunk_type2'] in ["Termination Traffic", "DID Traffic"]:
                trunk_type2 = params['trunk_type2']
                q = q.filter(cls.trunk_type2 == trunk_type2)
            else:
                raise ValidationError([{'trunk_type2': 'wrong value {}'.format(params['trunk_type2'])}])
        if 'server_ip' in params:
            q = q.filter(cls.server_ip == params['server_ip'])

        if 'res_ip' in params:  # or user.user_type == 'client':
            q = q.group_by(cls.ip_id)
        q = q.group_by(group_time, cls.res_id, cls.res_name, cls.server_ip, cls.direction).order_by(group_time)
        log.debug(model.query_to_sting(q))
        qcls = alias(q.subquery(), '_total_')
        if 'total' in params and params['total'].lower() == 'true':
            q1 = cls.session().query(qcls.c.report_time.label('report_time'),
                                     qcls.c.direction.label('direction'),
                                     qcls.c.trunk_type2.label('trunk_type2'),
                                     literal(None).label('res_id'),
                                     literal('Total').label('res_name'),
                                     func.sum(qcls.c.call).label('call'),
                                     func.sum(qcls.c.cps).label('cps'),
                                     func.sum(qcls.c.channels).label('channels'),
                                     )
            q1 = q1.group_by(qcls.c.report_time, qcls.c.direction, qcls.c.trunk_type2).order_by(qcls.c.report_time)
            total = q1.all()
        else:
            total = []
        objects_list = q.all() + total

        def add_null_rows(t_obj, f_date, date_to):
            delta_t = timedelta(minutes=1)
            t_obj['call'] = 0
            t_obj['channels'] = 0
            report_time_old = datetime.strptime(t_obj['report_time'], f_date)
            data = []
            if report_time_old < date_to and report_time_old + delta_t < date_to:
                while report_time_old + delta_t < date_to:
                    report_time_old = report_time_old + delta_t
                    new_obj = t_obj.copy()
                    new_obj['report_time'] = report_time_old.strftime(dmt)
                    data.append(new_obj)
            return data

        prev_obj = None
        new_object_list = []

        for obj in objects_list:
            data_new = []
            if prev_obj:
                report_time = datetime.strptime(obj._asdict()['report_time'], dmt)
                data_new = add_null_rows(prev_obj, dmt, report_time)
            else:
                date_start = datetime.utcnow() - delta
                if 'interval' in params and params['interval'] == 'today':
                    date_start = datetime(datetime.utcnow().year,
                                                   datetime.utcnow().month, datetime.utcnow().day)
                test_odj = obj._asdict()
                if datetime.strptime(test_odj['report_time'], dmt) > date_start:
                    report_time = datetime.strptime(test_odj['report_time'], dmt)
                    test_odj['report_time'] = date_start.strftime(dmt)
                    data_new = add_null_rows(test_odj, dmt, report_time)
            new_object_list += data_new
            new_object_list.append(obj._asdict())
            prev_obj = obj._asdict()

        if prev_obj:
            date_end = datetime.utcnow()
            new_object_list += add_null_rows(prev_obj, dmt, date_end)

        objects_list = new_object_list

        total = len(objects_list)
        per_page = total
        page = 0
        self.set_response(
            resp, responses.SuccessResponse(
                data={
                    'items': self.scheme_class().dump(objects_list, many=True).data,
                    'total': total, 'page': page, 'per_page': per_page
                },
                scheme=schemes.ObjectScheme
            )
        )


class QosIpReport(CustomGetAction):
    query_parameters = [
        {"name": "interval", "type": "string", "default": "24 hour",
         "enum": ['15 minute', '30 minute', '1 hour', '24 hour', 'today', '7 days', '15 days', '30 days', '60 days'],
         "description": "report interval, one of:('15 minute','30 minute','1 hour','24 hour', 'today','7 days','15 days','30 days','60 days')"
         },
        {"name": "start_time", "type": "string"},
        {"name": "end_time", "type": "string"},
        {"name": "step", "description": "groupping interval", "enum": ['minute', '5 min', '30 min', 'hour', 'day', 'month', 'all']},
        {"name": "direction", "type": "string", "default": "egress", "enum": ["ingress", "egress"]
         },
        {"name": "res_id", "type": "string", "description": "filter by resource id (array of integers)"
         },
        {"name": "server_ip", "type": "string", "description": "filter by server_ip"
         },
        {"name": "res_ip", "type": "string", "description": "filter by resource ip"
         },
        {"name": "total", "type": "boolean", "description": "add totals aggregation"
         },
        {"name": "top", "type": "integer", "description": "top limit - also top_by needed"
         },
        {"name": "top_by", "type": "string", "default": "call",
         "enum": ['call', 'cps', 'channels'],
         "description": "report top_by, one of:('call', 'cps', 'channels')"
         },
        {"name": "trunk_type2", "enum": ["Termination Traffic", "DID Traffic"]},
        {"name": "tz", "type": "string", "description": "timezone"},
        {"name": "group_by", "enum": ["res_id", "res_ip"]}
    ]
    scheme_class = QosResourceSchemeGet
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=scheme_class),)
    model_class = model.QosIp

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        user = self.get_user(self.req)
        params = dict(parse_qsl(req.query_string))
        
        # Validate and set direction
        if 'direction' not in params:
            params['direction'] = 'egress'
        elif params['direction'] not in ['ingress', 'egress']:
            raise ValidationError([{'direction': 'Invalid direction value. Must be "ingress" or "egress"'}])
            
        # Validate group_by parameter
        group_by = params.get('group_by')
        if group_by and group_by not in ['res_id', 'res_ip']:
            raise ValidationError([{'group_by': 'Invalid group_by value. Must be "res_id" or "res_ip"'}])

        cls = self.model_class
        fmt = 'YYYY-MM-DD HH24:MI:00'
        step = params.get('step')
        
        # Set format based on step
        if step:
            if step == 'all':
                fmt = 'YYYY-MM-DD HH24:MI:SS'
            elif step in ['5 min', '30 min', 'hour']:
                fmt = 'YYYY-MM-DD HH24:00:00'
            elif step == 'day':
                fmt = 'YYYY-MM-DD 00:00:00'
            elif step == 'month':
                fmt = 'YYYY-MM-01 00:00:00'
            elif step == 'year':
                fmt = 'YYYY-01-01 00:00:00'
            elif step == 'week':
                fmt = 'WW'

        dmt = '%Y-%m-%d %H:%M:%S'
        
        # Handle interval parameter
        delta = timedelta(hours=24)
        if 'interval' in params and params['interval'] != 'today':
            interval = params['interval'].split(' ')
            if len(interval) != 2:
                raise ValidationError([{'interval': 'Invalid interval format'}])
                
            try:
                interval_value = int(interval[0])
                if interval[1] == 'minute':
                    delta = timedelta(minutes=interval_value)
                elif interval[1] == 'hour':
                    delta = timedelta(hours=interval_value)
                elif interval[1] == 'days':
                    delta = timedelta(days=interval_value)
                else:
                    raise ValidationError([{'interval': 'Invalid interval unit'}])
            except ValueError:
                raise ValidationError([{'interval': 'Invalid interval value'}])

        # Handle timezone
        try:
            tz = int(params.get('tz', '0').split(':')[0])
        except ValueError:
            log.debug('Incorrect format for timezone')
            tz = 0

        # Build select fields based on group_by
        select = [
            cls.res_id.label('res_id'),
            cls.res_name.label('res_name'),
            cls.trunk_type2.label('trunk_type2'),
            func.max(cls.server_ip).label('server_ip'),
            func.max(cls.call).label('call'),
            func.max(cls.cps).label('cps'),
            func.max(cls.channels).label('channels')
        ]

        if not group_by or group_by == 'res_ip':
            select.extend([
                cls.ip_id.label('ip_id'),
                cls.direction.label('direction'),
                cls.res_ip.label('res_ip'),
            ])

        # Handle time range
        start_time = params.get('start_time')
        if start_time is None:
            start_time = text_("(now() - interval '{}')::TIMESTAMP".format(params['interval']))
            if params['interval'] == 'today':
                start_time = text_("(date_trunc('day', now()))::TIMESTAMP")
        else:
            try:
                start_time = str(datetime.fromtimestamp(int(start_time), UTC))
            except ValueError:
                raise ValidationError([{'start_time': 'Invalid timestamp'}])

        end_time = params.get('end_time')
        if end_time is None or end_time == '0':
            end_time = text_("now()")
        else:
            try:
                end_time = str(datetime.fromtimestamp(int(end_time), UTC))
            except ValueError:
                raise ValidationError([{'end_time': 'Invalid timestamp'}])

        # Set group_time based on step
        if step == "all":
            group_time = cls.report_time
        elif step == "minute":
            group_time = func.date_trunc('minute', cls.report_time)
        elif step == "5 min":
            group_time = func.to_timestamp(
                func.floor(func.extract('epoch', cls.report_time) / 300) * 300
            )
        elif step == "30 min":
            group_time = func.to_timestamp(
                func.floor(func.extract('epoch', cls.report_time) / 1800) * 1800
            )
        elif step == "hour":
            group_time = func.date_trunc('hour', cls.report_time)
        elif step == "day":
            group_time = func.date_trunc('day', cls.report_time)
        elif step == "week":
            group_time = func.date_trunc('week', cls.report_time)
        elif step == "month":
            group_time = func.date_trunc('month', cls.report_time)
        elif step == "year":
            group_time = func.date_trunc('year', cls.report_time)
        else:
            group_time = cls.report_time

        # Build base query
        q = cls.session().query(
            *select, group_time.label('report_time')
        ).filter(
            cls.direction == params['direction']
        ).filter(
            cls.report_time.between(start_time, end_time)
        )

        # Handle top parameter
        if 'top' in params and 'top_by' in params:
            try:
                top = int(params['top'])
                if top <= 0:
                    raise ValueError
            except ValueError:
                raise ValidationError([{'top': 'Invalid top value'}])

            top_by = params['top_by']
            if top_by not in ['call', 'cps', 'channels']:
                raise ValidationError([{'top_by': 'Invalid top_by value'}])

            tq = cls.session().query(cls.res_id.label('res_id')).filter(
                cls.direction == params['direction']
            ).filter(
                cls.report_time.between(start_time, end_time)
            )

            # Handle trunk_type2 filter
            if 'trunk_type2' in params and params['trunk_type2'] is not None:
                trunk_type2 = params['trunk_type2']
                if trunk_type2 in ["Termination Traffic", "DID Traffic"]:
                    tq = tq.filter(
                        or_(
                            cls.trunk_type2 == trunk_type2,
                            and_(cls.trunk_type2.is_(None), cls._trunk_type2 == trunk_type2)
                        )
                    )
                else:
                    raise ValidationError([{'trunk_type2': f'Invalid value {trunk_type2}'}])

            if 'server_ip' in params:
                tq = tq.filter(cls.server_ip == params['server_ip'])

            top_res_id = [i.res_id for i in tq.group_by(cls.res_id)
                         .order_by(func.sum(getattr(cls, top_by)).desc())
                         .limit(top)]
            
            if top_res_id:
                q = q.filter(cls.res_id.in_(top_res_id))

        # Handle user permissions
        res_id_in = []
        if user.user_type == 'agent':
            res_id_in = user.agent.res_id_list
        elif user.user_type == 'client':
            res_id_in = user.client.res_id_list

        # Handle res_id filter
        if 'res_id' in params:
            try:
                res_ids = [int(rid) for rid in params['res_id'].split(',')]
                for rid in res_ids:
                    r = model.Resource.get(rid)
                    if not r:
                        raise ValidationError([{'res_id': f'Resource not found: {rid}'}])
                    res_id_in.append(rid)
            except ValueError:
                raise ValidationError([{'res_id': 'Invalid resource ID format'}])

        if res_id_in or user.user_type in ('client', 'vendor'):
            q = q.filter(cls.res_id.in_(res_id_in))

        # Handle res_ip filter
        if 'res_ip' in params:
            res_ips = params['res_ip'].split(',')
            q = q.filter(cls.res_ip.in_(res_ips))

        # Handle trunk_type2 filter
        if 'trunk_type2' in params and params['trunk_type2'] is not None:
            trunk_type2 = params['trunk_type2']
            if trunk_type2 in ["Termination Traffic", "DID Traffic"]:
                q = q.filter(
                    or_(
                        cls.trunk_type2 == trunk_type2,
                        and_(cls.trunk_type2.is_(None), cls._trunk_type2 == trunk_type2)
                    )
                )
            else:
                raise ValidationError([{'trunk_type2': f'Invalid value {trunk_type2}'}])

        # Handle server_ip filter
        if 'server_ip' in params:
            q = q.filter(cls.server_ip == params['server_ip'])
            q = q.group_by(cls.server_ip)

        # Apply grouping based on group_by parameter
        if not group_by:
            q = q.group_by(group_time, cls.ip_id, cls.direction).order_by(group_time)
        elif group_by == 'res_ip':
            q = q.group_by(
                cls.res_id, cls.res_name, cls.trunk_type2,
                cls.ip_id, cls.direction, group_time
            ).order_by(group_time)
        else:  # group_by == 'res_id'
            q = q.group_by(
                cls.res_id, cls.res_name, cls.trunk_type2, group_time
            ).order_by(group_time)

        log.debug(str(q))

        # Handle totals
        objects_list = []
        if params.get('total', '').lower() == 'true':
            qcls = alias(q.subquery(), '_total_')
            select = [
                qcls.c.trunk_type2.label('trunk_type2'),
                literal(None).label('res_id'),
                literal('Total').label('res_name'),
                func.sum(qcls.c.call).label('call'),
                func.sum(qcls.c.cps).label('cps'),
                func.sum(qcls.c.channels).label('channels')
            ]
            
            if not group_by:
                select.extend([
                    qcls.c.report_time.label('report_time'),
                    qcls.c.direction.label('direction'),
                ])
                
            q1 = cls.session().query(*select)
            
            if not group_by:
                q1 = q1.group_by(
                    qcls.c.report_time, qcls.c.direction, qcls.c.trunk_type2
                ).order_by(qcls.c.report_time)
            else:
                q1 = q1.group_by(qcls.c.trunk_type2)
                
            objects_list.extend(q1.all())

        objects_list.extend(q.all())
        objects_list = [obj._asdict() for obj in objects_list]

        # Adjust timezone for report_time
        if not group_by:
            for obj in objects_list:
                obj['report_time'] = (obj['report_time'] + timedelta(hours=tz)).isoformat()

        total = len(objects_list)
        per_page = total
        page = 0
        
        self.set_response(
            resp, responses.SuccessResponse(
                data={
                    'items': self.scheme_class().dump(objects_list, many=True).data,
                    'total': total,
                    'page': page,
                    'per_page': per_page
                },
                scheme=schemes.ObjectScheme
            )
        )


class QosResourceRangeReport(CustomGetAction):
    query_parameters = [
        {"name": "start_time", "type": "string"},
        {"name": "end_time", "type": "string"},
        {"name": "step", "description": "groupping interval", "enum": ['minute', '5 min', '30 min', 'hour', 'day', 'month', 'all']},
        {"name": "group", "description": "groupping field", "enum": ['res_id', 'direction', 'server_ip']},
        {"name": "res_id", "type": "integer"},
        {"name": "direction", "type": "integer"},
        {"name": "server_ip", "type": "string"},
    ]
    scheme_class = QosResourceSchemeGet
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=QosResourceSchemeGet),)
    model_class = model.QosResource

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        user = self.get_user(self.req)
        params = dict(parse_qsl(req.query_string))

        start_time = params.pop('start_time', None)
        end_time = params.pop('end_time', '0')
        group = params.pop('group', None)
        res_id = params.pop('res_id', None)
        direction = params.pop('direction', None)
        server_ip = params.pop('server_ip', None)
        errors = []
        if not start_time:
            errors.append('missing start time')
        try:
            st = int(start_time)
            if st < 0:
                errors.append('wrong start time (unsupported date)')
        except ValueError:
            pass
        if group and group not in ['res_id', 'direction', 'server_ip']:
            errors.append("wrong group {}, must be one of ['res_id','direction','server_ip']".format(group))
        if errors:
            raise ValidationError(errors)
        try:
            start_time = str(datetime.fromtimestamp(int(start_time), UTC))
            if end_time == '0':
                end_time = str(datetime.now(UTC))
            else:
                end_time = str(datetime.fromtimestamp(int(end_time), UTC))
        except ValueError:
            pass

        cls = self.model_class
        fmt = 'YYYY-MM-DD HH24:MI:00'
        # if 'day' in params['interval']:
        #     fmt = 'YYYY-MM-DD HH24:00:00'
        # if params['interval'] in ('24 hour', '7 days', '15 days', '30 days'):
        #     fmt = 'YYYY-MM-DD HH24:00:00'

        step = params.get('step', None)
        if step == 'all':
            fmt = 'YYYY-MM-DD HH24:MI:SS'
        elif step == '5 min':
            fmt = 'YYYY-MM-DD HH24:'
        elif step == '30 min':
            fmt = 'YYYY-MM-DD HH24:'
        elif step == 'hour':
            fmt = 'YYYY-MM-DD HH24:00:00'
        elif step == 'day':
            fmt = 'YYYY-MM-DD'
        elif step == 'month':
            fmt = 'YYYY-MM'
        elif step == 'year':
            fmt = 'YYYY'
        elif step == 'week':
            fmt = 'WW'
        group_time = func.to_char(cls.report_time, fmt)
        if step in ('5 min', '30 min'):
            min_step = int(step.split(' ')[0])
            group_time = func.concat(group_time,
                                     cast_((cast_(func.extract('minute', cls.report_time), Integer_) / min_step * min_step), _String))
        _select = [group_time.label('report_time'),
                   func.max(cls.call).label('call'),
                   func.max(cls.cps).label('cps'),
                   func.max(cls.channels).label('channels')]
        if group:
            _select.append(getattr(cls, group).label(group))
            if group == 'res_id':
                ing = aliased(model.Resource)
                _select.append(
                    select([ing.alias]).where(ing.resource_id == cls.res_id).as_scalar().label('res_name'))
        q = cls.session().query(*_select
                                ).filter(
            cls.report_time.between(start_time, end_time))
        if res_id:
            q = q.filter(cls.res_id == res_id)
        if direction:
            q = q.filter(cls.direction == direction)
        if server_ip:
            q = q.filter(cls.server_ip == server_ip)
        if group:
            q = q.group_by(group_time, getattr(cls, group)).order_by(group_time, getattr(cls, group))
        else:
            q = q.group_by(group_time).order_by(group_time)
        log.debug(str(q))
        objects_list = q.all()
        total = len(objects_list)
        per_page = total
        page = 0
        self.set_response(
            resp, responses.SuccessResponse(
                data={
                    'items': self.scheme_class().dump(objects_list, many=True).data,
                    'total': total, 'page': page, 'per_page': per_page
                },
                scheme=schemes.ObjectScheme
            )
        )


class QosRouteTop10Report(CustomGetAction):
    query_parameters = [
        {"name": "interval", "type": "string", "default": "24 hour",
         "enum": ['15 minute', '30 minute', '1 hour', '24 hour', '7 days', '15 days', '30 days', '60 days'],
         "description": "report interval, one of:('15 minute','30 minute','1 hour','24 hour','7 days','15 days','30 days','60 days')"
         },
        {"name": "direction", "type": "integer", "default": "0", "description": "0 - ingress,1 - egress"},
        {"name": "trunk_type2", "enum": ["Termination Traffic", "DID Traffic"]},
        {"name": "agg_on", "enum": ["client", "trunk"]}
    ]
    scheme_class = QosRouteReportTop10SchemeGet
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=QosRouteReportTop10SchemeGet),)
    model_class = model.t_qos_route_report

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        try:
            from api_dnl.views.report import Report
            user = self.get_user(self.req)
            params = dict(parse_qsl(req.query_string))
            cls = self.model_class
            fmt = 'YYYY-MM-DD HH24:MI:00'

            group_time = func.to_char(cls.c.report_time, fmt)
            # client_name = select([model.Resource.client_name]).where(model.Resource.resource_id==cls.c.resource_id).scalar()
            # client_name = cls.c.resource_id
            end_time = int(datetime.now().timestamp())
            if 'minute' in params['interval']:
                start_time = int(
                    (datetime.now() - timedelta(minutes=int(params['interval'].split(' ')[0]))).timestamp())
            elif 'hour' in params['interval']:
                start_time = int((datetime.now() - timedelta(hours=int(params['interval'].split(' ')[0]))).timestamp())
            elif 'days' in params['interval']:
                start_time = int((datetime.now() - timedelta(days=int(params['interval'].split(' ')[0]))).timestamp())
            _params = {
                'start_time': start_time, 'end_time': end_time, 'group': 'ingress_id,ingress_client_id',
                'sort': 'ingress_call_cost',
                'fields': 'ingress_total_calls,ingress_call_cost,egress_total_calls,egress_call_cost,not_zero_calls,duration', 'order': 'desc'
            }
            if params.get('trunk_type2', None):
                resources = model.Resource.session().query(model.Resource.resource_id).filter(
                    model.Resource.trunk_type2 == params['trunk_type2']).all()
            else:
                resources = model.Resource.session().query(model.Resource.resource_id).all()
            resource_ids = [str(resource.resource_id) for resource in resources]
            if user.user_type == 'agent':
                resource_ids = [str(resource.resource_id) for resource in resources if
                                resource.resource_id in user.agent.res_id_list]
                _params['ingress_client_id'] = ','.join([str(cl_id) for cl_id in user.agent.client_id_list]) if user.agent.client_id_list else '0'
            if 'direction' in params and params['direction'] in (1, '1'):
                _params['egress_id'] = ','.join(resource_ids)
                _params['sort'] = 'egress_call_cost'
                _params['group'] = 'egress_id,egress_client_id'
            else:
                _params['ingress_id'] = ','.join(resource_ids)
            if 'agg_on' in params and params['agg_on'] == 'client':
                _params['group'] = _params['group'].split(',')[1]
            data = Report().run(**_params)
            cond = lambda row: any([row.get('egress_id', None), row.get('ingress_id', None),
                                    row.get('egress_client_id', None), row.get('ingress_client_id', None)])
            objects_list = [(lambda i: i.update(minutes=i['duration'] / 60) or i)(i) for i in data if cond(i)][:10]
            total = len(objects_list)
            per_page = total
            page = 0
            items = self.scheme_class().dump(objects_list, many=True).data
            self.set_response(
                resp, responses.SuccessResponse(
                    data={
                        'items': items,
                        # 'items':objects_list,
                        'total': total, 'page': page, 'per_page': per_page
                    },
                    scheme=schemes.ObjectScheme
                )
            )
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class QosRouteReport(CustomGetAction):
    query_parameters = [
        {"name": "interval", "type": "string", "default": "24 hour",
         # "enum": ['15 minute', '30 minute', '1 hour', '24 hour', '7 days', '15 days', '30 days', '60 days'],
         "enum": ['15 minute', '30 minute', '1 hour', '24 hour', 'today', 'yesterday', 'previous week', '7 days',
                  '15 days', '30 days', '60 days'],
         # "description": "report interval, one of:('15 minute','30 minute','1 hour','24 hour','7 days','15 days','30 days','60 days')"
         "description": "report interval, one of:('1 hour', '24 hour', 'today', 'yesterday', 'previous week')"
         },
        {"name": "trunk_type2", "type": "string", "enum": ['Termination Traffic', 'DID Traffic'],
         "default": "Termination Traffic"},
        {"name": "direction", "type": "integer", "default": "0", "description": "0 - ingress,1 - egress"},
        {"name": "res_id", "description": "trunk list"},
        {"name": "group_by_trunk", "type": "boolean"}
    ]
    scheme_class = QosRouteReportSchemeGet
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=QosRouteReportSchemeGet),)
    model_class = model.t_qos_route_report
    path_parameters = [{"name": "field", "description": "get datat for field"}]

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        try:
            field = kwargs['field']
            if field not in ('asr', 'qsr', 'acd', 'pdd', 'revenue', 'profitability'):
                raise ValidationError('wrong path {}'.format(field))

            user = self.get_user(self.req)
            params = dict(parse_qsl(req.query_string))
            cls = self.model_class
            fmt = 'YYYY-MM-DD HH24:MI:00'
            group_time = func.to_char(cls.c.report_time, fmt)
            # alias = select([model.Resource.alias]).where(model.Resource.resource_id==cls.c.resource_id).scalar()
            # client_name = cls.c.resource_id

            sel = [group_time.label('report_time')]
            interval = params['interval']
            filter = []
            if interval in ('15 minute', '30 minute', '1 hour', '24 hour', '7 days', '15 days', '30 days', '60 days'):
                filter = [cls.c.report_time.between(
                    text_("(CURRENT_TIMESTAMP - interval '{}')::TIMESTAMP".format(interval)),
                    text_("CURRENT_TIMESTAMP"))
                ]
            elif interval == 'today':
                filter = [func.date_trunc('day', cls.c.report_time) ==
                          # datetime.now(UTC).date()
                          text_("current_date")
                          ]
            elif interval == 'yesterday':
                filter = [func.date_trunc('day', cls.c.report_time) ==
                          # (datetime.now(UTC).date()-timedelta(hours=24)).date()
                          text_("current_date-1")
                          ]
            elif interval == 'previous week':
                filter = [
                    func.date_trunc('day', cls.c.report_time) >
                    text_("current_date - ((extract(DOW FROM cast(CURRENT_TIMESTAMP as TIMESTAMP)))::integer)")
                ]
            group = [group_time]
            if field == 'qsr':
                sel.append(
                    (100.0 * func.round((func.sum(cls.c.not_zero_calls) + func.sum(cls.c.busy_calls) + func.sum(
                        cls.c.cancel_calls)) / func.sum(cls.c.total_calls), 4)).label('qsr'))
            if field == 'asr':
                sel.append(
                    (100.0 * func.round(
                    cast_(func.sum(cls.c.not_zero_calls), Numeric) / cast_(func.sum(cls.c.total_calls), Numeric), 4)).label('asr'))
            elif field == 'acd':
                sel.append(
                    (func.round(func.sum(cls.c.bill_time / 60.0) / func.sum(cls.c.not_zero_calls), 4)).label('acd'))
            elif field == 'pdd':
                sel.append((func.round(func.sum(cls.c.total_pdd) / func.sum(cls.c.total_calls), 4)).label('pdd'))
            elif field == 'revenue':
                trunk_type2 = params.get('trunk_type2', None)
                sel.append(
                    (func.abs(func.sum(case([(cls.c.not_zero_calls > 0, cls.c.cost)], else_=0)))).label('revenue'))
                # if trunk_type2 == 'DID Traffic':
                #     params.pop('direction', None)
                #     filter.append(cls.c.direction == 1)
            elif field == 'profitability':
                sel.append((func.sum(case([(cls.c.direction == 0, cls.c.cost)], else_=0))).label('ingress_cost'))
                sel.append((func.sum(case([(cls.c.direction == 1, cls.c.cost)], else_=0))).label('egress_cost'))
                trunk_type2 = params.get('trunk_type2', 'Termination Traffic')
                # if trunk_type2 == 'Termination Traffic':
                #     sel.append(
                #         func.abs(func.round((func.sum(case([(cls.c.direction == 0, cls.c.cost)], else_=0)) - func.sum(
                #             case([(cls.c.direction == 1, cls.c.cost)], else_=0))) / func.sum(
                #             case([(cls.c.direction == 0, cls.c.cost)], else_=1)), 4)).label('profitability'))
                # else:
                #     sel.append(
                #         func.abs(func.round((func.sum(case([(cls.c.direction == 1, cls.c.cost)], else_=0)) - func.sum(
                #             case([(cls.c.direction == 0, cls.c.cost)], else_=0))) / func.sum(
                #             case([(cls.c.direction == 1, cls.c.cost)], else_=1)), 4)).label('profitability'))
            if field in ('acd',):# 'profitability'):
                filter.append(cls.c.not_zero_calls > 0)

            if 'trunk_type2' in params:
                filter.append(and_(model.Resource.resource_id == cls.c.resource_id,
                                   model.Resource.trunk_type2 == params['trunk_type2']))
            if 'direction' in params and field != 'profitability':
                filter.append(cls.c.direction == params['direction'])
            if 'res_id' in params and params['res_id'] != 'all':
                res = [int(r) for r in params['res_id'].split(',')]
                filter.append(cls.c.resource_id.in_(res))
            else:
                sel.append(text_("'all' as alias"))
            if 'group_by_trunk' in params and params['group_by_trunk'] in (True, 'true'):
                if field == 'revenue':
                    sel.append(model.Client.name.label('alias'))
                    filter.append(and_(model.Resource.resource_id == cls.c.resource_id,
                                       model.Client.client_id == model.Resource.client_id))
                    group.append(model.Client.name)
                else:
                    sel.append(model.Resource.alias.label('alias'))
                    filter.append(model.Resource.resource_id == cls.c.resource_id)
                    group.append(model.Resource.alias)
            sql = select(sel).where(and_(*filter)).group_by(*group).order_by(*group)
            log.debug(str(sql))
            q = model.get_db().engine.execute(sql)
            objects_list = [i for i in q]  # q.all()
            total = len(objects_list)
            per_page = total
            page = 0
            self.set_response(
                resp, responses.SuccessResponse(
                    data={
                        'items': self.scheme_class().dump(objects_list, many=True).data,
                        # 'items':objects_list,
                        'total': total, 'page': page, 'per_page': per_page
                    },
                    scheme=schemes.ObjectScheme
                )
            )
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


# --------------ResourceBlock
class ResourceBlockCreate(DnlCreate):
    scheme_class = ResourceBlockScheme
    entity = 'ResourceBlock'
    unique_field = 'res_block_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    import_key_fields = ('ani_prefix', 'digit', 'egress_client_id', 'ingress_client_id',
                         'ingress_res_id', 'engress_res_id', 'ingress_group_id', 'egress_group_id')

    def on_post(self, req, resp, **kwargs):
        if 'time_profile_id' in req.data:
            req.data['time_profile_id'] = req.data['time_profile_id'] or None
        return super(ResourceBlockCreate, self).on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):
        log.debug("BEFORE CREATE")
        if 'block_type' in self.req_data:
            log.debug("BLOCK TYPE IN SELF.REQ_DATA")
            log.debug(f"BLOCK_TYPE = {self.req_data['block_type']}")
            if self.req_data['block_type'] == 'specific trunk':
                if not obj.ingress_res_id and not obj.engress_res_id:
                    raise ValidationError({'block_type': ['no one resource id for block type "specific trunk"']})
            if self.req_data['block_type'] == 'specific carrier':
                if not obj.ingress_client_id and not obj.egress_client_id:
                    raise ValidationError({'block_type': ['no one carrier id for block type "specific carrier"']})
            if self.req_data['block_type'] == 'specific group':
                if not obj.ingress_group_id and not obj.egress_group_id:
                    raise ValidationError({'block_type': ['no one group id for block type "specific group"']})
        # else:
        #    obj.block_type = 'all'

        obj.create_by = self.get_user().name
        log.debug(f"OBJ.CREATED_BY = {obj.create_by}")
        obj.update_by = self.get_user().name
        # obj.update_at = datetime.now(UTC)
        # obj.create_time = datetime.now(UTC)
        if obj.digit is None:
            obj.digit = ''
        if obj.ani_prefix is None:
            obj.ani_prefix = ''
        # if obj.ingress_trunk:
        #    ingress_client_id=obj.ingress_trunk.client_id
        # if obj.egress_trunk:
        #    egress_client_id=obj.egress_trunk.client_id
        log.debug("BEFORE CREATE FINISHED, RETURNING OBJECT")
        return obj


class ResourceBlockResource(DnlResource):
    model_class = model.ResourceBlock
    scheme_class = ResourceBlockScheme
    scheme_class_get = ResourceBlockSchemeGet
    scheme_class_modify = ResourceBlockScheme
    entity = 'ResourceBlock'
    id_field = 'res_block_id'
    has_update_by = False
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_patch(self, req, resp, **kwargs):
        if 'time_profile_id' in req.data:
            req.data['time_profile_id'] = req.data['time_profile_id'] or None
        return super(ResourceBlockResource, self).on_patch(req, resp, **kwargs)

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        return super(ResourceBlockResource, self).before_update(obj, req)


class ResourceBlockList(DnlList):
    scheme_class = ResourceBlockSchemeGet
    model_class = model.ResourceBlock
    entity_plural = 'ResourceBlocks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        log.debug(f"ORDERING  = {ordering} \t QUERY = {query}")
        
        ordering, query = super(ResourceBlockList, self).modify_query_from_ordering_for_list(ordering, query, **kwargs)
        log.debug(f"ORDERING  = {ordering} \t QUERY = {query}")
        cls = self.model_class
        if ordering and 'by' in ordering:
            if ordering['by'] == 'ANI_prefix':
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    log.debug("query = query.order_by(func.length(cls.ani_prefix)).order_by(cls.ani_prefix)")
                    query = query.order_by(func.length(cls.ani_prefix)).order_by(cls.ani_prefix)
                else:
                    log.debug("query = query.order_by(func.length(cls.ani_prefix).desc()).order_by(cls.ani_prefix.desc())")
                    query = query.order_by(func.length(cls.ani_prefix).desc()).order_by(cls.ani_prefix.desc())
            if ordering['by'] == 'DNIS_prefix':
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    log.debug("query = query.order_by(func.length(cls.digit)).order_by(cls.digit)")
                    query = query.order_by(func.length(cls.digit)).order_by(cls.digit)
                else:
                    log.debug("query = query.order_by(func.length(cls.digit).desc()).order_by(cls.digit.desc())")
                    query = query.order_by(func.length(cls.digit).desc()).order_by(cls.digit.desc())
        log.debug(f"ORDERING  = {ordering} \t QUERY = {query}")
        return ordering, query

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        user = self.get_user(self.req)
        if (user.user_type == 'client' or user.user_type == 'vendor') and user.client:
            resources = model.Resource.session().query(model.Resource.resource_id).filter(
                    model.Resource.client_id == user.client.client_id).all()
            resource_ids = [resource.resource_id for resource in resources]
            ret = ret.filter(or_(cls.ingress_res_id.in_(resource_ids), cls.engress_res_id.in_(resource_ids)))
        return filt, ret


# ------ ResourceBlock ------

# region +++ResourceCidBlock+++
class ResourceCidBlockConfigResource(DnlResource):
    model_class = model.ResourceCidBlockConfig
    scheme_class = ResourceCidBlockConfigScheme
    scheme_class_get = ResourceCidBlockConfigSchemeGet
    scheme_class_modify = ResourceCidBlockConfigSchemeModify
    entity = 'ResourceCidBlockConfig'
    id_field = 'resource_id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()

    def on_patch(self, req, resp, **kwargs):
        resource_id = int(kwargs['resource_id'])
        cls = self.model_class
        if cls.get(resource_id) is None:
            cls(resource_id=resource_id).save()
        return super(ResourceCidBlockConfigResource, self).on_patch(req, resp, **kwargs)

    def on_get(self, req, resp, **kwargs):
        resource_id = int(kwargs['resource_id'])
        cls = self.model_class
        if cls.get(resource_id) is None:
            cls(resource_id=resource_id).save()
        return super(ResourceCidBlockConfigResource, self).on_get(req, resp, **kwargs)


class ResourceCidBlockLogList(DnlList):
    scheme_class = ResourceCidBlockLogSchemeGet
    model_class = model.ResourceCidBlockLog
    entity_plural = 'ResourceCidBlockLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
        # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---ResourceCidBlock---

# --------------Route
class RoutesCreate(DnlCreate):
    scheme_class = RouteScheme
    entity = 'Route'
    unique_field = 'route_id'
    additional_responses = ()
    path_parameters = ({'name': 'route_plan_id', 'description': 'Parent route plan id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.route_strategy_id = kwargs['route_plan_id']
        if obj.route_type == 'dynamic routing':
            obj.static_route_id = None
            if obj.dynamic_route_id is None:
                raise ValidationError('dynamic_route_id must be not NULL')
        if obj.route_type == 'static routing':
            obj.dynamic_route_id = None
            if obj.static_route_id is None:
                raise ValidationError('static_route_id must be not NULL')
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        req_data = self.req.data
        if req_data.get('DNIS_prefix') is not None:
            dnis_prefix_values = req_data['DNIS_prefix'].split(',')
        else:
            dnis_prefix_values = [None]
        if req_data.get('ANI_prefix') is not None:
            ani_prefix_values = req_data['ANI_prefix'].split(',')
        else:
            ani_prefix_values = [None]
        for dnis_prefix in dnis_prefix_values:
            for ani_prefix in ani_prefix_values:
                if model.Route.check_duplicates(ani_prefix, dnis_prefix,
                                                req_data.get('ANI_min', None), req_data.get('ANI_max', None),
                                                req_data.get('DNIS_min', None), req_data.get('DNIS_max', None), obj
                                                ):
                    raise ValidationError({'ANI_prefix': ['Duplicate prefixes combination already exists.']})
        
        return obj

    def _on_post(self, req, resp, **kwargs):
        self.apply_restrict_rules(req, kwargs)
        scheme = self.scheme_class()

        if not check_permission(self, req, 'create'):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return

        if self.check_request_data(req, resp, scheme):
            try:
                log.debug("\nREQ - {}\nRESP - {}\nKWARGS - {}".format(req, resp, kwargs))
                log.debug(f"SELF.SCHEME_CLASS = {self.scheme_class}")
                log.debug(f"SCHEME = {scheme}")
                if req.data.get('DNIS_prefix') is not None:
                    dnis_prefix_list = req.data["DNIS_prefix"].split(",")
                else:
                    dnis_prefix_list = [None]
                if req.data.get('ANI_prefix') is not None:
                    ani_prefix_values = req.data['ANI_prefix'].split(',')
                else:
                    ani_prefix_values = [None]
                data = None
                for dnis_prefix in dnis_prefix_list:
                    for ani_prefix in ani_prefix_values:
                        req.data["DNIS_prefix"] = dnis_prefix
                        req.data["ANI_prefix"] = ani_prefix
                        data = self.create_object(req, scheme, **kwargs)
                        log.debug("DATA - {}".format(data))
                self.set_response(
                    resp, self.scheme_class.get_object_created_response(data=data)
                )
                log.debug("AFTER_CREATE() starting")
                self.after_create(data, req, resp, **kwargs)
            except IntegrityError as e:
                try:
                    msg = str(e).split('\n')[1].split(':')[1]
                except:
                    msg = str(e)
                try:
                    model.get_db().session.rollback()
                except Exception as e2:
                    log.error('on create error {} rollback also failed {}'.format(e, e2))

                self.set_response(resp, AlreadyExistsResponse(self.entity, msg))
            except AlreadyExists as e:
                r = AlreadyExistsResponse(self.entity, str(e))
                r.status_code = 1000
                self.set_response(resp, r)
            except FkConstraintViolation as e:
                self.set_response(resp, responses.FkConstraintViolationResponse(
                    data=errors.CommonErrors.get_fk_violation_error(
                        e.table_name, e.fk_column_name, e.column_name, e.value)
                )
                                    )
            except schemes.validate.ValidationError as e:
                self.set_response(resp, responses.ValidationErrorResponse(data=e.messages))

            except NoResultFound as e:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(data=str(e)))
                return None

            except OperationalError as e:
                self.set_response(resp, OperationalErrorResponse(e))

            except DataError as e:
                try:
                    msg = str(e).split('\n')[1].split(':')[1]
                except:
                    msg = str(e)
                log.error(e)
                # self.set_response(resp, responses.OperationErrorResponse(data=errors.CommonErrors.DataError))
                self.set_response(resp, OperationErrorResponse(e))

            except Exception as e:
                log.error(e)
                # self.set_response(resp, responses.OperationErrorResponse(data=errors.CommonErrors.DataError))
                self.set_response(resp, OperationErrorResponse(e))
        return None


class RoutesDelete(DnlCreate):
    scheme_class = RouteDeleteScheme
    entity = 'Route'
    unique_field = 'route_id'
    additional_responses = ()
    path_parameters = ({'name': 'route_plan_id', 'description': 'Parent route plan id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def _on_post(self, req, resp, **kwargs):
        self.apply_restrict_rules(req, kwargs)
        scheme = self.scheme_class()

        if not check_permission(self, req, 'create'):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return

        if self.check_request_data(req, resp, scheme):
            try:
                required_fields = ["DNIS_prefix", "ANI_prefix", "ANI_min", "ANI_max", "DNIS_min", "DNIS_max"]
                missing = [field for field in required_fields if not req.data.get(field)]
                if missing:
                    self.set_response(resp, responses.ValidationErrorResponse(
                        data={field: "Field is required" for field in missing}))
                    return

                dnis_prefixes = req.data["DNIS_prefix"].split(",")
                ani_prefixes = req.data["ANI_prefix"].split(",")
                ani_min = req.data["ANI_min"]
                ani_max = req.data["ANI_max"]
                dnis_min = req.data["DNIS_min"]
                dnis_max = req.data["DNIS_max"]

                total_deleted = 0
                for dnis in dnis_prefixes:
                    for ani in ani_prefixes:
                        query = model.get_db().session.query(model.Route).filter(
                            model.Route.DNIS_prefix == dnis,
                            model.Route.ANI_prefix == ani,
                            model.Route.ANI_min == ani_min,
                            model.Route.ANI_max == ani_max,
                            model.Route.DNIS_min == dnis_min,
                            model.Route.DNIS_max == dnis_max,
                            model.Route.route_strategy_id == kwargs['route_plan_id']
                            )
                        deleted_count = query.delete(synchronize_session='fetch')
                        total_deleted += deleted_count

                model.get_db().session.commit()
                self.set_response(
                    resp, responses.SuccessResponse(
                        data={'deleted': total_deleted},
                        scheme=schemes.ObjectScheme
                    )
                )

            except Exception as e:
                model.get_db().session.rollback()
                log.error(e)
                self.set_response(resp, OperationErrorResponse(e))

        return None


class MultipleRoutesDelete(DnlCreate):
    scheme_class = MultipleRoutesDeleteScheme
    item_scheme_class = RouteDeleteScheme
    entity = 'Route'
    unique_field = 'route_id'
    additional_responses = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_parameters = ({
        'name': 'items',
        'schema': MultipleRoutesDeleteScheme,
        'description': 'List of items to delete.'
    },)
    path_parameters = ({'name': 'route_plan_id', 'description': 'Parent route plan id'},)


    def _on_post(self, req, resp, **kwargs):
        self.apply_restrict_rules(req, kwargs)
        scheme = self.scheme_class()

        if not check_permission(self, req, 'create'):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return

        if self.check_request_data(req, resp, scheme):
            try:
                log.debug("\nREQ - {}\nRESP - {}\nKWARGS - {}".format(req, resp, kwargs))
                log.debug(f"SELF.SCHEME_CLASS = {self.item_scheme_class}")
                log.debug(f"SCHEME = {scheme}")
                log.debug(f"REQ.DATA = {req.data}")
                
                if len(req.data['items']) == 0:
                    raise ValidationError({'error': 'items list is empty'})

                fields = ["DNIS_prefix", "ANI_prefix", "ANI_min", "ANI_max", "DNIS_min", "DNIS_max"]
                for idx, item in enumerate(req.data['items']):
                    for key in list(item.keys()):
                        if item[key] in (None, ''):
                            del item[key]
                    if not any(field in item for field in fields):
                        raise ValidationError({f'items[{idx}]': 'At least one of the required fields must be present with a non-empty value.'})

                total_deleted = 0
                for item in req.data['items']:
                    filters = []
                    for field in fields:
                        if field in item:
                            filters.append(getattr(model.Route, field) == item[field])
                    
                    if filters:
                        query = model.get_db().session.query(model.Route).filter(
                            and_(*filters, model.Route.route_strategy_id == kwargs['route_plan_id'])
                            )
                        deleted_count = query.delete(synchronize_session='fetch')
                        total_deleted += deleted_count

                model.get_db().session.commit()
                self.set_response(
                    resp, responses.SuccessResponse(
                        data={'deleted': total_deleted},
                        scheme=schemes.ObjectScheme
                    )
                )

            except Exception as e:
                model.get_db().session.rollback()
                log.error(e)
                self.set_response(resp, OperationErrorResponse(e))

        return None


class RouteResource(DnlResource):
    model_class = model.Route
    scheme_class = RouteScheme
    scheme_class_get = RouteGetScheme
    scheme_class_modify = RouteScheme
    entity = 'Route'
    id_field = 'route_id'
    has_update_by = True
    # unique_field='name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        if model.Route.check_duplicates(req.data.get('ANI_prefix', None), req.data.get('DNIS_prefix', None),
                                        req.data.get('ANI_min', None), req.data.get('ANI_max', None),
                                        req.data.get('DNIS_min', None), req.data.get('DNIS_max', None), obj
                                        ):
            raise ValidationError({'ANI_prefix': ['Duplicate prefixes combination already exists.']})

        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        # return super(RouteResource, self).before_update(obj, req)
        return obj



class MultipleRoutesCreate(DnlCreate):
    scheme_class = MultipleRoutesScheme
    item_scheme_class = RouteScheme
    entity = 'Route'
    additional_responses = ()
    path_parameters = ({'name': 'route_plan_id', 'description': 'Parent route plan id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_parameters = ('items', MultipleRoutesScheme)

    
    def before_create(self, obj, **kwargs):
        obj.route_strategy_id = kwargs['route_plan_id']

        if obj.route_type == 'dynamic routing':
            obj.static_route_id = None
            if obj.dynamic_route_id is None:
                raise ValidationError('dynamic_route_id must be not NULL')
        if obj.route_type == 'static routing':
            obj.dynamic_route_id = None
            if obj.static_route_id is None:
                raise ValidationError('static_route_id must be not NULL')

        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)

        if model.Route.check_duplicates(self.req.data.get('ANI_prefix', None), self.req.data.get('DNIS_prefix', None),
                                        self.req.data.get('ANI_min', None), self.req.data.get('ANI_max', None),
                                        self.req.data.get('DNIS_min', None), self.req.data.get('DNIS_max', None), obj
                                        ):
            raise ValidationError({'ANI_prefix': ['Duplicate prefixes combination already exists.']})

        return obj

    def _on_post(self, req, resp, **kwargs):
        self.apply_restrict_rules(req, kwargs)
        scheme = self.item_scheme_class()

        if not check_permission(self, req, 'create'):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return

        if self.check_request_data(req, resp, scheme):
            try:
                log.debug("\nREQ - {}\nRESP - {}\nKWARGS - {}".format(req, resp, kwargs))
                log.debug(f"SELF.SCHEME_CLASS = {self.item_scheme_class}")
                log.debug(f"SCHEME = {scheme}")
                log.debug(f"REQ.DATA = {req.data}")

                if 'items' in req.data and isinstance(req.data['items'], list):
                    data = None
                    for item_data in req.data['items']:
                        self.req_data = item_data
                        req.data = item_data
                        data = self.create_object(req, scheme, **kwargs)
                        log.debug(f"Created data: {data}")

                    self.set_response(
                        resp, self.item_scheme_class.get_object_created_response(data=data)
                    )

                    log.debug("AFTER_CREATE() starting")
                    self.after_create(data, req, resp, **kwargs)
                else:
                    self.set_response(
                        resp, responses.ValidationErrorResponse(data={"items": ["Items list is required."]})
                    )

            except IntegrityError as e:
                try:
                    msg = str(e).split('\n')[1].split(':')[1]
                except:
                    msg = str(e)
                try:
                    model.get_db().session.rollback()
                except Exception as e2:
                    log.error('on create error {} rollback also failed {}'.format(e, e2))

                self.set_response(resp, AlreadyExistsResponse(self.entity, msg))
            except AlreadyExists as e:
                r = AlreadyExistsResponse(self.entity, str(e))
                r.status_code = 1000
                self.set_response(resp, r)
            except FkConstraintViolation as e:
                self.set_response(resp, responses.FkConstraintViolationResponse(
                    data=errors.CommonErrors.get_fk_violation_error(
                        e.table_name, e.fk_column_name, e.column_name, e.value)
                ))
            except schemes.validate.ValidationError as e:
                self.set_response(resp, responses.ValidationErrorResponse(data=e.messages))

            except NoResultFound as e:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(data=str(e)))
                return None

            except OperationalError as e:
                self.set_response(resp, OperationalErrorResponse(e))

            except DataError as e:
                try:
                    msg = str(e).split('\n')[1].split(':')[1]
                except:
                    msg = str(e)
                log.error(e)
                # self.set_response(resp, responses.OperationErrorResponse(data=errors.CommonErrors.DataError))
                self.set_response(resp, OperationErrorResponse(e))

            except Exception as e:
                log.error(e, exc_info=True)
                # self.set_response(resp, responses.OperationErrorResponse(data=errors.CommonErrors.DataError))
                self.set_response(resp, OperationErrorResponse(e))
        return None


class RouteList(DnlList):
    scheme_class = RouteGetScheme
    model_class = model.Route
    entity_plural = 'Routes'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_objects_list(self, req, model_class, **kwargs):
        # model_class.filter(route_strategy_id == kwargs['route_strategy_id'] )
        return super(RouteList, self).get_objects_list(req, model_class, **kwargs)


class RoutesList(DnlList):
    scheme_class = RouteGetScheme
    model_class = model.Route
    entity_plural = 'Routes'
    path_parameters = ({'name': 'route_plan_id', 'description': 'Parent route plan id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RoutesList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['route_strategy_id'] = kwargs['route_plan_id']
        return ret


# ------ Route ------

# --------------ResourceTranslationRef
class ResourceTranslationRefCreate(DnlCreate):
    scheme_class = ResourceTranslationRefScheme
    entity = 'ResourceTranslationRef'
    unique_field = 'route_id'
    additional_responses = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent gateway resource_id'},
                       {'name': 'digit_map_id', 'description': 'DigitTranslation translation_id'},
                       {'name': 'time_profile_id', 'description': 'TimeProfile time_profile_id'},
                       )
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.resource_id = kwargs['trunk_id']
        obj.translation_id = kwargs['digit_map_id']
        obj.time_profile_id = kwargs['time_profile_id']
        return obj


class ResourceTranslationRefResource(DnlResource):
    model_class = model.ResourceTranslationRef
    scheme_class = ResourceTranslationRefScheme
    scheme_class_get = ResourceTranslationRefGetScheme
    scheme_class_modify = ResourceTranslationRefScheme
    entity = 'ResourceTranslationRef'
    id_field = 'ref_id'
    has_update_by = True
    has_update_operation = False
    # unique_field='name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class ResourceTranslationRefList(DnlList):
    scheme_class = ResourceTranslationRefGetScheme
    model_class = model.ResourceTranslationRef
    entity_plural = 'ResourceTranslationRefs'
    path_parameters = ({'name': 'trunk_id', 'description': 'Parent gateway resource_id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ResourceTranslationRefList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['resource_id'] = kwargs['trunk_id']
        return ret


# ------ ResourceTranslationRef ------


# --------------MailSender
class MailSenderCreate(DnlCreate):
    scheme_class = MailSenderScheme
    entity = 'MailSender'
    unique_field = 'id'
    additional_responses = ()
    # path_parameters=( {'name': 'route_strategy_id', 'description': 'Parent route plan id'}, )
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.update_on = datetime.now(UTC)
        return obj


class MailSenderResource(DnlResource):
    model_class = model.MailSender
    scheme_class = MailSenderScheme
    scheme_class_get = MailSenderGetScheme
    scheme_class_modify = MailSenderModifyScheme
    entity = 'MailSender'
    id_field = 'id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def delete_object(self, req, resp, model_class, **kwargs):
        if kwargs['id'] == 1:
            self.set_response(resp, resources.responses.ValidationErrorResponse(
                data='cannot delete default system sender'))
            return False
        mt = model.MailTemplate.filter(model.MailTemplate.from_mail_id == kwargs['id']).all()
        if len(mt):
            lst = []
            for t in mt:
                t.from_mail_id = None
                t.save()
            # if len(lst):
            #     self.set_response(resp, resources.responses.ValidationErrorResponse(
            #         data='cannot delete sender id="{}" it used in mail templates "{}"'.format(kwargs['id'],
            #                                                                                   ','.join(lst))))
            #     return False
        return super(MailSenderResource, self).delete_object(req, resp, model_class, **kwargs)

    def before_update(self, obj, req):
        # if obj.id == 1:
        #    raise Exception('bad update')
        if 'name' in req.data and req.data['name'] != obj.name:
            _valid_unique('MailSender', 'name', req.data['name'])
        if 'username' in req.data and req.data['username'] != obj.username:
            _valid_unique('MailSender', 'username', req.data['username'])
        return obj


class MailSenderResourceStatus(CustomGetAction):
    model_class = model.MailSender
    scheme_class = MailSenderStatusGetScheme
    entity = 'MailSender'
    id_field = 'id'
    has_update_by = True
    security = (DEFAULT_SECURITY)
    path_parameters = ({'name': 'id', 'description': 'sender id to get status'},)
    restrict = ()

    def on_get(self, req, resp, **kwargs):
        sender = model.MailSender.get(kwargs['id'])
        if not sender:
            self.set_response(
                resp,
                responses.ObjectNotFoundErrorResponse(data={'MailSender': '{} not found'.format(kwargs['id'])})
            )
        else:
            (host, port, user, passw) = (sender.smtp_host, sender.smtp_port, sender.username, sender.password)
            try:
                error_cause = ''
                server = None
                if port == '465':
                    server = smtplib.SMTP_SSL(host + ':' + port)
                else:
                    server = smtplib.SMTP(host + ':' + port)
                server.ehlo_or_helo_if_needed()
                if port == '587':
                    server.starttls()
                server.login(user, passw)
                status = "connected"
            except Exception as e:
                error_cause = str(e)
                status = "disconnected"
            resp.status = falcon.HTTP_200
            resp.body = json.dumps({"status": status, "error_cause": error_cause})


class MailSenderList(DnlList):
    scheme_class = MailSenderGetScheme
    model_class = model.MailSender
    entity_plural = 'MailSenders'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class MailSenderStatusList(MailSenderList):
    scheme_class = MailSendersStatusGetScheme


class MailSenderAction(resources.CustomPatchAction):
    model_class = model.MailSender
    scheme_class = MailSenderTestScheme
    scheme_class_get = MailSenderTestScheme
    scheme_class_modify = MailSenderTestScheme
    entity = 'MailSender'
    id_field = 'id'
    has_update_by = False
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'id', 'description': 'sender id to test'},)
    body_parameters = ('Test mail', MailSenderTestScheme)

    def apply(self, obj, req, resp, **kwargs):
        errors = self.scheme_class().validate(req.data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        ret = None
        try:
            ret = obj.send_mail(req.data['mail_to'], req.data['test_subject'],
                                req.data['test_content'])
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False
        if ret:
            e = Exception('mail has errors! \n' + obj.last_error)
            self.set_response(resp, OperationErrorResponse(e))
            return False
        else:
            return True


# --------------MailSender -----


class SendRateTemplateCreate(DnlCreate):
    scheme_class = SendRateTemplateScheme
    entity = 'SendRateTemplate'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class SendRateTemplateResource(DnlResource):
    model_class = model.SendRateTemplate
    scheme_class = SendRateTemplateScheme
    scheme_class_get = SendRateTemplateGetScheme
    scheme_class_modify = SendRateTemplateModifyScheme
    entity = 'SendRateTemplate'
    id_field = 'id'
    has_update_by = False
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        if kwargs['id'] == 1:
            return None
        return super(SendRateTemplateResource, self).get_object(resp, model_class, **kwargs)


class SendRateTemplateList(DnlList):
    scheme_class = SendRateTemplateGetScheme
    scheme_class_get = SendRateTemplateGetScheme
    model_class = model.SendRateTemplate
    entity_plural = 'SendRateTemplate list'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super(SendRateTemplateList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        ret = ret.filter(self.model_class.id != 1)
        return (filt, ret)


class MailTemplateResource(DnlResource):
    model_class = model.MailTemplate
    scheme_class = MailTemplateScheme
    scheme_class_get = MailTemplateGetScheme
    scheme_class_modify = MailTemplateScheme
    entity = 'MailTemplateScheme'
    id_field = 'title'
    # path_parameters = (
    #    {'name': 'title', 'description': 'One of:\n{}'.format(','.join(MailTemplateScheme.TITLE_LIST))},)
    has_update_by = True
    # unique_field='name'
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = True
    security = (DEFAULT_SECURITY)
    restrict = ()

    def ___get_object_data(self, resp, model_class, scheme_class, **kwargs):

        if not kwargs['title'] in scheme_class.TITLE_LIST:
            self.set_response(resp, responses.ValidationErrorResponse(data='bad title'))
            return None

        obj = self.get_object(resp, model_class, **kwargs)

        return scheme_class().dump(obj).data

    def ___update_object(self, req, resp, model_class, scheme_class, **kwargs):

        if not kwargs['title'] in scheme_class.TITLE_LIST:
            self.set_response(resp, responses.ValidationErrorResponse(data='bad title'))
            return

        req.data['title'] = kwargs['title']
        self.init_req(req)

        obj = self.get_object(resp, model_class, **kwargs)
        if not obj:
            # return None
            obj = model_class(id=1)
            obj.save()
        # raise Exception( str(self.req_data))
        scheme = scheme_class().load(self.req_data, instance=self.before_update(obj, req), partial=True)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False

        obj.set_template(kwargs['title'], self.req_data)  # !!!!
        # raise Exception( str(obj.id)+' '+str(obj.invoice_content)+' '+str(obj.payment_content) )
        result = scheme.data.save(save_history=True, user=self.get_user(req),
                                  module=getattr(self.__class__, 'api_module', 'N/A'))

        self.after_update(result, obj, scheme.data)

        return result


class AgentMailTemplateResource(MailTemplateResource):
    scheme_class = AgentMailTemplateScheme
    scheme_class_get = AgentMailTemplateScheme
    scheme_class_modify = AgentMailTemplateModifyScheme
    has_delete_operation = True

    def on_delete(self, req, resp, **kwargs):
        try:
            user = self.get_user(req)
            agent_id = user.agent.agent_id if user.agent else req.data.pop('agent_id', '')
            kwargs['title'] = kwargs['title'] + str(agent_id)
            return super(MailTemplateResource, self).on_delete(req, resp, **kwargs)
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))

    def on_patch(self, req, resp, **kwargs):
        try:
            user = self.get_user(req)
            agent_id = user.agent.agent_id if user.agent else req.data.pop('agent_id', '')
            kwargs['title'] = kwargs['title'] + str(agent_id)
            return super(MailTemplateResource, self).on_patch(req, resp, **kwargs)
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))

    def on_get(self, req, resp, **kwargs):
        try:
            user = self.get_user(req)
            agent_id = user.agent.agent_id if user.agent else req.data.pop('agent_id', '')
            kwargs['title'] = kwargs['title'] + str(agent_id)
            return super(MailTemplateResource, self).on_get(req, resp, **kwargs)
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class AgentMailTemplateCreate(DnlCreate):
    model_class = model.MailTemplate
    scheme_class = AgentMailTemplateScheme
    entity = 'MailTemplateScheme'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        try:
            user = self.get_user(req)
            agent_id = req.data.pop('agent_id', '')
            agent_id = user.agent.agent_id if user.agent else agent_id
            req.data['title'] = req.data['title'] + str(agent_id)
            return super(AgentMailTemplateCreate, self).on_post(req, resp, **kwargs)
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class MailTemplateEdit(resources.CustomAction):
    scheme_class = MailTemplateScheme
    model_class = model.MailTemplate
    description = 'Edit mail template'
    path_parameters = ({'name': 'title', 'description': 'tepmlate title'},)
    body_parameters = ('Template to edit', MailTemplateScheme)
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        # raise Exception('req_data='+str(req.data)+' ags='+str(kwargs) )
        # raise Exception('obj='+str(obj))
        result = None
        data = self.req_data
        try:
            # raise Exception('data='+str(data))
            if not self.model_class.get(1):
                self.model_class(id=1).save()
            data['title'] = kwargs['tite']
            templ, errors = MailTemplateScheme().load(data)
            if errors:
                self.set_response(resp, responses.ValidationErrorResponse(data=errors))
                return False
            try:
                result = templ.save()
            except Exception as e:
                self.set_response(resp, OperationErrorResponse(e))
                return False

            if result:
                self.set_response(
                    resp, responses.SuccessResponse(
                        data={
                            'object_id': result,
                        },
                        scheme=schemes.ObjectScheme
                    )
                )
                return True
            else:
                self.set_response(
                    resp, responses.SuccessResponseJustOk())
                return True
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


# raise e
# raise NotImplementedError('Ill be back!')


class MailTemplateList(DnlList):
    scheme_class = MailTemplateGetScheme
    model_class = model.MailTemplate
    entity_plural = 'MailTemplates'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# ------ MailTemplate ------
# +++ EmailLog


class EmailLogList(DnlList):
    scheme_class = EmailLogGetScheme
    model_class = model.EmailLog
    entity_plural = 'EmailLog'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_filter_type(self, q, val, kwargs):
        cls = self.model_class
        type_dict = {v: k for k, v in cls.TYPE.items()}
        return q.filter(cls.type == type_dict[val])

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(EmailLogList, self).get_filtering_for_list(parsed_qs, **kwargs)
        # if not 'send_from' in ret: ret['send_from']=''
        # if not 'send_to' in ret: ret['send_to'] = ''
        # ret['email_addresses'] = ret['send_from']+'*'+ret['send_to']
        return ret


# --- EmailLog

class CdrExportLogList(DnlList):
    scheme_class = CdrExportLogGetScheme
    model_class = model.CdrExportLog
    entity_plural = 'CdrExportLog'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# ---CdrClient

class _ClientCdrSimulateCallCreate(DnlCreate):
    scheme_class = ClientCdrSimulateCallScheme
    entity = 'ClientCdr'
    unique_field = 'id'
    additional_responses = ()
    # path_parameters=( {'name': 'route_strategy_id', 'description': 'Parent route plan id'}, )
    security = (DEFAULT_SECURITY)
    restrict = ()


# ---CdrClient

class ClientCdrSimulateCallCreate(resources.CustomAction):
    scheme_class = ClientCdrSimulateCallScheme
    scheme_class_get = CallApiScheme
    model_class = model.ClientCdr
    description = 'make simulate call'
    path_parameters = ()
    body_parameters = ('Carriers to create', ClientCdrSimulateCallScheme)
    method = 'post'
    additional_responses = (
        responses.SuccessResponseObjectInfo(scheme=CallApiScheme, description='Call simulation result'),
    )

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        test_rate_table_id = None
        try:
            server = model.VoipGateway.filter(model.VoipGateway.name == req.data['server']).first()
            if not server:
                server = model.VoipGateway.filter(model.VoipGateway.connected == True).first()
            if not server:
                self.set_response(
                    resp, responses.ValidationErrorResponse(
                        data='server {} not found (see /switch/list)'.format(req.data['server'])
                    )
                )
                return None
            server.check_info()
            if server._connected == False:
                self.set_response(
                    resp, responses.ValidationErrorResponse(
                        data='Backend service is not accessible at {}:{} for server "{}". '
                             'Please contact system admin for help.'.format(server.lan_ip, server.lan_port,
                                                                            req.data['server'])
                    )
                )
                return None
            trunk = model.IngressTrunk.filter(resource_id=req.data['ingress_trunk']).first()
            if not trunk:
                self.set_response(
                    resp,
                    responses.ValidationErrorResponse(
                        data='trunk_id {} not found (see /trunk/ingress/list)'.format(
                            req.data['ingress_trunk']
                        )
                    )
                )
                return None
            # create testing rate table
            if False:  # and (not trunk.rate_table or not trunk.rate_table.rates):
                log.debug('simulate call add testing rate table')
                jur_type = 'US Jurisdictional'
                RATE = 10.0
                NOW = datetime.now(UTC)
                test_rate_table_id = model.RateTable(name='#{}_test_rate_table'.format(trunk.alias),
                                                     jur_type=jur_type).save()
                trunk.rate_table_id = test_rate_table_id

                for c in [chr(a) for a in range(ord('1'), ord('9') + 1)]:
                    trunk.rate_table.rates.append(model.Rate(code=c, rate=RATE, effective_date=datetime(NOW.year, 1, 1),
                                                             min_time=6, interval=6
                                                             ))
                trunk.save()
                log.debug('simulate call waiting to add testing rate table')
                from time import sleep
                sleep(5.0)
                log.debug('simulate call waiting finished ... ')

            host = None
            if req.data.get('ingress_port'):
                host = model.ResourceIp.filter(ip=req.data['ingress_host'], port=req.data['ingress_port']).first()
            if not host:
                host = model.ResourceIp.filter(ip=req.data['ingress_host']).first()
                if host and not host.port and req.data.get('ingress_port'):
                    host.port = req.data['ingress_port']
            if not host:
                self.set_response(
                    resp,
                    responses.ValidationErrorResponse(
                        data='host ip {} not found (see /trunk/ip/list)'.format(
                            req.data['ingress_host']
                        )
                    )
                )
                return None
            api = get_dnl_switch_session(server.lan_ip, server.lan_port)
            data = api.call_simulation(
                host.ip, host.port, req.data['ani'], req.data['dnis'], 0
            )
            # data = {'Origination-LRN-Action-DNIS-After': {'DNIS': None}, 'Simulation-progress': 'Done', 'Global-Route-State': {'Origination-State': 'Unauthorized IP Address'}, 'Origination-Route-DNIS': None, 'Origination-Digit-Mapped-ANI': {'ANI': None}, 'Origination-LRN-Action-DNIS-Before': {'DNIS': None}, 'Origination-SRC-DNIS': '2222', 'Origination-Respond-LRN-DNIS': None, 'Origination-SRC-ANI': '1111', 'Origination-Trunk': {'Profit-Type': None, 'CPS': '0', 'CAP': '0', 'Profit-Margin': '0.000000', 'Dynamic-Route-Name': None, 'Route-Strategy-Name': None, 'Carrier-Name': None, 'Media-Type': 'Transcoding Media', 'Route-Type': 'Unknow', 'Trunk-Name': None, 'Rate-Table-Name': None, 'Static-Route-Name': None}, 'Origination-Ignored-Trunk': {'Trunk-Name': [None, None, None, 'bruno', 'bruno'], 'Cause': ['Resource not found', 'Resource not found', 'Resource not found', 'Resource ingress disable', 'Resource ingress disable']}, 'Origination-Translation-DNIS': {'DNIS': None}, 'Origination-Translation-ANI': {'ANI': None}, 'Origination-Digit-Mapped-DNIS': {'DNIS': None}}

            if test_rate_table_id:
                log.debug('simulate call delete testing rate table')
                model.RateTable.get(test_rate_table_id).delete()
                # trunk.rate_table_id = None
                # trunk.save()
            if data:
                self.set_response(
                    resp, responses.SuccessResponseObjectInfo(
                        data=data['payload'],
                        scheme=CallApiScheme
                    )
                )
                return False
            else:
                self.set_response(
                    resp, responses.SuccessResponseJustOk()
                )
            return False
        except Exception as e:
            log.debug('ClientCdrSimulateCallCreate:{} traceback: {}'.format(e, traceback.format_exc()))
            if test_rate_table_id:
                log.debug('simulate call clear testing rate table')
                model.RateTable.get(test_rate_table_id).delete()

            self.set_response(resp, OperationErrorResponse(e))
            return False


# --------------DailyCdrField
class DailyCdrFieldCreate(DnlCreate):
    scheme_class = DailyCdrFieldScheme
    entity = 'CDR_Visibility'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class DailyCdrFieldResource(DnlResource):
    model_class = model.DailyCdrField
    scheme_class = DailyCdrFieldScheme
    scheme_class_get = DailyCdrFieldGetScheme
    scheme_class_modify = DailyCdrFieldScheme
    entity = 'CDR_Visibility'
    id_field = 'id'
    has_update_by = False
    unique_field = 'field'
    security = (DEFAULT_SECURITY)
    restrict = ()


class DailyCdrFieldList(DnlList):
    scheme_class = DailyCdrFieldGetScheme
    model_class = model.DailyCdrField
    entity_plural = 'CDR_Visibility fields'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    # def get_objects_list(self, req, model_class, **kwargs):
    #     parsed_qs = dict(parse_qsl(req.query_string))

    #     try:
    #         per_page = int(parsed_qs.get('per_page'))
    #     except (ValueError, TypeError):
    #         per_page = conf.get_default_items_per_page()

    #     try:
    #         page = int(parsed_qs.get('page', 0))
    #     except ValueError:
    #         page = 0

    #     if hasattr(self, 'per_page_limit') and per_page > self.per_page_limit:
    #         raise ValidationError('per_page  over limit {}'.format(self.per_page_limit))

    #     if 'order_by' in parsed_qs:
    #         ordering = {
    #             'by': parsed_qs['order_by'],
    #             'dir': parsed_qs.get('order_dir', 'asc')
    #         }
    #     elif hasattr(self, 'ordering'):
    #         ordering = self.ordering
    #     else:
    #         ordering = {}

    #     fields = self.get_fields_for_list(parsed_qs, **kwargs)

    #     filtering = self.get_filtering_for_list(parsed_qs, **kwargs)

    #     filtering, query = \
    #         self.modify_query_from_filtering_for_list(filtering, **kwargs)

    #     for c in inspect(self.model_class).columns:
    #         if c.name in ['alias', 'name', 'template_name', 'group_name']:
    #             query = query.filter(or_(c.is_(None), c.notlike('#%')))
    #             break

    #     query = query.filter(model_class.db_name.in_(model.DailyCdrField.NEEDED_FIELDS))

    #     if ordering:
    #         ordering, query = \
    #             self.modify_query_from_ordering_for_list(ordering, query, **kwargs)
    #     if ('ACCEPT' in req.headers and req.headers['ACCEPT'] == 'text/csv'):
    #         return model_class.get_objects_query(
    #             query=query,
    #             filtering=filtering,
    #             ordering=ordering,
    #             paging=None
    #         ) + (0, None, fields)
    #     else:
    #         if 'by' in ordering.keys() and ordering['by'] == 'invoice_number':
    #             per_page = None
    #         return query, query.count(), page, per_page, fields

    def on_filter_client_viewable_origination(self, query, value, kwargs):
        cls = model.DailyCdrField
        return query.filter((cls.type.op('&')(64) == 64) == value)

    def on_filter_admin_default_origination(self, query, value, kwargs):
        cls = model.DailyCdrField
        return query.filter((cls.type.op('&')(32) == 32) == value)

    def on_filter_admin_default(self, query, value, kwargs):
        cls = model.DailyCdrField
        return query.filter((cls.type.op('&')(16) == 16) == value)

    def on_filter_client_viewable(self, query, value, kwargs):
        cls = model.DailyCdrField
        return query.filter((cls.type.op('&')(8) == 8) == value)

    def on_filter_vendor_viewable(self, query, value, kwargs):
        cls = model.DailyCdrField
        return query.filter((cls.type.op('&')(4) == 4) == value)

    def on_filter_client_cdr_delivery(self, query, value, kwargs):
        cls = model.DailyCdrField
        return query.filter((cls.type.op('&')(2) == 2) == value)

    def on_filter_vendor_cdr_delivery(self, query, value, kwargs):
        cls = model.DailyCdrField
        return query.filter((cls.type.op('&')(1) == 1) == value)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        log.debug("FILTERING FOR LIST")
        ret = super(DailyCdrFieldList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


class DailyCdrFieldEditManyResource(resources.CustomPatchAction):
    model_class = model.DailyCdrField
    scheme_class = DailyCdrFieldMiniScheme
    scheme_class_get = ObjectUpdatedScheme
    entity = 'CDR_Visibility'
    body_parameters = ('CdrFieldsToModify', DailyCdrFieldEditManyScheme)
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    modify_only = True

    def get_spec(self):
        return swagger.specify.get_spec(
            method=self.method, description=self.description,
            path_parameters=self.path_parameters,
            body_parameters=self.body_parameters,
            responses=(
                          responses.SuccessResponseObjectInfo(payload_scheme=self.scheme_class_get),
                          responses.SuccessResponseJustOk(),
                          responses.ObjectNotFoundErrorResponse()
                      ) + self.additional_responses,
            security=self.get_security(method=self.method)
        )

    def on_patch(self, req, resp, **kwargs):
        kwargs['id'] = 1
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        cnt = 0
        try:
            for data in req.data['items']:
                req.data = data
                kwargs[self.id_field] = data[self.id_field]
                obj = self.model_class.get(data[self.id_field])
                if obj:
                    cnt += 1
                    scheme = self.scheme_class().load(data, instance=obj, partial=True)
                    if scheme.errors:
                        self.set_response(resp, responses.ValidationErrorResponse(
                            data={'items:{}'.format(cnt): scheme.errors}))
                        return False
                    self.model_class.session().add(scheme.data)
            if cnt:
                self.model_class.session().commit()
                self.set_response(resp, responses.SuccessResponseObjectInfo(data={'updated': cnt}))
                return False
            else:
                self.set_response(
                    resp, responses.SuccessResponseJustOk())
                return True

        except IntegrityError:
            self.model_class.session().rollback()
            self.set_response(resp, responses.AlreadyExistsResponse(
                data=errors.CommonErrors.get_already_exists_error(self.entity, self.unique_field))
                              )
            return False
        except FkConstraintViolation as e:
            self.set_response(resp, responses.FkConstraintViolationResponse(
                data=errors.CommonErrors.get_fk_violation_error(e.table_name, e.column_name, e.value))
                              )
            return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


class DailyCdrFieldAutoEditManyResource(DailyCdrFieldEditManyResource):
    model_class = model.DailyCdrField
    scheme_class = DailyCdrFieldAutoMiniScheme
    entity = 'CDR_Visibility for client_cdr_delivery vendor_cdr_delivery'
    body_parameters = ('CdrFieldsToModify', DailyCdrFieldAutoEditManyScheme)
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    modify_only = True


# ------ DailyCdrField ------


# --------------Signup

class SignupCreate(DnlCreate):
    scheme_class = SignupScheme
    entity = 'Signup'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    no_auth_needed = True
    security = ()  # (DEFAULT_SECURITY)
    restrict = ()

    class Ret:
        def __init__(self, data):
            self.__dict__.update(data)
            self.email = self.main_email

    def before_create(self, obj, **kwargs):
        obj.update_by = self.req.remote_addr
        obj.update_at = datetime.now(UTC)
        obj.signed_up_on = datetime.now(UTC)
        obj.modified_on = datetime.now(UTC)
        _valid_unique2('Client', 'name', obj.client_name, 'Client {} already exists!'.format(obj.client_name))
        # _valid_unique2('User', 'email', obj.main_email, 'User {} already exists!'.format(obj.main_email))
        _valid_unique2('User', 'name', obj.username, 'User {} already exists!'.format(obj.username))

        sig = model.Signup.filter(and_(model.Signup.email == obj.main_email, model.Signup.status == 'pending')).first()
        if sig:
            raise Exception('Registration {} already exists!'.format(obj.main_email))
        sig = model.Signup.filter(
            and_(model.Signup.client_name == obj.client_name, model.Signup.status == 'pending')).first()
        if sig:
            raise Exception('Registration with client_name {} already exists!'.format(obj.client_name))
        cl = model.Client.filter(model.Client.name == obj.contact_name).first()
        if cl:
            raise Exception('contact name already exist!')
        us = model.User.filter(model.User.name == obj.login).first()
        if us:
            raise Exception('username already exist!')
        if obj.referral:
            a = model.Agent.get_from_referral(obj.referral)
            if not a:
                raise Exception('No referral agent found! {}'.format(obj.referral))
            obj.agent_id = a.agent_id
        return obj

    def after_create(self, obj_id, req, resp, **kwargs):
        try:
            obj = model.Signup.get(obj_id)
            # ret = self.Ret(req.data)

            obj.modified_on = datetime.now(UTC)
            obj.success = ' sucessfully registered '
            if obj.send_signup_notification:
                try:
                    # r=model.MailSender.apply_mail(ret, 'registration', ret.main_email)
                    ret = model.MailSender.apply_mail(obj, 'regletter', obj.main_email)
                    if ret:
                        log.warning('Signup mail not sent! {}'.format(str(e2)))
                        # self.set_response(resp, responses.OperationErrorResponse(
                        #     data=errors.Error(code=43, message=ret[1], reason='mail error')))
                        # return False
                except Exception as e2:
                    log.warning('Signup mail not sent! {}'.format(str(e2)))
        except Exception as e:
            log.error('error on create signup {}'.format(str(e)))
            ret = self.Ret(req.data)
            try:
                ret.company_name = ret.company
                ret.first_name = ret.contact_name.split(' ')[0]
                ret.last_name = ret.contact_name.split(' ')[1]
            except Exception as e1:
                log.error('error on create signup {}'.format(str(e1)))
                pass
            # ret.success = ' error on registration. Error message (for tech personal) : {}'.format(e)
            ret.success = ' error on registration.'
            try:
                if hasattr(ret, 'send_signup_notification') and ret.send_signup_notification:
                    model.MailSender.apply_mail(ret, 'regletter', ret.main_email)
            except Exception as e2:
                log.warning('Signup mail not sent! {}'.format(str(e2)))
            raise e


class SignupConfirm(CustomGetAction):
    no_auth_needed = True
    security = ()
    path_parameters = ({'name': 'token', 'type': 'string'},)

    def proceed(self, req, resp, token):
        import jwt
        try:
            signup_data = jwt.decode(token, settings.JWT_SIGNATURE)
            signup_id = signup_data['signup_id']
            obj = model.Signup.get(signup_id)
            if obj and obj.status == 'initial':
                obj.confirmed_at = datetime.now(UTC)
                obj.confirmed_ip = get_request_ip(req)
                obj.status = 'pending'
                obj.save()
                data = {'confirmed_at': str(obj.confirmed_at), 'confirmed_ip': obj.confirmed_ip}
                self.set_response(resp,
                                  responses.SuccessResponseObjectInfo(data=data))
                return False
            else:
                self.set_response(resp,
                                  responses.ObjectNotFoundErrorResponse())
                return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e)
                              # responses.OperationErrorResponse(data=errors.Error(code=406, message=str(e), reason=e.__class__.__name__))
                              )
            return False
        # +++ Failover


class SignupResource(DnlResource):  # DnlResource):
    model_class = model.Signup
    scheme_class = SignupScheme
    scheme_class_get = SignupGetScheme
    scheme_class_modify = SignupModifyScheme
    entity = 'Signup'
    id_field = 'id'
    # has_update_by = True
    unique_field = 'login'
    security = (DEFAULT_SECURITY)
    restrict = ()

    # no_auth_needed = True

    def before_update(self, obj, req):
        # if obj.status in ('approved', 'rejected'):
        #     raise ValidationError('Cannot edit this registration, already {}!'.format(obj.status))
        if 'main_email' in req.data and obj.main_email != req.data['main_email']:
            main_email = req.data['main_email']
            q = model.Signup.filter(and_(model.Signup.email == main_email, model.Signup.id != obj.id,
                                         model.Signup.status != 'rejected')).first()
            # _valid_unique2('User', 'email', main_email, 'User {} already exists!'.format(main_email))
            if q:
                raise ValidationError(
                    {'main_email': ['main_email {} already exists (duplicate)'.format(req.data['main_email'])]})
        if 'client_name' in req.data and obj.client_name != req.data['client_name']:
            client_name = req.data['client_name']
            _valid_unique2('Client', 'name', client_name, 'Client {} already exists!'.format(client_name))
        self.req_data['_client_name'] = obj.client_name
        if 'username' in req.data and obj.username != req.data['username']:
            username = req.data['username']
            _valid_unique2('User', 'name', username, 'User {} already exists!'.format(username))
        if 'referral' in req.data:
            q = model.Agent.get_from_referral(req.data['referral'])
            if not q:
                raise ValidationError('No referral agent found! {}'.format(req.data['referral']))
            obj.agent_id = q.agent_id
        if 'status' in req.data and req.data['status'] == 'approved':
            client = model.Client(name=obj.contact_name)
            # client.name=obj.client_name
            client.update_by = self.get_user(self.req).name
            client.update_at = datetime.now(UTC)
            cl_id = obj.update_client_record(client)
            obj.client_id = cl_id
        return obj

    def after_update(self, result, obj, data):

        pass


class AgentReferalNameResource(DnlResource):  # DnlResource):
    model_class = model.Agent
    scheme_class = AgentReferalNameScheme
    scheme_class_get = AgentReferalNameScheme
    entity = 'Signup'
    id_field = 'referal_key'
    # has_update_by = True
    has_delete_operation = False
    has_modify_operation = False
    # no_auth_needed = True
    # path_parameters = ({'name': 'referal_key', 'description': 'agent referal key'},)
    security = (DEFAULT_SECURITY)
    security = ()
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        try:
            token = kwargs.get('referal_key', None)
            cls = self.model_class
            return cls.get_from_referral(token)
        except NoResultFound:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return None
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


class SignupList(DnlList):
    scheme_class = SignupGetScheme
    model_class = model.Signup
    entity_plural = 'Signups'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class SignupApproveResource(DnlResource):
    model_class = model.Signup
    scheme_class = SignupScheme
    scheme_class_get = SignupGetScheme
    scheme_class_modify = SignupApproveScheme
    entity = 'Signup approval'
    id_field = 'id'
    # has_update_by = True
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = False
    unique_field = 'login'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        if req.data['status'] not in ['approved', 'rejected']:
            raise ValidationError(
                'Wrong status  {}. Possible values is {} '.format(req.data['status'], ['approved', 'rejected']))
        if (obj.status in ('pending', 'initial') or obj.status is None) and req.data['status'] in ['approved',
                                                                                                   'rejected']:
            obj.update_at = datetime.now(UTC)
            super(SignupApproveResource, self).before_update(obj, req)
        else:
            raise ValidationError('Not allowed this registration operation! Already {}'.format(obj.status))
        return obj

    def after_update(self, result, obj, data):

        obj.modified_on = datetime.now(UTC)
        if obj.status == 'approved':
            try:
                client = model.Client(name=obj.company)
                cl_id = obj.update_client_record(client)

                model.Resource.filter(
                    and_(model.Resource.alias == obj.company)).delete(
                    synchronize_session='fetch')
                is_egress = obj.client_type == 'vendor'
                is_ingress = not is_egress
                r = model.Resource(alias=obj.company, client_id=client.client_id, ingress=is_ingress,
                                   egress=is_egress)
                for i in obj.ip_address:
                    ip = model.ResourceIp(ip=i.ip, port=i.port)
                    r.ip.append(ip)

                data = self.req.data
                rate_table_id = data.pop('rate_table_id', None)
                route_strategy_id = data.pop('route_strategy_id', None)
                product_id = data.pop('product_id', None)
                if product_id:
                    product = model.ProductRoutRateTable.get(int(product_id))
                    prefix = model.ResourcePrefix(resource_id=r.resource_id, rate_table_id=product.rate_table_id,
                                                  product_id=product_id, route_strategy_id=product.rout_id)
                    r.prefixes.append(prefix)
                elif rate_table_id or route_strategy_id:
                    prefix = model.ResourcePrefix(resource_id=r.resource_id, rate_table_id=rate_table_id,
                                                  product_id=product_id, route_strategy_id=route_strategy_id)
                    r.prefixes.append(prefix)
                client.resources.append(r)
                client.save()

                if obj.agent_id:
                    a = model.Agent.get(obj.agent_id)
                    if a:
                        user = self.get_user(self.req)
                        username = user.name if user else 'user_not_found'
                        ac = model.AgentClient(agent_id=obj.agent_id, client_id=client.client_id, assigned_by=username)
                        ac.save()
                if obj.products:
                    for p_id in obj.products:
                        if model.ProductRoutRateTable.get(p_id):
                            model.ProductClientsRef(client_id=client.client_id, product_id=int(p_id)).save()

                model.MailSender.apply_mail(client, 'welcome')
                model.MailSender.apply_mail(obj, 'registration_accepted', obj.main_email)
            except Exception as e:
                try:
                    model.Resource.filter(
                        and_(model.Resource.alias == obj.company, model.Resource.ingress == True)).delete(
                        synchronize_session='fetch')
                    model.Client.filter(model.Client.name == obj.company).delete(synchronize_session='fetch')
                    model.User.filter(model.User.name == obj.login).delete(synchronize_session='fetch')
                    obj.session().commit()
                except:
                    pass
                try:
                    obj.session().rollback()
                    obj.status = 'pending'
                    obj.save()
                except:
                    pass
                raise e
        elif obj.status == 'rejected':
            model.MailSender.apply_mail(obj, 'registration_rejected', obj.main_email)
            pass


class GlobalRouteErrorCreate(DnlCreate):
    scheme_class = GlobalRouteErrorScheme
    entity = 'GlobalRouteError'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        assert isinstance(obj, object)
        return obj


class GlobalRouteErrorResource(DnlResource):
    model_class = model.GlobalRouteError
    scheme_class = GlobalRouteErrorScheme
    scheme_class_get = GlobalRouteErrorGetScheme
    scheme_class_modify = GlobalRouteErrorModifyScheme
    entity = 'GlobalRouteError'
    id_field = 'id'
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = True
    # has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class GlobalRouteErrorEditManyResource(DnlPatchManyResource):
    model_class = model.GlobalRouteError
    scheme_class = GlobalRouteErrorScheme
    entity = 'Global Route Error items'
    id_field = 'id'
    modify_only = True
    body_parameters = ('Global Route Error items', GlobalRouteErrorManyScheme)
    security = (DEFAULT_SECURITY)
    restrict = ()


class GlobalRouteErrorList(DnlList):
    scheme_class = GlobalRouteErrorGetScheme
    model_class = model.GlobalRouteError
    entity_plural = 'GlobalRouteErrors'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# class GlobalFailoverCreate(DnlCreate):
#     scheme_class = GlobalFailoverScheme
#     entity = 'GlobalFailover'
#     unique_field = 'id'
#     additional_responses = ()
#     path_parameters = ()
#     security = (DEFAULT_SECURITY)
#     restrict = ()

#     def before_create(self, obj, **kwargs):
#         return obj


# class GlobalFailoverResource(DnlResource):
#     model_class = model.GlobalFailover
#     scheme_class = GlobalFailoverScheme
#     scheme_class_get = GlobalFailoverGetScheme
#     scheme_class_modify = GlobalFailoverModifyScheme
#     entity = 'GlobalFailover'
#     id_field = 'id'
#     # has_update_by = True
#     # unique_field = 'name'
#     security = (DEFAULT_SECURITY)
#     restrict = ()


# class GlobalFailoverList(DnlList):
#     scheme_class = GlobalFailoverGetScheme
#     model_class = model.GlobalFailover
#     entity_plural = 'GlobalFailovers'
#     path_parameters = ()
#     security = (DEFAULT_SECURITY)
#     restrict = ()


# class GlobalFailoverEditManyResource(DnlPatchManyResource):
#     model_class = model.GlobalFailover
#     scheme_class = GlobalFailoverScheme
#     entity = 'Global Failover items'
#     id_field = 'id'
#     modify_only = True
#     body_parameters = ('Global Failover items', GlobalFailoverManyScheme)
#     security = (DEFAULT_SECURITY)
#     restrict = ()


class TerminationFailoverCreate(DnlCreate):
    scheme_class = TerminationFailoverScheme
    entity = 'TerminationFailover'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        return obj


class TerminationFailoverResource(DnlResource):
    model_class = model.TerminationFailover
    scheme_class = TerminationFailoverScheme
    scheme_class_get = TerminationFailoverGetScheme
    scheme_class_modify = TerminationFailoverModifyScheme
    entity = 'TerminationFailover'
    id_field = 'id'
    # has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = False


class TerminationFailoverList(DnlList):
    scheme_class = TerminationFailoverGetScheme
    model_class = model.TerminationFailover
    entity_plural = 'TerminationFailovers'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class TerminationFailoverEditManyResource(DnlPatchManyResource):
    model_class = model.TerminationFailover
    scheme_class = TerminationFailoverScheme
    entity = 'Termination Failover items'
    id_field = 'id'
    body_parameters = ('Termination Failover items', TerminationFailoverManyScheme)
    security = (DEFAULT_SECURITY)
    restrict = ()
    modify_only = True


class OriginationFailoverCreate(DnlCreate):
    scheme_class = OriginationFailoverScheme
    entity = 'OriginationFailover'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        return obj


class OriginationFailoverResource(DnlResource):
    model_class = model.OriginationFailover
    scheme_class = OriginationFailoverScheme
    scheme_class_get = OriginationFailoverGetScheme
    scheme_class_modify = OriginationFailoverModifyScheme
    entity = 'OriginationFailover'
    id_field = 'id'
    # has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_delete_operation = False


class OriginationFailoverList(DnlList):
    scheme_class = OriginationFailoverGetScheme
    model_class = model.OriginationFailover
    entity_plural = 'OriginationFailovers'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class OriginationFailoverEditManyResource(DnlPatchManyResource):
    model_class = model.OriginationFailover
    scheme_class = OriginationFailoverScheme
    entity = 'Origination Failover items'
    id_field = 'id'
    body_parameters = ('Origination Failover items', OriginationFailoverManyScheme)
    security = (DEFAULT_SECURITY)
    restrict = ()
    modify_only = True


# --- Failover

# +++ FtpConf

class FtpConfCreate(DnlCreate):
    scheme_class = FtpConfScheme
    entity = 'FtpConf'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        # user = self.get_user()
        # user.cdr_token()
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        from api_dnl.task.ftp_upload import check_ftp_status
        try:
            check_ftp_status.delay(object_id)
        except:
            check_ftp_status(object_id)


class FtpConfCopy(DnlCreate):
    scheme_class = FtpConfCopyScheme
    entity = 'FtpConf'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'id', 'description': 'Ftp configuration id to test'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        name = obj.alias
        obj = model.FtpConf.get(int(kwargs['id']))
        if not obj:
            raise NoResultFound()
        make_transient(obj)
        obj.id = None
        obj.alias = name
        return obj


class FtpConfResource(DnlResource):
    model_class = model.FtpConf
    scheme_class = FtpConfScheme
    scheme_class_get = FtpConfGetScheme
    scheme_class_modify = FtpConfScheme
    entity = 'FtpConf'
    id_field = 'id'
    # has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class FtpConfList(DnlList):
    scheme_class = FtpConfGetScheme
    model_class = model.FtpConf
    entity_plural = 'FtpConfs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class FtpConfActivate(DnlResourceAll):
    scheme_class = FtpConfActivateScheme
    model_class = model.FtpConf
    scheme_class_get = ObjectUpdatedScheme
    entity = 'FtpConf'


class FtpConfTest(CustomPatchAction):
    model_class = model.FtpConf
    entity = 'FtpConf'
    path_parameters = ({'name': 'id', 'description': 'Ftp configuration id to test'},)

    def apply(self, obj, req, resp, **kwargs):
        try:
            if not obj:
                raise ValidationError('Configuration not exists!')
            obj.test_ftp_server()
            obj.save()
            return True
        except Exception as e:
            trace = traceback.format_exc()
            log.error(trace)
            self.set_response(resp, OperationErrorResponse(e))
            obj.save()
            return False


class FtpConfManualTrigger(CustomPatchAction):
    model_class = model.FtpConf
    entity = 'FtpConf'
    path_parameters = ({'name': 'id', 'description': 'Ftp configuration id to test'},)
    body_parameters = ('Query times', FtpConfManualTriggerScheme)

    def apply(self, obj, req, resp, **kwargs):
        from falcon_rest.schemes import ObjectCreatedCompositeOrStrPk
        try:
            errors = FtpConfManualTriggerScheme().validate(req.data)

            if errors:
                self.set_response(resp, responses.ValidationErrorResponse(data=errors))
                return False
            if not obj:
                raise ValidationError('Configuration not exists!')
            st = parse_datetime(str(req.data['start_time']))
            st.replace(tzinfo=UTC, microsecond=0)

            et = parse_datetime(str(req.data['end_time']))
            et.replace(tzinfo=UTC, microsecond=0)

            start_time = int(st.timestamp())
            end_time = int(et.timestamp())
            if start_time == end_time:
                raise ValidationError('"start_time" cannot be equal "end_time"!')
            # user = self.get_user()
            # user.cdr_token()
            oid = obj.trigger_manual(start_time, end_time)
            if oid:
                self.set_response(resp, ObjectCreatedResponse(data=oid, scheme=ObjectCreatedCompositeOrStrPk,
                                                              data_key='object_pk'))
                return False
            # model.CdrDownloadTask
            return True
        except Exception as e:
            trace = traceback.format_exc()
            log.error(trace)
            self.set_response(resp, OperationErrorResponse(e))
            return False


# --- FtpServerLog
class FtpServerLogList(DnlList):
    scheme_class = FtpServerLogGetScheme
    model_class = model.FtpServerLog
    entity_plural = 'FtpServerLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# +++ FtpServerLog

# --- FtpCdrLog
class FtpCdrLogList(DnlList):
    scheme_class = FtpCdrLogGetScheme
    model_class = model.FtpCdrLog
    entity_plural = 'FtpCdrLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# +++ FtpCdrLog


# region +++ClientInvoiceSettings+++
class ClientInvoiceSettingsCreate(DnlCreate):
    scheme_class = ClientInvoiceSettingsScheme
    model_class = model.InvoiceSetting
    entity = 'ClientInvoiceSettings'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.create_by = user.name
        obj.create_on = datetime.now(UTC)
        return obj


class ClientInvoiceSettingsResource(DnlResource):
    model_class = model.InvoiceSetting
    scheme_class = ClientInvoiceSettingsScheme
    scheme_class_get = ClientInvoiceSettingsSchemeGet
    scheme_class_modify = ClientInvoiceSettingsSchemeModify
    entity = 'ClientInvoiceSettings'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()

    def before_update(self, obj, req):
        obj.update_on = datetime.now(UTC)
        return obj


class ClientInvoiceSettingsList(DnlList):
    scheme_class = ClientInvoiceSettingsSchemeGet
    model_class = model.InvoiceSetting
    entity_plural = 'ClientInvoiceSettingss'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---ClientInvoiceSettings---


class SystemParameterUploadUSCodedeck(CustomPatchAction):
    model_class = model.SystemParameter
    entity = 'SystemParameterUploadUSCodedeck'
    path_parameters = ()
    body_parameters = ()

    def on_patch(self, req, resp, **kwargs):
        kwargs['id'] = 1
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        try:
            # if not obj:
            #    raise ValidationError('Configuration not exists!')
            from api_dnl.task.code_deck_update import code_deck_update_us
            code_deck_update_us.delay()
            return True
        except Exception as e:
            trace = traceback.format_exc()
            log.error(trace)
            self.set_response(resp, OperationErrorResponse(e))
            return False


class SystemParameterUploadAZCodedeck(CustomPatchAction):
    model_class = model.SystemParameter
    entity = 'SystemParameterUploadUSCodedeck'
    path_parameters = ()
    body_parameters = ()

    def on_patch(self, req, resp, **kwargs):
        kwargs['id'] = 1
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        try:
            # if not obj:
            #    raise ValidationError('Configuration not exists!')
            from api_dnl.task.code_deck_update import code_deck_update_az
            code_deck_update_az.delay()
            return True
        except Exception as e:
            trace = traceback.format_exc()
            log.error(trace)
            self.set_response(resp, OperationErrorResponse(e))
            return False


class SystemParameterCustomDnlResource(DnlResource):
    model_class = model.SystemParameter
    # scheme_class = SystemParameterLoginPageScheme
    # scheme_class_get = SystemParameterLoginPageSchemeGet
    entity = 'SystemParameter - virtual'
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = True
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object_data(self, resp, model_class, scheme_class, **kwargs):
        kwargs['sys_id'] = 1
        obj = self.get_object(resp, model_class, **kwargs)
        if not obj:
            obj = model_class(sys_id=1)
        return scheme_class().dump(obj).data

    def update_object(self, req, resp, model_class, scheme_class, **kwargs):
        kwargs['sys_id'] = 1
        self.init_req(req)
        obj = self.get_object(resp, model_class, **kwargs)
        if not obj:
            self.model_class(sys_id=1).save()
        scheme = scheme_class().load(self.req_data, instance=self.before_update(obj, req), partial=True)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False
        result = scheme.data.save(save_history=True, user=self.get_user(req),
                                  module=getattr(self.__class__, 'api_module', 'N/A'))
        self.after_update(result, obj, scheme.data)
        return result


# ---


# +++SystemParameterLoginPage
class SystemParameterLoginPageGetResource(SystemParameterCustomDnlResource):
    no_auth_needed = True
    security = None
    has_delete_operation = False
    has_modify_operation = False
    has_info_operation = True
    scheme_class = SystemParameterLoginPageSchemeGet
    scheme_class_get = SystemParameterLoginPageSchemeGet
    entity = 'SystemParameter - Login settings'


class SystemParameterLoginPageResource(SystemParameterCustomDnlResource):
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = True
    scheme_class = SystemParameterLoginPageScheme
    scheme_class_get = SystemParameterLoginPageSchemeGet
    entity = 'SystemParameter - Login settings'


class SystemParameterPaymentSettingResource(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterPaymentSettingScheme
    scheme_class_get = SystemParameterPaymentSettingSchemeGet
    entity = 'SystemParameter - Payment settings'


class SystemParameterPaymentSettingPublicResource(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterPaymentSettingPublicSchemeGet
    scheme_class_get = SystemParameterPaymentSettingPublicSchemeGet
    entity = 'SystemParameter - Payment setting publics'
    has_delete_operation = False
    has_modify_operation = False
    has_info_operation = True


class SystemParameterInvoiceSettingResource(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterInvoiceSettingScheme
    scheme_class_get = SystemParameterInvoiceSettingSchemeGet
    entity = 'SystemParameter - Invoice settings'

    def before_update(self, obj, req):
        log.debug(f"SELF.REQ_DATA = {self.req_data}")
        log.debug(f"OBJ.company_info = {obj.company_info}")
        if 'company_info' in self.req_data:
            obj.company_info = self.req_data["company_info"]
        if 'invoice_number_format' in req.data:
            last_val = req.data['invoice_number_format']
            model.get_db().session.execute("select setval('class4_seq_invoice_no',{})".format(last_val))
        return obj


class SystemParameterPortalResource(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterPortalScheme
    scheme_class_get = SystemParameterPortalSchemeGet
    entity = 'SystemParameter - Client portal settings'


class SystemParameterSystemSettingResource(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterSystemSettingScheme
    scheme_class_get = SystemParameterSystemSettingSchemeGet
    entity = 'SystemParameter - System settings'


class SystemParameterSystemSettingPublicResource(SystemParameterSystemSettingResource):
    scheme_class_get = SystemParameterSystemSettingSchemePublicGet
    scheme_class = SystemParameterSystemSettingSchemePublicGet
    has_modify_operation = False
    no_auth_needed = True
    security = ()


class SystemParameterSystemTimeoutsResource(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterSystemTimeoutsScheme
    scheme_class_get = SystemParameterSystemTimeoutsSchemeGet
    entity = 'SystemParameter - System timeouts'


class SystemParameterSystemEmailsResource(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterSystemEmailsScheme
    scheme_class_get = SystemParameterSystemEmailsSchemeGet
    entity = 'SystemParameter - System emails'


class SystemParameterAutoRateEmailResource(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterAutoRateEmailScheme
    scheme_class_get = SystemParameterAutoRateEmailSchemeGet
    entity = 'SystemParameter - Auto rate email config'


class SystemParameterQosRoutingResource(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterQosRoutingScheme
    scheme_class_get = SystemParameterQosRoutingSchemeGet
    entity = 'SystemParameter - QOS routing'


class SystemParameterFirstTimeWizard(SystemParameterCustomDnlResource):
    scheme_class = SystemParameterFirstTimeWizardScheme
    scheme_class_get = SystemParameterFirstTimeWizardSchemeGet
    entity = 'SystemParameter - FirstTimeWizard'


# region +++C4Lrn+++
class C4LrnCreate(DnlCreate):
    scheme_class = C4LrnScheme
    model_class = model.C4Lrn
    entity = 'C4Lrn'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        # obj.created_by=user.name
        # obj.created_on=datetime.now(UTC)
        old_obj = model.C4Lrn.filter()
        if old_obj and old_obj.first():
            obj = old_obj.first()
        return obj


class C4LrnResource(DnlResource):
    model_class = model.C4Lrn
    scheme_class = C4LrnScheme
    scheme_class_get = C4LrnSchemeGet
    scheme_class_modify = C4LrnSchemeModify
    entity = 'C4Lrn'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class C4LrnList(DnlList):
    scheme_class = C4LrnSchemeGet
    model_class = model.C4Lrn
    entity_plural = 'C4Lrns'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
        # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---C4Lrn---

# +++JurisdictionPrefix

class JurisdictionPrefixCreate(DnlCreate):
    scheme_class = JurisdictionPrefixScheme
    entity = 'JurisdictionPrefix'
    unique_field = 'prefix'
    import_key_fields = ('prefix',)
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        cls = model.JurisdictionPrefix
        if cls.filter(and_(cls.prefix == self.req_data['prefix'], cls.state == self.req_data['state'])).first():
            raise ValidationError({'prefix': ['duplicate prefix']})
        if obj.jurisdiction_country_name in ('US', 'CA'):
            obj.jurisdiction_id = 1
        else:
            obj.jurisdiction_id = 0
        return obj


class JurisdictionPrefixResource(DnlResource):
    model_class = model.JurisdictionPrefix
    scheme_class = JurisdictionPrefixScheme
    scheme_class_get = JurisdictionPrefixGetScheme
    scheme_class_modify = JurisdictionPrefixScheme
    entity = 'JurisdictionPrefix'
    id_field = 'id'
    # has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        cls = model.JurisdictionPrefix
        if cls.filter(and_(cls.prefix == self.req_data['prefix'], cls.state == self.req_data['state'],
                           cls.id != obj.id)).first():
            raise ValidationError({'prefix': ['duplicate prefix']})
        if 'jurisdiction_country_name' in req.data and req.data['jurisdiction_country_name'] in ('US', 'CA'):
            obj.jurisdiction_id = 1
        else:
            obj.jurisdiction_id = 0
        return obj


class JurisdictionPrefixList(DnlList):
    scheme_class = JurisdictionPrefixGetScheme
    model_class = model.JurisdictionPrefix
    entity_plural = 'JurisdictionPrefixes'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# ---JurisdictionPrefix

# +++LoopDetection

class LoopDetectionCreate(DnlCreate):
    scheme_class = LoopDetectionScheme
    entity = 'LoopDetection rules'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        dup = []
        rules = []
        for res in obj.ingress_trunks:
            cls = model.LoopDetectionDetail
            q = cls.filter(cls.resource_id == res.resource_id).first()
            if q:
                dup.append(res.resource_id)
                rules.append(q.parent.name)
        if dup:
            raise ValidationError(
                {'ingress_trunks': ['trunks {} already present in another rules {}, cannot add'.format(dup, rules)]})
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        obj = model.LoopDetection.get(object_id)
        obj.update_trunks()
        obj.save()
        return obj


class LoopDetectionResource(DnlResource):
    model_class = model.LoopDetection
    scheme_class = LoopDetectionScheme
    scheme_class_get = LoopDetectionGetScheme
    scheme_class_modify = LoopDetectionScheme
    entity = 'LoopDetection rule'
    id_field = 'id'
    # has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        if 'ingress_trunks' in req.data and req.data['ingress_trunks']:
            obj.ingress_trunks = []
        return super().before_update(obj, req)

    def after_update(self, result, obj, data):
        obj.update_trunks()
        obj.save()
        return obj

    def delete_object(self, req, resp, model_class, **kwargs):
        obj = self.get_object(resp, model_class, **kwargs)
        if obj:
            obj.reset_trunks()
            log.debug('lopp delete rest trunks {}'.format(','.join([str(t.trunk_name) for t in obj.ingress_trunks])))

        return super(LoopDetectionResource, self).delete_object(req, resp, model_class, **kwargs)


class LoopDetectionList(DnlList):
    scheme_class = LoopDetectionGetScheme
    model_class = model.LoopDetection
    entity_plural = 'LoopDetection rules'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    # def on_get(self, req, resp, **kwargs):
    #    self._trunk_count = False
    #    return super(LoopDetectionList,self).on_get(req, resp, **kwargs)

    def on_filter_trunk_count_gt(self, query, value, kwargs):
        if '_trunk_count' in kwargs:
            return query.having(model.func.count(model.LoopDetectionDetail.id) > value)
        else:
            kwargs['_trunk_count'] = True
            return query.outerjoin(model.LoopDetectionDetail,
                                   model.LoopDetectionDetail.loop_detection_id == model.LoopDetection.id). \
                group_by(model.LoopDetection.id). \
                having(model.func.count(model.LoopDetectionDetail.id) > value)

    def on_filter_trunk_count_lt(self, query, value, kwargs):
        if '_trunk_count' in kwargs:
            return query.having(model.func.count(model.LoopDetectionDetail.id) < value)
        else:
            kwargs['_trunk_count'] = True
            return query.outerjoin(model.LoopDetectionDetail,
                                   model.LoopDetectionDetail.loop_detection_id == model.LoopDetection.id). \
                group_by(model.LoopDetection.id). \
                having(model.func.count(model.LoopDetectionDetail.id) < value)

    def _modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret = self.model_class.query()
        filt = {}
        query_fields = self.scheme_class.Meta.query_fields if hasattr(self.scheme_class.Meta,
                                                                      'query_fields') else []
        if filtering:
            for k, v in filtering.items():
                if k == 'trunk_count_gtXX':
                    ret = ret.outerjoin(model.LoopDetectionDetail).group_by(self.model_class.id).having(
                        model.func.count(model.LoopDetectionDetail.id) > v)
                    continue
                if k == 'trunk_count_lt':
                    ret = ret.outerjoin(model.LoopDetectionDetail).group_by(self.model_class.id).having(
                        model.func.count(model.LoopDetectionDetail.id) < v)
                    continue
                if query_fields and k in query_fields:
                    fop = self.parse_query_field(k, self.model_class)[0]
                    ret = ret.filter(text_(fop.format(v)))
                    continue
                filt[k] = v

        return (filt, ret)


class LoopDetectionActivate(DnlResourceAll):
    scheme_class = LoopDetectionActivateScheme
    model_class = model.LoopDetection
    scheme_class_get = ObjectUpdatedScheme
    entity = 'LoopDetection'
    has_update_by = True

    def on_all_update(self, q, req_data):
        for obj in q.all():
            obj.block_second = req_data['block_second']
            obj.update_trunks()

    def on_all_delete(self, q):
        for obj in q.all():
            obj.reset_trunks()


class LoopDetectionDetailList(DnlList):
    scheme_class = LoopDetectionDetailGetScheme
    model_class = model.LoopDetectionDetail
    entity_plural = 'LoopDetection blocked items'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        block_time_gt = filtering.pop('block_time_gt', None)
        block_time_lt = filtering.pop('block_time_lt', None)
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        if block_time_gt and block_time_lt:
            resources = model.Resource.filter(model.Resource.block_time.between(block_time_gt, block_time_lt)).all()
            ret = ret.filter(
                model.LoopDetectionDetail.resource_id.in_([resource.resource_id for resource in resources]))
        return filt, ret


# ---LoopDetection

# +++ FraudDetection


class FraudDetectionCreate(DnlCreate):
    scheme_class = FraudDetectionScheme
    entity = 'FraudDetection rules'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.update_on = datetime.now(UTC)

        return obj


class FraudDetectionResource(DnlResource):
    model_class = model.FraudDetection
    scheme_class = FraudDetectionScheme
    scheme_class_get = FraudDetectionGetScheme
    scheme_class_modify = FraudDetectionScheme
    entity = 'FraudDetection rule'
    id_field = 'id'
    has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_on = datetime.now(UTC)
        return obj


class FraudDetectionList(DnlList):
    scheme_class = FraudDetectionGetScheme
    model_class = model.FraudDetection
    entity_plural = 'FraudDetection rules'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class FraudDetectionActivate(DnlResourceAll):
    scheme_class = FraudDetectionActivateScheme
    model_class = model.FraudDetection
    scheme_class_get = ObjectUpdatedScheme
    entity = 'FraudDetection'
    has_update_by = True


class FraudDetectionLogList(DnlList):
    scheme_class = FraudDetectionLogGetScheme
    model_class = model.FraudDetectionLog
    entity_plural = 'FraudDetection execution records'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# --- FraudDetection


# +++ AlertRule


class AlertRuleCreate(DnlCreate):
    scheme_class = AlertRuleScheme
    entity = 'AlertRule rules'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        return obj


class AlertRuleResource(DnlResource):
    model_class = model.AlertRule
    scheme_class = AlertRuleScheme
    scheme_class_get = AlertRuleGetScheme
    scheme_class_modify = AlertRuleScheme
    entity = 'AlertRule rule'
    id_field = 'id'
    has_update_by = True
    unique_field = 'rule_name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class AlertRuleList(DnlList):
    scheme_class = AlertRuleGetScheme
    model_class = model.AlertRule
    entity_plural = 'AlertRule rules'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class AlertRuleActivate(DnlResourceAll):
    scheme_class = AlertRuleActivateScheme
    model_class = model.AlertRule
    scheme_class_get = ObjectUpdatedScheme
    entity = 'AlertRule rule'
    has_update_by = True


class AlertRuleLogList(DnlList):
    scheme_class = AlertRuleLogDetailGetScheme
    model_class = model.AlertRulesLogDetail
    entity_plural = 'AlertRule log records'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# --- AlertRule


# +++ BalanceDailyResetTask

class BalanceDailyResetTaskAction(CustomAction):
    model_class = model.Client
    scheme_class = BalanceDailyResetTaskScheme
    scheme_class_get = SuccessResponse
    entity = 'BalanceDailyResetTask'
    id_field = 'client_id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_parameters = ('Parameters for Reset balance', BalanceDailyResetTaskScheme)
    method = 'post'
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier id'},)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    @staticmethod
    def payment_reset(payment_type, client_id, new_balance, start_time, now, create_by):
        pay = model.ClientPayment
        pay.filter(
            and_(model.ClientPayment.client_id == client_id, model.ClientPayment.payment_type == payment_type)).delete()
        pay.session().commit()
        pay(result=True, receiving_time=now, amount=new_balance, client_id=client_id,
            description='Regenerate Balance', payment_type=payment_type, payment_time=start_time,
            update_by=create_by).save()

    def apply_today(self, obj, req, resp, **kwargs):
        try:
            client_id = int(kwargs['client_id'])
            start_time = self.req_data.get('start_time', str(datetime.today().date()))
            today_start_time = parse_datetime(start_time)
            d = datetime.now(UTC).date()
            start_time = str(d)
            start_time_1 = str(datetime.now(UTC).date())
            new_balance = self.req_data.get('new_balance', None)
            reset_balance = 1 if self.req_data.get('reset_balance', None) in ('true', True) else 0
            old_new_balance = new_balance
            reset_actual_balance = self.req_data.get('reset_actual_balance', None)
            reset_mutual_balance = self.req_data.get('reset_mutual_balance', None)
            if not reset_actual_balance and not reset_mutual_balance:
                reset_actual_balance, reset_mutual_balance = True, True
            create_by = self.get_user(req).name
            now = datetime.now(UTC)
            if reset_actual_balance:
                model.BalanceHistoryActual.filter(model.BalanceHistoryActual.client_id == client_id).delete()
                model.BalanceDailyResetTask(start_time=start_time, actual=1, client_id=client_id, reset_balance=1,
                                            create_by=create_by).save()
            if reset_mutual_balance:
                model.BalanceHistory.filter(model.BalanceHistory.client_id == client_id).delete()
                model.BalanceDailyResetTask(start_time=start_time, mutual=1, client_id=client_id, reset_balance=1,
                                            create_by=create_by).save()
            old_amount = None
            if not new_balance is None:
                if client_id:
                    cl = model.Client.get(client_id)
                    c4 = model.C4ClientBalance.filter(model.C4ClientBalance.client_id == str(cl.client_id)).first()
                    old_amount = c4.balance if c4 else None
                    if reset_mutual_balance or reset_actual_balance:
                        if reset_mutual_balance:
                            payment_type = 13
                        if reset_actual_balance:
                            payment_type = 14
                        if reset_mutual_balance and reset_actual_balance:
                            payment_type = 9
                        self.payment_reset(payment_type, client_id, new_balance, start_time, now, create_by)
                        if reset_actual_balance:
                            model.BalanceHistoryActual(date=start_time, actual_balance=new_balance, client_id=client_id,
                                                    actual_ingress_balance=new_balance, actual_egress_balance=0.0).save()
                        if reset_mutual_balance:
                            model.BalanceHistory(date=start_time, mutual_balance=new_balance, client_id=client_id,
                                                mutual_ingress_balance=new_balance, mutual_egress_balance=0.0).save()
                        if reset_mutual_balance:
                            cl.regenerate_balance()
                else:

                    for cl in model.Client.filter(model.Client.status == True).all():
                        if reset_mutual_balance or reset_actual_balance:
                            if reset_mutual_balance:
                                payment_type = 13
                            if reset_actual_balance:
                                payment_type = 14
                            if reset_mutual_balance and reset_actual_balance:
                                payment_type = 9
                            self.payment_reset(payment_type, client_id, new_balance, start_time, now, create_by)
                            if reset_actual_balance:
                                model.BalanceHistoryActual(date=start_time, actual_balance=new_balance,
                                                        client_id=cl.client_id,
                                                        actual_ingress_balance=new_balance,
                                                        actual_egress_balance=0.0).save()
                            if reset_mutual_balance:
                                model.BalanceHistory(date=start_time, mutual_balance=new_balance, client_id=cl.client_id,
                                                    mutual_ingress_balance=new_balance, mutual_egress_balance=0.0).save()
                            if reset_mutual_balance:
                                cl.regenerate_balance()
            actual, mutual = None, None
            if reset_actual_balance:
                actual = 1
            if reset_mutual_balance:
                mutual = 1
            # if actual or mutual:
            #     model.BalanceDailyResetTask(start_time=start_time, reset_balance=reset_balance, actual=actual, mutual=mutual,
            #                                 client_id=client_id,
            #                                 create_by=create_by, new_amount=new_balance, old_amount=old_amount).save()

            return True

        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False

        pass

    def apply(self, obj, req, resp, **kwargs):
        self.req_data = req.data
        try:
            if kwargs['client_id'] == 'all':
                kwargs['client_id'] = '0'
            try:
                client_id = int(kwargs['client_id'])
            except Exception as e:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(data={'client_id int found'}))
                return False
            if client_id != 0 and not model.Client.get(client_id):
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(data={'client_id int found'}))
                return False
            start_time = self.req_data.get('start_time', str(datetime.today().date()))
            today_start_time = None
            if parse_datetime(start_time).date() == datetime.now(UTC).date():
                return self.apply_today(obj, req, resp, **kwargs)

            new_balance = self.req_data.get('new_balance', None)
            old_new_balance = new_balance

            reset_actual_balance = self.req_data.get('reset_actual_balance', None)
            reset_mutual_balance = self.req_data.get('reset_mutual_balance', None)
            reset_balance = 1 if self.req_data.get('reset_balance', None) in ('true', True) else 0
            # if not reset_actual_balance and not reset_mutual_balance:
            #     raise Exception('Both reset_actual_balance and reset_mutual_balance are false. Nothing to do')
            create_by = self.get_user(req).name
            now = datetime.now(UTC)
            # if reset_actual_balance:
            #     model.BalanceDailyResetTask(start_time=start_time, actual=1, client_id=client_id,
            #                                 create_by=create_by).save()
            # if reset_mutual_balance:
            #     model.BalanceDailyResetTask(start_time=start_time, mutual=1, client_id=client_id,
            #                                 create_by=create_by).save()
            old_amount = None
            if not new_balance is None:
                if client_id:
                    cl = model.Client.get(client_id)
                    acls = model.BalanceHistoryActual
                    aq = acls.filter(acls.date == start_time, acls.client_id == cl.client_id).first()
                    if aq:
                        old_amount = aq.actual_ingress_balance

                    if reset_mutual_balance or reset_actual_balance:
                        if reset_mutual_balance:
                            payment_type = 13
                        if reset_actual_balance:
                            payment_type = 14
                        if reset_mutual_balance and reset_actual_balance:
                            payment_type = 9
                        self.payment_reset(payment_type, client_id, new_balance, start_time, now, create_by)
                        # model.ClientBalanceOperationAction.add_reset(client_id, new_balance, create_by)
                else:
                    for cl in model.Client.filter(model.Client.status == True).all():
                        if reset_mutual_balance or reset_actual_balance:
                            if reset_mutual_balance:
                                payment_type = 13
                            if reset_actual_balance:
                                payment_type = 14
                            if reset_mutual_balance and reset_actual_balance:
                                payment_type = 9
                            self.payment_reset(payment_type, client_id, new_balance, start_time, now, create_by)
                            # model.ClientBalanceOperationAction.add_reset(cl.client_id, new_balance, create_by)

            actual, mutual = None, None
            if reset_actual_balance:
                actual = 1
            if reset_mutual_balance:
                mutual = 1
            if actual or mutual:
                model.BalanceDailyResetTask(start_time=start_time, reset_balance=1, actual=actual, mutual=mutual,
                                            client_id=client_id,
                                            create_by=create_by, new_amount=new_balance, old_amount=old_amount).save()

            return True
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


class BalanceDailyResetTaskAllAction(BalanceDailyResetTaskAction):
    path_parameters = ()

    def apply(self, obj, req, resp, **kwargs):
        return super(BalanceDailyResetTaskAllAction, self).apply(obj, req, resp, client_id=0)


class BalanceDailyResetTaskCreate(DnlCreate):
    scheme_class = ImportGetScheme
    entity = 'BalanceDailyResetTask'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier id'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.create_by = self.get_user().name
        user = obj.create_by
        obj.create_at = datetime.now(UTC)
        obj.status = 'initial'
        if not 'start_time' in self.req_data:
            obj.start_time = datetime.today().date()
        obj.client_id = int(kwargs['client_id'])
        if obj.client_id != 0:
            q = model.Client.get(obj.client_id)
            if not q:
                raise NoResultFound()

        obj.reset_balance = 0
        obj.actual = 0
        obj.mutual = 0
        old = obj
        new_balance = self.req_data.get('new_balance', 0.0)
        reset_actual_balance = self.req_data.get('reset_actual_balance', None)
        reset_mutual_balance = self.req_data.get('reset_mutual_balance', None)
        if reset_actual_balance:
            obj0 = model.BalanceDailyResetTask(client_id=obj.client_id, start_time=obj.start_time,
                                               mutual=0, actual=1, status=0, create_by=obj.create_by)
            obj0.save()
            a = model.ClientBalanceOperationAction(client_id=obj.client_id,
                                                   balance=new_balance,
                                                   ingress_balance=new_balance,
                                                   egress_balance=0,
                                                   # action='Reset client balance, ingress balance, egress balance',
                                                   action='Increase ingress balance',
                                                   create_by=user)
            a.save()
            obj = model.BalanceDailyResetTask(client_id=obj.client_id, start_time=obj.start_time, reset_balance=1,
                                              mutual=1, actual=0, status=0, create_by=obj.create_by)
            obj.save()

        if reset_mutual_balance:
            obj0 = model.BalanceDailyResetTask(client_id=obj.client_id, start_time=obj.start_time,
                                               mutual=1, actual=0, status=0, create_by=obj.create_by)
            obj0.save()

            a = model.ClientBalanceOperationAction(client_id=obj.client_id,
                                                   balance=new_balance,
                                                   ingress_balance=new_balance,
                                                   egress_balance=0,
                                                   # action='Reset client balance, ingress balance, egress balance',
                                                   action='Increase ingress balance',
                                                   create_by=user)
            a.save()
            obj = model.BalanceDailyResetTask(client_id=obj.client_id, start_time=obj.start_time, reset_balance=1,
                                              mutual=1, actual=0, status=0, create_by=obj.create_by)
            obj.save()
        return obj


class BalanceDailyResetTaskAllCreate(BalanceDailyResetTaskCreate):
    path_parameters = ()

    def before_create(self, obj, **kwargs):
        super(BalanceDailyResetTaskAllCreate, self).before_create(obj, client_id=0)
        return obj


class BalanceDailyResetTaskList(DnlList):
    scheme_class = BalanceDailyResetTaskGetScheme
    model_class = model.BalanceDailyResetTask
    entity_plural = 'BalanceDailyResetTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(BalanceDailyResetTaskList, self).modify_query_from_filtering_for_list(filtering, **kwargs)

        # q = q.filter(model.BalanceDailyResetTask.reset_balance == 1)
        return ret, q


# +++ BalanceDailyResetTask

# ---- CreditLog
class CreditLogList(DnlList):
    scheme_class = CreditLogScheme
    model_class = model.CreditLog
    entity_plural = 'CreditLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- CreditLog

# ---- BalanceLog
class BalanceLogList(DnlList):
    scheme_class = BalanceLogScheme
    model_class = model.BalanceLog
    entity_plural = 'BalanceLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- BalanceLog

#  ---- HasUser

class HasUser(CustomGetAction):
    model_class = model.User
    scheme_class = HasUserGetScheme
    path_parameters = ()
    no_auth_needed = True

    def proceed(self, req, resp, **kwargs):
        try:
            cls = self.model_class
            obj = model.get_db().session.query(cls.user_id).limit(1).first()

            has_user = True if obj else False
            data = {
                'success': True,
                'has_user': has_user,
            }
            self.set_response(resp, responses.SuccessResponseObjectInfo(data=data))

            return True
        except AttributeError as e:
            self.set_response(
                resp, responses.AttributeNotExitsErrorResponse(
                    data=ATTRIBUTE_ERROR_RE.search(str(e)).group(1)
                )
            )
            return False
        except Exception as e:
            import traceback
            log.error(traceback.format_exc())
            self.set_response(resp, OperationErrorResponse(e))
            return False


#  ---- HasUser

# ++++ AuthToken
class AuthTokenList(DnlList):
    scheme_class = AuthTokenScheme
    model_class = model.AuthToken
    entity_plural = 'AuthToken'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


class AuthTokenDisable(CustomPostAction):
    scheme_class = AuthTokenDisableScheme
    entity_plural = 'AuthToken'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({"name": "token", "type": "string", "description": "token"},)

    def on_post(self, req, resp, **kwargs):
        cls = model.AuthToken
        obj = cls.filter(cls.token == kwargs['token']).first()
        if obj:
            obj.is_disabled = True
            obj.save()

            self.set_response(resp, responses.SuccessResponseJustOk())
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return False # ---- AuthToken


# ---- ImportExportLogs
class ImportExportLogsExportList(DnlList):
    scheme_class = ImportExportLogsExportScheme
    model_class = model.ImportExportLogs
    entity_plural = 'ImportExportLogs'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        user = self.get_user(self.req)
        if (user.user_type == 'client') and user.client:
            ret = ret.filter(cls.user_id == user.user_id)
        return filt, ret

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ImportExportLogsExportList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['log_type'] = 'export'
        return ret


class ImportExportLogsImportList(DnlList):
    scheme_class = ImportExportLogsImportScheme
    model_class = model.ImportExportLogs
    entity_plural = 'ImportExportLogs'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        ret = ret.filter(model.ImportExportLogs.obj.notin_(['png', 'jpg', 'ico']))
        return filt, ret

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(ImportExportLogsImportList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['log_type'] = 'import'
        return ret


def _json_write(file, result, scheme, only=None):
    csvfile = file  # open(file, 'wt+')
    csvfile.write('{"items":[')
    if not only:
        fieldnames = scheme.Meta.fields
    else:
        fieldnames = only
    for row in result:
        dump = scheme.dump(row, many=False).data
        csvfile.write(json.JSONEncoder().encode(dump) + ",")
    csvfile.write("]}")


# csvfile.close()


def _csv_write(file, result, scheme, only=None, headers=True, row_callback=None):
    csvfile = file  # open(file, 'wt+')
    if not only:
        fieldnames = scheme.Meta.fields
    else:
        fieldnames = only
    writer = csv.DictWriter(csvfile, fieldnames=fieldnames)
    if headers:
        writer.writeheader()
    # dump=SchemeClass().dump(result,many=True).data
    # writer.writerows(dump)
    i = 0
    for row in result:
        dump = scheme.dump(row, many=False).data
        writer.writerow(dump)
        i += 1
        if row_callback:
            row_callback(i)
    return i


# csvfile.close()


def xml_tostring(x):
    if x == None:
        return ''
    else:
        return str(x)


def _xml_write(file, result, scheme, only=None):
    from xmljson import BadgerFish as bf, Parker as X2J, parker as par, Element
    from xml.etree.ElementTree import fromstring, tostring
    import xml.etree.ElementTree as ET
    from xml.dom import minidom

    from api_dnl.__version__ import __version__ as VERSION

    xmlfile = file  # open(file, 'wt+')
    if not only:
        fieldnames = scheme.Meta.fields
    else:
        fieldnames = only

    dump = scheme.dump(result, many=True).data
    data = {'items': dump}
    # scheme.Meta.model.__name__
    attr = {'entity': scheme.Meta.model.__name__, 'api_version': VERSION, 'timestamp': str(datetime.utcnow())}
    result = bf(xml_tostring=xml_tostring).etree(data=data, root=Element('xml', attrib=attr))
    rough_string = tostring(result, 'utf-8')
    reparsed = minidom.parseString(rough_string)
    xmlfile.write(reparsed.toprettyxml(indent='\t'))


def _xls_write(file, result, scheme, only=None):
    from api_dnl.__version__ import __version__ as VERSION
    import xlwt

    xlsfile = file  # open(file, 'wb+')
    if not only:
        fieldnames = scheme.Meta.fields
    else:
        fieldnames = only

    dump = scheme.dump(result, many=True).data

    wb = xlwt.Workbook(encoding='utf-8')
    ws = wb.add_sheet('export ' + scheme.__class__.__name__)
    # Sheet header, first row
    row_num = 0
    font_style = xlwt.XFStyle()
    font_style.font.bold = True
    for c, col in enumerate(dump[0].keys()):
        ws.write(0, c, col, font_style)
    font_style.font.bold = False
    for r, row in enumerate(dump):
        for c, col in enumerate(row.values()):
            ws.write(r + 1, c, col, font_style)
    wb.save(xlsfile)


# xlsfile.close()


class ExportCreate(DnlCreate):
    model_class = model.ImportExportLogs
    scheme_class = ExportCreateScheme
    scheme_class_get = ExportGetScheme
    entity = 'Doing export '
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        from .task.export_file import create_export_query
        obj.user_id = self.get_user().user_id
        obj.download_time = None
        obj.log_type = 'export'
        obj._query = self.req_data['query']
        obj.status = 'initial'
        obj.obj = self.req_data['entity']
        create_export_query(obj)
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        from kombu.exceptions import OperationalError
        from .task.export_file import export_file
        try:
            log.debug('export_file {} try to schedule'.format(object_id))
            export_file.delay(object_id=object_id)
            log.info('export_file task scheduled {}'.format(object_id))
        except OperationalError as e:
            log.error('export_file {} restart sync:{}'.format(object_id, str(e)))
            export_file(object_id=object_id)
            log.debug('export_file {} finished '.format(object_id))
        except Exception as e:
            log.error('export_file {} restart sync:{}'.format(object_id, str(e)))
            export_file(object_id=object_id)
            log.debug('export_file {} finished '.format(object_id))

    def before_create_old(self, obj, **kwargs):
        obj.user_id = self.get_user().user_id
        obj.download_time = None
        obj.log_type = 'export'
        query = self.req_data['query']
        fmt = query['format']
        obj.file_path = settings.FILES['upload_to']
        obj.file_name = obj.obj + '_' + str(datetime.now(UTC)) + '.' + query['format']
        if not obj.obj in model.__dict__:
            raise ValidationError('Entity does not exists :{}'.format(obj.obj))
        cls = model.__dict__[obj.obj]
        meta = inspect(cls)
        qu = cls.query()
        cols = []
        if query['select'] and query['select'][0] == '*':
            query['select'] = []
            for f in meta.columns:
                if isinstance(f, model.Column):
                    query['select'].append(f.name)
        for f in query['select']:
            if f in meta.columns:
                cols.append(meta.columns[f])
            else:
                raise ValidationError('wrong field name :{}'.format(f))
        q = qu.session.query(*tuple(cols))
        if 'where' in query:
            for f in query['where']:
                filt = text_("{} {} '{}'".format(f['field'], f['op'], f['value']))
                q = q.filter(filt)
        try:
            result = q.all()
        except Exception as e:
            obj.status = 'fail'
            raise e
        if len(result) == 0:
            raise ValidationError('nothing to export!')

        class SchemeClass(BaseModelScheme):
            class Meta:
                model = cls
                fields = query['select']

        # --ouput--
        file_path = obj.file_path + '/' + obj.file_name
        if fmt == 'csv':
            _csv_write(file_path, result, SchemeClass)
        elif fmt == 'json':
            _json_write(file_path, result, SchemeClass)
        else:
            obj.status = 'fail'
            raise ValidationError('Not implemented...')
        obj.status = 'success'
        obj.finished_time = datetime.now(UTC)
        return obj

    def on_post(self, req, resp, **kwargs):
        try:
            user = self.get_user(req)
            if user.user_type == 'client' and (not 'entity' in req.data or req.data['entity'] != 'Rate'):
                self.set_response(
                    resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
                )
                return
            super(ExportCreate, self).on_post(req, resp, **kwargs)

        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class RateExportCreate(ExportCreate):
    model_class = model.ImportExportLogs
    scheme_class = RateCreateScheme
    scheme_class_get = ExportGetScheme
    entity = 'Doing export '
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        try:
            data = req.data
            new_data = {
                "query": {
                    "format": "csv",
                    "where": [
                        {
                            "op": "=",
                            "value": str(data['rate_table_id']),
                            "field": "rate_table_id"
                        },
                    ],
                    "select": [
                        "code",
                        "rate",
                        "effective_date",
                        "min_time",
                        "interval"
                    ],
                    "order": [
                        {
                            "field": "code",
                            "direction": "asc"
                        }
                    ]
                },
                "is_public": False,
                "entity": "Rate"
            }
            if 'headers' in data and data['headers']:
                new_data['query']['select'] = data['headers'].split(',')
            if 'header_text' in data and data['header_text']:
                new_data['query']['header_text'] = data['header_text']
            if 'footer_text' in data and data['footer_text']:
                new_data['query']['footer_text'] = data['footer_text']
            if 'is_effective_now' in data:
                new_data['query']['where'] += [
                    {
                        "op": "=",
                        "value": str(data['is_effective_now']),
                        "field": "is_effective_now"
                    }
                ]
            if 'effective_at' in data:
                new_data['query']['where'] += [
                    {
                        "op": "=",
                        "value": str(data['effective_at']),
                        "field": "effective_at"
                    }
                ]
            req.data = new_data
            super(RateExportCreate, self).on_post(req, resp, **kwargs)

        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class ExportGet(DnlResource):
    model_class = model.ImportExportLogs
    scheme_class = ExportGetScheme
    scheme_class_get = ExportGetScheme
    entity = 'Export file'
    id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec_info(self):
        spec = super(ExportGet, self).get_spec_info()
        spec['get']['produces'] = ['application/json', 'image/ico', 'image/jpg', 'image/png', 'text/csv',
                                   'application/xls']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')
        try:
            try:
                _id = int(kwargs['id'])
            except:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            obj = self.get_object(resp, self.model_class, **kwargs)
            if not obj:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            if not obj.is_public:
                if not check_permission(self, req, 'show', obj):
                    self.set_response(
                        resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
                    )
                    return
            from time import sleep
            count = 0
            while obj.status in ('initial', 'in progress') and count < 15:
                count += 1
                sleep(1)
                obj = self.model_class.filter(self.model_class.id == obj.id).first()
            if obj.status == 'initial':
                self.set_response(resp, responses.SuccessResponseObjectInfo(
                    data={'not started': 'export/import not yet started'}))
                # resp.status = falcon.HTTP_404
                return
            if obj.status == 'in progress':
                self.set_response(resp, responses.SuccessResponseObjectInfo(
                    data={'not finished': 'in progress {}'.format(obj.db_process_number)}))
                # resp.status = falcon.HTTP_404
                return
            if obj.status != 'success':
                self.set_response(resp, OperationErrorResponse('export/import was not successful!'))
                resp.status = falcon.HTTP_404
                return
            file_path = obj.file_path + '/' + obj.file_name
            if not os.path.exists(file_path):
                self.set_response(resp, OperationErrorResponse('file was cleaned on the server!'))
                resp.status = falcon.HTTP_404
                return
            fn = obj.file_name.replace(' ', '_').replace(':', '_').replace('+', '_').replace('.', '_')
            file_name = fn[:-4] + '.' + fn[-3:]
            resp.append_header('Content-Disposition', 'attachment; filename="{}"'.format(file_name))
            fmt = obj._query.pop('format', 'csv')
            if fmt not in ('png', 'jpg', 'ico', 'xls'):
                file = open(file_path, 'rt')
                resp.data = file.read().encode('UTF-8')
                resp.content_type = 'text/' + fmt
            else:
                file = open(file_path, 'rb')
                resp.data = file.read()
                if fmt == 'xls':
                    resp.content_type = 'application/vnd.ms-excel'
                else:
                    resp.content_type = 'image/' + fmt
                resp.status = falcon.HTTP_200
                return
            if self.get_user(req):
                obj.user_id = self.get_user(req).user_id
            if obj.log_type == 'export':
                obj.download_time = datetime.now(UTC)
            obj.save()
            obj.finished_time = datetime.now(UTC)
            resp.status = falcon.HTTP_200
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class ExportStatus(DnlResource):
    model_class = model.ImportExportLogs
    scheme_class = ExportGetScheme
    scheme_class_get = ExportGetScheme
    entity = 'Export file'
    id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')
        try:
            try:
                _id = int(kwargs['id'])
            except:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            obj = self.get_object(resp, self.model_class, **kwargs)
            if not obj:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            if not obj.is_public:
                if not check_permission(self, req, 'show', obj):
                    self.set_response(
                        resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
                    )
                    return

            self.set_response(resp, responses.SuccessResponseObjectInfo(data={'status': obj.status}))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class ExportPublicGet(ExportGet):
    no_auth_needed = True

    def _check_permission(self, req, perm, obj):
        # if super(ExportPublicGet,self).check_permission( req, 'show', obj ):
        if obj and obj.is_public:
            return True
        else:
            return False


class ExportGetErrors(DnlResource):
    model_class = model.ImportExportLogs
    scheme_class = ExportCreateScheme
    scheme_class_get = ExportGetScheme
    entity = 'Export eror file'
    id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')

        if not check_permission(self, req, 'show', self.get_object(resp, self.model_class, **kwargs)):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj and obj.error_file_path:
                # if obj.status == 'success':
                #    self.set_response(resp, OperationalError('export was successful!'))
                file_path = obj.file_path + '/' + obj.error_file_path
                if os.path.isfile(file_path):
                    file = open(file_path, 'rt')
                    resp.data = file.read().encode('UTF-8')
                    resp.content_type = 'text/plain'
                    resp.status = falcon.HTTP_200
                    return

            self.set_response(
                resp, responses.ObjectNotFoundErrorResponse()
            )
            return
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


# self.set_response(resp, responses.SuccessResponseObjectInfo(data=data))


class ImportCreate(DnlCreate):
    model_class = model.ImportExportLogs
    scheme_class = ImportCreateScheme
    scheme_class_get = ImportGetScheme
    entity = 'Doing import'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_params = ()

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = self.body_params or (

            {
                'name': 'entity',
                'in': 'formData',
                'description': 'Entity to import',
                'required': True,
                'type': 'string',
                'default': 'Rate',
            },
            {
                'name': 'format',
                'in': 'formData',
                'description': 'format',
                'required': True,
                'type': 'string',
                'default': 'csv',
                'enum': ['csv', 'json', 'xml', 'png', 'jpg', 'ico', 'txt', 'netrc']
            },
            {
                'name': 'file',
                'in': 'formData',
                'description': 'File to upload',
                'required': True,
                'type': 'file'
            },
            {
                'name': 'ignore_fields',
                'in': 'formData',
                'description': 'comma separated list of fields to ignore from import',
                'required': False,
                'type': 'list',
            },
            {
                'name': 'replace_fields',
                'in': 'formData',
                'description': 'comma separated list of fields to replace from import',
                'required': False,
                'type': 'list',

            },
            {
                'name': 'replace_values',
                'in': 'formData',
                'description': 'comma separated list of values  for replace from import',
                'required': False,
                'type': 'list',

            },
            {
                'name': 'delete_dublicates',
                'in': 'formData',
                'description': 'If set, will override rows with dublicate values of this field',
                'required': False,
                'type': 'boolean',

            },
            {
                'name': 'delete_mode',
                'in': 'formData',
                'description': 'exact:delete for exact match, partial: delete keys matched',
                'required': False,
                'type': 'string',
                'enum': ['exact', 'partial']
            },
            {
                'name': 'ignore_invalid_fields',
                'in': 'formData',
                'description': 'If set, will delete invalid fields and try to import row again',
                'required': False,
                'type': 'boolean',

            },
        )

        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          self.scheme_class.get_object_created_response(entity=self.entity),
                          # ,scheme=ObjectCreatedWithErrorsScheme),
                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def _log(self, msg, item=None, e=None):
        if not self.local_file_err:
            self.local_file_err = open(self.error_file_path, 'wt')
        if item:
            self.local_file_err.write(json.dumps(item) + '\n')
        self.local_file_err.write(str(msg))
        if e:
            try:
                self.local_file_err.write(str(e) + '\n')
            except Exception as e1:
                self.local_file_err.write('cannot save exception' + '\n')
                pass

    def before_create(self, obj, **kwargs):
        try:
            if obj.obj == 'DidBillingRel':
                raise ValidationError('for did import please use /tool/did_number_upload_task')
            obj.upload_type = 'http'
            obj.user_id = self.get_user().user_id
            obj.time = datetime.now(UTC)
            obj.log_type = 'import'
            fmt = self.req_data['format']
            if self.req_data.get('delete_dublicates', False) in (True, 'true', 'True'):
                obj.duplicate_type = 'delete'
            else:
                obj.duplicate_type = 'ignore'
            if self.req_data.get('delete_mode', None) in ('exact', 'partial'):
                obj.duplicate_type = self.req_data['delete_mode']
            obj._query = self.req_data  # {'format': fmt}
            obj.file_path = settings.FILES['upload_to']
            obj.file_name = obj.obj + '_' + obj.time.strftime('%Y%m%d_%H%M%S') + '.' + fmt
            file_path = obj.file_path + '/' + obj.file_name
            if os.path.exists(file_path):
                os.unlink(file_path)
            obj.error_file_path = obj.obj + '_' + obj.time.strftime('%Y%m%d_%H%M%S') + '.err'
            self.error_file_path = obj.file_path + '/' + obj.error_file_path
            self.local_file_err = None
            file = self.req.files['file']
            if fmt in ('png', 'jpg', 'ico', 'json', 'netrc', 'txt'):

                # byte_str = file.read()
                # local_file.write(byte_str)
                b = file.read()
                fsz = len(b)
                log.info('Uploaded file size:{}'.format(fsz))
                flimit = 200 * 1024 * 1024
                if fmt == 'ico' or obj.obj == 'logo':
                    flimit = 2 * 1024 * 1024
                if (fsz > flimit):
                    raise ValidationError('Image file too big :{} , limit is {}'.format(fsz, flimit))
                local_file = open(file_path, 'wb')
                local_file.write(b)
                # shutil.copyfileobj(file, local_file)
                local_file.close()
                obj.is_public = True
                obj.obj = fmt
            else:
                # check header
                byte_str = file.readline()
                text_obj = byte_str.decode('UTF-8').replace('\r', '').replace('\n',
                                                                              '')  # Or use the encoding you expect
                headers = text_obj.split(',')
                if not headers:
                    raise ValidationError('Missing csv header')
                if None in headers or '' in headers:
                    raise ValidationError('Empty columns in  csv header')
                sc = _scheme(obj.obj)
                if not sc:
                    raise ValidationError('incorrect entity name')
                req_fields = [fn for fn, f in sc._declared_fields.items() if f.required]
                errors = {}
                for f in req_fields:
                    if not f in headers:
                        errors[f] = ['required field missing in header']
                for f in headers:
                    if 'ignore_fields' in obj._query and obj._query['ignore_fields']:
                        if f in obj._query['ignore_fields'].split(','):
                            continue
                    if not f in sc.Meta.fields:
                        errors[f] = ['wrong field name in file header']
                if errors:
                    raise ValidationError(errors)
                file.seek(0, 0)
                # copy to local file
                local_file = open(file_path, 'wt')
                self.local_file_err = None
                byte_str = file.read()
                text_obj = byte_str.decode('UTF-8')  # Or use the encoding you expect
                local_file.write(text_obj)
                obj.status = 'success'
                obj.save()
            if not fmt in ('png', 'jpg', 'ico', 'txt', 'netrc'):
                if not obj.obj in model.__dict__:
                    raise ValidationError('Entity does not exists :{}'.format(obj.obj))
                obj.status = 'initial'
                obj.save()
                try:
                    from api_dnl.task.import_file import import_file
                    ret = import_file.delay(obj.id)
                    obj.task_uuid = ret.id
                    obj.save()
                except:
                    log.warning('import task delay starting failed ')
        except ValidationError as e:
            raise e
        except Exception as e:
            obj.status = 'fail'
            log.error('Import failure: {}'.format(str(e)))
            obj.save()
            raise ValidationError('Import failure: {}'.format(traceback.format_exc()))
        return obj


class ResourceBlockImportCreate(ImportCreate):

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = self.body_params or (

            {
                'name': 'file',
                'in': 'formData',
                'description': 'File to upload',
                'required': True,
                'type': 'file'
            },
            {
                'name': 'number_type',
                'in': 'formData',
                'description': 'type of numbers',
                'required': True,
                'type': 'string',
                'default': 'ANI',
                'enum': ['ANI', 'DNIS']
            },
            {
                'name': 'clients_type',
                'in': 'formData',
                'description': 'direction of block',
                'required': True,
                'type': 'string',
                'default': 'Origination',
                'enum': ['Origination', 'Termination']

            },
            {
                'name': 'block_by',
                'in': 'formData',
                'description': 'block by trunk/group',
                'required': False,
                'type': 'string',
                'default': 'block by trunk',
                'enum': ['block by trunk', 'block by group']

            },
            {
                'name': 'client_id',
                'in': 'formData',
                'description': 'blocking carrier id',
                'required': False,
                'type': 'integer',

            },
            {
                'name': 'trunk_id',
                'in': 'formData',
                'description': 'blocking trunk id',
                'required': False,
                'type': 'integer',

            },
            {
                'name': 'delete_dublicates',
                'in': 'formData',
                'description': 'If set, will override rows with dublicate values of this field',
                'required': False,
                'type': 'boolean',

            },
            {
                'name': 'method_type',
                'in': 'formData',
                'description': 'upload/delete',
                'required': False,
                'type': 'string',
                'default': 'upload',
                'enum': ['upload', 'delete']
            }
        )

        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          self.scheme_class.get_object_created_response(entity=self.entity),
                          # ,scheme=ObjectCreatedWithErrorsScheme),
                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def before_create(self, obj, **kwargs):
        try:

            obj.upload_type = 'http'
            obj.user_id = self.get_user().user_id
            obj.time = datetime.now(UTC)
            obj.log_type = 'import'
            obj.obj = 'ResourceBlock'

            if self.req_data.pop('method_type', 'upload') == 'delete':
                self.req_data['delete_mode'] = 'exact'
            if self.req_data.get('delete_dublicates', False):
                obj.duplicate_type = 'delete'
            else:
                obj.duplicate_type = 'ignore'
            self.req_data['upload_ani_dnis'] = True
            if 'client_id' in self.req_data:
                _valid('Client', 'client_id', self.req_data['client_id'], 'Invalid client_id')
            if 'block_by' in self.req_data:
                if self.req_data['block_by'] == 'block by trunk':
                    if 'trunk_id' in self.req_data:
                        _valid('Resource', 'resource_id', self.req_data['trunk_id'], 'Invalid trunk_id')
                    else:
                        self.req_data['trunk_id'] = None
                else:
                    _valid('TrunkGroup', 'group_id', self.req_data['trunk_id'], 'Invalid trunk group id')

            obj._query = self.req_data  # {'format': fmt}
            file = self.req.files['file']
            fmt = file.filename.split('.')[-1]
            obj.file_path = settings.FILES['upload_to']
            obj.file_name = obj.obj + '_' + str(obj.time) + '.' + fmt
            file_path = obj.file_path + '/' + obj.file_name
            obj.error_file_path = obj.file_name + '.err'
            self.error_file_path = obj.file_path + '/' + obj.error_file_path
            self.local_file_err = None

            if 'number_type' in self.req_data:
                number_type = self.req_data['number_type'].lower()

            local_file = open(file_path, 'wt')
            self.local_file_err = None
            byte_str = file.read()
            text_obj = byte_str.decode('UTF-8')  # Or use the encoding you expect
            if text_obj.split('\n')[0].isdigit():
                text_obj = '{}\n'.format(number_type) + text_obj
            local_file.write(text_obj)
            obj.status = 'success'
            obj.save()
            if not obj.obj in model.__dict__:
                raise ValidationError('Entity does not exists :{}'.format(obj.obj))
            obj.status = 'initial'
            obj.save()
        except ValidationError as e:
            raise e
        except Exception as e:
            obj.status = 'fail'
            log.error('Import failure: {}'.format(str(e)))
            raise ValidationError('Import failure: {}'.format(traceback.format_exc()))
            obj.save()
        return obj


class BlockNumberImportTaskCreate(DnlCreate):
    scheme_class = BlockNumberImportTaskScheme
    model_class = model.BlockNumberImportTask
    entity = 'BlockNumberImportTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = (
            {'name': 'file', 'in': 'formData', 'description': 'File to upload', 'type': 'file'},
            {'name': 'paste', 'in': 'formData', 'description': 'numbers to upload', 'type': 'text'},
            {'name': 'redup_in_block_rable_action', 'in': 'formData', "type": "string", "enum":
                ['reject entire import', 'skip the record', 'overwrite existing record']
             },
            {'name': 'redup_in_file_action', 'in': 'formData', "type": "string", "enum":
                ['reject entire import', 'skip the record', 'overwrite existing record']
             },
            {'name': 'op_method', 'in': 'formData', "type": "string", "enum": ["Upload", "Delete", "Release"]},
            # {'name': 'egress_client_id', 'in': 'formData', "type": "integer"},
            {'name': 'egress_trunk_id', 'in': 'formData', "type": "integer"},
            {'name': 'egress_trunk_group_id', 'in': 'formData', "type": "integer"},
            {'name': 'ingress_client_id', 'in': 'formData', "type": "integer"},
            {'name': 'ingress_trunk_id', 'in': 'formData', "type": "integer"},
            {'name': 'ingress_trunk_group_id', 'in': 'formData', "type": "integer"},
            {'name': 'block_type', 'in': 'formData', "type": "string",
             "enum": ["all", "specific trunk", "specific carrier", "specific group"]},
            {'name': 'prefix_type', 'in': 'formData', "type": "string", "enum": ["ani", "dnis"]},
            # {'name': 'client_id', 'in': 'formData', "type": "integer"},

        )
        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          # self.scheme_class.get_object_created_response(entity=self.entity),
                          responses.ObjectCreatedResponse(data_key='object_uuid', scheme=schemes.ObjectCreatedUuidAsPk),
                          SuccessResponseJustOk()

                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def before_create(self, obj, **kwargs):
        file = self.req.files['file'] if 'file' in self.req.files else None
        user = self.get_user(self.req)
        obj.operator_user = user.name

        obj.redup_in_block_rable_action = self.req_data.get('redup_in_block_rable_action', 'reject entire import')
        obj.redup_in_file_action = self.req_data.get('redup_in_file_action', 'reject entire import')
        obj.import_file_path = settings.FILES['upload_to']
        obj.op_method = self.req_data.get('op_method', 'Upload')
        uuid = generate_uuid_str()()
        obj.orig_import_file = uuid + '.csv'
        obj.format_import_file = obj.orig_import_file.replace('.csv', '_fmt.csv')
        file_name = obj.import_file_path + '/' + obj.orig_import_file
        # b = file.readlines()
        paste_str = self.req_data.get('paste', None)

        prefix_type = 'ani'
        if 'prefix_type' in self.req_data and self.req_data['prefix_type']:
            prefix_type = 'dnis' if self.req_data['prefix_type'] == 'dnis' else 'ani'

        if file:
            b = [line.decode() for line in file.readlines() if line.strip()]
        elif paste_str:
            paste_arr = paste_str.split(',')
            b = ['{}\n'.format(prefix_type)] + [(number + '\n') for number in paste_arr]
        else:
            raise ValidationError({'error': 'one of [paste, file] should not be null'})

        # log.info('Uploaded file rows:{}'.format(obj.num_records))
        log.debug(f'B = {b}')
        try:
            if b[0].replace('\n', '').replace('\r', '') not in ('ani', 'dnis') and not ',' in b[0]:
                b = ['{}\n'.format(prefix_type)] + b
            # b[0] = b[0].replace('ani', prefix_type).replace('dnis', prefix_type)
        except Exception as e:
            log.debug(f"ERROR - {e}")
        local_file = open(file_name, 'wt')
        local_file.writelines(b)
        local_file.close()

        egress_client_name, egress_client_id = None, None
        # log.debug(f"REQ_DATA = {self.req_data}")
        # if 'egress_client_id' in self.req_data:
        #     egress_client_id = self.req_data['egress_client_id']
        #     log.debug(f"egress_client_id = {egress_client_id}")
        #     egress_client_name = model.Client.filter(model.Client.client_id == egress_client_id).first().name
        #     log.debug(f"egress_client_name = {egress_client_name}")
        egress_trunk_id, egress_trunk_name = None, None
        if 'egress_trunk_id' in self.req_data and self.req_data['egress_trunk_id'] != 'None':
            egress_trunk_id = self.req_data['egress_trunk_id']
            egress_trunk = model.Resource.filter(model.Resource.resource_id == egress_trunk_id).first()
            if egress_trunk is not None:
                egress_trunk_name = egress_trunk.alias
        egress_trunk_group_id, egress_trunk_group_name = None, None
        if 'egress_trunk_group_id' in self.req_data and self.req_data['egress_trunk_group_id'] != 'None':
            egress_trunk_group_id = self.req_data['egress_trunk_group_id']
            egress_trunk_group_name = model.TrunkGroup.filter(
                model.TrunkGroup.group_id == egress_trunk_group_id).first().group_name
        ingress_client_id, ingress_client_name = None, None
        if 'ingress_client_id' in self.req_data and self.req_data['ingress_client_id'] != 'None':
            ingress_client_id = self.req_data['ingress_client_id']
            ingress_client_name = model.Client.filter(model.Client.client_id == ingress_client_id).first().name
        ingress_trunk_id, ingress_trunk_name = None, None
        if 'ingress_trunk_id' in self.req_data and self.req_data['ingress_trunk_id'] != 'None':
            ingress_trunk_id = self.req_data['ingress_trunk_id']
            log.debug(f"ingress_trunk_id = {ingress_trunk_id}")
            ingress_trunk_name = model.Resource.filter(model.Resource.resource_id == ingress_trunk_id).first().alias
            log.debug(f"ingress_trunk_name = {ingress_trunk_name}")
        ingress_trunk_group_id, ingress_trunk_group_name = None, None
        if 'ingress_trunk_group_id' in self.req_data and self.req_data['ingress_trunk_group_id'] != 'None':
            ingress_trunk_group_id = self.req_data['ingress_trunk_group_id']
            ingress_trunk_group_name = model.TrunkGroup.filter(
                model.TrunkGroup.group_id == ingress_trunk_group_id).first().group_name
        block_type = None
        if 'block_type' in self.req_data and self.req_data['block_type'] != 'None':
            BLOCK_TYPE = {'specific trunk': 1, 'specific carrier': 2, 'specific group': 3, 'all': 4}
            block_type = BLOCK_TYPE[self.req_data['block_type']]

        if (egress_client_name or egress_trunk_name or ingress_client_name or ingress_trunk_name
                or egress_trunk_group_name or ingress_trunk_group_name):
            obj.status = 'Initial'
            obj_id = obj.save()
            from api_dnl.tasks import do_block_number_import_preprocess
            from kombu.exceptions import OperationalError
            try:
                do_block_number_import_preprocess.delay(obj_id, egress_client_id, egress_trunk_id,
                                                        egress_trunk_group_id,
                                                        ingress_client_id, ingress_trunk_id,
                                                        ingress_trunk_group_id, block_type,
                                                        self.req_data)
            except OperationalError as e:
                log.warning('celery backend stopped:run preprocess online')
                do_block_number_import_preprocess(obj_id, egress_client_id, egress_trunk_id,
                                                  egress_trunk_group_id,
                                                  ingress_client_id, ingress_trunk_id, ingress_trunk_group_id,
                                                  block_type,
                                                  self.req_data)
                # raise ValidationError('cannot preprocess rate file: celery backend stopped')
                # do_rate_import_preprocess(obj_id, auto_ij_rate, self.req_data)
        else:
            obj.status = 'Initial'
            obj.format_import_file = obj.orig_import_file
            obj.save()
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        pass


class BlockNumberImportTaskLogGet(DnlResource):
    model_class = model.BlockNumberImportTask
    scheme_class = ExportGetScheme
    scheme_class_get = ExportGetScheme
    entity = 'BlockNumberImportTask log'
    id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = (DEFAULT_SECURITY)
    restrict = ()
    # no_auth_needed = True

    def get_spec_info(self):
        spec = super(BlockNumberImportTaskLogGet, self).get_spec_info()
        spec['get']['produces'] = ['application/json', 'text/csv', 'application/xls']
        return spec

    def on_get(self, req, resp, **kwargs):
        try:
            if not check_context(self, req, resp, **kwargs):
                self.set_response(resp, responses.ForbiddenErrorResponse())
                return
            try:
                _id = int(kwargs['id'])
            except:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            obj = self.get_object(resp, self.model_class, **kwargs)
            if not obj:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            if obj:
                if obj.status in ('Upload failed', ):
                    self.set_response(resp,
                                      OperationErrorResponse('BlockNumberImportTask Upload Failed progress: {}'.format(obj.progress)))
                    resp.status = falcon.HTTP_404
                    return
                if not obj.status in ('Upload successful',):
                    self.set_response(resp,
                                      OperationErrorResponse('BlockNumberImportTask in progress!'))
                    resp.status = falcon.HTTP_404
                    return
                file_path = None
                if obj.import_log_path:
                    file_path = obj.import_log_path + 'did_upload.log'
                if not file_path or not os.path.exists(file_path):
                    self.set_response(resp, OperationErrorResponse('file was cleaned or not generated on the server!'))
                    resp.status = falcon.HTTP_404
                    return
                file_name = 'did_upload.log'
                resp.append_header('Content-Disposition', 'attachment; filename="{}"'.format(file_name))
                file = open(file_path, 'rt')
                resp.data = file.read().encode('UTF-8')
                resp.content_type = 'text/txt'
                resp.status = falcon.HTTP_200
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class BlockNumberImportTaskList(DnlList):
    scheme_class = BlockNumberImportTaskScheme
    model_class = model.BlockNumberImportTask
    entity_plural = 'BlockNumberImportTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class ImportExportLogsKill(resources.CustomAction):
    model_class = model.ImportExportLogs
    scheme_class = ImportCreateScheme
    scheme_class_get = ImportGetScheme
    entity = 'Kill executing job'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_params = ()
    method = 'post'
    path_parameters = ({'name': 'id', 'description': 'Import job id to stop'},)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        try:
            if obj:
                if obj.task_uuid:
                    from api_dnl.tasks import app
                    try:
                        i = app.control.inspect()
                        found = False
                        for w in i.active():
                            for t in w:
                                if t['id'] == obj.task_uuid:
                                    found = True
                        if not found:
                            log.info('Import id={} task uuid {} was not active!!!'.format(obj.id, obj.task_uuid))
                    except Exception as e:
                        log.warning('celery workers need -n argument!{}'.format(e))
                    # app.control.revoke(obj.task_uuid,terminate=True)
                    app.control.terminate(obj.task_uuid)
                    log.info('Import id={} task uuid {} was killed'.format(obj.id, obj.task_uuid))
                    obj.task_uuid = None
                    obj.status = 'fail'
                    obj.save()
                    return True
                else:
                    raise ValidationError('Import id={} not running now!'.format(obj.id))
            return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


class ImportExportLogsRerun(resources.CustomAction):
    model_class = model.ImportExportLogs
    scheme_class = ImportCreateScheme
    scheme_class_get = ImportGetScheme
    entity = 'Run import job again'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_params = ()
    method = 'post'
    path_parameters = ({'name': 'id', 'description': 'Import job id to run'},)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        try:
            if obj:
                if obj.task_uuid:
                    raise ValidationError('Import id={} already running now!'.format(obj.id))
                else:
                    obj.status = 'initial'
                    log.info('Import id={} was restarted for execution !'.format(obj.id))
                    return True
            return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


# ---- ImportExportLogs

# ---- InvoiceCdrLog
class InvoiceCdrLogList(DnlList):
    scheme_class = InvoiceCdrLogScheme
    model_class = model.InvoiceCdrLog
    entity_plural = 'InvoiceCdrLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- InvoiceCdrLog


# ---- InvoiceLog
class InvoiceLogList(DnlList):
    scheme_class = InvoiceLogScheme
    model_class = model.InvoiceLog
    entity_plural = 'InvoiceLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


class InvoiceLogSend(resources.CustomPatchAction):
    scheme_class = InvoiceLogScheme
    model_class = model.InvoiceLog
    entity_plural = 'InvoiceLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'id', 'description': 'mark as sent'},)

    def apply(self, obj, req, resp, **kwargs):
        if obj:
            for i in obj.invoices:
                if i.status != 'done':
                    i.status = 'done'
                    i.save()
        else:
            return False
        return True


# ---- InvoiceLog

# ---- IpModifLogLog
class IpModifLogList(DnlList):
    scheme_class = IpModifLogScheme
    model_class = model.IpModifLog
    entity_plural = 'IpModifLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- IpModifLogLog

# ---- ModifLogLog
class ModifLogList(DnlList):
    scheme_class = ModifLogScheme
    model_class = model.ModifLog
    entity_plural = 'ModifLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- ModifLogLog
# ---- LicenseModificationLogLog
class LicenseModificationLogList(DnlList):
    scheme_class = LicenseModificationLogScheme
    model_class = model.LicenseModificationLog
    entity_plural = 'LicenseModificationLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- LicenseModificationLogLog
# ---- OrigLogLog
class OrigLogList(DnlList):
    scheme_class = OrigLogScheme
    model_class = model.OrigLog
    entity_plural = 'OrigLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- OrigLogLog

# region +++RateImportTask+++
class RateImportTaskCreate(DnlCreate):
    scheme_class = RateImportTaskScheme
    model_class = model.RateImportTask
    entity = 'RateImportTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    ext_body_parameters = (
        {'name': 'rate_file', 'in': 'formData', 'description': 'Rate file to upload', 'required': True, 'type': 'file'},
        {'name': 'rate_table_id', 'in': 'formData', 'description': 'Rate table', 'required': False, 'type': 'integer'},
        {'name': 'code_deck_id', 'in': 'formData', 'description': 'code dec table ID, used to get code name',
         'required': False, 'type': 'integer'},
        {'name': 'code_name_provider', 'in': 'formData', 'description': 'code dec table ID, used to get code name',
         'required': False, 'type': 'string',
         'enum': ['get code name from import rate file', 'get code name from code deck table']},
        {'name': 'import_rate_date_format', 'in': 'formData', 'description': '', 'required': False, 'type': 'string',
         'enum': ['MM/DD/YYYY', 'YYYY-MM-DD', 'DD-MM-YYYY', 'DD/MM/YYYY', 'YYYY/MM/DD', 'MM-DD-YYYY']},
        {'name': 'end_date_all_records_time', 'in': 'formData', 'description': '', 'required': False, 'type': 'string'},
        {'name': 'end_date_other_code_time', 'in': 'formData', 'description': '', 'required': False, 'type': 'string'},
        {'name': 'redup_in_rate_table_action', 'in': 'formData',
         'description': 'code dec table ID, used to get code name',
         'required': False, 'type': 'string',
         'enum': ['reject entire import', 'skip the record', 'overwrite existing record']},
        {'name': 'redup_in_file_action', 'in': 'formData', 'description': 'code dec table ID, used to get code name',
         'required': False, 'type': 'string',
         'enum': ['reject entire import', 'skip the record', 'overwrite previous record']},
        {'name': 'auto_ij_rate', 'in': 'formData', 'description': 'substitute IJ rate',
         'required': False, 'type': 'string',
         'enum': ['None', 'Inter Rate', 'Intra Rate', 'Max (Inter, Intra)']},
        {'name': 'rate_upload_template_id', 'in': 'formData', 'description': '', 'required': False, 'type': 'integer'},
        {'name': 'effective_date', 'in': 'formData', 'description': '', 'required': False, 'type': 'string'},
        {'name': 'min_time', 'in': 'formData', 'description': '', 'required': False, 'type': 'integer'},
        {'name': 'interval', 'in': 'formData', 'description': '', 'required': False, 'type': 'integer'},
        {'name': 'min_time_per_prefix', 'in': 'formData', 'description': '', 'required': False, 'type': 'string'},
        {'name': 'interval_per_prefix', 'in': 'formData', 'description': '', 'required': False, 'type': 'string'},
        {'name': 'replace_fields', 'in': 'formData', 'description': '', 'required': False, 'type': 'string'},
        {'name': 'replace_values', 'in': 'formData', 'description': '', 'required': False, 'type': 'string'},
        {'name': 'ignore_fields', 'in': 'formData', 'description': '', 'required': False, 'type': 'string'},
        {'name': 'map_header', 'in': 'formData', 'description': 'rename header field list to acceptable by backend',
         'required': False, 'type': 'string'},
        {'name': 'prefixes', 'in': 'formData', 'description': '', 'required': False, 'type': 'string'},
    )

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = self.ext_body_parameters

        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          self.scheme_class.get_object_created_response(entity=self.entity),
                          # ,scheme=ObjectCreatedWithErrorsScheme),
                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def on_post(self, req, resp, **kwargs):
        log.debug("on_post")
        tpl_id = req.data.pop('rate_upload_template_id', None)
        tpl = model.RateUploadTemplate.filter(model.RateUploadTemplate.id == tpl_id).first()
        if not (tpl_id and tpl):
            return super().on_post(req, resp, **kwargs)
        if tpl.end_date_all_records_time:
            req.data['end_date_all_records_time'] = req.data.get('end_date_all_records_time',
                                                                 str(tpl.end_date_all_records_time))
        if tpl.end_date_other_code_time:
            req.data['end_date_other_code_time'] = req.data.get('end_date_other_code_time',
                                                                str(tpl.end_date_other_code_time))
        if tpl.import_rate_date_format:
            req.data['import_rate_date_format'] = req.data.get('import_rate_date_format',
                                                               tpl.import_rate_date_format.upper())
        for key in ('auto_ij_rate', 'rate_table_id', 'code_deck_id', 'code_name_provider',
                    'redup_in_rate_table_action', 'redup_in_file_action', 'replace_fields',
                    'replace_values', 'ignore_fields', 'map_header'):
            value = req.data.get(key, str(getattr(tpl, key, None)))
            if value and value not in ('null', 'None'):
                req.data[key] = value
        log.debug("return super.on_post()")
        return super().on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):
        log.debug("before create")
        try:
            for f in self.ext_body_parameters:
                fn = f['name']
                if fn in ('rate_file', 'auto_ij_rate'):
                    continue
                try:
                    if fn in self.req_data:
                        setattr(obj, fn, self.req_data[fn])
                    else:
                        if 'required' in f and f['required']:
                            raise ValidationError({fn: 'missing mandatory parameter'})
                except Exception as e:
                    log.debug('rate/import parameter {} error:{}'.format(fn, e))
                    raise ValidationError({fn: str(e)})
            auto_ij_rate = None
            if 'auto_ij_rate' in self.req_data and self.req_data['auto_ij_rate'] != 'None':
                auto_ij_rate = self.req_data['auto_ij_rate']
                if auto_ij_rate not in ['None', 'Inter Rate', 'Intra Rate', 'Max (Inter, Intra)']:
                    raise ValidationError({'auto_ij_rate': 'wrong value'})
            effective_date = None
            if 'effective_date' in self.req_data and self.req_data['effective_date'] != 'None':
                effective_date = self.req_data['effective_date']
            replace_fields = None
            if 'replace_fields' in self.req_data:
                replace_fields = self.req_data['replace_fields'].split(',')
            replace_values = None
            if 'replace_values' in self.req_data and replace_fields:
                replace_values = self.req_data['replace_values'].split(',') if not ', ' in self.req_data['replace_values'] \
                                else self.req_data['replace_values'].split(', ')
            if replace_fields and replace_values and len(replace_fields) != len(replace_values):
                raise ValidationError('Values for replace not match with names!')
            replace = {}
            if replace_fields and replace_values:
                replace = dict(zip(replace_fields, replace_values))
            ignore = []
            if 'ignore_fields' in self.req_data:
                ignore = self.req_data['ignore_fields'].split(',') if not ', ' in self.req_data['ignore_fields'] \
                                else self.req_data['ignore_fields'].split(', ')
            min_time = None
            if 'min_time' in self.req_data and self.req_data['min_time'] != 'None':
                min_time = self.req_data['min_time']
            interval = None
            if 'interval' in self.req_data and self.req_data['interval'] != 'None':
                interval = self.req_data['interval']
            prefixes = []
            min_time_interval_per_prefixes = {}
            if 'prefixes' in self.req_data and self.req_data['prefixes'] != 'None':
                prefixes = self.req_data['prefixes'].split(',')
                min_times = self.req_data.get('min_time_per_prefix', '').split(',')
                intervals = self.req_data.get('interval_per_prefix', '').split(',')
                if len(prefixes) != len(intervals) or len(prefixes) != len(min_times):
                    raise ValidationError(
                        'the number of min_time_per_prefix, interval_per_prefix and prefixes should be same')
                min_time_interval_per_prefixes = {}
                for i in range(len(prefixes)):
                    min_time_interval_per_prefixes[prefixes[i]] = {'min_time': min_times[i], 'interval': intervals[i]}
            map_header = []
            if 'map_header' in self.req_data:
                map_header = self.req_data['map_header'].split(',')
                fields = ('ignore',
                          'effective_date', 'inter_rate', 'rate', 'code_name', 'country',
                          'setup_fee', 'interval', 'intra_rate', 'end_date', 'code',
                          'min_time', 'time_profile_id', 'gmt', 'local_rate')
                err = []
                for f in map_header:
                    if f not in fields:
                        err.append(f)
                if err:
                    raise ValidationError('map_header wrong field names: {} !'.format(','.join(err)))
            if self.get_user(self.req):
                obj.operator_user = self.get_user(self.req).name
            if not obj.operator_user:
                obj.operator_user = 'anonymous'
                rate_table = model.RateTable.get(self.req_data['rate_table_id'])
                if rate_table.update_by:
                    pass
                    # raise ValidationError(
                    #     {'rate_table_id': 'rate_table_id {} not allowed'.format(self.req_data['rate_table_id'])})
            file = self.req.files['rate_file']
            obj.create_time = datetime.now(UTC)
            obj.import_file_path = '{}'.format(settings.FILES['upload_to'])
            obj.orig_rate_file = file.filename
            file_path = obj.import_file_path + '/' + obj.orig_rate_file
            i = 0
            while os.path.exists(file_path):
                obj.orig_rate_file = file.filename.replace('.csv', str(i) + '.csv')
                file_path = obj.import_file_path + '/' + obj.orig_rate_file
                i += 1
            obj.format_rate_file = obj.orig_rate_file.replace('.csv', str(datetime.now(UTC).timestamp()).split('.')[
                0] + '_fmt.csv')
            with open(file_path, 'wb') as local_file:
                file.seek(0)
                shutil.copyfileobj(file, local_file)
            if map_header:
                with open(file_path, 'tr') as local_file:
                    reader = csv.DictReader(local_file)
                    if len(reader.fieldnames) != len(map_header):
                        raise ValidationError(
                            'map_header should contain same count of fields as in file (currently {})'.format(
                                len(reader.fieldnames)))
            if True or auto_ij_rate or effective_date or replace or ignore or map_header or interval or min_time:
                obj.status = 'API Processing'
                obj_id = obj.save()
                from api_dnl.tasks import do_rate_import_preprocess
                from kombu.exceptions import OperationalError
                try:
                    do_rate_import_preprocess.delay(obj_id, auto_ij_rate, replace, ignore, map_header, interval,
                                                    min_time, self.req_data, min_time_interval_per_prefixes)
                except OperationalError as e:
                    log.warning('celery backend stopped:run preprocess online')
                    do_rate_import_preprocess(obj_id, auto_ij_rate, replace, ignore, map_header, interval, min_time,
                                              self.req_data, min_time_interval_per_prefixes)
                    # raise ValidationError('cannot preprocess rate file: celery backend stopped')
                    # do_rate_import_preprocess(obj_id, auto_ij_rate, self.req_data)
            else:
                format_file_path = obj.import_file_path + '/' + obj.format_rate_file
                with open(format_file_path, 'wb') as local_file:
                    file.seek(0)
                    shutil.copyfileobj(file, local_file)
                obj.status = 'Initial'
            return obj
        except Exception as e:
            obj.status = 'API Failed'
            msg = 'RateImportTaskCreate error:{}'.format(e)
            log.error(msg)
            raise ValidationError(msg)


class RateImportTaskCreatePublic(RateImportTaskCreate):
    no_auth_needed = True


class RateImportTaskResource(DnlResource):
    model_class = model.RateImportTask
    scheme_class = RateImportTaskScheme
    scheme_class_get = RateImportTaskSchemeGet
    scheme_class_modify = RateImportTaskSchemeModify
    entity = 'RateImportTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_modify_operation = False


class RateImportTaskList(DnlList):
    scheme_class = RateImportTaskSchemeGet
    model_class = model.RateImportTask
    entity_plural = 'RateImportTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
        # ret = ret.filter(cls.user_id == user.user_id)#TODO:filter for user
        return filt, ret


class RateImportTaskDownloadOrig(DnlResource):
    model_class = model.RateImportTask
    scheme_class = RateImportTaskScheme
    scheme_class_get = RateImportTaskSchemeGet
    scheme_class_modify = RateImportTaskScheme
    entity = 'RateImportTask download orig file'
    id_field = 'id'
    # security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = True
    has_delete_operation = False
    has_modify_operation = False
    no_auth_needed = True

    def get_spec_info(self):
        spec = super(RateImportTaskDownloadOrig, self).get_spec_info()
        spec['get']['produces'] = ['text/csv']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')

        if (not hasattr(self, 'no_auth_needed') or self.no_auth_needed == False) \
                and not check_permission(self, req, 'show', self.get_object(resp, self.model_class, **kwargs)):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj:
                if obj.orig_rate_file:
                    file_name = obj.import_file_path + '/' + obj.orig_rate_file
                else:
                    file_name = None
                if file_name:
                    if os.path.isfile(file_name):
                        resp.data = obj.file_data
                        resp.content_type = mimetypes.guess_type(file_name)[0]
                        try:
                            obj.orig_rate_file.encode('ascii')
                            resp.append_header('Content-Disposition',
                                               'attachment; filename="{}"'.format(obj.orig_rate_file))
                        except UnicodeEncodeError:
                            resp.append_header('Content-Disposition',
                                               "attachment; filename*=utf-8''{}".format(quote(obj.orig_rate_file)))
                        resp.status = falcon.HTTP_200
                        return
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return

        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class RateImportTaskDownloadFormat(DnlResource):
    model_class = model.RateImportTask
    scheme_class = RateImportTaskScheme
    scheme_class_get = RateImportTaskSchemeGet
    scheme_class_modify = RateImportTaskScheme
    entity = 'RateImportTask download processed file'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = True
    has_delete_operation = False
    has_modify_operation = False
    no_auth_needed = True

    def get_spec_info(self):
        spec = super(RateImportTaskDownloadFormat, self).get_spec_info()
        spec['get']['produces'] = ['text/csv']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')

        if (not hasattr(self, 'no_auth_needed') or self.no_auth_needed == False) \
                and not check_permission(self, req, 'show', self.get_object(resp, self.model_class, **kwargs)):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj:
                if obj.format_rate_file:
                    file_name = obj.import_file_path + '/' + obj.format_rate_file
                else:
                    file_name = None
                if file_name:
                    if os.path.isfile(file_name):
                        resp.data = obj.file_data
                        resp.content_type = mimetypes.guess_type(file_name)[0]
                        try:
                            obj.format_rate_file.encode('ascii')
                            resp.append_header('Content-Disposition',
                                               'attachment; filename="{}"'.format(obj.format_rate_file))
                        except UnicodeEncodeError:
                            resp.append_header('Content-Disposition',
                                               "attachment; filename*=utf-8''{}".format(quote(obj.format_rate_file)))
                        resp.status = falcon.HTTP_200
                        return
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return

        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class RateImportTaskDownloadError(DnlResource):
    model_class = model.RateImportTask
    scheme_class = RateImportTaskScheme
    scheme_class_get = RateImportTaskSchemeGet
    scheme_class_modify = RateImportTaskScheme
    entity = 'RateImportTask download error file'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = True
    has_delete_operation = False
    has_modify_operation = False
    no_auth_needed = True

    def get_spec_info(self):
        spec = super(RateImportTaskDownloadError, self).get_spec_info()
        spec['get']['produces'] = ['text/plain']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')

        if (not hasattr(self, 'no_auth_needed') or self.no_auth_needed == False) \
                and not check_permission(self, req, 'show', self.get_object(resp, self.model_class, **kwargs)):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj and obj.import_log_path:
                file_name = obj.error_file_name
                if os.path.isfile(file_name):
                    resp.data = obj.error_file_data
                else:
                    resp.data = str.encode(obj.progress)
                resp.content_type = 'text/plain'  # mimetypes.guess_type(file_name)[0]
                resp.append_header('Content-Disposition', 'attachment; filename="{}"'.format('rate_import.log'))
                resp.status = falcon.HTTP_200
                return
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


# endregion ---RateImportTask---
# ---- Rate Analysis Summary
class RateAnalysisSummaryResource(DnlResource):
    model_class = model.RateImportTask
    scheme_class = RateImportTaskScheme
    entity = 'Rate Analysis Summary'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = True
    has_delete_operation = False
    has_modify_operation = False

    def get_spec(self):
        spec = swagger.specify.get_spec(
            method='get',
            description='Get rate analysis summary by rate table',
            path_parameters=[
                {'name': 'rate_table_id', 'in': 'path', 'required': True, 'type': 'integer', 
                 'description': 'Rate table ID to analyze'},
            ],
            responses=(
                responses.SuccessResponse(scheme=self.scheme_class, description='Rate analysis summary'),
            ) + self.get_additional_responses(method='get'),
            query_parameters=[
                {'name': 'target_rate', 'in': 'query', 'required': True, 'type': 'float',
                 'description': 'Target rate to analyze'}
            ],
            security=self.get_security(method='get')
        )
        return spec

    def on_get(self, req, resp, **kwargs):
        try:
            rate_table_id = kwargs.get('rate_table_id')
            target_rate = req.get_param_as_float('target_rate')
            if not rate_table_id:
                self.set_response(resp, responses.BadRequestErrorResponse('Rate table ID is required'))
                return

            target_rates = model.Rate.filter(model.Rate.rate_table_id == rate_table_id).all()

            vendor_summaries = {}
            for rate in target_rates:
                vendor = model.Client.get(rate.client_id)

                if vendor.name not in vendor_summaries:
                    vendor_summaries[vendor.name] = {
                        "Inter Rate": 0,
                        "Intra Rate": 0,
                        "IJ Rate": 0
                    }

                if rate.rate < target_rate:
                    if rate.rate_type == 'Inter':
                        vendor_summaries[vendor.name]["Inter Rate"] += 1
                    elif rate.rate_type == 'Intra':
                        vendor_summaries[vendor.name]["Intra Rate"] += 1
                    elif rate.rate_type == 'IJ':
                        vendor_summaries[vendor.name]["IJ Rate"] += 1

            resp.media = vendor_summaries
            resp.status = falcon.HTTP_200

        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))

# ---- Rate Analysis LCR
class RateAnalysisLCR(DnlResource):
    model_class = model.RateImportTask
    scheme_class = RateImportTaskScheme
    entity = 'Rate Analysis LCR'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = True
    has_delete_operation = False
    has_modify_operation = False

    def get_spec(self):
        spec = swagger.specify.get_spec(
            method='get',
            description='Get rate analysis summary by rate table',
            path_parameters=[
                {'name': 'code', 'in': 'path', 'required': True, 'type': 'string',
                 'description': 'Code'},
            ],
            responses=(
                responses.SuccessResponse(scheme=self.scheme_class, description='Rate analysis summary'),
            ) + self.get_additional_responses(method='get'),
            # query_parameters=[
            #     {'name': 'target_rate', 'in': 'query', 'required': True, 'type': 'float',
            #      'description': 'Target rate to analyze'}
            # ],
            security=self.get_security(method='get')
        )
        return spec

    def on_get(self, req, resp, **kwargs):
        try:
            code = kwargs.get('code')
            rate = model.Rate.filter(model.Rate.code == code).first()
            rate_table_id = rate.rate_table_id if rate else None
            if rate_table_id is None:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse('Rate table ID not found'))
                return

            lcr_task = model.LcrTask.filter(model.LcrTask.target_rate_table_id == rate_table_id).first()
            lcr_rate_table_id = lcr_task.lcr_rate_table_id if lcr_task else []
            effective_date = lcr_task.effective_date if lcr_task else None
            if not lcr_rate_table_id or not effective_date:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse('LCR Rate table ID not found'))
                return
            effective_date = effective_date.replace('/', '-')
            
            api = get_dnl_active_calls_session('127.0.0.1', '4320')
            sw_data = api.get_rate_sorting(effective_date=effective_date, code=code, rate_tables=lcr_rate_table_id)
            
            data = {'result': sw_data}

            self.set_response(
            resp, responses.SuccessResponseObjectInfo(data=data,
                                                      payload_scheme=VoipGatewayRateSortingScheme))
            return

        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))

# ---- RateAnalysisTask
class RateAnalysisTaskCreate(DnlCreate):
    scheme_class = RateAnalysisTaskScheme
    model_class = model.RateAnalysisTask
    entity = 'RateAnalysisTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    ext_body_parameters = (
        {'name': 'source_rate_table_id', 'in': 'formData', 'description': 'Source rate table ID', 'required': True, 'type': 'integer'},
        {'name': 'effective_date', 'in': 'formData', 'description': 'Effective date', 'required': True, 'type': 'string'},
        {'name': 'new_rate_table_id', 'in': 'formData', 'description': 'Target rate table ID', 'required': False, 'type': 'integer'},
        {'name': 'new_effective_date', 'in': 'formData', 'description': 'New effective date', 'required': False, 'type': 'string'},
        {'name': 'rate_generation_history_id', 'in': 'formData', 'description': 'Rate generation history ID', 'required': False, 'type': 'integer'},
        {'name': 'rate_file', 'in': 'formData', 'description': 'Rate file to analyze', 'required': False, 'type': 'file'},
    )

    def get_spec(self):
        additional_responses = (
            responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                          description='Cannot create analysis task'),
        ) + self.additional_responses

        return swagger.specify.get_spec(
            method='post',
            description='Creates new rate analysis task',
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                self.scheme_class.get_object_created_response(entity=self.entity),
            ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            ext_body_parameters=self.ext_body_parameters
        )

    def on_post(self, req, resp, **kwargs):
        from api_dnl.tasks import do_rate_analysis
        obj = super().on_post(req, resp, **kwargs)
        do_rate_analysis.delay(obj)
        return obj


class RateAnalysisTaskResource(DnlResource):
    model_class = model.RateAnalysisTask
    scheme_class = RateAnalysisTaskScheme
    scheme_class_get = RateAnalysisTaskSchemeGet
    entity = 'RateAnalysisTask'
    id_field = 'task_id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = True
    has_delete_operation = False
    has_modify_operation = False

    def get_spec_info(self):
        spec = super(RateAnalysisTaskResource, self).get_spec_info()
        spec['get']['produces'] = ['application/json']
        return spec

    # def on_get(self, req, resp, **kwargs):
    #     if not self.has_info_operation:
    #         return self.method_not_allowed_response(resp, 'GET')

    #     try:
    #         obj = self.get_object(resp, self.model_class, **kwargs)
    #         if obj and obj.result_file:
    #             result = {
    #                 'increase_count': obj.increases,
    #                 'decrease_count': obj.decreases,
    #                 'no_change_count': obj.no_changes,
    #                 'new_count': obj.new_rates,
    #                 'delete_count': obj.deleted_rates
    #             }
    #             resp.media = result
    #             resp.status = falcon.HTTP_200
    #             return
    #         self.set_response(resp, responses.ObjectNotFoundErrorResponse())
    #     except Exception as e:
    #         self.set_response(resp, OperationErrorResponse(e))



class LcrTaskResource(DnlResource):
    model_class = model.LcrTask
    scheme_class = LcrTaskScheme
    scheme_class_get = LcrTaskSchemeGet
    entity = 'LcrTask'
    id_field = 'task_id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = True
    has_delete_operation = False
    has_modify_operation = False

    def get_spec_info(self):
        spec = super(LcrTaskResource, self).get_spec_info()
        spec['get']['produces'] = ['application/json', 'text/csv']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:
            return self.method_not_allowed_response(resp, 'GET')

        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj:
                if obj.result_path and req.params.get('download') == 'true':
                    # Return CSV file
                    try:
                        with open(obj.result_path, 'rb') as f:
                            resp.content_type = 'text/csv'
                            resp.body = f.read()
                            resp.status = falcon.HTTP_200
                            return
                    except:
                        self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                        return

                # Return task info
                resp.media = self.scheme_class_get().dump(obj).data
                resp.status = falcon.HTTP_200
                return

            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class LcrTaskCreate(DnlCreate):
    model_class = model.LcrTask
    scheme_class = LcrTaskCreateScheme
    scheme_class_get = LcrTaskScheme
    entity = 'LcrTask'
    id_field = 'task_id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec(self):
        additional_responses = (
            responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                          description='Cannot create LCR task'),
        ) + self.additional_responses

        return swagger.specify.get_spec(
            method='post',
            description='Creates new LCR task',
            consumes=['application/json'],
            path_parameters=self.path_parameters,
            responses=(
                self.scheme_class.get_object_created_response(entity=self.entity),
            ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            body_parameters=('{} to create'.format(self.entity), self.scheme_class)
        )

    def after_create(self, object_id, req, resp, **kwargs):
        try:
            from api_dnl.tasks import do_lcr_task
            ret = do_lcr_task.delay(object_id)
            log.info('do_lcr_task scheduled {} {}'.format(object_id, ret.id))
        except Exception as e:
            log.error('cannot schedule do_lcr_task {}: {}'.format(object_id, str(e)))

class LcrTaskList(DnlList):
    model_class = model.LcrTask
    scheme_class = LcrTaskScheme
    entity_plural = 'LcrTasks'
    id_field = 'task_id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    additional_responses = ()

# ---- RateUploadTaskLog
class RateUploadTaskCreate(DnlCreate):
    model_class = model.RateUploadTask
    scheme_class = RateUploadTaskUploadScheme
    scheme_class_get = RateUploadTaskScheme
    entity = 'RateUploadTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_params = ()

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = self.body_params or (
            {
                'name': 'rate_file',
                'in': 'formData',
                'description': 'Rate file to upload',
                'required': True,
                'type': 'file'
            },
            # {'name': 'format_file', 'in': 'formData', 'description': 'Format file to upload', 'required': True, 'type': 'file'},
            # {'name': 'date_format', 'in': 'formData', 'description': 'Date format in imported file', 'required': True, 'type': 'string',
            #    'enum':tuple(self.model_class.DATE_FORMAT.values())},
            # {'name': 'method', 'in': 'formData', 'description': 'How to pass duplicates', 'required': True, 'type': 'string',
            #    'enum': tuple(self.model_class.REDUPLICATE_RATE_ACTION.values())},
            # {'name': 'rate_table_id', 'in': 'formData', 'description': 'Id of Rate table import to', 'required': True, 'type': 'integer',},
            # {'name': 'code_deck_flag', 'in': 'formData', 'description': 'how to process code deck', 'required': False, 'type': 'string',
            #    'enum':tuple(self.model_class.CODE_DECK_FLAG.values())},
            # {'name': 'use_ocn_lata_code', 'in': 'formData', 'description': 'How to use lata code', 'required': False, 'type': 'string',
            #    'enum':tuple(self.model_class.USE_OCN_LATA_CODE.values())},
        )

        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          self.scheme_class.get_object_created_response(entity=self.entity),
                          # ,scheme=ObjectCreatedWithErrorsScheme),
                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    # def _log(self, msg, item=None, e=None):
    #     if not self.local_file_err:
    #         self.local_file_err = open(self.error_file_path, 'wt')
    #     if item:
    #         self.local_file_err.write(json.dumps(item) + '\n')
    #     self.local_file_err.write(str(msg))
    #     if e:
    #         try:
    #             self.local_file_err.write(str(e) + '\n')
    #         except Exception as e1:
    #             self.local_file_err.write('cannot save exception' + '\n')
    #             pass

    def before_create(self, obj, **kwargs):
        try:
            obj.operator_user = self.get_user().name
            file = self.req.files['rate_file']
            obj.upload_orig_file = file.filename
            uuid = generate_uuid_str()()
            obj.create_time = int(datetime.now(UTC).timestamp())
            obj.upload_file_path = '{}/rate_upload_{}.{}'.format(settings.FILES['upload_to'], uuid,
                                                                 file.filename.split('.')[-1])
            file_path = obj.upload_file_path
            with open(file_path, 'wb') as local_file:
                file.seek(0)
                shutil.copyfileobj(file, local_file)
            obj.status = 'error'
            obj.progress = 'waiting for convert'
            obj.pre_status = 'uploaded'
            return obj

            obj.rate_table_id = self.req_data['rate_table_id']
            _valid('RateTable', 'rate_table_id' , obj.rate_table_id)
            if 'code_deck_flag' in self.req_data:
                value = self.req_data['code_deck_flag']
                enum = tuple(self.model_class.CODE_DECK_FLAG.values())
                if not value in enum:
                    raise ValidationError('code_deck_flag "{}" invalid, must be in {}'.format(value, enum))
                obj.code_deck_flag = value
            if 'use_ocn_lata_code' in self.req_data:
                value = self.req_data['use_ocn_lata_code']
                enum = tuple(self.model_class.USE_OCN_LATA_CODE.values())
                if not value in enum:
                    raise ValidationError('use_ocn_lata_code "{}" invalid, must be in {}'.format(value, enum))
                obj.use_ocn_lata_code = value

            if 'date_format' in self.req_data:
                value = self.req_data['date_format']
                enum = tuple(self.model_class.DATE_FORMAT.values())
                if not value in enum:
                    raise ValidationError('date_format "{}" invalid, must be in {}'.format(value, enum))
                obj.rate_date_format = value

            if 'method' in self.req_data:
                value = self.req_data['method']
                enum = tuple(self.model_class.REDUPLICATE_RATE_ACTION.values())
                if not value in enum:
                    raise ValidationError('method "{}",invalid must be in {}'.format(value, enum))
                obj.reduplicate_rate_action = value

            obj.upload_file_path = settings.FILES['upload_to']
            uuid = generate_uuid_str()()
            obj.create_time = int(datetime.now(UTC).timestamp())
            file = self.req.files['rate_file']
            obj.upload_orig_file = 'rate_upload_' + uuid + '.' + file.filename.split('.')[-1]
            file_path = obj.upload_file_path + '/' + obj.upload_orig_file
            with open(file_path, 'wb') as local_file:
                file.seek(0)
                shutil.copyfileobj(file, local_file)
            file = self.req.files['format_file']
            obj.upload_format_file = 'rate_format_' + uuid + '.' + file.filename.split('.')[-1]
            file_path = obj.upload_file_path + '/' + obj.upload_format_file
            with open(file_path, 'wb') as local_file:
                file.seek(0)
                shutil.copyfileobj(file, local_file)
            file.seek(0)
            self.default_info = file.read().encode()
            q = self.info
        except Exception as e:
            obj.status = 'error'
            msg = 'RateUploadTaskCreate error:{}'.format(e)
            log.error(msg)
            raise ValidationError(msg)
            pass
        obj.status = 'preprocess'
        return obj

    def after_create(self, object_id, req, resp, **kwargs):

        try:
            from api_dnl.task.upload_rate import upload_rate
            ret = upload_rate.delay(object_id)
            log.info('upload_rate task scheduled {} {}'.format(object_id, ret.id))
            obj = model.RateUploadTask.get(object_id)
            obj.task_id = ret.id
            obj.save()
        except Exception as e:
            log.error('cannot shedule upload_rate {}'.format(object_id))


"""
class RateUploadTaskCreate(DnlCreate):
    scheme_class = RateUploadTaskScheme
    entity = 'RateUploadTask rules'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        return obj
"""


class RateUploadTaskResource(DnlResource):
    model_class = model.RateUploadTask
    scheme_class = RateUploadTaskScheme
    scheme_class_get = RateUploadTaskGetScheme
    scheme_class_modify = RateUploadTaskScheme
    entity = 'RateUploadTask'
    id_field = 'id'
    has_update_by = True
    unique_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        if not obj.pre_status in ['uploaded', 'error', 'converted', 'preprocess']:
            raise ValidationError('File already processed! status:{}'.format(obj.pre_status))
        user = self.get_user(req)
        rate_table_id = self.req_data['rate_table_id']
        if user.user_type == 'client':
            if not rate_table_id in [r.rate_table_id for r in user.client.resources]:
                raise ValidationError('Rate table {} not belongs any of client trunks'.format(rate_table_id))
        # if obj.info == {}:
        #    raise ValidationError('info must contain fields mapping!')
        # if obj.start_from:
        #    obj.info['start_from']=obj.start_from
        obj.pre_status = 'preprocess'
        return obj


class RateUploadTaskApproveResource(RateUploadTaskResource):
    scheme_class_modify = RateUploadTaskApproveScheme
    has_delete_operation = False
    has_info_operation = False

    def before_update(self, obj, req):
        if not obj.pre_status == 'converted':
            raise ValidationError('Cannot yet approve this task! It is not converted!')
        if not obj.status in ['error', 'finished']:
            raise ValidationError('Cannot approve this task! It is processed now!')
        obj.status = 'initial'
        return obj


class RateUploadTaskGetHeader(RateUploadTaskResource):
    model_class = model.RateUploadTask
    scheme_class_modify = RateUploadTaskApproveScheme
    scheme_class_get = RateUploadTaskGetHeadersScheme
    has_delete_operation = False
    has_modify_operation = False
    has_info_operation = True
    path_parameters = ({'name': 'id', 'description': 'Rate upload id to get info'},
                       {'name': 'start_from', 'description': 'starting row to lookup'},)

    def on_get(self, req, resp, **kwargs):
        from .task.upload_rate import MyReader
        obj = self.model_class.get(kwargs['id'])
        if obj:
            try:
                fmt = obj.upload_orig_file.split('.')[-1]
                row = int(kwargs['start_from'])
                if fmt in ['csv', 'xls', 'xlsx']:
                    file = obj.upload_file_path + '/' + obj.upload_orig_file
                    reader = MyReader(file, start_from=row)  # csv.DictReader(file,delimiter=',')
                    fieldnames = reader.fieldnames
                    key_found = 0
                    self.set_response(resp,
                                      responses.SuccessResponseObjectInfo(payload_scheme=self.scheme_class_get,
                                                                          data=dict(fields=fieldnames, start_from=row)))
            except Exception as e:
                self.set_response(resp, OperationErrorResponse(e))
        else:
            self.set_response(responses.ObjectNotFoundErrorResponse())
        return


class RateAutoImportRuleCreate(DnlCreate):
    model_class = model.RateAutoImportRule
    scheme_class = RateAutoImportRuleScheme
    entity = 'RateAutoImportRule'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.create_by = self.get_user().name
        obj.update_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        obj.update_on = datetime.now(UTC)
        return obj


class RateAutoImportRuleResource(DnlResource):
    model_class = model.RateAutoImportRule
    scheme_class = RateAutoImportRuleScheme
    scheme_class_get = RateAutoImportRuleGetScheme
    entity = 'RateAutoImportRule'
    id_field = 'id'
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_on = datetime.now(UTC)
        return obj


class RateAutoImportRuleList(DnlList):
    model_class = model.RateAutoImportRule
    scheme_class = RateAutoImportRuleGetScheme
    entity_plural = 'RateAutoImportRules'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class RateAutoImportRuleLogList(DnlList):
    model_class = model.RateAutoImportRuleLog
    scheme_class = RateAutoImportRuleLogGetScheme
    entity_plural = 'RateAutoImportRuleLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class RateUploadTaskDownloadOrig(DnlResource):
    file_name = 'upload_orig_file'
    model_class = model.RateUploadTask
    scheme_class = RateUploadTaskScheme
    scheme_class_get = RateUploadTaskGetScheme
    scheme_class_modify = RateUploadTaskScheme
    entity = 'RateUploadTask download orig file'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = True
    has_delete_operation = False
    has_modify_operation = False

    def get_spec_info(self):
        spec = super(RateUploadTaskDownloadOrig, self).get_spec_info()
        spec['get']['produces'] = ['text/csv', 'application/vnd.ms-excel', 'application/octet-stream']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')

        if not check_permission(self, req, 'show', self.get_object(resp, self.model_class, **kwargs)):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj:
                file_name = getattr(obj, self.file_name, None)
                if file_name:
                    file_path = obj.upload_file_path + '/' + file_name
                    if os.path.isfile(file_path):
                        file = open(file_path, 'rb')
                        resp.data = file.read()

                        resp.content_type = mimetypes.guess_type(file_name)[0]
                        resp.append_header('Content-Disposition', 'attachment; filename="{}"'.format(file_name))
                        resp.status = falcon.HTTP_200
                        return
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return

        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class RateUploadTaskDownloadError(DnlResource):
    file_name = 'result_file_path'
    model_class = model.RateUploadTask
    scheme_class = RateUploadTaskScheme
    scheme_class_get = RateUploadTaskGetScheme
    scheme_class_modify = RateUploadTaskScheme
    entity = 'RateUploadTask download error file'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()
    has_info_operation = True
    has_delete_operation = False
    has_modify_operation = False

    def get_spec_info(self):
        spec = super(RateUploadTaskDownloadError, self).get_spec_info()
        spec['get']['produces'] = ['text/plain']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')

        if not check_permission(self, req, 'show', self.get_object(resp, self.model_class, **kwargs)):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj and obj.result_file_path:
                file_name = 'rate_import.log'
                file_path = obj.result_file_path + '/' + file_name
                if os.path.isfile(file_path):
                    file = open(file_path, 'rb')
                    resp.data = file.read()
                    resp.content_type = 'text/plain'  # mimetypes.guess_type(file_name)[0]
                    resp.append_header('Content-Disposition', 'attachment; filename="{}"'.format(file_name))
                    resp.status = falcon.HTTP_200
                    return

            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class RateUploadTaskDownloadFormat(RateUploadTaskDownloadOrig):
    file_name = 'upload_format_file'
    entity = 'RateUploadTask download format file'


class RateUploadTaskList(DnlList):
    scheme_class = RateUploadTaskGetScheme
    model_class = model.RateUploadTask
    entity_plural = 'RateUploadTask'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def __modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        if ordering['by'] == 'start_date_time':
            if ordering['dir'] == 'desc':
                query = query.order_by(self.model_class.start_time.desc())
            else:
                query = query.order_by(self.model_class.start_time.asc())
            ordering = {}
        if ordering['by'] == 'create_date_time':
            if ordering['dir'] == 'desc':
                query = query.order_by(self.model_class.create_time.desc())
            else:
                query = query.order_by(self.model_class.create_time.asc())
            ordering = {}
        # return {},query
        return super(RateUploadTaskList, self).modify_query_from_ordering_for_list(ordering, query, **kwargs)

    def __modify_query_from_filtering_for_list(self, filtering, **kwargs):
        if 'start_date_time_gt' in filtering:
            filtering['start_time_gt'] = int(parse_datetime(filtering['start_date_time_gt']).timestamp())
            del filtering['start_date_time_gt']
        if 'start_date_time_lt' in filtering:
            filtering['start_time_lt'] = int(parse_datetime(filtering['start_date_time_lt']).timestamp())
            del filtering['start_date_time_lt']
        if 'create_date_time_gt' in filtering:
            filtering['create_time_gt'] = int(parse_datetime(filtering['create_date_time_gt']).timestamp())
            del filtering['create_date_time_gt']
        if 'create_date_time_lt' in filtering:
            filtering['create_time_lt'] = int(parse_datetime(filtering['create_date_time_lt']).timestamp())
            del filtering['create_date_time_lt']
        ret, query = super(RateUploadTaskList, self).modify_query_from_filtering_for_list(filtering, **kwargs)

        return ret, query


class RateUploadValuesList(DnlList):
    scheme_class = RateUploadValuesGetScheme
    model_class = model.RateUploadValues
    entity_plural = 'RateUploadValues'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'id', 'description': 'Upload task id'},)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(RateUploadValuesList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['task_id'] = kwargs['id']
        return ret


# ---- RateUploadTaskLog


# ---- RateUploadTemplate
class RateUploadTemplateCreate(DnlCreate):
    scheme_class = RateUploadTemplateScheme
    entity = 'RateUploadTemplate'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.create_by = self.get_user().name
        obj.update_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        obj.update_on = datetime.now(UTC)
        return obj


class RateUploadTemplateResource(DnlResource):
    model_class = model.RateUploadTemplate
    scheme_class = RateUploadTemplateScheme
    scheme_class_get = RateUploadTemplateSchemeGet
    scheme_class_modify = RateUploadTemplateSchemeModify
    entity = 'RateUploadTemplate'
    id_field = 'id'
    has_update_by = True
    unique_field = 'rule_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_on = datetime.now(UTC)
        if 'name' in req.data and req.data['name'] != obj.name:
            _valid_unique('RateUploadTemplate', 'name', req.data['name'])
        return obj


class RateUploadTemplateList(DnlList):
    scheme_class = RateUploadTemplateSchemeGet

    model_class = model.RateUploadTemplate
    entity_plural = 'RateUploadTemplate'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(RateUploadTemplateList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # user = self.get_user(self.req)
        # if user and user.client:
        #     q.filter() # filter for client
        return filt, q


# ---- RateUploadTemplateLog 


# ---- RateDownloadLogLog
class RateDownloadLogList(DnlList):
    scheme_class = RateDownloadLogScheme
    model_class = model.RateDownloadLog
    entity_plural = 'RateDownloadLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- RateDownloadLogLog
# #---- RateMassEditLogLog
class RateMassEditLogList(DnlList):
    scheme_class = RateMassEditLogScheme
    model_class = model.RateMassEditLog
    entity_plural = 'RateMassEditLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- RateMassEditLogLog
# ---- RetrievePasswordLogLog
class RetrievePasswordLogList(DnlList):
    scheme_class = RetrievePasswordLogScheme
    model_class = model.RetrievePasswordLog
    entity_plural = 'RetrievePasswordLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- RetrievePasswordLogLog
# ---- ScheduledReportLogLog
class ScheduledReportLogList(DnlList):
    scheme_class = ScheduledReportLogScheme
    model_class = model.ScheduledReportLog
    entity_plural = 'ScheduledReportLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- ScheduledReportLogLog
# ---- ScheduledLogLog
class SchedulerLogList(DnlList):
    scheme_class = SchedulerLogScheme
    model_class = model.SchedulerLog
    entity_plural = 'SchedulerLog'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- SchedulerLogLog

# ---- SipRegistration
class SipRegistrationList(DnlList):
    scheme_class = SipRegistrationScheme
    model_class = model.SipRegistration
    entity_plural = 'SipRegistration'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def on_filter_is_spam(self, q, val, kwargs):
        cls = self.model_class
        clsip = aliased(model.ResourceIp)
        if val == 'true':
            return q.outerjoin(clsip, clsip.username == cls.username).filter(clsip.resource_ip_id.is_(None))
        if val == 'false':
            return q.outerjoin(clsip, clsip.username == cls.username).filter(clsip.resource_ip_id.isnot(None))
        return q

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        if 'uptime_gt' in filtering:
            filtering['uptime_gt'] = int(parse_datetime(filtering['uptime_gt']).timestamp())
        if 'uptime_lt' in filtering:
            filtering['uptime_lt'] = int(parse_datetime(filtering['uptime_lt']).timestamp())
        ret, query = super(SipRegistrationList, self).modify_query_from_filtering_for_list(filtering, **kwargs)

        return ret, query


class SipRegistrationActiveList(DnlList):
    scheme_class = SipRegistrationScheme
    model_class = model.SipRegistration
    entity_plural = 'SipRegistrationsActive'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(SipRegistrationActiveList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        m = self.model_class
        if filtering:
            for k, v in filtering.items():
                if '*' in v:  # pragma: no cover
                    q = q.filter(getattr(m, k).like(v.replace('*', '%')))
                else:
                    q = q.filter(getattr(m, k) == v)
        q = q.filter(m.id.in_(q.session.query(func.max(m.id)).filter(q.whereclause).group_by(m.username)))
        return ret, q


# ---- SipRegistration

class ClientCdrActiveList(DnlList):
    scheme_class = ClientCdrGetScheme
    model_class = model.ClientCdr
    entity_plural = 'ClientCdr'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret, q = super(ClientCdrActiveList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        # q = q.filter(m.id.in_( m.query().session.query(func.max(m.id)).group_by(m.username).all() ) )
        # m=self.model_class
        return ret, q


# ---- SipRegistration

# ---- InvoiceEmail
class InvoiceEmailList(DnlList):
    scheme_class = InvoiceEmailScheme
    model_class = model.InvoiceEmail
    entity_plural = 'InvoiceEmail'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ()


# ---- InvoiceEmail

# +++ CarrierTemplate

class CarrierTemplateCreate(DnlCreate):
    scheme_class = CarrierTemplateScheme
    entity = 'CarrierTemplate'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.create_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        obj.update_on = obj.create_on
        # if not obj.allowed_credit:
        #    obj.allowed_credit=0.0
        return obj


class CarrierTemplateFromClientCreate(DnlCreate):
    scheme_class = CarrierTemplateFromClientScheme
    entity = 'CarrierTemplate'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'client_id', 'description': 'Parent carrier'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        client = model.Client.get(kwargs['client_id'])
        obj.update_by = self.get_user().name
        obj.create_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        obj.update_on = obj.create_on
        obj.template_from_client(client)
        return obj

    def create_object(self, req, scheme, **kwargs):
        data = resources.BaseResource.create_object(self, req, scheme, **kwargs)
        # client = model.Client.get(kwargs['client_id'])
        # client.template_id=data
        # client.save()
        return data


class CarrierTemplateResource(DnlResource):
    model_class = model.CarrierTemplate
    scheme_class = CarrierTemplateScheme
    scheme_class_get = CarrierTemplateGetScheme
    scheme_class_modify = CarrierTemplateModifyScheme
    entity = 'CarrierTemplate'
    id_field = 'id'
    has_update_by = True
    unique_field = 'template_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_on = datetime.now(UTC)
        if req.data['template_name'] != obj.template_name:
            _valid_unique('CarrierTemplate', 'template_name', req.data['template_name'])
        return obj


class CarrierTemplateList(DnlList):
    scheme_class = CarrierTemplateGetScheme
    model_class = model.CarrierTemplate
    entity_plural = 'CarrierTemplates'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# --- CarrierTemplate


# +++ EgressTrunkTemplate

class EgressTrunkTemplateCreate(DnlCreate):
    scheme_class = EgressTrunkTemplateScheme
    entity = 'EgressTrunkTemplate'
    unique_field = 'resource_template_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.create_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        obj.update_on = datetime.now(UTC)
        obj.direction = 'egress'

        return obj


class EgressTrunkTemplateFromResourceCreate(DnlCreate):
    scheme_class = EgressTrunkTemplateFromResourceScheme
    entity = 'EgressTrunkTemplate'
    unique_field = 'resource_template_id'
    additional_responses = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'Trunk to create template'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.create_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        obj.update_on = datetime.now(UTC)
        obj.direction = 'egress'
        obj.create_from_resource(self.req_data['name'], kwargs['trunk_id'])
        return obj


class IngressTrunkTemplateFromResourceCreate(DnlCreate):
    scheme_class = IngressTrunkTemplateFromResourceScheme
    entity = 'IngressTrunkTemplate'
    unique_field = 'resource_template_id'
    additional_responses = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'Trunk to create template'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.create_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        obj.update_on = datetime.now(UTC)
        obj.direction = 'ingress'
        if not 'name' in self.req_data:
            raise ValidationError('Missing "name" for template!')
        obj.create_from_resource(self.req_data['name'], kwargs['trunk_id'])

        return obj


class EgressTrunkTemplateResource(DnlResource):
    model_class = model.EgressTrunkTemplate
    scheme_class = EgressTrunkTemplateScheme
    scheme_class_get = EgressTrunkTemplateGetScheme
    scheme_class_modify = EgressTrunkTemplateModifyScheme
    entity = 'EgressTrunkTemplate'
    id_field = 'resource_template_id'
    has_update_by = True
    unique_field = 'template_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_on = datetime.now(UTC)
        if 'name' in req.data:
            cls = self.model_class
            q = cls.filter(and_(cls.name == req.data['name'], cls.direction == 'egress',
                                cls.resource_template_id != obj.resource_template_id)).first()
            if q:
                raise ValidationError({'name': ['such template {} already exists'.format(q.name)]})
        return obj


class EgressTrunkTemplateList(DnlList):
    scheme_class = EgressTrunkTemplateGetScheme
    model_class = model.EgressTrunkTemplate
    entity_plural = 'EgressTrunkTemplates'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_get(self, req, resp, **kwargs):  # pragma: no cover
        if 'order_by=used_by' in req.query_string:
            req.query_string = req.query_string.replace('order_by=used_by', '')
            if 'order_dir=desc' in req.query_string:
                self.sort_by_usage = 'desc'
            else:
                self.sort_by_usage = 'asc'
        return super(EgressTrunkTemplateList, self).on_get(req, resp, **kwargs)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(EgressTrunkTemplateList, self).get_filtering_for_list(parsed_qs, **kwargs)
        ret['direction'] = 'egress'
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(EgressTrunkTemplateList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        if hasattr(self, 'sort_by_usage'):
            if self.sort_by_usage == 'desc':
                q = q.join(model.Resource,
                           model.Resource.resource_template_id == model.EgressTrunkTemplate.resource_template_id,
                           isouter=True
                           ).group_by(model.EgressTrunkTemplate.resource_template_id).order_by(
                    model.func.count(model.Resource.resource_id.distinct()).desc())
            else:
                q = q.join(model.Resource,
                           model.Resource.resource_template_id == model.EgressTrunkTemplate.resource_template_id,
                           isouter=True
                           ).group_by(model.EgressTrunkTemplate.resource_template_id).order_by(
                    model.func.count(model.Resource.resource_id.distinct()))

        return (filt, q)


# --- EgressTrunkTemplate

# +++ IngressTrunkTemplate

class IngressTrunkTemplateCreate(DnlCreate):
    scheme_class = IngressTrunkTemplateScheme
    entity = 'IngressTrunkTemplate'
    unique_field = 'resource_template_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.create_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        obj.update_on = datetime.now(UTC)
        obj.direction = 'ingress'
        return obj


class IngressTrunkTemplateResource(DnlResource):
    model_class = model.IngressTrunkTemplate
    scheme_class = IngressTrunkTemplateScheme
    scheme_class_get = IngressTrunkTemplateGetScheme
    scheme_class_modify = IngressTrunkTemplateModifyScheme
    entity = 'IngressTrunkTemplate'
    id_field = 'resource_template_id'
    has_update_by = True
    unique_field = 'template_name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        obj.update_by = self.get_user().name
        obj.update_on = datetime.now(UTC)
        if 'name' in req.data:
            cls = self.model_class
            q = cls.filter(and_(cls.name == req.data['name'], cls.direction == 'ingress',
                                cls.resource_template_id != obj.resource_template_id)).first()
            if q:
                raise ValidationError({'name': ['such template {} already exists'.format(q.name)]})
        return obj


class IngressTrunkTemplateList(DnlList):
    scheme_class = IngressTrunkTemplateGetScheme
    model_class = model.IngressTrunkTemplate
    entity_plural = 'IngressTrunkTemplates'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def _on_get(self, req, resp, **kwargs):
        if (not hasattr(self, 'no_auth_needed') or self.no_auth_needed == False) and not check_permission(self, req,
                                                                                                          'list'):
            self.set_response(
                resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
            )
            return
        try:
            log.debug("req.headers['ACCEPT']={}".format(req.headers['ACCEPT']))
            if 'ACCEPT' in req.headers and '*/*' in req.headers['ACCEPT'] and 'application/json' not in req.headers[
                'ACCEPT']:
                req.headers['ACCEPT'] = 'text/csv'
            objects_list, total, page, per_page, fields = self.get_objects_list(req, self.model_class, **kwargs)

            try:
                per_page = int(dict(parse_qsl(req.query_string)).get('per_page'))
                log.debug("PER_PAGE TRIES SUCCESSFULLY - {}".format(per_page))
            except (ValueError, TypeError):
                per_page = conf.get_default_items_per_page()
                log.debug("PER_PAGE TRIES, but got an error - {}".format(per_page))

            def serialize_field(val):
                if isinstance(val, datetime):
                    return val.isoformat()
                return None

            def convert_object_to_dict(obj):
                data = {}
                if hasattr(obj, '__dict__'):
                    for key in obj.__dict__:
                        if not key.startswith('_'):
                            value = obj.__dict__[key]
                            if hasattr(value, '__dict__'):
                                value = convert_object_to_dict(value)
                            data[key] = value
                    return data
                return obj

            try:
                scheme_instance = self.scheme_class(only=fields)
                items = []
                for obj in objects_list:
                    item = {}
                    for field in scheme_instance.fields.keys():
                        if hasattr(obj, field):
                            value = getattr(obj, field)
                            if value:
                                item[field] = serialize_field(value)
                                if item[field] is None:
                                    item[field] = convert_object_to_dict(value)
                    items.append(item)

                log.debug(f"items: {items}")
                self.set_response(
                    resp, responses.SuccessResponse(
                        data={
                            'items': items,
                            'total': total, 'page': page, 'per_page': per_page
                        },
                        scheme=schemes.ObjectScheme
                    )
                )
            except Exception as e:
                log.debug(f"ERROR - {e}")
        except AttributeError as e:
            self.set_response(
                resp, responses.AttributeNotExitsErrorResponse(
                    data=ATTRIBUTE_ERROR_RE.search(str(e)).group(1)
                )
            )
        except Exception as e:
            import traceback
            log.error(traceback.format_exc())
            self.set_response(resp, OperationErrorResponse(e))

    def on_get(self, req, resp, **kwargs):  # pragma: no cover
        if 'order_by=used_by' in req.query_string:
            req.query_string = req.query_string.replace('order_by=used_by', '')
            if 'order_dir=desc' in req.query_string:
                self.sort_by_usage = 'desc'
            else:
                self.sort_by_usage = 'asc'
        return super().on_get(req, resp, **kwargs)

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super().get_filtering_for_list(parsed_qs, **kwargs)
        ret['direction'] = 'ingress'
        return ret

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        if hasattr(self, 'sort_by_usage'):
            if self.sort_by_usage == 'desc':
                q = q.join(model.Resource,
                           model.Resource.resource_template_id == model.IngressTrunkTemplate.resource_template_id,
                           isouter=True
                           ).group_by(model.IngressTrunkTemplate.resource_template_id).order_by(
                    model.func.count(model.Resource.resource_id.distinct()).desc())
            else:
                q = q.join(model.Resource,
                           model.Resource.resource_template_id == model.IngressTrunkTemplate.resource_template_id,
                           isouter=True
                           ).group_by(model.IngressTrunkTemplate.resource_template_id).order_by(
                    model.func.count(model.Resource.resource_id.distinct()))

        return (filt, q)


# --- DidBillingPlan

# +++ DidBillingPlan


class DidBillingPlanCreate(DnlCreate):
    scheme_class = DidBillingPlanScheme
    entity = 'DidBillingPlan'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def create_rates(self, obj, min_time=1, interval=1):
        rate_per_min = 0.0
        if obj.rate_per_min and obj.rate_table:
            rate_per_min = obj.rate_per_min
        log.debug('DidBillingPlanCreate create rates')
        letters = [chr(a) for a in range(ord('0'), ord('9') + 1)] + [chr(a) for a in range(ord('a'), ord('z') + 1)] + [
            chr(a) for a in range(ord('A'), ord('Z') + 1)]
        for c in letters:
            # q=model.Rate.filter(model.Rate.rate_table_id=)
            obj.rate_table.rates.append(model.Rate(code=c, rate=rate_per_min,
                                                   # setup_fee=obj.setup_fee,
                                                   min_time=min_time, interval=interval
                                                   ))

    def before_create(self, obj, **kwargs):
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        name = obj.name  # + str(uuid.uuid4())
        old = model.RateTable.filter(model.RateTable.name == name).first()
        while old:
            name = name + str(random.randint(0, 9))
            old = model.RateTable.filter(model.RateTable.name == name).first()
        if not obj.min_time:
            obj.min_time = 1
        if not obj.interval:
            obj.interval = 1
        if not obj.rate_table_id:
            obj.rate_table = model.RateTable(name=name)
            obj.rate_table.update_at = datetime.now(UTC)
            obj.rate_table.update_by = self.get_user().name
            obj.rate_table.origination = True
            if obj.rate_type is None:
                obj.rate_type = 'fixed'
            if obj.rate_type == 'fixed':
                self.create_rates(obj, obj.min_time, obj.interval)
        obj.update_by = self.get_user().name
        obj.create_on = datetime.now(UTC)
        obj.trunk_type = 'Ingress'
        # if obj.type=='fixed' and not obj.monthly_fee:
        #    raise ValidationError('Missing monthly_fee with "fixed" is mandatory!')

        return obj


class DidBillingPlanResource(DnlResource):
    model_class = model.DidBillingPlan
    scheme_class = DidBillingPlanScheme
    scheme_class_get = DidBillingPlanGetScheme
    scheme_class_modify = DidBillingPlanModifyScheme
    entity = 'DidBillingPlan'
    id_field = 'id'
    has_update_by = True
    unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object(self, resp, model_class, **kwargs):
        obj = super(DidBillingPlanResource, self).get_object(resp, model_class, **kwargs)
        if self.req and self.get_user(self.req).user_type == 'client':
            product_id = self.get_user(self.req).client.did_product_id
            product_items = model.DidProductItem.filter(model.DidProductItem.did_product_id == product_id).all()
            ids = [i.billing_rule_id for i in product_items]
            if not obj.id in ids:
                return None
        return obj

    def before_update(self, obj, req):
        log.debug("Before Update")
        errors = self.scheme_class_modify().validate(req.data)
        if errors:
            raise ValidationError(errors)
        obj.update_by = self.get_user().name
        obj.update_at = datetime.now(UTC)
        if obj.rate_type == 'fixed':
            if obj.rate_table:
                if 'rate_per_min' in req.data:
                    model.Rate.filter(model.Rate.rate_table_id == obj.rate_table_id).update(dict(
                        rate=req.data['rate_per_min']
                    ))
                if 'min_time' in req.data:
                    model.Rate.filter(model.Rate.rate_table_id == obj.rate_table_id).update(dict(
                        min_time=req.data['min_time']
                    ))
                if 'interval' in req.data:
                    model.Rate.filter(model.Rate.rate_table_id == obj.rate_table_id).update(dict(
                        interval=req.data['interval']
                    ))
        if 'name' in req.data:
            dcls = model.DidBillingRel
            dids = dcls.filter(dcls.client_billing_rule_id == obj.id).all()
            for did in dids:
                if did.client_res:
                    did.client_res.alias = did.client_res.alias.replace(obj.name, req.data['name'])
                    did.client_res.name = did.client_res.alias
                    obj.session().add(did.client_res)

        return obj

    def on_delete(self, req, resp, **kwargs):
        obj = model.DidBillingPlan.get(int(kwargs['id']))
        assignment = model.DidAssignments.filter(or_(model.DidAssignments.client_billing_plan_id == int(kwargs['id']),
                                             model.DidAssignments.vendor_billing_plan_id == int(kwargs['id'])))
        did = model.DidRepository.filter(model.DidRepository.vendor_billing_plan_id == int(kwargs['id']))
        if (assignment and assignment.first()) or (did and did.first()):
            e = Exception('there is did associated with this plan')
            self.set_response(resp, OperationErrorResponse(e))
            return None
        if obj and obj.rate_table_id:
            model.RateTable.filter(model.RateTable.rate_table_id == obj.rate_table_id).delete(
                synchronize_session='fetch')
        return super(DidBillingPlanResource, self).on_delete(req, resp, **kwargs)


class DidBillingPlanList(DnlList):
    scheme_class = DidBillingPlanGetScheme

    model_class = model.DidBillingPlan
    entity_plural = 'DidBillingPlans'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class DidBillingPlanRateParamsResource(CustomPatchAction):
    model_class = model.DidBillingPlan
    scheme_class = DidBillingPlanModifyRateParamsScheme  # DidBillingPlanGetScheme
    entity = 'DidBillingPlan'
    body_parameters = ('Rate parameters for this item', DidBillingPlanModifyRateParamsScheme)
    path_parameters = ({'name': 'id', 'description': 'Billing rule with fixed plan to edit'},)

    def apply(self, obj, req, resp, **kwargs):
        try:
            if not obj.rate_table:
                raise ValidationError('This Billing rule does not have rate table!')
            if not obj.rate_table.rates:
                raise ValidationError('This Billing rule rate table does not have rates!')
            if 'min_time' in req.data:
                model.Rate.filter(model.Rate.rate_table_id == obj.rate_table_id).update(dict(
                    min_time=req.data['min_time']
                ))
            if 'interval' in req.data:
                model.Rate.filter(model.Rate.rate_table_id == obj.rate_table_id).update(dict(
                    interval=req.data['interval']
                ))
            obj.save()
            scheme = self.scheme_class()
            data = scheme.dump(obj).data
            self.set_response(resp, responses.SuccessResponseObjectInfo(data=data))
            return False
        except Exception as e:
            trace = traceback.format_exc()
            log.error(trace)
            self.set_response(resp, OperationErrorResponse(e))
            return False


# --- DidBillingPlan

# --- RerateCdrTask ---
class RerateCdrTaskCreate(DnlCreate):
    scheme_class = RerateCdrTaskScheme
    entity = 'RerateCdrTask'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        return obj


class RerateCdrTaskResource(DnlResource):
    model_class = model.RerateCdrTask
    scheme_class = RerateCdrTaskScheme
    scheme_class_get = RerateCdrTaskGetScheme
    scheme_class_modify = RerateCdrTaskScheme
    entity = 'RerateCdrTask'
    id_field = 'id'
    has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()


class RerateCdrTaskList(DnlList):
    scheme_class = RerateCdrTaskGetScheme
    model_class = model.RerateCdrTask
    entity_plural = 'RerateCdrTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        if 'by' in ordering:
            if ordering['by'] == 'from_date':
                ordering['by'] = 'from_time'
            if ordering['by'] == 'to_date':
                ordering['by'] = 'to_time'

        return ordering, query


# --- RerateCdrTask ---
# +++ RerateReportExecLog
class RerateReportExecLogList(DnlList):
    scheme_class = RerateReportExecLogScheme
    model_class = model.RerateReportExecLog
    entity_plural = 'RerateReportExecLog'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# --- RerateReportExecLog
# +++ RerateCdrDownloadLog
class RerateCdrDownloadLogList(DnlList):
    scheme_class = RerateCdrDownloadLogScheme
    model_class = model.RerateCdrDownloadLog
    entity_plural = 'RerateCdrDownloadLog'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# --- RerateCdrDownloadLog

# +++ VersionInformation
class VersionInformationList(DnlList):
    scheme_class = VersionInformationGetScheme
    model_class = model.VersionInformation
    entity_plural = 'VersionInformation'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    no_auth_needed = True


# --- VersionInformation

# +++PcapQuery
class PcapQueryCreate(DnlCreate):
    scheme_class = PcapQueryScheme
    entity = 'PcapQuery'
    unique_field = 'query_key'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        if 'duration' in req.data:
            kwargs['duration'] = req.data['duration']
        return super(PcapQueryCreate, self).on_post(req, resp, **kwargs)

    def before_create(self, obj, **kwargs):
        try:
            obj.duration = int(kwargs.pop('duration', 0))
        except:
            raise ValidationError({'diration': ['must be integer']})
        obj.requested_by = self.get_user().name
        return obj


class PcapQueryResource(DnlResource):
    model_class = model.PcapQuery
    scheme_class = PcapQueryScheme
    scheme_class_get = PcapQueryGetScheme
    scheme_class_modify = PcapQueryEmptyScheme
    entity = 'PcapQuery'
    id_field = 'query_key'
    # has_update_by = True
    # unique_field = 'name'
    security = (DEFAULT_SECURITY)
    restrict = ()
    # has_delete_operation = False
    has_modify_operation = False

    def on_delete(self, req, resp, **kwargs):
        obj = self.get_object(resp, self.model_class, **kwargs)
        file = None
        if obj and obj.file_name:
            file = obj.file_name
        ret = super(PcapQueryResource, self).on_delete(req, resp, **kwargs)
        if file:
            try:
                os.unlink(file)
            except:
                pass
        return ret


class PcapQueryRestart(CustomPatchAction):
    model_class = model.PcapQuery
    scheme_class = PcapQueryScheme
    scheme_class_get = PcapQueryGetScheme
    entity = 'PcapQuery'
    id_field = 'query_key'
    security = (DEFAULT_SECURITY)
    restrict = ()
    path_parameters = ({'name': 'query_key', 'description': 'query_key to restart'},)

    def apply(self, obj, req, resp, **kwargs):
        if obj:
            obj.status = 'initial'
            obj.queued_time = datetime.now(UTC)
            obj.msg = 'restarted'
            obj.public_url = ''
            obj.requested_by = self.get_user(req).name
            obj.save()
            s = self.scheme_class_get()
            data = s.dump(obj).data
            self.set_response(resp, responses.SuccessResponseObjectInfo(data=data))
            return False
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(data='query not found'))
            return False


class PcapQueryGet(DnlResource):
    no_auth_needed = True
    model_class = model.PcapQuery
    scheme_class = PcapQueryScheme
    scheme_class_get = PcapQueryGetScheme
    entity = 'Pcap file'
    id_field = 'query_key'
    has_modify_operation = False
    has_delete_operation = False
    security = ()
    restrict = ()

    def get_spec_info(self):
        spec = super(PcapQueryGet, self).get_spec_info()
        spec['get']['produces'] = ['application/vnd.tcpdump.pcap']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')
        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj:
                if obj.status != 'success':
                    self.set_response(resp, OperationErrorResponse('pcap query was not successful! {}'.format(obj.msg)))
                    return False
                import os
                file_path = settings.PCAP_WEB_PUBLIC_DIR + '/' + obj.query_key + '.pcap'
                file = open(file_path, 'rb')
                # file.name = obj.query_key +'.pcap'
                resp.data = file.read()
                resp.content_type = 'application/vnd.tcpdump.pcap'
                resp.append_header('Content-Disposition', 'attachment; filename="{}.pcap"'.format(obj.query_key))
                # if self.get_user(req):
                #    obj.user_id = self.get_user(req).user_id
                # obj.download_time=datetime.now(UTC)
                # obj.save()
                # obj.finished_time = datetime.now(UTC)
                resp.status = falcon.HTTP_200
            else:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(data='query not found'))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


# self.set_response(resp, responses.SuccessResponseObjectInfo(data=data))


class PcapQueryList(DnlList):
    scheme_class = PcapQueryGetScheme
    model_class = model.PcapQuery
    entity_plural = 'PcapQuerys'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(PcapQueryList, self).get_filtering_for_list(parsed_qs, **kwargs)

        return ret


# ---PcapQuery

# +++PcapQueryTask+++
class PcapQueryTaskCreate(DnlCreate):
    description = 'filter expression. syntax: name=value operator name=value\n name: call-id,caller,callee,ip.src,ip.dst\n operator: and'
    scheme_class = PcapQueryTaskScheme
    model_class = model.PcapQueryTask
    entity = 'PcapQueryTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.operator_user = user.name
        if obj.pcap_start_time.timestamp() > datetime.utcnow().timestamp() \
                or obj.pcap_end_time.timestamp() > datetime.utcnow().timestamp():
            raise ValidationError("pcap_start_time, pcap_end_time cannot be in future!")
        # client_cdr = model.get_db().session.query(model.ClientCdr.time, model.ClientCdr.call_duration).order_by(model.ClientCdr.time.desc()).limit(1).first()
        # if client_cdr:
        #     obj.pcap_start_time = client_cdr.time - timedelta(seconds=5)
        #     obj.pcap_end_time = client_cdr.time + timedelta(seconds=(client_cdr.call_duration + 5))
        # obj.created_on=datetime.now(UTC)
        return obj


class PcapQueryTaskResource(DnlResource):
    model_class = model.PcapQueryTask
    scheme_class = PcapQueryTaskScheme
    scheme_class_get = PcapQueryTaskSchemeGet
    scheme_class_modify = PcapQueryTaskSchemeModify
    entity = 'PcapQueryTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_modify_operation = False


class PcapQueryTaskList(DnlList):
    scheme_class = PcapQueryTaskSchemeGet
    model_class = model.PcapQueryTask
    entity_plural = 'PcapQueryTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if user and not user.is_admin:
            ret = ret.filter(self.model_class.operator_user == user.name)
        return filt, ret


class PcapQueryTaskGet(DnlResource):
    model_class = model.PcapQueryTask
    scheme_class = PcapQueryTaskSchemeGet
    scheme_class_get = PcapQueryTaskSchemeGet
    entity = 'Pcap file'
    id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = (DEFAULT_SECURITY)
    restrict = ()
    no_auth_needed = True

    def get_spec_info(self):
        spec = super(PcapQueryTaskGet, self).get_spec_info()
        spec['get']['produces'] = ['application/vnd.tcpdump.pcap']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')
        try:
            self.init_req(req)
            obj = self.get_object(resp, self.model_class, **kwargs)
            # user = self.get_user(req)
            if (not hasattr(self, 'no_auth_needed') or self.no_auth_needed == False) and not check_context(self, req, resp, **kwargs):
                self.set_response(
                    resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
                )
                return
            if obj:
                if obj.status not in ('Partially Successful', 'All Successful'):
                    self.set_response(resp,
                                      OperationErrorResponse(
                                          'pcap query task {} was not successful! Status is {}'.format(obj.id,
                                                                                                       obj.status)))
                    return False
                if obj.capture_uuid == 'no file found':
                    self.set_response(resp,
                                      OperationErrorResponse(
                                          'pcap query task {} did not generate result file'.format(obj.id,
                                                                                                   obj.status)))
                    return False
                import os
                file_path = obj.result_file
                file_name = file_path.split('/')[-1]
                file = open(file_path, 'rb')
                # file.name = obj.query_key +'.pcap'
                resp.data = file.read()
                resp.content_type = 'application/vnd.tcpdump.pcap'
                resp.append_header('Content-Disposition', 'attachment; filename="{}"'.format(file_name))
                resp.status = falcon.HTTP_200
            else:
                self.set_response(resp,
                                  responses.ObjectNotFoundErrorResponse(data='query not found or not successfull'))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class PcapQueryTaskSendMail(CustomPostAction):
    model_class = model.PcapQueryTask
    scheme_class = PcapQueryTaskEmailScheme
    body_parameters = ('Mail parameters', PcapQueryTaskEmailScheme)
    path_parameters = ({"name": "id", "type": "string", "description": "request id"},)

    def apply(self, obj, req, resp, **kwargs):
        log.debug('send pcap: {} {} {}'.format(req.query_string, req.data, req.headers))
        if obj:
            errors = self.scheme_class().validate(req.data)
            if errors:
                raise ValidationError(errors)
                # self.set_response(resp, responses.ValidationErrorResponse(errors))
                # return False
            if 'email' in req.data:
                if not obj.mail:
                    obj.mail = model.PcapQueryTaskMail(id=obj.id, email=req.data['email'])
                obj.mail.email = req.data['email']
            if 'client_id' in req.data:
                obj.mail.client_id = req.data['client_id']
            obj.save()
            from api_dnl.tasks import do_pcap_email_async_task
            try:
                do_pcap_email_async_task.delay(obj.id)
                return True
            except Exception as e0:
                log.debug('do_pcap_email_async_task after create {}'.format(e0))
                try:
                    do_pcap_email_async_task(obj.id)
                    return True
                except Exception as e:
                    self.set_response(resp, OperationErrorResponse(e))
                    return False
        else:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse())
            return False


class ShowStirShaken(DnlResource):
    model_class = model.PcapQueryTask
    scheme_class = PcapQueryTaskScheme
    scheme_class_get = PcapQueryTaskSchemeGet
    entity = 'PcapQueryTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_modify_operation = False
    has_delete_operation = False

    def on_get(self, req, resp, **kwargs):
        try:
            log.debug("ON GET")
            self.init_req(req)
            if not check_context(self, req, resp, **kwargs):
                return False
            kwargs = client_context(self, req, resp, **kwargs)
            if not self.has_info_operation:  # pragma: no cover
                return self.method_not_allowed_response(resp, 'GET')
            user = self.get_user(req)
            if user and user.user_type == 'client':
                pass
            elif not check_permission(self, req, 'show', self.get_object(resp, self.model_class, **kwargs)):
                self.set_response(
                    resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
                )
                return

            query_task = model.PcapQueryTask.get(kwargs['id'])

            if not query_task:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(data="QueryTask object not found"))
                return
            if not query_task.result_file:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse(data="PCAP file is not defined in the database"))
                return
            
            results = []
            if query_task and query_task.result_file:
                packets = rdpcap(query_task.result_file)
                for pkt in packets:
                    if pkt.haslayer("Raw"):
                        payload = pkt["Raw"].load.decode(errors="ignore")
                        if payload.startswith("INVITE"):
                            src_ip = pkt["IP"].src
                            dst_ip = pkt["IP"].dst
                            ani = re.search(r"From:.*?sip:(\d+)@", payload)
                            dnis = re.search(r"To:.*?sip:(\d+)@", payload)
                            identity = re.search(r"Identity:\s*(.*)", payload)
                            results.append({
                                "time": float(pkt.time),
                                "from_ip": src_ip,
                                "to_ip": dst_ip,
                                "ani": ani.group(1) if ani else None,
                                "dnis": dnis.group(1) if dnis else None,
                                "identity": identity.group(1) if identity else None,
                            })

            data = {'items': results}
            self.set_response(
                resp, responses.SuccessResponseObjectInfo(data=data,
                                                        payload_scheme=ShowStirShakenGetScheme))
            return None

        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


# ---PcapQueryTask---


# +++ StorageConfig
class StorageConfigCreate(DnlCreate):
    scheme_class = StorageConfigScheme
    entity = 'StorageConfig'
    unique_field = 'conf_type'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class StorageConfigResource(DnlResource):
    model_class = model.StorageConfig
    scheme_class = StorageConfigScheme
    scheme_class_get = StorageConfigScheme
    scheme_class_modify = StorageConfigModifyScheme
    entity = 'StorageConfig'
    id_field = 'conf_type'
    has_delete_operation = False
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def after_update(self, result, obj, data):

        try:
            pass
        # from api_dnl.task.pcaploader import load_db_settings,PCAP_APP
        # load_db_settings()
        # load_db_settings.delay()
        except Exception as e:
            log.error('StorageConfig after update error:{}'.format(str(e)))
            pass
        return obj


# --- StorageConfig
# +++ LcrTest
class LcrTestCreate(DnlCreate):
    scheme_class = LcrTestScheme
    entity = 'LcrTest'
    unique_field = 'name'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        trunk = model.Resource.get(obj.egress_id)
        if not trunk or not trunk.rate_table:
            raise ValidationError('Egress does not have rate_table! Nothing to to test')
        obj.create_data()
        return obj


class LcrTestResource(DnlResource):
    model_class = model.LcrTest
    scheme_class = LcrTestScheme
    scheme_class_get = LcrTestGetScheme
    scheme_class_modify = LcrTestScheme
    entity = 'LcrTest'
    id_field = 'id'
    has_modify_operation = False
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class LcrTestCall(CustomPatchAction):
    scheme_class = LcrTestCallScheme
    scheme_class_get = CallApiScheme
    model_class = model.LcrTest
    id_field = 'id'
    description = 'make test call'
    path_parameters = ({'name': 'id', 'description': 'Test id to call'},)
    body_parameters = ('Code to call', LcrTestCallScheme)
    method = 'post'
    additional_responses = (responses.SuccessResponseObjectInfo(scheme=CallApiScheme,
                                                                description='Call simulation result'),)

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        try:
            data = obj.test_code(req.data['code'])
            # data = {'Origination-LRN-Action-DNIS-After': {'DNIS': None}, 'Simulation-progress': 'Done', 'Global-Route-State': {'Origination-State': 'Unauthorized IP Address'}, 'Origination-Route-DNIS': None, 'Origination-Digit-Mapped-ANI': {'ANI': None}, 'Origination-LRN-Action-DNIS-Before': {'DNIS': None}, 'Origination-SRC-DNIS': '2222', 'Origination-Respond-LRN-DNIS': None, 'Origination-SRC-ANI': '1111', 'Origination-Trunk': {'Profit-Type': None, 'CPS': '0', 'CAP': '0', 'Profit-Margin': '0.000000', 'Dynamic-Route-Name': None, 'Route-Strategy-Name': None, 'Carrier-Name': None, 'Media-Type': 'Transcoding Media', 'Route-Type': 'Unknow', 'Trunk-Name': None, 'Rate-Table-Name': None, 'Static-Route-Name': None}, 'Origination-Ignored-Trunk': {'Trunk-Name': [None, None, None, 'bruno', 'bruno'], 'Cause': ['Resource not found', 'Resource not found', 'Resource not found', 'Resource ingress disable', 'Resource ingress disable']}, 'Origination-Translation-DNIS': {'DNIS': None}, 'Origination-Translation-ANI': {'ANI': None}, 'Origination-Digit-Mapped-DNIS': {'DNIS': None}}

            if data:

                self.set_response(resp, responses.SuccessResponseObjectInfo(
                    data=data['payload'],
                    scheme=CallApiScheme
                )
                                  )
                return False
            else:
                self.set_response(
                    resp, responses.SuccessResponseJustOk())
            return False
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


# --- LcrTest
class RtCallbackResource(CustomAction):
    method = 'post'
    no_auth_needed = True
    model_class = model.CdrDownloadTask
    body_parameters = ('callback body parameters', RtCallbackScheme)
    path_parameters = ({'name': 'request_uuid', 'description': 'request id to inform'},)

    def on_post(self, req, resp, **kwargs):
        self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):

        try:
            request_id = kwargs['request_uuid']
            user = model.User.filter(model.User.name == req.data['user_name']).first()
            if not user:
                msg = 'rt_callback user not found'
                log.warning(msg)
                self.set_response(resp, OperationErrorResponse(msg))
                return False
            a = StatisticAPI()

            # token,exp=a.authenticate(user=user.name)
            token = user.cdr_api_token
            exp = user.cdr_expire.timestamp()
            a.set_token(token, exp)
            ret = a.send_request(params={}, rt_api='async', cdr_request=request_id)
            if ret.status_code != 200:
                msg = 'rt_callback cannot get status'
                log.warning(msg)
                self.set_response(resp, OperationErrorResponse(msg))
                return False
            res = ret.json()
            log.debug('rt_callback result is {}'.format(res))
            locals().update(res)
            if res['status'] != 'Complete':
                msg = 'rt_callback status not complete {}'.format(res)
                log.warning(msg)
                self.set_response(resp, OperationErrorResponse(msg))
                return False

            if not 'to_email' in res or not res['to_email']:
                msg = 'rt_callback to_email is none'
                log.warning(msg)
                self.set_response(resp, OperationErrorResponse(msg))
                return False

            if 'download_link' in res:
                user.fmt_download_link = res['download_link']
            if 'start_time' in res:
                user.fmt_start_time = res['start_time']
            if 'end_time' in res:
                user.fmt_start_time = res['end_time']
            user.fmt_download_link = '{}{}{}/rt/cdr_request/{}/download'.format(settings.API_SCHEME, settings.API_HOST,
                                                                                settings.API_BASE_PATH, request_id)
            user.fmt_share_link = user.fmt_download_link
            user.fmt_username = 'admin'
            user.fmt_current_day = str(datetime.now(UTC).date())
            user.fmt_customer_gmt = '+00'  # user.auto_send_zone
            user.fmt_company_name = 'N/A'
            user.fmt_client_name = 'N/A'

            if 'count' in res:
                user.fmt_cdr_count = res['count']
            ret = model.MailSender.apply_mail(user, 'send_cdr', to=res['to_email'], att=[])
            if ret:
                self.set_response(resp, responses.OperationErrorResponse(
                    data=errors.Error(code=43, message=ret[1], reason='mail error')))
                return False
            return True
        except Exception as e:
            log.error('rt_callback error {}'.format(e))
            self.set_response(resp, OperationErrorResponse(str(e)))


# --- CdrDowloadTask ---
class CdrDownloadTaskCreate(DnlCreate):
    scheme_class = CdrDownloadTaskScheme
    entity = 'CdrDownloadTask'
    unique_field = 'request_id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        old = model.SendCdrDirect.get(obj.request_id)
        if old:
            log.debug('delete old SendCdrDirect')
            old.delete()
        # old = model.CdrDownloadTask.get(obj.request_id)
        # if old:
        #     log.debug('delete old CdrDownloadTask')
        #     old.delete()
        a = StatisticAPI()
        res = a.send_request(params={}, rt_api='async', cdr_request=obj.request_id)
        if res.status_code == 404:
            raise ValidationError({'request_id': ['Invalid request_id. It must be prepared by cdr api.']})
        obj.status = 'waiting'
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        log.debug('CdrDownloadTaskCreate  after_create "{}"'.format(object_id))
        try:
            from api_dnl.task.cdr_download import cdr_download
            ret = cdr_download.delay(request_id=object_id)
            log.info('cdr_download task scheduled {} {}'.format(object_id, ret.id))
        # obj = model.RateUploadTask.get(object_id)
        # obj.task_id = ret.id
        # obj.save()
        except Exception as e:
            log.error('CdrDownloadTaskCreate {}'.format(e))


class CdrDownloadTaskList(DnlList):
    scheme_class = CdrDownloadTaskGetScheme
    model_class = model.CdrDownloadTask
    entity_plural = 'CdrDownloadTaskS'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class CdrDownloadTaskResource(DnlResource):
    model_class = model.CdrDownloadTask
    scheme_class = CdrDownloadTaskScheme
    scheme_class_get = CdrDownloadTaskGetScheme
    entity = 'CdrDownloadTask file'
    id_field = 'request_uuid'
    has_modify_operation = False
    has_delete_operation = True
    # security = (DEFAULT_SECURITY)
    restrict = ()
    no_auth_needed = True

    def on_delete(self, req, resp, **kwargs):
        kwargs['request_id'] = kwargs['request_uuid']
        obj = self.get_object(resp, self.model_class, **kwargs)
        file = None
        if obj and obj.file_name:
            file = obj.file_name
        ret = super(CdrDownloadTaskResource, self).on_delete(req, resp, **kwargs)
        if file:
            try:
                os.unlink(file)
            except:
                pass
        return ret

    def get_spec_info(self):
        spec = super(CdrDownloadTaskResource, self).get_spec_info()
        spec['get']['produces'] = ['application/json', 'image/ico', 'image/jpg', 'image/png', 'text/csv']
        return spec

    def on_get(self, req, resp, **kwargs):
        kwargs['request_id'] = kwargs['request_uuid']
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')
        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if not obj or not obj.orig_file:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            if not True:  # not obj.is_public:
                if not check_permission(self, req, 'show', obj):
                    self.set_response(
                        resp, responses.ForbiddenErrorResponse(data=errors.AuthErrors.Forbidden)
                    )
                    return
            if obj and obj.orig_file:
                resp.data = obj.file_data
                resp.append_header('Content-Disposition',
                                   'attachment; filename="cdr_{}.xls"'.format(obj.fmt_start_time.date()))
                resp.content_type = mimetypes.guess_type(obj.orig_file)[0]
                resp.status = falcon.HTTP_200
                return
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


# --- CdrDowloadTask ---

# --- Ticket ---
class TicketTypeCreate(DnlCreate):
    scheme_class = TicketTypeScheme
    entity = 'TicketType'
    unique_field = 'ticket_type'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class TicketTypeResource(DnlResource):
    model_class = model.TicketType
    scheme_class = TicketTypeScheme
    scheme_class_get = TicketTypeScheme
    scheme_class_modify = TicketTypeScheme
    entity = 'TicketType'
    id_field = 'ticket_type'
    security = (DEFAULT_SECURITY)
    restrict = ()


class TicketTypeList(DnlList):
    scheme_class = TicketTypeGetScheme
    model_class = model.TicketType
    entity_plural = 'TicketTypes'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class TicketCreate(DnlCreate):
    scheme_class = TicketScheme
    entity = 'Ticket'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user()
        obj.user_name = user.name
        obj.create_on = datetime.now(UTC)
        obj.update_on = obj.create_on
        obj.user_ip = get_request_ip(self.req)
        obj.status = 'none'
        obj.ticket_status = 'waiting'
        obj.url = '{}/config/export/public/{}'.format(settings.API_URL, user.avatar_id)
        return obj


class TicketResource(DnlResource):
    model_class = model.Ticket
    scheme_class = TicketScheme
    scheme_class_get = TicketGetScheme
    scheme_class_modify = TicketScheme
    entity = 'Ticket'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object_data(self, resp, model_class, scheme_class_get, **kwargs):
        cls = self.model_class
        user = self.get_user(self.req)
        q = cls.get(int(kwargs['id']))
        if not q:
            return None
        if not q.check_user(user):
            return None
        return super(TicketResource, self).get_object_data(resp, model_class, scheme_class_get, **kwargs)

    def before_update(self, obj, req):
        cls = self.model_class
        user = self.get_user(self.req)
        if 'ticket_status' in req.data:
            if user.user_type != 'admin' and req.data['ticket_status'] == 'in progress':
                raise ValidationError({'ticket_status': ['you cannot set such ticket status!']})
            obj.set_ticket_status(req.data['ticket_status'], user.name)

        obj.set_ticket_update(datetime.now(UTC), self.get_user().name)

        return obj


class TicketSendResource(CustomPatchAction):
    model_class = model.Ticket
    scheme_class = CustomPatchAction
    scheme_class_get = TicketGetScheme
    scheme_class_modify = TicketSendScheme
    entity = 'Ticket'
    id_field = 'id'
    path_parameters = ({'name': 'id', 'description': 'Ticket id to send'},)

    def apply(self, obj, req, resp, **kwargs):
        if not obj:
            raise NoResultFound
        if not obj.check_user(self.get_user(req)):
            raise NoResultFound
        config = model.SystemParameter.get(1)
        att = []
        for i in obj.attachments:
            att.append((i.orig_file, i.file_data))
        if not obj.department:
            obj.department = 'Admin'
        mails = {'Admin': config.system_admin_email,
                 'Finance': config.finance_email,
                 'NOC': config.noc_email}
        obj.email = mails[obj.department]
        ret = model.MailSender.apply_mail(obj, 'trouble_ticket', att=att)
        if not ret:
            obj.status = 'sent'
            obj.save()
        else:
            if ret:
                self.set_response(resp, responses.OperationErrorResponse(
                    data=errors.Error(code=43, message=ret[1], reason='mail error')))
                return False
        return obj

class SendTroubleTicketResource(CustomPostAction):
    scheme_class = SendTroubleTicketScheme
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_parameters = ('Parameters', scheme_class,)

    def on_post(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            self.set_response(resp, responses.ForbiddenErrorResponse())
            return

        try:
            params = req.data
            required_fields = ['mail_sender_id', 'dest_email', 'content', 'subject']
            for field in required_fields:
                if field not in params:
                    raise ValidationError(f'Missing required field: {field}')

            mail_sender = model.MailSender.get(params['mail_sender_id'])
            if not mail_sender:
                raise ValidationError('Invalid mail_sender_id')

            # Build email parameters
            email_params = {
                'to': params['dest_email'],
                'subject': params['subject'],
                'text': params['content']
            }

            if 'cc_email' in params:
                email_params['cc'] = params['cc_email']

            # Send email
            ret = mail_sender.send_mail(**email_params)

            if ret == 0:
                self.set_response(resp, responses.SuccessResponse(data={'status': 'success'}, scheme=schemes.ObjectScheme))
            else:
                self.set_response(resp, responses.OperationErrorResponse(
                    data=errors.Error(code=43, message=ret[1], reason='mail error')))

        except ValidationError as e:
            self.set_response(resp, responses.ValidationErrorResponse(data=str(e)))
        except Exception as e:
            self.set_response(resp, responses.OperationErrorResponse(data=str(e)))


class TicketList(DnlList):
    scheme_class = TicketGetScheme
    model_class = model.Ticket
    entity_plural = 'Tickets'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(TicketList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        q = q.filter(cls.ticket_id.is_(None))
        user = self.get_user(self.req)
        if user.user_type != 'admin':
            q = q.filter(cls.user_name == user.name)
        return filt, q

    def get_filtering_for_list(self, parsed_qs, **kwargs):
        ret = super(TicketList, self).get_filtering_for_list(parsed_qs, **kwargs)
        return ret


class TicketCommentCreate(DnlCreate):
    scheme_class = TicketCommentScheme
    entity = 'TicketComment'
    unique_field = 'id'
    additional_responses = ()
    path_parameters = ({'name': 'id', 'description': 'ticket id for comment'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user()
        cls = model.Ticket
        ticket = cls.get(kwargs['id'])
        if not ticket or ticket.ticket:
            raise NoResultFound()
        if not ticket.check_user(user):
            raise NoResultFound()
        obj.user_name = user.name
        obj.create_on = datetime.now(UTC)
        obj.user_ip = get_request_ip(self.req)
        obj.status = 'none'
        obj.ticket = ticket
        obj.set_ticket_update(datetime.now(UTC), user.name)
        req = self.req
        if 'ticket_status' in req.data:
            if user.user_type != 'admin' and req.data['ticket_status'] == 'in progress':
                raise ValidationError({'ticket_status': ['you cannot set such ticket status!']})
            obj.set_ticket_status(req.data['ticket_status'], user.name)
        else:
            if user.user_type == 'admin':
                obj.set_ticket_status('in progress', user.name)
            else:
                obj.set_ticket_status('waiting', user.name)
        return obj


class TicketCommentResource(DnlResource):
    model_class = model.Ticket
    scheme_class = TicketCommentScheme
    scheme_class_get = TicketCommentGetScheme
    scheme_class_modify = TicketCommentScheme
    entity = 'TicketComment'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object_data(self, resp, model_class, scheme_class_get, **kwargs):
        cls = self.model_class
        user = self.get_user(self.req)
        q = cls.get(int(kwargs['id']))
        if not q:
            return None
        if not q.check_user(user):
            return None
        return super(TicketCommentResource, self).get_object_data(resp, model_class, scheme_class_get, **kwargs)

    def before_update(self, obj, req):
        cls = self.model_class
        user = self.get_user(self.req)
        if 'ticket_status' in req.data:
            if user.user_type != 'admin' and req.data['ticket_status'] == 'in progress':
                raise ValidationError({'ticket_status': ['you cannot set such ticket status!']})
            obj.set_ticket_status(req.data['ticket_status'], user.name)
        else:
            if user.user_type == 'admin':
                obj.set_ticket_status('in progress', user.name)
            else:
                obj.set_ticket_status('open', user.name)

        obj.set_ticket_update(datetime.now(UTC), user.name)
        return obj


class TicketCommentSendResource(CustomPatchAction):
    model_class = model.Ticket
    scheme_class = CustomPatchAction
    scheme_class_get = TicketCommentScheme
    scheme_class_modify = TicketSendScheme
    entity = 'Ticket'
    id_field = 'id'
    path_parameters = ({'name': 'id', 'description': 'Ticket id to send'},)

    def apply(self, obj, req, resp, **kwargs):
        if not obj:
            raise NoResultFound
        config = model.SystemParameter.get(1)
        att = []
        for i in obj.attachments:
            att.append((i.orig_file, i.file_data))

        obj.department = obj.ticket.department
        if not obj.department:
            obj.department = 'Admin'
        mails = {'Admin': config.system_admin_email,
                 'Finance': config.finance_email,
                 'NOC': config.noc_email}
        obj.email = mails[obj.department] + ';' + obj.mail_list
        ret = model.MailSender.apply_mail(obj, 'trouble_ticket', att=att)
        if not ret:
            obj.status = 'sent'
            obj.save()
        else:
            if ret:
                self.set_response(resp, responses.OperationErrorResponse(
                    data=errors.Error(code=43, message=ret[1], reason='mail error')))
                return False
        return obj


class TicketAttachmentCreate(DnlCreate):
    model_class = model.TicketAttachment
    scheme_class = TicketAttachmentScheme
    scheme_class_get = TicketAttachmentGetScheme
    entity = 'Attach file'
    id_field = 'uuid'
    path_parameters = ({'name': 'id', 'description': 'Ticket or comment id to attach file'},)
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_params = ()

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = self.body_params or (

            {
                'name': 'file',
                'in': 'formData',
                'description': 'File to upload',
                'required': True,
                'type': 'file'
            },
        )

        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          self.scheme_class.get_object_created_response(entity=self.entity),
                          # ,scheme=ObjectCreatedWithErrorsScheme),
                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def before_create(self, obj, **kwargs):
        try:

            obj.uuid = generate_uuid_str()()
            obj.ticket_id = kwargs['id']
            obj.user_name = self.get_user().name
            obj.create_on = datetime.now(UTC)
            file = self.req.files['file']
            obj.orig_file = file.filename
            b = file.read()
            fsz = len(b)
            log.info('Uploaded file size:{}'.format(fsz))
            flimit = 200 * 1024 * 1024
            if (fsz > flimit):
                raise ValidationError('File too big :{} , limit is {}'.format(fsz, flimit))
            local_file = open(obj.file_name, 'wb')
            local_file.write(b)
            # shutil.copyfileobj(file, local_file)
            local_file.close()
        except ValidationError as e:
            raise e
        except Exception as e:
            log.error('Import failure: {}'.format(str(e)))
            raise ValidationError('Import failure: {}'.format(traceback.format_exc()))
        return obj


class TicketAttachmentResource(DnlResource):
    model_class = model.TicketAttachment
    scheme_class = TicketAttachmentScheme
    scheme_class_get = TicketAttachmentScheme
    entity = 'Export file'
    id_field = 'uuid'
    has_modify_operation = False
    has_delete_operation = True
    # security = (DEFAULT_SECURITY)
    security = ()
    restrict = ()
    no_auth_needed = True

    def on_delete(self, req, resp, **kwargs):
        obj = self.get_object(resp, self.model_class, **kwargs)
        file = None
        if obj and obj.file_name:
            file = obj.file_name
        ret = super(TicketAttachmentResource, self).on_delete(req, resp, **kwargs)
        if file:
            try:
                os.unlink(file)
            except:
                pass
        return ret

    def get_spec_info(self):
        spec = super(TicketAttachmentResource, self).get_spec_info()
        spec['get']['produces'] = ['application/json', 'image/ico', 'image/jpg', 'image/png', 'text/csv']
        return spec

    def on_get(self, req, resp, **kwargs):
        if not self.has_info_operation:  # pragma: no cover
            return self.method_not_allowed_response(resp, 'GET')
        try:
            obj = self.get_object(resp, self.model_class, **kwargs)
            if obj and obj.orig_file and os.path.exists(obj.file_name):
                resp_file_header(resp, obj.orig_file)
                resp.stream = open(obj.file_name, 'rb')
                resp.status = falcon.HTTP_200
                return
            else:
                self.set_response(
                    resp, responses.ObjectNotFoundErrorResponse()
                )
                return
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


# --- Ticket ---

# +++AsyncFtpExport
class AsyncFtpExportList(DnlList):
    scheme_class = AsyncFtpExportScheme
    model_class = model.AsyncFtpExport
    entity_plural = 'AsyncFtpExport log'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# ---AsyncFtpExport


# ++++++++++++++AllowedSendToIp
class AllowedSendToIpCreate(DnlCreate):
    scheme_class = AllowedSendToIpScheme
    entity = 'AllowedSendToIp'
    unique_field = 'system_function_id'
    additional_responses = ()
    path_parameters = ({'name': 'trunk_id', 'description': 'parent ingress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    # noinspection PyUnusedLocal
    def before_create(self, obj, **kwargs):
        obj.resource_id = kwargs['trunk_id']
        # cls = model.AllowedSendToIp
        # cls.filter(cls.resource_id == obj.resource_id).delete(synchronize_session='fetch')
        pro = model.SwitchProfile.get(self.req_data['sip_profile_id'])
        obj.direction = 0
        obj.sip_profile = pro
        return obj


class AllowedSendToIpResource(DnlResource):
    model_class = model.AllowedSendToIp
    scheme_class = AllowedSendToIpScheme
    scheme_class_get = AllowedSendToIpGetScheme
    scheme_class_modify = AllowedSendToIpScheme
    entity = 'AllowedSendToIp'
    id_field = 'trunk_id'
    has_update_by = True
    unique_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    # path_parameters = ({'name': 'trunk_id', 'description': 'parent ingress trunk'},)

    def on_set_id(self, req, resp, **kwargs):
        cls = self.model_class
        obj = cls.filter(cls.resource_id == kwargs['trunk_id']).first()
        if not obj:
            kwargs['id'] = 0
        else:
            kwargs['id'] = obj.id
        return kwargs

    def on_patch(self, req, resp, **kwargs):
        kwargs = self.on_set_id(req, resp, **kwargs)
        return super(AllowedSendToIpResource, self).on_patch(req, resp, **kwargs)

    def on_get(self, req, resp, **kwargs):
        kwargs = self.on_set_id(req, resp, **kwargs)
        return super(AllowedSendToIpResource, self).on_get(req, resp, **kwargs)

    def on_delete(self, req, resp, **kwargs):
        kwargs = self.on_set_id(req, resp, **kwargs)
        return super(AllowedSendToIpResource, self).on_delete(req, resp, **kwargs)

    def get_object_data(self, resp, model_class, scheme_class_get, **kwargs):
        cls = self.model_class
        obj = cls.filter(cls.resource_id == kwargs['trunk_id']).first()
        if not obj:
            data = {'sip_profile_ip': None, 'sip_profile_port': None, 'voip_gateway_name': None,
                    'sip_profile_name': None}
            return data
        # cls.filter(and_(cls.resource_id == obj.resource_id, cls.id != obj.id)).delete(synchronize_session='fetch')
        kwargs['id'] = obj.id
        return super(AllowedSendToIpResource, self).get_object_data(resp, model_class, scheme_class_get, **kwargs)

    def before_update(self, obj, req):
        cls = self.model_class
        # cls.filter(and_(cls.resource_id == obj.resource_id, cls.id != obj.id)).delete(synchronize_session='fetch')
        if 'sip_profile_id' in self.req_data:
            pro = model.SwitchProfile.get(self.req_data['sip_profile_id']) if self.req_data.get('sip_profile_id',
                                                                                                0) else None
            obj.sip_profile = pro
        if 'voip_gateway_name' in self.req_data:
            pro = model.SwitchProfile.filter(
                model.SwitchProfile.server_name == self.req_data['voip_gateway_name']).first() if self.req_data.get(
                'voip_gateway_name', '') else None
            obj.sip_profile = pro
        if 'sip_profile_id' in self.req_data:
            sip_profile = model.SwitchProfile.filter(model.SwitchProfile.id == self.req_data['sip_profile_id']).first()
            if sip_profile:
                obj.sip_profile_ip = sip_profile.sip_ip
                obj.sip_profile_port = sip_profile.sip_port
        return obj


class AllowedSendToIpByIdResource(DnlResource):
    model_class = model.AllowedSendToIp
    scheme_class = AllowedSendToIpScheme
    scheme_class_get = AllowedSendToIpGetScheme
    scheme_class_modify = AllowedSendToIpScheme
    entity = 'AllowedSendToIp'
    id_field = 'id'
    has_update_by = True
    unique_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        cls = self.model_class
        # cls.filter(and_(cls.resource_id == obj.resource_id, cls.id != obj.id)).delete(synchronize_session='fetch')
        if 'sip_profile_id' in self.req_data:
            pro = model.SwitchProfile.get(self.req_data['sip_profile_id']) if self.req_data.get('sip_profile_id',
                                                                                                0) else None
            obj.sip_profile = pro
        if 'voip_gateway_name' in self.req_data:
            pro = model.SwitchProfile.filter(
                model.SwitchProfile.server_name == self.req_data['voip_gateway_name']).first() if self.req_data.get(
                'voip_gateway_name', '') else None
            obj.sip_profile = pro
        if 'sip_profile_id' in self.req_data:
            sip_profile = model.SwitchProfile.filter(model.SwitchProfile.id == self.req_data['sip_profile_id']).first()
            if sip_profile:
                obj.sip_profile_ip = sip_profile.sip_ip
                obj.sip_profile_port = sip_profile.sip_port
        return obj


class AllowedSendToIpByIdResource(DnlResource):
    model_class = model.AllowedSendToIp
    scheme_class = AllowedSendToIpScheme
    scheme_class_get = AllowedSendToIpGetScheme
    scheme_class_modify = AllowedSendToIpScheme
    entity = 'AllowedSendToIp'
    id_field = 'id'
    has_update_by = True
    unique_field = 'id'
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_update(self, obj, req):
        cls = self.model_class
        # cls.filter(and_(cls.resource_id == obj.resource_id, cls.id != obj.id)).delete(synchronize_session='fetch')
        if 'sip_profile_id' in self.req_data:
            pro = model.SwitchProfile.get(self.req_data['sip_profile_id']) if self.req_data.get('sip_profile_id',
                                                                                                0) else None
            obj.sip_profile = pro
        if 'voip_gateway_name' in self.req_data:
            pro = model.SwitchProfile.filter(
                model.SwitchProfile.server_name == self.req_data['voip_gateway_name']).first() if self.req_data.get(
                'voip_gateway_name', '') else None
            obj.sip_profile = pro
        if 'sip_profile_id' in self.req_data:
            sip_profile = model.SwitchProfile.filter(model.SwitchProfile.id == self.req_data['sip_profile_id']).first()
            if sip_profile:
                obj.sip_profile_ip = sip_profile.sip_ip
                obj.sip_profile_port = sip_profile.sip_port
        return obj


class AllowedSendToIpList(DnlList):
    scheme_class = AllowedSendToIpGetScheme
    model_class = model.AllowedSendToIp
    entity_plural = 'AllowedSendToIps'
    path_parameters = ({'name': 'trunk_id', 'description': 'parent ingress trunk'},)
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, q = super(AllowedSendToIpList, self).modify_query_from_filtering_for_list(filtering, **kwargs)
        cls = self.model_class
        q = q.filter(cls.resource_id == int(kwargs['trunk_id']))
        return filt, q


# ----------AllowedSendToIp

# region +++SpamTrafficIp+++
class SpamTrafficIpCreate(DnlCreate):
    scheme_class = SpamTrafficIpScheme
    model_class = model.SpamTrafficIp
    entity = 'SpamTrafficIp'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.created_by = user.name
        obj.auto_block = False
        # obj.created_on=datetime.now(UTC)
        return obj


class SpamTrafficIpResource(DnlResource):
    model_class = model.SpamTrafficIp
    scheme_class = SpamTrafficIpScheme
    scheme_class_get = SpamTrafficIpSchemeGet
    scheme_class_modify = SpamTrafficIpSchemeModify
    entity = 'SpamTrafficIp'
    id_field = 'ip'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()

    def before_update(self, obj, req):
        user = self.get_user(self.req)
        obj.created_by = user.name
        obj.auto_block = False
        return obj


class SpamTrafficIpList(DnlList):
    scheme_class = SpamTrafficIpSchemeGet
    model_class = model.SpamTrafficIp
    entity_plural = 'SpamTrafficIps'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
        # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


class SpamTrafficIpActivate(DnlResourceAll):
    scheme_class = SpamTrafficIpActivateScheme
    model_class = model.SpamTrafficIp
    scheme_class_get = ObjectUpdatedScheme
    entity = 'SpamTrafficIp records'
    has_update_by = False


# endregion ---SpamTrafficIp---
# region +++CleanDataManagement+++
class CleanDataManagementCreate(DnlCreate):
    scheme_class = CleanDataManagementScheme
    model_class = model.CleanDataManagement
    entity = 'CleanDataManagement'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        # obj.created_by=user.name
        # obj.created_on=datetime.now(UTC)
        return obj


class CleanDataManagementResource(DnlResource):
    model_class = model.CleanDataManagement
    scheme_class = CleanDataManagementScheme
    scheme_class_get = CleanDataManagementSchemeGet
    scheme_class_modify = CleanDataManagementSchemeModify
    entity = 'CleanDataManagement'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class CleanDataManagementList(DnlList):
    scheme_class = CleanDataManagementSchemeGet
    model_class = model.CleanDataManagement
    entity_plural = 'CleanDataManagements'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---CleanDataManagement---

# region +++DiskManagement+++

class DiskManagementCustomDnlResource(DnlResource):
    model_class = model.DiskManagement
    scheme_class = DiskManagementScheme
    scheme_class_get = DiskManagementScheme
    entity = 'DiskManagement - virtual'
    has_delete_operation = False
    has_modify_operation = True
    has_info_operation = True
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_object_data(self, resp, model_class, scheme_class, **kwargs):
        kwargs['id'] = 1
        obj = self.get_object(resp, model_class, **kwargs)
        if not obj:
            obj = model_class(id=1)
            obj.save()
        return scheme_class().dump(obj).data

    def update_object(self, req, resp, model_class, scheme_class, **kwargs):
        kwargs['id'] = 1
        self.init_req(req)
        obj = self.get_object(resp, model_class, **kwargs)
        if not obj:
            obj = model_class(id=1)
            obj.save()
        return super().update_object(req, resp, model_class, scheme_class, **kwargs)


# endregion ---DiskManagement---

class ReleaseCauseList(DnlList):
    scheme_class = ReleaseCauseScheme
    model_class = model.ReleaseCause
    entity_plural = 'InvoiceSummarys'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class EgressReleaseCauseList(DnlList):
    scheme_class = EgressReleaseCauseScheme
    model_class = model.EgressErrorString
    entity_plural = 'EgressReleaseCauses'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# region +++MonitoredRule+++
class MonitoredRuleCreate(DnlCreate):
    scheme_class = MonitoredRuleScheme
    model_class = model.MonitoredRule
    entity = 'MonitoredRule'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.updated_by = user.name
        obj.create_time = datetime.now(UTC)
        obj.updated_at = datetime.now(UTC)
        return obj


class MonitoredRuleResource(DnlResource):
    model_class = model.MonitoredRule
    scheme_class = MonitoredRuleScheme
    scheme_class_get = MonitoredRuleSchemeGet
    scheme_class_modify = MonitoredRuleSchemeModify
    entity = 'MonitoredRule'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()

    def before_update(self, obj, req):
        user = self.get_user(self.req)
        obj.updated_by = user.name
        obj.updated_at = datetime.now(UTC)
        return obj


class MonitoredRuleList(DnlList):
    scheme_class = MonitoredRuleSchemeGet
    model_class = model.MonitoredRule
    entity_plural = 'MonitoredRules'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
        # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


class MonitoredRuleActivate(DnlResourceAll):
    scheme_class = MonitoredRuleActivateScheme
    model_class = model.MonitoredRule
    scheme_class_get = ObjectUpdatedScheme
    entity = 'Monitored rules'
    has_update_by = False


# endregion ---MonitoredRule---
# region +++MonitoredRuleHistory+++
class MonitoredRuleHistoryCreate(DnlCreate):
    scheme_class = MonitoredRuleHistoryScheme
    model_class = model.MonitoredRuleHistory
    entity = 'MonitoredRuleHistory'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        # obj.created_by=user.name
        # obj.created_on=datetime.now(UTC)
        return obj


class MonitoredRuleHistoryResource(DnlResource):
    model_class = model.MonitoredRuleHistory
    scheme_class = MonitoredRuleHistoryScheme
    scheme_class_get = MonitoredRuleHistorySchemeGet
    scheme_class_modify = MonitoredRuleHistorySchemeModify
    entity = 'MonitoredRuleHistory'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class MonitoredRuleHistoryList(DnlList):
    scheme_class = MonitoredRuleHistorySchemeGet
    model_class = model.MonitoredRuleHistory
    entity_plural = 'MonitoredRuleHistorys'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
        # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---MonitoredRuleHistory---
# region +++CdrExportTask+++
class CdrExportTaskCreate(DnlCreate):
    scheme_class = CdrExportTaskScheme
    model_class = model.CdrExportTask
    entity = 'CdrExportTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.operator_user = user.name
        obj.create_time = datetime.now(UTC)
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        from kombu.exceptions import OperationalError
        from api_dnl.tasks import do_cdr_export_email_task
        if model.CdrExportEmailTask.get(object_id):  # email scheduled
            try:
                ret = do_cdr_export_email_task.delay(object_id)
                log.debug('do_cdr_export_email_task scheduled {}'.format(ret))
            except OperationalError:
                log.debug('do_cdr_export_email_task start without celery')
                do_cdr_export_email_task(object_id)


class CdrExportTaskResource(DnlResource):
    model_class = model.CdrExportTask
    scheme_class = CdrExportTaskScheme
    scheme_class_get = CdrExportTaskSchemeGet
    scheme_class_modify = CdrExportTaskSchemeModify
    entity = 'CdrExportTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_delete_operation = False
    has_modify_operation = False


class CdrExportTaskList(DnlList):
    scheme_class = CdrExportTaskSchemeGet
    model_class = model.CdrExportTask
    entity_plural = 'CdrExportTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
        return filt, ret


# endregion ---CdrExportTask---
# region +++DidNumberDeleteTask+++
class DidNumberDeleteTaskCreate(DnlCreate):
    scheme_class = DidNumberDeleteTaskScheme
    model_class = model.DidNumberDeleteTask
    entity = 'DidNumberDeleteTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = (
            {'name': 'file', 'in': 'formData', 'description': 'File to upload', 'required': True, 'type': 'file'},
            {'name': 'op_method', 'in': 'formData', "type": "string", "enum": ["Remove DIDs from a specific client",
                                                                               "Remove DIDs from any client",
                                                                               "Remove DIDs from a specific vendor",
                                                                               "Remove DIDs from any vendor"]
             },
            {'name': 'action', 'in': 'formData', "type": "string", "enum": ['End date', 'Delete']},
            {'name': 'client_id', 'in': 'formData', 'description': 'Specified client_id', 'required': False,
             'type': 'integer'},
            {'name': 'vendor_id', 'in': 'formData', 'description': 'Specified client_id', 'required': False,
             'type': 'integer'},
        )
        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          # self.scheme_class.get_object_created_response(entity=self.entity),
                          responses.ObjectCreatedResponse(data_key='object_uuid', scheme=schemes.ObjectCreatedUuidAsPk),
                          SuccessResponseJustOk()

                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def before_create(self, obj, **kwargs):
        file = self.req.files['file']
        user = self.get_user(self.req)
        obj.operator_user = user.name
        obj.upload_file_path = settings.FILES['upload_to']
        obj.repeated_action = self.req_data.get('action', 'End date')
        obj.op_method = self.req_data.get('op_method', "Remove DIDs from any client")
        obj.client_id = self.req_data.get('client_id', None)
        obj.vendor_id = self.req_data.get('vendor_id', None)
        if obj.op_method == 'Remove DIDs from a specific client':
            if obj.client_id is None:
                raise Exception('client_id not provided')
            if model.Client.get(obj.client_id) is None:
                raise Exception('client_id {} not found'.format(obj.client_id))
        if obj.op_method == 'Remove DIDs from a specific vendor':
            if obj.vendor_id is None:
                raise Exception('vendor_id not provided')
            if model.Client.get(obj.vendor_id) is None or model.Client.get(obj.vendor_id).client_type != 'vendor':
                raise Exception('vendor_id {} not found'.format(obj.vendor_id))

        uuid = generate_uuid_str()()
        # obj.upload_orig_file = file.filename
        obj.orig_name = file.filename
        obj.upload_orig_file = uuid + '.csv'
        obj.upload_format_file = uuid + '.csv'
        file_name = obj.upload_file_path + '/' + obj.upload_format_file
        b = file.readlines()
        obj.num_records = len(b)
        log.info('Uploaded file rows:{}'.format(obj.num_records))
        local_file = open(file_name, 'wb')
        local_file.writelines(b)
        local_file.close()
        obj.status = 'Initial'
        obj.progress = 'Starting'
        return obj

    def after_create(self, object_id, req, resp, **kwargs):

        from kombu.exceptions import OperationalError
        from api_dnl.task.did_import_file import did_import_file_delete
        try:
            ret = did_import_file_delete.delay(object_id)
            log.debug('did_import_file_delete scheduled {}'.format(ret))
        except OperationalError:
            log.debug('did_import_file_delete start without celery')
            did_import_file_delete(object_id)


class DidNumberDeleteTaskResource(DnlResource):
    model_class = model.DidNumberDeleteTask
    scheme_class = DidNumberDeleteTaskScheme
    scheme_class_get = DidNumberDeleteTaskSchemeGet
    scheme_class_modify = DidNumberDeleteTaskSchemeModify
    entity = 'DidNumberDeleteTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_delete_operation = False
    has_modify_operation = False


class DidNumberDeleteTaskLogGet(DnlResource):
    model_class = model.DidNumberDeleteTask
    scheme_class = ExportGetScheme
    scheme_class_get = ExportGetScheme
    entity = 'DidNumberDeleteTask log'
    id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = (DEFAULT_SECURITY)
    restrict = ()
    # no_auth_needed = True

    def get_spec_info(self):
        spec = super(DidNumberDeleteTaskLogGet, self).get_spec_info()
        spec['get']['produces'] = ['application/json', 'text/csv', 'application/xls']
        return spec

    def on_get(self, req, resp, **kwargs):
        try:
            if not check_context(self, req, resp, **kwargs):
                self.set_response(resp, responses.ForbiddenErrorResponse())
                return
            try:
                _id = int(kwargs['id'])
            except:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            obj = self.get_object(resp, self.model_class, **kwargs)
            if not obj:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            if obj:
                if obj.status == ('Initial', 'In Process', 'Copy To DB'):
                    self.set_response(resp,
                                      OperationErrorResponse('DidNumberDeleteTask in progress!'))
                    resp.status = falcon.HTTP_404
                    return
                errors = obj.progress.split('IMPORT WARNINGS:')[-1]
                resp.data = errors.encode('UTF-8')
                resp.content_type = 'text/txt'
                resp.status = falcon.HTTP_200
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class DidNumberDeleteTaskList(DnlList):
    scheme_class = DidNumberDeleteTaskSchemeGet
    model_class = model.DidNumberDeleteTask
    entity_plural = 'DidNumberDeleteTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class

        return filt, ret


# endregion ---DidNumberDeleteTask---

# region +++DidNumberAssignTask+++
class DidNumberAssignTaskCreate(DnlCreate):
    scheme_class = DidNumberAssignTaskScheme
    model_class = model.DidNumberAssignTask
    entity = 'DidNumberAssignTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = (
            {'name': 'file', 'in': 'formData', 'description': 'File to upload', 'required': True, 'type': 'file'},
            {'name': 'client_id', 'in': 'formData', 'description': 'Specified client_id', 'required': False,
             'type': 'integer'},
            {'name': 'client_billing_rule_id', 'in': 'formData', 'description': 'Specified client_id',
             'required': False,
             'type': 'integer'},
            {'name': 'action', 'in': 'formData', "type": "string", "enum": ['End date', 'Replace']},
        )
        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          # self.scheme_class.get_object_created_response(entity=self.entity),
                          responses.ObjectCreatedResponse(data_key='object_uuid', scheme=schemes.ObjectCreatedUuidAsPk),
                          SuccessResponseJustOk()

                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def before_create(self, obj, **kwargs):
        file = self.req.files['file']
        user = self.get_user(self.req)
        obj.operator_user = user.name
        obj.upload_file_path = settings.FILES['upload_to']
        obj.repeated_action = self.req_data.get('action', 'End date')
        obj.client_id = self.req_data.get('client_id', None)
        obj.client_billing_rule_id = self.req_data.get('client_billing_rule_id', None)

        uuid = generate_uuid_str()()
        # obj.upload_orig_file = file.filename
        obj.orig_name = file.filename
        obj.upload_orig_file = uuid + '.csv'
        obj.upload_format_file = uuid + '.csv'
        file_name = obj.upload_file_path + '/' + obj.upload_format_file
        b = file.readlines()
        obj.num_records = len(b)
        log.info('Uploaded file rows:{}'.format(obj.num_records))
        local_file = open(file_name, 'wb')
        local_file.writelines(b)
        local_file.close()
        obj.status = 'Initial'
        obj.progress = 'Starting'
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        from kombu.exceptions import OperationalError
        from api_dnl.task.did_import_file import did_import_file_assign
        try:
            ret = did_import_file_assign.delay(object_id)
            log.debug('did_import_file_assign scheduled {}'.format(ret))
        except OperationalError:
            log.debug('did_import_file_assign start without celery')
            did_import_file_assign(object_id)


class DidNumberAssignTaskResource(DnlResource):
    model_class = model.DidNumberAssignTask
    scheme_class = DidNumberAssignTaskScheme
    scheme_class_get = DidNumberAssignTaskSchemeGet
    scheme_class_modify = DidNumberAssignTaskSchemeModify
    entity = 'DidNumberAssignTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_delete_operation = False
    has_modify_operation = False


class DidNumberAssignTaskList(DnlList):
    scheme_class = DidNumberAssignTaskSchemeGet
    model_class = model.DidNumberAssignTask
    entity_plural = 'DidNumberAssignTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class

        return filt, ret


# endregion ---DidNumberAssignTask---

# region +++DidNumberUploadTask+++
class DidNumberUploadTaskCreate(DnlCreate):
    scheme_class = DidNumberUploadTaskScheme
    model_class = model.DidNumberUploadTask
    entity = 'DidNumberUploadTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = (
            {'name': 'file', 'in': 'formData', 'description': 'File to upload', 'type': 'file'},
            {'name': 'paste', 'in': 'formData', 'description': 'numbers to upload', 'type': 'text'},
            {'name': 'range', 'in': 'formData',
             'description': 'range of numbers to upload for example(1231231231-1231232131)', 'type': 'text'},
            {'name': 'repeated_action', 'in': 'formData', "type": "string", "enum": ['Ignore', 'Overwrite']},
            {'name': 'op_method', 'in': 'formData', "type": "string", "enum": ["Upload", "Delete", "Release", "Assign"]},
            {'name': 'did_vendor_name', 'in': 'formData', "type": "string", 'required': False},
            {'name': 'did_client_name', 'in': 'formData', "type": "string", 'required': False},
            {'name': 'failover_id', 'in': 'formData', "type": "integer"},
            {'name': 'vendor_billing_rule_name', 'in': 'formData', "type": "string", 'required': False},
            {'name': 'client_billing_rule_name', 'in': 'formData', "type": "string", 'required': False},
            {'name': 'enable_for_clients', 'in': 'formData', "type": "string", "enum": ["Yes", "No"]},
        )
        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          # self.scheme_class.get_object_created_response(entity=self.entity),
                          responses.ObjectCreatedResponse(data_key='object_uuid', scheme=schemes.ObjectCreatedUuidAsPk),
                          SuccessResponseJustOk()

                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def on_post(self, req, resp, **kwargs):
        super().on_post(req, resp, **kwargs)
        self.resp = resp

    def before_create(self, obj, **kwargs):
        file = self.req.files['file'] if 'file' in self.req.files else None
        user = self.get_user(self.req)
        obj.operator_user = user.name

        obj.repeated_action = self.req_data.get('repeated_action', 'Overwrite')
        obj.upload_file_path = settings.FILES['upload_to']
        obj.op_method = self.req_data.get('op_method', 'Upload')
        obj.enable_for_clients = self.req_data.get('enable_for_clients', 'No')
        uuid = generate_uuid_str()()
        # obj.upload_orig_file = file.filename
        # obj.upload_orig_file = file.filename
        obj.upload_orig_file = uuid + '.csv'
        file_name = obj.upload_file_path + '/' + obj.upload_orig_file
        range_str = self.req_data.get('range', None)
        paste_str = self.req_data.get('paste', None)
        if file:
            b = file.readlines()
        elif paste_str:
            paste_arr = paste_str.split(',')
            b = [b'did\n'] + [(number + '\n').encode('UTF-8') for number in paste_arr]
        elif range_str:
            range_arr = range_str.split('-')
            b = [b'did\n'] + [(str(number) + '\n').encode('UTF-8') for number in
                              range(int(range_arr[0]), int(range_arr[1]) + 1)]
        else:
            raise ValidationError({'error': 'one of [paste, file] should not be null'})

        obj.num_records = len(b)
        log.info('Uploaded file rows:{}'.format(obj.num_records))
        if b[0].replace(b'\n', b'').replace(b'\r', b'') != b'did' and not b',' in b[0]:
            b = [b'did\n'] + b
        local_file = open(file_name, 'wb')
        local_file.writelines(b)
        local_file.close()
        obj.did_vendor_name = self.req_data.get('did_vendor_name', None)
        if obj.did_vendor_name:
            vendor = model.Client.filter(model.Client.name == obj.did_vendor_name).first()
            if not vendor or vendor.client_type != 'vendor':
                raise Exception("did_vendor_name: wrong vendor {}".format(obj.did_vendor_name))
        obj.vendor_billing_rule_name = self.req_data.get('vendor_billing_rule_name', None)
        if obj.vendor_billing_rule_name:
            vendor_billing_rule = model.DidBillingPlan.filter(
                model.DidBillingPlan.name == obj.vendor_billing_rule_name).first()
            if not vendor_billing_rule:
                raise Exception("vendor_billing_rule_name: wrong rule {}".format(obj.vendor_billing_rule_name))
        obj.did_client_name = self.req_data.get('did_client_name', None)
        if obj.did_client_name:
            client = model.Client.filter(model.Client.name == obj.did_client_name).first()
            if not client or client.client_type != 'client':
                raise Exception("did_client_name: wrong client {}".format(obj.did_client_name))
        obj.client_billing_rule_name = self.req_data.get('client_billing_rule_name', None)
        if obj.client_billing_rule_name:
            client_billing_rule = model.DidBillingPlan.filter(
                model.DidBillingPlan.name == obj.client_billing_rule_name).first()
            if not client_billing_rule:
                raise Exception("client_billing_rule_name: wrong rule {}".format(obj.client_billing_rule_name))
        if obj.did_client_name and not obj.client_billing_rule_name:
            raise Exception("if client is selected client billing rule should be seleted as well.")
        obj.upload_format_file = obj.upload_orig_file
        if obj.did_vendor_name or obj.vendor_billing_rule_name or obj.did_client_name or obj.client_billing_rule_name:
            obj.status = 'In Process'
        else:
            obj.status = 'Initial'
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        from .tasks import do_did_number_upload_task_preprocess
        from kombu.exceptions import OperationalError
        
        failover_id = self.req_data.get('failover_id', None)
        obj = self.model_class.get(object_id)
        if obj.status == 'In Process':
            try:
                do_did_number_upload_task_preprocess.delay(object_id, failover_id=failover_id)
            except OperationalError as e:
                do_did_number_upload_task_preprocess(object_id, failover_id=failover_id)


class DidNumberUploadTaskResource(DnlResource):
    model_class = model.DidNumberUploadTask
    scheme_class = DidNumberUploadTaskScheme
    scheme_class_get = DidNumberUploadTaskSchemeGet
    scheme_class_modify = DidNumberUploadTaskSchemeModify
    entity = 'DidNumberUploadTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_delete_operation = False
    has_modify_operation = False


class DidNumberUploadTaskLogGet(DnlResource):
    model_class = model.DidNumberUploadTask
    scheme_class = ExportGetScheme
    scheme_class_get = ExportGetScheme
    entity = 'DidNumberUploadTask log'
    id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = (DEFAULT_SECURITY)
    restrict = ()
    # no_auth_needed = True

    def get_spec_info(self):
        spec = super(DidNumberUploadTaskLogGet, self).get_spec_info()
        spec['get']['produces'] = ['application/json', 'text/csv', 'application/xls']
        return spec

    def on_get(self, req, resp, **kwargs):
        try:
            self.init_req(req)
            if not check_context(self, req, resp, **kwargs):
                self.set_response(resp, responses.ForbiddenErrorResponse())
                return
            try:
                _id = int(kwargs['id'])
            except:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            obj = self.get_object(resp, self.model_class, **kwargs)
            if not obj:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            if obj:
                if obj.status == ('Initial', 'In Process', 'Copy To DB'):
                    self.set_response(resp,
                                      OperationErrorResponse('DidNumberUploadTask in progress!'))
                    resp.status = falcon.HTTP_404
                    return
                file_path = obj.result_file_path + '/did_upload.log'
                if not os.path.exists(file_path):
                    self.set_response(resp, OperationErrorResponse('file was cleaned or not generated on the server!'))
                    resp.status = falcon.HTTP_404
                    return
                file_name = 'did_upload.log'
                resp.append_header('Content-Disposition', 'attachment; filename="{}"'.format(file_name))
                file = open(file_path, 'rt')
                resp.data = file.read().encode('UTF-8')
                resp.content_type = 'text/txt'
                resp.status = falcon.HTTP_200
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class DidNumberUploadTaskList(DnlList):
    scheme_class = DidNumberUploadTaskSchemeGet
    model_class = model.DidNumberUploadTask
    entity_plural = 'DidNumberUploadTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class

        return filt, ret


# endregion ---DidNumberUploadTask---


# region +++CodeDeckImportTask+++
class CodeDeckImportTaskCreate(DnlCreate):
    scheme_class = CodeDeckImportTaskScheme
    model_class = model.CodeDeckImportTask
    entity = 'CodeDeckImportTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = (
            {'name': 'file', 'in': 'formData', 'description': 'File to upload', 'type': 'file'},
            {'name': 'redup_in_code_deck_table_action', 'in': 'formData', "type": "string",
             "enum": ['reject entire import', 'skip the record', 'overwrite existing record']},
            {'name': 'redup_in_file_action', 'in': 'formData', "type": "string",
             "enum": ['reject entire import', 'skip the record', 'overwrite existing record']},
            {'name': 'op_method', 'in': 'formData', "type": "string", "enum": ["Upload", "Delete", "Release"]},
            {'name': 'delete_all', 'in': 'formData', "type": "string", "enum": ["Yes", "No"]},
            {'name': 'code_deck_id', 'in': 'formData', "type": "integer"},

        )
        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          # self.scheme_class.get_object_created_response(entity=self.entity),
                          responses.ObjectCreatedResponse(data_key='object_uuid', scheme=schemes.ObjectCreatedUuidAsPk),
                          SuccessResponseJustOk()

                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def before_create(self, obj, **kwargs):
        file = self.req.files['file'] if 'file' in self.req.files else None
        user = self.get_user(self.req)
        obj.operator_user = user.name

        obj.redup_in_code_deck_table_action = self.req_data.get('redup_in_code_deck_table_action', 'skip the record')
        obj.redup_in_file_action = self.req_data.get('redup_in_file_action', 'skip the record')

        obj.op_method = self.req_data.get('op_method', 'Upload')
        delete_all = self.req_data.get('delete_all', 'No')
        obj.delete_all = delete_all == 'Yes'
        upload_file_path = settings.FILES['upload_to']
        uuid = generate_uuid_str()()
        obj.orig_import_filename = file.filename
        # obj.upload_orig_file = file.filename
        obj.format_import_filename = upload_file_path + '/' + uuid + '.csv'
        file_name = obj.format_import_filename
        if file:
            b = file.readlines()
        else:
            raise ValidationError({'error': 'no file provided'})

        obj.num_records = len(b)
        log.info('Uploaded file rows:{}'.format(obj.num_records))

        local_file = open(file_name, 'wb')
        local_file.writelines(b)
        local_file.close()
        obj.status = 'Initial'

        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        from .task.code_deck_update import do_code_deck_import_preprocess
        from kombu.exceptions import OperationalError
        obj = self.model_class.get(object_id)
        if obj.status == 'In Process':
            try:
                do_code_deck_import_preprocess.delay(object_id)
            except OperationalError as e:
                do_code_deck_import_preprocess(object_id)


class CodeDeckImportTaskResource(DnlResource):
    model_class = model.CodeDeckImportTask
    scheme_class = CodeDeckImportTaskScheme
    scheme_class_get = CodeDeckImportTaskSchemeGet
    scheme_class_modify = CodeDeckImportTaskSchemeModify
    entity = 'CodeDeckImportTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_delete_operation = False
    has_modify_operation = False


class CodeDeckImportTaskLogGet(DnlResource):
    model_class = model.CodeDeckImportTask
    scheme_class = ExportGetScheme
    scheme_class_get = ExportGetScheme
    entity = 'CodeDeckImportTask log'
    id_field = 'id'
    has_modify_operation = False
    has_delete_operation = False
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec_info(self):
        spec = super(CodeDeckImportTaskLogGet, self).get_spec_info()
        spec['get']['produces'] = ['application/json', 'text/csv', 'application/xls']
        return spec

    def on_get(self, req, resp, **kwargs):
        try:
            try:
                _id = int(kwargs['id'])
            except:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            obj = self.get_object(resp, self.model_class, **kwargs)
            if not obj:
                self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                return
            if obj:
                if obj.status == ('Initial', 'In Process', 'Copy To DB'):
                    self.set_response(resp,
                                      OperationErrorResponse('CodeDeckImportTask in progress!'))
                    resp.status = falcon.HTTP_404
                    return
                file_path = obj.import_log_filename
                if file_path is None or not os.path.exists(file_path):
                    self.set_response(resp, OperationErrorResponse('import log file not generated by backend!'))
                    resp.status = falcon.HTTP_404
                    return
                file_name = 'code_import.log'
                resp.append_header('Content-Disposition', 'attachment; filename="{}"'.format(file_name))
                file = open(file_path, 'rt')
                resp.data = file.read().encode('UTF-8')
                resp.content_type = 'text/txt'
                resp.status = falcon.HTTP_200
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


class CodeDeckImportTaskList(DnlList):
    scheme_class = CodeDeckImportTaskSchemeGet
    model_class = model.CodeDeckImportTask
    entity_plural = 'CodeDeckImportTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class

        return filt, ret


# endregion ---CodeDeckImportTask---

#

# region +++Watchdog+++

class WatchdogServerStatusGet(CustomGetAction):
    description = "Get status of Server with Watchdog"
    path_parameters = ({'name': 'server_ip', 'description': 'server to get info about'},)
    allow_methods = ["get"]

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        params = dict(parse_qsl(req.query_string))
        try:
            url = 'http://{}:11400/status'.format(kwargs['server_ip'])
            log.debug('Watchdog GET url: {} params:{}'.format(url, params))
            ret = requests.get(url)
            log.debug('Watchdog GET status:{} response:{}'.format(ret.status_code, resp.body))
            if 'Content-type' in ret.headers:
                resp.content_type = ret.headers['Content-type']
            if 'Content-Disposition' in ret.headers:
                resp.set_header('Content-Disposition', ret.headers['Content-Disposition'])
            if 'Content-Length' in ret.headers:
                resp.set_header('Content-Length', ret.headers['Content-Length'])
            if 'Date' in ret.headers:
                resp.set_header('Date', ret.headers['Date'])
            resp.body = ret.content
            resp.status = str(ret.status_code)
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


class WatchdogServiceAction(CustomPostAction):
    scheme_class = WatchdogServiceActionScheme
    description = "start/stop/restart service of server"
    path_parameters = ({'name': 'server_ip', 'description': 'server to get info about'},
                       {'name': 'service', 'description': 'service to do some action'},)
    query_parameters = [{"name": "action", "enum": ['start', 'stop', 'restart'], 'required': True}]
    allow_methods = ["post"]

    def get_spec(self):
        return swagger.specify.get_spec(
            method='post', description='start/stop/restart service of server',
            path_parameters=self.path_parameters,
            query_parameters=self.query_parameters,
            responses=(
                responses.SuccessResponseObjectsList(payload_scheme_items=self.scheme_class),
                responses.AttributeNotExitsErrorResponse()
            ),
            security=self.get_security(method='post')
        )

    def on_post(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        params = dict(parse_qsl(req.query_string))
        try:
            action = params.get('action', 'start')
            url = 'http://{}:11400/{}/{}'.format(kwargs['server_ip'], kwargs['service'], action)
            log.debug('Watchdog GET url: {} params:{}'.format(url, params))
            log.debug(f"SENDING POST REQUEST TO {url}")
            ret = requests.post(url)
            log.debug('Watchdog GET status:{} response:{}'.format(ret.status_code, ret.text))
            if 'Content-type' in ret.headers:
                resp.content_type = ret.headers['Content-type']
            if 'Content-Disposition' in ret.headers:
                resp.set_header('Content-Disposition', ret.headers['Content-Disposition'])
            if 'Content-Length' in ret.headers:
                resp.set_header('Content-Length', ret.headers['Content-Length'])
            if 'Date' in ret.headers:
                resp.set_header('Date', ret.headers['Date'])
            resp.body = ret.content
            resp.status = str(ret.status_code)
            if str(ret.status_code) == '500' and action == 'stop':
                ret = requests.post(url)
                response_dict = json.loads(ret.content.decode('utf-8'))
                if str(response_dict.get('status')) in ('Service is not running', 'Failed to stop service'):
                    resp.body = json.dumps({
                        "code": 200,
                        "error": None,
                        "status": "Service has stopped"
                    })
                    resp.status = '200'
            server = model.VoipGateway.filter(model.VoipGateway.lan_ip == kwargs['server_ip']).first()
            server_name = server.name if server else kwargs['server_ip']
            log_ev = model.WatchdogSystemdEvents()
            log_ev.server_name = server_name
            log_ev.service = kwargs['service']
            log_ev.event = action + 'ed'
            log_ev.unit = kwargs['server_ip']
            log_ev.message = resp.body
            log_ev.save()
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


# endregion ---Watchdog---

# region +++NumberAnalytics+++

class NumberAnalyticsGet(CustomGetAction):
    description = "Get Number Analytics"
    path_parameters = ({'name': 'number', 'description': 'phone number without tech prefix'},)
    allow_methods = ["get"]

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        params = dict(parse_qsl(req.query_string))
        try:
            number = kwargs['number']
            obj = model.VoipGateway.filter().first()
            api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
            log.debug('VoipGatewayCallStats swith {} logged in'.format(obj.id))
            sw_data = api._api_call('lerg_db_search {}'.format(number)).decode('utf-8')
            head = 'f1,f2,f3,country,state,lata,f4,operating_company,ocn,rate_center,f5'.split(',')
            ret1 = dict(zip(head, [''] * len(head)))
            if ',' in sw_data:
                ret1 = dict(zip(head, sw_data.split(',')))

            sw_data = api._api_call('spamdb_youmail_search {}'.format(number)).decode('utf-8')
            head = 'spam_score,unlawful,fraud_tcpa_probability,fraud_probability'.split(',')
            ret2 = dict(zip(head, [''] * len(head)))
            if ',' in sw_data:
                ret2 = dict(zip(head, sw_data.split(',')))

            ret3 = {}
            for f in ('ftc', 'dno', 'dnc'):
                sw_data = api._api_call(f"spamdb_{f}_search {number}").decode('utf-8')
                ret3[f] = sw_data

            ret = dict(**ret1, **ret2, **ret3)
            for temp_field in ('f1', 'f2', 'f3', 'f4', 'f5',):
                if temp_field in ret:
                    del ret[temp_field]
            resp.body = json.dumps(ret)
            resp.status = falcon.HTTP_200
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None

# endregion ---NumberAnalytics---


class CheckLergDb(resources.CustomAction):
    scheme_class = CheckLergDbScheme
    model_class = model.ShakenStiSpConf
    entity_plural = 'CheckLergDb'
    path_parameters = ()
    body_parameters = ('Number', CheckLergDbScheme)
    security = (DEFAULT_SECURITY)
    restrict = ()
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        scheme = self.scheme_class().load(req.data)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False

        lst = [gw for gw in model.VoipGateway.query() if gw._connected]
        if len(lst) == 0:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Connected voip gateway not found'}))
            return False
        obj = lst[0]

        if req.data and req.data['number']:
            try:
                api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
                log.debug('VoipGatewayCallStats switch {} logged in'.format(obj.id))
                result = api.lerg_db_search(req.data['number'])

                self.set_response(resp, responses.SuccessResponseObjectInfo(data=result))
                return False
            except Exception as e:
                self.set_response(resp, OperationErrorResponse(e))
                return False
        else:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False


class CheckDnc(resources.CustomAction):
    scheme_class = CheckDncScheme
    model_class = model.ShakenStiSpConf
    entity_plural = 'CheckDnc'
    path_parameters = ()
    body_parameters = ('Number', CheckDncScheme)
    security = (DEFAULT_SECURITY)
    restrict = ()
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        scheme = self.scheme_class().load(req.data)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False
        
        lst = [gw for gw in model.VoipGateway.query() if gw._connected]
        if len(lst) == 0:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Connected voip gateway not found'}))
            return False
        obj = lst[0]

        if req.data and req.data['number']:
            try:
                api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
                log.debug('VoipGatewayCallStats switch {} logged in'.format(obj.id))
                result = api.spamdb_dnc_search(req.data['number'])
                
                self.set_response(resp, responses.SuccessResponseObjectInfo(data=result))
                return False
            except Exception as e:
                self.set_response(resp, OperationErrorResponse(e))
                return False
        else:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False


class CheckDno(resources.CustomAction):
    scheme_class = CheckDnoScheme
    model_class = model.ShakenStiSpConf
    entity_plural = 'CheckDno'
    path_parameters = ()
    body_parameters = ('Number', CheckDnoScheme)
    security = (DEFAULT_SECURITY)
    restrict = ()
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        scheme = self.scheme_class().load(req.data)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False
        
        lst = [gw for gw in model.VoipGateway.query() if gw._connected]
        if len(lst) == 0:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Connected voip gateway not found'}))
            return False
        obj = lst[0]

        if req.data and req.data['number']:
            try:
                api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
                log.debug('VoipGatewayCallStats switch {} logged in'.format(obj.id))
                result = api.spamdb_dno_search(req.data['number'])
                
                self.set_response(resp, responses.SuccessResponseObjectInfo(data=result))
                return False
            except Exception as e:
                self.set_response(resp, OperationErrorResponse(e))
                return False
        else:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False


class CheckYoumail(resources.CustomAction):
    scheme_class = CheckYoumailScheme
    model_class = model.ShakenStiSpConf
    entity_plural = 'CheckYoumail'
    path_parameters = ()
    body_parameters = ('Number', CheckYoumailScheme)
    security = (DEFAULT_SECURITY)
    restrict = ()
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        scheme = self.scheme_class().load(req.data)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False

        lst = [gw for gw in model.VoipGateway.query() if gw._connected]
        if len(lst) == 0:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Connected voip gateway not found'}))
            return False
        obj = lst[0]

        if req.data and req.data['number']:
            try:
                api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
                log.debug('VoipGatewayCallStats switch {} logged in'.format(obj.id))
                result = api.spamdb_youmail_search(req.data['number'])

                self.set_response(resp, responses.SuccessResponseObjectInfo(data=result))
                return False
            except Exception as e:
                self.set_response(resp, OperationErrorResponse(e))
                return False
        else:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False


class CheckFtc(resources.CustomAction):
    scheme_class = CheckFtcScheme
    model_class = model.ShakenStiSpConf
    entity_plural = 'CheckFtc'
    path_parameters = ()
    body_parameters = ('Number', CheckFtcScheme)
    security = (DEFAULT_SECURITY)
    restrict = ()
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        scheme = self.scheme_class().load(req.data)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False

        lst = [gw for gw in model.VoipGateway.query() if gw._connected]
        if len(lst) == 0:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Connected voip gateway not found'}))
            return False
        obj = lst[0]

        if req.data and req.data['number']:
            try:
                api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
                log.debug('VoipGatewayCallStats switch {} logged in'.format(obj.id))
                result = api.spamdb_ftc_search(req.data['number'])

                self.set_response(resp, responses.SuccessResponseObjectInfo(data=result))
                return False
            except Exception as e:
                self.set_response(resp, OperationErrorResponse(e))
                return False
        else:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False


class CheckLrn(resources.CustomAction):
    scheme_class = CheckLrnScheme
    model_class = model.ShakenStiSpConf
    entity_plural = 'CheckLrn'
    path_parameters = ()
    body_parameters = ('Number', CheckLrnScheme)
    security = (DEFAULT_SECURITY)
    restrict = ()
    method = 'post'

    def on_post(self, req, resp, **kwargs):
        return self.proceed(req, resp, **kwargs)

    def apply(self, obj, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False

        scheme = self.scheme_class().load(req.data)
        if scheme.errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False

        lst = [gw for gw in model.VoipGateway.query() if gw._connected]
        if len(lst) == 0:
            self.set_response(resp, responses.ObjectNotFoundErrorResponse(
                data={'message': 'Connected voip gateway not found'}))
            return False
        obj = lst[0]

        if req.data and req.data['number']:
            try:
                api = get_dnl_active_calls_session(obj.lan_ip, obj.lan_port)
                log.debug('VoipGatewayCallStats switch {} logged in'.format(obj.id))
                result = api.lrn_search(req.data['number'])

                self.set_response(resp, responses.SuccessResponseObjectInfo(data=result))
                return False
            except Exception as e:
                self.set_response(resp, OperationErrorResponse(e))
                return False
        else:
            self.set_response(resp, responses.ValidationErrorResponse(data=scheme.errors))
            return False

# region +++FrundDetection+++
class FrundDetectionCreate(DnlCreate):
    scheme_class = FrundDetectionScheme
    model_class = model.FrundDetection
    entity = 'FrundDetection'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        # obj.created_by=user.name
        # obj.created_on=datetime.now(UTC)
        return obj


class FrundDetectionResource(DnlResource):
    model_class = model.FrundDetection
    scheme_class = FrundDetectionScheme
    scheme_class_get = FrundDetectionSchemeGet
    scheme_class_modify = FrundDetectionSchemeModify
    entity = 'FrundDetection'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class FrundDetectionList(DnlList):
    scheme_class = FrundDetectionSchemeGet
    model_class = model.FrundDetection
    entity_plural = 'FrundDetections'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


class FrundDetectionHistoryList(DnlList):
    scheme_class = FrundDetectionHistorySchemeGet
    model_class = model.FrundDetectionHistory
    entity_plural = 'FrundDetectionHistorys'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---FrundDetection---

# region +++DidMrcInfo+++

def query_did_charge(start_date, end_date, client, vendor, did):
    from sqlalchemy import DateTime
    params = ';'.join([str(start_date), str(end_date), str(client), str(vendor), str(did)])
    clsd = model.DidChargeDetail
    rel = model.DidBillingRel  # v6
    # rel = DidBillingBrief
    pln = model.DidBillingPlan
    rep = model.DidReport
    res = model.Resource
    dids = None
    if did:
        dids = [i for i in did.split(',')]

    trunks = None
    client_id = None
    if client:
        client_id = [int(i) for i in client.split(',')]
        trunks = [r.resource_id for r in res.filter(res.client_id.in_(client_id)).all()]

    vendor_trunks = None
    if vendor:
        vendor_id = [int(i) for i in vendor.split(',')]
        vendor_trunks = [r.resource_id for r in res.filter(res.client_id.in_(vendor_id)).all()]

    exists = clsd.filter(clsd.params == params).first()
    if exists is not None:
        clsd.filter(clsd.params == params).delete(synchronize_session='fetch')
    old = clsd.filter(clsd.created_on < datetime.now(UTC) - timedelta(days=30)).first()
    if old is not None:
        clsd.filter(clsd.created_on < datetime.now(UTC) - timedelta(days=30)).delete(synchronize_session='fetch')
    ret = clsd.session().execute(clsd.__table__.insert() \
        .from_select(
        ['params', 'did_number', 'client_billing_plan_id', 'client_trunk_id', 'vendor_trunk_id', 'nrc', 'mrc',
         'pay_type',
         'start_date', 'end_date'],
        select([literal(params), rel.did, rel.buy_billing_plan_id, rel.client_res_id, rel.vendor_res_id,
                case([(rel.start_date >= start_date, pln.did_price)], else_=0.0),
                pln.monthly_charge,
                pln.pay_type,
                func.greatest(cast_(rel.start_date, DateTime), start_date),
                func.least(cast_(rel.end_date, DateTime), end_date),
                ]
               ). \
            where(and_(or_(rel.end_date.is_(None), rel.end_date > start_date),
                       rel.start_date <= end_date,
                       rel.client_res_id.in_(trunks) if trunks else True,
                       rel.vendor_res_id.in_(vendor_trunks) if vendor_trunks else True,
                       rel.did.in_(dids) if dids else True,
                       pln.id == rel.buy_billing_plan_id))
    )
    )
    # print(ret)

    q = clsd.__table__.update().values(mrc_number=
                                       case([(clsd.pay_type == 0,
                                              func.extract('isoyear', clsd.end_date) * 52 +
                                              func.extract('week', clsd.end_date) - func.extract('week',
                                                                                                 clsd.start_date)
                                              - func.extract('isoyear', clsd.start_date) * 52
                                              )],
                                            else_=func.extract('month',
                                                               clsd.end_date + timedelta(days=1)) - func.extract(
                                                'month', clsd.start_date)
                                                  + func.extract('year', clsd.end_date + timedelta(
                                                days=1)) * 12 - func.extract('year', clsd.start_date) * 12
                                            )
                                       ).where(clsd.params == params)
    # print(str(q))
    ret = clsd.session().execute(q)
    # print(ret)
    r = select([rep.did, clsd.start_date, clsd.end_date, func.sum(rep.not_zero_calls).label('attempts'),
                func.sum(rep.egress_bill_time / 60.0).label('minutes'),
                func.sum(rep.egress_call_cost).label('call_charge')]).where(
        and_(rep.report_time >= clsd.start_date,
             rep.report_time < clsd.end_date + timedelta(days=1),
             rep.not_zero_calls > 0,
             rep.egress_client_id.in_(client_id) if client_id else True,
             rep.ingress_id.in_(vendor_trunks) if vendor_trunks else True, )). \
        group_by(rep.did, clsd.start_date, clsd.end_date).alias('rep')
    q = clsd.__table__.update().values(attempts=r.c.attempts,
                                       minutes=r.c.minutes,
                                       call_charge=r.c.call_charge,
                                       ).where(and_(clsd.did_number == r.c.did,
                                                    clsd.start_date == r.c.start_date,
                                                    clsd.end_date == r.c.end_date
                                                    ))
    # print(str(q))
    ret = clsd.session().execute(q)
    # print(ret)
    clsd.session().commit()
    return clsd.filter(clsd.params == params)


def query_did_cost(start_date, end_date, client, vendor, did):
    from sqlalchemy import DateTime
    params = ';'.join([str(start_date), str(end_date), str(client), str(vendor), str(did)])
    clsd = model.DidCostDetail
    rel = model.DidBillingRel  # v6
    # rel = DidBillingBrief
    pln = model.DidBillingPlan
    rep = model.DidReport
    res = model.Resource
    dids = None
    if did:
        dids = [i for i in did.split(',')]

    trunks = None
    client_id = None
    if client:
        client_id = [int(i) for i in client.split(',')]
        trunks = [r.resource_id for r in res.filter(res.client_id.in_(client_id)).all()]

    vendor_trunks = None
    if vendor:
        vendor_id = [int(i) for i in vendor.split(',')]
        vendor_trunks = [r.resource_id for r in res.filter(res.client_id.in_(vendor_id)).all()]

    exists = clsd.filter(clsd.params == params).first()
    if exists is not None:
        clsd.filter(clsd.params == params).delete(synchronize_session='fetch')
    old = clsd.filter(clsd.created_on < datetime.now(UTC) - timedelta(days=30)).first()
    if old is not None:
        clsd.filter(clsd.created_on < datetime.now(UTC) - timedelta(days=30)).delete(synchronize_session='fetch')
    ret = clsd.session().execute(clsd.__table__.insert() \
        .from_select(
        ['params', 'did_number', 'client_billing_plan_id', 'client_trunk_id', 'vendor_trunk_id', 'nrc', 'mrc',
         'pay_type',
         'start_date', 'end_date'],
        select([literal(params), rel.did, rel.buy_billing_plan_id, rel.client_res_id, rel.vendor_res_id,
                case([(rel.start_date >= start_date, pln.did_price)], else_=0.0),
                pln.monthly_charge,
                pln.pay_type,
                func.greatest(cast_(rel.start_date, DateTime), start_date),
                func.least(cast_(rel.end_date, DateTime), end_date),
                ]
               ). \
            where(and_(or_(rel.end_date.is_(None), rel.end_date > start_date),
                       rel.start_date <= end_date,
                       rel.client_res_id.in_(trunks) if trunks else True,
                       rel.vendor_res_id.in_(vendor_trunks) if vendor_trunks else True,
                       rel.did.in_(dids) if dids else True,
                       pln.id == rel.buy_billing_plan_id))
    )
    )
    # print(ret)

    q = clsd.__table__.update().values(mrc_number=
                                       case([(clsd.pay_type == 0,
                                              func.extract('isoyear', clsd.end_date) * 52 +
                                              func.extract('week', clsd.end_date) - func.extract('week',
                                                                                                 clsd.start_date)
                                              - func.extract('isoyear', clsd.start_date) * 52
                                              )],
                                            else_=func.extract('month',
                                                               clsd.end_date + timedelta(days=1)) - func.extract(
                                                'month', clsd.start_date)
                                                  + func.extract('year', clsd.end_date + timedelta(
                                                days=1)) * 12 - func.extract('year', clsd.start_date) * 12
                                            )
                                       ).where(clsd.params == params)
    # print(str(q))
    ret = clsd.session().execute(q)
    # print(ret)
    r = select([rep.did, func.sum(rep.not_zero_calls).label('attempts'),
                func.sum(rep.egress_bill_time / 60.0).label('minutes'),
                func.sum(rep.ingress_call_cost).label('vendor_cost'),
                func.sum(rep.egress_call_cost).label('client_cost')]). \
        where(and_(rep.report_time >= start_date, rep.report_time <= end_date,
                   rep.egress_client_id.in_(client_id) if client_id else True,
                   rep.ingress_id.in_(vendor_trunks) if vendor_trunks else True, )).group_by(
        rep.did).alias('rep')
    q = clsd.__table__.update().values(attempts=r.c.attempts,
                                       minutes=r.c.minutes,
                                       vendor_cost=func.coalesce(r.c.vendor_cost, 0),
                                       client_cost=func.coalesce(r.c.client_cost, 0),
                                       ).where(and_(clsd.did_number == r.c.did, rep.not_zero_calls > 0,
                                                    ))
    # print(str(q))
    ret = clsd.session().execute(q)
    # print(ret)
    clsd.session().commit()
    return clsd.filter(clsd.params == params)


class DidUsageReport(DnlList):
    scheme_class = DidChargeDetailSchemeGet
    model_class = model.DidReport
    entity_plural = 'DidChargeDetails'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        if ordering['by'] == 'client':
            ordering['by'] = 'client_name'
        if ordering['by'] == 'vendor':
            ordering['by'] = 'vendor_name'
        return ordering, query

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        start_date = parse_datetime(filtering.pop('start_date', None))
        errors = []
        if not start_date:
            errors.append('start_date is mandatory parameter')
        end_date = parse_datetime(filtering.pop('end_date', None))
        if not end_date:
            errors.append('end_date is mandatory parameter')
        client = filtering.pop('client', None)
        # if not client:
        #     errors.append('client is mandatory parameter')
        if errors:
            raise ValidationError(errors)

        vendor = filtering.pop('vendor', None)
        did = filtering.pop('did', None)
        client_id = None
        res = model.Resource
        if client:
            client_id = [int(i) for i in client.split(',')]
            trunks = [r.resource_id for r in res.filter(res.client_id.in_(client_id)).all()]

        vendor_trunks = None
        if vendor:
            vendor_id = [int(i) for i in vendor.split(',')]
            vendor_trunks = [r.resource_id for r in res.filter(res.client_id.in_(vendor_id)).all()]
        filt = {}
        ret = query_did_charge(start_date, end_date, client, vendor, did)
        return filt, ret

        # new ver
        rep = self.model_class
        r = select([rep.did, func.sum(rep.not_zero_calls).label('attempts'),
                    func.sum(rep.egress_bill_time / 60.0).label('minutes'),
                    func.sum(rep.egress_call_cost).label('call_charge')]).where(
            and_(rep.report_time >= start_date,
                 rep.report_time < end_date + timedelta(days=1),
                 rep.not_zero_calls > 0,
                 rep.egress_client_id.in_(client_id) if client_id else True,
                 rep.ingress_id.in_(vendor_trunks) if vendor_trunks else True, )). \
            group_by(rep.did).alias('rep')
        ret = rep.session().execute(r)
        return filt, ret


class DidCostReport(DnlList):
    scheme_class = DidCostDetailSchemeGet
    model_class = model.DidCostDetail
    entity_plural = 'DidCostDetails'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        if ordering['by'] == 'client':
            ordering['by'] = 'client_name'
        if ordering['by'] == 'vendor':
            ordering['by'] = 'vendor_name'
        return ordering, query

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        start_date = filtering.pop('start_date', None)
        errors = []
        if not start_date:
            errors.append('start_date is mandatory parameter')
        end_date = filtering.pop('end_date', None)
        if not end_date:
            errors.append('end_date is mandatory parameter')
        client = filtering.pop('client', None)
        # if not client:
        #     errors.append('client is mandatory parameter')
        if errors:
            raise ValidationError(errors)

        vendor = filtering.pop('vendor', None)
        did = filtering.pop('did', None)
        filt = {}
        ret = query_did_cost(start_date, end_date, client, vendor, did)
        return filt, ret


# endregion ---DidMrcInfo---

# region +++DidMrcInfo+++
# class DidMrcInfoList(DnlList):
#     scheme_class = DidMrcInfoSchemeGet
#     model_class = model.DidMrcInfo
#     entity_plural = 'DidMrcInfos'
#     path_parameters = ()
#     security = (DEFAULT_SECURITY)
#     restrict = ()
#
#     def modify_query_from_filtering_for_list(self, filtering, **kwargs):
#         filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
#         user = self.get_user(self.req)
#         if user.client_id:
#             cls = self.model_class
#             ret = ret.filter(cls.client_id == user.client_id)
#         return filt, ret
#

# endregion ---DidMrcInfo---
# # region +++DidSetupFee+++
# class DidSetupFeeList(DnlList):
#     scheme_class = DidSetupFeeSchemeGet
#     model_class = model.DidSetupFee
#     entity_plural = 'DidSetupFees'
#     path_parameters = ()
#     security = (DEFAULT_SECURITY)
#     restrict = ()
#
#     def modify_query_from_filtering_for_list(self, filtering, **kwargs):
#         filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
#         user = self.get_user(self.req)
#         if user.client_id:
#             cls = self.model_class
#             ret = ret.filter(cls.client_id == user.client_id)
#         return filt, ret
#
#
# # endregion ---DidSetupFee---

# region +++LergImportTask+++
class LergImportCreate(DnlCreate):
    model_class = model.LergImportTask
    scheme_class = LergImportTaskScheme
    scheme_class_get = LergImportTaskSchemeGet
    entity = 'import of Lerg file '
    id_field = 'uuid'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    body_params = ()

    def get_spec(self):
        additional_responses = (
                                   responses.OperationErrorResponse(data=errors.CommonErrors.PermissionError,
                                                                    description='Can\'t create file'),
                               ) + self.additional_responses

        ext_body_parameters = self.body_params or (
            {'name': 'file', 'in': 'formData', 'description': 'File to upload', 'required': True, 'type': 'file'},
        )

        return swagger.specify.get_spec(
            method='post', description='Creates new {}'.format(self.entity.lower()),
            consumes=['multipart/form-data'],
            path_parameters=self.path_parameters,
            responses=(
                          # self.scheme_class.get_object_created_response(entity=self.entity),
                          responses.ObjectCreatedResponse(data_key='object_uuid', scheme=schemes.ObjectCreatedUuidAsPk),
                          responses.SuccessResponseJustOk()

                      ) + additional_responses + self.get_additional_responses(method='post'),
            security=self.get_security(method='post'),
            # body_parameters=('{} to create'.format(self.entity), self.scheme_class),
            ext_body_parameters=ext_body_parameters
        )

    def before_create(self, obj, **kwargs):
        file = self.req.files['file']
        obj.uuid = generate_uuid_str()()
        user = self.get_user(self.req)
        obj.created_by = user.name
        obj.file = file.filename
        b = file.read()
        fsz = len(b)
        log.info('Uploaded file size:{}'.format(fsz))
        local_file = open(obj.file_name, 'wb')
        local_file.write(b)
        local_file.close()
        return obj

    def after_create(self, result, req, resp, **kwargs):
        from kombu.exceptions import OperationalError
        try:
            from task.lerg import do_lerg_import_file
            try:
                do_lerg_import_file.delay(result)
            except OperationalError as e:
                log.warning('import_file task not started: {}'.format(str(e)))
                do_lerg_import_file(result)
        except Exception as e:
            log.error('import_file task error: {}'.format(str(e)))
            pass


class LergImportList(DnlList):
    scheme_class = LergImportTaskSchemeGet
    model_class = model.LergImportTask
    entity_plural = 'LergImportTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# endregion +++LergImportTask+++
# region +++LergDownloadSchedule+++
class LergDownload(CustomPostAction):
    scheme_class = LergDownloadScheme
    body_parameters = ('lerg download', LergDownloadScheme)

    def on_post(self, req, resp, **kwargs):
        try:
            self.init_req(req)
            if not check_context(self, req, resp, **kwargs):
                return False
            include_ca = req.data.get('include_CA', False)
            ret = requests.get(
                'http://lerg.denovolab.com/lerg/download?countries={}'.format('US,CA' if include_ca else 'US'))
            resp.status = str(ret.status_code)
            resp.body = ret.content
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return False


class LergDownloadScheduleCreate(DnlCreate):
    scheme_class = LergDownloadScheduleScheme
    model_class = model.LergDownloadSchedule
    entity = 'LergDownloadSchedule'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def create_object(self, req, scheme, **kwargs):
        if 'include_CA' in req.data:
            include_CA = req.data['include_CA']
            del req.data['include_CA']
        else:
            raise ValidationError('include_CA not exists')

        req.data['url'] = 'http://lerg.denovolab.com/lerg/download?countries={}'.format('US,CA' if include_CA else 'US')
        return super(LergDownloadScheduleCreate, self).create_object(req, scheme, **kwargs)

    def after_create(self, object_id, req, resp, **kwargs):
        obj = model.LergDownloadSchedule.get(object_id)
        obj.url = req.data['url']
        obj.save()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.created_by = user.name
        obj.created_on = datetime.now(UTC)
        return obj


class LergDownloadScheduleResource(DnlResource):
    model_class = model.LergDownloadSchedule
    scheme_class = LergDownloadScheduleScheme
    scheme_class_get = LergDownloadScheduleSchemeGet
    scheme_class_modify = LergDownloadScheduleSchemeModify
    entity = 'LergDownloadSchedule'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class LergDownloadScheduleList(DnlList):
    scheme_class = LergDownloadScheduleSchemeGet
    model_class = model.LergDownloadSchedule
    entity_plural = 'LergDownloadSchedules'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
        # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---LergDownloadSchedule---


# region +++LawfulIntercept+++
class MediaAsrFilterCreate(DnlCreate):
    scheme_class = MediaAsrFilterScheme
    model_class = model.MediaAsrFilter
    entity = 'MediaAsrFilter'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class MediaAsrFilterResource(DnlResource):
    model_class = model.MediaAsrFilter
    scheme_class = MediaAsrFilterScheme
    scheme_class_get = MediaAsrFilterScheme
    scheme_class_modify = MediaAsrFilterScheme
    entity = 'MediaAsrFilter'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class MediaAsrFilterList(DnlList):
    scheme_class = MediaAsrFilterScheme
    model_class = model.MediaAsrFilter
    entity_plural = 'MediaAsrFilters'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class MediaCaptureFilterCreate(DnlCreate):
    scheme_class = MediaCaptureFilterScheme
    model_class = model.MediaCaptureFilter
    entity = 'MediaCaptureFilter'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class MediaCaptureFilterResource(DnlResource):
    model_class = model.MediaCaptureFilter
    scheme_class = MediaCaptureFilterScheme
    scheme_class_get = MediaCaptureFilterScheme
    scheme_class_modify = MediaCaptureFilterScheme
    entity = 'MediaCaptureFilter'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class MediaCaptureFilterList(DnlList):
    scheme_class = MediaCaptureFilterScheme
    model_class = model.MediaCaptureFilter
    entity_plural = 'MediaCaptureFilters'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class SignalCaptureFilterCreate(DnlCreate):
    scheme_class = SignalCaptureFilterScheme
    model_class = model.SignalCaptureFilter
    entity = 'SignalCaptureFilter'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


class SignalCaptureFilterResource(DnlResource):
    model_class = model.SignalCaptureFilter
    scheme_class = SignalCaptureFilterScheme
    scheme_class_get = SignalCaptureFilterScheme
    scheme_class_modify = SignalCaptureFilterScheme
    entity = 'SignalCaptureFilter'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class SignalCaptureFilterList(DnlList):
    scheme_class = SignalCaptureFilterScheme
    model_class = model.SignalCaptureFilter
    entity_plural = 'SignalCaptureFilters'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


# endregion ---LawfulIntercept---


# region +++LergDownloadTask+++

class LergDownloadTaskList(DnlList):
    scheme_class = LergDownloadTaskSchemeGet
    model_class = model.LergDownloadTask
    entity_plural = 'LergDownloadTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        return filt, ret


# endregion ---LergDownloadTask---

### end ###

# region SmsReport
class SmsReport(CustomGetAction):
    query_parameters = [
        {"name": "start_date", "type": "string", 'required': True, },
        {"name": "end_date", "type": "string", 'required': True, },
        {"name": "client_id", "type": "integer", },
        {"name": "vendor_id", "type": "integer", },
        {"name": "page", "type": "integer", },
        {"name": "per_page", "type": "integer", },
        {"name": "number", "type": "str", },
        {"name": "step", "description": "groupping interval", "enum": ['hour', 'day', 'month']}
    ]
    scheme_class = SmsReportScheme
    additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=SmsReportScheme),)
    model_class = model.Sms

    def on_get(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        try:
            user = self.get_user(self.req)
            params = dict(parse_qsl(req.query_string))
            client_id = int(params.get('client_id', 0))
            vendor_id = int(params.get('vendor_id', 0))
            number = params.get('number', None)
            if number and '*' in number:
                number = number.replace('*', '%')
            cls = self.model_class
            fmt = 'YYYY-MM-DD HH24:MI:00'

            if 'step' in params:
                step = params.get('step', 'hour')
                if step == 'hour':
                    fmt = 'YYYY-MM-DD HH24:00:00'
                if step == 'day':
                    fmt = 'YYYY-MM-DD'
                if step == 'month':
                    fmt = 'YYYY-MM'
                if step == 'year':
                    fmt = 'YYYY'
                if step == 'week':
                    fmt = 'WW'
            group_time = func.to_char(cls.created_on, fmt)
            q = cls.session().query(group_time.label('report_time'),
                                    cls.client_id,
                                    cls.client_name,
                                    cls.vendor_id,
                                    cls.vendor_name,
                                    func.count(cls.id.distinct()).label('attempt_count'),
                                    func.sum(case([(or_(cls.delivery_error == '000', cls.direction == 'received'), 1)],
                                                  else_=0)).label('success_count'),
                                    func.sum(case([(or_(cls.delivery_error == '000', cls.direction == 'received'), 0)],
                                                  else_=1)).label('failed_count'),
                                    ).filter(

                cls.created_on.between(params['start_date'], params['end_date']))
            if number:
                q = q.filter(or_(cls.sender.like(number), cls.receiver.like(number)))
            if client_id:
                q = q.filter(cls.client_id == client_id)

            if vendor_id:
                q = q.filter(cls.vendor_id == vendor_id)
            q = q.group_by(group_time, cls.client_id, cls.vendor_id).order_by(group_time, cls.client_id, cls.vendor_id)
            log.debug(str(q))
            objects_list = q.all()
            page = int(params.get('page', -1))
            per_page = int(params.get('per_page', 0))
            if page > -1 and per_page > 0:
                objects_list = objects_list[page * per_page:(page + 1) * per_page]
            total = len(objects_list)
            self.set_response(
                resp, responses.SuccessResponse(
                    data={
                        'items': self.scheme_class().dump(objects_list, many=True).data,
                        'total': total, 'page': page, 'per_page': per_page
                    },
                    scheme=schemes.ObjectScheme
                )
            )
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))


# endregion


# region DidApiAdminDisconnect
class DidApiAdminDisconnect(CustomPostAction):
    scheme_class = DidApiAdminDisconnectScheme
    path_parameters = ()
    # additional_responses = (responses.SuccessResponseObjectsList(payload_scheme_items=DidApiOrderLocalGetScheme),)
    body_parameters = ('Release list', scheme_class,)

    def on_post(self, req, resp, **kwargs):
        from api_dnl.task.did_disconnect import did_disconnect
        from kombu.exceptions import OperationalError
        # vendors = _get_all_vendors(True, 'local')
        # if not vendors:
        #     self.set_response(resp, responses.ObjectNotFoundErrorResponse())
        #     return
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            self.set_response(resp, responses.ForbiddenErrorResponse())
            return
        user = self.get_user(self.req)
        if not user.is_admin:
            self.set_response(resp, responses.UnAuthorizedErrorResponse())
            return

        params = req.data
        release_on_time = None

        # params['client_id'] = 'CLI_{}'.format(client_id)
        # params = dict(parse_qsl(req.query_string))
        errors_ = self.scheme_class().validate(params)

        if 'release_on_time' in params:
            release_on_time = parse_datetime(params['release_on_time']).replace(tzinfo=UTC).replace(microsecond=0)
            if release_on_time < datetime.now(UTC):
                release_on_time = None
        if errors_:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors_))
            return

        obj_id = None
        try:
            if release_on_time is None:
                obj = model.DidDisconnectTask(release_on_time=datetime.utcnow().replace(microsecond=0), data=params)
                obj_id = obj.save()
                try:
                    did_disconnect.delay(obj_id)
                    self.set_response(resp, responses.SuccessResponse(data={
                        'task_id': obj_id}, scheme=schemes.ObjectScheme))
                except OperationalError as e:
                    did_disconnect(obj_id)
                    self.set_response(resp, responses.SuccessResponse(data={
                        'task_id': obj_id, 'warning': 'api_dnl_worker does not run'}, scheme=schemes.ObjectScheme))
            else:
                obj = model.DidDisconnectTask(release_on_time=release_on_time, data=params)
                obj_id = obj.save()
                from api_dnl.utils.did_api import unprefix, unprefix_2
                for did_item in params["items"]:
                    number = unprefix_2(did_item['number'])
                    did_number = unprefix(did_item['number'])
                    cls = model.DidBillingRel
                    did = model.DidBillingRel.filter(
                        and_(or_(cls.did == number, cls.did == did_number), cls.end_date.is_(None)
                             )).first()
                    if did:
                        did.end_date = release_on_time
                        did.save()

                self.set_response(resp, responses.SuccessResponse(data={
                    'task_id': obj_id, 'warning': 'scheduled on {}'.format(release_on_time)},
                    scheme=schemes.ObjectScheme))
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None


class DidApiAdminDisconnectAll(CustomPostAction):
    scheme_class = DidApiAdminDisconnectAllScheme
    path_parameters = ()
    body_parameters = ('Release list', scheme_class,)

    def on_post(self, req, resp, **kwargs):
        from api_dnl.task.did_disconnect import did_disconnect
        from kombu.exceptions import OperationalError
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            self.set_response(resp, responses.ForbiddenErrorResponse())
            return
        user = self.get_user(self.req)
        if not user.is_admin:
            self.set_response(resp, responses.UnAuthorizedErrorResponse())
            return
        params = req.data
        release_on_time = None

        errors_ = self.scheme_class().validate(req.data)
        if 'release_on_time' in params:
            release_on_time = parse_datetime(params['release_on_time']).replace(tzinfo=UTC)
            if release_on_time < datetime.now(UTC):
                errors_['release_on_time'] = 'release_on_time should be future date'
        if errors_:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors_))
            return

        params = {'items': []}

        try:
            dids = model.DidRepository.filter().all()

            paste_dids = ','.join([did.did for did in dids])

            
            task_api = DidNumberUploadTaskCreate()
            req.data['paste'] = paste_dids
            req.files = {}
            # req.data['vendor_billing_rule_name'] = obj.vendor_billing_rule_name
            # req.data['did_vendor_name'] = obj.did_vendor_name
            req.data['op_method'] = 'Release'
            task_api.on_post(req, resp, **kwargs)
            resp.body = task_api.resp.body
            resp.status = task_api.resp.status
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
            return None

        # obj_id = None
        # try:
        #     if release_on_time is None:
        #         obj = model.DidDisconnectTask(release_on_time=datetime.now(), data=params)
        #         obj_id = obj.save()
        #         try:
        #             did_disconnect.delay(obj_id)
        #             self.set_response(resp, responses.SuccessResponse(data={
        #                 'task_id': obj_id}, scheme=schemes.ObjectScheme))
        #         except OperationalError as e:
        #             did_disconnect(obj_id)
        #             self.set_response(resp, responses.SuccessResponse(data={
        #                 'task_id': obj_id, 'warning': 'api_dnl_worker does not run'}, scheme=schemes.ObjectScheme))
        #     else:
        #         obj = model.DidDisconnectTask(release_on_time=release_on_time, data=params)
        #         obj_id = obj.save()
        #         self.set_response(resp, responses.SuccessResponse(data={
        #             'task_id': obj_id, 'warning': 'scheduled on {}'.format(release_on_time)},
        #             scheme=schemes.ObjectScheme))
        # except Exception as e:
        #     self.set_response(resp, OperationErrorResponse(e))
        #     return None


class DidDisconnectTaskList(DnlList):
    scheme_class = DidDisconnectTaskSchemeGet
    model_class = model.DidDisconnectTask
    entity_plural = 'DidDisconnectTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            raise Exception('allowed only for admins')
        return filt, ret


# endregion

# region +++ClientDidProduct+++
class ClientDidProductCreate(DnlCreate):
    scheme_class = ClientDidProductScheme
    model_class = model.ClientDidProduct
    entity = 'ClientDidProduct'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.created_by = user.name
        obj.created_on = datetime.now(UTC)
        return obj


class ClientDidProductResource(DnlResource):
    model_class = model.ClientDidProduct
    scheme_class = ClientDidProductScheme
    scheme_class_get = ClientDidProductSchemeGet
    scheme_class_modify = ClientDidProductSchemeModify
    entity = 'ClientDidProduct'
    id_field = 'client_id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_delete_operation = False

    def get_object(self, resp, model_class, **kwargs):
        obj = super(ClientDidProductResource, self).get_object(resp, model_class, **kwargs)
        if not obj:
            client_id = int(kwargs['client_id'])
            if model.Client.session().query(model.Client.client_id).filter(model.Client.client_id == client_id).first():
                obj = model_class(client_id=client_id)
                obj.save()
        return obj

    def before_update(self, obj, req):
        return obj


class ClientDidProductList(DnlList):
    scheme_class = ClientDidProductSchemeGet
    model_class = model.ClientDidProduct
    entity_plural = 'ClientDidProducts'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if user.user_type == 1 and user.client_id:
            cls = self.model_class
            ret = ret.filter(cls.client_id == user.client_id)
        if not user.is_admin:
            cls = self.model_class
            # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---ClientDidProduct---

# region +++DidProduct+++
class DidProductCreate(DnlCreate):
    scheme_class = DidProductScheme
    model_class = model.DidProduct
    entity = 'DidProduct'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.created_by = user.name
        obj.created_on = datetime.now(UTC)
        return obj


class DidProductResource(DnlResource):
    model_class = model.DidProduct
    scheme_class = DidProductScheme
    scheme_class_get = DidProductSchemeGet
    scheme_class_modify = DidProductSchemeModify
    entity = 'DidProduct'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class DidProductList(DnlList):
    scheme_class = DidProductSchemeGet
    model_class = model.DidProduct
    entity_plural = 'DidProducts'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if user.user_type == 1 and user.client_id:
            cls = self.model_class
            ret = ret.filter(cls.client_id == user.client_id)
        if not user.is_admin:
            cls = self.model_class
            # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---DidProduct---

# region +++DidProductItem+++
class DidProductItemCreate(DnlCreate):
    scheme_class = DidProductItemScheme
    model_class = model.DidProductItem
    entity = 'DidProductItem'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.created_by = user.name
        obj.created_on = datetime.now(UTC)
        return obj


class DidProductItemResource(DnlResource):
    model_class = model.DidProductItem
    scheme_class = DidProductItemScheme
    scheme_class_get = DidProductItemSchemeGet
    scheme_class_modify = DidProductItemSchemeModify
    entity = 'DidProductItem'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class DidProductItemList(DnlList):
    scheme_class = DidProductItemSchemeGet
    model_class = model.DidProductItem
    entity_plural = 'DidProductItems'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        # if not user.is_admin:
        #     cls = self.model_class
        #     ret = ret.filter(cls.did_product_id.in_(select(model.ClientDidProduct.did_product_id)))#TODO:filter for user
        return filt, ret


# endregion ---DidProductItem---

# region +++RandomAniGeneration+++
class RandomAniGenerationCreate(DnlCreate):
    scheme_class = RandomAniGenerationScheme
    model_class = model.RandomAniGeneration
    entity = 'RandomAniGeneration'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        # obj.created_by=user.name
        # obj.created_on=datetime.now(UTC)
        return obj


class RandomAniGenerationResource(DnlResource):
    model_class = model.RandomAniGeneration
    scheme_class = RandomAniGenerationScheme
    scheme_class_get = RandomAniGenerationSchemeGet
    scheme_class_modify = RandomAniGenerationSchemeModify
    entity = 'RandomAniGeneration'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class RandomAniGenerationList(DnlList):
    scheme_class = RandomAniGenerationSchemeGet
    model_class = model.RandomAniGeneration
    entity_plural = 'RandomAniGenerations'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        ordering, query = super(RandomAniGenerationList, self).modify_query_from_ordering_for_list(ordering, query,
                                                                                                   **kwargs)
        cls = self.model_class
        if ordering and 'by' in ordering:
            if ordering['by'] == 'ani_number':
                if not 'dir' in ordering or ordering['dir'] == 'asc':
                    query = query.order_by(func.length(cls.ani_number)).order_by(cls.ani_number)
                else:
                    query = query.order_by(func.length(cls.ani_number).desc()).order_by(cls.ani_number.desc())
        return ordering, query

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class

        return filt, ret


# endregion ---RandomAniGeneration---

# region +++RandomAniGroup+++
class RandomAniGroupCreate(DnlCreate):
    scheme_class = RandomAniGroupScheme
    model_class = model.RandomAniGroup
    entity = 'RandomAniGroup'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        # obj.created_by=user.name
        # obj.created_on=datetime.now(UTC)
        return obj


class RandomAniGroupResource(DnlResource):
    model_class = model.RandomAniGroup
    scheme_class = RandomAniGroupScheme
    scheme_class_get = RandomAniGroupSchemeGet
    scheme_class_modify = RandomAniGroupSchemeModify
    entity = 'RandomAniGroup'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()

    def on_delete(self, req, resp, **kwargs):
        try:
            group_id = kwargs['id']
            super(RandomAniGroupResource, self).on_delete(req, resp, **kwargs)
            model.Resource.filter(model.Resource.random_table_id == kwargs['id']).update({'random_table_id': None},
                synchronize_session='fetch')

            resp.data = {'success': True}
            self.set_response(resp, responses.SuccessResponseJustOk())
            return True
        except Exception as e:
            self.set_response(resp, responses.OperationErrorResponse(e))
            return True

class RandomAniGroupNumbersDelete(CustomDeleteAction):
    model_class = model.RandomAniGroup
    scheme_class = RandomAniGroupSchemeGet
    entity = 'ShakenAniGroupRel'
    security = (DEFAULT_SECURITY)
    path_parameters = ({'name': 'group_id', 'description': 'RandomAniGroup id'},)
    scheme_class_get = RandomAniGroupSchemeGet
    has_modify_operation = False

    def apply(self, obj, req, resp, **kwargs):
        from kombu.exceptions import OperationalError
        group_id = kwargs['group_id']
        try:
            model.RandomAniGeneration.filter(model.RandomAniGeneration.random_table_id == group_id).delete(
                synchronize_session='fetch')
        except Exception as e:
            self.set_response(resp, OperationErrorResponse(e))
        self.set_response(resp, responses.SuccessResponseJustOk())
        return False


class RandomAniGroupList(DnlList):
    scheme_class = RandomAniGroupSchemeGet
    model_class = model.RandomAniGroup
    entity_plural = 'RandomAniGroups'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class

        return filt, ret


# endregion ---RandomAniGroup---
class RateAutoImportMailboxLogList(DnlList):
    scheme_class = RateAutoImportMailboxLogSchemeGet
    model_class = model.RateAutoImportMailboxLog
    entity_plural = 'RateAutoImportMailboxLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
        # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret
# endregion ---RateAutoImportMailboxLog---
