import json
import sys, os
from urllib.parse import parse_qsl, urlencode
from datetime import date, datetime, timedelta
import traceback
from pytz import UTC
import mimetypes
from time import mktime
from dateutil.parser import parse as parse_datetime
import falcon
from sqlalchemy.orm import aliased, make_transient, foreign
from sqlalchemy import or_, and_, select, inspect, text as text_
from api_dnl import model, settings
from falcon_rest.logger import log
from falcon_rest.responses import responses
from falcon_rest.responses import errors
from falcon_rest.resources.resources import swagger, ResourcesBaseClass, DEFAULT_SECURITY, ATTRIBUTE_ERROR_RE

from api_dnl.resources import DnlResource, DnlList, DnlCreate, CustomAction, CustomPatchAction, ValidationError, \
    client_context, check_context
from api_dnl.schemes.did_export import *
from api_dnl.view import NoResultFound, DEFAULT_SECURITY, OperationErrorResponse, generate_uuid_str

DID_EXPORT_DEBUG = True

def _gen_csv(self):
    log.debug(f"SELF = {self}")
    try:
        import csv
        import io
        self.scheme_class = DidRepositoryScheme
        self.job_start_time = int(datetime.now(UTC).timestamp())
        self.status = 'running'
        self.count = 0
        window_size = 128  # or whatever limit you like
        window_idx = 0
        _count = 0
        _size = 0
        _page_count = 0
        d = []
        from_pos = 0#int(filtering.get('from', '0'))
        limit = 0#int(filtering.get('count', '0'))
        header_write = True
        orig_file = open(self.file_name,'wt')
        q = self.get_did_query()
        log.debug(f"GOT Q - {q}")
        for thing in q.yield_per(512):
            log.debug(f"COUNT = {_count}")
            _count += 1
            if _count < from_pos:
                continue
            _page_count += 1
            if limit and _page_count > limit:
                break
            window_idx += 1
            d.append(thing)
            if window_idx == window_size:
                data = self.scheme_class().dump(d, many=True).data
                csvfile = io.StringIO()
                if len(data):
                    fieldnames = data[0].keys()
                    writer = csv.DictWriter(csvfile, fieldnames=fieldnames)
                    if header_write:
                        header_write = False
                        writer.writeheader()
                    writer.writerows(data)
                    value = csvfile.getvalue()
                    _size += len(value)
                    orig_file.write(value)
                    yield str.encode(value)
                d = []
                window_idx = 0
                # self.count = _count
                # self.size = _size
                # self.save()
        if d:  # rest piece
            data = self.scheme_class().dump(d, many=True).data
            csvfile = io.StringIO()
            if len(data):
                fieldnames = data[0].keys()
                writer = csv.DictWriter(csvfile, fieldnames=fieldnames)
                if _count <= window_size and header_write:
                    header_write = False
                    writer.writeheader()
                writer.writerows(data)
                d = []
                value = csvfile.getvalue()
                _size += len(value)
                orig_file.write(value)
                yield str.encode(value)
        if limit and _page_count > limit:
            pass #break
        # finish
        self.status = 'success'
        self.size = _size
        self.count = _count
        self.save()
        orig_file.close()
        yield ('\r\n\r\n').encode()
    except Exception as e:
        # model.get_db().session.rollback()
        self.status = 'fail'
        self.msg = str(e)[:512]
        self.save()
        log.error('did_export UNEXPECTED ERROR: {}'.format(traceback.format_exc()))
        yield str.encode('\r\n\r\ndid_export UNEXPECTED ERROR: {}\r\n\r\n'.format(e))
    finally:
        self.job_end_time = int(datetime.now(UTC).timestamp())
        self.save()
        orig_file.close()


model.DidExportAsyncTask.gen_csv = _gen_csv

# region +++DidExportAsyncTask+++
class DidExportAsyncTaskCreate(DnlCreate):
    scheme_class = DidExportAsyncTaskScheme
    model_class = model.DidExportAsyncTask
    entity = 'DidExportAsyncTask'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()



    def on_post(self, req, resp, **kwargs):
        self.init_req(req)
        if not check_context(self, req, resp, **kwargs):
            return False
        kwargs = client_context(self, req, resp, **kwargs)
        ret = self._on_post(req, resp, **kwargs)
        if req.data['action'] == 'download':
            res=json.loads(resp.body)
            log.debug(f"RES = {res}")
            obj=self.model_class.get(res['object_id'])
            resp.body = None
            resp.content_type = 'text/csv'
            resp.append_header('Content-Disposition', 'attachment; filename="did_{}.csv"'.format(int(datetime.now(UTC).timestamp())))
            resp.stream = _gen_csv(obj)
            resp.status = falcon.HTTP_200
            return ret
        else:
            return ret


    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.user_id = user.user_id
        if user.user_type=='client':
            obj.request_client_id = user.client_id
        # obj.created_on=datetime.now(UTC)
        return obj

    def after_create(self, object_id, req, resp, **kwargs):
        obj = self.model_class.get(object_id)
        obj.orig_file = 'did_{}.csv'.format(object_id)
        obj.save()
        if req.data['action'] != 'download':
            from api_dnl.tasks import do_did_export_async_task
            do_did_export_async_task.delay(object_id)



class DidExportAsyncTaskResource(DnlResource):
    model_class = model.DidExportAsyncTask
    scheme_class = DidExportAsyncTaskScheme
    scheme_class_get = DidExportAsyncTaskSchemeGet
    scheme_class_modify = DidExportAsyncTaskSchemeModify
    entity = 'DidExportAsyncTask'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
    has_modify_operation = False
    has_delete_operation = False


class DidExportAsyncTaskList(DnlList):
    scheme_class = DidExportAsyncTaskSchemeGet
    model_class = model.DidExportAsyncTask
    entity_plural = 'DidExportAsyncTasks'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret
# endregion ---DidExportAsyncTask---
