"""did_number_assign_task

Revision ID: 1da8bd531726
Revises: 899687100aba
Create Date: 2021-03-29 18:14:06.704962

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '1da8bd531726'
down_revision = '899687100aba'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_number_assign_task',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('operator_user', sa.String(length=40), nullable=True),
    sa.Column('upload_file_path', sa.String(length=256), nullable=True),
    sa.Column('upload_orig_file', sa.String(length=100), nullable=True),
    sa.Column('upload_format_file', sa.String(length=100), nullable=True),
    sa.Column('orig_name', sa.String(length=256), nullable=True),
    sa.Column('repeated_action', api_dnl.migration_types.ChoiceType(), server_default='0', nullable=True),
    sa.Column('status', api_dnl.migration_types.ChoiceType(), server_default='0', nullable=False),
    sa.Column('progress', sa.Text(), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('import_export_logs_id', sa.Integer(), nullable=True),
    sa.Column('op_method', api_dnl.migration_types.ChoiceType(), server_default='0', nullable=True),
    sa.Column('client_id', sa.Integer(), nullable=True),
    sa.Column('client_billing_rule_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    # op.drop_table('did_cost_detail')
    # op.create_table('did_cost_detail',
    # sa.Column('id', sa.Integer(), nullable=False),
    # sa.Column('params', sa.String(length=4096), nullable=True),
    # sa.Column('created_on', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    # sa.Column('did_number', sa.String(length=64), nullable=False),
    # sa.Column('client_billing_plan_id', sa.Integer(), nullable=True),
    # sa.Column('client_trunk_id', sa.Integer(), nullable=True),
    # sa.Column('vendor_trunk_id', sa.Integer(), nullable=True),
    # sa.Column('nrc', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False),
    # sa.Column('mrc', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False),
    # sa.Column('minutes', sa.Integer(), server_default='0', nullable=True),
    # sa.Column('attempts', sa.Integer(), server_default='0', nullable=True),
    # sa.Column('vendor_cost', api_dnl.migration_types.Numeric(length=15, collation=6), server_default=sa.text('0.00'), nullable=False),
    # sa.Column('client_cost', api_dnl.migration_types.Numeric(length=15, collation=6), server_default=sa.text('0.00'), nullable=False),
    # sa.Column('start_date', sa.Date(), nullable=True),
    # sa.Column('end_date', sa.Date(), nullable=True),
    # sa.Column('mrc_number', sa.Integer(), server_default='0', nullable=True),
    # sa.Column('pay_type', sa.Integer(), server_default='0', nullable=True),
    # sa.ForeignKeyConstraint(['client_billing_plan_id'], ['did_billing_plan.id'], ondelete='CASCADE'),
    # sa.ForeignKeyConstraint(['client_trunk_id'], ['resource.resource_id'], ondelete='CASCADE'),
    # sa.ForeignKeyConstraint(['vendor_trunk_id'], ['resource.resource_id'], ondelete='CASCADE'),
    # sa.PrimaryKeyConstraint('id')
    # )
    # op.create_index(op.f('ix_did_cost_detail_did_number'), 'did_cost_detail', ['did_number'], unique=False)
    # op.create_index(op.f('ix_did_cost_detail_params'), 'did_cost_detail', ['params'], unique=False)
    # op.add_column('agent', sa.Column('mail_template_title', sa.String(length=200), nullable=True))
    # op.create_foreign_key(None, 'agent', 'mail_template', ['mail_template_title'], ['title'], ondelete='CASCADE')
    # op.drop_constraint('client_invoice_settings_invoice_setting_id_fkey', 'client_invoice_settings', type_='foreignkey')
    # op.create_foreign_key(None, 'client_invoice_settings', 'invoice_settings', ['invoice_setting_id'], ['id'], ondelete='CASCADE')
    # op.add_column('did_charge_detail', sa.Column('port_fee', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False))
    op.add_column('did_number_delete_task', sa.Column('orig_name', sa.String(length=256), nullable=True))
    op.drop_column('did_number_delete_task', 'result_file_path')
    op.drop_column('did_number_delete_task', 'progress')
    op.add_column('did_number_delete_task', sa.Column('progress', sa.Text(), nullable=True))
    # op.drop_column('did_report', 'surcharge')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # op.add_column('did_report', sa.Column('surcharge', sa.NUMERIC(), autoincrement=False, nullable=True))
    #
    # op.drop_column('did_charge_detail', 'port_fee')
    # op.drop_constraint(None, 'client_invoice_settings', type_='foreignkey')
    # op.create_foreign_key('client_invoice_settings_invoice_setting_id_fkey', 'client_invoice_settings', 'invoice_settings', ['invoice_setting_id'], ['id'])
    # op.drop_constraint(None, 'agent', type_='foreignkey')
    # op.drop_column('agent', 'mail_template_title')
    # op.drop_index(op.f('ix_did_cost_detail_params'), table_name='did_cost_detail')
    # op.drop_index(op.f('ix_did_cost_detail_did_number'), table_name='did_cost_detail')
    # op.drop_table('did_cost_detail')
    #
    op.add_column('did_number_delete_task',
                sa.Column('result_file_path', sa.VARCHAR(length=256), autoincrement=False, nullable=True))
    op.drop_column('did_number_delete_task', 'orig_name')
    op.drop_table('did_number_assign_task')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))