"""c4_shaken_conf

Revision ID: 2717825cc406
Revises: 56dd5e2d4e1b
Create Date: 2020-11-03 18:25:07.549113

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '2717825cc406'
down_revision = '56dd5e2d4e1b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('c4_shaken_conf',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=True),
    sa.Column('is_primary', sa.Boolean(), server_default='false', nullable=False),
    sa.Column('conn_type', sa.String(length=3), nullable=True),
    sa.Column('hostaddr', sa.Text(), nullable=False),
    sa.Column('port', sa.Integer(), nullable=False),
    sa.Column('heartbeat', sa.Boolean(), server_default='false', nullable=False),
    sa.Column('heartbeat_interval', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    # op.drop_column('client', 'enable_sign_in_notification')
    # op.drop_column('client', 'enable_trunk_view')
    # op.drop_column('client', 'enable_strip')
    # op.drop_column('client', 'enable_paypal')
    # op.drop_column('client', 'enable_trunk_edit')
    op.add_column('resource', sa.Column('require_valid_idt', sa.Boolean(), server_default='false', nullable=False))
    op.add_column('resource', sa.Column('require_valid_idt_check', sa.Boolean(), server_default='false', nullable=False))
    op.add_column('resource', sa.Column('x_identity_pass_through', sa.Boolean(), server_default='false', nullable=False))
    # ### end Alembic commands ###
    connection = op.get_bind()
    connection.execute( """
COMMENT ON COLUMN public.c4_shaken_conf.is_primary IS 'Whether this is a primary or redundant connection';
COMMENT ON COLUMN c4_shaken_conf.conn_type IS 'tcp / tls / udp';
COMMENT ON COLUMN c4_shaken_conf.heartbeat IS 'Enable heartbeat packet sending';
COMMENT ON COLUMN c4_shaken_conf.heartbeat_interval IS 'How often to send heartbeat packet; Default: every 10 seconds';
COMMENT ON COLUMN resource.require_valid_idt_check IS 'For ingress - accept calls only with valid Identity header';
COMMENT ON COLUMN resource.require_valid_idt IS 'For egress - accept calls only with valid Identity header';
""")
    up_rec('resource')
    up_rec('c4_shaken_conf')

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('resource', 'x_identity_pass_through')
    op.drop_column('resource', 'require_valid_idt_check')
    op.drop_column('resource', 'require_valid_idt')
    op.drop_table('c4_shaken_conf_record')
    op.drop_table('c4_shaken_conf')
    # ### end Alembic commands ###
    up_rec('resource')
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))