"""empty message

Revision ID: 3dfdcffbc5b4
Revises: 
Create Date: 2017-10-03 02:14:47.244792

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '3dfdcffbc5b4'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    pass
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('spam_traffic_ip',
    sa.Column('ip', sa.VARCHAR(length=30), autoincrement=False, nullable=False),
    sa.Column('brief', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True)
    )
    op.create_table('did_report',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('did', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_ip', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('egress_ip', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True)
    )
    op.create_table('code_record',
    sa.Column('code_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('code_deck_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('city', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('state', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='code_record_pkey')
    )
    op.create_table('switch_profile',
    sa.Column('id', sa.INTEGER(), server_default=sa.text("nextval('switch_profile_id_seq'::regclass)"), nullable=False),
    sa.Column('switch_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('profile_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('sip_ip', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('sip_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_debug', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('sip_trace', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('proxy_ip', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('proxy_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('voip_gateway_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('support_rpid', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('support_oli', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('support_priv', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('support_div', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('support_paid', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('support_pci', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('support_x_lrn', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('support_x_header', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('sip_capture_ip', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('sip_capture_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_capture_path', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('lan_ip', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('lan_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profile_status', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('paid_replace_ip', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('auth_register', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('default_register', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('report_ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('report_port', sa.INTEGER(), server_default=sa.text('3300'), autoincrement=False, nullable=True),
    sa.Column('active_call_ip', sa.CHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('active_call_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cap', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pcap_token', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['voip_gateway_id'], ['voip_gateway.id'], name='fkey_switch_profile_voip_gateway_id'),
    sa.PrimaryKeyConstraint('id', name='switch_profile_pkey'),
    postgresql_ignore_search_path=False
    )
    op.create_table('ftp_conf',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('server_ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('server_port', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('username', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('frequency', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('fields', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('headers', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('contain_headers', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('file_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_carriers', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('egress_carriers', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('ingress_carriers_all', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('egress_carriers_all', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_release_cause', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('egress_release_cause', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('conditions', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('ingresses', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('egresses', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('ingresses_all', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('egresses_all', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('time', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('alias', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('server_dir', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('max_lines', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('active', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('every_hours', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('file_breakdown', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('every_minutes', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='ftp_conf_pkey')
    )
    op.create_table('product_items_resource',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('item_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('by_percentage', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('order_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('order_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['item_id'], ['product_items.item_id'], name='fkey_product_items_resource_product_items_item_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='fkey_product_items_resource_resource_resource_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='product_items_resource_pkey'),
    sa.UniqueConstraint('item_id', 'resource_id', name='product_items_resource_item_id_resource_id_uni')
    )
    op.create_table('c4_lrn_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('srv1_ip', sa.VARCHAR(length=16), autoincrement=False, nullable=True),
    sa.Column('srv1_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('srv2_ip', sa.VARCHAR(length=16), autoincrement=False, nullable=True),
    sa.Column('srv2_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='c4_lrn_record_pkey')
    )
    op.create_table('balance_history_actual',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('payment_received', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('credit_note_sent', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('debit_note_sent', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('unbilled_incoming_traffic', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('short_charges', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('payment_sent', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('credit_note_received', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('debit_note_received', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('unbilled_outgoing_traffic', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('actual_balance', sa.NUMERIC(precision=20, scale=5), autoincrement=False, nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('actual_ingress_balance', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('actual_egress_balance', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='fkey_balance_history_actual_client_client_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='balance_history_actual_pkey')
    )
    op.create_table('qos_total',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('call', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('server_ip', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('server_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('channels', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_channels', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_channels', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cps', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_table('payment_term_record',
    sa.Column('payment_term_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('days', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('grace_days', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('notify_days', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('more_days', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('finance_rate', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='payment_term_record_pkey')
    )
    op.create_table('currency',
    sa.Column('currency_id', sa.INTEGER(), server_default=sa.text("nextval('currency_currency_id_seq'::regclass)"), nullable=False),
    sa.Column('code', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('active', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=False),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('currency_id', name='currency_pkey'),
    sa.UniqueConstraint('code', name='currency_code_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('version_information',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('program_name', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('major_ver', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('minor_ver', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('build_date', sa.VARCHAR(length=11), autoincrement=False, nullable=True),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='version_information_pkey'),
    sa.UniqueConstraint('program_name', name='version_information_program_name_key')
    )
    op.create_table('fraud_detection_log_detail',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('fraud_detection_log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('block_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('limit_value', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('actual_value', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('partner_email_msg', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('partner_email_status', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('partner_email', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('system_email_msg', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('system_email_status', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('system_email', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('is_block', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_send_email', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['fraud_detection_log_id'], ['fraud_detection_log.id'], name='fkey_fraud_detection_log_detail_fraud_detection_log_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='fraud_detection_log_detail_pkey')
    )
    op.create_table('dynamic_route_override_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('digits', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('percentage', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='dynamic_route_override_record_pkey')
    )
    op.create_table('rate_table',
    sa.Column('rate_table_id', sa.INTEGER(), server_default=sa.text("nextval('rate_table_rate_table_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('modify_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.Column('code_deck_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('currency_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('rate_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_country_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('lnp_dipping_rate', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_prefix', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('noprefix_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('noprefix_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('prefix_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('prefix_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('jur_type', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('origination', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_virtual', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['code_deck_id'], ['code_deck.code_deck_id'], name='fkey_rate_table_code_deck_code_deck_id', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['currency_id'], ['currency.currency_id'], name='fkey_rate_table_currency_currency_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('rate_table_id', name='rate_table_pkey'),
    sa.UniqueConstraint('name', name='rate_table_name_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('allowed_sendto_ip_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('direction', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_profile_ip', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('sip_profile_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='allowed_sendto_ip_record_pkey')
    )
    op.create_table('rate_generation_rate',
    sa.Column('rate_generation_history_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('code', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=False),
    sa.Column('rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('setup_fee', sa.NUMERIC(precision=30, scale=10), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('effective_date', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('end_date', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('min_time', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('grace_time', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('interval', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('seconds', sa.INTEGER(), server_default=sa.text('60'), autoincrement=False, nullable=False),
    sa.Column('code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('rate_type', sa.INTEGER(), server_default=sa.text('3'), autoincrement=False, nullable=False),
    sa.Column('intra_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('inter_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('local_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('zone', sa.VARCHAR(length=10), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('ocn', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('lata', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('generation_rate_id', sa.INTEGER(), nullable=False),
    sa.Column('lcr_rate', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('lcr_intra_rate', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('lcr_inter_rate', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('lcr_local_rate', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('generation_rate_id', name='rate_generation_rate_pkey')
    )
    op.create_table('carrier_template_low_bal_config',
    sa.Column('carrier_template_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('is_notify', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('value_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('actual_notify_balance', sa.NUMERIC(precision=30, scale=2), autoincrement=False, nullable=True),
    sa.Column('percentage_notify_balance', sa.NUMERIC(precision=30, scale=2), autoincrement=False, nullable=True),
    sa.Column('send_time_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_send_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duplicate_days', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('send_to', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duplicate_send_days', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('last_alert_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('disable_trunks_days', sa.INTEGER(), server_default=sa.text('5'), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['carrier_template_id'], ['carrier_template.id'], name='fkey_carrier_template_low_bal_config_carrier_template_carrier_t', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('carrier_template_id', name='carrier_template_low_bal_config_pkey')
    )
    op.create_table('rate_generation_template_margin',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('rate_generation_template_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('max_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('markup_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('markup_value', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['rate_generation_template_id'], ['rate_generation_template.id'], name='rate_generation_template_margi_rate_generation_template_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='rate_generation_template_margin_pkey')
    )
    op.create_table('product',
    sa.Column('product_id', sa.INTEGER(), server_default=sa.text("nextval('product_product_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('modify_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.Column('introduction', sa.VARCHAR(length=80), autoincrement=False, nullable=True),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('code_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('code_deck_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_lrn', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('product_id', name='product_pkey'),
    sa.UniqueConstraint('name', name='name_uniq'),
    postgresql_ignore_search_path=False
    )
    op.create_table('scheduled_report_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('email_to', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('report_name', sa.CHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('attachment_path', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('execute_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='scheduled_report_log_pkey')
    )
    op.create_table('product_items_record',
    sa.Column('item_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('product_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('alias', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('digits', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('strategy', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_len', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_len', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_abr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_abr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_aloc', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_aloc', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('limit_price', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('code_name', sa.CHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='product_items_record_pkey')
    )
    op.create_table('cdr_report_detail20170922',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('lnp_cost', sa.NUMERIC(precision=15, scale=8), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_18s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_24s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_2h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_3h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_4h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_12s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('product_rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('incoming_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('outgoing_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('inter_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('npr_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.Column('ingress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ring_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.CheckConstraint("(report_time >= '2017-09-22 00:00:00+00'::timestamp with time zone) AND (report_time < '2017-09-23 00:00:00+00'::timestamp with time zone)", name='timecheck')
    )
    op.create_table('rate_generation_code_deck',
    sa.Column('rate_generation_template_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['rate_generation_template_id'], ['rate_generation_template.id'], name='fkey_rate_generation_code_deck_rate_gen_template_id')
    )
    op.create_table('loop_detection',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('rule_name', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('counter_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('block_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='loop_detection_pkey')
    )
    op.create_table('route_block',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('egress_trunk_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code_name', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='route_block_pkey')
    )
    op.create_table('jurisdiction_update_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('tigger_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('is_new_file', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('import_log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('file_update_time_flg', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='jurisdiction_update_log_pkey')
    )
    op.create_table('file',
    sa.Column('uuid', sa.VARCHAR(length=36), autoincrement=False, nullable=False),
    sa.Column('path', sa.VARCHAR(length=1024), autoincrement=False, nullable=False),
    sa.Column('belongs_to_table', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('belongs_to_field', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('belongs_to_pk', sa.VARCHAR(length=128), autoincrement=False, nullable=True),
    sa.Column('uploaded_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
    sa.Column('attached_on', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=True),
    sa.Column('public', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('uuid', name='file_pkey')
    )
    op.create_table('route_record',
    sa.Column('route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('digits', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('static_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_strategy_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lnp', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('lrn_block', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('dnis_only', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('code_deck_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('intra_static_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_static_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_country_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_prefix', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('ani_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('digits_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('digits_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code_name', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('route_type_flg', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='route_record_pkey')
    )
    op.create_table('global_route_error_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('error_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('error_description', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('to_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('default_to_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('default_to_sip_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='global_route_error_record_pkey')
    )
    op.create_table('api_permissions',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('role_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('entity_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('read', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('write', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['entity_id'], ['api_entity.id'], name='api_permissions_entity_id_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['role_id'], ['role.role_id'], name='api_permissions_role_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='api_permissions_pkey'),
    sa.UniqueConstraint('role_id', 'entity_id', name='api_permissions_role_id_entity_id_key')
    )
    op.create_table('email_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('send_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('email_addresses', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('files', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('email_res', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('alert_block_egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('alert_block_code_name', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('error', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('resend_email', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('subject', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('is_view', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('sent_from', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='email_log_pkey')
    )
    op.create_table('rate_send_log',
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('status', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('zip', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('file', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('error', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('format', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('id', sa.INTEGER(), server_default=sa.text("nextval('rate_send_log_id_seq'::regclass)"), nullable=False),
    sa.Column('email_template_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('effective_date', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('start_effective_date', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('download_deadline', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('is_email_alert', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('is_disable', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('is_temp', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('headers', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('send_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('send_specify_email', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('resource_ids', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('download_method', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('total_records', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('completed_records', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='rate_send_log_pkey'),
    postgresql_ignore_search_path=False
    )
    op.create_table('transaction_fee_items_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('trans_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('transaction_fee_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('trans_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('use_fee', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='transaction_fee_items_record_pkey')
    )
    op.create_table('resource_replace_action_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_prefix', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('ani', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('ani_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_prefix', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('dnis', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('dnis_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_replace_action_record_pkey')
    )
    op.create_table('fraud_detection_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('fraud_detection_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('finish_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['fraud_detection_id'], ['fraud_detection.id'], name='fkey_fraud_detection_log_fraud_detection_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='fraud_detection_log_pkey')
    )
    op.create_table('product_items',
    sa.Column('item_id', sa.INTEGER(), nullable=False),
    sa.Column('product_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('alias', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('digits', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=False),
    sa.Column('strategy', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_len', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('max_len', sa.INTEGER(), server_default=sa.text('32'), autoincrement=False, nullable=True),
    sa.Column('min_asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_abr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_abr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_aloc', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_aloc', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('limit_price', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('code_name', sa.CHAR(length=100), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['product_id'], ['product.product_id'], name='fkey_product_items_product_product_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['time_profile_id'], ['time_profile.time_profile_id'], name='fkey_product_items_time_profile_time_profile_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('item_id', name='product_items_pkey'),
    sa.UniqueConstraint('product_id', 'digits', name='c4_uni_product_items_product_id_digits')
    )
    op.create_table('agent_commission_history_detail',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('history_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('total_date', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('commission', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_cost', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='agent_commission_history_detail_client_id_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['history_id'], ['agent_commission_history.history_id'], name='agent_commission_history_detail_history_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='agent_commission_history_detail_pkey')
    )
    op.create_table('client_cdr',
    sa.Column('id', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('record_sequence_number', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('version_number', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('record_type', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('connection_type', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('session_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('start_time_of_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('answer_time_of_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('release_tod', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('minutes_west_of_greenwich_mean_time', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('first_release_dialogue', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('trunk_id_origination', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('voip_protocol_origination', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('origination_source_number', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('origination_source_host_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('origination_destination_number', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('origination_call_id', sa.VARCHAR(length=150), autoincrement=False, nullable=True),
    sa.Column('origination_remote_payload_ip_address', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('origination_remote_payload_udp_address', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_local_payload_ip_address', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('origination_local_payload_udp_address', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_codec_list', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('origination_ingress_packets', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_egress_packets', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_ingress_octets', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_egress_octets', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_ingress_packet_loss', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_ingress_delay', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_ingress_packet_jitter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('trunk_id_termination', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('voip_protocol_termination', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('termination_source_number', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('termination_destination_number', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('termination_destination_host_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('termination_call_id', sa.VARCHAR(length=150), autoincrement=False, nullable=True),
    sa.Column('termination_remote_payload_ip_address', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('termination_remote_payload_udp_address', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('termination_local_payload_ip_address', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('termination_local_payload_udp_address', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('termination_codec_list', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('termination_ingress_packets', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('termination_egress_packets', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('termination_ingress_octets', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('termination_egress_octets', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('termination_ingress_packet_loss', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('termination_ingress_delay', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('termination_ingress_packet_jitter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('final_route_indication', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('routing_digits', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('call_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ring_time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('callduration_in_ms', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('conf_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('call_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_currency_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('ingress_client_currency', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_client_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_bill_result', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_client_currency_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_client_currency', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_six_seconds', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_minutes', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_result', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_minutes', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('ingress_dnis_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('lrn_dnis', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_dnis_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('translation_ani', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ani_code_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_code_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('item_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rerate_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('orig_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('orig_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('orig_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('term_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('term_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('term_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_effective_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_effective_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_erro_string', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('route_plan', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dynamic_route', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('static_route', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('contract_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('order_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('order_type', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('lrn_number_vendor', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('lnp_dipping_cost', sa.NUMERIC(precision=10, scale=8), autoincrement=False, nullable=True),
    sa.Column('is_final_call', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('egress_code_asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('egress_code_acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('route_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('is_manual_kill', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('orig_call_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_delay_second', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_delay_second', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('trunk_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('origination_profile_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('termination_profile_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('o_trunk_type2', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('o_billing_method', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('t_trunk_type2', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('t_billing_method', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('campaign_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('tax', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ring_epoch', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('end_epoch', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('paid_user', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('rpid_user', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('timeout_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('q850_cause', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True)
    )
    op.create_table('resource_replace_action',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_prefix', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('ani', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('ani_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_prefix', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('dnis', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('dnis_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='fkey_resource_replace_action_resource_resource_id'),
    sa.PrimaryKeyConstraint('id', name='resource_replace_action_pkey')
    )
    op.create_table('agent_commission_payment',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('history_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('note', sa.TEXT(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['history_id'], ['agent_commission_history.history_id'], name='agent_commission_payment_history_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='agent_commission_payment_pkey')
    )
    op.create_table('role',
    sa.Column('role_id', sa.INTEGER(), server_default=sa.text("nextval('role_role_id_seq'::regclass)"), nullable=False),
    sa.Column('role_name', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('view_pw', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('default_sysfunc_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('del_able', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('edit_able', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_carriers', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_transaction', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_mutual_settlements', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_invoices', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_payment', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_spam_report', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_location_report', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_origterm', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_summary_report', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_usage_report', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('sync_list', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_qos_report', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_disconnect_cause', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_billing_mismatch', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_active_call', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_termination_report', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_rates_analysis', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_call_simulation', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_ingress_trunk_simulation', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_egress_trunk_simulation', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_sip_capture', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_digit_mapping', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_trunk', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_dynamic_routing', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_static_route_table', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_block_list', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_routing_plan', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_active_web_session', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_payment_term', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_jurisdiction', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_capicity', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_rate_table', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_code_deck', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_time_profile', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_currency', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_task_schedulers', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_mail_template', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_role', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_user', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_change_password', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_setting', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_import_log', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_export_log', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('sync_backup', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_lrn_setting', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('active', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_unpaid_bills', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_service_charge', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_voip_gateway', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_trouble_shoot', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_event', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_ticket', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_buy_select_country', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_search_private_buy', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_buy_confirm_order', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_sell_select_country', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_search_private_sell', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_sell_confirm_order', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('role_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('role_id', name='role_pkey'),
    sa.UniqueConstraint('role_name', name='role_role_name_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('cdr_report_detail20170715',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('lnp_cost', sa.NUMERIC(precision=15, scale=8), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_18s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_24s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_2h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_3h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_4h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_12s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('product_rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('incoming_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('outgoing_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('inter_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('npr_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.Column('ingress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ring_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.CheckConstraint("(report_time >= '2017-07-15 00:00:00+00'::timestamp with time zone) AND (report_time < '2017-07-16 00:00:00+00'::timestamp with time zone)", name='timecheck')
    )
    op.create_table('resource_block_items',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('block_resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('active', sa.SMALLINT(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='resource_block_items_pkey')
    )
    op.create_table('resource_direction',
    sa.Column('direction', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('action', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('digits', sa.VARCHAR(length=10), autoincrement=False, nullable=False),
    sa.Column('direction_id', sa.INTEGER(), nullable=False),
    sa.Column('dnis', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('number_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('number_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='fkey_resource_direction_resource_resource_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['time_profile_id'], ['time_profile.time_profile_id'], name='fkey_resource_direction_time_profile_time_profile_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('direction_id', name='resource_direction_pkey')
    )
    op.create_table('mail_sender',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('smtp_host', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('smtp_port', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('username', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('email', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('secure', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('loginemail', sa.VARCHAR(length=12), autoincrement=False, nullable=True),
    sa.Column('last_modified_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('modified_by', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('enable_auth', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='mail_sender_pkey')
    )
    op.create_table('carrier_group',
    sa.Column('group_id', sa.INTEGER(), nullable=False),
    sa.Column('group_name', sa.VARCHAR(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('group_id', name='carrier_group_pkey'),
    sa.UniqueConstraint('group_name', name='carrier_group_group_name_key')
    )
    op.create_table('import_export_logs',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('file_path', sa.VARCHAR(length=300), server_default=sa.text("''::character varying"), autoincrement=False, nullable=False),
    sa.Column('error_file_path', sa.VARCHAR(length=300), server_default=sa.text("''::character varying"), autoincrement=False, nullable=False),
    sa.Column('status', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('user_id', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('obj', sa.VARCHAR(length=80), autoincrement=False, nullable=True),
    sa.Column('log_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('finished_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duplicate_type', sa.VARCHAR(length=16), autoincrement=False, nullable=True),
    sa.Column('ext_attributes', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('server_id', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('upload_table', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('upload_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('db_error_file_path', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('duplicate_numbers', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('foreign_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('success_numbers', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('error_row', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('error_rollback', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('php_process_number', sa.BIGINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('db_process_number', sa.BIGINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('foreign_name', sa.VARCHAR(length=80), autoincrement=False, nullable=True),
    sa.Column('auto_enddate', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('custom_end_date', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('pid', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('myfile_filename', sa.VARCHAR(length=100), autoincrement=False, nullable=True)
    )
    op.create_table('resource_template',
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('resource_template_id', sa.INTEGER(), nullable=False),
    sa.Column('create_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('update_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('trunk_type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('media_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profit_margin', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
    sa.Column('profit_type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('wait_ringtime180', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lnp_dipping_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('lnp_dipping', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('delay_bye_second', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ignore_early_media', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('re_invite', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('re_invite_interval', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('media_timeout', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('res_strategy', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('max_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('trunk_type2', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('billing_rule', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('billing_method', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('random_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('amount_per_port', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('info', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rfc2833', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inband', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ring_timeout', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('codecs_str', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('paid', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('oli', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('pci', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('priv', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('div', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('display_name', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('rpid_screen', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid_party', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid_id_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid_privacy', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_rounding', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_decimal', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_profile', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('us_route', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('us_other', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('canada_route', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('canada_other', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intl_route', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ignore_early_nosdp', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('bill_by', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ignore_ring', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('hosts', sa.VARCHAR(length=4096), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('resource_template_id', name='resource_template_pkey')
    )
    op.create_table('alert_rules_log_detail',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('alert_rules_log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('abr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('profitability', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('revenue', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('system_email_address', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('system_email_status', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('partner_email_address', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('partner_email_status', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_email', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_block', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('resource_block_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('email_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='alert_rules_log_detail_pkey')
    )
    op.create_table('import_target_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.Column('file_name', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('file_path', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('error_message', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='import_target_log_pkey')
    )
    op.create_table('scheduler_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('script_name', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('start_time', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.Column('end_time', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='scheduler_log_pkey')
    )
    op.create_table('resource_ip_limit_record',
    sa.Column('limit_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ip_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('capacity', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_ip_limit_record_pkey')
    )
    op.create_table('system_parameter',
    sa.Column('sys_timezone', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('sys_area', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('mailserver_host', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('mail_server_from', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('de_pin_len', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ftp_username', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('ftp_pass', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('date_format', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('datetime_format', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('sys_currency', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('sys_id', sa.INTEGER(), nullable=False),
    sa.Column('invoices_tplno', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('invoices_lastno', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('invoices_fields', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('invoices_delay', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('invoices_separate', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('invoices_cdr_fields', sa.VARCHAR(length=80), autoincrement=False, nullable=True),
    sa.Column('dr_period', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('radius_log_routes', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('events_notfoundaccount', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('events_notfoundtariff', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('events_unprofitable', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('events_alertszerotime', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('lowBalance_period', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('events_deleteafterdays', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('stats_rotate_delay', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('rates_deleteafterdays', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('cdrs_deleteafterdays', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('logs_deleteafterdays', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('backup_period', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('backup_leave_last', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('csv_delimiter', sa.VARCHAR(length=5), autoincrement=False, nullable=True),
    sa.Column('sys_ani', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('conf_number', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('msgmonthlyfee', sa.NUMERIC(precision=20, scale=3), autoincrement=False, nullable=True),
    sa.Column('fail_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('forbidden_times', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('conf_max_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('smtphost', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('smtpport', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('emailusername', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('emailpassword', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('fromemail', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('emailname', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('loginemail', sa.VARCHAR(length=12), autoincrement=False, nullable=True),
    sa.Column('system_admin_email', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('switch_ip', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('switch_port', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('noc_email', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('finance_email', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('pdf_tpl', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('tpl_number', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('rate_clean_days', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('smtp_secure', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('default_code_deck', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('qos_sample_period', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('minimal_call_attempt_required', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('low_call_attempt_handling', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('welcome_message', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('report_count', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('realm', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('workstation', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('landing_page', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('invoice_name', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('auto_delivery_timezone', sa.VARCHAR(length=20), server_default=sa.text("'+00'::character varying"), autoincrement=False, nullable=True),
    sa.Column('auto_delivery_address', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('allow_cdr_fields', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('company_info', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('bar_color', sa.VARCHAR(length=20), server_default=sa.text("'6B9B20'::character varying"), autoincrement=False, nullable=True),
    sa.Column('auto_delivery_group_by', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('inactivity_timeout', sa.INTEGER(), server_default=sa.text('30'), autoincrement=False, nullable=True),
    sa.Column('is_preload', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('yourpay_store_number', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('paypal_account', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('withdraw_email', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('switch_alias', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('overlap_invoice_protection', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('send_cdr_fields', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('system_rate_mail', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('ingress_pdd_timeout', sa.INTEGER(), server_default=sa.text('60000'), autoincrement=False, nullable=False),
    sa.Column('egress_pdd_timeout', sa.INTEGER(), server_default=sa.text('6000'), autoincrement=False, nullable=False),
    sa.Column('ring_timeout', sa.INTEGER(), server_default=sa.text('60'), autoincrement=False, nullable=False),
    sa.Column('call_timeout', sa.INTEGER(), server_default=sa.text('3600'), autoincrement=False, nullable=True),
    sa.Column('invoice_send_mode', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('company_info_location', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('daily_payment_confirmation', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('daily_payment_email', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('notify_carrier', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('notify_carrier_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_setting_subject', sa.CHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('payment_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('is_show_mutual_balance', sa.SMALLINT(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('ftp_email', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('is_hide_unauthorized_ip', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('stripe_account', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('require_comment', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_rate_smtp', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('auto_rate_username', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('auto_rate_pwd', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('auto_rate_smtp_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_rate_mail_ssl', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('themer', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('default_us_ij_rule', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('report_hourly_save_days', sa.INTEGER(), server_default=sa.text('30'), autoincrement=False, nullable=True),
    sa.Column('report_daily_save_days', sa.INTEGER(), server_default=sa.text('180'), autoincrement=False, nullable=True),
    sa.Column('report_code_save_days', sa.INTEGER(), server_default=sa.text('60'), autoincrement=False, nullable=True),
    sa.Column('full_cdr_save_days', sa.INTEGER(), server_default=sa.text('30'), autoincrement=False, nullable=True),
    sa.Column('simple_cdr_save_days', sa.INTEGER(), server_default=sa.text('180'), autoincrement=False, nullable=True),
    sa.Column('non_zero_cdr_save_days', sa.INTEGER(), server_default=sa.text('60'), autoincrement=False, nullable=True),
    sa.Column('invoice_decimal_digits', sa.INTEGER(), server_default=sa.text('2'), autoincrement=False, nullable=True),
    sa.Column('stripe_public_account', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('default_billing_decimal', sa.INTEGER(), server_default=sa.text('6'), autoincrement=False, nullable=False),
    sa.Column('auto_carrier_notification', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('login_page_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_received_confirmation', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('paypal_service_charge', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('stripe_service_charge', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('signup_content', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('login_fit_image', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('login_captcha', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('login_image', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('billing_info', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('billing_info_location', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('charge_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('sys_id', name='system_parameter_pkey')
    )
    op.create_table('cdr_export_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('export_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('file_name', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_dipp', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('backend_pid', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cdr_start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('cdr_end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('sql', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('file_rows', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('error_msg', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('send_mail', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('where_sql', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('show_fields_sql', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('total_hours', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('finished_hours', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('stop_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('download_cdr_from', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('download_cdr_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_cc', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('send_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('total_date', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('finished_date', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('finished_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='cdr_export_log_pkey')
    )
    op.create_table('resource_prefix',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('tech_prefix', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=False),
    sa.Column('route_strategy_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('code_cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code_cap', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('product_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='fkey_resource_prefix_resource_resource_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='resource_prefix_pkey')
    )
    op.create_table('mail_cdr_log',
    sa.Column('id', sa.INTEGER(), server_default=sa.text("nextval('mail_cdr_log_id_seq'::regclass)"), nullable=False),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('cdr_counts', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('finish_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('cdr_start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('cdr_end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('file_counts', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('mail_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('mail_subject', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='mail_cdr_log_pkey'),
    postgresql_ignore_search_path=False
    )
    op.create_table('rate_upload_task',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('operator_user', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('upload_file_path', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('upload_orig_file', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('upload_format_file', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('result_file_path', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('rate_table_code_deck_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_date_format', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('rate_end_date', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('reduplicate_rate_action', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('code_deck_flag', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('use_ocn_lata_code', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('status', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('progress', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('expense_detail', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('start_time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('end_time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('default_info', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('all_rate_end_date', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='rate_upload_task_pkey')
    )
    op.create_table('termination_global_failover',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('failover_strategy', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('from_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='termination_global_failover_pkey')
    )
    op.create_table('payment_invoice',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('payment_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('amount', sa.NUMERIC(precision=20, scale=5), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['invoice_id'], ['invoice.invoice_id'], name='payment_invoice_invoice_id_fkey'),
    sa.ForeignKeyConstraint(['payment_id'], ['client_payment.client_payment_id'], name='payment_invoice_payment_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='payment_invoice_pkey')
    )
    op.create_table('resource_direction_record',
    sa.Column('direction', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('action', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('digits', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('direction_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('number_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('number_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_direction_record_pkey')
    )
    op.create_table('translation_item',
    sa.Column('ref_id', sa.INTEGER(), nullable=False),
    sa.Column('translation_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('ani', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('dnis', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('action_ani', sa.VARCHAR(length=30), autoincrement=False, nullable=False),
    sa.Column('action_dnis', sa.VARCHAR(length=30), autoincrement=False, nullable=False),
    sa.Column('ani_method', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('dnis_method', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['translation_id'], ['digit_translation.translation_id'], name='fkey_translation_item_digit_translation_translation_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('ref_id', name='translation_item_pkey')
    )
    op.create_table('switch_profile_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('switch_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('profile_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('sip_ip', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('sip_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_debug', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_trace', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('proxy_ip', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('proxy_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('voip_gateway_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('support_rpid', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('support_oli', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('support_priv', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('support_div', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('support_paid', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('support_pci', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('support_x_lrn', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('support_x_header', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_capture_ip', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('sip_capture_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_capture_path', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('lan_ip', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('lan_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profile_status', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('paid_replace_ip', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auth_register', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('default_register', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('report_ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('report_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('active_call_ip', sa.CHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('active_call_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cap', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pcap_token', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='switch_profile_record_pkey')
    )
    op.create_table('cdr_rerate',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('finish_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('rerate_type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('rerate_rate_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_table_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('cdr_backup_file', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('where_condition', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
    sa.Column('end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
    sa.Column('pid', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='cdr_rerate_pkey')
    )
    op.create_table('balance_history',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('payment_received', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('credit_note_sent', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('debit_note_sent', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('payment_sent', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('credit_note_received', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('debit_note_received', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('invoice_set', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('invoice_received', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('mutual_balance', sa.NUMERIC(precision=20, scale=5), autoincrement=False, nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('mutual_ingress_balance', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('mutual_egress_balance', sa.NUMERIC(precision=20, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='fkey_balance_history_client_client_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='balance_history_pkey')
    )
    op.create_table('users_limit',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='users_limit_client_id_fkey'),
    sa.ForeignKeyConstraint(['user_id'], ['users.user_id'], name='users_limit_user_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='users_limit_pkey')
    )
    op.create_table('ingress_did_repository',
    sa.Column('number', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('created_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('updated_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('state', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('city', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('rate_center', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('lata', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['egress_id'], ['resource.resource_id'], name='ingress_did_repository_egress_id_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['ingress_id'], ['resource.resource_id'], name='ingress_did_repository_ingress_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('number', name='ingress_did_repository_pkey')
    )
    op.create_table('termination_global_failover_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('failover_strategy', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('from_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='termination_global_failover_record_pkey')
    )
    op.create_table('resource_codecs_ref_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('codec_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_codecs_ref_record_pkey')
    )
    op.create_table('user_auth_ip',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='user_auth_ip_pkey')
    )
    op.create_table('system_limit',
    sa.Column('ingress_call_limit', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('ingress_cps_limit', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('egress_call_limit', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('egress_cps_limit', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False)
    )
    op.create_table('rate_send_log_detail',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('send_to', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('error', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('salt', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('download_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('sent_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['log_id'], ['rate_send_log.id'], name='rate_send_log_detail_log_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='rate_send_log_detail_pkey')
    )
    op.create_table('web_session',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('host', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('agent', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('msg', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='web_session_pkey')
    )
    op.create_table('origination_global_failover_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('failover_strategy', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('from_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='origination_global_failover_record_pkey')
    )
    op.create_table('codecs',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('name', sa.VARCHAR(length=40), autoincrement=False, nullable=False),
    sa.Column('detail', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='codecs_pkey'),
    sa.UniqueConstraint('name', name='codecs_name_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('loop_detection_detail',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('loop_detection_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='loop_detection_detail_pkey')
    )
    op.create_table('dynamic_route_pri',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('digits', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('resource_pri', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['dynamic_route_id'], ['dynamic_route.dynamic_route_id'], name='fkey_dynamic_route_pri_dynamic_route_dynamic_route_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='fkey_dynamic_route_pri_resource_resource_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='dynamic_route_pri_pkey')
    )
    op.create_table('block_log',
    sa.Column('log_id', sa.INTEGER(), nullable=False),
    sa.Column('block_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('block_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('code_detail', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('re_enable_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('asr', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('abr', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('acd', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('margin', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('re_enable', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('type', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('log_id', name='block_log_pkey')
    )
    op.create_table('global_route_error',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('error_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('error_description', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('to_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('default_to_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('default_to_sip_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='global_route_error_pkey')
    )
    op.create_table('invoice_email',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_no', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('mail_content', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('send_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('pdf_file', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('send_address', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('mail_sub', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='class4_pkey_invoice_email_id')
    )
    op.create_table('qos_ip',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('ip_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('direction', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('server_ip', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('server_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('channels', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_table('credit_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('modified_by', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('modified_from', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('modified_to', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('modified_on', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('carrier_name', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='credit_log_pkey')
    )
    op.create_table('role_privilege',
    sa.Column('role_privilege_id', sa.INTEGER(), nullable=False),
    sa.Column('role_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('system_function_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('writable', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('readable', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('executable', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('reseller_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['role_id'], ['role.role_id'], name='role_privilege_role_id_fkey'),
    sa.ForeignKeyConstraint(['system_function_id'], ['system_function.system_function_id'], name='role_privilege_system_function_id_fkey'),
    sa.PrimaryKeyConstraint('role_privilege_id', name='role_privilege_pkey')
    )
    op.create_table('qos_route_report',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code', sa.VARCHAR(length=32), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('direction', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('server_ip', sa.VARCHAR(length=36), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True)
    )
    op.create_table('dynamic_route',
    sa.Column('dynamic_route_id', sa.INTEGER(), server_default=sa.text("nextval('dynamic_route_dynamic_route_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('routing_rule', sa.INTEGER(), server_default=sa.text('6'), autoincrement=False, nullable=False),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('lcr_flag', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('is_virtual', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['time_profile_id'], ['time_profile.time_profile_id'], name='fkey_dynamic_route_time_profile_time_profile_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('dynamic_route_id', name='dynamic_route_pkey'),
    sa.UniqueConstraint('name', name='dynamic_route_name_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('voip_gateway',
    sa.Column('id', sa.INTEGER(), server_default=sa.text("nextval('voip_gateway_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('paid_replace_ip', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('lan_ip', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('lan_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('active_call_ip', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('active_call_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_capture_ip', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('sip_capture_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_capture_path', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='voip_gateway_pkey'),
    postgresql_ignore_search_path=False
    )
    op.create_table('balance_daily_reset_task',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('reset_balance', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('mutual', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('actual', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('finished_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='balance_daily_reset_task_pkey')
    )
    op.create_table('dynamic_route_record',
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('routing_rule', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('lcr_flag', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_virtual', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='dynamic_route_record_pkey')
    )
    op.create_table('signup_ip',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('signup_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('netmark', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['signup_id'], ['signup.id'], name='signup_ip_signup_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='signup_ip_pkey')
    )
    op.create_table('rate_generation_history',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('is_applied', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('rate_generation_template_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('finished_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('rate_count', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('processing_time', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('progress', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('rate_table_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['rate_generation_template_id'], ['rate_generation_template.id'], name='fkey_rate_generation_history_rate_gen_template_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='rate_generation_history_pkey')
    )
    op.create_table('dynamic_route_pri_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('digits', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_pri', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='dynamic_route_pri_record_pkey')
    )
    op.create_table('orig_invoice',
    sa.Column('invoice_id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_number', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('state', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('invoice_time', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('invoice_start', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('invoice_end', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('total_amount', sa.NUMERIC(precision=15, scale=2), autoincrement=False, nullable=False),
    sa.Column('pdf_path', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('create_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('invoice_id', name='orig_invoice_pkey')
    )
    op.create_table('ip_modif_log',
    sa.Column('modify', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('detail', sa.CHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('trunk_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('old', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('new', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='ip_modif_log_pkey')
    )
    op.create_table('rerate_cdr_download_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('task_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('download_file', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('finished_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['task_id'], ['rerate_cdr_task.id'], name='rerate_cdr_download_log_task_id_fkey', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id', name='rerate_cdr_download_log_pkey')
    )
    op.create_table('resource_ip_record',
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_ip_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ip', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('fqdn', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('sip_rpid', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('disable_by_alert', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('priority', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('last_priority', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('addr_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('direction', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('username', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('reg_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('reg_status', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('reg_srv_ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('reg_srv_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('expires', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('need_register', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_ip_record_pkey')
    )
    op.create_table('agent_client',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('commission', sa.NUMERIC(precision=5, scale=2), autoincrement=False, nullable=True),
    sa.Column('update_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('method_type', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['agent_id'], ['agent.agent_id'], name='fkey_agent_client_agent_agent_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='fkey_agent_client_client_client_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='agent_client_pkey')
    )
    op.create_table('alert_rules_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('alert_rules_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('finish_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('limit_acd_value', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('limit_asr_value', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('limit_abr_value', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('limit_pdd_value', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('limit_profitability_value', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('limit_revenue_value', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('limit_asr', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('limit_abr', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('limit_acd', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('limit_pdd', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('limit_profitability', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('limit_revenue', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='alert_rules_log_pkey')
    )
    op.create_table('client',
    sa.Column('client_id', sa.INTEGER(), server_default=sa.text("nextval('client_client_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('mode', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('orig_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('currency_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('allowed_credit', sa.NUMERIC(precision=30, scale=10), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('status', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=False),
    sa.Column('auto_invoicing', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=False),
    sa.Column('payment_term_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_format', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('attach_cdrs_list', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('cdr_list_format', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('last_invoiced', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('notify_client_balance', sa.NUMERIC(precision=30, scale=10), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('notify_admin_balance', sa.NUMERIC(precision=30, scale=10), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('low_balance_notice', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=False),
    sa.Column('company', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('address', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('logo', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('login', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('is_panelaccess', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_accountsummary', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_ratetable', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_trunks', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_products', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_balance', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_paymenthistory', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_onlinepayment', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('role_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.Column('profit_margin', postgresql.DOUBLE_PRECISION(precision=53), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('enough_balance', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('service_charge_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('noc_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('billing_email', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('tax_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('details', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('invoice_show_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('invoice_past_amount', sa.NUMERIC(precision=30, scale=10), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('is_link_cdr', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_trunk', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_route', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_spam', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_location', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_orig_term', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_usage', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_qos', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_discon', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_bill_mismatch', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_active_call', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_termin', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('database_name', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('is_rate_anal', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_capture', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_call_simulation', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_ingress_sim', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_egress_sim', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_report', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_tools', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_manage', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('mail_sended', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('scc_bellow', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('scc_percent', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('scc_charge', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profit_type', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('auto_invoice_type', sa.INTEGER(), server_default=sa.text('2'), autoincrement=False, nullable=False),
    sa.Column('cps_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_zone', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('invoice_zero', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('corporate_contact_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('paypal', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('is_auto_summary', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('auto_send_zone', sa.VARCHAR(), server_default=sa.text("'+00:00'::character varying"), autoincrement=False, nullable=True),
    sa.Column('is_daily_balance_notification', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('daily_balance_notification', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_recipient', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('low_balance_number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_auto_balance', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('numer_of_days_balance', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('auto_daily_balance_recipient', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('daily_cdr_generation', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('daily_cdr_generation_zone', sa.VARCHAR(), server_default=sa.text("'+00:00'::character varying"), autoincrement=False, nullable=True),
    sa.Column('daily_cdr_generation_type', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('transaction_fee_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('unlimited_credit', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('include_payment_history', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('include_available_credit', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('include_payment_history_days', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('auto_summary_not_zero', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('auto_summary_group_by', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('daily_balance_already_sent', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('last_autoreport_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('last_lowbalance_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('last_cdrdown_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('include_tax', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('tax', sa.NUMERIC(precision=5, scale=2), autoincrement=False, nullable=True),
    sa.Column('invoice_jurisdictional_detail', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('decimal_place', sa.INTEGER(), server_default=sa.text('5'), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_value', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('email_invoice', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('scc_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('is_invoice_account_summary', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_daily_usage', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('invoice_include_payment', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_short_duration_call_surcharge_detail', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('usage_detail_fields', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_hour', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_period', sa.INTEGER(), server_default=sa.text('24'), autoincrement=False, nullable=True),
    sa.Column('last_autobalance_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('auto_summary_include_cdr', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('client_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_delivery_email', sa.VARCHAR(length=250), autoincrement=False, nullable=True),
    sa.Column('invoice_use_balance_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('notify_client_balance_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('finance_email_cc', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('decimals_num', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_start_from', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('low_balance_notification_time_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('low_balance_notification_time_cycle', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('daily_balance_send_time', postgresql.TIME(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_send_time_zone', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('is_breakdown_by_rate_table', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('breakdown_by_rate_table', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('offset_balance', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_show_detail_trunk', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_total_trunk', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_code_100', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_code_name', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_country', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_by_date', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('daily_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('hourly_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('carrier_template_id', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('is_send_trunk_update', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('phone', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('is_panel_invoices', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_cdrslist', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_summaryreport', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_sippacket', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_mydid', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_panel_didrequest', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('is_send_as_link', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_vendor_invoice', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('vendor_payment_term_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('zero_balance_notice_time', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('zero_balance_notice_last_sent', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('zero_balance_notice_first_sended', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('zero_balance_notice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('payment_received_notice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['currency_id'], ['currency.currency_id'], name='fkey_client_currency_currency_id', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['payment_term_id'], ['payment_term.payment_term_id'], name='fkey_client_payment_term_payment_term_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('client_id', name='client_pkey'),
    sa.UniqueConstraint('login', name='client_login_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('modif_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('module', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('detail', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('rollback', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rollback_msg', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('rollback_flg', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('rollback_extra_info', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='modif_log_id')
    )
    op.create_table('cdr_report_detail20170923',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('lnp_cost', sa.NUMERIC(precision=15, scale=8), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_18s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_24s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_2h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_3h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_4h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_12s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('product_rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('incoming_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('outgoing_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('inter_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('npr_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.Column('ingress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ring_pdd', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_table('product_items_resource_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('item_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('by_percentage', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('order_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('order_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='product_items_resource_record_pkey')
    )
    op.create_table('currency_updates',
    sa.Column('currency_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('modify_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.Column('rate', sa.NUMERIC(precision=30, scale=6), autoincrement=False, nullable=False),
    sa.Column('last_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('currency_updates_id', sa.INTEGER(), nullable=False),
    sa.ForeignKeyConstraint(['currency_id'], ['currency.currency_id'], name='fkey_currency_updates_currency_currency_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('currency_updates_id', name='currency_updates_pkey')
    )
    op.create_table('agent_client_client',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('agent_client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('commission', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='agent_client_client_pkey'),
    sa.UniqueConstraint('client_id', name='agent_client_client_client_id_key')
    )
    op.create_table('invoice_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('cnt', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='class4_fkey_invoice_log_id')
    )
    op.create_table('system_configure',
    sa.Column('limit_cps', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('limit_cap', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('switch_name', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True)
    )
    op.create_table('kill_pg_sql_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('query', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('kill_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='kill_pg_sql_log_pkey')
    )
    op.create_table('resource_lrn_action_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('direction', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('action', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('digits', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('dnis', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_lrn_action_record_pkey')
    )
    op.create_table('qos_resource',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.Column('res_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('direction', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('server_ip', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('server_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('channels', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_table('import_rate_file_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('file_path', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('file_name', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_trunk_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('end_date', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('date_format', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('sample_do', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('ratetable_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('product_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('old_file_path', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='import_rate_file_log_pkey')
    )
    op.create_table('system_function',
    sa.Column('system_function_id', sa.INTEGER(), nullable=False),
    sa.Column('description', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('func_name', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('is_read', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_write', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_exe', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('func_url', sa.VARCHAR(length=512), autoincrement=False, nullable=True),
    sa.Column('func_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('key_118n', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('parent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('image_name', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('develop_status', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('system_function_id', name='system_function_pkey')
    )
    op.create_table('dynamic_route_override',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('digits', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('percentage', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['dynamic_route_id'], ['dynamic_route.dynamic_route_id'], name='class4_fkey_dynamic_route_override_dynamic_route_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='class4_fkey_dynamic_route_override_resource_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='class4_pkey_dynamic_route_override_id')
    )
    op.create_table('resource_capacity_record',
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_cap', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_capacity_record_pkey')
    )
    op.create_table('product_record',
    sa.Column('product_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('modify_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('introduction', sa.VARCHAR(length=80), autoincrement=False, nullable=True),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('code_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code_deck_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_lrn', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='product_record_pkey')
    )
    op.create_table('jurisdiction_prefix',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('alias', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('prefix', sa.NullType(), autoincrement=False, nullable=False),
    sa.Column('jurisdiction_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_country_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_country_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ocn', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('lata', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('block_id', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('effective_date', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='jurisdiction_prefix_pkey')
    )
    op.create_table('service_charge_items',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('min_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('max_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('charge_value', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('service_charge_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='service_charge_items_pkey')
    )
    op.create_table('rerate_cdr_task',
    sa.Column('id', sa.INTEGER(), server_default=sa.text("nextval('rerate_cdr_task_id_seq'::regclass)"), nullable=False),
    sa.Column('from_time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('to_time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('timezone', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('update_lrn', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('update_us_jurisdiction', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('ingress_trunk', sa.VARCHAR(length=1024), autoincrement=False, nullable=True),
    sa.Column('egress_trunk', sa.VARCHAR(length=1024), autoincrement=False, nullable=True),
    sa.Column('lrn_server_ip', sa.VARCHAR(length=16), autoincrement=False, nullable=True),
    sa.Column('lrn_server_port', sa.INTEGER(), server_default=sa.text('5060'), autoincrement=False, nullable=False),
    sa.Column('cdr_file', sa.VARCHAR(length=4096), autoincrement=False, nullable=True),
    sa.Column('err_code', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('include_q850', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('progress', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('load_cdr_elapsed_sec', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('load_rate_elapsed_sec', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('rerate_elapsed_sec', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('create_time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('start_time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('end_time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('cdr_file_path', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('download_file', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('client_ids', sa.VARCHAR(length=1024), autoincrement=False, nullable=True),
    sa.Column('update_local_rate', sa.SMALLINT(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('id', name='rerate_cdr_task_pkey'),
    postgresql_ignore_search_path=False
    )
    op.create_table('trunk_group',
    sa.Column('group_id', sa.INTEGER(), server_default=sa.text("nextval('trunk_group_group_id_seq'::regclass)"), nullable=False),
    sa.Column('group_name', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('trunk_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('group_id', name='trunk_group_pkey'),
    sa.UniqueConstraint('group_name', name='trunk_group_name_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('resource_next_route_rule_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('reponse_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('return_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('return_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_next_route_rule_record_pkey')
    )
    op.create_table('dynamic_route_items_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='dynamic_route_items_record_pkey')
    )
    op.create_table('cdr_report_detail',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('lnp_cost', sa.NUMERIC(precision=15, scale=8), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_18s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_24s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_2h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_3h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_4h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_12s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('product_rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('incoming_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('outgoing_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('inter_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('npr_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.Column('ingress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ring_pdd', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_table('random_ani_generation_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_number', sa.VARCHAR(length=32), autoincrement=False, nullable=True),
    sa.Column('random_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='random_ani_generation_record_pkey')
    )
    op.create_table('resource_translation_ref',
    sa.Column('ref_id', sa.INTEGER(), nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('translation_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='fkey_resource_translation_ref_resource_resource_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['time_profile_id'], ['time_profile.time_profile_id'], name='fkey_resource_translation_ref_time_profile_time_profile_id', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['translation_id'], ['digit_translation.translation_id'], name='fkey_resource_translation_ref_digit_translation_translation_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('ref_id', name='resource_translation_ref_pkey')
    )
    op.create_table('resource_ip_limit',
    sa.Column('limit_id', sa.INTEGER(), nullable=False),
    sa.Column('ip_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('capacity', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['ip_id'], ['resource_ip.resource_ip_id'], name='fkey_resource_ip_limit_resource_ip_ip_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['time_profile_id'], ['time_profile.time_profile_id'], name='fkey_resource_ip_limit_time_profile_time_profile_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('limit_id', name='resource_ip_limit_pkey')
    )
    op.create_table('resource',
    sa.Column('resource_id', sa.INTEGER(), server_default=sa.text("nextval('resource_resource_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('egress', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('active', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=False),
    sa.Column('rfc_2833', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('t38', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('alias', sa.VARCHAR(length=100), server_default=sa.text('NULL::character varying'), autoincrement=False, nullable=False),
    sa.Column('res_strategy', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('cps_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('capacity', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lnp', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('lrn_block', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('tdm', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=False),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('transnexus', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_strategy_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('media_type', sa.INTEGER(), server_default=sa.text('2'), autoincrement=False, nullable=False),
    sa.Column('pass_through', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profit_margin', postgresql.DOUBLE_PRECISION(precision=53), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('enough_balance', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('egress_bill_after_action', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('proto', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('dnis_only', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=False),
    sa.Column('ring_timeout', sa.INTEGER(), server_default=sa.text('60'), autoincrement=False, nullable=False),
    sa.Column('ignore_ring', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('ignore_early_media', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('disable_by_alert', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('priority', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('last_priority', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('wait_ringtime180', sa.INTEGER(), server_default=sa.text('6000'), autoincrement=False, nullable=True),
    sa.Column('profit_type', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('lnp_dipping', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('lnp_dipping_rate', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('cli_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auth_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('delay_bye_second', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('delay_bye_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('marketplace', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('rating_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('billing_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('trunk_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('switch_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('transaction_fee_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('service_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('product_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('paid', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('oli', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('pci', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('priv', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('div', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('trunk_type2', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('account_id', sa.CHAR(length=32), autoincrement=False, nullable=True),
    sa.Column('billing_method', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('amount_per_port', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('billing_rule', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ignore_early_nosdp', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('media_timeout', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('private', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('agent_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('bill_by', sa.INTEGER(), server_default=sa.text('4'), autoincrement=False, nullable=True),
    sa.Column('rate_profile', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('us_route', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('intl_route', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('canada_route', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('rate_decimal', sa.INTEGER(), server_default=sa.text('6'), autoincrement=False, nullable=True),
    sa.Column('rate_rounding', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('us_other', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('canada_other', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('redirect', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('lrn_prefix', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('pass_response_code', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('is_del', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('dtmf_type', sa.INTEGER(), server_default=sa.text('3'), autoincrement=False, nullable=True),
    sa.Column('dtmf_detect', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('rpid_screen', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('rpid_party', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('display_name', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid_id_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('rpid_privacy', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('counter_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('block_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('re_invite', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('re_invite_interval', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('info', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rfc2833', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inband', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dummy_trunk', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('random_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_virtual', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('rfc_r833_payload', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_template_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_use_rpid', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_block_group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('block_404_number_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('enfource_cid', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='fkey_resource_client_client_id', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['group_id'], ['trunk_group.group_id'], name='fkey_resource_trunk_group_group_id', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['rate_table_id'], ['rate_table.rate_table_id'], name='fkey_resource_rate_table_rate_table_id', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['route_strategy_id'], ['route_strategy.route_strategy_id'], name='fkey_resource_route_strategy_route_strategy_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('resource_id', name='resource_pkey'),
    sa.UniqueConstraint('alias', name='resource_alias_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('mail_tmplate',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('invoice_to', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('invoice_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('invoice_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_to', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('lowbalance_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('lowbalance_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('noc_email_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('noc_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('carrier_email_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('carrier_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('alert_email_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('carrier_invoice_subject', sa.TEXT(), server_default=sa.text("'Invoice form {start_Date} – {end_date}'::text"), autoincrement=False, nullable=True),
    sa.Column('carrier_invoice_content', sa.TEXT(), server_default=sa.text("'Dear {carrier_name},\r\n          This is invoice {invoice_number} for {start_date} – {end_date}.\r\n        Please remit your due balance within the terms of your contractual\r\n        agreement to avoid disconnection of service.\r\n--\r\nAutogenerated by billing system'::text"), autoincrement=False, nullable=True),
    sa.Column('auto_summary_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_balance_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_balance_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_delivery_subject', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('auto_delivery_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_cdr_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('auto_cdr_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('no_route_available_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('no_route_available_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('target_match_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('target_match_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_watch_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('rate_watch_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('route_update_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('route_update_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_update_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('rate_update_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('low_balance_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('low_balance_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('new_invoice_posted_mail_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('new_invoice_posted_mail_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_sent_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('payment_sent_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_received_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('payment_received_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('send_cdr_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('send_cdr_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('select_route_up_email_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('select_route_up_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('exchange_auto_summary_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('exchange_auto_summary_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('finance_alert_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('finance_alert_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('buy_qos_alert_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('buy_qos_alert_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('sell_qos_alert_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('sell_qos_alert_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('lowbalance_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('noc_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('carrier_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_balance_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_cdr_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('payment_sent_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('payment_received_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('send_cdr_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('no_route_available_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('target_match_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_watch_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('route_update_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_update_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('low_balance_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('select_route_up_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('new_invoice_posted_mail_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('exchange_auto_summary_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('finance_alert_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('buy_qos_alert_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('sell_qos_alert_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_success_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_success_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_success_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_fail_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_fail_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_fail_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('invoice_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_from_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('lowbalance_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('alert_email_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_balance_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_cdr_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('send_cdr_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_sent_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_received_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('daily_payment_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('daily_payment_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('daily_payment_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('dialer_detection_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('dialer_detection_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('retrieve_password_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('retrieve_password_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('retrieve_password_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_success', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_failure', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_change_from', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('trunk_change_subject', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('trunk_change_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('fraud_detection_from', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('fraud_detection_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('fraud_detection_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('welcom_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('welcom_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('welcom_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_rate_notice_from', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('download_rate_notice_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_rate_notice_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('no_download_rate_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('no_download_rate_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('no_download_rate_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('vendor_invoice_dispute_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('vendor_invoice_dispute_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('vendor_invoice_dispute_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('vendor_invoice_dispute_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_interop_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_interop_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_interop_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_interop_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('regletter_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('regletter_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('regletter_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('regletter_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('paymresvd_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('paymresvd_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('paymresvd_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('paymresvd_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='mail_tmplate_pkey')
    )
    op.create_table('code',
    sa.Column('code_id', sa.INTEGER(), nullable=False),
    sa.Column('code', sa.NullType(), autoincrement=False, nullable=False),
    sa.Column('code_deck_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('city', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('state', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('code_id', name='class4_pkey_code_id')
    )
    op.create_table('execution_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('rule_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('ani_find', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('of_calls', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('msg', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('exec_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='execution_log_pkey')
    )
    op.create_table('egress_profile',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('server_name', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['egress_id'], ['resource.resource_id'], name='fkey_egress_profile_resource_egress_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['profile_id'], ['switch_profile.id'], name='fkey_egress_profile_switch_profile_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='egress_profile_pkey')
    )
    op.create_table('client_record',
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('mode', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('currency_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('allowed_credit', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('status', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('auto_invoicing', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('payment_term_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_format', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('attach_cdrs_list', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('cdr_list_format', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('last_invoiced', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('notify_client_balance', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('notify_admin_balance', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('low_balance_notice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('company', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('address', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('logo', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('login', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('is_panelaccess', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_accountsummary', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_ratetable', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_trunks', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_products', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_balance', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_paymenthistory', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_onlinepayment', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('role_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('profit_margin', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('enough_balance', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('service_charge_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('noc_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('billing_email', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('tax_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('details', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('invoice_show_details', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('invoice_past_amount', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('is_link_cdr', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_trunk', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_route', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_spam', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_location', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_orig_term', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_usage', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_qos', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_discon', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_bill_mismatch', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_active_call', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_termin', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('database_name', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('is_rate_anal', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_capture', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_call_simulation', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_ingress_sim', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_egress_sim', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_report', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_tools', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_manage', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('mail_sended', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('scc_bellow', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('scc_percent', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('scc_charge', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profit_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_invoice_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cps_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_zone', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('invoice_zero', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('corporate_contact_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('paypal', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('is_auto_summary', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('auto_send_zone', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('is_daily_balance_notification', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_notification', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_recipient', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('low_balance_number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_auto_balance', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('numer_of_days_balance', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_daily_balance_recipient', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_cdr_generation', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('daily_cdr_generation_zone', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('daily_cdr_generation_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('transaction_fee_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('unlimited_credit', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('include_payment_history', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('include_available_credit', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('include_payment_history_days', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_not_zero', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_group_by', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_already_sent', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('last_autoreport_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('last_lowbalance_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('last_cdrdown_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('include_tax', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('tax', sa.NUMERIC(precision=5, scale=2), autoincrement=False, nullable=True),
    sa.Column('invoice_jurisdictional_detail', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('decimal_place', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_value', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('email_invoice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('scc_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_invoice_account_summary', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_daily_usage', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('invoice_include_payment', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_short_duration_call_surcharge_detail', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('usage_detail_fields', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_hour', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_period', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('last_autobalance_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('auto_summary_include_cdr', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('client_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_delivery_email', sa.VARCHAR(length=250), autoincrement=False, nullable=True),
    sa.Column('invoice_use_balance_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('notify_client_balance_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('finance_email_cc', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('decimals_num', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_start_from', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('low_balance_notification_time_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('low_balance_notification_time_cycle', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_send_time', postgresql.TIME(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_send_time_zone', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('is_breakdown_by_rate_table', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('breakdown_by_rate_table', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('offset_balance', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_detail_trunk', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_total_trunk', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_code_100', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_code_name', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_country', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_by_date', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('daily_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('hourly_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('carrier_template_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_send_trunk_update', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('phone', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('is_panel_invoices', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_cdrslist', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_summaryreport', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_sippacket', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_mydid', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_panel_didrequest', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_send_as_link', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_vendor_invoice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('vendor_payment_term_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('zero_balance_notice_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('zero_balance_notice_last_sent', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('zero_balance_notice_first_sended', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('zero_balance_notice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('payment_received_notice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='client_record_pkey')
    )
    op.create_table('balance_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('balance', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('date', sa.DATE(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='balance_log_pkey')
    )
    op.create_table('global_failover',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('failover_strategy', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('from_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='global_failover_pkey'),
    sa.UniqueConstraint('from_sip_code', name='global_failover_from_sip_code_key')
    )
    op.create_table('import_rate_status',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('delete_queue', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_queue', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('insert_queue', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('error_counter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('reimport_counter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('error_log_file', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('reimport_log_file', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('time', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.Column('upload_file_name', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('local_file', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('method', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('start_epoch', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('end_epoch', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('sql_record', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('default_info', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='import_rate_status_pkey')
    )
    op.create_table('rate_record',
    sa.Column('rate_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('setup_fee', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('effective_date', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('end_date', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('min_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('grace_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('interval', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('seconds', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('basic_percentages', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('gift_percentages', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('rate_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('inter_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('local_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('zone', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('ocn', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('lata', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('did_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='rate_record_pkey')
    )
    op.create_table('captcha',
    sa.Column('captcha_id', sa.INTEGER(), nullable=False),
    sa.Column('captcha_time', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('ip_address', sa.VARCHAR(length=16), autoincrement=False, nullable=False),
    sa.Column('word', sa.VARCHAR(length=20), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('captcha_id', name='captcha_pkey')
    )
    op.create_table('sip_registrations',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('username', sa.VARCHAR(length=40), autoincrement=False, nullable=False),
    sa.Column('network_ip', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('network_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('expires', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('contact', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('uptime', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='sip_registrations_pkey')
    )
    op.create_table('did_billing_plan',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('did_price', sa.REAL(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('min_price', sa.REAL(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('payphone_subcharge', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('monthly_charge', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='did_billing_plan_pkey')
    )
    op.create_table('send_rate_template',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('name', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('subject', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='send_rate_template_id')
    )
    op.create_table('dashboard_time_option',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('admin_point_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('client_point_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('iden', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='dashboard_time_option_pkey')
    )
    op.create_table('agent_commission_history',
    sa.Column('history_id', sa.INTEGER(), nullable=False),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('total_date', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('finished', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['agent_id'], ['agent.agent_id'], name='agent_commission_history_agent_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('history_id', name='agent_commission_history_pkey')
    )
    op.create_table('resource_block_items_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('block_resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('active', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_block_items_record_pkey')
    )
    op.create_table('translation_item_record',
    sa.Column('ref_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('translation_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('dnis', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('action_ani', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('action_dnis', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('ani_method', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_method', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='translation_item_record_pkey')
    )
    op.create_table('c4_livecall_user',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('name', sa.VARCHAR(length=50), autoincrement=False, nullable=False),
    sa.Column('password', sa.VARCHAR(length=50), autoincrement=False, nullable=False),
    sa.Column('user_type', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('id', name='c4_livecall_user_pkey')
    )
    op.create_table('retrieve_password_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('username', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('operation_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('email_addresses', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('modify_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='retrieve_password_log_pkey')
    )
    op.create_table('trouble_tickets_template',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('title', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('updated_by', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='trouble_tickets_template_pkey')
    )
    op.create_table('invoice_payment',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_no', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('payment_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('payment_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='invoice_payment_pkey')
    )
    op.create_table('currency_record',
    sa.Column('currency_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('active', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.Column('rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('record_id', name='currency_record_pkey')
    )
    op.create_table('rate_table_record',
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('modify_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('code_deck_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('currency_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_country_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('lnp_dipping_rate', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_prefix', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('noprefix_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('noprefix_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('prefix_min_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('prefix_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('jur_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('origination', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_virtual', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='rate_table_record_pkey')
    )
    op.create_table('agent_client_client_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('commission', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='agent_client_client_record_pkey')
    )
    op.create_table('dynamic_route_qos',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('digits', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=False),
    sa.Column('min_asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_abr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_abr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_aloc', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_aloc', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('limit_price', sa.REAL(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['dynamic_route_id'], ['dynamic_route.dynamic_route_id'], name='fkey_dynamic_route_qos_dynamic_route_dynamic_route_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='dynamic_route_qos_pkey')
    )
    op.create_table('currency_updates_record',
    sa.Column('currency_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('modify_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('rate', sa.NUMERIC(precision=30, scale=6), autoincrement=False, nullable=True),
    sa.Column('last_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('currency_updates_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='currency_updates_record_pkey')
    )
    op.create_table('rerate_report_exec_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('finish_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('exec_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('task_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('total_files_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('success_files_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['task_id'], ['rerate_cdr_task.id'], name='rerate_report_exec_log_task_id_fkey', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id', name='rerate_report_exec_log_pkey')
    )
    op.create_table('payment_gateway_history',
    sa.Column('chargetotal', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('method', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('cardnumber', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('cardexpmonth', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('cardexpyear', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('created_time', postgresql.TIMESTAMP(), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('modified_time', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.Column('error', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('confirmed', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('fee', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_id', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('address1', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('address2', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('city', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('state_province', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('zip_code', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('credit_card_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('paypal_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('transaction_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('return_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('charge_type', sa.NUMERIC(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('charge_amount', sa.NUMERIC(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('response', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='payment_gateway_history_pkey')
    )
    op.create_table('rate_generation_template_detail',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('rate_generation_template_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_interval', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['rate_generation_template_id'], ['rate_generation_template.id'], name='fkey_rate_generation_template_detail_rate_gen_template_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='rate_generation_template_detail_pkey')
    )
    op.create_table('invoice_history',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('last_invoice_for', sa.DATE(), server_default=sa.text("('now'::text)::date"), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='invoice_history_pkey')
    )
    op.create_table('resource_capacity',
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_cap', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_table('origination_global_failover',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('failover_strategy', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('from_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('to_sip_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='origination_global_failover_pkey')
    )
    op.create_table('time_profile',
    sa.Column('time_profile_id', sa.INTEGER(), server_default=sa.text("nextval('time_profile_time_profile_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('start_time', postgresql.TIME(), autoincrement=False, nullable=True),
    sa.Column('end_time', postgresql.TIME(), autoincrement=False, nullable=True),
    sa.Column('start_week', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('end_week', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('time_zone', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('time_profile_id', name='time_profile_pkey'),
    sa.UniqueConstraint('name', name='time_profile_name_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('client_balance',
    sa.Column('client_id', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('balance', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
    sa.Column('ingress_balance', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_balance', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('bod_balance', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('client_id', name='client_balance_pkey')
    )
    op.create_table('rate_mass_edit_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('action_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('action_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('down_file_path', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('action_rate_rows', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='rate_mass_edit_log_id')
    )
    op.create_table('mail_cdr_log_detail',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('mail_cdr_log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('order', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cdr_start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('cdr_end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('file_size', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('filename', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['mail_cdr_log_id'], ['mail_cdr_log.id'], name='mail_cdr_log_detail_mail_cdr_log_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='mail_cdr_log_detail_pkey')
    )
    op.create_table('api_entity',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('name', sa.VARCHAR(length=32), autoincrement=False, nullable=False),
    sa.Column('path', sa.VARCHAR(length=64), autoincrement=False, nullable=False),
    sa.Column('has_write_permission', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('id', name='api_entity_pkey'),
    sa.UniqueConstraint('name', name='api_entity_name_key'),
    sa.UniqueConstraint('path', name='api_entity_path_key')
    )
    op.create_table('resource_next_route_rule',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('route_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('reponse_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('return_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('return_string', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='resource_next_route_rule_pkey'),
    sa.UniqueConstraint('reponse_code', 'resource_id', name='resource_next_route_rule_reponse_code_resource_id_uni')
    )
    op.create_table('dynamic_route_items',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['dynamic_route_id'], ['dynamic_route.dynamic_route_id'], name='fkey_dynamic_route_items_dynamic_route_dynamic_route_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='fkey_dynamic_route_items_resource_resource_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='dynamic_route_items_pkey')
    )
    op.create_table('client_balance_operation_action',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('balance', sa.NUMERIC(precision=12, scale=6), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('ingress_balance', sa.NUMERIC(precision=12, scale=6), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('egress_balance', sa.NUMERIC(precision=12, scale=6), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('action', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_result', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('update_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('update_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('id', name='client_balance_operation_action_pkey')
    )
    op.create_table('c4_client_balance',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('client_id', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('balance', sa.NUMERIC(precision=30, scale=6), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('ingress_balance', sa.NUMERIC(precision=30, scale=6), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('egress_balance', sa.NUMERIC(precision=30, scale=6), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('id', name='c4_client_balance_pkey')
    )
    op.create_table('ftp_cdr_log_detail',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('ftp_cdr_log_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('file_name', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('ftp_ip', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('ftp_dir', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('detail', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('local_file_path', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='ftp_cdr_log_detail_pkey')
    )
    op.create_table('service_charge_items_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('max_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('charge_value', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('service_charge_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='service_charge_items_record_pkey')
    )
    op.create_table('ftp_server_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('cmd', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('response', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='ftp_server_log_pkey')
    )
    op.create_table('send_mails',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('mail_subject', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('mail_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('mail_to', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('mail_cc', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('files', postgresql.ARRAY(sa.VARCHAR(length=200)), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('send_time', postgresql.TIME(timezone=True), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='send_mails_pkey')
    )
    op.create_table('resource_block_record',
    sa.Column('ingress_res_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('engress_res_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('digit', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('res_block_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('disable_by_alert', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('ani_prefix', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('ani_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_method', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_method', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_empty', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('action_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('block_log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('loop_block_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ticket_log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code_name', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('dialer_detection_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_max_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('full_match', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('unblock_at', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('block_at', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('unblock_after', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_block_record_pkey')
    )
    op.create_table('signup',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('company', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('login', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('address', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('noc_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('billing_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('rate_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('rate_delivery_email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('tax_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('details', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('phone', sa.VARCHAR(length=32), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('modify_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('signup_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('send_email', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('contact_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('city', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('state', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('zip', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('billing_address', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('billing_city', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('billing_state', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('billing_zip', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('billing_country', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('billing_contact_name', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('billing_phone', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('product_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='signup_pkey')
    )
    op.create_table('did_assign',
    sa.Column('number', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('created_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('assigned_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['egress_id'], ['resource.resource_id'], name='did_assign_egress_id_fkey'),
    sa.PrimaryKeyConstraint('number', name='did_assign_pkey')
    )
    op.create_table('agent_clients',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('commission', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('assigned_on', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=True),
    sa.Column('assigned_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('method_type', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['agent_id'], ['agent.agent_id'], name='agent_clients_agent_id_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='agent_clients_client_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='agent_clients_pkey'),
    sa.UniqueConstraint('agent_id', 'client_id', name='agent_clients_agent_id_client_id_key')
    )
    op.create_table('did_billing_rel',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('did', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('sell_billing_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('buy_billing_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('did_billing_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('start_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('ingress_res_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_res_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('end_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='did_billing_rel_pkey')
    )
    op.create_table('carrier_template',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('allowed_credit', sa.NUMERIC(), autoincrement=False, nullable=False),
    sa.Column('attach_cdrs_list', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('auto_daily_balance_recipient', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_invoice_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_invoicing', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('auto_send_zone', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_group_by', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_hour', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_include_cdr', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_not_zero', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_period', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('breakdown_by_rate_table', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('call_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cdr_list_format', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cps_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('currency_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('daily_balance_notification', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_recipient', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_send_time', postgresql.TIME(), autoincrement=False, nullable=True),
    sa.Column('daily_balance_send_time_zone', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('daily_cdr_generation', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('daily_cdr_generation_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('daily_cdr_generation_zone', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('daily_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('decimal_place', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('email_invoice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('hourly_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('include_available_credit', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('include_tax', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('invoice_format', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_include_payment', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('invoice_jurisdictional_detail', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('invoice_show_details', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('invoice_start_from', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('invoice_use_balance_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_zero', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('invoice_zone', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('is_auto_balance', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_auto_summary', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_breakdown_by_rate_table', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_daily_balance_notification', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_email_invoice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_invoice_account_summary', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_send_as_link', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_send_trunk_update', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_short_duration_call_surcharge_detail', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_by_date', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_code_100', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_code_name', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_country', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_daily_trunk', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_daily_usage', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_detail_trunk', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_show_total_trunk', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('last_invoiced', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('mode', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('notify_client_balance', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('notify_client_balance_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('numer_of_days_balance', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('payment_term_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profit_margin', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
    sa.Column('profit_type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('rate_value', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('scc_bellow', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('scc_charge', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('scc_percent', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('scc_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('tax', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('template_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('update_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('usage_detail_fields', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('unlimited_credit', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('test_credit', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='carrier_template_pkey'),
    sa.UniqueConstraint('template_name', name='carrier_template_template_name_key')
    )
    op.create_table('client_low_balance_config',
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('is_notify', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('value_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('actual_notify_balance', sa.NUMERIC(precision=30, scale=2), autoincrement=False, nullable=True),
    sa.Column('percentage_notify_balance', sa.NUMERIC(precision=30, scale=2), autoincrement=False, nullable=True),
    sa.Column('send_time_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_send_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duplicate_days', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('send_to', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duplicate_send_days', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('last_alert_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('disable_trunks_days', sa.INTEGER(), server_default=sa.text('5'), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='fkey_client_low_balance_config_client_client_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('client_id', name='client_low_balance_config_pkey')
    )
    op.create_table('random_ani_generation',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('ani_number', sa.VARCHAR(length=32), autoincrement=False, nullable=True),
    sa.Column('random_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='random_ani_generation_pkey')
    )
    op.create_table('invoice_cdr_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_number', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('carrier_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='invoice_cdr_log_pkey')
    )
    op.create_table('allowed_sendto_ip',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('direction', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('sip_profile_ip', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('sip_profile_port', sa.INTEGER(), autoincrement=False, nullable=True)
    )
    op.create_table('ftp_cdr',
    sa.Column('ftp_user', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('ftp_pw', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('run_freq', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cdr_fields', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('cdr_start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('cdr_end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('last_run_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('cdr_alias', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('ftp_user', name='ftp_cdr_pkey')
    )
    op.create_table('rate',
    sa.Column('rate_id', sa.INTEGER(), nullable=False),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('code', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=False),
    sa.Column('rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('setup_fee', sa.NUMERIC(precision=30, scale=10), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('effective_date', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.Column('end_date', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('min_time', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('grace_time', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('interval', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('seconds', sa.INTEGER(), server_default=sa.text('60'), autoincrement=False, nullable=False),
    sa.Column('code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('basic_percentages', sa.REAL(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('gift_percentages', sa.REAL(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('rate_type', sa.INTEGER(), server_default=sa.text('3'), autoincrement=False, nullable=False),
    sa.Column('intra_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('inter_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('local_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('zone', sa.VARCHAR(length=10), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('ocn', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('lata', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('did_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['rate_table_id'], ['rate_table.rate_table_id'], name='fkey_rate_rate_table_rate_table_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['time_profile_id'], ['time_profile.time_profile_id'], name='fkey_rate_time_profile_time_profile_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('rate_id', name='rate_pkey')
    )
    op.create_table('sip_error_code',
    sa.Column('sip_error_code_id', sa.INTEGER(), nullable=False),
    sa.Column('return_code', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('return_code_str', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('switch_error_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('switch_error_code_str', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('sip_error_code_id', name='sip_error_code_pkey')
    )
    op.create_table('egress_profile_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('server_name', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='egress_profile_record_pkey')
    )
    op.create_table('cdr_report_detail20170920',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('lnp_cost', sa.NUMERIC(precision=15, scale=8), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_country', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress_prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_30', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('duration_6', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_18s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_24s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_2h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_3h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_4h', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('call_12s', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('product_rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('egress_rate_date', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('incoming_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('outgoing_bandwidth', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_intra', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_inter', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_intra', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time_inter', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('agent_cost', sa.NUMERIC(precision=12, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_plan_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('orig_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('term_jur_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('origination_destination_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('termination_source_host_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('binary_value_of_release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('release_cause', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('release_cause_from_protocol_stack', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('inter_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('q850_cause_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('npr_count', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_local', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost_ij', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.Column('ingress_code', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ring_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.CheckConstraint("(report_time >= '2017-09-20 00:00:00+00'::timestamp with time zone) AND (report_time < '2017-09-21 00:00:00+00'::timestamp with time zone)", name='timecheck')
    )
    op.create_table('resource_prefix_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('tech_prefix', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('route_strategy_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('code_cps', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code_cap', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('product_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_prefix_record_pkey')
    )
    op.create_table('route',
    sa.Column('route_id', sa.INTEGER(), nullable=False),
    sa.Column('digits', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=True),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('static_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('route_strategy_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('lnp', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('lrn_block', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('dnis_only', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('code_deck_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('intra_static_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_static_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_country_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_prefix', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('ani_min_length', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('ani_max_length', sa.INTEGER(), server_default=sa.text('32'), autoincrement=False, nullable=True),
    sa.Column('digits_min_length', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('digits_max_length', sa.INTEGER(), server_default=sa.text('32'), autoincrement=False, nullable=True),
    sa.Column('code_name', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('route_type_flg', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['dynamic_route_id'], ['dynamic_route.dynamic_route_id'], name='fkey_route_dynamic_route_dynamic_route_id', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['route_strategy_id'], ['route_strategy.route_strategy_id'], name='fkey_route_route_strategy_route_strategy_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['static_route_id'], ['product.product_id'], name='fkey_route_product_static_route_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('route_id', name='route_pkey')
    )
    op.create_table('resource_ip',
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('resource_ip_id', sa.INTEGER(), nullable=False),
    sa.Column('ip', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('port', sa.INTEGER(), server_default=sa.text('5060'), autoincrement=False, nullable=True),
    sa.Column('fqdn', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('sip_rpid', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('disable_by_alert', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('priority', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('last_priority', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('addr_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('direction', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('username', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('reg_type', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('reg_status', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('reg_srv_ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('reg_srv_port', sa.INTEGER(), server_default=sa.text('5060'), autoincrement=False, nullable=False),
    sa.Column('expires', sa.INTEGER(), server_default=sa.text('3600'), autoincrement=False, nullable=False),
    sa.Column('profile_id', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('need_register', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='fkey_resource_ip_resource_resource_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('resource_ip_id', name='resource_ip_pkey')
    )
    op.create_table('dynamic_route_qos_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dynamic_route_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('digits', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('min_asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_asr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_abr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_abr', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_acd', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('min_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_pdd', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('min_aloc', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('max_aloc', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('limit_price', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='dynamic_route_qos_record_pkey')
    )
    op.create_table('daily_cdr_fields',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('field', sa.VARCHAR(), autoincrement=False, nullable=False),
    sa.Column('label', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='daily_cdr_fields_pkey')
    )
    op.create_table('product_rout_rate_table_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rout_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('product_name', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('marketplace', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('prefix', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('description', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('allowed_client', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='product_rout_rate_table_record_pkey')
    )
    op.create_table('users',
    sa.Column('user_id', sa.INTEGER(), nullable=False),
    sa.Column('name', sa.VARCHAR(length=40), autoincrement=False, nullable=False),
    sa.Column('password', sa.VARCHAR(length=60), autoincrement=False, nullable=False),
    sa.Column('role_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('reseller_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
    sa.Column('active', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('fullname', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('user_type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('create_user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('last_login_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('card_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_online', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('login_ip', sa.VARCHAR(length=15), autoincrement=False, nullable=True),
    sa.Column('default_mod', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('default_mod2', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('last_seen', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('report_group', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('outbound_report', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('all_termination', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('show_carrier_trunk_drop_only', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('report_fields', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('landing_page', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('user_id', name='users_pkey'),
    sa.UniqueConstraint('name', name='users_name_key')
    )
    op.create_table('resource_codecs_ref',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('codec_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['codec_id'], ['codecs.id'], name='fkey_resource_codecs_ref_codecs_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.resource_id'], name='fkey_resource_codecs_ref_resource_resource_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='resource_codecs_ref_pkey')
    )
    op.create_table('c4_livecall_user_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('user_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='c4_livecall_user_record_pkey')
    )
    op.create_table('fraud_detection',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('rule_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('active', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('hourly_minute', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('hourly_revenue', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_minute', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_revenue', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_block', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_send_mail', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('email_to', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_ids', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('update_on', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='fraud_detection_pkey'),
    sa.UniqueConstraint('rule_name', name='fraud_detection_rule_name_key')
    )
    op.create_table('payment_term',
    sa.Column('payment_term_id', sa.INTEGER(), server_default=sa.text("nextval('payment_term_payment_term_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('days', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('grace_days', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('notify_days', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('more_days', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('finance_rate', sa.REAL(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('payment_term_id', name='payment_term_pkey'),
    sa.UniqueConstraint('name', name='payment_term_name_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('host_based_report',
    sa.Column('report_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('ingress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('not_zero_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_call_cost', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True),
    sa.Column('egress_total_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_success_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_busy_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_cancel_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_ip', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('egress_ip', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('ingress_avg_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('egress_avg_rate', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('cdr_date', sa.VARCHAR(length=24), autoincrement=False, nullable=True)
    )
    op.create_table('sip_error_code_record',
    sa.Column('sip_error_code_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('return_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('return_code_str', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('switch_error_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('switch_error_code_str', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='sip_error_code_record_pkey')
    )
    op.create_table('time_profile_record',
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('start_time', postgresql.TIME(), autoincrement=False, nullable=True),
    sa.Column('end_time', postgresql.TIME(), autoincrement=False, nullable=True),
    sa.Column('start_week', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('end_week', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time_zone', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='time_profile_record_pkey')
    )
    op.create_table('resource_translation_ref_record',
    sa.Column('ref_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('translation_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='resource_translation_ref_record_pkey')
    )
    op.create_table('c4_lrn',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('srv1_ip', sa.VARCHAR(length=16), autoincrement=False, nullable=True),
    sa.Column('srv1_port', sa.INTEGER(), server_default=sa.text('5060'), autoincrement=False, nullable=False),
    sa.Column('srv2_ip', sa.VARCHAR(length=16), autoincrement=False, nullable=True),
    sa.Column('srv2_port', sa.INTEGER(), server_default=sa.text('5060'), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('id', name='c4_lrn_pkey')
    )
    op.create_table('product_rout_rate_table',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('rout_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('product_name', sa.VARCHAR(length=256), autoincrement=False, nullable=False),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('marketplace', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('par_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('prefix', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('description', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('allowed_client', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['rate_table_id'], ['rate_table.rate_table_id'], name='product_rout_rate_table_rate_table_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['rout_id'], ['route_strategy.route_strategy_id'], name='product_rout_rate_table_rout_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='product_rout_rate_table_pkey'),
    sa.UniqueConstraint('rate_table_id', 'rout_id', name='product_rout_rate_table_rate_table_id_rout_id_uni')
    )
    op.create_table('client_payment',
    sa.Column('client_payment_id', sa.INTEGER(), nullable=False),
    sa.Column('payment_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
    sa.Column('amount', sa.NUMERIC(precision=20, scale=10), autoincrement=False, nullable=False),
    sa.Column('result', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cause', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('description', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('approved', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('current_balance', sa.NUMERIC(precision=30, scale=10), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('invoice_number', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('payment_type', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=True),
    sa.Column('payment_method', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('email_sended', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('receiving_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('egress_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='fkey_client_payment_client_client_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('client_payment_id', name='client_payment_pkey')
    )
    op.create_table('rate_generation_template',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('name', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('include_blocked_route', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('rate_table_type', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('lcr_digit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('default_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('margin_default_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('margin_default_value', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('default_interval', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('default_min_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('last_generated', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('code_deck_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_str', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('include_local_rate', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('effective_days', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('decimal_places', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('user_defined_code_deck', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='rate_generation_template_pkey')
    )
    op.create_table('alert_rules',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('rule_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('trunk_type', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('all_trunk', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('include', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('in_codes', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('in_code_deck', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('in_code_name_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('exclude', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('ex_code_deck', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ex_code_name_id', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('acd', sa.VARCHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('acd_value', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('asr', sa.VARCHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('asr_value', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('abr', sa.VARCHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('abr_value', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.VARCHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('pdd_value', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('profitability', sa.VARCHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('profitability_value', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('revenue', sa.VARCHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('revenue_value', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('min_call_attempt', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('step3_type', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('disable_scope', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_sent_to', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_sent_from', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_subject', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_enable_type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('auto_enable', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('execution_schedule', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('specific_minutes', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('daily_time', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('weekly_time', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('weekly_value', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('sample_size', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ex_codes', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('last_run_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('active', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_block', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('is_email', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('status', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('monitor_by', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('res_id', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='alert_rules_pkey'),
    sa.UniqueConstraint('rule_name', name='alert_rules_rule_name_key')
    )
    op.create_table('ftp_cdr_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('ftp_start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('ftp_end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ftp_ip', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('ftp_dir', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('alias', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('ftp_conf_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('cdr_start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('cdr_end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('pid', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='ftp_cdr_log_pkey')
    )
    op.create_table('transaction_fee_items',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('trans_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('transaction_fee_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('trans_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('use_fee', sa.REAL(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='transaction_fee_items_pkey')
    )
    op.create_table('host_info',
    sa.Column('time', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('res_id', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('ip_id', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('acd', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('asr', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ca', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('call_count', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('direction', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('call_count_asr', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('res_id', 'ip_id', 'time', name='host_info_pkey')
    )
    op.create_table('carrier',
    sa.Column('carrier_id', sa.INTEGER(), nullable=False),
    sa.Column('carrier_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('is_prepay', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('payment_term', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('credit_limit', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('enable_auto_invoice', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('enable_low_balance', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('invoice_format', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('company_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('address', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('email', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('username', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('carrier_id', name='carrier_pkey')
    )
    op.create_table('import_rate_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('import_file', sa.VARCHAR(length=300), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('cli_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dtmf', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('g729', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('prefix', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('order_type', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('error_file', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('duplicate_type', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('code_deck_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='import_rate_log_pkey')
    )
    op.create_table('route_strategy',
    sa.Column('route_strategy_id', sa.INTEGER(), server_default=sa.text("nextval('route_strategy_route_strategy_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=256), autoincrement=False, nullable=False),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('is_virtual', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('route_strategy_id', name='route_strategy_pkey'),
    sa.UniqueConstraint('name', name='route_strategy_name_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('orig_log',
    sa.Column('log_id', sa.INTEGER(), nullable=False),
    sa.Column('update_on', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('module', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('type', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('detail', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('log_id', name='orig_log_pkey')
    )
    op.create_table('authorization_logs',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('direction', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auth_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('error_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('request_ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('request_port', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('username', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('authname', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('sip_callid', sa.VARCHAR(length=128), autoincrement=False, nullable=True),
    sa.Column('time', sa.BIGINT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='authorization_logs_pkey')
    )
    op.create_table('resource_lrn_action',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('direction', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('action', sa.SMALLINT(), autoincrement=False, nullable=False),
    sa.Column('digits', sa.VARCHAR(length=10), autoincrement=False, nullable=False),
    sa.Column('dnis', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=True),
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('id', name='resource_lrn_action_pkey')
    )
    op.create_table('resource_record',
    sa.Column('resource_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ingress', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('egress', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('active', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('rfc_2833', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('t38', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('alias', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('res_strategy', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('cps_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('capacity', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lnp', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('lrn_block', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('tdm', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('transnexus', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('route_strategy_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('media_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pass_through', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profit_margin', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('enough_balance', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('egress_bill_after_action', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('proto', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_only', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('ring_timeout', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ignore_ring', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('ignore_early_media', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('disable_by_alert', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('priority', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('last_priority', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('wait_ringtime180', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('profit_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lnp_dipping', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('lnp_dipping_rate', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('cli_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('auth_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('delay_bye_second', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('delay_bye_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('max_duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('marketplace', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rating_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('billing_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('trunk_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('switch_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('transaction_fee_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('service_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('product_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('paid', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('oli', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('pci', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('priv', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('div', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('trunk_type2', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('account_id', sa.CHAR(length=32), autoincrement=False, nullable=True),
    sa.Column('billing_method', sa.SMALLINT(), autoincrement=False, nullable=True),
    sa.Column('amount_per_port', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('billing_rule', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ignore_early_nosdp', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('media_timeout', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('private', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('bill_by', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_profile', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('us_route', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intl_route', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('canada_route', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_decimal', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_rounding', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('us_other', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('canada_other', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('redirect', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_prefix', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('pass_response_code', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_del', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dtmf_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dtmf_detect', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid_screen', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid_party', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('display_name', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid_id_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rpid_privacy', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('counter_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('block_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('re_invite', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('re_invite_interval', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('info', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rfc2833', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inband', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dummy_trunk', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('random_table_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_virtual', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('rfc_r833_payload', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_template_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('rate_use_rpid', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('resource_block_group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('block_404_number_time', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('enfource_cid', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False)
    )
    op.create_table('code_deck',
    sa.Column('code_deck_id', sa.INTEGER(), server_default=sa.text("nextval('code_deck_code_deck_id_seq'::regclass)"), nullable=False),
    sa.Column('name', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('update_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('code_deck_id', name='code_deck_pkey'),
    sa.UniqueConstraint('client_id', name='code_deck_client_id_key'),
    sa.UniqueConstraint('name', name='code_deck_name_key'),
    postgresql_ignore_search_path=False
    )
    op.create_table('agent',
    sa.Column('agent_id', sa.INTEGER(), nullable=False),
    sa.Column('agent_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('email', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('commission', sa.NUMERIC(precision=5, scale=2), autoincrement=False, nullable=True),
    sa.Column('method_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('frequency_type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('status', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_role_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('update_on', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('update_by', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('edit_permission', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('agent_id', name='agent_pkey')
    )
    op.create_table('spam_traffic_ip_record',
    sa.Column('ip', sa.VARCHAR(length=30), autoincrement=False, nullable=True),
    sa.Column('brief', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='spam_traffic_ip_record_pkey')
    )
    op.create_table('invoice',
    sa.Column('invoice_id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_number', sa.VARCHAR(length=20), autoincrement=False, nullable=False),
    sa.Column('state', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.Column('invoice_start', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
    sa.Column('invoice_end', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
    sa.Column('total_amount', sa.NUMERIC(precision=30, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('paid', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('due_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('pay_amount', sa.NUMERIC(precision=30, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('current_balance', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=False),
    sa.Column('total_minutes', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('disputed', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('send_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('buy_total', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('sell_total', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('buy_minutes', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('sell_minutes', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('buy_service_charge', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('sell_service_charge', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('link_cdr', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('credit_amount', sa.NUMERIC(precision=30, scale=5), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('pdf_path', sa.VARCHAR(length=300), autoincrement=False, nullable=True),
    sa.Column('cdr_path', sa.VARCHAR(length=300), autoincrement=False, nullable=True),
    sa.Column('lrn_numbers', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('lrn_rate', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('lrn_cost', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('disputed_amount', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('credit_note', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('invoice_zone', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('reconcile_file_path', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('reconcile_state', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('output_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('include_detail', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('generate_start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('generate_copy_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('generate_stats_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('generate_end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('invoice_jurisdictional_detail', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
    sa.Column('previous_balance', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('payment_credit', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('finance_charge', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('decurring_charge', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('non_recurring_charge', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('tax', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('decimal_place', sa.INTEGER(), server_default=sa.text('5'), autoincrement=False, nullable=True),
    sa.Column('rate_value', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('scc_cost', sa.NUMERIC(precision=30, scale=5), autoincrement=False, nullable=True),
    sa.Column('is_invoice_account_summary', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('new_balance', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('is_show_daily_usage', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('scc_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('scc_per', sa.REAL(), autoincrement=False, nullable=True),
    sa.Column('invoice_include_payment', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('scc_sec', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('is_short_duration_call_surcharge_detail', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('usage_detail_fields', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('ingress_cdr_file', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('egress_cdr_file', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('current_charge', sa.NUMERIC(precision=30, scale=10), autoincrement=False, nullable=True),
    sa.Column('invoice_log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_use_balance_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('invoice_balance_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('total_calls', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('decimals_num', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('please_pay', sa.NUMERIC(precision=20, scale=5), autoincrement=False, nullable=True),
    sa.Column('credit_remaining', sa.NUMERIC(precision=20, scale=5), autoincrement=False, nullable=True),
    sa.Column('unlimited_credit_unlimited', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('payment_term', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('is_show_total_trunk', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_detail_trunk', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_code_100', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_code_name', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_country', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_show_by_date', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('is_send_as_link', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='fkey_invoice_client_client_id', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('invoice_id', name='invoice_pkey'),
    sa.UniqueConstraint('invoice_number', name='invoice_invoice_number_key')
    )
    op.create_table('jurisdiction_prefix_record',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('alias', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('prefix', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_country_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('jurisdiction_country_name', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ocn', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('lata', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('block_id', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('effective_date', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('time', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('flag', sa.CHAR(length=1), autoincrement=False, nullable=True),
    sa.Column('record_id', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint('record_id', name='jurisdiction_prefix_record_pkey')
    )
    op.create_table('resource_block',
    sa.Column('ingress_res_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('engress_res_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('digit', sa.NullType(), server_default=sa.text("''::prefix_range"), autoincrement=False, nullable=True),
    sa.Column('res_block_id', sa.INTEGER(), nullable=False),
    sa.Column('time_profile_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ingress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('disable_by_alert', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('ani_prefix', sa.NullType(), autoincrement=False, nullable=True),
    sa.Column('ani_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_length', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_method', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('dnis_method', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_empty', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=True),
    sa.Column('action_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('block_log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('loop_block_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ticket_log_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('code_name', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('country', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('create_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.Column('update_by', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('dialer_detection_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ani_max_length', sa.INTEGER(), server_default=sa.text('32'), autoincrement=False, nullable=True),
    sa.Column('dnis_max_length', sa.INTEGER(), server_default=sa.text('32'), autoincrement=False, nullable=True),
    sa.Column('ingress_group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('egress_group_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('full_match', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('unblock_at', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('block_at', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('unblock_after', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['engress_res_id'], ['resource.resource_id'], name='fkey_resource_block_resource_engress_res_id', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['ingress_res_id'], ['resource.resource_id'], name='fkey_resource_block_resource_ingress_res_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['time_profile_id'], ['time_profile.time_profile_id'], name='fkey_resource_block_time_profile_time_profile_id', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('res_block_id', name='resource_block_pkey')
    )
    op.create_table('digit_translation',
    sa.Column('translation_id', sa.INTEGER(), nullable=False),
    sa.Column('translation_name', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('translation', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('translation_id', name='digit_translation_pkey'),
    sa.UniqueConstraint('translation_name', name='digit_translation_translation_name_key')
    )
    # ### end Alembic commands ###
