"""invoice company_type drop orig

Revision ID: 4afb93d2da82
Revises: a65b67c0e8c9
Create Date: 2020-12-31 11:20:44.902373

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '4afb93d2da82'
down_revision = 'a65b67c0e8c9'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('orig_invoice_history')
    op.drop_table('orig_invoice')
    op.add_column('invoice', sa.Column('company_type', sa.SmallInteger(), server_default='1', nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('invoice', 'company_type')
    op.create_table('orig_invoice',
    sa.Column('invoice_id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_number', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('state', sa.INTEGER(), server_default=sa.text('1'), autoincrement=False, nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_time', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('invoice_start', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('invoice_end', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('total_amount', sa.NUMERIC(precision=15, scale=2), autoincrement=False, nullable=False),
    sa.Column('pdf_path', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('create_type', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('due_date', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.Column('show_account_summary', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('show_all_area_codes_summary', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('show_authorization_code_summary', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('show_origination_lata_summary', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('show_transaction_summary_analysis', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('cdr_file', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='orig_invoice_client_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('invoice_id', name='orig_invoice_pkey')
    )
    op.create_table('orig_invoice_history',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('last_invoice_for', sa.DATE(), server_default=sa.text("('now'::text)::date"), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='orig_invoice_history_pkey')
    )
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))