"""delete unique from ip

Revision ID: 827fd5abc017
Revises: 6ce5566376fc
Create Date: 2017-10-27 16:47:22.279749

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '827fd5abc017'
down_revision = '6ce5566376fc'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute("delete from balance_history_actual where ctid not in (select max(ctid) from balance_history_actual s  group by s.date,s.client_id)")
    
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    op.drop_constraint('resource_ip_ip_key', 'resource_ip', type_='unique')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_unique_constraint('resource_ip_ip_key', 'resource_ip', ['ip'])
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date'], unique=False)
    # ### end Alembic commands ###
