"""DID repository redesign

Revision ID: 872ed0d086b7
Revises: 6121e053e080
Create Date: 2023-06-14 19:03:10.621357

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '872ed0d086b7'
down_revision = '6121e053e080'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_assignments',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('did', sa.String(length=50), nullable=False),
    sa.Column('vendor_id', sa.Integer(), nullable=False),
    sa.Column('vendor_billing_plan_id', sa.Integer(), nullable=False),
    sa.Column('client_id', sa.Integer(), nullable=False),
    sa.Column('client_billing_plan_id', sa.Integer(), nullable=False),
    sa.Column('fallback_id', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('created_by', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_did_assignments_did'), 'did_assignments', ['did'], unique=True)
    op.create_table('did_assignments_log',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('did', sa.String(length=50), nullable=True),
    sa.Column('vendor_id', sa.Integer(), nullable=True),
    sa.Column('vendor_billing_plan_id', sa.Integer(), nullable=True),
    sa.Column('client_id', sa.Integer(), nullable=True),
    sa.Column('client_billing_plan_id', sa.Integer(), nullable=True),
    sa.Column('fallback_id', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.Date(), nullable=False),
    sa.Column('created_by', sa.Integer(), nullable=True),
    sa.Column('deleted_at', sa.Date(), nullable=True),
    sa.Column('deleted_by', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id', 'created_at'),
    postgresql_partition_by='RANGE (created_at)'                
    )
    op.create_index(op.f('ix_did_assignments_log_created_at'), 'did_assignments_log', ['created_at'], unique=False)
    op.create_table('did_repository',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('did', sa.String(length=50), nullable=False),
    sa.Column('vendor_id', sa.Integer(), nullable=False),
    sa.Column('vendor_billing_plan_id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('created_by', sa.Integer(), nullable=True),
    sa.Column('is_available', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_did_repository_did'), 'did_repository', ['did'], unique=True)
    op.create_table('did_repository_log',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('did', sa.String(length=50), nullable=True),
    sa.Column('vendor_id', sa.Integer(), nullable=True),
    sa.Column('vendor_billing_plan_id', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.Date(), nullable=False),
    sa.Column('created_by', sa.Integer(), nullable=True),
    sa.Column('deleted_at', sa.Date(), nullable=True),
    sa.Column('deleted_by', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id', 'created_at'),
    postgresql_partition_by='RANGE (created_at)'
    )
    op.create_index(op.f('ix_did_repository_log_created_at'), 'did_repository_log', ['created_at'], unique=False)
    op.add_column('did_billing_plan', sa.Column('client_id', sa.Integer()))
    op.create_foreign_key(None, 'did_billing_plan', 'client', ['client_id'], ['client_id'], ondelete='CASCADE')
    op.drop_column('did_transaction', 'did_billing_id')
    up_rec('did_billing_plan')
    connection = op.get_bind()
    connection.execute(
        """
        COMMENT ON COLUMN did_repository.created_by IS '0 - UI; 1 - API; 2 - Mass Import';
        COMMENT ON COLUMN did_repository.is_available IS 'Is visible for clients';
        COMMENT ON COLUMN did_assignments.created_by IS '0 - UI; 1 - API; 2 - Mass Import';
        COMMENT ON COLUMN did_number_upload_task.repeated_action IS
        '0 - Skip duplicates; 1 - Overwrite duplicates';
        COMMENT ON COLUMN did_number_upload_task.status IS
        '0 - Init; 1 - Processing; 2 - Uploading; 3 - Finished; 4 - Error';
        COMMENT ON COLUMN did_number_upload_task.op_method IS
        '0 - Insert; 1 - Release; 2 - Delete; 3 - Assign';
        """)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('did_transaction', sa.Column('did_billing_id', sa.Integer(), nullable=False))
    op.create_foreign_key(None, 'did_transaction', 'did_billing_rel', ['did_billing_id'], ['id'], ondelete='CASCADE')
    op.create_unique_constraint('unique_did', 'did_billing_rel', ['did'])
    op.drop_constraint(None, 'did_billing_plan', type_='foreignkey')
    op.drop_column('did_billing_plan', 'client_id')
    op.drop_index(op.f('ix_did_repository_log_created_at'), table_name='did_repository_log')
    op.drop_table('did_repository_log')
    op.drop_index(op.f('ix_did_repository_did'), table_name='did_repository')
    op.drop_table('did_repository')
    op.drop_index(op.f('ix_did_assignments_log_created_at'), table_name='did_assignments_log')
    op.drop_table('did_assignments_log')
    op.drop_index(op.f('ix_did_assignments_did'), table_name='did_assignments')
    op.drop_table('did_assignments')
    up_rec('did_billing_plan')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE if not exists {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))
