"""rate uniq

Revision ID: 8f9d9e2d3ccf
Revises: 6232cff0e810
Create Date: 2018-02-07 21:06:16.502581

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '8f9d9e2d3ccf'
down_revision = '6232cff0e810'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index('class4_idx_rate_table_id_code', 'rate', ['code', 'rate_table_id'], unique=False, postgresql_using='gist', postgresql_ops={'code': 'gist_prefix_range_ops'})
    op.create_index(op.f('ix_rate_code'), 'rate', ['code'], unique=False)
    op.create_unique_constraint('rate_rate_table_id_code_effective_date_key', 'rate', ['rate_table_id', 'code', 'effective_date'])
    op.drop_constraint('rate_rate_table_id_code_effective_date_end_date_key', 'rate', type_='unique')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_unique_constraint('rate_rate_table_id_code_effective_date_end_date_key', 'rate', ['rate_table_id', 'code', 'effective_date', 'end_date'])
    op.drop_constraint('rate_rate_table_id_code_effective_date_key', 'rate', type_='unique')
    op.drop_index(op.f('ix_rate_code'), table_name='rate')
    op.drop_index('class4_idx_rate_table_id_code', table_name='rate')
    # ### end Alembic commands ###
