"""c4_shaken_status

Revision ID: 93da483c695b
Revises: 2717825cc406
Create Date: 2020-11-12 17:10:14.044875

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '93da483c695b'
down_revision = '2717825cc406'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('c4_shaken_status',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.Text(), nullable=True),
    sa.Column('upd_time', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('is_primary', sa.Boolean(), server_default='false', nullable=False),
    sa.Column('is_online', sa.Boolean(), server_default='false', nullable=False),
    sa.Column('error', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('code_deck_import_task',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('operator_user', sa.String(length=40), nullable=True),
    sa.Column('orig_import_filename', sa.String(length=256), nullable=True),
    sa.Column('format_import_filename', sa.String(length=256), nullable=True),
    sa.Column('import_log_filename', sa.String(length=256), nullable=True),
    sa.Column('redup_in_code_deck_rable_action', sa.SmallInteger(), server_default='0', nullable=False),
    sa.Column('redup_in_file_action', sa.SmallInteger(), server_default='0', nullable=False),
    sa.Column('delete_all', sa.Boolean(), server_default='false', nullable=False),
    sa.Column('code_deck_id', sa.Integer(), nullable=False),
    sa.Column('status', sa.SmallInteger(), server_default='0', nullable=False),
    sa.Column('progress', sa.String(length=1024), nullable=True),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.add_column('did_number_upload_task', sa.Column('enable_for_clients', sa.Boolean(), server_default='false', nullable=True))
    op.add_column('block_number_import_task',
                  sa.Column('op_method', sa.SmallInteger(), server_default='0', nullable=False))
    # ### end Alembic commands ###
    up_rec('c4_shaken_status')
    connection = op.get_bind()

    connection.execute("""
    create SEQUENCE  IF NOT EXISTS did_number_upload_task_id_seq;
    alter table did_number_upload_task alter COLUMN id SET DEFAULT nextval('did_number_upload_task_id_seq'::regclass);
    """)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('block_number_import_task', 'op_method')
    op.drop_column('did_number_upload_task', 'enable_for_clients')
    op.drop_table('code_deck_import_task')
    op.drop_table('c4_shaken_status')
    # ### end Alembic commands ###
    connection = op.get_bind()
    connection.execute("""
        alter table did_number_upload_task alter COLUMN id SET DEFAULT NULL;
        drop SEQUENCE  IF EXISTS did_number_upload_task_id_seq;
        
        """)
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))