"""role menus for UI

Revision ID: d8adba8b5066
Revises: d860ebaae08a
Create Date: 2022-04-22 12:35:43.894802

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'd8adba8b5066'
down_revision = 'd860ebaae08a'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('sys_main_menu',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('display_name', sa.String(length=50), nullable=True),
    sa.Column('ordering', sa.Integer(), nullable=True),
    sa.Column('enabled', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_sys_main_menu_display_name'), 'sys_main_menu', ['display_name'], unique=True)
    op.create_table('sys_submenu',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('display_name', sa.String(length=50), nullable=True),
    sa.Column('ordering', sa.Integer(), nullable=True),
    sa.Column('is_readable', sa.Boolean(), nullable=True),
    sa.Column('is_editable', sa.Boolean(), nullable=True),
    sa.Column('is_executable', sa.Boolean(), nullable=True),
    sa.Column('enabled', sa.Boolean(), nullable=True),
    sa.Column('main_menu_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['main_menu_id'], ['sys_main_menu.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_sys_submenu_display_name'), 'sys_submenu', ['display_name'], unique=True)
    op.create_index(op.f('ix_sys_submenu_main_menu_id'), 'sys_submenu', ['main_menu_id'], unique=False)
    op.create_table('role_submenu_rel',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('role_id', sa.Integer(), nullable=False),
    sa.Column('submenu_id', sa.Integer(), nullable=False),
    sa.Column('editable', sa.Boolean(), nullable=False),
    sa.Column('readable', sa.Boolean(), nullable=False),
    sa.Column('executable', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['role_id'], ['role.role_id'], ),
    sa.ForeignKeyConstraint(['submenu_id'], ['sys_submenu.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('role_id', 'submenu_id')
    )
    op.create_index(op.f('ix_role_submenu_rel_role_id'), 'role_submenu_rel', ['role_id'], unique=False)
    op.create_index(op.f('ix_role_submenu_rel_submenu_id'), 'role_submenu_rel', ['submenu_id'], unique=False)
    op.drop_column('system_function', 'web_page_name')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('system_function', sa.Column('web_page_name', sa.VARCHAR(length=50), autoincrement=False, nullable=True))
    op.drop_index(op.f('ix_role_submenu_rel_submenu_id'), table_name='role_submenu_rel')
    op.drop_index(op.f('ix_role_submenu_rel_role_id'), table_name='role_submenu_rel')
    op.drop_table('role_submenu_rel')
    op.drop_index(op.f('ix_sys_submenu_main_menu_id'), table_name='sys_submenu')
    op.drop_index(op.f('ix_sys_submenu_display_name'), table_name='sys_submenu')
    op.drop_table('sys_submenu')
    op.drop_index(op.f('ix_sys_main_menu_display_name'), table_name='sys_main_menu')
    op.drop_table('sys_main_menu')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))