"""UsersLimit foreign

Revision ID: ddbda7e079e7
Revises: 7687474c703c
Create Date: 2017-10-24 16:56:38.632691

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'ddbda7e079e7'
down_revision = '7687474c703c'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    op.drop_constraint('users_limit_user_id_fkey', 'users_limit', type_='foreignkey')
    op.drop_constraint('users_limit_client_id_fkey', 'users_limit', type_='foreignkey')
    op.create_foreign_key(None, 'users_limit', 'users', ['user_id'], ['user_id'], ondelete='CASCADE')
    op.create_foreign_key(None, 'users_limit', 'client', ['client_id'], ['client_id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'users_limit', type_='foreignkey')
    op.drop_constraint(None, 'users_limit', type_='foreignkey')
    op.create_foreign_key('users_limit_client_id_fkey', 'users_limit', 'client', ['client_id'], ['client_id'])
    op.create_foreign_key('users_limit_user_id_fkey', 'users_limit', 'users', ['user_id'], ['user_id'])
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date'], unique=False)
    # ### end Alembic commands ###
