"""send_rate_direct

Revision ID: e15e7cf10cdd
Revises: 6004c46b593b
Create Date: 2017-12-11 02:07:56.622080

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'e15e7cf10cdd'
down_revision = '6004c46b593b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('send_rate_direct',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('subject', sa.String(length=200), nullable=True),
    sa.Column('content', sa.Text(), nullable=True),
    sa.Column('download_method', sa.SmallInteger(), nullable=True),
    sa.Column('header', sa.Text(), nullable=True),
    sa.Column('sender_id', sa.Integer(), nullable=True),
    sa.Column('mail_cc', sa.String(length=200), nullable=True),
    sa.Column('to_mail', sa.String(length=200), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['rate_send_log.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['sender_id'], ['mail_sender.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id')
    )
    op.alter_column('rate_send_log', 'email_template_id',
               existing_type=sa.INTEGER(),
               nullable=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('rate_send_log', 'email_template_id',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.drop_table('send_rate_direct')
    # ### end Alembic commands ###
