"""manual_invoice_task

Revision ID: e7604eafaeee
Revises: c31341010733
Create Date: 2019-04-23 22:20:25.006668

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'e7604eafaeee'
down_revision = 'c31341010733'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_invoice_number_fee_detail',
    sa.Column('invoice_number', sa.Integer(), nullable=False),
    sa.Column('did_number', sa.String(length=64), nullable=False),
    sa.Column('nrc', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('mrc', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False)
    )
    op.create_index(op.f('ix_did_invoice_number_fee_detail_invoice_number'), 'did_invoice_number_fee_detail', ['invoice_number'], unique=False)
    op.create_table('did_setup_fee',
    sa.Column('invoice_number', sa.Integer(), nullable=False),
    sa.Column('client_id', sa.Integer(), nullable=False),
    sa.Column('did_number', sa.String(length=64), nullable=False),
    sa.Column('fee', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False)
    )
    op.create_index(op.f('ix_did_setup_fee_client_id'), 'did_setup_fee', ['client_id'], unique=False)
    op.create_index(op.f('ix_did_setup_fee_did_number'), 'did_setup_fee', ['did_number'], unique=False)
    op.create_index(op.f('ix_did_setup_fee_invoice_number'), 'did_setup_fee', ['invoice_number'], unique=False)
    op.create_table('dnl_invoice_history',
    sa.Column('client_id', sa.Integer(), nullable=False),
    sa.Column('last_succ_invoice_number', sa.Integer(), nullable=True),
    sa.Column('last_succ_invoice_end_time', sa.Numeric(), nullable=True),
    sa.Column('invoice_generation_time', sa.DateTime(), nullable=True),
    sa.Column('invoice_end_time', sa.Numeric(), nullable=True),
    sa.Column('status', sa.SmallInteger(), server_default=sa.text('0'), nullable=False),
    sa.Column('result', sa.String(length=256), nullable=True)
    )
    op.create_index(op.f('ix_dnl_invoice_history_client_id'), 'dnl_invoice_history', ['client_id'], unique=False)
    op.create_table('invoice_code_name_detail',
    sa.Column('invoice_number', sa.Integer(), nullable=False),
    sa.Column('code_name', sa.String(length=256), nullable=True),
    sa.Column('rate', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('total_calls', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.Column('total_minutes', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('total_amount', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('inter_calls', sa.Integer(), nullable=True),
    sa.Column('intra_calls', sa.Integer(), nullable=True),
    sa.Column('ij_calls', sa.Integer(), nullable=True),
    sa.Column('inter_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('intra_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('ij_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('inter_amount', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('intra_amount', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('ij_amount', sa.Numeric(precision=32, scale=6), nullable=True)
    )
    op.create_index(op.f('ix_invoice_code_name_detail_invoice_number'), 'invoice_code_name_detail', ['invoice_number'], unique=False)
    op.create_table('invoice_country_detail',
    sa.Column('invoice_number', sa.Integer(), nullable=False),
    sa.Column('country', sa.String(length=256), nullable=True),
    sa.Column('total_calls', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.Column('total_minutes', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('total_amount', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False)
    )
    op.create_index(op.f('ix_invoice_country_detail_invoice_number'), 'invoice_country_detail', ['invoice_number'], unique=False)
    op.create_table('invoice_daily_detail',
    sa.Column('invoice_number', sa.Integer(), nullable=False),
    sa.Column('report_date', sa.Date(), nullable=True),
    sa.Column('total_calls', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.Column('total_minutes', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('total_amount', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('inter_calls', sa.Integer(), nullable=True),
    sa.Column('intra_calls', sa.Integer(), nullable=True),
    sa.Column('ij_calls', sa.Integer(), nullable=True),
    sa.Column('inter_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('intra_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('ij_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('inter_amount', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('intra_amount', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('ij_amount', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('did_number', sa.String(length=64), nullable=True)
    )
    op.create_index(op.f('ix_invoice_daily_detail_invoice_number'), 'invoice_daily_detail', ['invoice_number'], unique=False)
    op.create_table('invoice_summary',
    sa.Column('invoice_number', sa.Integer(), nullable=False),
    sa.Column('client_id', sa.Integer(), nullable=False),
    sa.Column('invoice_generation_time', sa.DateTime(), nullable=True),
    sa.Column('invoice_start_time', sa.DateTime(), nullable=True),
    sa.Column('invoice_end_time', sa.DateTime(), nullable=True),
    sa.Column('payment_dur_date', sa.Date(), nullable=True),
    sa.Column('invoice_zone', sa.String(length=20), nullable=True),
    sa.Column('payment_id', sa.Integer(), nullable=True),
    sa.Column('current_balance', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('previous_balance', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('payments_and_credits', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('balance_forward', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('long_distance_charges', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('taxes', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('scc_amount', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('current_charges', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('total_calls', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.Column('total_minutes', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('total_amount', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('unlimited_credit', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_tax', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_scc_charges', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_daily_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_country_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_code_name_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_trunk_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_trunk_prefix_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('invoice_type', sa.SmallInteger(), server_default=sa.text('0'), nullable=False),
    sa.Column('did_mrc', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('did_nrc', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.PrimaryKeyConstraint('invoice_number')
    )
    op.create_index(op.f('ix_invoice_summary_client_id'), 'invoice_summary', ['client_id'], unique=False)
    op.create_index(op.f('ix_invoice_summary_invoice_generation_time'), 'invoice_summary', ['invoice_generation_time'], unique=False)
    op.create_table('invoice_trunk_detail',
    sa.Column('invoice_number', sa.Integer(), nullable=False,primary_key=True),
    sa.Column('trunk_id', sa.Integer(), nullable=False),
    sa.Column('total_calls', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.Column('total_minutes', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('total_amount', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('inter_calls', sa.Integer(), nullable=True),
    sa.Column('intra_calls', sa.Integer(), nullable=True),
    sa.Column('ij_calls', sa.Integer(), nullable=True),
    sa.Column('inter_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('intra_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('ij_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('inter_amount', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('intra_amount', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('ij_amount', sa.Numeric(precision=32, scale=6), nullable=True)
    )
    op.create_index(op.f('ix_invoice_trunk_detail_invoice_number'), 'invoice_trunk_detail', ['invoice_number'], unique=False)
    op.create_table('invoice_trunk_prefix_detail',
    sa.Column('invoice_number', sa.Integer(), nullable=False),
    sa.Column('trunk_id', sa.Integer(), nullable=False),
    sa.Column('prefix', sa.String(length=100), nullable=True),
    sa.Column('total_calls', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.Column('total_minutes', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('total_amount', sa.Numeric(precision=32, scale=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('inter_calls', sa.Integer(), nullable=True),
    sa.Column('intra_calls', sa.Integer(), nullable=True),
    sa.Column('ij_calls', sa.Integer(), nullable=True),
    sa.Column('inter_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('intra_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('ij_minutes', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('inter_amount', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('intra_amount', sa.Numeric(precision=32, scale=6), nullable=True),
    sa.Column('ij_amount', sa.Numeric(precision=32, scale=6), nullable=True)
    )
    op.create_index(op.f('ix_invoice_trunk_prefix_detail_invoice_number'), 'invoice_trunk_prefix_detail', ['invoice_number'], unique=False)
    op.create_table('manual_invoice_task',
    sa.Column('id', sa.Integer(), nullable=False,primary_key=True),
    sa.Column('operator_user', sa.String(length=40), nullable=True),
    sa.Column('client_id', sa.Integer(), nullable=False),
    sa.Column('start_date', sa.Date(), nullable=True),
    sa.Column('end_date', sa.Date(), nullable=True),
    sa.Column('timezone', sa.String(length=20), nullable=True),
    sa.Column('include_tax', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_scc_charges', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_daily_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_country_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_code_name_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_trunk_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_trunk_prefix_details', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('status', sa.SmallInteger(), server_default=sa.text('0'), nullable=False),
    sa.Column('invoice_number', sa.Integer(), nullable=True),
    sa.Column('progress', sa.String(length=1024), nullable=True),
    sa.Column('proc_start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('proc_end_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('manual_invoice_task')
    op.drop_index(op.f('ix_invoice_trunk_prefix_detail_invoice_number'), table_name='invoice_trunk_prefix_detail')
    op.drop_table('invoice_trunk_prefix_detail')
    op.drop_index(op.f('ix_invoice_trunk_detail_invoice_number'), table_name='invoice_trunk_detail')
    op.drop_table('invoice_trunk_detail')
    op.drop_index(op.f('ix_invoice_summary_invoice_generation_time'), table_name='invoice_summary')
    op.drop_index(op.f('ix_invoice_summary_client_id'), table_name='invoice_summary')
    op.drop_table('invoice_summary')
    op.drop_index(op.f('ix_invoice_daily_detail_invoice_number'), table_name='invoice_daily_detail')
    op.drop_table('invoice_daily_detail')
    op.drop_index(op.f('ix_invoice_country_detail_invoice_number'), table_name='invoice_country_detail')
    op.drop_table('invoice_country_detail')
    op.drop_index(op.f('ix_invoice_code_name_detail_invoice_number'), table_name='invoice_code_name_detail')
    op.drop_table('invoice_code_name_detail')
    op.drop_index(op.f('ix_dnl_invoice_history_client_id'), table_name='dnl_invoice_history')
    op.drop_table('dnl_invoice_history')
    op.drop_index(op.f('ix_did_setup_fee_invoice_number'), table_name='did_setup_fee')
    op.drop_index(op.f('ix_did_setup_fee_did_number'), table_name='did_setup_fee')
    op.drop_index(op.f('ix_did_setup_fee_client_id'), table_name='did_setup_fee')
    op.drop_table('did_setup_fee')
    op.drop_index(op.f('ix_did_invoice_number_fee_detail_invoice_number'), table_name='did_invoice_number_fee_detail')
    op.drop_table('did_invoice_number_fee_detail')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))